﻿contentPages = [{"id":"8850723979","fileName":"885072397928073923211.html","title":"Introduction","level":1,"position":1,"hasContent":false,"hierarchy":[],"content":"  In this section, you can find the basic information about the product and also the formatting conventions used in the topics. "},{"id":"25182308363","fileName":"25182308363.html","title":"General Description","level":2,"position":2,"hasContent":true,"hierarchy":["Introduction"],"content":" The Power Focus 8 from Atlas Copco takes productivity and connectivity to entirely new levels. It connects a wide range of Atlas Copco tools, giving you one controller platform for all your assembly needs. Using Virtual Stations, multiple tools can be operated from one single controller with different tightening settings. The perfect solution for your smart integrated assembly operation."},{"id":"78927883","fileName":"78927883.html","title":"Conventions","level":2,"position":3,"hasContent":true,"hierarchy":["Introduction"],"content":" To enhance user understanding, certain formatting conventions are used throughout this document. The formatting conventions used are listed below.  User Guide Conventions     Element  Notation  Description  Output    General emphasis  In the Programworkspace.  To make certain text elements stand out, or to highlight.  Text in Bold   Graphical User Interface (GUI) items  Select the Functionbutton.  Any reference to items found on screen in the GUI (for example, command buttons, icon names and field names).  Text in Bold   Graphical User Interface (GUI) Path >  Generally, on the top of the GUI.  Navigation aid which keeps track of the location in the GUI.  For example: Controller > Program > Edit   User input  Enter a Descriptionfor the program.  Any text input by the user.  Text in Bold   File names  Enter a File Namefor the export.  Files either exported from, or imported into the system.  Text in Bold Italic   Variable and parameter names  Enter a Namefor the export.  Variable and parameter names (not values).  Text in Italic   Variable and parameter values  Enter a VALUEfor the export.  Variable and parameter values.  Text in BOLD CAPS   System output   Client.Domain.Models.ExportImportConfiguration  Any text output by the system.  Text in Monospace   External links         Links to external sites that have information connected to the document or subject content. These could include:   Technical Product Data  Dimensional Drawings  Accessories  Product Specific Information  Selectable text to external sites   Internal documentation links      Relevant Information- links to information which is directly related to the current topic and needs to be considered for certain configurations that are made.   In this Section- links to all the topics within the section, which can be useful when understanding a feature, or configuration. If available, these links will be presented below the text.  Selectable text to internal content "},{"id":"8955112331","fileName":"895511233128073985675.html","title":"Liabilities and Warnings","level":2,"position":4,"hasContent":false,"hierarchy":["Introduction"],"content":""},{"id":"7043427595","fileName":"7043427595.html","title":"General Data Protection Regulation (GDPR)","level":3,"position":5,"hasContent":true,"hierarchy":["Introduction","Liabilities and Warnings"],"content":" This product offers the possibility to process personal identifiable information such as system user name, role and IP-address. The purpose of this processing capability could be to enhance quality control through traceability and proper access management. If you decide to process personal data you need to be aware of and comply with relevant personal data protection rules, including, in the EU the GDPR as well as other applicable laws, directives and regulations. Atlas Copco can in no way be held liable for any use made by you of the product."},{"id":"28533038091","fileName":"28533038091.html","title":"Radio Equipment Directive (EU) 2014\/53 (RED) and Commission Delegated Regulation (EU 2022\/30) supplementing RED","level":3,"position":6,"hasContent":true,"hierarchy":["Introduction","Liabilities and Warnings"],"content":"   Radio equipment that communicates via internet and is placed on the EU and the EEA market on or after 1 August 2025 must comply with cybersecurity requirements in RED.  Software versions with earlier release number than 3.14.8does not comply with the cybersecurity requirements in RED.  It is prohibitedto install non-compliant software in products placed on the market on or after 1 August 2025for the usage in the EU and EEA.   Check serial number to identify the correct date for when the product is placed on the market.  Downgrading to using a software version with an earlier release number than 3.14.8cancels regulatory compliance within the EU and the EEA and exposes the product to cybersecurity risks.  Use of a software version with an earlier release number than 3.14.8is on the sole risk and liability of the customer. Atlas Copco assumes no liability whatsoever for any of the potential implications arising from the use of a software version with an earlier release number."},{"id":"2505623179","fileName":"2505623179.html","title":"Liability","level":3,"position":7,"hasContent":true,"hierarchy":["Introduction","Liabilities and Warnings"],"content":" Many events in the operating environment may affect the tightening process and shall require a validation of results. In compliance with applicable standards and\/or regulations, we hereby require you to check the installed torque and rotational direction after any event that can influence the tightening result. Examples of such events include but are not limited to:   initial installation of the tooling system  change of part batch, bolt, screw batch, tool, software, configuration or environment  change of air- or electrical connections  change in line ergonomics, process, quality procedures or practices  changing of operator  any other change that influences the result of the tightening process The check should:   Ensure that the joint conditions have not changed due to events of influence.  Be done after initial installation, maintenance or repair of the equipment.  Occur at least once per shift or at another suitable frequency."},{"id":"13413616779","fileName":"13413616779.html","title":"Warnings","level":3,"position":8,"hasContent":true,"hierarchy":["Introduction","Liabilities and Warnings"],"content":"  Changing parameters may lead to a decrease in tool performance and may also slow down the production.  Risk of Property Damage or Severe Injury  Ensure that you read, understand and follow all instructions before operating the tool. Failure to follow all the instructions may result in electric shock, fire, property damage and\/or severe bodily injury.   Read all Safety Information delivered together with the different parts of the system.  Read all Product Instructions for installation, operation and maintenance of the different parts of the system.  Read all locally legislated safety regulations regarding the system and parts thereof.  Save all Safety Information and instructions for future reference. "},{"id":"18869224715","fileName":"18869224715.html","title":"About the User Guide","level":2,"position":9,"hasContent":true,"hierarchy":["Introduction"],"content":" The User Guide describes how to set up and configure the POWER FOCUS 8. It is intended for anyone operating or servicing the POWER FOCUS 8."},{"id":"18582665867","fileName":"18582665867.html","title":"Revision History","level":2,"position":10,"hasContent":true,"hierarchy":["Introduction"],"content":"      Release Number  Revision Date  Revision Description     item   item   none   3.14  10\/2025    NEW Content  Radio Equipment Directive (EU) 2014\/53 (RED) and Commission Delegated Regulation (EU 2022\/30) supplementing RED  Working with Automation Rules  TTC - Tighten to Clutch  CRh - Clutch Rehit  Machine Capability Test Mode Active - 10148: Added an Input\/Output signal  Toggles Machine Capability Mode - 10152: Added an Input signal   UPDATED Content  Configuration of the Network: Added information on default ports and services  Event Codes  General Virtual Station: Added information on Maximum consecutive loosenings  Open End in Open Position - 89: Output signal enabled for Fieldbus  General Virtual Station  Connecting to web GUI via service Ethernet port  Multistep Programs  Adding a Multistep Program  Deleting a Multistep Program  Validate a Tool with a Tightening Program  Settings for a Multistep Program  Updating Controller Software through USB  Updating Controller Software through Web GUI  Web GUI  Configuration of the Extended Logging   3.13  09\/2024    NEW content  Source Tightening Properties  Unpair Bluetooth Connection  Configuration of HTTPS  Configuring HTTPS  Certificates   UPDATED content  Configuring a Source Tightening  Supported Tools  Calibrating the Tool  Configuring the Factory Ethernet Port  Configuring the Firewall  Configuring the ToolsNet Connection  Configuring the ToolsTalk Connection  EM Stop Connection Scenarios  Live Results  Event Codes  Step Monitors   3.11  02\/2024     UPDATED content  Multistep GUI  Event Codes updated.  NOK Results List updated.  \"StepSync\" replaced with \"controller\" or \"synchronized tightening\" in the user guide.  Configuration of the Tool LEDs updated.   3.10  06\/2023     NEW content  Configuring the Controller as a Wireless Access Point added to Configuration of the Network.  Troubleshooting Matrix added to Troubleshooting and Service    UPDATED content  Tool Diagnostics Diagnostic test added to Tool Diagnostics.  PrT - Prevailing Torque added in Configuration for FlexSystem and StepSync.  Exporting Logs from Connected Tools QST-M added.  Event Codes updated with battery status.  Configuring Protocols Window in a Virtual Station updated with communication timeout value.   3.9  01\/2023     NEW content  Configuration > Working with the Too Tab > Tool Diagnostics  Configuration > Working with the Tool Tab > Zero Position  Configuration > Working with the Settings Tab > Configuration of IxB Connect  Configuration > Working with the Configurations Tab >Tool Configuration > Configuration of the Dual Transducers    UPDATED content  Configuration > Working with the Controller Tab > Exporting Systems Logs and Information  Configuration > Working with the Controller Tab > Export\/Import > Exporting logs from Connected Tools  Configuration > Working with the Tightening Tab > Multistep Programs > Tightening Steps  Configuration > Working with the Tightening Tab > Multistep Programs > Step Monitors  Configuration > Working with the Configurations Tab > General Virtual Station  Configuration > Working with the Settings Tab > Configuration of the Network > Configuring the Firewall   3.8  06\/2022    NEW content:  Configuration > Working with the Controller Tab > Export\/Import > Exporting \"System logs and information\"   UPDATED content:  Configuration > Working with the Controller Tab > StepSync  Configuration > Working with the Controller Tab > StepSync > StepSync Tightenings  Configuration > Working with the Controller Tab > StepSync > StepSync Signals  Configuration > Working with the Tightening Tab > Multistep Programs (new filterable tables for tightening steps, step monitors and step restrictions).  Configuration > Working with the Tightening Tab > Multistep Programs (Creating Multistep Program inserted into Adding a Multistep Program)   3.7  01\/2022    NEW content:  Configurations Tab > Tool Configuration > Configuration of the Open End  Settings Tab > Configuration of the Server Connections > Configuring the Remote Logging Connection  Settings Tab > Configuration of the Extended Logging  Settings Tab > Configuration of the Extended Logging > Configuring the Log Groups   UPDATED content:  Multistep Programs > Tightening Steps (TC - Torque Calibration)  Multistep Programs > Step Monitors (C - Current, TC - Torque Calibration)  Multistep Programs > Settings for a Multistep Program (Program Monitor - Time, Program Restriction - Angle, Program Restriction - Time)  Multistep Programs > Step Restrictions (C - Current)  Event Codes list  Input Signals - Power Focus 8  Input Signals - StepSync  Output Signals - Power Focus 8  Output Signals - StepSync   3.6  06\/2021  First official release of the user guide for POWER FOCUS 8. "},{"id":"58952203","fileName":"58952203.html","title":"Prerequisites","level":2,"position":11,"hasContent":true,"hierarchy":["Introduction"],"content":" Anyone interested in learning more about POWER FOCUS 8can benefit from reading this User Guide.  For a complete understanding of the technical aspects described in the User Guide, we recommend the following:  Knowledge about tightening techniques  Experience of working with the previous versions of Power Focus"},{"id":"13413532427","fileName":"1341353242728073932683.html","title":"System Overview","level":2,"position":12,"hasContent":false,"hierarchy":["Introduction"],"content":""},{"id":"13414601611","fileName":"1341460161128073969803.html","title":"Software Structure","level":3,"position":13,"hasContent":false,"hierarchy":["Introduction","System Overview"],"content":""},{"id":"62559499","fileName":"6255949928073978251.html","title":"Menu Overview","level":4,"position":14,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure"],"content":" The controller has several menus available to configure tightening and hardware accessories, perform tool maintenance, administer software, and view reports. "},{"id":"19188363275","fileName":"19188363275.html","title":"Tightening Tab","level":5,"position":15,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  The Tighteningtab lists the tightening programs stored on the controller that are available for an individual tightening. Tightening configurations are described in the Tighteningtab.  "},{"id":"19188384267","fileName":"19188384267.html","title":"Batch Sequence Tab","level":5,"position":16,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  The Batch sequencetab lists the batch sequences stored in the controller. A batch sequence consists of one or more repetitive tightening programs in various combinations. Batch sequences are created and configured in the Batch sequencetab.  "},{"id":"19188392459","fileName":"19188392459.html","title":"Sources Tab","level":5,"position":17,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  The Sourcestab lists the available options for controlling the selection of a tightening program, for example, a tightening program or a batch sequence, via digital input from different hardware. Scanner configurations are done in the Sourcestab.  "},{"id":"19031194251","fileName":"19031194251.html","title":"Tool Tab","level":5,"position":18,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  The Tooltab provides information about the tools connected to the controller, including wireless tools. Some of the data available in this section is the QA calibration, the tool reference product and the service and calibration of the tool.  "},{"id":"19031185803","fileName":"19031185803.html","title":"Virtual Station Tab","level":5,"position":19,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  The Virtual stationtab configures the Virtual Stations. The Virtual Station is a software abstraction of a controller system. In the Virtual stationtab, the different resources, accessories, tools and tasks are assigned to a Virtual Station. Virtual Station Type licenses are assigned inside each Virtual Station configuration.  "},{"id":"19188401931","fileName":"19188401931.html","title":"Configurations Tab","level":5,"position":20,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  A list of accessory configurations is given in the Configurationstab. Accessories like tool accessories and socket selectors can be configured. Digital I\/O signals are mapped to buttons, lamps, switches and connectors.  "},{"id":"19188412427","fileName":"19188412427.html","title":"Controller Tab","level":5,"position":21,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  The Controllertab lists hardware and software components. The software versions stored and used in the controller are listed and can be updated. The license manager for additional features is handled. It is also possible to import or export settings to and from the controller.  "},{"id":"19188429323","fileName":"19188429323.html","title":"Reports Tab","level":5,"position":22,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  In the Reportstab the stored tightening results and the events are listed.  "},{"id":"15945023371","fileName":"15945023371.html","title":"Settings Tab","level":5,"position":23,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  The Settingstab is used to set up the controller specific settings, such as language, pin code, wireless network and fieldbus.  "},{"id":"28225206539","fileName":"28225206539.html","title":"Automation Rules Tab","level":5,"position":24,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  The Automation Rules tab lists the rules stored on the controller. The rules allow logical operations on Boolean signals available on the controller.  "},{"id":"19030385419","fileName":"19030385419.html","title":"License Assignment Tab","level":5,"position":25,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  The License assignmenttab is used to upload or discard licenses from or to the FSMP and to check their status.  "},{"id":"19188437259","fileName":"19188437259.html","title":"Help Tab","level":5,"position":26,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  The Helptab contains useful help sections about the controller. It is possible to download PDF files in different languages through a computer connected to the controller.  "},{"id":"2231529355","fileName":"2231529355.html","title":"Quick Start Guide","level":4,"position":27,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure"],"content":" To create a better overview of the system, this instruction lightly goes through the different steps required to get started using the system.  This section does not cover every feature of the system, but instead focuses on the most basic features.    Decide on what kind of tool to use. The kind of tool being used affect the availability of tightening strategies.  The main purpose of the tool is to perform a tightening. This is done by defining a tightening programwhich contains all relevant parameters of a tightening, for example target angle and target torque.  One or several tightening programs can be added to a Batch Sequencewhich works as a series of tightening programs. A batch sequence can for example be a certain number of tightenings with a tightening program, or a sequence of different tightening programs.  Create a Virtual Stationand assign a tool to it. The virtual station acts as an interface between the controller and the tool, allowing for several tools to be connected to a single physical controller. A virtual station is required even if only one tool is connected to the controller.  Assign a task to the Virtual Station. The task can be either a tightening program, a batch sequence, or a specified digital input (from for example a barcode scanner). The tool assigned to the station will now be able to perform the task. "},{"id":"13414603787","fileName":"1341460378728073942155.html","title":"Hardware Structure","level":3,"position":28,"hasContent":false,"hierarchy":["Introduction","System Overview"],"content":""},{"id":"91780235","fileName":"9178023528073949067.html","title":"Operating and Handling","level":4,"position":29,"hasContent":true,"hierarchy":["Introduction","System Overview","Hardware Structure"],"content":" The POWER FOCUS 8is set up and configured by using the controller front panel. It is also possible to access the controller interface through a web GUI by browsing to the controller’s IP address on a connected PC. "},{"id":"18755000843","fileName":"1875500084328073962891.html","title":"Front Panel","level":5,"position":30,"hasContent":true,"hierarchy":["Introduction","System Overview","Hardware Structure","Operating and Handling"],"content":" The front panel contains a touch-screen display and special buttons.       1  Display: A color display with touch screen showing configuration views and results.   2  Special buttons: Special function buttons  "},{"id":"18755006859","fileName":"18755006859.html","title":"Front Panel Buttons","level":6,"position":31,"hasContent":true,"hierarchy":["Introduction","System Overview","Hardware Structure","Operating and Handling","Front Panel"],"content":"  These buttons are available as clickable icons in the web GUI.     Button  Name  Description       Home  Go to the Home screen.      Go Result  Go to the live result view.   "},{"id":"18755012491","fileName":"18755012491.html","title":"Touch Screen Buttons","level":6,"position":32,"hasContent":true,"hierarchy":["Introduction","System Overview","Hardware Structure","Operating and Handling","Front Panel"],"content":"      Button  Name  Description       Add  Adds an additional item.      Back  Return to previous view.      Scroll up \/ Scroll down  Move in a list that is too long for the screen.      Maximize \/ Minimize  Maximize or minimize a section with parameters.      Back (in a list)  Back between pages of a list.      Forward (in a list)  Forward between pages of a list.      Close  Tap to close the window.      Notice  Sign showing that a parameter is configured wrong.      Home  Go to the Home screen.      Go Result  Go to the live results screen.               "},{"id":"69384843","fileName":"69384843.html","title":"Navigation","level":6,"position":33,"hasContent":true,"hierarchy":["Introduction","System Overview","Hardware Structure","Operating and Handling","Front Panel"],"content":"   To navigate in the controller GUI either tap on a menu item or move a finger (drag) across the display to scroll through items.  Options are selected by tapping the required option.  To enter data into a text box, tap the text box and a keyboard appears on the display.  50305931  "},{"id":"62541195","fileName":"6254119528073955979.html","title":"Web GUI","level":5,"position":34,"hasContent":true,"hierarchy":["Introduction","System Overview","Hardware Structure","Operating and Handling"],"content":" The web GUI is very similar to the controller display. It enables configuration and programming of the controller through a web browser on a computer connected to the controller.  Users can program the controller from the controller and the web interface at the same time. "},{"id":"19144972171","fileName":"19144972171.html","title":"GUI Buttons and Icons","level":6,"position":35,"hasContent":true,"hierarchy":["Introduction","System Overview","Hardware Structure","Operating and Handling","Web GUI"],"content":"      Button  Name  Description       Add  Add an additional item.      Remove  Remove an item.      Ellipsis  Edit an item.      Go back  Return to previous view.       Scroll up  Scroll down  Move in a list that is too long for the screen.       Maximize  Minimize  Maximize or minimize a section with parameters.       Back (to the start) (in a list)  Back (in a list)  Move back in pages of a list.       Forward (to the end) (in a list)  Forward (in a list)  Move forward in pages of a list.      Close  Tap to close the window.      Notice  Sign showing that a parameter is configured wrong.      Filter  Tap to filter on items.      WARNING  Sign leading to a warning about the risk of injury.      Pairing  Tap to pair a STB tool or a STwrench to the controller via WLAN or Bluetooth.      Validate program  Tap to check if a program is valid.      Download manual  Tap to download the User Guide in PDF format.      Go home  Go to the Home screen.      Go result  Go to the live results screen.      Virtual Station Grid Overview  Grid overview of the virtual stations results                      "},{"id":"28192443275","fileName":"28192443275.html","title":"Connecting to web GUI via service Ethernet port","level":6,"position":36,"hasContent":true,"hierarchy":["Introduction","System Overview","Hardware Structure","Operating and Handling","Web GUI"],"content":"  Make sure the DHCP settings are enabled on the computer. Perform the following steps to connect to the web GUI:    Connect to the service ethernet port.  Open a web browser.  In the address field, type 169.254.1.1.  The web GUI opens."},{"id":"9829248907","fileName":"9829248907.html","title":"License Introduction","level":2,"position":37,"hasContent":true,"hierarchy":["Introduction"],"content":" Licenses for controller features are managed through the Functionality Management System (FMS). FMS allows users to change controller functions to their specific needs through a dynamic licensing scheme. Licenses can be obtained for individual features or collections of features and can be deployed across multiple Virtual Stations. The licenses can be returned to a license pool when they are no longer required. Licenses can be obtained through the Atlas Copco License Portal (ACLP). Licenses can be downloaded from the ACLP and managed\/distributed through ToolsTalk, or can be stored on a FMS Portable (USB drive) to be inserted into the controller.  The creation and management of a customer account in the ACLP is not covered in this documentation. Contact your local Atlas Copco representative for more information."},{"id":"9848246155","fileName":"9848246155.html","title":"Licenses Overview","level":2,"position":38,"hasContent":true,"hierarchy":["Introduction"],"content":" Configuration of features governed by licenses can be done even in the absence of an installed license. For example configuration of tightening programs and configuration of Multistep programs. Assigning these features to a tool or virtual station is also possible. Running the feature without a valid license, however, will require the installation of the appropriate license. License enforcement is performed at two stages: assignment and runtime (trigger pressed). If a feature for which no license is installed is assigned to a Virtual Station, a red exclamation mark will appear at the Virtual Station View in ToolsTalk 2. The controller GUI will also show a warning triangle at the tool or task section (depending on what is missing). If a feature for which no license is installed is started (i.e. trigger pressed), an event will be presented to the user informing the user of which license is missing. It will not be possible to proceed without a correct license installed.  Running an unlicensed feature will, in most cases, result in a locked tool. Many features and functions in the controller require a license in order to be assigned and used by a virtual station. There are four types of licenses: Virtual Station Type Fixed collection of features bundled together in a single package. The Virtual Station Type determines, among other things, what tools can be run, how many programs and sequences can be used, which tightening strategies are available, and the type of reporting that can be done. The features contained in each Virtual Station Type are features that often are used in conjunction with each other, or which have internal dependencies that require the presence of other features in the package. Virtual Station Types are assigned in their entirety to a virtual station. The virtual station can then make use of all features contained in the Virtual Station Type. In order to be able to perform tightenings, a Virtual Station has to be assigned a Virtual Station Typelicense. Depending on the license type, various tightening options will be enabled or blocked. Sync Functionality Type Works in the same way as described in Virtual Station Type but used for fixtured systems. To be able to run several tools on a virtual station each tool need a sync functionality license. Virtual Station Feature Individual features which can complement Virtual Station Types. A lot of features can be purchased as a single license. Controller Feature Features that are controller-wide. These are features which are assigned to a controller and once assigned can be used by all virtual stations on that controller."},{"id":"12071037195","fileName":"12071037195.html","title":"License Sources","level":2,"position":39,"hasContent":true,"hierarchy":["Introduction"],"content":" Licenses used on a controller can be pulled from several different sources. The number of simultaneous sources is limited to 10 (either 10 FMS Portable sources, or one License Server (TT2) in addition to 9 FMS Portable sources). If you would like to add licenses from a source when the source limit (10) has been reached, all licenses from one source need to be removed from the controller to make room for licenses from the other source. Source Overview The Source Overview tab ( License assignment> Source Overview) provides the user with an overview of the licenses installed on the controller, as well as where they were installed from. A maximum number of 10 different sources can be displayed here, and each will be designated with FMS P (for FMS Portable, or dongle), or License Server (TT2). Clicking on any license source will present that source's detailed license source information. It lists the source name and type, as well as the number and type of licenses in each category (Virtual Station Type, Virtual Station Feature and Controller Feature)."},{"id":"18995834763","fileName":"18995834763.html","title":"Supported Tools","level":2,"position":40,"hasContent":true,"hierarchy":["Introduction"],"content":"  Tools supported by a Virtual Station may vary depending on the Virtual Station type on the controller.      Supported Tools  BatchControl  JointControl  StationControl  CriticalControl  ProcessControl    BCP \/ BCV -RE  -  -  -  -  -   IxB Connect  -  -  X  -  X   Tensor SB  -  X  X  -  -   TensorSL *  -  -  X  X  X   TBP  -  -  X  X  X   TensorST  -  -  X  X  X   TensorSTR  -  -  X  X  X   SRB  -  -  X  X  X   Tensor STB  -  -  X  X  X   STWrench  -  -  X  X  X   TensorES  -  X  X  -  -   TensorSR  -  -  X  X  X   QST (Fixtured spindle)  -  -  X  X  X   TBPS  -  X  X  -  -   MWR-S (Mechatronic Wrench Signal)  -  -  -  -  -   MWR-T (Mechatronic Wrench Torque)  X  X  X  X  -   MWR-TA (Mechatronic Wrench Torque Angle)  -  -  X  X  X   External tool  X  X  X  X  X * Requires Power Focus 8 Low Voltage."},{"id":"8850725515","fileName":"885072551528073995147.html","title":"Installation and Upgrade","level":1,"position":41,"hasContent":false,"hierarchy":[],"content":"  In this section, you can find information to help with the initial installation of the product, or upgrading from one version to another. "},{"id":"13414969739","fileName":"1341496973928074004619.html","title":"License Installation","level":2,"position":42,"hasContent":false,"hierarchy":["Installation and Upgrade"],"content":""},{"id":"19036496267","fileName":"19036496267.html","title":"Installing Licenses on the Controller","level":3,"position":43,"hasContent":true,"hierarchy":["Installation and Upgrade","License Installation"],"content":"  Note that licenses sources are limited to 1 License Server (TT2) and 9 FMS Portables (dongles) simultaneously. Licenses are installed either through the server (ToolsTalk 2) or FMS Portable. If the license source limit is reached, all licenses from one source need to be removed from the controller in order to add licenses from another source.  Before installing licenses through the server (ToolsTalk 2), make sure that the controller time is synced with the server time. Installing from the Server Distributing server-based licenses is done through ToolsTalk 2. Please refer to the ToolsTalk 2User Guide for instructions on installing licenses.  In order to be able to install licenses using ToolsTalk 2, the correct license server needs to be configured:    On the home view, go to the Settingstab and select Server connectionson the left pane.  On the Atlas Copco License Managerwindow, set the switch to On.  Insert the correct Server hostIP address (usually the same as the IP address for ToolsTalk 2) and Server Port.  Select Apply. Installing from FMS Portable (USB) The Functionality Management System (FMS) uses a special FMS Portable device to transfer functionality to and from a controller. The USB flash drive contains both a general purpose memory area and a trusted storage area that is only accessible by the License manager in a controller. The purchased feature items are downloaded from Atlas Copco to the general purpose area. The first time the FMS Portable is inserted into a controller with a License manager, the file is detected and decoded and the feature items are transferred to the trusted storage area that is only accessible from a License manager. If you have a USB drive with the licenses installed, perform the following steps to install them on the controller.    Insert the USB into the USB port in the controller  The USB License Management window will pop up in the GUI. The Poolcolumn will show the total license count on the controller from all sources. The Available on FMS Pcolumn shows the licenses available on this dongle, while the From this FMS Pcolumn shows the number of licenses that have been moved to this controller from this particular FMS P.  Select the left-pointing arrow next to license you want to install on the controller.  The number in the Available on FMS Pcolumn will decrease by 1 and the number in the From this FMS Pcolumn will increase by 1. The user will be presented with events on the controller for both license transfer start and end. License sync Existing licenses downloaded from the server are checked against the license server every two hours. If no response from the license server is obtained within a 14 day period, the affected licenses will be revoked. The user will also be warned when licenses are about to expire. When a license is within 7 days of expiration, the user will be presented with a warning once every two hours. If licenses are not renewed, they will expire and the affected functions will no longer be available. "},{"id":"9844855819","fileName":"9844855819.html","title":"Removing Licenses from the Controller","level":3,"position":44,"hasContent":true,"hierarchy":["Installation and Upgrade","License Installation"],"content":" One way of removing an FMS Portable-installed licenses are described, for instructions how to remove server-installed licenses, please refer to the ToolsTalk 2User Guide. Removing FMS Portable-Installed Licenses    Make sure the FMS Portable is inserted into the USB port in the controller.  [If the USB License Manager window is not visible] Select the License Assignmentmenu.  Select the USB icon in the top right of the window.  The USB License Manager window pops up.  Select the right-pointing arrow next to the license you want to remove from the controller.  Licenses that are assigned to virtual stations can be removed from the controller. However, the Virtual Station will become unusable as a result. "},{"id":"8850727051","fileName":"885072705128074054155.html","title":"Configuration","level":1,"position":45,"hasContent":false,"hierarchy":[],"content":"  In this section, you can find detailed information about how to create, modify, and verify product settings. "},{"id":"80998923","fileName":"8099892328074181771.html","title":"Working with the Tightening Tab","level":2,"position":46,"hasContent":true,"hierarchy":["Configuration"],"content":"  Risk of injury  A change in the configuration of the tightening program may cause unexpected torque, rotational direction, or speed in the system(s) where the tightening program is currently in use. This could result in severe bodily injury and\/or property damage.   Check the tightening program configurations after adding a new program or after applying changes to an existing program.  Changes made to tightening programs in any section need to be actively applied by clicking the Apply button in the bottom right corner of the GUI. Alternatively, changes can be undone by clicking the Undo button in the same location. When navigating away from the section where changes have been made (by using the Back, Home or Result button), the user will be presented with a warning pop-up where the changes can also be applied or undone. The user cannot proceed without applying or undoing changes.   Controller features, such as the Low Reaction Tightening Strategies and controller-wide functions among others, require licenses distributed through the Functionality Management System (FMS). Whereas configuration of features is possible without specific licenses, the assignment and use of those features will require the correct license to be installed on the controller. Please refer to Licenses (FMS) for more detailed information on licenses.  The POWER FOCUS 8tightening programs need parameters to be set in order to perform tightening. Selecting a Strategy and either the Target torqueor Target angleare mandatory. Other settings are optional, such as Soft start, Selftap, and Torque compensation. It is also possible to monitor the tightening as it progresses by adding limits within which the torque, or angle the nut turns, must remain. The tightening procedure is divided into four steps: Start, Rundown, Tightening and Stop.   "},{"id":"1744545675","fileName":"174454567528074195595.html","title":"Step Configuration Stages","level":3,"position":47,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab"],"content":" The controller tightening programs need parameters to be set in order to execute the programs. Selecting a Strategyand either the Target torqueor Target angleare mandatory. Other settings are optional. It is also possible to monitor the tightening as it progresses by adding limits within which the torque or angle rotation must remain. The tightening procedure is divided into four stages: Start, Rundown, Tightening and Stop.  Typical tightening curve The figure is typical of how tightenings are described. The curves represent how speed, torque and angle vary over time. All tightening strategies are represented in this way. Parameters, monitors and limits are also shown in detailed figures. A task is defined from the time a trigger is pressed until the tightening target is reached, or an error occurs. A combination of a tightening strategy together with specific parameter settings forms a tightening program. The user can create many different tightening programs, and one of them is selected at runtime.  "},{"id":"91423499","fileName":"9142349928074217355.html","title":"Start Stage","level":4,"position":48,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages"],"content":" The optional Start step initiates the tightening, enables socket and thread finding, and the option to detect rehits. "},{"id":"61715723","fileName":"61715723.html","title":"Direction","level":5,"position":49,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Start Stage"],"content":"  Directiondefines the tightening direction of the spindle to clockwise (CW) or counterclockwise (CCW). The rotation of the spindle will always be in this direction, except when loosening and during the conditioning step used in the Three stepstrategy.      Parameter  Description  Default value    Thread direction  Defines the tightening direction of the spindle.  Clockwise"},{"id":"60633611","fileName":"60633611.html","title":"Soft Start","level":5,"position":50,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Start Stage"],"content":" During Soft startit is possible to set the speed, the maximum torque and the the rotation angle to help the screw to enter the thread, and to prevent the tool being jerked out of position when the tool trigger is pressed.       Parameter name  Description  Default value    Soft start  Enables setting of the tool’s speed, angle and maximum torque to facilitate the screw entering the thread.  Off:Soft start is turned off.  On:Soft start is turned on.  On   Speed  Defines the speed during Soft start.  35 rpm   Angle  Defines the angle to turn the spindle for the screw to enter the thread.  90°   Torque max  Defines the upper torque limit during Soft start. If Torque maxis exceeded, the tightening is aborted and an error message is given. The tightening will be considered NOK.  1.25 Nm  "},{"id":"60672907","fileName":"60672907.html","title":"Rehit Detection","level":5,"position":51,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Start Stage"],"content":" When Rehit detectionis activated, it is possible to detect a screw that has already been tightened.      Parameter  Description  Default value    Rehit detection  Detects attempts to tighten an already tightened screw.    Early:the Rehit detection Earlyoption terminates the tightening immediately when a rehit is detected and ends the tightening in the most ergonomic possible way. To be able to use the Rehit detection Early option, Soft start must be set to On. This is because the Soft start torque maxvalue is used as the torque limit beyond which the tightening is considered a rehit. The tightening is considered as NOK and a rehit error is indicated.   Complete:to make a rehit detection when Soft start is not used, the Rehit detection Completeoption must be used. Rehit detection Complete does not terminate the tightening until all tightening steps have been executed and consequently takes longer. The tightening is considered a rehit if the speed never reaches half the rundown speed, and a rehit error is indicated. The tightening is considered as NOK.   Off:no rehit detection is performed.  Early"},{"id":"81997323","fileName":"81997323.html","title":"Current Monitoring","level":5,"position":52,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Start Stage"],"content":" Current monitoring provides an extra security to monitor the tightening torque and is a complement to the torque sensor in the tool. At final target torque, the rotor current is measured and converted to a torque value. If the calculated torque is within 10% of the measured torque, the tightening is considered to be OK.      Parameter  Description  Default    Current monitoring  Switch with On - Off position.   Off: Current monitoring is disabled and the tool torque is measured by the torque sensor.  On: the current is measured at final torque target and converted to a torque value. The calculated torque is compared to the measured torque. If the difference is within 10%, the tightening is considered OK.  Off  Current monitoring is not implemented for Turbo Tight, Rotate, Pulsing and STwrench strategies."},{"id":"82022027","fileName":"82022027.html","title":"TrueAngle Compensation","level":5,"position":53,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Start Stage"],"content":" Certain tools are equipped with a gyro and measure the tool rotation during tightening. If the tool is rotated during tightening, the angle measurement may be corrupted. This leads to faulty tightening if made to angle references. For variations within specified limits, the controller can compensate for these rotations and make a correct tightening. If the tool rotation is outside specified limits, the tightening is aborted and the result status NOKis reported. Additional information reports Tool movement exceeded.      Parameter  Description  Default    TrueAngle compensation  Available for all tightening strategies except Rotate.  Tools which have a crowfoot installed as an attachment do not support the parameter TrueAngle compensation.  On   Tool movement limits - Negative  Only visible if TrueAngle compensation is on. Defines the maximum negative rotation of the tool. If the value is exceeded the tightening is terminated and an error is reported. Expressed in a numeric angle value.   Min value: 1  Max value: 180  30   Tool movement limits - Positive  Only visible if TrueAngle compensation is on. Defines the maximum positive rotation of the tool. If the value is exceeded the tightening is terminated and an error is reported. Expressed in a numeric angle value.   Min value: 1  Max value: 180  30  Only tools with gyro have the capability to measure the tool movement.   "},{"id":"91426571","fileName":"9142657128074203019.html","title":"Rundown Stage","level":4,"position":54,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages"],"content":" The part of the tightening from when the screw enters the thread until just before the screw head touches the underlying surface and snug is reached. The torque required during rundown does not contribute to any clamping force.      Parameter  Description  Default value    Rundown speed  Defines the speed during the Rundown step  Tool max speed "},{"id":"60789131","fileName":"60789131.html","title":"Selftap","level":5,"position":55,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Rundown Stage"],"content":" The Selftap step enables tightening where the rundown torque required is greater than the Rundown completetorque, for example when tightening thin layers of metal using self-threading (or self-tapping) screws. The selftap window starts when the torque value reaches SelftapTorqueMin\/2. The torque must reach over SelftapTorqueMin, but not pass SelftapTorqueMax, during the angle window.       Parameter  Description  Default value    Selftap  Activates the Selftap step.  Off   Speed  Defines the speed during Selftap.   Soft start speedor 5% of ToolMaxSpeed   Length  Defines the angle to turn the socket during Selftap. Measured from the end of the Start step.  360°   Torque min  Torque value for lower Selftap limit.  0 Nm   Torque max  Torque value for upper Selftap limit.  Tool max torque  "},{"id":"60828427","fileName":"60828427.html","title":"Rundown Torque Limits","level":5,"position":56,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Rundown Stage"],"content":" The friction between the nut and joint can vary. This can cause the torque needed to run a nut down a thread, before engagement with the joint surface takes place, to vary as well. These effects could be, for example, hole interference, prevailing torque or varying lubrication. Monitoring the rundown torque can be useful when running down a lock nut which has a plastic insert in the threads to help the fastener resist vibration. This will require a higher torque, known as prevailing torque, to overcome the interference.       Parameter  Description  Default value    Rundown torque limits  Sets Rundown torque limits to On or Off.  Off:No limits are set.  On:Torque limits and angle interval are set.  Off   Offset  Angle offset before the Angle interval begins.  0°   Length  Angle defining the Rundown torque limit section.  360°   Torque min  Torque value for lower Rundown torque limit.  0 Nm   Torque max  Torque value for upper Rundown torque limit.  19% of Target torque  "},{"id":"60880523","fileName":"60880523.html","title":"Rundown Angle Limits","level":5,"position":57,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Rundown Stage"],"content":" By monitoring the angle of rotation during rundown, errors such as missing washers or screws with incorrect thread size or length can be detected. For example, threads that are too long would require a greater turning angle for the screw to reach snug.       Parameter  Description  Default value    Rundown angle limits  Activates Rundown angle limits. The angle limits are set relative to when the tool trigger is pressed or when a specified torque value is reached. Angle limits will not be checked during Selftap if Selftap is activated.  Off:No limits are set.  From trigger:The system starts to monitor the tightening angle as soon as the tool trigger is pressed and reports if angle or time limits are violated.  From torque:The system starts to monitor the tightening angle from the specified <From torque>value and reports if angle or time limits are violated.  Off   <From torque>  Torque value from where Rundown angle limits are set.  10% of Target Torque   Angle min  Angle value for lower angle limit from starting point.  100°   Angle max  Angle value for upper angle limit from starting point.  1000°   Time min  Minimum time (in milliseconds) for the step. Measured from the start of the step.  10 ms   Time max  Maximum time (in milliseconds) for the step. Measured from the start of the step.  5000 ms  "},{"id":"61960075","fileName":"61960075.html","title":"Post View Torque","level":5,"position":58,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Rundown Stage"],"content":" Some joints have a torque peak prior to Rundown complete. Post view torque makes it possible to monitor torque values during two specified angular intervals. The interval starts are defined as an angle prior to Rundown complete and torque is then monitored for a specified angular interval. Post view torque is therefore similar to Rundown torque limits except that the maximum and minimum limits can be positioned independently of each other and can differ in length to better control the outcome of the rundown step.       Parameter  Description  Default value    Post view torque  Post view torque makes it possible to monitor torque values during two specified angular intervals.  Off   Torque min  Torque value for lower Post view torque limit.     Torque min offset  Angle offset before the Post view torque min interval begins.  720°   Torque min length  Angle length defining the Post view torque min section.  90°   Torque max  Torque value for upper Post view torque limit.     Torque max offset  Angle offset before the Post view torque max interval begins.  360°   Torque max length  Angle length defining the Post view torque max section.  90°  "},{"id":"60919819","fileName":"60919819.html","title":"Rundown Complete","level":5,"position":59,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Rundown Stage"],"content":" Rundown complete sets if the screw has reached snug. It ends the Rundown step so that the tightening step can be entered.      Parameter  Description  Default value    Rundown complete  Specifies how to control when snug is reached.  At torque:Specifies the torque value for when the rundown step is completed.  At torque   <At torque>  Defines the torque value for when snug is reached and the rundown step is completed. Rundown complete must be smaller than First torquein multi-step strategies or Target torquein the TurboTight strategy.  "},{"id":"91432715","fileName":"91432715.html","title":"Stop Stage","level":4,"position":60,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages"],"content":" The Stop stage terminates the tightening so that the socket can be released. Soft Stop Soft stop causes the tightening stop in a more ergonomic fashion.  Do not stop tools within the time interval of 50-300 ms, as this is known to make it feel like an uncomfortable stop.      Parameter  Description  Default value    Soft stop  Turns the Soft stop on or off.    Off:No Soft stop is used.   On:Soft stop is activated. When target torque is reached, the tool speed is immediately decreased to 75%. Then the speed is decreased to zero in at most 40 ms.  Off"},{"id":"65795211","fileName":"65795211.html","title":"Loosening a Screw","level":4,"position":61,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages"],"content":" By setting the loosening parameters, you can control the behavior of loosening for a specific tightening program. Specify the loosening speed and torque to ensure that the screw is unscrewed as desired, so that the screw thread does not break, regardless of what tool you use.  A loosening is considered OK when Run-up torqueis reached. However, the screw will probably not have been fully run up by then. The screw should now be able to be turned using a low torque and the speed can be increased. The operator will need to proceed with the loosening until it is considered finished.       Parameter name  Description  Default value    Detection torque  The minimum torque required to begin performing a loosening operation and produce a loosening result.  7% ToolMaxTorque   Run-up torque  When the torque falls below Run-up torque, the loosening is considered to be OK.  Note!Depending on variations in screw length, the system cannot determine when the screw has been run up completely. This is for the operator to decide.  3.5% ToolMaxTorque   Loosening speed  Loosening speed will be attained when Run-up torqueis reached.  ToolMaxSpeed  "},{"id":"84247307","fileName":"8424730728074209931.html","title":"Stage Parameter Descriptions","level":4,"position":62,"hasContent":false,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages"],"content":""},{"id":"61140619","fileName":"61140619.html","title":"Target Torque Limits","level":5,"position":63,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Stage Parameter Descriptions"],"content":" By setting the Target torque limits, it is possible to discard a tightening should the torque result not fall within the specified torque limits. A too high torque can cause the screw to deform as a result of passing the yield point, and can even break, or can cause the stripping of threads. Not enough torque result in the clamping force not being enough to withstand the forces for which the joint is designed.       Parameter  Description  Default value    Torque limits  The tightening is considered as NOK if the torque result is outside the range defined by Torque min and Torque max.  Auto:Torque limits are automatically set to the default values specified for Torque min and Torque max.  Manual:Enables the Torque limit values to be set manually.  Auto   Torque min  Torque value for lower torque limit. Can be entered if Manualhas been selected.  95% of Target torque   Torque max  Torque value for upper torque limit. Can be entered if Manualhas been selected.  120% of Target torque The parameter Measure torque atcan have different values. By default the torque is measured at torque peak. The possible values of the parameter are listed in the table below.      Name  Description    Max torque value  Measures the highest torque value during the tightening.   Value at peak angle  Measures the torque value at the highest angle value.   Value at shutoff  Measures the last torque value before entering the break step.  "},{"id":"61179915","fileName":"61179915.html","title":"Target Angle Limits","level":5,"position":64,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Stage Parameter Descriptions"],"content":" With Target angle limits set, it is possible to monitor whether the nut is turned the desired angle during the tightening.      Parameter  Description  Default value    Angle limits  Choose the section of the tightening, in degrees, in which to monitor the angle.    Off:No limits are checked.   From Rundown complete:The monitoring window is set from when the Rundown complete torqueis reached.   From torque:The monitoring window is set from when the specified torque value is reached. Torque must be greater than Rundown complete torque.   From First target:The monitoring is set from when First targetis reached. This option is not available if TurboTight is chosen.   Auto:The angle monitoring limits are automatically calculated by the controller   Manual:The angle monitoring limits are manually entered.  Off   <From torque>  Torque value from where angle limits are set.     <From torque>  Torque value from where angle limits are set.  75% of Target Torque   Angle min  Angle value for lower angle limit  90°   Angle max  Angle value for upper angle limit  720°   Time min  Minimum time (in milliseconds) for the step. Measured from the start of the step.  10 ms For TurboTight: 0 ms   Time max  Maximum time (in milliseconds) for the step. Measured from the start of the step.  1000 ms For TurboTight: 40 ms  Position 1-4 are valid if the target is torque. Position 5-6 are valid if the target is angle. The parameter Measure angle atcan have different values. The parameter is only available when angle monitoring is turned on for the tightening program used. By default the angle is measured at Max angle value. The possible values of the parameter are listed in the table below.      Name  Description    Value at peak torque  Measures the angle at the highest torque value.   Max angle value  Measures the highest angle during tightening.   Value at shutoff  Measures the last angle value before entering the break step."},{"id":"61335179","fileName":"61335179.html","title":"Torque Compensation","level":5,"position":65,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Stage Parameter Descriptions"],"content":" By using torque compensation, the actual clamping force applied to the joint can be better determined and the scatter in the applied clamping force can be reduced. The torque compensation point is set by referring back to a specified angle from Rundown complete and calculating a value for the torque used during rundown. This is then compensated for when creating the preload in the screw by adding the torque value calculated in the torque compensation point to the Target torque.      Parameter  Description  Default value    Torque compensation  Enables adjustment if the Target torque for torque used in the rundown step.  Off:No compensation is made.  On:Manually sets the Torque compensation point.  Off"},{"id":"1232883979","fileName":"1232883979.html","title":"Residual Torque Correlation Factor","level":5,"position":66,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Stage Parameter Descriptions"],"content":" The term Residual torque correlation factor is similar to a calibration and adjusts between the dynamic torque, measured in the electrical tool, and the residual torque, measured by a control tool. The Residual torque correlation factoris available for all tools running the TurboTight strategy and the TensoPulse tightening strategy. It is also available for the battery pulse tools that are supported by the controller.  When using a Residual torque correlation factorthat differs from 100, the reported Final torqueis no longer the dynamic torque measured by the tool transducer. The dynamic torque measurement uses an internal torque transducer that constantly measures the torque. When the target torque is reached, the tool stops and the result is evaluated and reported. The measured final torque in the transducer is affected by the joint condition, the tool speed, gears and sockets. The residual torque is measured after the tightening is completed. It is the torque needed to continue or restart the tightening to a higher level. The residual torque is determining the clamping force in the joint.      A dynamic torque measurement is highly repetitive but may differ between tool type and tool speed.  A handheld calibrated torque wrench provides high accuracy measuring the residual torque but has higher variations due to joint relaxation, torque decay, friction or operator technique. The Residual torque correlation factoris a compensation between the dynamic torque and the residual torque. The factor should be determined by conducting tests. The selected tightening program is performed a few times and the dynamic torque is recorded. The tightenings are also manually measured to determine the residual torque.  The Residual torque correlation factorcan be calculated by dividing a residual torque by a dynamic torque. The Residual torque correlation factoris presented as percent and is by default 100%. This means the reported dynamic torque value has not been modified.      Parameters  Function     Target torque  The tool target torque set for the tightening using the TurboTight strategy.    Final dynamic torque  The final torque reported as the result of the performed tightening.    Dynamic torque  The dynamic torque measured by a reference transducer.    Residual torque  The desired residual torque that ensures the desired clamping force.    Residual torque correlation factor  The compensation factor between residual torque and dynamic torque An example of how torque tuning can be used: The TurboTight strategy is selected. The joint shall be tightened to 12 Nm to reach the desired clamping force. The following set up is made:      Example settings  Value  Function     Target torque  12 Nm  The programmed desired target torque in the controller    Residual torque correlation factor  100  The compensation factor between residual torque and dynamic torque A number of tightenings are made. After each tightening the joint is checked with a calibrated torque wrench. The average is calculated and the following result has been found:      Initial parameters and results  Value  Function     Target torque  12 Nm  The programmed target torque in the controller.    Final torque  12 Nm  The final torque reported as the result of the performed tightening.    Dynamic torque  12 Nm  The uncompensated measured torque from the tool transducer.    Residual torque  10 Nm  The residual torque measured with a calibrated torque wrench or other test tool.    Residual torque correlation factor  100 %  The compensation factor between residual torque and dynamic torque The testing shows that the residual torque is too low to produce the desired clamp force. The Residual torque correlation factor is calculated to 0.83, which is 83 %. An adjustment of the tuning factor is made and the following result is obtained.      Final parameters and results  Value  Function     Target torque  12 Nm  The programmed target torque in the controller.    Final torque  12 Nm  The final torque reported as the result of the performed tightening.    Dynamic torque  14.5 Nm  The uncompensated measured torque from the tool transducer.    Residual torque  12 Nm  The desired residual torque that ensures the desired clamping force.    Residual torque correlation factor  83 %  The compensation factor between residual torque and dynamic torque. What this shows is that we need to tighten a bit more than the specified target, to compensate for differences and to reach the desired torque in the joint.  It is important that the correlation is made with the same tool type and parameter configuration that will be used in production.  "},{"id":"2683154059","fileName":"2683154059.html","title":"Trigger Lost","level":5,"position":67,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Stage Parameter Descriptions"],"content":" In the Result Evaluationwindow of the program tightening stage, NOK on trigger lostswitch controls whether or not it is allowed to release the tool trigger before the target condition has been reached. The setting can be set to On or Off. Below is a description of the two states.      Switch setting  Description    On  Releasing the trigger before reaching the target condition will result in a NOK tightening.   Off  Releasing the trigger before reaching the target condition will result in an OK tightening as long as all other conditions have been met.  The default behavior is that premature trigger release shall not be allowed.  Availability The NOK on trigger lost is available in the following tightening strategies: Rotate, Quick Step, Two Step, Three Step, and Impulse - Single Step.  For the tightening strategies Rotate, Quick Step, Two Step and Three Step, Trigger Lostsetting is only available when the Target of the program is set to Angle (not Torque)."},{"id":"18740221323","fileName":"1874022132328074224267.html","title":"Tightening Programs","level":3,"position":68,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab"],"content":" By selecting the tightening program it is possible to choose the method for applying clamping force (or pre-load) to the joint. Different joints require different strategies for how to apply the desired clamping force and to minimize unwanted in-service effects. POWER FOCUS 8can store up to 1,000 tightening programs.   The TurboTightstrategy, enables the option to use Manual programming or Quick prog - for more information, see the paragraph TurboTight.  The Quick step, Two stepand Three stepstrategies enable the choice of tightening towards a Target torque or a Target angle value.  The External resultstrategy, is used when OK tightenings are indicated by an external digital signal - for more information, see the paragraph External result. All tightening programs require that you at least set the Target torqueor Target anglevalue.      Parameter  Description  Default value    Strategy  Available tightening programs.  TurboTight: No additional tightening behavior is used as default. Only target values are used.  Quick step: Adds an initial tightening step to reduce pre-load scatter.  Two step: Adds a pause between the first and final tightening step to further counteract short-term relaxation effects.  Three step: Tightens to a defined First torque value, then loosens the screw and immediately retightens it to Target torque or Target angle.  Wrench - production: Tightening strategy to use with an ST Wrench.  Wrench - quality: Strategy used for quality test of tightenings with an ST Wrench.  Rotate: Rotates the spindle a specified speed and angle.  External result: presents a predetermined tightening result instead of measured torque\/angle.  Multistep: Tightening strategy consisting of multiple configurable steps, with restrictions and monitors.  TurboTight   Target type  Defines the type of the target value in the final step.  Target torque:The tightening aims towards the specified target value when performing the final step.  Target angle:The tightening aims towards the specified target value when performing the final step.     Target torque  Defines the target torque of the tightening of the final step.     Target angle  Defines the target angle of the tightening of the final step.     Target speed  Activates setting the tool speed for the final step manually or using the default speed.  Auto:Uses a value that is calculated based on the Tool max speed.  Manual:Specify the tool speed manually.  Auto   <Manual>  Tool speed during tightening or during the final step.   "},{"id":"62055563","fileName":"62055563.html","title":"TurboTight","level":4,"position":69,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":"  TurboTight is the default tightening strategy and it is designed to perform a very fast and ergonomic tightening based on the maximum speed of the tool (Tool max speed). This strategy has two options:   Quick prog, that requires only the Target torqueto be set to perform the tightening.   Manual, that allows the user to configure several tightening parameters.  To minimize the risk of unexpected jerk at the end of the tightening when using the TurboTight tightening strategy, make sure to activate Time monitoring. To minimize the risk of unexpected jerk at the end of the tightening when using the TurboTight tightening strategy, make sure to set the Time Max Limit. Time Max Limit is enabled by default, but it is necessary to setup the related values. In the tightening stage, set Angle Limitto From Rundown Complete. Set Time Maxas low as possible, without stopping the normal tightening. In the rundown stage, set Rundown Complete Torqueso that it is triggered when the torque start to increase. Depending on the joint properties, for example if the joint is very stiff or very soft, a different tightening strategy than TurboTight might be needed.   TurboTight is not available for Joint Control. Fine-Tuning the TurboTight Strategy TurboTight tightening strategy points to the target torque, and the result can be below or above the target. The most important parameter for TurboTight tightening strategy is the speed. It is possible to keep maximum speed for most tightenings, but if all\/some of the tightenings overshoot, decrease the speed in small steps. Rundown Complete Torqueis not used for controlling of the tightening; it is only used for calculating of limits and results. "},{"id":"60968203","fileName":"60968203.html","title":"Quick Step","level":4,"position":70,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":" Quick step is a tightening strategy used to reduce the joint’s preload scatter by adding an initial step with a given torque and speed, and then reducing the target speed in the final step.       Parameter  Description  Default value    First torque  Target torque for the first step.     First torque  Torque during first step.  80% of Target Torque   First speed  Target speed for the first step.     First speed  Tool speed during first step.  50% of Tool max speed  "},{"id":"60970763","fileName":"60970763.html","title":"Two Step","level":4,"position":71,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":" The Two step strategy is very similar to the Quick step strategy except that it adds a small time delay between the first step and the final step, to further counteract short-term relaxation effects in the joint.       Parameter  Description  Default value    First torque  Torque during first step.  80% of Target Torque   First speed  Target speed for the first step.     Pause time  Time between first and second step.  50 ms Fine-Tuning the Two Step Strategy When the First target is reached, the tool makes an immediate stop for a specified time before it continues with the final step. The First torque value and the Pause time should be chosen to improve ergonomics for hand-held tools.  "},{"id":"60976395","fileName":"60976395.html","title":"Three Step","level":4,"position":72,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":" The Three step strategy adds a loosening step between the first step and the final step, to overcome short-term relaxation effects due to embedment, and reduce preload scatter. This is sometimes used to condition the joint. This can be useful in, for example, joints with many adjoining surfaces and will have a greater effect on new parts than on reused ones, due to the smoothing of surfaces, which reduces embedment. Conditioning the joint is done by tightening the first step to a given torque, First torque, and then releasing the load by turning the nut a specified Conditioning angleand then retightening the nut to its Target torqueor Target angle. The target torque can be lower than the torque reached during the first step after rundown. In order for the target torque to be lower than the first torque, set target torque (Tightening parameters > Tightening step > Final step > Target torque) to a value lower than First torque (Tightening parameters > Tightening step > First step > First torque). If Angle is used as a target in the tightening program, the Target angle is measured from the position at the end of the loosening step (conditioning). Behavior of Measure torque at, and Measure angle to The Max torque valueand Value at peak torquemeasured under Result evaluation for Measure torque at and Measure angle to, respectively, represent the highest values measured over the entire tightening. This means that if the Target torque is set lower than the First torque, the Result evaluation value will be higher than the end value. In order to view the tightening's final value, both Measure torque at, and Measure angle to should be set to Value at shutoff.       Parameter  Description  Default value    First torque  Torque during first step.  80% of Target Torque   First speed  Tool speed during first step.  50% of Tool max speed   Conditioning speed  Tool speed during the conditioning step.  50% of Tool max speed   Conditioning angle  Angle to turn the socket during the conditioning step.  180° Fine-Tuning the Three Step Strategy When the First target is reached and the conditioning step is entered, the tool makes an immediate stop and reverse before it continues with the final step. This conditioning step may need to be fine-tuned to improve ergonomics for hand-held tools.  "},{"id":"1783968907","fileName":"178396890728074231691.html","title":"STwrench","level":4,"position":73,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":" The STwrench is connected to a controller using a wireless connection and is configured through the controller GUI or the web GUI. The STwrench is configured under the tightening menu in the same way as the other tightening strategies. The STwrench has a Rapid Backup Unit (RBU). The RBU defines the wrench function and stores the tightening programs. The controller supports currently only the RBU of the type Production. The STwrench End-fitting tool(socket) contains a RFID TAG with a programmable number. This wrench uses this number to automatically recognize the tool and which program that can be used. The RFID TAG also stores the torque and angle correction coefficients. The STwrench has several programs both for production tightening and for quality control.  The STwrench can only support tightening programs supported by the tool ( Wrench Productionand Wrench Quality).  For more information about the STwrench, see the STwrench User Guide (printed matter number 9836 4134 01). "},{"id":"19082572811","fileName":"1908257281128074238603.html","title":"Wrench Production Strategy","level":5,"position":74,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","STwrench"],"content":" In this section, you can see the different parameters applicable to the different stages of the Wrench Production strategy. "},{"id":"19082888459","fileName":"19082888459.html","title":"Wrench Production Start Stage Parameters","level":6,"position":75,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","STwrench","Wrench Production Strategy"],"content":"  The parameters shown in the tables are available if one of the STwrench strategies are used. There are several combinations of strategies. Some of the parameters are only available for certain strategies and may not be visible in other strategies. Parameter rules are automatically checked. If a violation occurs, the error indicatoris displayed beside the incorrect parameters. Select the error indicator to display more information about the error.  Switching between strategies can result in the error indicator being shown. This indicates that the chosen combination is invalid, and needs to be corrected.  For more information about the STwrench, see the STwrench User Guide (printed matter number 9836 4134 01).    Parameters in the STwrench start step     Parameter name  Condition  Description  Default value    Tag number    On: after enabling TAG Check switch ( Configurations > Tool Configuration > TAG Check > On), a correct TAG number is required to run the tightening program.  Off: The TAG number is not checked.  Off   Required tag number  Tag number = On  The required TAG number for this tightening program.  1   Direction   The parameter options are CW(clockwise) or CCW(counterclockwise).    Rehit detection   The parameter options are:  Completeor Off.  Off   Torque correction coefficient   In certain cases extensions may be needed to fit the application. In this case the wrench measurement must be compensated to show a correct value. For more information about to calculate the correction coefficient, see the STwrench User Guide (printed matter number 9836 4134 01). The parameter is stored in the RFID TAG in the End-fitting tool.  1.0   Angle correction   In certain cases extensions may be needed to fit the application. In this case the wrench measurement must be compensated to show a correct value. To calculate the correction coefficient, please refer to the STwrench user guide. The parameter is stored in the RFID TAG in the End-fitting tool.  0°   Linear slope coefficient   Linear slope coefficient characterizes the joint stiffness in the linear part of the curve, as torque\/angle slope in the Nm\/Deg measurement unit.  0.5  The correction coefficients alter the STwrench measurement. It may cause an improper reading. Before making any corrections, refer to the latest version of the STwrench User Guide (printed matter number 9836 4134 01).  "},{"id":"19082883595","fileName":"19082883595.html","title":"Wrench Production Rundown Stage Parameters","level":6,"position":76,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","STwrench","Wrench Production Strategy"],"content":"  The parameters shown in the tables are available if one of the STwrench strategies are used. There are several combinations of strategies. Some of the parameters are only available for certain strategies and may not be visible in other strategies. Parameter rules are automatically checked. If a violation occurs, the error indicatoris displayed beside the incorrect parameters. Select the error indicator to display more information about the error.  Switching between strategies can result in the error indicator being shown. This indicates that the chosen combination is invalid, and needs to be corrected.  For more information about the STwrench, see the STwrench User Guide (printed matter number 9836 4134 01).     Rundown completeis in the STwrench documentation defined as Cycle start, this is when the tightening step begins.  Parameters in the STwrench rundown step     Parameter name  Description  Default value    Rundown speed   690 rpm   Rundown complete torque  Definition of the Rundown complete point  Depends on the smarthead minload (usually 5% of nominal torque) in Nm   Ratchet time   5000 ms  "},{"id":"19082935819","fileName":"19082935819.html","title":"Wrench Production Tightening Stage Parameters","level":6,"position":77,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","STwrench","Wrench Production Strategy"],"content":"  The parameters shown in the tables are available if one of the STwrench strategies are used. There are several combinations of strategies. Some of the parameters are only available for certain strategies and may not be visible in other strategies. Parameter rules are automatically checked. If a violation occurs, the error indicatoris displayed beside the incorrect parameters. Select the error indicator to display more information about the error.  Switching between strategies can result in the error indicator being shown. This indicates that the chosen combination is invalid, and needs to be corrected.  For more information about the STwrench, see the STwrench User Guide (printed matter number 9836 4134 01).    Parameters in the STwrench tightening step     Parameter name  Condition  Description  Default value    Control strategy   The parameter options are: Torque\/Angle, Yield point, Looseand PVT compensate with snug.    Premature torque loss detection time   From rundown complete, the program may start the tightening with an increase in torque. If the tool detects a decrease in torque within this time frame, a slip-off is reported If the socket slips of the screw head and the measured torque decreases below Rundown complete within the specified time, the tightening is aborted and premature torque loss is reported.  200 ms   Target   Select the target from the drop-down menu. The parameter options are:  Torque, Angle, Torque or Angle.  Torque   Target Torque    Defines the target torque for tightening step.  0 Nm   Torque limits  Target = Torque  Selection made by a switch.  Autoor Manuallyposition.     Torque min  Torque limits = Manual  Torque value for the lower limit  0 Nm   Torque max  Torque limits = Manual  Torque value for the upper limit  0 Nm   Target Angle  Target = Angle or Target=Torque or Angle  Defines the target angle for tightening step.  0°   Angle limits  Target = Angle  Selected from a drop-down menu. The parameter options are:  Autoor Manually. Angle values for max and min can be or selected    Angle limits  Target = Torque  Selected from a drop-down menu. The parameter options are:  Off:No angle limit monitoring.  From rundown complete:The monitoring window is set from when the Rundown complete torqueis reached.  From torque:The monitoring window is set from when the specific torque value is reached.    Final angle monitoring torque   Torque value from when the angle limits are monitored  20 Nm   Angle min  Angle limits = on or manually  Angle value lower limit  324°   Angle max  Angle limits = on or manually  Angle value upper limit  396°   Angle search limit  Angle limits = manually   0   Measure torque at    Selected from a drop-down menu. The parameter options are:  Max torque value  Value at peak angle     NOK on final less than target    Selection made by a switch.  Onor Offposition.  Off   Change bolt limit     50 Nm  Additional parameters in the STwrench tightening step if the strategy is Wrench - Production, and PVT compensate with snug is the control strategy     Parameter name  Condition  Description  Default value    Torque compensation point  Torque compensation = On   0°   PCT distance  Torque compensation = On   360°   PVT interval  Torque compensation = On   180°   Delay monitoring  Torque compensation = On   0°   Prevailing torque min  Torque compensation = On  Torque value for the lower limit  1 Nm   Prevailing torque max  Torque compensation = On  Torque value for the upper limit  20 Nm   Compensation value  Torque compensation = On  Selected from a drop-down menu. The parameter options are:  Average torque  Peak torque   "},{"id":"19082937355","fileName":"19082937355.html","title":"Wrench Production Stop Stage Parameters","level":6,"position":78,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","STwrench","Wrench Production Strategy"],"content":"  The parameters shown in the tables are available if one of the STwrench strategies are used. There are several combinations of strategies. Some of the parameters are only available for certain strategies and may not be visible in other strategies. Parameter rules are automatically checked. If a violation occurs, the error indicatoris displayed beside the incorrect parameters. Select the error indicator to display more information about the error.  Switching between strategies can result in the error indicator being shown. This indicates that the chosen combination is invalid, and needs to be corrected.  For more information about the STwrench, see the STwrench User Guide (printed matter number 9836 4134 01).    Parameters in the STwrench loosening step     Parameter name  Condition  Description  Default value    End cycle time   It is applied when torque goes below the cycle start and gets to the third percentage value set on the STwrench LEDs.  100 ms  "},{"id":"19082938891","fileName":"19082938891.html","title":"Wrench Production Loosening Parameters","level":6,"position":79,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","STwrench","Wrench Production Strategy"],"content":"  The parameters shown in the tables are available if one of the STwrench strategies are used. There are several combinations of strategies. Some of the parameters are only available for certain strategies and may not be visible in other strategies. Parameter rules are automatically checked. If a violation occurs, the error indicatoris displayed beside the incorrect parameters. Select the error indicator to display more information about the error.  Switching between strategies can result in the error indicator being shown. This indicates that the chosen combination is invalid, and needs to be corrected.  For more information about the STwrench, see the STwrench User Guide (printed matter number 9836 4134 01).    Parameters in the STwrench loosening step     Parameter name  Condition  Description  Default value    Loosening limit   If this parameter is set to a value greater than 0, Power Focus checks if a negative torque exceeding this value is applied during the tightening. In that case, the overall status of the tightening is marked as Not OK. This function is started when the wrench reaches the Cycle Start (before starting the tightening, a loosening is allowed and does not produce results). This function is used to detect unwanted loosening at the end of a tightening (for instance, when the wrench is disengaged from the joint).  0 Nm  "},{"id":"19083118347","fileName":"1908311834728074246027.html","title":"Wrench Quality Strategy","level":5,"position":80,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","STwrench"],"content":" In this section, you can see the different parameters applicable to the different stages of the Wrench Quality strategy. "},{"id":"19083122059","fileName":"19083122059.html","title":"Wrench Quality Start Stage Parameters","level":6,"position":81,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","STwrench","Wrench Quality Strategy"],"content":"  The parameters shown in the tables are available if one of the STwrench strategies are used. There are several combinations of strategies. Some of the parameters are only available for certain strategies and may not be visible in other strategies. Parameter rules are automatically checked. If a violation occurs, the error indicatoris displayed beside the incorrect parameters. Select the error indicator to display more information about the error.  Switching between strategies can result in the error indicator being shown. This indicates that the chosen combination is invalid, and needs to be corrected.  For more information about the STwrench, see the STwrench User Guide (printed matter number 9836 4134 01).    Parameters in the STwrench start step     Parameter name  Condition  Description  Default value    Tag number    On: after enabling TAG Check switch ( Configurations > Tool Configuration > TAG Check > On), a correct TAG number is required to run the tightening program.  Off: The TAG number is not checked.  Off   Required tag number  Tag number = On  The required TAG number for this tightening program.  1   Direction   The parameter options are CW(clockwise) or CCW(counterclockwise).  CW   Torque correction coefficient   In certain cases extensions may be needed to fit the application. In this case the wrench measurement must be compensated to show a correct value. For more information about to calculate the correction coefficient, see the STwrench User Guide (printed matter number 9836 4134 01). The parameter is stored in the RFID TAG in the End-fitting tool.  1.0   Angle correction   In certain cases extensions may be needed to fit the application. In this case the wrench measurement must be compensated to show a correct value. To calculate the correction coefficient, please refer to the STwrench user guide. The parameter is stored in the RFID TAG in the End-fitting tool.  0°   Linear slope coefficient   Linear slope coefficient characterizes the joint stiffness in the linear part of the curve, as torque\/angle slope in the Nm\/Deg measurement unit.  0.5  The correction coefficients alter the STwrench measurement. It may cause an improper reading. Before making any corrections, refer to the latest version of the STwrench User Guide (printed matter number 9836 4134 01).  "},{"id":"19083144715","fileName":"19083144715.html","title":"Wrench Quality Rundown Stage Parameters","level":6,"position":82,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","STwrench","Wrench Quality Strategy"],"content":"  The parameters shown in the tables are available if one of the STwrench strategies are used. There are several combinations of strategies. Some of the parameters are only available for certain strategies and may not be visible in other strategies. Parameter rules are automatically checked. If a violation occurs, the error indicatoris displayed beside the incorrect parameters. Select the error indicator to display more information about the error.  Switching between strategies can result in the error indicator being shown. This indicates that the chosen combination is invalid, and needs to be corrected.  For more information about the STwrench, see the STwrench User Guide (printed matter number 9836 4134 01).     Rundown completeis in the STwrench documentation defined as Cycle start, this is when the tightening step begins.  Parameters in the STwrench rundown step     Parameter name  Description  Default value    Rundown speed   690 rpm   Rundown complete torque  Definition of the Rundown complete point  Depends on the smarthead minload (usually 5% of nominal torque) in Nm   Ratchet time   5000 ms  "},{"id":"19083152907","fileName":"19083152907.html","title":"Wrench Quality Tightening Stage Parameters","level":6,"position":83,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","STwrench","Wrench Quality Strategy"],"content":"  The parameters shown in the tables are available if one of the STwrench strategies are used. There are several combinations of strategies. Some of the parameters are only available for certain strategies and may not be visible in other strategies. Parameter rules are automatically checked. If a violation occurs, the error indicatoris displayed beside the incorrect parameters. Select the error indicator to display more information about the error.  Switching between strategies can result in the error indicator being shown. This indicates that the chosen combination is invalid, and needs to be corrected.  For more information about the STwrench, see the STwrench User Guide (printed matter number 9836 4134 01).    Parameters in the STwrench tightening step     Parameter name  Condition  Description  Default value    Control strategy   The parameter options are: Yield point, Residual Torque\/Time, Residual Torque\/Angle, Residual Torque\/Peakand Loosen and retighten.    Premature torque loss detection time   From rundown complete, the program may start the tightening with an increase in torque. If the tool detects a decrease in torque within this time frame, a slip-off is reported If the socket slips of the screw head and the measured torque decreases below Rundown complete within the specified time, the tightening is aborted and premature torque loss is reported.  200 ms   Target Torque    Defines the target torque for tightening step.  0 Nm   Torque limits  Target = Torque  Selection made by a switch.  Autoor Manuallyposition.     Torque min  Torque limits = Manual  Torque value for the lower limit  0 Nm   Torque max  Torque limits = Manual  Torque value for the upper limit  0 Nm   Target Angle  Target = Angle or Target=Torque or Angle  Defines the target angle for tightening step.  0°   Angle limits  Target = Angle  Selected from a drop-down menu. The parameter options are:  Autoor Manually. Angle values for max and min can be or selected    Angle limits  Target = Torque  Selected from a drop-down menu. The parameter options are:  Off:No angle limit monitoring.  From rundown complete:The monitoring window is set from when the Rundown complete torqueis reached.  From torque:The monitoring window is set from when the specific torque value is reached.    Final angle monitoring torque   Torque value from when the angle limits are monitored  20 Nm   Angle min  Angle limits = on or manually  Angle value lower limit  324°   Angle max  Angle limits = on or manually  Angle value upper limit  396°   Angle search limit  Angle limits = manually   0   Measure torque at    Selected from a drop-down menu. The parameter options are:  Max torque value  Value at peak angle     NOK on final less than target    Selection made by a switch.  Onor Offposition.  Off   Change bolt limit    50 Nm  Additional parameters in the STwrench tightening step if the strategy is Wrench - Production, and PVT compensate with snug is the control strategy     Parameter name  Condition  Description  Default value    Torque compensation point  Torque compensation = On   0°   PCT distance  Torque compensation = On   360°   PVT interval  Torque compensation = On   180°   Delay monitoring  Torque compensation = On   0°   Prevailing torque min  Torque compensation = On  Torque value for the lower limit  1 Nm   Prevailing torque max  Torque compensation = On  Torque value for the upper limit  20 Nm   Compensation value  Torque compensation = On  Selected from a drop-down menu. The parameter options are:  Average torque  Peak torque   "},{"id":"6258584587","fileName":"625858458728074253451.html","title":"Pulsing Tool Strategies","level":4,"position":84,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":" The strategy can be selected if the controller software version supports the tightening program. Pulsing tools can achieve a higher torque compared to normal rotating tools. "},{"id":"19083163531","fileName":"1908316353128074260875.html","title":"Impulse-Single Step Strategy","level":5,"position":85,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","Pulsing Tool Strategies"],"content":"  The principle below is applicable for direct driven electrical tool. It is applicable to the Atlas Copco SRB series of tools. After each pulse period the resulting torque in the screw is increased. After a series of pulses, the final torque target is reached.  TensorPulse with maximum pulse energy      A  Maximum positive energy in pulse N   B  Maximum positive energy in pulse N+1   C  Increase in energy (torque)  The energy level in the action phase and reaction phase are user configurable parameters. The combination of these two parameters creates an efficient tightening combined with operator comfort. It is possible to set the amount of energy in the two phases as a percentage of the maximum energy that can be delivered in each period:   Pulse energy; The amount of energy that is applied to each positive pulse as a percentage of the maximum energy that can be applied in the pulse period. The value is between 10-100%.   Reaction force retention factor; The amount of energy that is applied to each reactive pulse as a percentage of the maximum energy that can be applied in the pulse period. The value is between 0-75%.  TensorPulse with reduced positive pulse energy      A  Reduced positive energy in pulse N   B  Reduced positive energy in pulse N+1   C  Resulting curve for torque build up using maximum pulse energy.   D  Resulting curve for torque build up using reduced pulse energy.   A small Pulse energy(reduced energy) requires more pulses to reach the target torque as the torque is increased in smaller steps. Smaller steps provides better accuracy to terminate the tightening when the target is reached. Smaller pulses decrease tool movement and increases operator comfort.  A correctly tuned Reaction force retention factorwill create the desired operator comfort. If the factor is too high the operator feels a clockwise rotation of the tool. If the factor is too low, the operator feels a counter clockwise rotation of the tool.  In an ideal configuration, the reaction energy does not create any loosening force. If the amount of pulses to reach the target value increases, the value is set too high and a small loosening occurs at each pulse.  The optimum values for the Pulse energyand the Reaction force retention factorneed to be tuned for optimum performance of the tool and for best operator comfort.   "},{"id":"19083179659","fileName":"19083179659.html","title":"Impulse Single-Step Start Stage Parameters","level":6,"position":86,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","Pulsing Tool Strategies","Impulse-Single Step Strategy"],"content":" During the start stage, the tool rotates in a speed mode without any pulsing.      Parameter name  Description  Default Value    Soft start  Enables setting of the tool’s speed, angle and maximum torque to facilitate the bolt entering the thread. Selected by radio buttons.  Off: Soft start is turned off.  On:Soft start is turned on.  Off   Speed  Defines the speed during the soft start.  300 rpm   Time  Defines the Soft startduration.  400 ms   Rehit detection   Early:Terminates the tightening immediately when an already tightened screw\/bolt is detected. The tightening will be considered as NOK. Requires that Soft startis activated.  Complete:Even though an already tightened screw\/bolt is detected, the tightening is not terminated until all tightening steps have been executed. The tightening will be considered as NOK. To make a rehit detection when Soft startis not activated, the Rehit detection Completeoption must be selected. Rehit detection Completewill not terminate the tightening until all tightening steps have been executed. The tightening will be considered a rehit if the speed fails to reach half the rundown speed, a rehit error is then indicated.  Off:No rehit detection will be performed. Combination Soft start = Off and Rehit = Early is not allowed.  Off   Use attachment tuning  Attachment tuning is selected by radio buttons.  No   Gear ratio  Socket rotation speed = Tool speed \/ gear ratio.  1.00   Efficiency tuning  For example 0.9 means 10% efficiency loss.  1.00"},{"id":"19083194379","fileName":"19083194379.html","title":"Impulse Single-Step Rundown Stage Parameters","level":6,"position":87,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","Pulsing Tool Strategies","Impulse-Single Step Strategy"],"content":" During rundown, the tool can use either speed mode, with a constant motor speed, or pulse mode. The selection is made depending on the encountered torque and the given torque limits within the configuration.      Parameter name  Condition  Description  Default value    Rundown speed   Selected by radio buttons. Rundown speed can be selected between Maxor Manual.  Max   Rundown speed  Rundown speed = manual  Specifies the tool speed during the rundown step.  0 rpm   Rundown time limits   Selected from a shortcut menu:  Off: Rundown time limitsis turned off.  From Trigger: Rundown time limitsis turned On. The system starts to monitor the time as soon as the tool trigger is pressed and reports if the time limits are violated.  From torque: Rundown time limitsis turned On. The system starts to monitor the time from the specified torque value and reports if the time limits are violated.  Off   Rundown time monitoring torque  Rundown time limits = from torque  Torque value from where Rundown time limitsmonitor starts.  2.5 Nm   Time min  Rundown time limits = On  Minimum allowed time for rundown.  10ms   Time max  Rundown time limits = On  Maximum allowed time for rundown.  5000ms   Rundown pulse limits   Selected from a shortcut menu:  Off: Rundown pulse limitsis turned off.  From Trigger: Rundown pulse limitsis turned On. The system starts to monitor the pulses as soon as the tool trigger is pressed and reports if the pulse limits are violated.  From torque: Rundown pulse limitsis turned On. The system starts to monitor the pulses from the specified torque value and reports if the pulse limits are violated.  Off   Rundown pulse monitoring torque  Rundown pulse limits = from torque  Torque value from where the Rundown pulse limitsmonitor starts.  2.5 Nm   Pulses min  Rundown pulse limits = On  Minimum number of pulses to reach the target.  2   Pulses max  Rundown pulse limits = On  Maximum number of pulses to reach the target.  50   Rundown complete torque    Defines the torque value for when snug is reached and rundown is completed.  5 Nm"},{"id":"19083195915","fileName":"19083195915.html","title":"Impulse Single-Step Tightening Stage Parameters","level":6,"position":88,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","Pulsing Tool Strategies","Impulse-Single Step Strategy"],"content":"      Parameter name  Condition  Description  Default value    Pulse Energy   The Pulse energydelivered in the action pulse expressed in a percentage of the maximum energy the tool can deliver in each pulse.  100%   Residual torque correlation factor   The term Residual torque correlation factor is similar to a calibration and adjusts between the dynamic torque, measured in the electrical tool, and the residual torque, measured by a control tool.  100%   Premature torque loss detection time   A constant increase in torque is assumed when moving from rundown to tightening. A socket slip of, or a broken screw head can cause the torque decrease. This may be detected in a monitoring window.  200 ms   Target torque   Final target torque for the tightening.  0 Nm   Torque limits   Selected by radio buttons. Limits can be Automaticallyor Manuallyselected  Manually   Torque min  Torque limits = manual  Minimum torque for the step.  0 Nm   Torque max  Torque limits = manual  Maximum torque for the step.  1 Nm   Angle limits    Off: Angle limitsis turned off.  From Rundown complete: Angle limitsis turned On. The system starts to monitor the tightening angle as soon as Rundown completeis reached and reports if angle limits are violated.  From torque: Rundown angle limitsis turned On. The system starts to monitor the tightening angle from the specified torque value and reports if angle limits are violated.  Off   Final angle monitoring torque   Torque value from where Angle limitsmonitoring starts.  20 Nm   Angle min   Angle value for lower angle limit from the starting point.  0°   Angle max   Angle value for the upper angle limit from starting point.  0°   Time limits   Selected from a shortcut menu:  Off: Time limitsis turned off.  From rundown complete: Time limitsis turned On. The system starts to monitor the time as soon as rundown completeis reached and reports if the time limits are violated.  From torque: Time limitsis turned On. The system starts to monitor the time from the specified torque value and reports if the time limits are violated.  Off   Time monitoring torque  Time limits = from torque  Torque value from where the Time limitsmonitor starts.    Time min  Time limits = On  Minimum allowed time for tightening.  10ms   Time max  Time limits = On  Maximum allowed time for tightening.  1000ms   Pulse limits   Selected from a shortcut menu:  Off:No pulse limit monitoring.  From rundown complete:The monitoring starts when the Rundown complete torqueis reached and reports if the number of pulses is outside the limit.  From torque:The monitoring starts when the specific torque value is reached and reports if the number of pulses is outside the limit.  Off   Final pulse monitoring torque  Pulse limits = from torque  Torque value from when the pulse limits are monitored.  18.75 Nm   Pulses min  Pulse limits = on  Minimum number of pulses to reach the final target.  2   Pulses max  Pulse limits = on  Maximum number of pulses to reach the final target.  50"},{"id":"19083197451","fileName":"19083197451.html","title":"Impulse Single-Step Loosening Parameters","level":6,"position":89,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","Pulsing Tool Strategies","Impulse-Single Step Strategy"],"content":"  Loosening parameters     Parameter name  Description  Default value    Loosening enabled   Off:Loosening is disabled.  On:Loosening is enabled and additional parameters can be configured.  On   Detection torque   Auto:The value is set based on the tool type and the tool capability.  Manual:The value is set manually.  Auto   Detection torque  The minimum torque required to begin performing a loosening operation and produce a loosening result.  3.5 Nm   Run-up torque   Auto:The value is set based on the tool type and the tool capability.  Manual:The value is set manually.  Auto   Run-up torque  When the torque falls below Run-up torque, the loosening is considered to be OK.  Depending on variations in screw length, the system cannot determine when the screw has been run up completely. This is for the operator to decide.  1.75 Nm   Loosening speed  Loosening speed will be attained when Run-up torqueis reached.  Max:The value is set to maximum.  Manual:The value is set manually.  Max   Loosening speed  Visible if Loosening speedis set to Manual  1 rpm"},{"id":"19083161995","fileName":"1908316199528074268299.html","title":"TensorPulse Strategy","level":5,"position":90,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","Pulsing Tool Strategies"],"content":"   Before using TensorPulsetightening step, it is mandatory that the following license type is installed on the controller:   Low Reaction Strategies   TensorPulseis valid only for the following tools: ETV-STR61-100-13, ETV-STR61-70-13 and ETV-STR61-50-10. This step generates tightening pulses in the forward direction, until the torque target is reached. If running TensorPulsetightening step, use the necessary PulseDrive socket\/adapter. If TensorPulsetightening step runs without the PulseDrive socket\/adapter, all the tightenings are NOK. The step error “PulseDrive socket\/adapter not detected” shows for no PulseDrive socket\/adapter.  The principle below is applicable for direct driven electrical tools. It is applicable to the Atlas Copco SRB series of tools.  The pulse tightening uses a technique of pulsing the electrical current in the motor and has two distinct features:  An action current that adds positive torque in the tightening direction.  A reaction current that creates a comfort reaction by applying a reverse torque.  Pulse tightening principle      A  Action pulse to apply tightening force.   B  Reaction pulse for comfort  The figure shows the general principle of a current pulse tightening strategy. The detailed curve depends on the tool type and the tightening algorithm. The pulse period consists of two phases as shown in the figure with an action current and a reaction current. Each action pulse adds torque to the tightening until the final target is reached. Each reaction pulse creates a counterforce that provides a comfortable reaction. The energy level of the action phase and the reaction phase are configurable parameters. The combination of these two parameters creates an efficient tightening combined with operator comfort.  "},{"id":"19085455883","fileName":"19085455883.html","title":"TensorPulse Start Stage Parameters","level":6,"position":91,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","Pulsing Tool Strategies","TensorPulse Strategy"],"content":" During the start stage, the tool rotates in a speed mode without any pulsing.      Parameter name  Description  Default Value    Direction  The parameter options are CW(clockwise) or CCW(counterclockwise).  CW   Soft start  Enables setting of the tool’s speed, angle and maximum torque to facilitate the bolt entering the thread. Selected by radio buttons.  Off: Soft start is turned off.  On:Soft start is turned on.  Off   Speed  Defines the speed during the Soft Start.  300 rpm   Angle  Defines the angle during the Soft Start.  90°   Torque max  Defines the maximum torque during the Soft Start.  1.25 Nm   Rehit detection   Early:Terminates the tightening immediately when an already tightened screw\/bolt is detected. The tightening will be considered as NOK. Requires that Soft startis activated.  Complete:Even though an already tightened screw\/bolt is detected, the tightening is not terminated until all tightening steps have been executed. The tightening will be considered as NOK. To make a rehit detection when Soft Startis not activated, the Rehit detection Completeoption must be selected. Rehit detection Completewill not terminate the tightening until all tightening steps have been executed. The tightening will be considered a rehit if the speed fails to reach half the rundown speed, a rehit error is then indicated.  Off:No rehit detection will be performed. Combination Soft start = Off and Rehit = Early is not allowed.  Off   True angle compensation  Switch with Onor Offposition.  Off   Tool movement limits  Only visible if True angle compensationis set to On. Defines the rotation limits of the tool.    Negative  Only visible if True angle compensationis set to On. Defines the maximum negative rotation of the tool. If the value is exceeded the tightening is terminated and an error is reported. This is expressed in a numeric angle value.  30   Positive  Only visible if True angle compensationis set to On. Defines the maximum positive rotation of the tool. If the value is exceeded the tightening is terminated and an error is reported. This is expressed in a numeric angle value.  30   Use attachment tuning  Attachment tuning is selected by radio buttons.  No   Gear ratio  Socket rotation speed = Tool speed \/ gear ratio.  1.00   Efficiency tuning  For example 0.9 means 10% efficiency loss.  1.00"},{"id":"19085461259","fileName":"19085461259.html","title":"TensorPulse Rundown Stage Parameters","level":6,"position":92,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","Pulsing Tool Strategies","TensorPulse Strategy"],"content":" During rundown, the tool can use either speed mode, with a constant motor speed, or pulse mode. The selection is made depending on the encountered torque and the given torque limits within the configuration.      Parameter name  Condition  Description  Default value    High-speed rundown   The rundown step can be done in high-speed in order to minimize the time, without overshooting. This is achieved by letting the tool run at a higher speed for a specified angle length. When the angle has been reached, the speed will change to the lower speed specified in Rundown speedparameter. Only available for SRBtools. The parameter options are Onor Off  Off   Length   Angle defining the High-speed rundownsection. Max 99999°  3600°   Speed    Tool max speedmust be higher than Rundown speed(rpm).  690 rpm   Rundown speed   Selected by radio buttons. Rundown speed can be selected between Maxor Manual.  Max   Rundown speed  Rundown speed = manual  Specifies the tool speed during the rundown step.  690 rpm   Rundown torque limits    Rundown torque limitsis activated through a switch  Off:Rundown torque limits is turned off.  On:Rundown torque limits is turned on.  Off   Offset  Rundown torque limits = On  Angle offset before the Angle interval begins.  0°   Length  Rundown torque limits = On  Angle defining the Rundown torque limit section.  360°   Torque min  Rundown torque limits = On  Torque value for lower Rundown torque limit.  0 Nm   Torque max  Rundown torque limits = On  Torque value for upper Rundown torque limit.  4.75 Nm   Rundown angle limits    Off:Rundown angle limits is turned off.  From Trigger:Rundown angle limits is turned On. The system starts to monitor the tightening angle as soon as the tool trigger is pressed and reports if angle limits are violated.  From torque:Rundown angle limits is turned On. The system starts to monitor the tightening angle from the specified torque value and reports if angle limits are violated.  Off   Rundown angle monitoring torque   Torque value from where Rundown angle limitsare set.  0 Nm   Angle min   Angle value for lower angle limit from starting point.  100°   Angle max   Angle value for upper angle limit from starting point.  5000°   Time min  Visible if Rundown Angle limits =From Trigger or if Rundown Angle limits=From Torque  Minimum time for the step.  10 ms   Time max  Visible if Rundown Angle limits =From Trigger or if Rundown Angle limits=From Torque  Maximum time for the step.  5000 ms   Rundown complete torque   Defines the torque value for when snug is reached and rundown is completed.  5 Nm"},{"id":"19085465867","fileName":"19085465867.html","title":"TensorPulse Tightening Stage Parameters","level":6,"position":93,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","Pulsing Tool Strategies","TensorPulse Strategy"],"content":"      Parameter name  Condition  Description  Default value    Pulse Energy   The Pulse energydelivered in the action pulse expressed in a percentage of the maximum energy the tool can deliver in each pulse.  100%   Reaction force tuning factor   The energy delivered by the tool expressed in a percentage value. The reaction force tuning factor is based on the action energy and results in a comfortable reaction.  40%   Residual torque correlation factor   The term Residual torque correlation factor is similar to a calibration and adjusts between the dynamic torque, measured in the electrical tool, and the residual torque, measured by a control tool.  100%   Premature torque loss detection time   A constant increase in torque is assumed when moving from rundown to tightening. A socket slip of, or a broken screw head can cause the torque decrease. This may be detected in a monitoring window.  200 ms   Target torque   Final target torque for the tightening.  0 Nm   Torque limits   Selected by radio buttons. Limits can be Automaticallyor Manuallyselected  Manually   Torque min  Torque limits = manual  Minimum torque for the step.  0 Nm   Torque max  Torque limits = manual  Maximum torque for the step.  1 Nm   Angle limits    Off: Angle limitsis turned off.  From Rundown complete: Angle limitsis turned On. The system starts to monitor the tightening angle as soon as Rundown completeis reached and reports if angle limits are violated.  From torque: Rundown angle limitsis turned On. The system starts to monitor the tightening angle from the specified torque value and reports if angle limits are violated.  From Rundown complete   Final angle monitoring torque   Torque value from where Angle limitsmonitoring starts.  20 Nm   Angle min   Angle value for lower angle limit from the starting point.  0°   Angle max   Angle value for the upper angle limit from starting point.  0°   Time min  Time limits = On  Minimum allowed time for tightening.  10ms   Time max  Time limits = On  Maximum allowed time for tightening.  1000ms   Pulse limits   Selected from a shortcut menu:  Off:No pulse limit monitoring.  From rundown complete:The monitoring starts when the Rundown complete torqueis reached and reports if the number of pulses is outside the limit.  From torque:The monitoring starts when the specific torque value is reached and reports if the number of pulses is outside the limit.  Off   Final pulse monitoring torque  Pulse limits = from torque  Torque value from when the pulse limits are monitored.  18.75 Nm   Pulses min  Pulse limits = on  Minimum number of pulses to reach the final target.  2   Pulses max  Pulse limits = on  Maximum number of pulses to reach the final target.  50   Measure angle to  Angle limits = on  Selected from a shortcut menu:  Value at peak torque: Measures the angle value at the maximum torque during the tightening.  Max angle value: Measures the maximum angle value during the tightening.  Value at Shutoff: Measures the angle value before starting the stop stage.  Max angle value"},{"id":"19085470859","fileName":"19085470859.html","title":"TensorPulse Loosening Parameters","level":6,"position":94,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","Pulsing Tool Strategies","TensorPulse Strategy"],"content":"  Loosening parameters     Parameter name  Description  Default value    Loosening enabled   Off:Loosening is disabled.  On:Loosening is enabled and additional parameters can be configured.  On   Detection torque   Auto:The value is set based on the tool type and the tool capability.  Manual:The value is set manually.  Auto   Detection torque  The minimum torque required to begin performing a loosening operation and produce a loosening result.  3.5 Nm   Run-up torque   Auto:The value is set based on the tool type and the tool capability.  Manual:The value is set manually.  Auto   Run-up torque  When the torque falls below Run-up torque, the loosening is considered to be OK.  Depending on variations in screw length, the system cannot determine when the screw has been run up completely. This is for the operator to decide.  1.75 Nm   Loosening speed  Loosening speed will be attained when Run-up torqueis reached.  Max:The value is set to maximum.  Manual:The value is set manually.  Max   Loosening speed  Visible if Loosening speedis set to Manual  1 rpm"},{"id":"60982027","fileName":"60982027.html","title":"Rotate","level":4,"position":95,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":" The Rotate strategy is primarily a strategy for testing and demonstration purposes. When the tool is allowed to rotate freely, it turns the socket the specified angle using the lowest torque possible.      Parameter  Description  Default value    Target speed  Target speed for the Rotate strategy.     <Target speed>  Manual tool speed during the Rotate strategy.  16.5% of Tool max speed   Target angle  Angle to turn the spindle.  360°"},{"id":"4488377355","fileName":"448837735528074282635.html","title":"External Result","level":4,"position":96,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":" External result is a strategy used when an OK tightening is indicated by an external digital signal (and not by torque or angle values measured during tightening). When the signal is sent, the Result view will show the value of the Target parameter provided in the tightening program (specified torque value, angle value, or text string). These (torque and angle) values do not represent actual measured values, but only inserted text.      Parameter  Description  Default value    Torque <Target torque>  Numerical value for desired displayed target torque value  0.00   Angle <Target angle>  Numerical value for desired displayed target angle value  360°   Text  Alphanumerical string for desired displayed text.   "},{"id":"19481899659","fileName":"19481899659.html","title":"Running the External Result Tightening Strategy with a Tool Connected","level":5,"position":97,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","External Result"],"content":"    On the home view, go to the Tighteningtab. Then, create a tightening program with External Resultstrategy.  Return to the home view and select the Virtual Stationtab.  On the Licenseswindow, the External Result Tightening Strategy with a Tool Connectedfeature requires a license to be assigned and used by a virtual station.  On the Toolwindow, select the necessary tool. Then, select the tool configuration.  On the Taskwindow, select the tightening program with an External Resultstrategy.  Send EXTERNAL_OKsignal to the Virtual Station.  Select the Go Resultbutton to display the results. Results are sent from the Tool configuration for the tool connected to the Virtual Station. "},{"id":"19481908107","fileName":"19481908107.html","title":"Running the External Result Tightening Strategy without a Tool Connected","level":5,"position":98,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","External Result"],"content":"    On the home view, select the Tighteningtab. Then, create a tightening program with External Resultstrategy.  Return to the home view and select the Settingstab. Then, select External Tool.  Select the plusicon in the upper-right corner of the screen to create an external tool.  It is possible to create up to ten External Tool configurations.  On the External Toolwindow, enter the model, the serial number and the description of the external tool.  Serial Number is a mandatory text box. The serial number can be used to provide an identifier for the necessary tool, for example the manufacturer serial number. The maximum number of characters for the Serial Number text box is 32.  Once the switch in the upper-right corner of the External Toolwindow is set to On, return to the home view and select the Tooltab. The added external tool appears on the list of the available tools.  Return to the home view and select the Virtual Stationtab.  On the Licenseswindow, the External Result Tightening Strategy without a Tool Connectedfeature requires a license to be assigned and used by a virtual station.  On the Toolwindow, select the necessary external tool. Then, select the tool configuration.  On the Taskwindow, select the tightening program with an External Resultstrategy.  Send EXTERNAL_OKsignal to the Virtual Station.  Select the Go Resultbutton to display the results (serial numbers). Serial numbers are sent from the External Tool configuration for the tool connected to the Virtual Station. "},{"id":"61978763","fileName":"6197876328215426827.html","title":"Tightening Program and Error Reporting Validation","level":4,"position":99,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":" The tightening program automatically validates with the parameter rules and tool properties as soon as new values are entered or changes are made. If the validation detects any errors, they are reported with an error description. "},{"id":"19429276683","fileName":"19429276683.html","title":"Validation Error Reporting","level":5,"position":100,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","Tightening Program and Error Reporting Validation"],"content":" If the validation gives an error, the error is displayed with an icon next to the parameter or parameters causing the error. When you tap on the icon, a short description of the error is given.  Example(See image):     Target torqueis set to 35 Nm with Final torque limits set to Torque min15 Nm and Torque max30 Nm.  When you tap on the validation error icon next to the Torque maxparameter, a short description of the error is given, saying that Target torqueis greater than Torque max(Torque max <= Target torque).  To fix the error, adjust the Torque maxvalue so that it is greater than Target torque, and the error icon will disappear.  "},{"id":"18222964363","fileName":"18222964363.html","title":"Validate a Tool with a Tightening Program","level":5,"position":101,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","Tightening Program and Error Reporting Validation"],"content":"    On the home view, go to the Tighteningtab. If required, select a specific program in the list.  Validation can be performed both for the entire list of programs, or for individual programs.  Select the Validate Programicon in the upper-right corner of the screen.  In the pop-up window, choose the tool to validate the tightening program against, and select Validate.  If a tightening program is not compatible with the selected tool, it will be indicated by a red circle with an exclamation point."},{"id":"18794847499","fileName":"18794847499.html","title":"Tightening Program Tool Compatibility Table","level":4,"position":102,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":"   The availability of tightening strategies depends on the licenses installed on the controller.      Tightening Strategies  ES  ST  STR  SR  SB  ETT  SL (low voltage)  QST  STB  SRB 2.0 ETP-SRB31-20  SRB 2.1 ETP-SRB31-25  SRB-HA  TBP \/ TBP-S  STW  External tool    Two step  X  X  X  X  X  X  X  X  X  X  -  X  -  -  -   Quick step  X  X  X  X  X  X  X  X  X  X  X  X  -  -  -   Three step  X  X  X  X  X  X  X  X  X  X  -  X  -  -  -   Turbo Tight  X  -  X  -  -  X  -  -  -  X  X  -  -  -  -   Rotate  X  X  X  X  X  X  X  X  X  X  -  X  -  -  -   External Result  X  X  X  X  X  X  X  X  X  X  X  X  X  -  X   Tensor Pulse  -  -  -  -  -  -  -  -  -  X  X  -  -  -  -   Impulse - single step  -  -  -  -  -  -  -  -  -  -  -  -  X  -  -   Wrench production  -  -  -  -  -  -  -  -  -  -  -  -  -  X  -   Wrench quality  -  -  -  -  -  -  -  -  -  -  -  -  -  X  -      Tightening Features  ES  ST  STR  SR  SB+  ETT  SL (low voltage)  QST  STB  SRB 2.0 ETP-SRB31-20  SRB 2.1 ETP-SRB31-25  TBP \/ TBP-S  STW  External tool    True Angle  -  -  X  -  -  X  -  -  -  -  -  -  -  - "},{"id":"18740215947","fileName":"1874021594729398409739.html","title":"Multistep Programs","level":3,"position":103,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab"],"content":"  Risk of injury  A change in the configuration of the tightening program may cause unexpected torque, rotational direction, or speed in the system(s) where the tightening program is currently in use. This could result in severe bodily injury and\/or property damage.   Check the tightening program configurations after adding a new program or after applying changes to an existing program.   Controller features, such as the Low Reaction Tightening Strategies and controller-wide functions among others, require licenses distributed through the Functionality Management System (FMS). Whereas configuration of features is possible without specific licenses, the assignment and use of those features will require the correct license to be installed on the controller. Please refer to Licenses (FMS) for more detailed information on licenses.  A multistep tightening is a tightening done in several steps. The number of steps and the type of steps vary depending on the tightening to be done. A multistep tightening program is highly configurable, including monitoring function and restrictions. To access multistep tightening programs, go to the Tighteningtab in the home view and select Multistep Program Libraryon the left pane. "},{"id":"19036594187","fileName":"19036594187.html","title":"Multistep GUI","level":4,"position":104,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs"],"content":"  While multistep tightening programs can be selected from the controller display, editingprograms can only be done in the web GUI.  Tightening and multistep programs that appear dimmed indicate that they are Global Programs distributed from ToolsTalk. These programs cannot be changed via the controller GUI. Global programs can only be modified through ToolsTalk. Refer to the ToolsTalkuser documentation for more information. The interface for mutistep programs can be divided into three main areas.  On topthere is a drop-down menu containing the Properties of the multistep tightening program. Here general properties such as program name, overall program monitor and validation can be filled out.  To the rightthere are four tabs containing the steps, monitors, restrictions and reporters that can be used to build the multistep program. To use any of the items, click on the appropriate tab, and drag the item in the list to the tightening area. Depending on its function, either drop the item between the beginning and the end of the program (for steps), or on top of a particular step (for monitors and restrictions). The main area of the interface is the tightening area. This is the area that includes all the steps in the tightening program. Scroll the mouse wheel to zoom in and out on the tightening area. At bottom left of the screen there is a Copy Tightening Programbutton and a Delete Tightening Programbutton."},{"id":"22163558155","fileName":"2216355815529398416907.html","title":"Tightening Steps","level":4,"position":105,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs"],"content":"   The availability of tightening steps, monitors and restrictions depends on the license installed on the controller. General Parameters The following step parameters are common for many of the step types. The parameters are set in the step properties window which is displayed when selecting a step in the tightening program.      Parameter  Description     Name  Name of the step.    Rotational direction  Each of the tightening steps can run either forward, that is to make a tightening, or reverse, to loosen the screw slightly. The arrows indicate this direction. Many of the tightening steps have a direction hard-coded to forward, for example Tighten to Angle, or Tighten to Torque. Steps such as Loosen to Angleor Loosen to Torquehave their direction automatically set to reverse.  The reversesetting is not allowed for tools configured with Gear Front Attachment (GFA) of type open end. The tightening direction of the tightening program must be the same as the tightening direction of the open end tool for a tightening to be allowed to be run. It is possible to assign a loosening program to a tightening program for an open end tool, but if the direction switch is set to run the loosening program, the tool will be locked.    Step category  For each step, there is an option to choose a step category. By selecting step category, the NOK tightenings will be listed in the event result view with related detailed status together with the corresponding multistep error information. If no selection is made, the detailed status will be set to uncategorized multistep error. The related detailed status can be customized.    Angle window  A joint is considered Hardif the screw is tightened to its full torque and it rotates 30 degrees (or less) after it has been tightened to its snug point. A Softjoint rotates 720 degrees or more after it has been tightened to its snug point. The hardness parameter defines the Angle Windowfor the gradient calculation. The harder the joint - the smaller the angle window.    Speed Ramp \/ Acceleration (only available in ToolsTalk 2)  For most of the steps it is possible to specify how the acceleration to the target speed should be achieved. Three different settings are possible; Hard, Soft and Manual. The acceleration defined will be used whenever a step is started. Regardless whether the tool is already running with speed at the beginning of the step, the ramp will be used to accelerate to the target speed of the step. This will be the case even if the speed at the start of the step is higher, or lower than the target speed.    Speed ramp - Hardand Softmode     Hard:2000 rpm\/s (Speed Ramp between 1000 and 10000 rpm\/s is a Hard acceleration.)   Soft:500 rpm\/s (Speed Ramp between 200 and 1000 rpm\/s is a Soft acceleration.)    Speed ramp - Manualmode    Speed:   Default value: 60 rpm  Minimum limit: > 0  Maximum limit: ≤ Tool Max Speed  Acceleration:   Default value: 500 rpm\/s  Minimum limit: > 0  Maximum limit: ≤ Tool Max Acceleration    Using speed shifts  1−5 angle triggers or torque triggers can be defined during a step, where the speed will shift. Within one step, all the speed shift triggers are based on the same property, that is either torque or angle. They cannot be mixed within one step. The Torque triggers and Angle triggers must be less than the step target, depending on the type of the step and the trigger type. The Torque trigger and Torque speed also validate against the Max torque and Max speed of the tool. A warning or error indicator occurs whenever the Speed Shift settings exceed either the tool max values, or step max values. The Torque triggers and Angle triggers must be less than the step target, depending on the type of the step and the trigger type. The Torque trigger and Torque speed also validate against the Max torque and Max speed of the tool. A warning or error indicator occurs whenever the Speed Shift settings exceed either the tool max values, or step max values.  It is possible to push the settings to the tool when a tightening program has a warning, but not when a tightening program has an error (fault) indicator. The speed shifts can be added in the Configurationfield. To add a speed shift: In the dialog box of a step that can have speed shifts, select Add speed shift. Then, select an angle range or a torque range. The Speed Shift Angle\/Torque fields open. Add values according to the table below:    Angle\/Torque trigger: Must be > 0  Speed: Must be > 0  Speed ramp type: Hard or soft    Brake type  The braking behavior of a multistep tightening program can be controlled at two possible locations in the program: in a step preceding a reversal of direction of the tightening, and\/or at the final step of the tightening program. At other locations in the tightening program, the braking parameters will not be available in the step's general settings. Braking can be set to either Ergo stopor Inertia. Inertiawill brake the tool completely, while Ergo stopwill allow for a more ergonomic slowing down of the tightening.  Inertiahas no additional parameters.  Ergo stopparameters:    Adaptive brake:Set the Adaptive Brake to Onor Off   Ramp time:Only available when Adaptive Brake is set to Off. Insert time in ms.    Exclude in MCT mode  The Exclude in MCT modeoption can be turned on for steps in a Multistep program. When using the MCT mode for a Multistep program, steps with Exclude in MCT modeturned on will be excluded. Setting the Exclude in MCT modeoption to on in such a way that there is no break before a wait step or direction switch will result in an error in runtime when in MCT mode. Termination Paths and Repair paths are ignored on fixtured systems, i.e. if they are triggered the tightening will be marked as NOK MC tightening.  MCT mode is only to be used when testing. Make sure MCT mode is disabled before returning the tool to the production line.  The following tightening steps are not supported for tools configured with Gear Front Attachment (GFA) of type open end:   A - Tighten to Angle \/ Loosen to Angle  TrR - Loosen to Trigger Release  T - Tighten to Torque \/ Loosen to Torque  E - Engage  SR - Socket Release  DT - Tighten to DynaTork  TPT - TensorPulse Tighten to Torque \/ Loosen to Torque  IT - Impulse Tighten to Torque \/ Loosen to Torque  IA - Impulse Tighten to Angle \/ Loosen to Angle  AP - Adaptive Pulse  ITrR - Impulse Loosen to Trigger Release Trace Settings When the trace configuration is enabled on the program level, the trace resolution can be configured on step level. The setting for Trace Settingdefines how the sampling should be done on each specific step.      Parameter  Description     Trace Setting     Program: Use the settings as defined on program level.   Manual: The trace sample type from the program level will be used, that is, Time or Angle. Using a different sample rate will override the setting on the program level.    Sample Time  Choose the sample time from the drop-down list (0.25 - 1000 ms)    Sample Angle  Choose the sample angle from the drop-down list (0.25 - 20 degree) With this trace recording the sample rates will not be the same in all the steps, instead the sample rate depends on the configuration in each step. This means the trace is divided into one trace for each step. The maximum number of samples in a trace is 4096. If a tightening produce more than 4096 values a down-sampling will take place. This is done by removing every second trace sample from the whole tightening and when continue the recording with half the resolution. This process will be repeated every time the 4096 sample limit is reached. If more than 2048 in total was recorded, this process will result in a trace between 2048 and 4096 samples. If the limit if 4096 samples is reached the configured trace sample times will no longer be followed. Instead the sample times will be doubled or quadrupled etc., depending on how many times the down sampling has taken place. Since all steps are down sampled the relation between the steps will still be the same though. If a step was configured with double sample time compared to another step, this will still be the case in the final trace regardless how many times a down-sampling has occurred.      Trace channel  Note    Torque  Available for all tools equipped with a torque transducer   Angle  Available for all tools   Torque Second  Only available for tools with two torque transducers   Angle Second  Only available for tools with two angle transducers   Current  Available for all tools   Gradient  Available if some step\/restriction\/monitor produces the gradient values   Available tools for each system type     Power Focus 6000 \/ Power Focus 8  Power Focus 6000 Synchronized tightening \/ Power Focus 8 Synchronized tightening  Flex  IxB    ST  ST  QST  IxB   STR  STR     SL  QST     QST      STB      IxB      Power Focus Connect      XB         Tightening Steps  Tools     title-item   list "},{"id":"21408791307","fileName":"21408791307.html","title":"A – Tighten to Angle \/ Loosen to Angle","level":5,"position":106,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB IXB  A – Tighten to Angle This step runs the tool until the target angle is reached. The target angle is measured from the start of the step.  A – Loosen to Angle This step runs the tool with the speed n in the backward direction until the angle target is reached. The target angle is measured from the start of the step.  This step is not supported for tools configured with Gear Front Attachment (GFA) of type open end.   Parameters     Parameter  Description     Target angle  The angle target. Must be > 0.    Speed  Default: 60 rpm.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Speed ramp  If Speed ramp type is Manual, this field opens. Default: 500 rpm\/s.    Brake (Valid only for Power Focus 6000 Synchronized tightening, Power Focus 8 Synchronized tightening and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.       A  Target Angle Microvideo  A - Tighten to Angle \/ Loosen to Angle   "},{"id":"21408789771","fileName":"21408789771.html","title":"DI – Run Until Digital Input","level":5,"position":107,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST This steps runs the tool, in the direction defined by parameter Direction, until the input specified by Digital Inputgoes high or low depending on the value of Stop Condition.      Parameter  Description     Direction  Forward, or Backward    Digital Input  One of the following local digital inputs on the controller can be selected:   Local DI 1  Local DI 2  Local DI 3  Local DI 4    Brake (Valid only for Power Focus 6000 Synchronized tightening, Power Focus 8 Synchronized tightening and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.    Stop Condition     Falling edge: The steps runs until a falling edge is detected after step start.   Rising edge: The steps runs until a rising edge is detected after step start.   Any edge: The step runs until a falling or a rising edge is detected after step start.   Low: The step runs until low value is detected.   High: The step runs until high value is detected.    Speed (rpm)  Default: 60 rpm.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Speed ramp  Available if Speed ramp typeis Manual. Default: 500 rpm\/s. Microvideo  DI - Run Until Digital Input  "},{"id":"21408857611","fileName":"21408857611.html","title":"DT – Tighten to DynaTork","level":5,"position":108,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB IXB  This step is not supported for tools configured with Gear Front Attachment (GFA) of type open end. This step runs the tool with speed n in the forward direction until the Target torqueis reached. The tool will then hold the current constant at the DynaTork Percentageof Target torqueduring the DynaTork time.  To avoid overheating of the tool, it is strongly recommended to never run DynaTork to more than 40% of the maximum torque of the tool.      Parameter  Description     Target torque  The torque target. Must be > 0.    DynaTork Time  The time DynaTork will be active.    DynaTork Percentage  The percentage of Torque target.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Speed ramp  If Speed ramp type is Manual, this field opens. Default: 500 rpm\/s.    Speed (rpm)  Default: 60 rpm.    Brake (Valid only for Power Focus 6000 Synchronized tightening, Power Focus 8 Synchronized tightening and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.       A  Target Torque   B  Torque level retained during DynaTork Time   C  Percentage of Ts   D  Percentage of Ts   E  Torque level retained during DynaTork Time   F  DynaTork Time Microvideo  DT - Tighten to DynaTork   "},{"id":"21408893195","fileName":"21408893195.html","title":"E - Engage","level":5,"position":109,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST IXB  This step is not supported for tools configured with Gear Front Attachment (GFA) of type open end. This step runs the tool in both directions until the socket engages the screw. The step continues until Target torqueor Target angleis reached, provided that Continue if not Engagedis set to Yes. If Target Angle is reached in any direction, the direction is reversed. Limit the search iterations by entering Max Engage Attempts. If Target Torque is reached in any direction the step will finish with OKstatus. Microvideo  E- Engage  "},{"id":"21408894731","fileName":"21408894731.html","title":"Ext - External Result","level":5,"position":110,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB IXB BCP BCV External Tool External result is a strategy used when an OK tightening is indicated by an external digital signal (and not by torque or angle values measured during tightening). This external signal can be provided through any means that can provide a digital signal into the controller (e.g through the I\/O bus). When the signal is sent, the result view (logged data) will show the value of the Target parameter provided in the tightening program (specified torque value, angle value, or text string). These (torque and angle) values do not represent actual measured values, but only inserted text.      Parameter  Description     Torque <Target torque>  Numerical value for desired displayed target torque value. A signal could for example come from a Click Wrench and display <Target torque>.    Angle <Target angle>  Numerical value for desired displayed target angle value. A signal could for example come from a Click Wrench and display <Target angle>.    Text  Alphanumerical string for desired displayed text. For example: \"Oil has been changed\"."},{"id":"25989447179","fileName":"25989447179.html","title":"IT - Impulse Tighten to Torque \/ Loosen to Torque","level":5,"position":111,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    IXB   Impulsesteps are valid only for IPB-P tools.  Impulse Tighten to Torque This step generates tightening pulses in the forward direction, until the torque target is reached.  Impulse Loosen to Torque This step generates tightening pulses in the backward direction, until torque is below torque target.      Parameter  Description     Torque Target - Ts   Torque Targetmust range from 0 through the maximum torque of the tool.    Pulse Energy - Pe   Pulse Energyis used to control the amount of energy\/current in each pulse.  Pulse Energymust range from 10% through 100 %. Default value: 100%.    Auto Speed     On: The tool will run at impulse energy speed both when pulsing and not pulsing. The pulse energy speed will be used through the whole step.   Off: The tool will run at the entered speed when not pulsing and at impulse energy speed when pulsing. Different speeds will be used within the step."},{"id":"21408897803","fileName":"21408897803.html","title":"MWR - Mechatronic Wrench","level":5,"position":112,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    MWR Mechatronic Wrench is a specialized step that can be used only in conjunction with the Mechatronic Wrench (MWR). This step cannot be used in combination with other steps. No restrictions can be used with this step. By default, the step has three monitors: Peak Torque, Angle, and Click.      Parameter  Description     Loosening limit  Numerical value for negative torque (i.e. torque in the loosening direction) at which point the tightening result is marked as NOK (False direction of tightening (loosen)); in Nm.    Tool Size  Numerical value for the specific length of the end fitting tool installed on the MWR-TA; in mm.    Tool Bend  Numerical value for the end fitting tool installed on the MWR-TA; in °\/Nm.    Rehit Angle Window  Numerical value for the angle for determining if the screw was already tightened if the torque is reached; in °.    Max Angular Rate  Numerical value for the max rate at which the screw can be tightened; in °\/s."},{"id":"21408862219","fileName":"21408862219.html","title":"RD – Rundown","level":5,"position":113,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST IXB Rundown step is the part of the tightening from when the screw enters the thread until just before the screw head touches the underlying surface and snug point is reached. The torque required during rundown does not contribute to any clamping force. This step runs the tool with the speed in the forward direction, and depending on the Rundown Type, Torque or Snug the step behavior is as follows:  Rundown Type: To Torque: The step stops when the specified target torque is found.  Rundown Type: To Snug: The snug gradient calculation starts at the specified torque trigger level Tt. If no torque trigger is set the gradient calculation is started at the start of the step. The slope calculation is made between two angle points Addegrees apart and is calculated as: (Tn – Tn-1) \/ (An – An-1) and as soon as two slopes after each other are larger than TSLOPEthe snug point is found.      Parameter  Description     Rundown type   To Torqueor To Snug.    Target torque  Default: \"not set\". Must be > 0.    Speed  Default: 60 rpm. Must be > 0.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Speed ramp  If Speed ramp type is Manual, this field opens. Default: 500 rpm\/s.    Trigger Torque  If Rundown typeis To Snug, the Trigger torquefield is displayed. Default: \"not set\". Must be > 0.    Delta Angle  If Rundown typeis To Snug, the Delta anglefield is displayed. Default: \"0\". Must be > 0.    Torque Rate  If Rundown typeis To Snug, the Torque ratefield is displayed. Default: \"0\". Must be > 0.    Brake (Valid only for Power Focus 6000 Synchronized tightening, Power Focus 8 Synchronized tightening and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.       A  Snug Point   B  Angle Delta   C  Torque Slope   D  Torque Target   E  Torque Trigger  "},{"id":"21408788235","fileName":"21408788235.html","title":"SR - Socket Release","level":5,"position":114,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB IXB  This step is not supported for tools configured with Gear Front Attachment (GFA) of type open end. This step runs the tool with speed n in the backward direction until the target angle is reached. The target angle is measured from the start of the step. This step is only allowed to use as the last step in the tightening path of a multistep tightening program. However, it is possible to add a sync point after this step.      Parameter  Description     Target angle  The angle target. Default: 3 degrees, must be > 0    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Speed ramp  If Speed ramp type is Manual, this field opens. Default: 500 rpm\/s.    Speed  Default: 60 rpm."},{"id":"22265219467","fileName":"22265219467.html","title":"SZP - Set Zero Position","level":5,"position":115,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST The step Set Zero Position sends out the signal set zero position to the tool. The position is repeated once every 360 degrees. With the steps Loosen to Zero Position or Tighten to Zero Position it is possible to return the tool to zero position. This step does not have any parameters.  The zero position is a specific position stored with either a “Set Zero Position” step or the signal “Set Zero Position”. The position is repeated once every 360 degrees."},{"id":"21408810251","fileName":"21408810251.html","title":"T - Tighten to Torque \/ Loosen to Torque","level":5,"position":116,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB IXB  T – Tighten to Torque This step runs the tool with the programmed speed in forward direction until the target torque is reached.      Parameter  Description     Target torque  The torque target. Must be > 0.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Speed  Default: 60 rpm. Must be > 0.    Speed ramp  If Speed ramp type is Manual, this field opens. Default: 500 rpm\/s.    Brake (Valid only for Power Focus 6000 Synchronized tightening, Power Focus 8 Synchronized tightening and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool. Microvideo  T - Tighten to Torque  T – Loosen to Torque  This step is not supported for tools configured with Gear Front Attachment (GFA) of type open end. This step runs the tool with the speed in the backward direction. For the step to be active, the torque must first exceed 110 % of the Target torque. The Target torque should be set to a positive value. After reaching the target torque, the step runs until the torque drops below the target torque.      Parameter  Description     Target torque  The torque target. Must be > 0.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Speed  Default: 60 rpm. Must be > 0.    Speed ramp  If Speed ramp type is Manual, this field opens. Default: 500 rpm\/s.    Brake (Valid only for Power Focus 6000 Synchronized tightening, Power Focus 8 Synchronized tightening and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.       A  Target Torque   "},{"id":"21408856075","fileName":"21408856075.html","title":"T&A – Tighten to Torque and Angle","level":5,"position":117,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB IXB This tightening step runs the tool with the given speed in the forward direction until both the target torque and the target angle are reached. The torque measurement starts at the beginning of the step. If the torque trigger is NOT set, the angle measurement starts at the beginning of the step. If the torque trigger is set, the angle measurement starts when the torque trigger is reached. The step ends when: Measured Torque >= Target Torque (Ts) AND (Measured Angle - Angle Measured at Torque Trigger) >= Target Angle (As).      Parameter  Description     Target torque (Ts)  Default value: 0. Must be > 0 and <= Tool Max Torque.    Target angle (As)  Default value: 0. Must be > 0.    Torque Trigger (Tt)  Default value: NOT set. Must be > 0 and < Target torque (Ts).    Speed (n)  Default: 60 rpm. Must be > 0 and <= Tool Max Speed.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, Speed ramp typeopens automatically.    Brake (Valid only for Power Focus 6000 Synchronized tightening, Power Focus 8 Synchronized tightening and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.  Tightening to Torque AND Angle, without Torque Trigger set      A  Target Torque   B  Target Angle  Tightening to Torque AND Angle, with Torque Trigger set      A  Target Torque   B  Torque Trigger   C  Target Angle   "},{"id":"21408854539","fileName":"21408854539.html","title":"T|A – Tighten to Torque or Angle","level":5,"position":118,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB IXB This tightening step runs the tool with the given speed in the forward direction until either the target torque or the target angle is reached. The torque measurement starts at the beginning of the step. If the torque trigger is NOT set, the angle measurement starts at the beginning of the step. If the torque trigger is set, the angle measurement starts when the torque trigger is reached. The step ends when: Measured Torque >= Target Torque (Ts) OR (Measured Angle - Angle Measured at Torque Trigger) >= Target Angle (As).      Parameter  Description     Target torque (Ts)  Default value: 0. Must be > 0 and <= Tool Max Torque.    Target angle (As)  Default value: 0. Must be > 0.    Torque Trigger (Tt)  Default value: NOT set. Must be > 0 and < Target torque (Ts).    Speed (n)  Default: 60 rpm. Must be > 0 and <= Tool Max Speed.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, Speed ramp typeopens automatically.    Brake (Valid only for Power Focus 6000 Synchronized tightening, Power Focus 8 Synchronized tightening and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.  Tightening to Torque OR Angle, without Torque Trigger set      A  Target Torque   B  Target Angle  Tighten to Torque OR Angle, with Torque Trigger set      A  Target Torque   B  Torque Trigger   C  Target Angle   "},{"id":"21408811787","fileName":"21408811787.html","title":"T+A – Tighten to Torque Plus Angle","level":5,"position":119,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB IXB This step runs the tool until the target torque is reached. From this point it continues to run an additional target angle.      Parameter  Description     Target torque  The torque target. Must be > 0.    Target angle  The angle target. Must be > 0.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Speed ramp  If Speed ramp type is Manual, this field opens. Default: 500 rpm\/s.    Speed  Default: 60 rpm.    Brake (Valid only for Power Focus 6000 Synchronized tightening, Power Focus 8 Synchronized tightening and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.       A  Target Torque   B  Target Angle  "},{"id":"21408896267","fileName":"21408896267.html","title":"TC - Torque Calibration","level":5,"position":120,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    QST  This step is only supported for multiple transducer tools. The Torque Calibrationstep runs the tool with the specified speed in the forward direction until the torque target is reached.      Parameter  Description     Target torque  Must be > 0.    Speed  Must be > 0. Default: 60 rpm.    Transducer   Torqueor Torque 2. Default: Torque. Set to Torque 2in order to calibrate the front transducer.    Adaptive brake (Valid only for Power Focus 6000 Synchronized tightening, Power Focus 8 Synchronized tightening and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool."},{"id":"21408860683","fileName":"21408860683.html","title":"ThCT – Thread Cutting to Torque","level":5,"position":121,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB IXB The Thread Cutting to Torquefunction enables tightening where the Rundown torque required is greater than the Rundown completetorque, for example when tightening thin layers of metal using self-threading (or self-tapping) screws. The tool runs in forward direction until the Thread Cutting Angle(Aw) is reached. The thread cutting angle window is measured from when the torque passes Thread Cut Trigger Torque(Ttc) for the first time. From the point where Thread cutting angle is reached, the step continues to run until the Target Torque(Tt) is reached.      Parameter  Description     Target torque  Must be > 0.    Thread Cutting Angle Window  Default: 0. Must be > 0.    Trigger Torque  The angle measurement starts at this trigger.    Speed  Default: 60 rpm. Must be > 0.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Brake (Valid only for Power Focus 6000 Synchronized tightening, Power Focus 8 Synchronized tightening and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.       A  Target Torque   B  Torque Trigger   C  Thread Cutting Angle Window  "},{"id":"21408912267","fileName":"21408912267.html","title":"TPT - TensorPulse Tighten to Torque \/ Loosen to Torque","level":5,"position":122,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    STR IXB  Before using TensorPulsetightening\/loosening step, it is mandatory that the following license type is installed on the controller:    Low Reaction Strategies   TensorPulseis valid only for the following tools: ETV-STR61-100-13, ETV-STR61-70-13, ETV-STR61-50-10, ITB-P.  This step is not supported for tools configured with Gear Front Attachment (GFA) of type open end or closed end.  TensorPulse Tighten to Torque This step generates tightening pulses in the forward direction, until the torque target is reached.  TensorPulse Loosen to Torque This step generates tightening pulses in the backward direction, until torque is below torque target. If running TensorPulsetightening\/loosening step, use the necessary PulseDrive socket\/adapter. If TensorPulsetightening\/loosening step runs without the PulseDrive socket\/adapter, all the tightenings are NOK. The step error “PulseDrive socket\/adapter not detected” shows for no PulseDrive socket\/adapter.      Parameter  Description     Torque Target - Ts  Torque Target must range from 0 through the maximum torque of the tool.    Pulse Energy - Pe  Pulse Energy is used to control the amount of energy\/current in each pulse. Pulse Energy must range from 10% through 100 %. By default, it is set to 100%.    Reaction Force Tuning Factor  Reaction Force Tuning Factor is used to tune the reaction force when running TensorPulsestep. It is the power that moves the tool in the opposite direction after each pulse. High tuning factor makes high reaction force and high pulse frequency; low tuning factor makes low reaction force and low pulse frequency. Reaction Force Tuning Factor must range from 0 through 100 %. By default, it is set to 40%.  In the trace, the angle reversal means that the tool rotates backward to enable pulsing, but the bolt head does not necessarily rotate backward because of the PulseDrive socket\/adapter."},{"id":"28203629707","fileName":"28203629707.html","title":"TTC - Tighten to Clutch","level":5,"position":123,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    XCB This step runs the tool with the programmed speed in forward direction until the clutch has been released. When the tool detects the release of the clutch, the step will finish with an OK status. Tighten to Clutch step is only valid for the XCB tool.      Parameter  Description     Speed shift  Angle or Torque    Trigger angle\/Trigger Torque  The trigger angle (in deg) or trigger torque (in Nm) at which the speed shifts.    Speed  The target speed (in rpm)    Speed Ramp Type  Switch to choose the type of speed ramp: Hard, Soft or Manual"},{"id":"21408805643","fileName":"21408805643.html","title":"TrR – Loosen to Trigger Release","level":5,"position":124,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR STB IXB  This step is not supported for tools configured with Gear Front Attachment (GFA) of type open end. This step runs in the backward direction until the tool trigger is released (loosen). It can only be used as a last step in a program. For STB tools, this step is only applicable for loosening programs.      Parameter  Description     Speed  Numerical value for rotation speed; in rpm.    Speed Ramp Type  List of options where speed ramp can be chosen [Hard, Soft, Manual]"},{"id":"21408807179","fileName":"21408807179.html","title":"TTTR – Tighten to Trigger Release","level":5,"position":125,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR STB IXB This step runs until the tool trigger is released (tighten). It can only be used as a last step in a tightening program.      Parameter  Description     Speed  Numerical value for rotation speed; in rpm.    Speed Ramp Type  List of options where speed ramp can be chosen [Hard, Soft, Manual]"},{"id":"21408786699","fileName":"21408786699.html","title":"W – Wait","level":5,"position":126,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB IXB In this step the tool waits until the Wait Typecondition is fulfilled. The tool does not rotate while waiting, but Hold conditioncan be specified.      Parameter  Description     Wait Type     Time: Wait specified time.   Signal (valid only for Power Focus 6000 Synchronized tightening): Wait until a rising edge on the signal Continue Step is received.    Wait Time  Number of seconds the tool will stand still - valid only when Timeis selected for Wait Type.    Hold Condition     No hold: The tool is waiting without running.   Hold torque: While waiting the tool strives to hold the torque it had when entering the step.   Hold position: While waiting the tool strives to hold the position it had when entering the step."},{"id":"21408909195","fileName":"21408909195.html","title":"WP - Wrench Production","level":5,"position":127,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    STwrench Strategy used for the quality test of the tightening performed with the STwrench.      Parameter  Description     Control Strategy  The Wrench Productionstep type can be configured with the following control strategies.    Torque: This strategy guides the operator is reaching the desired target torque.   Angle: This strategy guides the operator is reaching the desired target angle.   Torque or Angle: This strategy guides the operator is reaching the desired target angle or desired target torque.   Torque and Angle: This strategy guides the operator in tightening a bolt until both target torque and angle have been reached.   Yield Point: With this strategy, the STwrench detects the yield point automatically. The torque limits specify the range in which the result is OK. Target angle specifies how far beyond the yield point the user may tighten.   Loose: This strategy is used to loosen a tightened screw.   PVT compensate with snug: This strategy guides the operator in reaching the desired target torque for joints with prevailing torque, when the prevailing torque level is higher than the final target. Based on the control strategy selected, a combination of some of the parameters listed below will be displayed.      Parameters  Description     Target Torque  Defines the target torque for tightening step.    Measure torque at  Specifies where the torque will be measured. Choose between Peak torqueor Peak angle.    Peak torque: The torque value will be set to the peak torque value.   Peak Angle: The torque value will be set to the torque measured at the peak angle.    Angle search limit  This is an offset that is used to the set the torque result value for a tightening. Measure torque atmust be set to Peak Anglefor this parameter to be available.    Ratchet time  Numerical value for ratchet time which is by default 5000 ms. This allows the operator to release the torque for a while and recharge during the tightening operation. If the Ratchet timeis exceeded the result of the tightening is marked as NOK with the reason \"Tightening timeout\".    End cycle time  Numerical value in ms to indicate the end cycle time. Applied when torque goes below the rundown complete    Torque correction coefficient  The parameter is used to correct the torque reading when using an extension or torque multiplier on the wrench. Default value is 1.    Angle correction  The parameter is used to correct the angle reading when using an extension or torque multiplier on the wrench. Default value is 0.    Target Angle  Defines the target angle for tightening step.    Rehit detection   Onor Off. Rehit detection can be used to determine when a tightening is a rehit based on the angle limit setting. Angle limit for rehitis enabled if Rehit directionis set to On.    Linear slope coefficient  Linear slope coefficient characterizes the joint stiffness in the linear part of the curve, as torque\/angle slope in the Nm\/Deg measurement unit.    Compensate value  Choose between Average torqueand Peak torque. The Compensate value specifies how the PVT will be calculated.  Average torque- The PVT will be based on an average calculated using the following:   Delay monitoring  PVT interval  PVT distance  Prevailing torque min  Prevailing torque max  Peak torque- The PVT will be based on the peak value measured before snug was detected.    Delay monitoring  PVT calculation will not start before this window has been passed, starts at tightening start.    PVT interval  Sets how many degrees the PVT window shall be calculated for, start from the PVT distance point.    PVT distance  Sets how many degrees prior to snug the system shall start the PVT window.    Prevailing torque min  Prevailing torque minimum limit.    Prevailing torque max  Prevailing torque maximum limit Microvideo  WP - Wrench Production  "},{"id":"21408910731","fileName":"21408910731.html","title":"WQ - Wrench Quality","level":5,"position":128,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    STwrench Strategy used for the quality test of the tightening performed with the STwrench.      Parameter  Description     Control Strategy  The Wrench Qualitystrategy can be configured with the following control strategies.    Residual Torque\/Time: This strategy analyzes the torque trace as a function of time. The operator shall execute this operation with a single, steady, movement. The wrench automatically recognizes the breakaway and residual point.   Residual Torque\/Angle: This strategy evaluates the residual torque on a joint, looking for the residual point of the Torque\/Angle trace.   Residual Torque\/Peak: This strategy evaluates the residual torque on a joint as the peak torque necessary to rotate the bolt further.   Loose and Retighten: This strategy loosens a bolt and retightens it back to its original position   Yield Point: With this strategy the wrench detects the yield point automatically. Target Angle specifies how far beyond the yield point the user may tighten. Based on the control strategy selected, a combination of some of the parameters listed below will be displayed.      Parameters  Description     Ratchet time  Numerical value for ratchet time which is by default 5000 ms. This allows the operator to release the torque for a while and recharge during the tightening operation. If the Ratchet timeis exceeded the result of the tightening is marked as NOK with the reason \"Tightening timeout\".    Torque correction coefficient  The parameter is used to correct the torque reading when using an extension or torque multiplier on the wrench. Default value is 1.    Angle correction  The parameter is used to correct the angle reading when using an extension or torque multiplier on the wrench. Default value is 0.    Target Angle  Defines the target angle for tightening step.    Rehit detection   Onor Off. Rehit detection can be used to determine when a tightening is a rehit based on the angle limit setting. Angle limit for rehitis enabled if Rehit directionis set to On.    Linear slope coefficient  Linear slope coefficient characterizes the joint stiffness in the linear part of the curve, as torque\/angle slope in the Nm\/Deg measurement unit."},{"id":"21408859147","fileName":"21408859147.html","title":"Y – Tighten to Yield","level":5,"position":129,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST IXB This strategy runs the tool with the speed in the forward direction until the yield point is detected. The yield point is found by monitoring the torque gradient from the point where the torque goes above the Trigger Torquelevel, calculated based on Torque and Angle distance measurements. The Angle distance parameter is set according to the specified hardness of the joint. Set the Gradient angle window(for hard joint, for soft joint or for manually setting of the Angle window). If Manualis selected, the Angle Windowmust be set. A joint is considered Hardif the screw is tightened to its full torque and it rotates 30 degrees or less after it has been tightened to its snug point. A Softjoint rotates 720 degrees or more after it has been tightened to its snug point. The hardness parameter defines the Angle Window for the gradient calculation. The harder the joint - the smaller the angle window.      Parameter  Description     Gradient Angle Window  Specifies Angle Window:   For Hard Joint: Angle Window= 1 deg.  For Soft Joint: Angle Window= 20 deg.   Manual: Manually set Angle Window.    Angle Window  Available when Gradient Angle Windowis set to Manual. Must be > 0 and <= 100.    Trigger Torque  The angle measurement starts at this trigger. Must be >= 0 and < Tool MaxTorque.    Damping  Frequency in which the gradient is being calculated. Must be > 0 and < 100 and < Angle window.    Yield Point Percentage  Must be >= 20 %    Speed  Default: 60 rpm. Must be > 0.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Torque Filter Type  The type of the filter:    None: No filtering of the torque is used. The raw values are used as-is in the gradient calculation.   Five-point: The torque value used in the calculation are filtered using a sliding average filter over 5 torque samples.   Low pass: The torque values is filtered with a simple discrete Infinite Impulse Response filter.   Sliding Average: The torque values used in the calculation are filtered using a sliding average filter over a Number of Samplesspecified by the use.    Cut-off Frequency  Needs to be specified when Torque Filter Typeis set to Low pass:   20 Hz  40 Hz  90 Hz  200 Hz  600 Hz    Number of Samples  Needs to be specified when Torque Filter Typeis set to Sliding Average:   2  4  6  8  16  32    Brake (Valid only for Power Focus 6000 Synchronized tightening, Power Focus 8 Synchronized tightening and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.       A  Peak Gradient   B  Yield Point   C  Shut-off Point   D  Angle Distance   E  Torque Trigger  "},{"id":"21408808715","fileName":"21408808715.html","title":"YM2 - Tighten to Yield: Method 2","level":5,"position":130,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    QST This step runs the tool with the specified speed in the forward direction until the yield point is detected. Search for the yield point starts when the torque has reached Tt. The average of the torque over Afdegrees is calculated. This procedure is repeated N rstimes. A reference slope is calculated with linear regression over the N rspoints. After that, new average values are continuously calculated over A fdegrees. The actual slope is calculated with linear regression over the last N saverage points. The yield point is reached when the slope is less than Py %of the reference slope.      Parameter  Description     Target torque  Must be > 0.    Filter angle  Default: 1. Must be > 0.    Number of samples  Default: 6. Must be >=4.    Number pf samples, reference  Default: 6. Must be >=4.    Yield point percentage  Default: 90%. Must be >20%.    Speed  Default: 60 rpm. Must be > 0.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Speed ramp  If Speed ramp type is Manual, this field opens. Default: 500 rpm\/s.    Brake (Valid only for Power Focus 6000 Synchronized tightening, Power Focus 8 Synchronized tightening and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.       A  Torque Trigger   B  Number of samples, ref   C  Actual Slope   D  Number of samples   E  Reference Slope   F  Filter Angle  "},{"id":"22265223307","fileName":"22265223307.html","title":"ZP - Loosen to Zero Position","level":5,"position":131,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST This step runs the tool with the speed (N) in the backward direction until it reaches the zero position. If the total angle to rotate to reach the zero position is less than the minimum angle (Am) degree the rotation will continue for one more revolution, 360 degrees.  The zero position is a specific position stored with either a “Set Zero Position” step or the signal “Set Zero Position”. The position is repeated once every 360 degrees.   Parameters     Parameter  Description    Minimum Angle  Minimum Angle (Am) [°]   Speed  Rotation speed (N) [rpm]. Default value 60 rpm."},{"id":"22265221387","fileName":"22265221387.html","title":"ZP - Tighten to Zero Position","level":5,"position":132,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST This step runs the tool with the speed (N) in the forward direction until it reaches the zero position. If the total angle to rotate to reach the zero position is less than the minimum angle (Am) degree the rotation will continue for one more revolution, 360 degrees.  The zero position is a specific position stored with either a “Set Zero Position” step or the signal “Set Zero Position”. The position is repeated once every 360 degrees.   Parameters     Parameter  Description    Minimum Angle  Minimum Angle (Am) [°]   Speed  Rotation speed (N) [rpm]. Default value 60 rpm"},{"id":"22262063627","fileName":"2226206362729398424331.html","title":"Step Monitors","level":4,"position":133,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs"],"content":"   The availability of tightening steps, monitors and restrictions depends on the license installed on the controller. The step monitors are used to verify that the tightening was achieved according to the specification, for example, angle limits or torque. Each step has mandatory step monitors and optional step monitors. The mandatory monitors are included when dragging a new step to the multistep program. The optional monitors are flexible and can be placed as needed in the multistep program. Every step can have up to eight monitors each. The following monitors are automatically added to every step that is added to the multistep tightening program.  Default step monitors     Step Monitor  Applicable steps    Angle  All   Peak Torque  All   Available tools for each system type     Power Focus 6000 \/ Power Focus 8  Power Focus 6000 Synchronized tightening \/ Power Focus 8 Synchronized tightening  Flex  IxB    ST  ST  QST  IxB   STR  STR     SL  QST     QST      STB      IxB      Power Focus Connect      XB         Step Monitors  Tools     title-item   list "},{"id":"21896040843","fileName":"21896040843.html","title":"A - Angle","level":5,"position":134,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB MWR-TA This step monitor measures the maximum angle reached during the monitor and checks that it is between High limitand Low limit. The angle measurement starts at the start of the monitor or, if specified, at the point where the torque passes Trigger torquefor the first time during the monitor.      Parameter  Description  Default value     Stop condition  It specifies where the angle measurement ends:    End End point used: the angle at the end of the monitor.   Peak Torque End point used: the angle at the point where the highest torque is reached during the monitor.   Shut Off End point used: the angle at the shut off point of the step.   Peak End point used: the highest angle reached during the monitor.  Shut Off    Trigger torque  The angle measurement starts at this trigger.  Minimum limit: must be >= 0  Maximum limit: must be < Tool Max Torque  Not set    Low Limit  Lowest acceptable angle.  Minimum limit: must be >= 0  Maximum limit: must be < 9 999 999 and < High Limit  Not set    High Limit  Highest acceptable angle.  Minimum limit: Must be > 0 and > Low Limit  Maximum limit: must be < 9 999 999  Not set Result Values    Angle Measured: the angle measured by the monitor.  Step Monitor Angle - Stop condition End      A  Shut-off point  D  Angle high limit   B  Torque trigger  E  Measured angle   C  Angle low limit  F  Step  Step Monitor Angle - Stop condition Peak Torque      A  Peak torque  E  Angle high limit   B  Shut-off point  F  Measured angle   C  Torque trigger  G  Step   D  Angle low limit    Step Monitor Angle, Stop condition Shut Off      A  Shut-off point  D  Angle high limit   B  Torque trigger  E  Measured angle   C  Angle low limit  F  Step  Step Monitor Angle - without Torque Trigger and with stop condition Peak      A  Shut-off point  D  Measured angle   B  Angle low limit  E  Step n-1   C  Angle high limit  F  Step n     "},{"id":"28147691531","fileName":"28147691531.html","title":"AZP - Adjust to Zero Position","level":5,"position":135,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    QST This monitor is used to return to the true Zero Crossing position, measured in the Zero Crossingmonitor earlier in the program. Backlash angle is used if measured earlier in the program      Parameter  Description     Low Speed  Speed used when Slowdown Distanceis reached. Must be < Speed and > 0.    ZeroPosition Adjustment  Target position from Zero Crossing value. Must be > -9,999,000 and < 9,999,999.    Slowdown Distance  Degrees before target in which the Low Speedwill be used. Must be >= 0 and < 9,999,999.    Speed  Default: 60 rpm. Must be < Tool max speed.    Speed Ramp Type   Hard, Softor Manual. Default: Hard. If you select Manual, the Speed Ramp field opens."},{"id":"28150384395","fileName":"28150384395.html","title":"BA - Backlash Angle","level":5,"position":136,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    QST This monitor monitors the backlash angle of the socket. Used with the Backlash Angle Measurementstep.      Parameter  Description     High Limit  Maximum angle limit. Must be < 9,999,999."},{"id":"28140235019","fileName":"28140235019.html","title":"BM - Backlash Angle Measurement","level":5,"position":137,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    QST This monitor measures the backlash in the socket. The resulting angle is used in calculations in the Adjust to Zero Positionmonitor.      Parameter  Description     Direction  The direction in which the measurement ends.    Target Torque  The torque target. Must be >= 0.    Speed  Default: 60 rpm. Must be >= 0.    Speed Ramp Type   Hard, Softor Manual. Default: Hard. If you select Manual, the Speed Ramp field opens."},{"id":"21896048267","fileName":"21896048267.html","title":"C - Current","level":5,"position":138,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB This monitor measures the actual current at any point after the torque passes Torque Trigger. The result will be the first peak or low value, that made the monitor NOK. In case of OK, the result will be the last measured current value. If the torque trigger is never reached during the monitor it will end with NOK status and no measurement value.      Parameter  Description    Torque Trigger  Must be >= 0 and < Tool Max Torque.   Low limit  Lowest acceptable current.   High limit  Highest acceptable current."},{"id":"21902805771","fileName":"21902805771.html","title":"Cl - Click","level":5,"position":139,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    MWR-T MWR-TA  This step monitor is not available for IxB tools. Monitor to enable click torque and click angle results. This monitor has no settings, and can only be used with the MWR step."},{"id":"27369380619","fileName":"27369380619.html","title":"DT - Delta Torque","level":5,"position":140,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST IXB This step monitor measures the difference between the peak torque and the low spot torque (i.e. the lowest measured torque) and checks that it is between the limits.      Parameter  Description     High Limit  Highest acceptable torque.    Low Limit  Lowest acceptable torque."},{"id":"27369382155","fileName":"27369382155.html","title":"LST - Low Spot Torque","level":5,"position":141,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST IXB This step monitor measures the lowest torque and checks that it is between the limits.      Parameter  Description     High Limit  Highest acceptable torque.    Low Limit  Lowest acceptable torque.    Type  Specifies the start condition:    Step Start: The measurement starts from step start and ends at the shut-off point.   Angle Trigger: The measurement starts at the set angle and ends at the shut-off point.    Start Angle  Available when Typeis set to Angle Trigger."},{"id":"21902835083","fileName":"21902835083.html","title":"LD - Loosening Detection","level":5,"position":142,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    STwrench  This step monitor is only available for STwrench tools This monitor can be used to check the torque and direction to see if a loosening is attempted when using the Wrench Productionstep strategy for an STwrench. If the applied torque is above the value set for Loosening Limitin the direction opposite to the configured thread direction of the program, the result shall be reported as NOK."},{"id":"21900544779","fileName":"21900544779.html","title":"MT - Mean Torque","level":5,"position":143,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST IXB This monitor measures the average torque during the monitor and checks the calculated value is within the limits.      Parameter  Description     Type  Specifies start condition:    Step Start: The measurement starts from step start and ends at the shut-off point.   Torque Trigger: The measurement starts at the point where the torque passes Torque Triggerfor the first time. It ends at the shut-off point.   Angle Trigger: The measurement starts at the point where the angle is Angle Trigger, measured from the optional Trigger Torque, is reached. Without Trigger Torque, the Angle Triggeris measured from the start of the step. It ends at the shut-off point   Angle Window: Measures during an Angle Window. The window starts at the point where the torque passes Trigger Torquefor the first time plus an angle offset, Angle Trigger.   Time Interval: Measures during the last Time Intervalseconds of the tightening.    Torque Trigger  Available when Typeis set to Trigger Torque, Angle Triggeror Angle Window. Must be >= 0 and < Tool Max Torque.    Angle Trigger  Available when Typeis set to Angle Triggeror Angle Window. Must be > 0.    Angle Window  Available when Typeis set to Angle Window. Must be > 0.     Time Interval  Available when Typeis set to Time Interval. Must be > 0.    Low Limit  Lowest acceptable torque.    High Limit  Highest acceptable torque."},{"id":"21902746763","fileName":"21902746763.html","title":"PC - Pulse Count","level":5,"position":144,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    STR  This step monitor is only available for the following tools:    ETV-STR61-100-13   ETV-STR61-70-13   ETV-STR61-50-10 Before using the Pulse Countstep monitor, the Low Reaction Strategieslicense must be installed on the controller. This monitor measures the number of pulses and confirms if it is between the pulse count low limit and pulse count high limit. If the torque trigger level is set, the check starts as soon as the measured torque is above the torque trigger level. If running a tightening step with Pulse Countstep monitor, use the necessary PulseDrive socket\/adapter. If the tightening step runs without the PulseDrive socket\/adapter, all the tightenings are NOK. The step error “PulseDrive socket\/adapter not detected” shows for no PulseDrive socket\/adapter.      Parameter  Description     Pulse Count High Limit - n+  The Pulse Count limits are used to determine if the measured number of pulses is OK or NOK. The measured number of pulses is OK if it is between the pulse count low limit and pulse count high limit. The measured number of pulses is NOK if:   It is higher than the pulse count high limit.  It is lower than the pulse count low limit.  The trigger torque level is not reached. Pulse count high limit must range from 1 through 9999999. It must be greater than or equal to the pulse count low limit.  Pulse Count High Limittext box can be empty.    Pulse Count Low Limit - n-  The Pulse Count limits are used to determine if the measured number of pulses is OK or NOK. The measured number of pulses is OK if it is between the pulse count low limit and pulse count high limit. The measured number of pulses is NOK if:   It is higher than the pulse count high limit.  It is lower than the pulse count low limit.  The trigger torque level is not reached. Pulse Count Low Limit must range from 1 through 9999999. It must be lower than or equal to the Pulse Count High Limit.  Pulse Count Low Limittext box can be empty.    Torque Trigger - Tt  Torque Trigger must range from 0 through the maximum torque of the tool.  Torque Triggertext box can be empty."},{"id":"21901847051","fileName":"21901847051.html","title":"PrT - Prevailing Torque","level":5,"position":145,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB The monitor calculates the prevailing torque value in the Window Lengthand checks that it is between the Torque limits. The Angle Window starts at the angle degrees set in Start Anglein reverse direction from the shut-off point. This then spans for the angle degrees set in Angle Window Length in reverse direction. If Start Angleis left blank the angle window starts at the shut-off point. The calculated prevailing torque value is the mean or peak torque value (depending on the parameter set by the user) during the Window Length. The calculated value is saved as result data Prevailing Torque Measured. If Torque compensationis set to On, the Prevailing Torque Measured will be subtracted from all torque result values in consecutive steps. Any previously calculated prevailing torque compensation values will no longer be subtracted from torque result values. If Torque compensationis set to Off, no subtraction will be made in consecutive steps. If the total angle of the step is less than the Start Angleplus Window Length, then the monitor will report NOK. Prevailing torque can be measured as an average of measured values, or at peak torque. To choose between these two modes, set the Use Valueparameter to either Mean torque(for average values), or Peak torque(for peak value).      Parameter  Description     Torque Compensation  On or off.    Start Angle  Must be > 0    Window length  Must be >= 0    Low Limit  Must be > 0    High Limit  Must be >= 0    Use value   Mean torque(for average values), or Peak torque(for peak value)."},{"id":"21900548491","fileName":"21900548491.html","title":"PT - Peak Torque","level":5,"position":146,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB MWR-TA MWR-T This step monitor measures the maximum torque reached during the monitor, including any over shoot, and checks that it is between High limitand Low limit.      Parameter  Description     Low Limit  Lowest acceptable torque.    High Limit  Highest acceptable torque."},{"id":"21900552203","fileName":"21900552203.html","title":"PTCA - Post Thread Cut Angle","level":5,"position":147,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB This step monitor measures the maximum angle reached during the monitor and checks that it is between High limitand Low limit. The Trigger Torquelevel is ignored until the end of the Thread cut angle windowis reached. After that, the angle measuring starts as soon as the measured torque is above Trigger Torque.      Parameter  Description  Default value     Stop condition  It specifies where the angle measurement ends:    End End point used: the angle at the end of the monitor.   Peak Torque End point used: the angle at the point where the highest torque was reached during the monitor.   Shut Off End point used: the angle at the shut off point of the step.   Peak End point used: the highest angle reached during the monitor.  Shut Off    Trigger torque  The angle measurement starts at this trigger.  Minimum limit: must be >= 0  Maximum limit: must be < Tool Max Torque  0    Low Limit  Lowest acceptable angle.  Minimum limit: must be >= 0  Maximum limit: must be < 9 999 999 and < High Limit  Not set    High Limit  Highest acceptable angle.  Minimum limit: Must be > 0 and > Low Limit  Maximum limit: must be < 9 999 999  Not set    Thread cut trigger torque   Minimum limit: must be >= 0  Maximum limit: must be < Tool Max Torque  Not set    Thread cut angle window   Minimum limit: must be >= 0  Maximum limit: must be < 9 999 999  0 Result Values    Angle Measured: the angle measured by the monitor.  Step Monitor - Post Thread Cut Angle      A  Shut-off point  E  Angle low limit   B  Torque trigger  F  Angle high limit   C  Torque trigger thread cut  G  Measured angle   D  Thread cut angle window    "},{"id":"21900555915","fileName":"21900555915.html","title":"PTCPT - Post Thread Cut Peak Torque","level":5,"position":148,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB Measures the maximum torque achieved during the monitoring, including any over-shoot, and checks that it is between the Torque limits. All torque values are ignored until the end of the Thread cut angle windowhas been reached.      Parameter  Description     Thread cut trigger torque  Must be >= 0    Thread cutting angle window  Must be > 0    Low Limit  Must be >= 0    High Limit  Must be > 0 Must be > Low limit"},{"id":"21901839627","fileName":"21901839627.html","title":"PVTH - Post View Torque High","level":5,"position":149,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB This monitor checks that all torque values in the Angle Window Lengthare below the High limit. The Angle Window starts at the angle degrees set in Start Anglein reverse direction from the shut-off point. This then spans for the angle degrees set in Angle Window Length in reverse direction. If Start Angle is left blank, the Angle Window starts at the shut-off point. The torque values used in the monitor are based on the mean torque value, calculated over Number of Samples. If the total angle of the step is less than Start Angle plus Angle Window Length the monitor will report NOK.      Parameter  Description     Start Angle  Must be >= 0    Window length  Must be > 0    Number of samples  Minimum value =1 Maximum value = 80    High Limit  Highest acceptable torque."},{"id":"21901843339","fileName":"21901843339.html","title":"PVTL - Post View Torque Low","level":5,"position":150,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB Same as monitor Post View Torque High, but this monitor checks that all torque values in the Angle Window Lengthare above Low Limitinstead.      Parameter  Description     Start Angle  Must be >= 0    Window length  Must be > 0    Number of samples  Minimum value =1 Maximum value = 80    Low Limit  Lowest acceptable torque."},{"id":"21902754187","fileName":"21902754187.html","title":"SOC - Shut Off Current","level":5,"position":151,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB The shut off point is the point where the step reaches its target. The current is measured at the shut off point and checked to be between High limitand Low limit.      Parameter  Description     Low Limit  Lowest acceptable current.    High Limit  Highest acceptable current."},{"id":"21902750475","fileName":"21902750475.html","title":"SOT - Shut Off Torque","level":5,"position":152,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB The shut off point is the point where the step reaches its target. The torque is measured at the shut off point and checked to be between High limitand Low limit.      Parameter  Description     Low Limit  Lowest acceptable torque.    High Limit  Highest acceptable torque."},{"id":"21902757899","fileName":"21902757899.html","title":"SSD - Stick Slip Detection","level":5,"position":153,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST IXB This step monitor detects and reports stick slip effects during a step. The detection is done by counting the number of times the torque falls below the Trigger Level. If the number of times is larger than Maximum Number of Oscillationsthen the stick slip error is reported. The monitor operates in two different modes, Dynamicor Fixed. The difference between the modes is the way that the Trigger level is calculated.  Dynamic Torque: Trigger Levelis dynamically calculated as Peak Torque Percentageof the current max torque, which has been achieved so far during the monitoring. The monitoring is started as soon as the torque passes the Trigger Torque.  Fixed Torque: Trigger Levelis the fixed Trigger Torquespecified by the user. In this mode the percentage is not needed. If the torque never reaches the Trigger Torquethen the monitoring is not started, this will result in status NOK.      Parameter  Description     Type  Specifies what type of Stick slip detection that will be done in the monitor Stick Slip detection. Default: Dynamic torque.    Peak Torque Percentage  Default: 80%, Must be >=10 and < 100.    Trigger Torque  Default: 5, Must be >= 0 and < Tool max torque.    Maximum Number of Oscillations  Default: 5, Must be >= 3 and <20."},{"id":"21902798347","fileName":"21902798347.html","title":"TAW - Torque in Angle Window","level":5,"position":154,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB This monitor checks that all torque values in the angle window are within the torque limits.      Parameter  Description     Trigger Torque  Must be >= 0    Start Angle  Must be > 0    Window Length  Must be <= 0    Low Limit  Must be >= 0    High Limit  Must be > 0 Must be > Low limit   NOK if window is passed  If set to Yes, status of this monitor is NOK if the end of angle window is not reached."},{"id":"21902769035","fileName":"21902769035.html","title":"TC - Torque Calibration","level":5,"position":155,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    QST  This step monitor is only available for tools equipped with multiple transducers. The Torque Calibrationmonitor checks if the maximum torque reached is within the torque limits.      Parameter  Description     Transducer type   Torqueor Torque 2 Set to Torque 2for the front transducer of the tool.    Low limit  Must be >= 0    High limit  Must be > 0 Must be > Low limit"},{"id":"21902765323","fileName":"21902765323.html","title":"TG - Torque Gradient","level":5,"position":156,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST IXB This monitor checks that the gradient is within the limit.      Parameter  Description     Gradient Angle Window  Specifies Angle Window:   For Hard Joint: Angle Window= 1 deg.  For Soft Joint: Angle Window= 20 deg.   Manual: Manually set Angle Window.    Angle Window  Available when Gradient Angle Windowis set to Manual. Must be > 0 and <= 100.    End Point Check  If set to Yes, only the gradient measured at the shut off point of the step is checked to be within the limits.    Trigger Torque  The angle measurement starts at this trigger. Must be > 0 and < Tool MaxTorque.    Damping  Frequency in which the gradient is being calculated. Must be > 0 and < 100 and < Angle window.    Low Limit  Lowest acceptable torque gradient. Must be >= -100.    High Limit  Highest acceptable torque gradient. Must be > -100 and > Low limit.    Torque Filter Type  The type of the filter:    None: No filtering of the torque is used. The raw values are used as-is in the gradient calculation.   Five-point: The torque value used in the calculation are filtered using a sliding average filter over 5 torque samples.   Low pass: The torque values is filtered with a simple discrete Infinite Impulse Response filter.   Sliding Average: The torque values used in the calculation are filtered using a sliding average filter over a Number of Samplesspecified by the use.    Cut-off Frequency  Needs to be specified when Torque Filter Typeis set to Low pass:   20 Hz  40 Hz  90 Hz  200 Hz  600 Hz    Number of Samples  Needs to be specified when Torque Filter Typeis set to Sliding Average:   2  4  6  8  16  32    Angle Offset  Available when End Point Checkis set to No. Specifies the degrees that the calculation of the gradient start after the trigger torque is passed for the first time."},{"id":"21902761611","fileName":"21902761611.html","title":"Ti - Time","level":5,"position":157,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB Measures the elapsed time during the monitor and checks that it is between the time limits. The time measurement starts at the start of the monitor and, if the Trigger Torque is specified, at the point where the torque passes Trigger Torque for the first time during the monitor.      Parameter  Description     Trigger Torque  Must be >= 0 and < Tool max torque.    Low Limit  Must be >= 0    High Limit  Must be > 0 Must be > Low limit"},{"id":"21902802059","fileName":"21902802059.html","title":"TRD - Torque Rate and Deviation","level":5,"position":158,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST IXB This step monitor measures and checks the torque rate, i.e. the ratio of torque vs. angle. The calculated torque rate is checked if it is within the torque rate limits defined by High Limitand Low Limit.      Parameter  Description     Trigger Torque  Torque of the angle start point.    Start Point Angle  When Start point angle has been measured from Trigger torque the measuring of the torque starts.    End Point Angle  Angle point where the measuring of the torque is stopped.    End Point Torque  Torque where the measuring of the torque is stopped.    Low Limit  Lowest acceptable torque.    High Limit  Highest acceptable torque.    Limit  Must be > 0"},{"id":"21896044555","fileName":"21896044555.html","title":"YA - Angle from Yield","level":5,"position":159,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST IXB This monitor measures the peak angle reached from the yield point and checks that the peak angle is within the limit.      Parameter  Description     Gradient Angle Window  Specifies Angle Window:   For Hard Joint: Angle Window= 1 deg.  For Soft Joint: Angle Window= 20 deg.   Manual: Manually set Angle Window.    Angle Window  Available when Gradient Angle Windowis set to Manual. Must be > 0 and <= 100.    Yield Point Percentage  Must be >= 20 %    Trigger Torque  The angle measurement starts at this trigger. Must be > 0 and < Tool MaxTorque.    Damping  Frequency in which the gradient is being calculated. Must be > 0 and < 100 and < Angle window.    Low Limit  Lowest acceptable angle. Must be >= 0    High Limit  Highest acceptable angle. Must be > 0    Torque Filter Type  The type of the filter:    None: No filtering of the torque is used. The raw values are used as-is in the gradient calculation.   Five-point: The torque value used in the calculation are filtered using a sliding average filter over 5 torque samples.   Low pass: The torque values is filtered with a simple discrete Infinite Impulse Response filter.   Sliding Average: The torque values used in the calculation are filtered using a sliding average filter over a Number of Samplesspecified by the use.    Cut-off Frequency  Needs to be specified when Torque Filter Typeis set to Low pass:   20 Hz  40 Hz  90 Hz  200 Hz  600 Hz    Number of Samples  Needs to be specified when Torque Filter Typeis set to Sliding Average:   2  4  6  8  16  32"},{"id":"28150335115","fileName":"28150335115.html","title":"ZC - Zero Crossing","level":5,"position":160,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    QST This monitor calculates the true start of a spring compression.      Parameter  Description     Trigger Torque  Torque value from where the monitor starts. Must be < End Point Torque.    End Point Torque  Torque value for stop measuring. Must be > Trigger Torque.    Start Point Angle  Angle value from where the monitor starts. Must be < End point angle.    End Point Angle  Angle value for stop measuring. Must be > Start point angle.    Torque Rate Limit High  Maximum torque rate. Must be > Torque Rate Limit Lowand < 999.    Torque Rate Limit Low  Minimum torque rate. Must be < 999 and < Torque Rate Limit High."},{"id":"22262065547","fileName":"2226206554729398431755.html","title":"Step Restrictions","level":4,"position":161,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs"],"content":"   The availability of tightening steps, monitors and restrictions depends on the license installed on the controller. To make sure the tightening stops if something unexpected happens, it is possible to add step restrictions to the multistep tightening program. These restrictions could, for example, test that a maximum torque is not reached or that a part of the multistep tightening does not take too long to run. Each step has its own set of mandatory step restrictions and optional step restrictions. The mandatory restrictions are included when dragging a new step to the multistep program. All steps can have up to four restrictions each.  For synchronized tightening in Power Focus 6000 and Power Focus 8, it is possible to use synchronization points in the tightening program. When any condition that is set for a restriction is met, the tool will be stopped immediately and the program jumps to the next synchronization point (only valid when using synchronized tightening in Power Focus 6000, Power Focus 8, and Flex), or the end of the program. In controllers without synchronized tightening the tool is stopped immediately and the program jumps to the end of the program.  For Flex only: For each restriction, select Repairable= Yesto allow retry when tightening stops. The following restrictions are automatically added to every step that is added to the multistep tightening program.  Default step restrictions     Step Restriction  Applicable steps    Maximum Time  All except External Result and MWR   Maximum Torque    Tighten to Angle  Tighten to Torque+Angle  Turbo Loosening  Wait  Socket release  Run until Digital Input  Tighten to Trigger Release  TensorPulse  Impulse   Maximum Angle    Tighten to Torque  TurboTight  Turbo Loosening  Tighten to DynaTork  Wait  Run until Digital Input  Loosen to Torque  Thread Cutting to Torque  Rundown  Tighten to Yield  Pulsing Rundown Snug  TensorPulse   Available tools for each system type     Power Focus 6000 \/ Power Focus 8  Power Focus 6000 Synchronized tightening \/ Power Focus 8 Synchronized tightening  Flex  IxB    ST  ST  QST  IxB   STR  STR     SL  QST     QST      STB      IxB      Power Focus Connect      XB         Step Restrictions  Tools     title-item   list "},{"id":"21903501323","fileName":"21903501323.html","title":"A - Maximum Angle","level":5,"position":162,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST STB IXB This restriction measures the angle. If the measured angle reaches the Maximum Limit, the tool is stopped immediately. The angle is measured from the start of the restriction or, if specified, from the point where the torque passes Trigger Torquefor the first time during the restriction.      Parameter  Description     Trigger Torque  If specified, this is the torque from where the angle is measured.    Maximum Limit  If this limit is reached the tool is stopped immediately."},{"id":"21902844811","fileName":"21902844811.html","title":"C - Current","level":5,"position":163,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST STB IXB  This step restriction is not supported for Power Focus XC. This restriction checks the actual current where torque passes Torque Trigger. If the actual current exceeds the limits, the tool will be stopped immediately and the tightening program will jump to the next synchronization point or the end of the program. The result will be the first peak or low value, that made the monitor NOK. In case of OK, the result will be the last measured current value. If the torque trigger is never reached during the restriction it will end with status OK.      Parameter  Description    Torque Trigger  Must be >= 0 and < Tool Max Torque.   Low limit  Lowest acceptable current.   High limit  Highest acceptable current."},{"id":"28214796555","fileName":"28214796555.html","title":"CRh - Clutch Rehit","level":5,"position":164,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    XCB If the tool clutch is released while the tightening is still within the angle window, the step restriction is triggered. This stops the tightening immediately and produces a NOK result. This step restriction is only valid for the Tighten to Clutch tightening step.      Parameter  Description    Angle Window  The angle window (in degrees) during which the Clutch Rehit step restriction is triggered."},{"id":"21902840715","fileName":"21902840715.html","title":"CTh - Cross Thread","level":5,"position":165,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST STB IXB This restriction checks the angle from the point where torque passes Start torque(T1) to the point where the torque passes End torque(T2). If the angle measured from Start torque(T1) is higher than Maximum limit(Amax), the tool is stopped immediately. When the torque passes End torque(T2), the measured angle is checked against the limit Minimum limit(Amin). If the angle is lower than this limit, the tool is stopped immediately.       Parameter  Description  In illustration     Start Torque  Must be <=0.  T1    End Torque  Must be <=0.  T2    Minimum Limit  The low angle limit.  Amin    Maximum Limit  The high angle limit.  Amax  "},{"id":"21903531403","fileName":"21903531403.html","title":"PCH - Pulse Count High","level":5,"position":166,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    STR IXB  This restriction is only available for the following tools:    ETV-STR61-100-13   ETV-STR61-70-13   ETV-STR61-50-10   ITB-P Before using the Pulse Countrestriction, the Low Reaction Strategieslicense must be installed on the controller. This restriction gives a limit to the number of pulses, and makes sure that those are below the specified pulse count high limit. If the measured number of pulses is higher than the pulse count high limit, the tool is stopped immediately and the program goes to the next synchronization point or the end of the program. If the torque trigger level is set, the check starts as soon as the measured torque is above the torque trigger level. If running a tightening step with Pulse Count Highstep restriction, use the necessary PulseDrive socket\/adapter. If the tightening step runs without the PulseDrive socket\/adapter, all the tightenings are NOK. The step error “PulseDrive socket\/adapter not detected” shows for no PulseDrive socket\/adapter.      Parameter  Description     Pulse Count High Limit - n+  Pulse count high limit must range from 1 through 9999999.  Pulse Count High Limittext box can be empty.    Torque Trigger - Tt  Torque Trigger must range from 0 through the maximum torque of the tool.  Torque Triggertext box can be empty."},{"id":"21903512459","fileName":"21903512459.html","title":"Rh - Rehit","level":5,"position":167,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST STB IXB This restriction checks the torque. If the measured torque exceeds the Detection Torque, the tool is stopped immediately and the program jumps to the next synchronization point (for Power Focus 6000 Synchronized tightening and Power Focus 8 Synchronized tightening), or the end of the program. It is only possible to add step Rehit restriction to the first step of the multistep tightening program. Once the Rehit restriction has been added to the first step it shall not be possible to move the step to any other position within the tightening program. The Rehit restriction has to be deleted from the first step in order to move it to other position in the tightening program.      Parameter  Description     Detection Torque  If the measured torque exceeds the Detection Torque, the tool is stopped immediately and the program jumps to the next synchronization point (for Power Focus 6000 Synchronized tightening and Power Focus 8 Synchronized tightening), or the end of the program. Must be greater than zero.    Angle Window  The angle window is measured from the start of the step. If no Angle Window is set, the restriction is active during the whole step."},{"id":"21903516171","fileName":"21903516171.html","title":"RT - Rescinding Torque","level":5,"position":168,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST STB IXB This restriction checks the torque. If the measured torque drops below the condition of the restriction the tool is stopped immediately and the program jumps to the next synchronization point (for Power Focus 6000 Synchronized Tightening and Power Focus 8 Synchronized Tightening), or the end of the program.    Torque control processes The restriction condition is the measured torque. For the restriction to be active the torque must first exceed 110 % of the Rescinding Torque Limit.   Angle control processes This restriction checks the maximum torque reached during the restriction. For the restriction to be active the torque must first exceed the Trigger Torque.  Torque control processes     Parameter  Description    Rescinding torque limit  Default: 10 Nm. Must be > 0.  Angle control processes (valid only for Power Focus 6000 Synchronized tightening and Power Focus 8 Synchronized tightening)     Parameter  Description    Trigger Torque  Must be > 0.   Peak torque percentage  Default: 95. Must be >= 50.   Rescinding torque time  Default: 20. Must be >= 5 and <= 500.   Rescinding Torque Angle  Must be > 0.  Cable tools have the option to select Rescinding Torque for Angle. This restriction is controlled by two parameters: Peak Torque Percentageand Rescending Torque Time. Percentage sets the downward deviation from the last peak torque, and Rescending Torque Timesets the duration (between 5 and 500 ms) of that deviation. Only when both conditions (equal to or lower than the indicated percentage for the set duration) are met, will the program be interrupted and jump to the end."},{"id":"21903505035","fileName":"21903505035.html","title":"T - Maximum Torque","level":5,"position":169,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST STB IXB This restriction checks the torque. If the measured torque exceeds the Maximum limit, the tool is stopped immediately.      Parameter  Description     Maximum Limit  If the torque reaches this specified limit the tool is stopped immediately."},{"id":"21903523979","fileName":"21903523979.html","title":"TAW - Torque in Angle Window","level":5,"position":170,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST STB IXB This restriction checks that the measured torque in the Angle Window Lengthis between the Torque limits. If the measured torque is outside the limits the tool is stopped immediately and the program jumps to the end. The Angle Window Length starts at the Start Anglefrom the point that the torque first passed the Trigger Torque. If Trigger Torque is not set, then the Start Angle begins at the start of the restriction. If the end of the Angle Window Length is not reached, the status of the restriction is NOK.      Parameter  Description     Trigger Torque  Must be >= 0    Start Angle  Must be >= 0    Window Length  Must be >0    Minimum Limit  Must be >= 0    Maximum Limit  Must be <= Minimum limit"},{"id":"21903527691","fileName":"21903527691.html","title":"TCD - Torque vs Current Deviation","level":5,"position":171,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST IXB This restriction verifies that all current measurements converted to the corresponding torque are, at most, the Maximum deviationaway from the actual torque measured with the torque transducer. The restriction starts when the torque reaches Trigger Torquefor the first time during the step and is active until the step reaches its target. If Trigger Torqueis never reached, the monitor will report OK.      Parameter  Description     Trigger Torque  Must be >= 0    Maximum Deviation  Default: 1, Must be > 0"},{"id":"21903520267","fileName":"21903520267.html","title":"TG - Torque Gradient","level":5,"position":172,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST IXB This restriction checks the gradient and if it is outside the limits the tool is stopped immediately and the program jumps to the end of the program.      Parameter  Description     Gradient Angle Window  Specifies Angle Window:   For Hard Joint: Angle Window= 1 deg.  For Soft Joint: Angle Window= 20 deg.   Manual: Manually set Angle Window.    Angle Window  Available when Gradient Angle Windowis set to Manual. Must be > 0 and <= 100.    Trigger Torque  Must be > 0 and < Tool MaxTorque.    Damping  Frequency in which the gradient is being calculated. Must be > 0 and < 100 and < Angle window.    Minimum Limit  Must be >= -100.    Maximum Limit  Must be > -100 and > Low limit.    Torque Filter Type  The type of the filter:    None: No filtering of the torque is used. The raw values are used as-is in the gradient calculation.   Five-point: The torque value used in the calculation are filtered using a sliding average filter over 5 torque samples.   Low pass: The torque values is filtered with a simple discrete Infinite Impulse Response filter.   Sliding Average: The torque values used in the calculation are filtered using a sliding average filter over a Number of Samplesspecified by the use.    Cut-off Frequency  Needs to be specified when Torque Filter Typeis set to Low pass:   20 Hz  40 Hz  90 Hz  200 Hz  600 Hz    Number of Samples  Needs to be specified when Torque Filter Typeis set to Sliding Average:   2  4  6  8  16  32"},{"id":"21903507467","fileName":"21903507467.html","title":"Ti - Maximum Time","level":5,"position":173,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST STB IXB This restriction checks the time. If Maximum Limitis reached, the tool is stopped immediately.      Parameter  Description     Maximum Limit  If this time is elapsed, the tool is stopped immediately."},{"id":"14689638539","fileName":"14689638539.html","title":"Result Reporters","level":4,"position":174,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs"],"content":" The result reporters makes it possible to extract specific values of selected producer from the result. The result reporters belong to a step but has to be tied to the monitor\/restriction which they read the values from. Only monitors or restrictions located in the same step as the result reporter can be selected. A result reporter is added to a step using drag and drop (in the same way as monitors and restrictions). Each result reporter is responsible for reporting a specific result value, for example, Rundown Angle, Final Torque, Prevailing Torque. It is possible to tie a result reporter to:   Program monitors  Step monitors  Step restrictions Each result reporter defines a final value type:   Final Angle  Final Torque  Prevailing Torque  Self-tap Torque  Current  Rundown Angle  Number of Pulses General Parameters      Parameter  Description     Producer  Specifies which monitor\/restriction produces the value.    Value  Specifies which value to show from the selected producer.  Limitations:  It is only possible to add a result reporter on a monitor\/restriction belonging to a step in main path or a program monitor\/program restriction.  There may exist several reporters on a step if they are of different type.  There may exist a result reporter of, for example, type final angle on every step and program monitor angle.  For those monitor\/restrictions that have more than one result value, it is possible to add more than one result reporter if the result reporters are of different types.  There may not exist several result reporters of the same type on a step or on a program monitor\/restriction.  There is only one result reported for each possible final value type.  Rules:  The internal number of a result item has to be the same as for the corresponding result reporter.  The internal number of a monitor\/restriction result has to be the same as the internal number of the monitor\/restriction in the configuration.  The step results has to be ordered according to the order of execution. The first executed step has to be first.  Possible values reported by a result reporter if present in the monitor\/restriction\/step:  The monitors\/restrictions measured value (as float or integer)  The monitors\/restrictions high and low limits  Status  Torque trigger and angle trigger  Angle target and torque target (read from the step)  Possible values for status:  Low  OK  High  Other  NotSet The target values do not belong to any step monitor so the target values are taken from the step that the monitor belongs to."},{"id":"5148077963","fileName":"5148077963.html","title":"Adding a Multistep Program","level":4,"position":175,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs"],"content":"    On the Home view, select the TighteningTab. Then, on the left, select Multistep program library.  Select the Plus icon at the upper-right corner of the GUI. Then, select the needed type of program (Tightening or Loosening).  Drag and drop tightening steps, monitors and restrictions in the tightening area.  Steps can only be placed between the start and end points of the program, whilst monitors and restrictions can only be placed on steps.      Function   Description    Start and end points    Start and end points of the multistep program. All steps must be placed between these two points.   Adding a step    Drag a step from the list and drop it in the desired position between the start and end points.   Moving a step    Click and hold a step and move it to the desired position   Showing step properties    Click on the step to reveal the properties   Closing step properties    Click anywhere in the tightening area to close the properties menu   Deleting a step    Open the step properties and click Deleteat the bottom of the menu   Adding a restriction\/monitor    Drag a restriction\/monitor from the list and drop it on the appropriate step.   Moving a restriction\/monitor    Click and hold the icon (checkmark for monitor, stop sign for restriction) and drag and drop it on the appropriate step   Showing restriction\/monitor properties    Click on the restriction\/monitor icon to reveal the properties menu   Closing restriction\/monitor properties    Click anywhere in the tightening area to close the properties menu   Deleting a restriction\/monitor    Open the restriction\/monitor properties and click on Deleteat the bottom of the menu   Step error    When a validation error occurs in a step, that step will be marked. Note that when the step properties are opened, the parameter causing the error will also be marked.   Monitor\/Restriction error    When a validation error occurs in a monitor or restriction, that monitor or restriction will be marked. Note that when the monitor\/restriction properties are opened, the parameter causing the error will also be marked.   Forbidden placement    When a particular placement (of a step, monitor or restriction) is not allowed, the placeholder icon will not be shown.               "},{"id":"19472788363","fileName":"19472788363.html","title":"Deleting a Multistep Program","level":4,"position":176,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs"],"content":"    On the home view, go to the Tighteningtab and select Multistep program libraryon the left pane.  Select the multistep tightening program that you want to delete from the list.  Go to the bottom of the selected program´s parameters and select Delete. A warning pop-up window appears  Select Yesin the warning pop-up window to confirm your choice."},{"id":"5150672139","fileName":"5150672139.html","title":"Settings for a Multistep Program","level":4,"position":177,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs"],"content":" General Settings      Parameter  Description    Name  A user defined name for the multistep program.   Thread Direction  Direction of the threads, either clockwise (CW) or counter clockwise (CCW).   Loosening Program  Indicate if a loosening program is available. Choose from the list of available loosening programs in the controller.   Type  Type of program, either Tightening or Loosening.   Program Start  Gives the torque level for generating a result. If left blank, the result is generated every time the tool is started; otherwise result is only generated from the set torque level.   Program End Torque  Gives the torque value that stops a multistep tightening. The signal 168 - Program Endis true when, after a multistep tightening Program End Torquehas reached, and Program End Timeouthas elapsed. Default value for Program End Torqueis Tool max torque * 0.03.   Program End Timeout  Gives the time value (in seconds) that stops a multistep tightening. The signal 168 - Program Endis true when, after a multistep tightening Program End Torquehas reached, and Program End Timeouthas elapsed. Default value for Program End Timeoutis 0 seconds.   True Angle Compensation  Turns True Angle Compensation on or off (default is Off).   NOK on Trigger Lost  NOK on trigger lost switch controls whether or not it is allowed to release the tool trigger before the target condition has been reached on the last step. The toggle can be set to Onor Off.    Off- Releasing the trigger before reaching the target condition in the last step causes an OK tightening as long as all other conditions has been fulfilled.   On(default value) - Releasing the trigger before reaching the target condition in any step will be treated as a trigger lost and cause a NOK tightening. Attachment Tuning      Parameter  Description    Use attachment tuning  Select whether attachment tuning should be on or off.   Gear ratio  The gear ratio value can be between 0.5 and 100.0.   Efficiency tuning  The efficiency tuning value can be between 0.5 and 1.0.   Reversed rotation direction  Setting that allows reversing the direction of rotation.    Yes: Reversed   No: Not reversed (default) Program Monitor  Angle     Parameter  Description    Enabled  Turn angle monitoring Onor Offfor the entire program. If Active in stepsand Trigger Torqueare left blank, angle monitoring will start at program start.   Active in steps  Sets a range of steps this monitor is valid for:   If no start step is specified, this monitor will start at program start.  If no end step is specified, this monitor will stop at the last step of the program.   Type  Type of angle monitoring. Choose between:    Peak Angle: the highest angle reached during the monitor   Angle at Peak Torque: the angle at the point where the highest torque was reached during the monitor (Not available for STB tools)   Shut Off Angle: the angle at the shut-off point of the step   Angle at End: the angle at the end of the monitor, including the brake, if active.   Trigger torque  Sets the value of the trigger torque for angle monitoring. For STB tools, Trigger Torque will only activate in the tightening direction when executing a tightening program; and only in the loosening direction when executing a loosening program.   Low limit  Sets angle monitoring (program) lower limit.   High limit  Sets angle monitoring (program) higher limit.  Torque     Parameter  Description    Enabled  Turn Torque monitoring Onor Offfor the entire program. If Active in stepsis left blank, torque monitoring will start at program start.   Active in steps  Sets a range of steps this monitor is valid for:   If no start step is specified, this monitor will start at program start.  If no end step is specified, this monitor will stop at the last step of the program.   Type  Type of angle monitoring:    Peak Torque: the highest torque reached during the monitor.   Shut Off Torque: the torque at the shut-off point of the step.   Low limit  Sets torque monitoring (program) lower limit.   High limit  Sets torque monitoring (program) higher limit.  Time     Parameter  Description    Enabled  Turn time monitoring Onor Offfor the entire program. This monitor checks that the time is within the specified limits.   Active in steps  Sets a range of steps this monitor is valid for:   If no start step is specified, this monitor will start at program start.  If no end step is specified, this monitor will stop at the last step of the program.   Trigger torque  Sets the value of the trigger torque at which this monitor shall start.   Low limit  Sets time monitoring (program) lower limit.   High limit  Sets time monitoring (program) higher limit. Program Restrictions      Parameter  Description    Maximum Time Limit  Set amount in seconds. This restriction checks the total time for the tightening and if it exceeds the Time Highlimit the tool is stopped immediately. The time is measured from the start of the program.   Maximum Torque Limit  This restriction checks the torque and if the measured torque exceeds the Torque Highlimit the tool is stopped immediately.  Angle     Parameter  Description    Enabled  Turn angle restriction Onor Offfor the entire program. This restriction checks that the angle is within the specified angle limits.   Active in steps  Sets a range of steps this restriction is valid for:   If no start step is specified, this restriction will start at program start.  If no end step is specified, this restriction will stop at the last step of the program.   Trigger torque  Sets the value of the trigger torque at which the this restriction shall start.   High limit  Sets angle restriction (program) higher limit.  Time     Parameter  Description    Enabled  Turn time restriction Onor Offfor the entire program. This restriction checks that the time is within the specified time limits.   Active in steps  Sets a range of steps this restriction is valid for:   If no start step is specified, this restriction will start at program start.  If no end step is specified, this restriction will stop at the last step of the program.   Trigger torque  Sets the value of the trigger torque at which this restriction shall start.   High limit  Sets time restriction (program) higher limit. Reporters This enables the user to choose which values (from monitors\/restrictions) shall be shown as final values. Click Addto choose a result reporter to be tied to a program monitor\/restriction value.      Parameter  Description    Reporter  Select a result reporter.   Producer  Select which monitor\/restriction produces the value.   Value  Select which value to show from the selected producer. Residual Torque Correlation Factor  The setting is only valid for low reaction tightening steps. The following steps are supported:   TensorPulse Tighten to Torque (TPT)  TensorPulse Loosen to Torque (TPT)  Impulse Tighten to Torque (IT)  Impulse Loosen to Torque (IT)      Parameter  Description    Enabled  Select whether residual torque correlation factor should be Onor Off.   Residual torque correlation factor  The value can be between 50 to 150. Trace Configuration The trace configuration can be done on program level or for each step. The default configuration is set on the program level and can be overridden in each step as needed. Here, enabling this function allows the configuration to be done on program level.      Parameter  Description    Enabled     On: Enables the trace resolution configuration on program level.   Off: The trace recording is done with the same resolution for the whole tightening. In this case, the trace points are evenly distributed in time over the whole tightening. For each time slot (0.25 ms) two values (the minimum and the maximum measured value) are displayed in the trace. The maximum number of samples in this format is 2000.   Sample Type     Sample Time: specifies how often samples should be stored in the trace by specifying a sample time in ms.   Sample Angle: specifies how often samples should be stored in the trace by specifying a sample in deg.    Sample Time  Choose the sample time from the drop-down list (0.25 - 1000 ms)   Sample Angle  Choose the sample angle from the drop-down list (0.25 - 20 degree) Validation      Parameter  Description    Validate against tool values  Use Onif tool is known and set Max Torqueand Max Speed. Use Offif tool is not known.   Tool  Drop-down for choosing the tool to validate against.   Max torque  Max torque of the tool to validate against.   Max speed  Max speed of the tool to validate against. "},{"id":"6359545867","fileName":"6359545867.html","title":"STB Tools and Multistep","level":4,"position":178,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs"],"content":" Due to the wireless nature of STB tools, some multistep functions and behaviors may differ. Besides the general limitations listed here, descriptions of multistep functions will be additional information on STB tools where necessary. Program Validation All tightening programs will be validated for compatibility with STB tools before the program is downloaded to the tool. If the chosen tightening program is not compatible with the tool, the tool will be locked. When this error occurs, it will trigger event 5030, \"Configuration complexity exceeded\". To unlock the tool, reduce the complexity of the tightening program, or choose a different tightening program altogether."},{"id":"60434059","fileName":"6043405928074188683.html","title":"Tightening Program Configuration - General Parameters","level":3,"position":179,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab"],"content":"  Changes made to tightening programs in any section need to be actively applied by clicking the Apply button in the bottom right corner of the GUI. Alternatively, changes can be undone by clicking the Undo button in the same location. When navigating away from the section where changes have been made (by using the Back, Home or Result button), the user will be presented with a warning pop-up where the changes can also be applied or undone. The user cannot proceed without applying or undoing changes. The general tightening program settings is used to set up and manage the tightening programs by naming tightening programs, to make general tightening settings such as selecting tightening strategy, Manual or Quick prog mode, and to set the tightening program target value.  For more information about tightening parameters, see Start Stage, Rundown Stage, Tightening Strategies, and Stop Stage. For more information about Loosening parameters, see Loosening a screw. "},{"id":"60436875","fileName":"60436875.html","title":"Name","level":4,"position":180,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Program Configuration - General Parameters"],"content":" Use the Namefield to give the tightening program a name. This name will be stored with the tightening results and sent to ToolsNet (if applicable). The name can be maximum of 32 characters long."},{"id":"19472794251","fileName":"19472794251.html","title":"Strategy","level":4,"position":181,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Program Configuration - General Parameters"],"content":"  Strategysets the tightening strategy to be used with the tightening program. For more information about the available strategies and the relevant parameters, see Tightening Programs. "},{"id":"60452235","fileName":"60452235.html","title":"Target","level":4,"position":182,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Program Configuration - General Parameters"],"content":" The Quick step, Two step, and Three step strategies enable the choice of tightening towards either a Target torque or a Target angle value. When TurboTight is activated, only the Target torque option is available."},{"id":"60455307","fileName":"60455307.html","title":"Time Monitoring (elapsed time)","level":4,"position":183,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Program Configuration - General Parameters"],"content":" Time monitoring is available for all tightening strategies except Rotate. Time monitoring can be activated when angle limits are activated. Time monitoring is available for the rundown step and the final step of the tightening step.  To minimize the risk of unexpected jerk at the end of the tightening when using the TurboTight tightening strategy, make sure to activate Time monitoring.  Since handling the trace takes time, there is always a short difference between the Program elapsed time compared to Step elapsed time . This is especially noticeable in programs containing only one step.  When using an STB tool it is not possible to use time monitoring if all monitoring options are switched on. "},{"id":"2683165451","fileName":"2683165451.html","title":"Attachment Tuning","level":4,"position":184,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Program Configuration - General Parameters"],"content":" Attachment tuning gives the possibility to compensate for front attachments on the tool. The compensation can be made for each tightening program. An operator can hot swap an attachment and then select a tightening program tuned for that specific attachment. Attachment tuning is available for all conventional strategies except for the STwrench.    In Tightening program settings, set Attachment tuning enabledto Yes  Click on Tightening parameters > Edit  Click on the start step.  Under Attachment tuning, set Use attachment tuningto Yes  Set the necessary parameters for Gear ratioand Efficiency tuning(see table below).   Parameters for Attachment tuning     Attachment tuning  Description  Default     Attachment gear ratio  The Attachment gear ratiois needed to compensate the angle. Minimum: 0.5 Maximum: 100 Socket rotation speed = Tool speed \/ gear ratio  1.0    Efficiency tuning  Attachment gear ratio combined with the Efficiency tuningis needed to compensate the torque. Minimum: 0.5 Maximum: 1.0 For example 0.9 means 10% efficiency loss.  1.0 "},{"id":"59217035","fileName":"5921703528074064011.html","title":"Working with the Batch Sequence Tab","level":2,"position":185,"hasContent":true,"hierarchy":["Configuration"],"content":"   Controller features, such as the Low Reaction Tightening Strategies and controller-wide functions among others, require licenses distributed through the Functionality Management System (FMS). Whereas configuration of features is possible without specific licenses, the assignment and use of those features will require the correct license to be installed on the controller. Please refer to Licenses (FMS) for more detailed information on licenses.  Batch sequences are used to perform a specified number of tightenings in a specific order. Each batch sequence is given a name. "},{"id":"59223435","fileName":"59223435.html","title":"Batch Sequence Settings","level":3,"position":186,"hasContent":true,"hierarchy":["Configuration","Working with the Batch Sequence Tab"],"content":" A batch sequence can consist of up to 99 batches, with a batch size of up to 250 tightenings. The batches in a batch sequence are carried out in the order listed, or by using a Socket selector to choose which batch to run.  Batch settings parameters     Parameter name  Description  Default value    Lock tool on Batch sequence compl.  A batch sequence is completed when the batch sequence counter is equal to the batch sequence size.  On:The tool is locked and a tightening program or batch sequence must be selected to continue performing tightenings.  Off:After completion, the batch sequence is ready to be repeated.  On   Free order   No:The configured batches will be executed in the order listed, provided they have been configured to perform tightenings. If socket has been specified, the system will prompt for the socket when the batch is to be performed.  Yes:The configured batches can be executed in any order. The operator must indicate to the system which batch is to be executed by using a Socket selector. A batch is regarded as complete when all joints have been completed.  No   Increment on NOK  Makes it possible to increment the batch counter value even though the tightening is reported as NOK. For Max consecutive NOK to work (the maximum number of times a single bolt can be tightenened), Increment on NOK must be set to No. Setting this parameter to Yes, will allow the sequence to move on to the next tightening.  No   Max consecutive NOK  Maximum consecutive not OK tightenings (NOK) are a defined maximum allowed number of NOK consecutive tightenings in a batch. If the Max consecutive NOKnumber is reached, the event Too many NOK tightenings (4020)is displayed.  0   Decrement on loosening  Decrements the counter within the currently active batch. Completed batched cannot be decremented.  Never:The setting is off. Counter is not decremented when loosening is performed in the active batch.  Always:The batch counter is decremented when a loosening is performed.  When last tightening was OK:If the preceding tightening was OK, the batch counter is decremented when a loosening is performed.  Never   Sequence abort timer   On:The selected batch sequence can be aborted within a specified time limit  Off:The selected batch sequence cannot be aborted.  Off   Abort time (10-600)  The number of seconds during which the selected batch sequence can be aborted.  10"},{"id":"59220363","fileName":"59220363.html","title":"Batch Configuration","level":3,"position":187,"hasContent":true,"hierarchy":["Configuration","Working with the Batch Sequence Tab"],"content":" A batch is set up to perform a specified number of consecutive tightenings using the same tightening program. Batches must have tightening program and batch size specified in order to run.  Batch configuration parameters     Parameter  Description    Tightening program  The tightening program to use with the batch.   Batch size  Number of tightenings the batch will perform. Max. number of tightenings in one batch is 250. Batch size 0 will give the batch an infinite number of tightenings.   Identifier number  When using a Socket selector, this is the socket position used to activate the batch."},{"id":"19472853899","fileName":"1947285389928074550155.html","title":"Working with the Sources Tab","level":2,"position":188,"hasContent":true,"hierarchy":["Configuration"],"content":"  External signals used as tasks for tightenings are configured in the Sourcesmenu. Sources are accessories or similar connected to a virtual station. Two types of source tasks are available:  Source Tighteningtask  Source Batchtask  Source Tighteningis used to select a single tightening program.  Source Batchis used to select a batch sequence, a series of tightening programs. "},{"id":"18996841227","fileName":"1899684122728074557579.html","title":"Source Tightening","level":3,"position":189,"hasContent":true,"hierarchy":["Configuration","Working with the Sources Tab"],"content":" The tightening menu shows a list of source tightening configurations. To link separate lists to a virtual station, go to the Virtual Stationtab, select the virtual station in question on the left pane and, on the Taskwindow, select Choose task. There, a Source can be chosen as a task. Source tightenings link a specific tightening program to an identifier number. When the identifier number is sent to the controller (either by external digital signal, or, in cases where a socket selector is used, by lifting the corresponding socket in the selector) the linked program will run according to the source tightening configuration. It can either run repeatedly, or as a batch with a batch size configured either in the source tightening list or set dynamically by an external system.  Source Tightening lists can be set either in Control or Confirm mode.  In Control mode, an external source selects a tightening program by requesting an identifier number. In case of a socket selector, the identifier number is linked to a corresponding socket in the socket selector, and the tightening program is selected by lifting the socket.  In Confirm mode, the socket selector cannot be used as a controlling source. In this mode identifier numbers are linked to both a tightening program and a specific socket (indicated in an additional column in the list). When an identifier number is requested (by an external signal), the corresponding socket is prompted in the socket selector and the tightening program is activated when the operator lifts the socket (other sockets are disabled). If no socket is specified (that is, set to 0 in the Socket column), the tightening program is activated directly and the socket status is ignored.  POWER FOCUS 8can store up to 250 sources. "},{"id":"19472981259","fileName":"19472981259.html","title":"Configuring a Source Tightening","level":4,"position":190,"hasContent":true,"hierarchy":["Configuration","Working with the Sources Tab","Source Tightening"],"content":"  Changes made to tightening programs in any section need to be actively applied by clicking the Apply button in the bottom right corner of the GUI. Alternatively, changes can be undone by clicking the Undo button in the same location. When navigating away from the section where changes have been made (by using the Back, Home or Result button), the user will be presented with a warning pop-up where the changes can also be applied or undone. The user cannot proceed without applying or undoing changes.    On the home view, go to the Sourcestab and select Tighteningon the left pane.  Select the plusicon in the upper-right corner of the screen.  Give the Source Tightening a name and select the correct Selector mode(Control or Confirm, depending on what is required).  By default, only one editable Identifier number will be available when creating a new Source Tightening. At the bottom of the screen, select the plusicon to add more.  Give every item an identifier number  If a socket selector is used, the identifier numbers will correspond to the positions in the socket selector, i.e. Identifier number 1 corresponds to socket number 1 in the socket selector.  Choose a tightening program to link to each identifier number by clicking on Programand choosing from the list of tightening programs. "},{"id":"14088079115","fileName":"14088079115.html","title":"Source Tightening Properties","level":4,"position":191,"hasContent":true,"hierarchy":["Configuration","Working with the Sources Tab","Source Tightening"],"content":"      Parameter  Description     Name  The name issued to the source tightening.    Selector mode   Control: An external source selects a tightening program by requesting an identifier number. The identifier number is linked to a corresponding socket in the socket selector, and by lifting the socket the tightening program is selected.  Confirm: The socket selector cannot be used as a controlling source. In this mode identifier numbers are linked to both a tightening program and a specific socket (indicated in an additional column in the list). When an identifier number is requested (by an external signal), the corresponding socket is prompted in the socket selector and the tightening program is activated when the operator lifts the socket (other sockets are disabled). If no socket is specified (that is, set to 0 in the Socketcolumn), the tightening program is activated directly and the socket status is ignored.    Max consecutive NOK per program   On: The batch counter increments even when a tightening operation fails.  Off: Set Max consecutive NOKfor the tightening. The batch will only advance if a successful tightening is performed.    Max consecutive NOK  Set the number of consecutive NOK results to be allowed. If the value is set to 0, there is no check performed for NOK tightenings. When reaching max consecutive NOK, the tool locks and the sequence execution is halted.    Batch control  Select how the source tightening is to be executed. The available options are:    No batch control Running the selected tightening program repeatedly.   Internal batch control For each program in the Identifier selector configuration section, set the batch size to be used when that program is selected.   External batch control External systems can set the batch size using either Open Protocol or Fieldbus. The batch size must be set by an external system; if not set when a program is selected, the tool will be locked. When batch control is Internalor External, source tightening can be configured to:    Lock tool on batch sequence completion When enabled, the tool automatically locks upon reaching the specified batch size.   Increment on NOK When enabled, the batch counter increments for both successful and failed tightenings.  External: Configure how many times a source tightening should be executed by using Open protocol or an external protocol. Any configuration change clears the source tightening to start over from a clean and known state (the batch count in the batch will be reset to 0). Ongoing tightenings are able to finish before the changes take effect.     Use Joint IDs  Source tightening can be configured to attach a Joint ID to each result, enhancing traceability in data analysis software like ToolsNet. When Use Joint IDsis enabled, you can configure a Joint IDfor each program in the Identifier Selector Configurationsection.     Empty Joint ID No Joint ID will be assigned to results from this selected program.   Joint ID when not running batch The configured Joint ID will be attached to each result when the program is selected. If the program runs multiple times, it will use the same joint ID for all iterations.   Joint ID when running batch Joint ID behavior varies based on its format.   If the joint ID does not end with a number, the same joint ID is used for all tightenings in the batch.  If the joint ID ends with a number,   The number increments with each increase of the batch counter.  The joint ID's ending number may not match the batch counter. Example: If the initial joint ID ends with 5, after two tightenings:   The batch counter will be 2.  The joint ID will end with 7."},{"id":"19429217803","fileName":"1942921780328074565003.html","title":"Source Batch Sequence","level":3,"position":192,"hasContent":true,"hierarchy":["Configuration","Working with the Sources Tab"],"content":" To access to the Source Batch configuration, go to the Sourcestab on the home view and select Batch Sequenceon the left pane. The controller can be configured to select a batch sequence based on either an identifier number or an identifier string.       Input  Description     Identifier number  The number must be a positive integer number that can originate from an accessory or from an external control entity.    Identifier string  The string must consist of ASCII characters and can originate from a scanner or from an external control entity.  "},{"id":"19474248203","fileName":"19474248203.html","title":"Creating a Source Batch","level":4,"position":193,"hasContent":true,"hierarchy":["Configuration","Working with the Sources Tab","Source Batch Sequence"],"content":"    On the home view, go to the Sourcestab and select Batch sequenceon the left pane.  Select the plusicon in the upper-right corner of the screen.  Give the new Source Batch a name  Set the Abort on new identifierto Yesif scanning a new identifier string should abort the previous scan.  Select the Identifier method(string for text, or number for numerical strings).  Set Free orderto Onif the strings should be able to be scanned in any order.  Identifier strings can be made up of up to 4 different strings. When Free orderis set to Off, the strings need to be scanned in a specific order for the system to recognize the string.  If required, add an identifier string by selecting the plusicon in the Identifier string configurationsection.  Select the Namelabel for the identifier string you want to change the properties of, a pop-up window will appear. The following properties can be indicated per string:   Name: the name of the string  Length: the length of the string. SeeCombining Identifier Stringsfor more information on concatenating strings.  Significant positions: these are used to specify which characters in the barcode string to read when putting together the string to match with your pre-defined string. The number of significant positions must match the number of characters in the pre-defined strings.  Saved positions: these indicate which parts of each string are used when the Source Batch is saved, and how they are represented in the log. Indicate in this field the positions in the string that need to be saved. Positions can constitute only parts of the entire string. If the field is left empty, the entire (concatenated) string will be saved. The table below shows some examples of saved position combinations. Saved position values are comma-separated (without spaces), and ranges are indicated using a hyphen.      Identifier string  Positions    String 1: 1234567  1-7   String 2: abcdef  8-13   String 3: GHIJKL  14-19   String 4: 890  20-22  Saved position examples     Saved positions  Saved results    (empty)  1234567abcdefGHIJKL890   1-3,9,11,15,20-22  123bdH890   8-12,1-7,19,20-21 will be changed automatically to: 1-12,19-21  1234567abcdeL89  The ID field in the string properties window cannot be altered, it can only be used to navigate between the different strings.  An error may occur when Free orderis set to On, and the lengths of the different strings are duplicated. The scanned sequence will then not activate a tightening program. To avoid this error, set Free orderto Off, or adjust the string lengths.  Select Edit.  In the Editwindow, indicate which strings (in the String containscolumn) should be linked to which Batch sequence (in the Activatescolumn). Click the plusicon at the bottom to add more strings.  Wildcards can be used when typing the \"string contains\". The wildcards can be used at any position in the string. No Batch sequence is activated in case of an ambiguous matching result. The wildcard is a . (period) "},{"id":"59277835","fileName":"59277835.html","title":"Configuring Significant Positions to Read in Barcode String","level":4,"position":194,"hasContent":true,"hierarchy":["Configuration","Working with the Sources Tab","Source Batch Sequence"],"content":" The positions in the barcode string are associated with a number between 1 and 1024. The first position of the string is 1 and the last is 1024.  The significant positions must be specified following the rules described in the table below. Barcode strings:      Description   Significant positions   Valid configuration   Barcode string to match with pre-defined string    Significant positions in order  1,2,3,7,8  Ok  ABCGH   Significant positions in optional order  7,1,2,3,8  Ok  GABCH   Range of numbers  1–3,7-8  Ok  ABCGH"},{"id":"19036731019","fileName":"19036731019.html","title":"Combining Identifier Strings","level":4,"position":195,"hasContent":true,"hierarchy":["Configuration","Working with the Sources Tab","Source Batch Sequence"],"content":" The identifier stringthat is used for matching is a combination of up to four strings from a factory management system or up to four scanner inputs that need to be combined into one string. The Addand Deletebuttons manage how many strings are combined. The following parameters are available:  Parameters for combining identifier strings     Parameter  Description     Name  The string must be given a name.    Length  The length of the string must be known and must be entered. This is important to be able to combine the correct string identifier.    Significant positions  The comma-separated positions or ranges (separated by hyphen) in the combined string that are used for matching.    Saved positions  The comma-separated positions or ranges in the strings that will be saved in the result. If more than one identifier stringis to be used, perform the following steps:    Select the Addbutton to create a new entry on the table.  Give the string a name.  Enter the length of the string.  Repeat steps 1-3 for every string to be added. Up to four strings can be combined. The Start-End parameters in each row define the individual string positions in the combined string identifierthat will be used in the next step of the matching process. Performing a task selection process using an identifier stringas an input:    Define which positions in the string are to be activated.  Enter the significant positions to define which positions in the identifier stringwill be used for the matching. The positions must be either comma-separated, or by range."},{"id":"19191308555","fileName":"1919130855528074528395.html","title":"Working with the Tool Tab","level":2,"position":196,"hasContent":true,"hierarchy":["Configuration"],"content":" This tab provides information about the tools connected to the controller, including wireless tools. Some of the data available in this section is the QA calibration, the tool reference product and the service and calibration of the tool.  A tool must be connected to the controller for the Toolmenu to show information. "},{"id":"60342539","fileName":"60342539.html","title":"Tool Information","level":3,"position":197,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":" The Tool information view contains information used for giving service personnel accurate information about the tool connected to the controller, so that they can give adequate help and support, or for operators to see what tool is connected to the controller.  Tool information     Information  Description     Model  Tool model denomination.    Max torque  The maximum torque the tool can use for a tightening.    Min speed  The minimum rotation speed of the tool.    Max speed  The maximum rotation speed of the tool.    Min final speed  The minimum final rotation speed of the tool (only for BCP\/BCV-RE tools).    Max final speed  The maximum final rotation speed of the tool (only for BCP\/BCV-RE tools).    Gear ratio  The ratio of the angular velocity of the input gear to the angular velocity of the output gear.    Serial number  The tool’s serial number may be needed when the correct version of the Product instruction is required, in order to get the correct spare parts or service instructions.    Software version  The software version of the tool.    Product number  The product number or ordering number of the tool.    Production date  The manufacturing date of the tool.  IxB Connect Tool Information     Information  Description    Connection type  Tool connection type (WLAN\/Bluetooth\/Cellular) to the controller.   IP Address  Tool IP address when connected via WLAN.   MAC address  The MAC address of the connected device.  IPB-P Tool Information     Information  Description     Torque Adjustment Factor  Pulse tool torque adjustment expressed in %. Tool TAG information  Tool TAG information is only available if the tool type is a STwrench.  STwrench tool information     Information  Description     TAG id  The programmable RFID TAG identification number that is programmed into the End-fitting tool(Socket).    Torque correction coefficient  In certain cases extensions may be needed to fit the application. In this case the wrench measurement must be compensated to show a correct value. To calculate the correction coefficient, refer to the latest version of the STwrench User Guide (printed matter number 9836 4134 01). The parameter is stored in the RFID TAG in the End-fitting tool.    Angle correction coefficient  In certain cases extensions may be needed to fit the application. In this case the wrench measurement must be compensated to show a correct value. To calculate the correction coefficient, refer to the latest version of the STwrench User Guide (printed matter number 9836 4134 01). The parameter is stored in the RFID TAG in the End-fitting tool.    Nominal torque  The smartHEAD of the STwrench contains the torque transducer and defines the wrench’s nominal torque. For more information, refer to the latest version of the STwrench User Guide (printed matter number 9836 4134 01).  The correction coefficients alter the STwrench measurement. It may cause an improper reading. Before making any corrections, refer to the latest version of the STwrench User Guide (printed matter number 9836 4134 01). "},{"id":"67529611","fileName":"67529611.html","title":"Tool Connection","level":3,"position":198,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":" The tool connection area shows which virtual station the tool is connected to. "},{"id":"27350206347","fileName":"27350206347.html","title":"Transducer Information","level":3,"position":199,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":"  Only available for QST and IxB tools. A tool can have several torque and angle transducers depending on tool type. An image shows the position of the transducers. Select Detailsfor more information about the torque or angle transducers. Depending on transducer type the following information can be available.  Angle transducer     Information  Description     Enabled  Indicates if the transducer is enabled.    Gear ratio  The gear ratio between the transducer and the out-going shaft of the tool.    Wind-up  The wind-up compensation factor for the angle transducer.  Torque transducer     Information  Description     Enabled  Indicates if the transducer is enabled.    Serial Number  Serial number of the transducer as a string.    Article Number  Article number of the transducer as a string.    Calibration Value  Calibration value for the transducer expressed in Nm."},{"id":"19474736011","fileName":"19474736011.html","title":"Tool Health","level":3,"position":200,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":" The Healthpane contains information about tool temperature. Tool temperature Tool temperatures (both for cabled and battery tools) are monitored continuously by the POWER FOCUS 8. Supported temperature units are degrees Celsius (°C) and degrees Fahrenheit (°F), with Celsius as the default unit. When the tool motor temperature or tool electronics temperature exceeds max temperature, the tool is locked and an alert (2014) is shown. The tool is once again unlocked when the tool temperature drops below the temperature limit.  Tool temperature is not available for the STwrench. Monitoring Tool Temperature Using the tool's display or through the web interface, access the latest tool electronics and tool motor temperatures measured together with the timestamp when the measurement was taken.    On the home view, go to the Tooltab.  Both tool electronics temperature and tool motor temperature are listed under the Healthleft pane. For pulse tools, the Tool pulse unit temperature is also listed.  Select the Peak Temperatureview to see a list of the highest temperature peaks for the component.  Select the Real time temperatureview to continuously monitor the temperature of a component."},{"id":"19474833675","fileName":"19474833675.html","title":"Tool Maintenance","level":3,"position":201,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":" The tool stores a service interval number and counts how many tightenings can be performed before a tool maintenance, or service is needed. Setting the Maintenance Alarm    On the home view, go to the Settingstab and select Alarmson the left pane.  On the Maintenancewindow, set the Service indicator alarmto On.  Return to the home view, go to the Tooltab and select the tool to set the alarm for.  On the Maintenancewindow, enter a value in the Service intervaltext box.  Service intervals can only be set in multiples of 10 000. Any number other than multiples of 10 000 is rounded off to the nearest multiple of 10 000.  When working with pulse tools, both service intervals for number of tightenings and number of pulses is set. Whichever interval is reached first will trigger the alarm.  Maintenance parameters     Field  Description     Last service  Date and time when last service was performed. The Last service date is set at the repair workshop. The Last service dateis set to current date and time when the Reset service countbutton is pressed.    Total tightenings at service  Total number of tightenings performed by the tool since it was used for the first time. This value is made available at service, and will remain the same until next service.    Remaining tightenings  Total number of tightenings left until the service interval is reached.    Total number of tightenings  Indicates the total lifetime tightenings of the tool.    Number of services  The number of times the tool was serviced.    Tightening service indicator  Indicates the percentage of depleted service interval.    Service interval  Number of tightenings to be performed between two service events. Can be set in multiples of 10 000.    Total pulses at service  [Pulse tools only] Total number of pulses performed by the tool since it was used for the first time. This value is made available at service, and will remain the same until next service.    Remaining pulses  [Pulse tools only] Total number of pulses left until the service interval is reached.    Service interval  [Pulse tools only] Number of pulses to be performed between two service events. Can be set in multiples of 10 000.    Reset service counter  Reset of the Remaining tighteningscounter and sets Last service dateto current date.    Reset service data  [Pulse tools only] Reset of the Remaining tighteningscounter as well as oil status and sets Last service dateto current date."},{"id":"59654923","fileName":"5965492328074535819.html","title":"Tool Calibration","level":3,"position":202,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":"  Tool calibrationis used to control how well a tool corresponds to a reference transducer. The calibration value stored in the tool memory is used to adjust the torque value given by the tool’s torque transducer so that the correct torque value is displayed on the controller. The controller displays the date when the tool was last calibrated.  Calibration parameters     Field  Description     Last calibrated  Date and time when last calibration was performed.    Calibration value  Torque value to calibrate against.    Next calibration date  Date when the next calibration of this tool is needed. "},{"id":"59658251","fileName":"59658251.html","title":"Preparing the Calibration","level":4,"position":203,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab","Tool Calibration"],"content":"    Make sure the tool and controller are set up to perform tightening.  Set up the tool with a torque reference transducer (such as the STa6000, STpad or JSB Bench).  Refer to the torque reference transducer User Guide for set-up instructions.  Select a Tightening program with a target torque corresponding to a tightening normally used with your tool.  See Basic Tightening setup for a tutorial on setting up and activating a suitable tightening program."},{"id":"19474840587","fileName":"19474840587.html","title":"Calibrating the Tool","level":4,"position":204,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab","Tool Calibration"],"content":" The calibration value used for the tool is calculated from the torque readings read from the controller, and the torque reference transducer through the equation below:  New calibration value = Old calibration value × Mean (Reference values \/ Controller values)    On the home view, go to the Tooltab and select the tool to be calibrated. Then, go to the Calibrationwindow.  Take note the old calibration value found in the Calibration valuetext box.  If the calibration value is adjusted by more than 10%, a confirmation prompt is displayed as the change may significantly impact the accuracy and performance of the system.  Make at least three tightenings and use the torque values read from the controller and the reference transducer (ACTA or similar) for calculating the mean torque values.  Calculate the new calibration value using the New calibration valueequation.  Store the new calibration value in the tool memory by entering the calculated value in the Calibration valuetext box and selecting Apply.  After calibration is completed, perform a tightening to verify that the new values are correct."},{"id":"19036737163","fileName":"19036737163.html","title":"QA Calibration","level":4,"position":205,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab","Tool Calibration"],"content":"    On the home view, go to the Tooltab and select QA Calibrationon the left pane.  Modify the parameters on the QA Calibrationwindow and select Applyto implement the changes.       Parameter   Description    Enable  ON: Enables the external tool configuration option OFF: Disables the external tool configuration option.   Virtual station  Select the ellipsisicon to connect the tool to a virtual station.   Connection type  Connect via TCP port or Connect via COM port.   COM port  Visible when Connection type COM portis selected. Shows a drop-down list with the available COM ports.   TCP port  Visible when Connection type TCP portis selected. Shows the TCP port, pre-populated."},{"id":"19474847243","fileName":"19474847243.html","title":"Calibrating a Tool Through the STa6000 or STpad","level":4,"position":206,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab","Tool Calibration"],"content":" Connecting the STa6000\/STpad The STa6000\/STpad can be connected to the controller in two ways:    Connecting the STa6000      Connection  Remarks    COM port  Connect the Atlas Copco USB to Serial adapter to the controller's USB port using the ACTA Serial cable. Connect the STa6000 to the Serial Adapter using a USB cable.   Ethernet port  Connect the ethernet cable between the STa6000 and the controller's Factory Ethernet port, or the factory network.    Connecting the STpad      Connection  Remarks    COM port  Connect the STpad to the Controller's COM port using the ACTA Serial cable.   Ethernet port  Connect the ethernet cable between the STa6000 and the controller's Factory Ethernet port, or the factory network. Performing the QA Calibration through the STa6000 or STpad    Make sure the tool is connected and assigned to a virtual station on the controller.  Single tightening programs cannot be used for calibration purposes. Make sure a batch program is selected.  On the home view, go to the Tooltab and select QA Calibrationon the left pane. Then, set QA Calibrationto On.  Select the virtual station the tool to be calibrated is connected to, and select the connection type to be used (TCP of COM port).  Note that the default port for communication is 4561  Connect the STa6000\/STpad to the controller, and select the correct virtual station.  Start the calibration from the STa6000\/STpad.  The STa6000\/STpad requests controller information, including tool information and tightening program.  Execute the tightening. When the calibration device detects a tightening, it requests the tightening result from the controller.  Repeat the above step until all tightenings in the batch have been executed.  Once completed, the STa6000\/STpad creates a report, as well as calculate a new calibration value for the tool.  Select Store in the STa6000\/STpad to send the new calibration value to the controller, which in turn writes it to the tool.  During calibration, if the tightening program is changed, or the sequence\/batch is updated, the calibration is terminated.  There is no limit in the batch size used for calibration purposes. However, the STa6000 can only display two digits as batch size. Thus, the counter on the Sta6000 reads 00 for 100.  After calibration is completed, perform a tightening to verify that the new values are correct."},{"id":"23017200267","fileName":"23017200267.html","title":"Tool Diagnostics","level":3,"position":207,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":" In Diagnostics it is possible to run:   Sensor tracking  Diagnostic tests Sensor tracking To diagnose a tool, the angle or torque sensor, it is possible to start a Sensor tracking session in the Tool menu. A Sensor tracking session has a time out of 20 minutes. A warning is shown 5 minutes before timeout and it is then possible to extend the session or to stop it.  Sensor tracking is only possible for cable tools.  It is only possible to start one Sensor tracking session for each tool and controller at a time.    In the HOMEwindow select Tool.  Select Cable Tooland Sensor Trackingin Diagnostics.  Turn On Start sensor tracking.  Tool angle, torque and speed are shown.  Sensor tracking information     Tool angle  How much the tool has turned since the sensor tracking session started or since the last reset.   Torque  Readout: the instantaneous value for the torque. Peak value: the highest measured torque value since the sensor tracking session started or since the last reset.   Speed  Readout: the instantaneous value for the speed. Peak value: the highest measured speed value since the sensor tracking session started or since the last reset. Diagnostic tests To find out if a tool works correctly it is possible to do a diagnostic tests of the tool. The type of test that can be run depends on which tool is connected. Three different types of tests can be run:   Automatic production test: No action is required from the user.  Manual tests with no acknowledgment: The user has to do some tasks during the test.  Manual tests with acknowledgment: The user has to monitor and give feedback on the tool´s behavior.  It is only possible to start one diagnostic test for each tool and controller at a time. When the diagnostic test is started the session is locked for other clients. A diagnostic test session has a time out of 20 minutes. A warning is shown 5 minutes before timeout and it is then possible to extend the session or to stop it.  Diagnostic test information     Automatic production test  Manual test with no acknowledgment  Manual test with acknowledgment      Torque transducer shunt check  Torque transducer 2 shunt check    Start button\/Trigger  Safety trigger  Reverse ring\/switch or button  Push start  Function button    Speaker\/Buzzer  LEDs    In the HOMEwindow select Tool.  Select Cable Tooland Diagnostic Testsin Diagnostics.  Turn on Diagnostic Tests.  Select the test you want to run.  Follow the instructions on the screen.  All tests show result with green or red indication.  The diagnostic test times out if no action is done within 20 seconds.  A diagnostic test result is shown when the a test session is completed.  If you leave the diagnostic test page the result will disappear!  To export a test result; select the Exportbutton."},{"id":"27326159883","fileName":"27326159883.html","title":"Zero Offset and Shunt","level":3,"position":208,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":"  Only available for QST tools. For each torque transducer, the zero offset and shunt calibration limits can be viewed and changed.      Information  Description    Shunt value (1-100)  Maximum allowed measured shunt calibration value in %.   Shunt drift value (1-100)  Maximum allowed change in measured shunt calibration value in %.   Zero offset value (1-50)  Maximum allowed Zero offset compensation in %.   Zero offset drift value (2-100)  Maximum allowed change in the zero offset compensation in %."},{"id":"23123128331","fileName":"23123128331.html","title":"Zero Position","level":3,"position":209,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":" This configuration makes a system always return to the original start position for each tightening or sequence. Zero Position is set for each tool separately for both handheld and fixtured. Zero position sets the current position of the tool. It is not possible to set Zero Position during an ongoing tightening or sequence. Set a zero position:    In the home view select Tool.  Select Cable Tooland then Zero Positionin the right menu.  Select SET. The current position of the tool will be set as Zero Position."},{"id":"19474870411","fileName":"19474870411.html","title":"Tool Motor Tuning","level":3,"position":210,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":" A motor tuning adjusts the tool’s motor control unit to optimize the performance and minimize loss. For cable tools a motor tuning should be performed on each specific combination of controller and tool together. STB tools can be moved to another controller without the need to perform a new motor tuning. Before performing the motor tuning, make sure the tool is connected to a virtual station and that the controller is set up to perform tightening. The motor tuning takes approximately 1 minute to perform and rotates the spindle in both clockwise (CW) and counterclockwise (CCW) directions before it is finished.  For tools configured with open end Gear Front Attachment (GFA), remove the open end extension from the tool before performing the motor tuning. Performing tool motor tuning    On the home view, go to the Tooltab, select the tool to be motor tuned and go to Motor tuning.  Select Perform, and then press the trigger on the tool.  Select OKto start the Motor tuning. Follow the instructions on the screen and keep pressing the tool trigger until the motor tuning is done.   If the motor tuning is successful, an OK event is displayed.  If the motor tuning is not successful, or the tool trigger was released before the motor tuning is done, an NOK event is displayed."},{"id":"27379762699","fileName":"27379762699.html","title":"Unpair Bluetooth Connection","level":3,"position":211,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":" To unpair the tool from the controller, select Perform. The tool must be paired again over Bluetooth to reconnect."},{"id":"23515569291","fileName":"23515569291.html","title":"Front End Configuration","level":3,"position":212,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":" Configure the tool to use the correct front end attachment.    Go to Toolin the home menu and select Cable Tool > Front End Configuration.  Select the Front End Type. If Open End is selected, the following parameters can be set.  Before using the Gear Front Attachment (GFA) - whether Open Endor Closed End- ensure that the tool head and tool body are properly assembled and configured. Failure to do so may result in damage to the mechanical stop in the head, especially for the Open Endtype, if the tool operates in the wrong direction.      Settings  Description    Reversed rotation direction  Indicates the rotation direction.  Yes: Reversed  No: Not reversed (Default)   Tightening direction   CW: Default Tightening direction set to clockwise.  CCW Tightening direction set to counterclockwise.   Positioning limit   Manual Set the Torque positioning limit.  Auto: Default Torque positioning limit automatically set to 2% of maximum torque but at least 2 Nm.  Select Applyto set up the configuration. The tool will restart. Perform Open End tuning The Open End tuning function is available for tools configured with Open End Gear Front Attachment (GFA). The function calculates the true gear ratio of both the tool and the extension combined, and saves it to the tool. The tuning will take approximately two minutes to perform.  When the Open End tuning is completed the tool must be calibrated with the Open End extension attached.    Select Performand then press the trigger on the tool.  Follow the instructions on the screen and keep pressing the tool trigger until the Open End tuning is completed.   If the Open End tuning was successful an OK event will be displayed.  If the Open End tuning was not successful, or the tool trigger was released before the tuning was finished, an NOK event will be displayed."},{"id":"18997302667","fileName":"1899730266728074543243.html","title":"WLAN and Bluetooth for Wireless Tools","level":3,"position":213,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":" The POWER FOCUS 8controller has a radio module that supports Bluetooth and can create a WLAN network by acting as an Access Point. In Wireless AP mode only one channel can be selected. If both Wireless AP mode and Wireless Client mode are enabled, this only channel will be common for both modes. The connected tools can be used a client, an access point for other devices, or both.  POWER FOCUS 8supports twenty five tools connected using Access Point mode and six tools connected using Bluetooth mode. "},{"id":"18997312139","fileName":"18997312139.html","title":"Configuring a Wireless Client","level":4,"position":214,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab","WLAN and Bluetooth for Wireless Tools"],"content":"    On the home view, go to the Settingstab and select Networkon the left pane.  On the Wireless Clientwindow, select Edit.  Set Enabledto On.  Set DHCPto Onor Offdepending on the configuration. If set to Off, fill out the required information, provided by the local system administrator:   IP address  Subnet mask  Gateway  Enter a Network name (SSID).  On the Securitywindow, select Modeand choose a security mode from the list. If WPA2 Personalis chosen, enter a Security key.  Enter security parameters and import cert files and keys, as applicable.  Edit the Optional Settingsas applicable.  Select Apply. The controller will establish a wireless connection to the network.  To access the user interface wirelessly, type the IP address into a web browser."},{"id":"18997313675","fileName":"18997313675.html","title":"Configuring the Controller as a Wireless Access Point","level":4,"position":215,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab","WLAN and Bluetooth for Wireless Tools"],"content":"  If multiple channels have been configured previously in Wireless Client mode, enabling Wireless AP modewill update the channel list to contain only the current\/default channel for the Wireless AP mode.  It is possible to connect up to 32 tools to one access point.    On the home view, go to the Settingstab and select Networkon the left pane.  On the Wireless APwindow, select Edit.  Set Enabledto On.  Enter the required information, provided by the local system administrator:   IP address  Subnet mask  Gateway  To distribute IP addresses, set DHCP Serverto Onand enter IP range startand IP range stop.  Enter a Network name (SSID).  On the Securitywindow, select Modeand choose a security mode from the list. If WPA2 Personalis chosen, enter a Security keywhose length should be at least 10 digits or more.  Select Apply."},{"id":"18997334411","fileName":"18997334411.html","title":"Pairing Mode for Wireless Tools and STwrench","level":4,"position":216,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab","WLAN and Bluetooth for Wireless Tools"],"content":" Placing the Wireless Tool in Pairing Mode    Disconnect the (charged) battery from the tool.  Press the tool trigger while re-attaching the battery.  When the tool LEDs are off, release the tool trigger.  When the tool LEDs are on again, press the tool trigger.  When the tool LEDs are off again, release the tool trigger. Both LEDs start to flash (after approximately 10 seconds).  The tool is now in pairing mode. The LEDs keep flashing when the tool is in pairing mode.  Do not start the Power Focus pairing procedure before both LEDs on the tool are flashing. Initiate pairing within 30 seconds or the tool might time out.  When the tool is placed in pairing mode, tap the connection type to start the pairing process. Placing the STwrench in pairing mode    Turn on the STwrench.  During the cell and gyroscope adjustment, press the UP, RIGHT and BARCODE buttons on the STwrench keyboard in that order.  At the end of the zero adjustment, the wrench is in pairing mode.  When the tool is placed in pairing mode, tap the connection type to start the pairing process."},{"id":"18997339147","fileName":"18997339147.html","title":"Bluetooth Requirements","level":4,"position":217,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab","WLAN and Bluetooth for Wireless Tools"],"content":"  In order to use Bluetooth with the POWER FOCUS 8, the following requirements need to be met:   POWER FOCUS 8software 3.6 or higher  A wireless tool equipped with a Bluetooth module  Tool software boot version 9.1.6 or higher  Tool software app version 3.6.1 or higher"},{"id":"18997343883","fileName":"18997343883.html","title":"Wireless Tools Restrictions","level":4,"position":218,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab","WLAN and Bluetooth for Wireless Tools"],"content":" When all Bluetooth slots (6) are filled, additional wireless tools paired with the controller will replace existing paired tools. The rule governing this replacement is that offline tools will be replaced first, followed by online tools. Tools linked to a Virtual Station will never be replaced. When pairing an additional Bluetooth-equipped tool to a controller that already has six wireless Bluetooth tools linked to Virtual Stations, make sure to remove one of the paired tools from one of the Virtual Stations before pairing the additional tool. The tool disconnected from the Virtual Station will then be replaced by the new tool."},{"id":"18997349387","fileName":"18997349387.html","title":"Pairing a Wireless Tool to a Controller","level":4,"position":219,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab","WLAN and Bluetooth for Wireless Tools"],"content":"  The pairing of a Mechatronic Wrench to a controller is done differently than other wireless tools, and requires an MWRKit to be connected to the controller. Please refer to the tool's Product Instructions for more detailed information.  Before you start the pairing process:  Make sure to have virtual stations available.  Make sure Bluetooth is enabled in the Controller.  Make sure there are pairing slots available (6 for Bluetooth).  Check which radio channel to use  Check how to put the tool into pairing mode. See the corresponding documentation for the tools to be paired or follow the instructions below.  If possible, have a clear line of sight between tool and controller.  Make sure no other tools are being paired with the controller at the same time.    Enable Bluetooth on the controller by going to the Settingstab, selecting Wirelesson the left pane and then going to the Bluetoothwindow. Drag the Enabledswitch to On.  Set the radio channel to be used with the wireless tool. On the home view, go to the Settingstab, select Wirelesson the left pane and then go to the Bluetoothwindow. Drag the Enabledswitch to On.  Return to the home view and go to the Tooltab. Then, select the plusicon in the upper-right corner of the screen to start the pairing.  Put the tool in pairing mode.  On the Pairingdialog box, select Bluetoothto start the pairing process.  The pairing process will end with one of the following results:    Pairing successful: The tool has been paired to the controller using the selected channel.   Pairing unsuccessful: This can be due to any of the following reasons:   No tool detected during the pairing process. Make sure the tool is in range and in pairing mode, and then select Closeand try again.  More than one tool was found during the pairing process. Make sure no other tool is in pairing mode, and then select Closeand try again.  Pairing already in progress. Make sure no one else is performing the pairing process on the controller, and then select Closeand try again.  Pairing failed. Select Closeand try again."},{"id":"25800127627","fileName":"25800127627.html","title":"IxB Tools restrictions","level":4,"position":220,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab","WLAN and Bluetooth for Wireless Tools"],"content":" IxB connect functionality requirements The IxB connect functionality requires:   PF6000 controller from version 13 and above  PF8 controller revision 5 and above Maximum number of tool connections      Controller  Connectivity type  IxB tool no. of tools  IxB and other wireless tools no. of tools    PF6000  Wireless LAN  6  6 (no matter the combination)   Bluetooth supported tools = IxB\/XB tools only  4  NA   Bluetooth supported tools = No IXB\/XB tools  0  6 wireless tools   PF8  Wireless LAN  20  20   Bluetooth  6  6 (no matter the combination)"},{"id":"19474901259","fileName":"19474901259.html","title":"Connecting BCP\/BCV-RE Tools","level":4,"position":221,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab","WLAN and Bluetooth for Wireless Tools"],"content":" The process for connecting BCV and BCP tools to the controller is slightly different than for other types of tools.    On the home view, go to the Settingstab and select BCP\/BCV-REConnections.  Add a new BCP\/BCV-RE Connection configuration by selecting the plusicon in the upper-right corner of the screen.  Turn on the configuration and provide a name in the name field.  Fill in the Device port and the Device host of the tool you want to connect in the respective fields. You can find both pieces of information in the tool's Loader Software.  The tool is now connected to the controller. Assign it to a Virtual Station in order to use it with a tightening program."},{"id":"18734440587","fileName":"1873444058728074319243.html","title":"Working with the Virtual Station Tab","level":2,"position":222,"hasContent":true,"hierarchy":["Configuration"],"content":" Virtual stations are configured in the Virtual Stationmenu. A virtual station is a software abstraction of a physical station and can be set up to use a specific tool and remotely execute different tasks using the tool. In POWER FOCUS 8, it is possible to set up a number of 20 virtual stations per controller. Each virtual station can be connected to one tool and one or more accessories. By using virtual stations, the operator can operate multiple tools and run different tasks using the same controller. It is possible to connect one cable tool and multiple STB tools simultaneously to the controller. When configuring different tools, make sure the selected start signal in Start source matches the selected tool and that the selected task can be run on the specific tool.  Before any tightening can begin a task must be selected in the virtual stations menu. A task is of one of three types:  Tightening program  Batch sequence  Sources The selection can be made manually by the operator or by external signals. "},{"id":"18224029707","fileName":"18224029707.html","title":"Creating a Virtual Station","level":3,"position":223,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab"],"content":"    On the home view, go to the Virtual Stationtab and select the plusicon in the upper-right corner of the screen.  Edit the name and other parameters. The list of virtual stations created is presented in order of creation.   Controller features, such as the Low Reaction Tightening Strategies and controller-wide functions among others, require licenses distributed through the Functionality Management System (FMS). Whereas configuration of features is possible without specific licenses, the assignment and use of those features will require the correct license to be installed on the controller. Please refer to Licenses (FMS) for more detailed information on licenses.   If no tool configuration is available when assigning a tool, a new tool configuration is automatically created and assigned to the virtual station. This auto-created tools configuration will have Start source set to Trigger onlyand trace set to Off.For STB tools Start request will be set to On. "},{"id":"19000605707","fileName":"19000605707.html","title":"Deleting a Virtual Station","level":3,"position":224,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab"],"content":"    On the home view, go to the Virtual Stationtab and select the virtual station to remove on the left pane.  Select the Deleteicon at the bottom of the virtual station´s list of parameters."},{"id":"19474924683","fileName":"19474924683.html","title":"Assigning Licenses to a Virtual Station","level":3,"position":225,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab"],"content":"  To make virtual stations working, it is needed to assign them a Virtual Station Type license.    On the home view, go to the Virtual Stationtab and select the virtual station you want to assign licenses to on the left pane.  On the home view, go to the License Assignmenttab and select Virtual Station Typespane on the left.  The Change License Typewindow appears.  Select the Virtual Station Type license you want to assign to the virtual station.  If additional Virtual Station Featuresneed to be assigned, select Editin the Featuresfield.  The Select Featureswindow appears.  Check all features you want to assign to the virtual station and select OK."},{"id":"19474930315","fileName":"19474930315.html","title":"Unassigning Licenses from a Virtual Station","level":3,"position":226,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab"],"content":"    On the home view, go to the Virtual Stationtab and select the virtual station you want to unassign licenses from on the left pane.  On the home view, go to the License Assignmenttab and select Virtual Station Typepane on the left.  The Change License Typewindow appears.  Select the name of the assigned Virtual Station Type you want to unassign.  The Change License Typewindow closes and the Virtual Station Typefield will say None. All features will be removed from the controller as well.  When a Virtual Station is deleted, the licenses associated with that Virtual Station will automatically be returned to the Pool."},{"id":"18997373579","fileName":"1899737357928074326155.html","title":"Connecting a Tool to a Virtual Station","level":3,"position":227,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab"],"content":" A virtual station can only have one tool connected. Just one of the tools connected to a controller can be a cable tool. Added virtual stations can connect wireless tools paired to the controller. Each virtual station needs to have one tool configuration in addition to the tool. The tool configurations are created in the Configurationstab.     On the home view, go to the Virtual stationmenu and select the virtual station you want to connect the tool to on the left pane.  On the Toolwindow, select Choose toolto open the list of available tools. Or, if a tool is already chosen, select Change toolto open the list of tools available to change to.   On the list of available tools, tap the desired tool to connect it to the virtual station. Use the Searchbox, the scroll bar and the Filterbutton to search for a tool. For more information, seeFiltering, Sorting and Searching for Tools in a Virtual Station.  Non-available tools will be greyed out. To connect a greyed out tool to a virtual station, first disconnect it from its virtual station.  When the new tool is connected, assign a configuration to the tool on the Toolwindow. If there are more than one configuration available, a list of tool configurations appears.   To replace the tool configuration for the virtual station:  Select the ellipsisicon beside the name of the current configuration. A list of available configurations appears.  Choose another configuration from the list. It is not possible to deselect a configuration, only to select another available configuration.   "},{"id":"19126399755","fileName":"19126399755.html","title":"Filtering, Sorting and Searching for Tools in a Virtual Station","level":4,"position":228,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab","Connecting a Tool to a Virtual Station"],"content":"  POWER FOCUS 8allows to connect up to 20 tools. Use the scroll bar to the right of the tools list to navigate the list of available tools. Use the Searchbar at the top of the tools list to find a specific tool. Sort the tools list by tapping one of the following parameters located under the Searchbar:  Sorting options     Sorting option  Description     Tool Type  Tap this parameter to sort tools by type.    Max Torque  Tap this parameter to sort tools by maximum torque.    Virtual Station  Tap this parameter to sort tools by connection to a virtual station.    Model  Tap this parameter to sort tools by model.    TurboTight  Tap this parameter to sort the tools whose maximum torque when performing a TurboTight strategy differs from the tool´s maximum torque.    Configuration  Tap this parameter to sort tools by configuration.    Serial Number  Tap this parameter to sort tools by serial number.    TensorPulse  Tap this parameter to sort the tools whose maximum torque when performing a TensorPulse strategy differs from the tool´s maximum torque. Use the Filtericon in the upper-right corner of the screen to filter the list of tools.  Filtering options     Filtering option  Description    Available tools   Unselected: shows both the tools assigned and not assigned to a virtual station.  Selected: shows the tools that are not assigned to any virtual station.   Virtual Station compatible tools   Unselected: shows both the virtual station compatible and non-compatible tools.  Selected: shows all the virtual station compatible tools.  The filtering can be done in four ways by selecting the corresponding check box or check boxes on the filter pop-up window:  Show compatible tools for the virtual station license type assigned (default filtering: Available tools= Unselected, Virtual Station compatible tools= Selected).  Show all tools ( Available tools= Unselected, Virtual Station compatible tools= Unselected).  Show all tools except the ones assigned to a virtual station ( Available tools= Selected, Virtual Station compatible tools= Unselected).  Show virtual station compatible tools that are not assigned to any virtual station ( Available tools= Selected, Virtual Station compatible tools= Selected). Tap the Applybutton on the filter pop-up window to apply the selected filters. "},{"id":"19482029323","fileName":"1948202932328074339979.html","title":"Configuring the Task Window in a Virtual Station","level":3,"position":229,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab"],"content":" Selected tasks can either be running a tightening program, running a batch sequence or enabling a task using a source configured in the Sourcestab. Tasks can be monitored from the controller and the result of the tasks can be presented together with any events that may have occurred during the operation. "},{"id":"19482557579","fileName":"19482557579.html","title":"Assigning a Task to a Virtual Station","level":4,"position":230,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab","Configuring the Task Window in a Virtual Station"],"content":"    On the home view, go to the Virtual Stationtab, select a virtual station on the left pane and go to the Taskwindow.  On the Taskwindow, select the arrow beside Choose task.The Choose taskwindow appears.  On the Choose taskwindow, go to the corresponding tab and select a Tightening program, a Batch sequenceor a Source tighteningpreviously created on the controller. The selected task is now assigned to the tool connected to the selected virtual station."},{"id":"19474939147","fileName":"1947493914728074346891.html","title":"Configuring Manual Mode in a Virtual Station","level":4,"position":231,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab","Configuring the Task Window in a Virtual Station"],"content":" Manual mode for Virtual stations is used for performing tasks while the tool is in locked mode. In cases where the tool is locked for a certain reason (e.g. because the tool is outside its TLS footprint) there still may be a need to perform certain tasks with the tool, such as performing emergency work. By configuring manual mode for the virtual station, users can determine what signals are sent when entering manual mode (Entering signals), what task can be performed while in manual mode (Secondary task), and what signals are sent when leaving manual mode (Leaving signals). Since desired scenarios can vary between different users (i.e. which signals to send upon entry and exit and what task to perform), manual mode is fully configurable for each virtual station. Configuration consists of three elements: entering signals, leaving signals and secondary task (note that by primary task is meant the (automatic) task that is assigned to the virtual station under Task).    On the home view, go to the Virtual stationtab and select the virtual station to configure on the left pane. Then, go to the Taskwindow and select Set manual mode  On the Manual mode configuration screen, select Choose taskon the Secondary Taskwindow. This determines which task to run when in manual mode.  If no secondary task is set, the primary task will be used during manual mode.  All task types (tightening, batch sequence, source) can be set for the secondary task as for the primary task.  Set the entering signals by selecting the plusicon at the bottom of the Enteringsection. See the parameters for entering signals below.  Set the leaving signals by selecting the plusicon at the bottom of the Leavingsection. See the parameters for leaving signals below.  The maximum number of signals that can be set for entering and leaving is 99. "},{"id":"4504901899","fileName":"4504901899.html","title":"Entering and Leaving Signals","level":5,"position":232,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab","Configuring the Task Window in a Virtual Station","Configuring Manual Mode in a Virtual Station"],"content":" The parameters for entering and leaving signals are the same. There are two types of signals: Boolean and integer\/string type. For Boolean type signals, an on\/off (true\/false) switch is used. For integer\/string type signals, a text field is used where the (I\/O) signal or string can be indicated.      Signal  Type  Default value    Abort sequence  Boolean  Off   Acknowledge events  Boolean  Off   Activate tool scanner  Boolean  Off   Clear results  Boolean  Off   Disable Fieldbus  Boolean  Off   Disable Open Protocol Commands  Boolean  Off   Disable Tool scanner  Boolean  Off   Dynamic batch size  Integer  0   External identifier  Integer  0   External monitored [1-8]  Boolean  Off   Flash Tool Green Led (external protocol)  Boolean  Off   Generic IO [1-10]  Integer  0   Id for dynamic batch size  Integer  0   Reset batch  Boolean  Off   Reset batch sequence  Boolean  Off   Reset bistable relay  Boolean  Off   Reset Too Many NOK  Boolean  Off   Select input  Integer  0   Set bistable relay  Boolean  Off   Unlock tool on complete  Boolean  Off   Unlock tool on disable  Boolean  Off"},{"id":"19135734283","fileName":"19135734283.html","title":"Configuring Protocols Window in a Virtual Station","level":3,"position":233,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab"],"content":" On the home view, go to the Virtual Stationtab and select a Virtual Station on the left pane. Go to the Protocolswindow to find a list of available communication protocols depending on the current license in use. The Open Protocol is available for all licenses.  To gain access to ILM Protocolfunctionality, refer to the   ILM ProtocolUser Guide. To gain access to functionality through Open Protocol, a unique port for each Virtual Station needs to be defined.    Set the Open Protocolswitch to On.  Enter the Server portnumber.  Enter the Communication timeoutvalue in seconds, between 15 and 60.  Enter the PLC Indexvalue between 1 to 20.   PLC Indexis only relevant when running the SoftPLC.  PLC Indexis used to map where in the shared memory the Open Protocol commands are to be written. The default value is 1 but it is possible to enter values 1 to 20.  Choose the action to be applied when the connection to the client is lost.  The Disconnect setting controls the action applied when a connection error occurs:   None: The tightening program continues normally.   Lock tool: The tool is locked after finishing the current tightening normally.   Unassign task: The tightening is aborted after finishing the ongoing task. Except for plain tightening programs or Batch sequences where the task will be removed after finishing.   Always lock tool: The tool is locked after finishing the current tightening, regardless of result.   Use legacy counter The legacy counter setting counts all tightenings in a sequence and outputs that number to secondary systems. To enable this setting, set Use legacy counterto Yes.   MID2500 loosening program This setting allows for the selection of a MID2500 loosening program from the list.  Tap or select Applywhen ready.  As the default value for PLC Indexis always 1 and no checks are made to see if it is in use, there is a possibility that you may have configured the system so that the same index is configured several times when adding Virtual stations. In this case, the Soft PLC will not be able to determine from which Virtual Station the incoming MID is originating from."},{"id":"19399613963","fileName":"1939961396328074333067.html","title":"Configuring Accessories Window in a Virtual Station","level":3,"position":234,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab"],"content":" For connecting and disconnecting QIF accessories to and from a virtual station, see Connecting QIF accessories to a virtual station and Connecting QIF accessories to a virtual station. For troubleshooting with the help of I\/O diagnostics of an accessory, see Digital Signal Diagnostics. "},{"id":"79780747","fileName":"79780747.html","title":"Digital Signal Diagnostics","level":4,"position":235,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab","Configuring Accessories Window in a Virtual Station"],"content":" During deployment and during troubleshooting of a controller, a diagnostic tool is very helpful. It is available for the analysis under the Info tag for a device configuration or a fieldbus mapping in the Virtual stationmenu. The controller can operate in normal mode or in diagnostics mode. In normal mode the digital input and output signals operate normally and are routed between the internal controller logic and to an external accessory or a connector. The diagnostics mode is divided into monitor mode and forced mode. In the monitor mode signals operate normally, but provide live monitoring of the signal behavior. In forced mode the connection between the controller internal logic and the external accessory is opened and the input and output signals can be forced to a desired state. It is possible to diagnose digital signals for one device or one fieldbus at a time."},{"id":"18224517259","fileName":"18224517259.html","title":"Diagnostics Configuration","level":4,"position":236,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab","Configuring Accessories Window in a Virtual Station"],"content":" The diagnostics for a specific accessory or fieldbus is accessible through the Info option in the Virtual Station view for the accessory or fieldbus.     On the home view, go to the Virtual Stationtab and select a Virtual Station on the left pane.  Go to the Accessorieswindow, select Infoand then Diagnostics.  Activate Monitor modeor Forced modewith the switch. The statuses of input signals and output signals are available under the respective tabs. It is only possible to access the diagnostics from one single user or function at a time. If the diagnostics is already in use, an information message is shown on the screen.  "},{"id":"79762059","fileName":"79762059.html","title":"Normal Operations","level":4,"position":237,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab","Configuring Accessories Window in a Virtual Station"],"content":" In normal operations mode external input signals are passed to the internal controller logic and controller output signals are passed to an external target, without any intervention from the diagnostics module.        A  Controller internal state machine and logic functions   B  Digital output signal path   C  Digital input signal path   D  Diagnostics module  "},{"id":"81614859","fileName":"81614859.html","title":"Monitor Digital Signals","level":4,"position":238,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab","Configuring Accessories Window in a Virtual Station"],"content":" In the diagnostics mode all signals passed to and from the controller internal logic can be monitored. A signal tap is connected in the diagnostics module and the signal states are displayed on the web GUI or the controller GUI.        A  Controller internal state machine and logic functions   B  Digital output signal path   C  Digital input signal path   D  Diagnostics module   E  User interface   F  Output signal tap   G  Input signal tap  "},{"id":"81636875","fileName":"81636875.html","title":"Force Digital Signals","level":4,"position":239,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab","Configuring Accessories Window in a Virtual Station"],"content":" In the diagnostics mode all signals passed to and from the controller internal logic can be forced to a desired state. The signal lines are opened in the diagnostics module. From the user interface both input and output signals can be forced to steady states. The user interface is either the web GUI or the controller GUI.  While signals are forced, the controller operates normally. When leaving the diagnostics mode and the forced mode all signals are set to the current operating state of the controller. This may lead to a change-of-state for digital outputs, which can create unwanted actions.        A  Controller internal state machine and logic functions   B  Digital output signal path   C  Digital input signal path   D  Diagnostics module   E  User interface   F  Forced output signal insertion point   G  Forced input signal insertion point  "},{"id":"18224569739","fileName":"18224569739.html","title":"Configuring the Fieldbus Menu in a Virtual Station","level":3,"position":240,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab"],"content":" On the home view, go to the Virtual Stationtab, select a Virtual Station on the left pane and go to the Fieldbuswindow. The Fieldbuswindow in the GUI shows the fieldbus mapping assigned to the controller. To analyze the controller fieldbus configuration and fieldbus configuration select Performon the Diagnosticsfield for the fieldbus mapping. For more information, see Configuring Accessories Window in a Virtual Station.  To configure fieldbus mappings, ToolsTalk 2 is required.  Virtual station - Fieldbus  "},{"id":"19188352011","fileName":"1918835201128074429067.html","title":"Working with the Configurations Tab","level":2,"position":241,"hasContent":true,"hierarchy":["Configuration"],"content":" In this tab, tool accessories and socket selectors can be configured. Also, digital I\/O signals can be mapped to buttons, lamps, switches and connectors. "},{"id":"18692662923","fileName":"1869266292328074458251.html","title":"Tool Configuration","level":3,"position":242,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab"],"content":" On the home view, go to the Configurationstab and select Tool Configurationon the left pane to configure the available accessory functions on the tool. Different functions are available depending on the tool type. Configuring Accessory Functions on the Tool    On the Configurationwindow, select Filter by tool type. Then, select the relevant tool.  On the Configurationwindow, select Editto configure the relevant functions.  A configuration assigned to a virtual station cannot be deleted.  If available, configure the Function Button, the LED Ring, the Direction Switch, the Buzzer and the Vibrator by selecting the ellipsisicon on the corresponding fields. Each field shows a number which corresponds to the number of the specific function (for example, 1 corresponds to Function Button, 2 to LED Ring, 3 to Direction Switch, 4 to Buzzer and 5 to Vibrator).  If available, configure the General Settings, the Start condition and the Accessory Bus on its corresponding windows according to the customer needs. "},{"id":"83837067","fileName":"83837067.html","title":"Configuration of the Function Button","level":4,"position":243,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration"],"content":" Use the function button on the tool to control up to six of the available input signals. The button’s three possible condition states are combined with the two possible states of the direction switch.      Function button states  Direction switch states    Single push  CW   Single push  CCW   Double push  CW   Double push  CCW   Pressed  CW   Pressed  CCW Two configurable parameters controls the push time.      Parameter  Description  Default value    Push detection interval  For single push: the maximum push time (in milliseconds) between the button being pressed and the button being released.  300 ms   Next push interval  For double push: the maximum time (in milliseconds) between the button being released after the first push, and the buttong being pressed again.  300 ms"},{"id":"18673861899","fileName":"18673861899.html","title":"Configuration of the Tool LEDs","level":4,"position":244,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration"],"content":" The tool LEDs have the following features:   The front LEDilluminates the work area and can be used to indicate the result status for supported tools.  The blue LEDis part of the tool LEDs or as part of the EHMI or RHMI for supported tools. An output signal can be connected to the blue LED.  The status LEDsconsist of a red, a yellow, and a green ring or a segmented multicolor ring on specific pistol tools. Output signals can be connected to the status LEDs.  A result indicatorconfigures how the tool LEDs are lit to indicate tightening results status and the duration of this indication in supported tools.  An output signal can be of the type eventor state. A statesignal is active as long as the output signal is active. An eventsignal is active during the configured time range. Blue LED The blue LED can be configured with an event or state output signal. The signal status would be displayed with a steady light.   To configure the blue LED  Select a signal to connect with the blue LED.  Optional: set the duration of an event signal.  The blue LED is replaced by or complemented with a blue indication on the EHMI or RHMI for specific tools types. Result Indicator The result indicator configures how the tool LEDs are lit to indicate tightening results status and the duration of this indication. The configuration affects the front LED and status LED result indication on supported tools. This includes pattern and duration. If pattern is set to Off, the result indication will not be used, even if Front LEDis set to Onin the Tool Configurationview.  Front LED must be set to Onin the Tool Configurationview to use front LED result indication on supported tools.   Front LEDsupports the green and red color. Patterns that use the color yellow will not display yellow on the front LED.  Result indicator signals     Signal  Description    Off  No LEDs are activated after the tightening, regardless of the result.   Green  The green light always turns on when a tightening operation is OK.   Red:high:yellow:low  If the tightening is terminated incorrectly (NOK); a red LED indicates that the final value is too high, or a yellow LED indicates that the value is too low. Red and yellow can be lit simultaneously (e.g. in case of too high torque, and too low angle).   Red:high(prio):yellow:low  If the tightening is terminated incorrectly (NOK); a red LED indicates that the final value is too high, or a yellow LED indicates that the value is too low. Red and yellow cannot be lit simultaneously. Only red is lit in case of simultaneous high and low values.   Red:NOK:yellow:low  A red LED indicates that the tightening is terminated incorrectly (NOK). An additional yellow LED can indicate if the value is too low.   Red:NOK  A red LED indicates that the tightening is terminated incorrectly (NOK). No additional LEDs are shown. Status LEDs The status LEDs consist of LEDs in three colors: red, yellow, and green. Each light can be steady or flashing. This offers a total of six different signals that can be connected to the status LEDs.   To configure the status LEDs  For each color and function, steady or flashing, select an output signal from the shortcut menu.  Optional: set the duration of an event signal.  Status LED signals and result indications can not simultaneously be displayed on the tool. The following conditions apply:   A LED is turned on by a configured signal only when no tightening is ongoing and when the controlling output signal is activated.  A LED is turned off when the next tightening is started, even if the configured duration hasn’t been reached for an eventtype signal or the controlling output signal hasn’t been deactivated for a statetype signal.  A result indication on the status LEDs will be deactivated if an update, activated or deactivated, is made to a configured signal. Duration The duration decides for how long the result indication will be lit after the trigger is released.      Parameter  Description    To next tightening  The blue LED, the status LEDs, and the result indication are on until the next tightening is started.   Time  The blue LED is on for the configured duration after activation. The status LEDs are on for the configured duration after activation or until the start of the next tightening. The result indication is on for the configured duration after the trigger is released or until the start of the next tightening."},{"id":"83874059","fileName":"83874059.html","title":"Configuration of the Direction Switch","level":4,"position":245,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration"],"content":" The direction switch on the tool can be configured to trigger certain input signals when switched quickly (with a duration of 500 ms) from clockwise (CW) to counter clockwise (CCW) and back, or vice versa. Systems in Remote start When the system uses remote start and the user wants to trigger a signal assigned to a direction switch in Tool configuration, one needs to assign the respective signal and use the signal10029 - Select Looseningwith a required duration of 500 ms to trigger it. For this to work, an extra configuration step in ToolsTalk is needed. Under Hardware configurationin ToolsTalk, a configuration must be set for the tool by clicking on the tool icon. "},{"id":"18674763531","fileName":"18674763531.html","title":"Configuration of the Buzzer","level":4,"position":246,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration"],"content":" The buzzer is configured by assigning a sound to a signal selected from a list of available signals. The sound consists of a set of parameters described in the table. A signal with a sound can be prioritized between 1 and 10 where 1 is highest priority and 10 the lowest. By default a signal and sound has the priority 5. Up to 20 sounds can be assigned to signals.      Parameter  Description    Priority  Defines the priority of the buzzer.   Frequency  Exact frequency in Hz.   Time on  Time (in ms) that the buzzer makes a sound.   Time off  Time (in ms) that the buzzer is quiet.   Repetition  Number of times the buzzer repeats the on\/off sequence.   Volume  The buzzer volume, in percentage of max volume."},{"id":"18692742923","fileName":"1869274292328074465163.html","title":"General Settings","level":4,"position":247,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration"],"content":" The general settings for the tool can be set in the General settings section. Trace Configuration, TAG Check and TAG Selection functions are further described in their corresponding sections.      Parameter  Description  Default value    Inactivity timeout  Determines if the tool turns the power off after a set period of inactivity, or not.  On   <Inactivity timeout>  If Inactivity timeout is set to On, it sets the number of minutes before the shutdown.  120 min   Front LED  Sets the behavior of the front LED (above tool trigger). Available only for wireless tools. When it is set to Off, the front LED does not lit when the trigger is pressed.  On   Duration after trigger released  Sets how long the front LED stays lit after the tool trigger is released (in seconds).  For cable tools, the front LED stays lit for 10 seconds after the tools trigger is pressed.  0 sec   Trace  Enables the graphical representation of the tightening.  For multistep programs, trace is always on from Trigger pressed.  For wireless tools, select Trigger pressedor Rundown completefor making the trace.  Off   TAG check  Enables TAG checking on the tool. The tool locks if the TAG supplied with the program is not equal to the one inserted into the STwrench smartHEAD.  TAG check is available only for STwrench or when no tool is selected when validating the tool configuration.  Off   TAG selection  It is used for selecting a Tightening Program\/Batch or Batch Sequence by using Batch Sequence\/Source Tightening\/Source Batch. The Tightening Program\/Batch or Batch Sequence has a TAG number configured that corresponds to the TAG number of the TAG inserted into the STwrench smartHEAD. On the STwrench display, the operator is informed about which Tightening Program\/Batch or Batch Sequence is selected for the TAG inserted into the STwrench smartHEAD.  TAG selection is available only for STwrench or when no tool is selected when validating the tool configuration.  Off   Lock tool on memory full  Enables to lock the tool when the memory of the controller is full.  On "},{"id":"72154251","fileName":"72154251.html","title":"Trace Configuration","level":5,"position":248,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration","General Settings"],"content":" Traces provide users with a graphical representation of the tightening. Traces can begin either from when the trigger is pressed or from after rundown complete.      Parameter  Description  Default value    Trace  Enables the result to be viewed in graphic form.  Off: No trace is made.  Trigger pressed: The trace is drawn from when the tool trigger is pressed.  Rundown complete: The trace is drawn from when Rundown completeis reached.  Off The maximum number of trace points is 2000 (200 for STB tools). If the maximum number of trace points is exceeded, every other result will be erased (effectively halving the sampling rate). Tracing will continue as long as the tightening is active, and every time the maximum number of trace points is reached, half of the trace points will be erased to allow the tracing to continue. Tracing will stop when the final stage of the tightening has finished."},{"id":"18700630667","fileName":"18700630667.html","title":"TAG Check","level":5,"position":249,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration","General Settings"],"content":"  TAG checkfeature enables TAG checking on the tool. When the TAG check is enabled both on the POWER FOCUS 8and the STwrench, the tool locks if the TAG supplied with the program is not equal to the one inserted into the STwrench smartHEAD. The TAG number is specified differently, depending on the work task. In case of Generic Tightening Strategies, the TAG number is specified in the Tightening Program. In case of Multistep Tightening Strategy, the TAG number depends on what has been selected in Sources\/Batch Sequencemenu.   If running Source Tightening( Sources > Tightening > Source Tightening > Selector mode - Confirm), the TAG number is specified in the Socketbox.  If running Batch Sequence( Batch sequence > Sequence library > Sequence > Batch configuration - Edit), the TAG number is the Identifier Number.  If running Source Batch( Sources > Batch sequence > Source Batch), the TAG number is specified in the Batch Sequenceas per above section.  In case of Batch Sequenceand Source Batch, set Free order- in the Batch Sequence- to No.  TAG check is available only for STwrench.      TAG check options  Description    Off  The tool does not lock, regardless of the inserted TAG.   On  The tool is locked as long as the TAG number is not equal to the TAG number specified in the tightening strategy configuration."},{"id":"1820889995","fileName":"1820889995.html","title":"TAG Selection","level":5,"position":250,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration","General Settings"],"content":"  TAG selectionfeature is used for selecting a Tightening Program\/Batch or Batch Sequence that has a TAG number configured that corresponds to the TAG number of the TAG inserted into the STwrench smartHEAD.  TAG selection is available only for STwrench.      TAG selection options  Description    Off  The STwrench does not signal the controller to select Tightening Program\/Batch or Batch Sequence.   On  Select the Tightening Program\/Batch or Batch Sequence according to the TAG number configured in the Batch Sequence\/Source Tightening\/Source Batch."},{"id":"18692738187","fileName":"1869273818728074472075.html","title":"Configuration of the Start Condition","level":4,"position":251,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration"],"content":" The start conditions for a tool, such as start request and start source, are configured here. The functions are described in the corresponding sections. "},{"id":"67845771","fileName":"67845771.html","title":"Start Request","level":5,"position":252,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration","Configuration of the Start Condition"],"content":" Start request enables the requirement of having a persistent connection between the tool and controller for an STB tool. This to make sure that the tool is always up to date with tightening program or batch settings, and with other settings on the controller, when performing tightening. When Start request is set to On the tool gets locked if the tool loose connection with the controller. This means that if the tool loses connection in the middle of a tightening or a batch sequence, the tool will finish the ongoing tightening and then stop. The tool will be locked until it has reestablished the connection.  Parameters available for the start request     Parameter  Description  Default value    Start request  Lock the tool when the tool loose connection with the controller.  On: The tool is locked from performing tightening if it loose connection with the controller..  Off: The tool can continue to perform tightening although it has lost connection with the controller.  On"},{"id":"59712779","fileName":"59712779.html","title":"Start Source","level":5,"position":253,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration","Configuration of the Start Condition"],"content":" Use the tool start source to set how to start the tool. The default value is Trigger only.   Start Sourceis available only for certain tool types.  Options for start source     Start source  Description    Trigger only  Press the tool trigger to start the tightening.   Trigger OR Push  Press the tool trigger or push the tool against the joint to start the tightening.   Trigger AND Push  Press the tool trigger and push the tool against the joint to start the tightening.   Push only  Push the tool against the joint to start the tightening.   Digital input  Have a signal using digital input to trigger the start of the tightening. The Remote startswitch must be set to On.   Trigger AND Digital input  Have a signal using digital input and press the tool trigger to start the tightening. The Remote startswitch must be set to Off.   Safety trigger  Two triggers (as with trigger and push) activated within 500 ms from each other to start the tightening."},{"id":"18692783499","fileName":"1869278349928074478987.html","title":"Configuration of the Accessory Bus","level":4,"position":254,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration"],"content":" Tool accessories are connected to the tool through the accessory bus. The tool accessories are configured separately for each tool configuration on the controller.  Accessory bus configurations     Type  Description     ST selector  A small display and buttons used to select tasks or programs according to the configuration.    TLS tag  Tool Location System tag used to provide output signaling to the operator.    EHMI  A small display and buttons used to select tasks or programs according to the configuration.    Scanner  A device to read a barcode string or a QR code containing information. "},{"id":"18997412363","fileName":"18997412363.html","title":"ST Selector","level":5,"position":255,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration","Configuration of the Accessory Bus"],"content":" The ST selectoris a tool accessory. It is installed on the tool and connected to the tool accessory bus. It has a small display, two input buttons and output LEDs. Display The display shows one information at a time and has four different pages that can be configured to display different preset items on every page.      Parameter  Description  Default Value     Page 1  Select the message to be displayed from the list:.   Final torque  Final angle  Batch count  Remaining batch  Generic IO 1  Generic IO 2  Generic IO 3  Generic IO 4  Generic IO 5  Generic IO 6  Generic IO 7  Generic IO 8  Generic IO 9  Generic IO 10  Selected tightening program  Selected batch sequence id  Target torque  Target\/Final torque  None    Page 2    Page 3    page 4 Switch time      Parameter  Description  Default Value     Switch time  Select the time to display one message before the next message is displayed.  1 s Buttons The two buttons can be configured to act upon the displayed information and used to step through listed items.      Parameter  Description  Default Value     Left button  Select one action from the shortcut menu. The available parameter values are: Off, Take previousand Take next  Take previous    Right button  Select one action from the shortcut menu. The available parameter values are: Off, Take previousand Take next  Take next Status LEDs The status LEDs can be activated or deactivated.      Parameter  Description  Default Value     Show result LEDs  The parameter values are Onand Off  On    Show extra LEDs  The parameter values are Onand Off  On The result LEDs are red, green and yellow, and show the same information as the main tool LEDs. The two extra LEDs can show Batch OKand Batch sequence OK. Both these LEDs are turned off at the next tightening."},{"id":"2689783563","fileName":"2689783563.html","title":"TLS Tag","level":5,"position":256,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration","Configuration of the Accessory Bus"],"content":" The Tool Location System (TLS)tag, is a tool accessory. The TLS tag is installed on the tool and connected to the tool accessory bus. The TLS tag is part of the Ubisense positioning system and is handled independently from the controller. In addition to the positioning, the TLS tag can be used to provide information to the operator. Selected output signals can generate different LED light combinations. Up to 10 different output signals can be mapped to a light priority.  TLS tag configuration parameters     Parameter  Description     Signal  Select a signal to trigger the LED light from a shortcut menu. For a signal of the type Event, select the duration of the signal.    Color  Select a color for the LED.    Priority  10 priority levels are available for the sounds where one (1) is the highest priority level. Default priority level is five (5). For two simultaneous signals, the signal with the highest priority wins. When two signals with the same priority triggers the LED, the first arriving signal wins.  An output signal can be of type Eventor of type State. A state signal is active as long as the state is active. An event signal is active during a configurable time."},{"id":"2694111883","fileName":"2694111883.html","title":"EHMI","level":5,"position":257,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration","Configuration of the Accessory Bus"],"content":" The EHMIis a tool accessory. It is installed on the tool and connected to the tool accessory bus. It has a graphical display, three function buttons, and optionally a scanner. The display is a subset of the controller GUI with the possibility to select tightening programs, batch sequences, and to view results from tightenings. The interaction with the controller is through function buttons. In the EHMI configuration it is possible to decide if the function buttons are On or Off.  EHMI buttons     Parameter  Description     Enable function buttons  On = The buttons have full functionality to configure settings within the visible menus. Off = The function buttons can only be used to acknowledge a necessary dialog on the EHMI."},{"id":"18698576651","fileName":"18698576651.html","title":"Scanner","level":5,"position":258,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration","Configuration of the Accessory Bus"],"content":" The Scanneris a tool accessory. It is installed on the tool and connected to the tool accessory bus. A scanner is used to read a barcode string or a QR code containing information to choose the appropriate batch sequence.      Parameter  Description  Default Value     Pass through mode   On: Enables pass through.  Off: Disables pass through.  Off"},{"id":"22800255627","fileName":"22800255627.html","title":"Configuration of the Multiple Transducers","level":4,"position":259,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration"],"content":"  Only available for QST and IxB tools. Depending on the tool type and the number of transducers, it is possible to set how the torque and angle transducers are used in a tightening. The transducers can be configured to be controlling or monitoring.  Multiple transducers     Parameter  Description    Controlling torque transducer  Set the torque transducer to use for tightening.  Available settings:   Auto: For QST tools, Torqueis used by default. For IxB tools, Torque 2is used by default. If Torque 2is not available for the IxB tool type, Torqueis used.   Torque   Torque 2   Controlling angle transducer  Set the angle transducer to use for tightening.  Available settings:   Auto: For QST tools, Motor angleis used by default.   Motor angle   Angle   Angle 2 Select Detailsto open a sub-menu with more settings.  Monitor and reporting torque     Parameter  Description    Report monitoring torque values  If set, a Final Torque value will be reported from both the controlling and the monitoring transducer, including evaluation of the status for both (OK\/High\/Low).   Redundancy error reporting torque  Redundancy error is reported if the Final Torque measured on the controlling transducer differ from the value measured on the monitoring transducer.   Lock the tool on redundancy error  Lock the tool if a redundancy error is detected.  Torque transducer misc settings     Parameter  Description    Require dual torque  If set, the connected tool must have dual torque transducers (that are not disabled) to be able to run a tightening.   Monitoring torque in trace  If set, the values from the monitoring torque transducer are included in the trace.  Dual torque restrictions     Parameter  Description    Enable double torque restriction  If set, the double torque transducer restriction is active.   Maximum torque difference  The limit for the double torque difference restriction.  Monitor and reporting angle     Parameter  Description    Report monitoring angle values  If set, a Final Angle value will be reported from both the controlling and the monitoring transducer, including evaluation of the status for both (OK\/High\/Low).   Redundancy error reporting angle  Redundancy error is reported if the Final Angle measured on the controlling transducer differ from the value measured on the monitoring transducer.   Lock the tool on redundancy error  Lock the tool if a redundancy error is detected.  Angle transducer misc settings     Parameter  Description    Require dual angle  If set, the connected tool must have dual angle transducers (that are not disabled) to be able to run a tightening.   Monitoring angle in trace  If set, the values from the monitoring angle transducer is included in the trace.  Dual angle restrictions     Parameter  Description    Enable double angle restriction  If set, the double angle transducer restriction is active.   Maximum angle difference  The limit for the double angle difference restriction."},{"id":"20828780555","fileName":"20828780555.html","title":"Configuration of the Open End","level":4,"position":260,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration"],"content":"  Before using an open end tool, make sure that the tool head and tool body have been assembled and configured correctly. If not, the tool can run in the wrong direction and the mechanical stop in the open-end head may be damaged. After performing a tightening with an open end tool, it is possible to let the open end tool getting to the opening position again through the open end configuration. Configure the open end strategies and settings through the HMI (Human Machine Interface).  The open end configuration is applicable only to cable tools, IXB tools, and STB tools. The open end configuration is not applicable to Flexand to synchronized tightening. Open End Configuration  Open End Settings     Settings  Description     Automatic Positioning  After performing a tightening with an open end tool, it is possible to let the open end tool getting to the opening position again automatically. A toggle key turns the Automatic Positioning Onor Off:    On: if enabled, after the tightening, when the open end tool is lifted up, the open end tool gets to the opening position again automatically. The operator must hold down the tool trigger during the full process (tightening + Automatic Positioning). If the operator releases the tool trigger before that the Automatic Positioningis completed, the open end tool will get back to the opening position through the selected Positioning Strategy.   Off: default value. If disabled, after the tightening, when the open end tool is lifted up, the open end tool does not get to the opening position again automatically. When the open end tool is lifted up, the operator must release the tool trigger. To let the open end tool getting to the opening position again, the operator must hold down the tool trigger again during the full Automatic Positioning.   Automatic Positioningis applicable only to Multistep tightening programs.   Automatic Positioningis applicable only to cable toolsand IXB tools.    Positioning Strategy  Select the Positioning Strategyto let the open end tool getting back to the opening position after the tightening.    Forward: default value. The open end tool turns forward - in the same direction of the tightening direction - to the opening position.   Reverse: the open end tool turns reverse - in the opposite direction of the tightening direction - to the opening position.   Reverse Torque Based: the open end tool gets to the opening position through a slow reverse rotation that is done by reversing slowly and monitoring the torque.   Forward Fast Start: the open end tool gets to the opening position as quick as possible.  We recommend to use Reverse Torque Basedand Forward Fast Startstrategies for open end tools with swiveling front part.   Reverse Torque Basedand Forward Fast Startstrategies are applicable only to cable toolsand IXB tools. If the Positioning Strategyof the STB toolsis Reverse Torque Basedor Forward Fast Start, the default Positioning Strategywould run automatically. For Reverse Torque Based, the default Positioning Strategyis Reverse. For Forward Fast Start, the default Positioning Strategyis Forward.    Positioning Speed   Positioning Speeddefines how quickly the tool should get to the opening position.  Positioning Speedis expressed as the percentage (%) of the open end tool maximum speed. The operator can enter a Positioning Speedvalue which ranges from 5% through 100%. By default, the Positioning Speedis set to 38%."},{"id":"19475091083","fileName":"1947509108328074485899.html","title":"Digital Signals","level":3,"position":261,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab"],"content":" In this section, you can find information about input and output digital signals. "},{"id":"83800459","fileName":"83800459.html","title":"Input Signals","level":4,"position":262,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Digital Signals"],"content":" Input signals are system commands that are carried out by using for example buttons or switches on an accessory, either a tool accessory or a QIF accessory, or by connecting the signal to an I\/O input plug.  The input signal Lock tool must not be configured for more than one accessory for each virtual station. "},{"id":"83818763","fileName":"83818763.html","title":"Output Signals","level":4,"position":263,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Digital Signals"],"content":" Output signals are states or events of the system. They can be linked to either a tool accessory or a QIF accessory. "},{"id":"19475039115","fileName":"19475039115.html","title":"Triggering Manual Mode","level":3,"position":264,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab"],"content":" Manual mode can be activated by a switch or an external system. For example (indicated below), a button on an operator panel can be configured to activate manual mode.    On the home view, go to the Configurationstab and select Operator panelon the left pane.  If no configuration for an operator panel exists, select the plusicon in the upper-right corner of the screen.  On the Configurationwindow you want to alter, select Editand then select the ellipsisicon on the position [A,B,C,D,E,F,G,I] to configure.  On the Componentwindow, select the ellipsisicon and, on the list, select One way key switch.  On the Turn Signalwindow, select the ellipsisicon and, on the list, select Manual mode(use the arrow buttons to navigate within the list if necessary).  Close the Position configuration window.  If the user needs to be notified that Manual mode has been entered or left, then events 4070 and 4071 have to be configured, respectively."},{"id":"59361931","fileName":"5936193128074436491.html","title":"Selector Configuration","level":3,"position":265,"hasContent":false,"hierarchy":["Configuration","Working with the Configurations Tab"],"content":""},{"id":"19475044747","fileName":"19475044747.html","title":"Digital Input Information","level":4,"position":266,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Selector Configuration"],"content":" On the home view, go to the Sourcestab, select Tighteningon the left pane and then select Digital inputsto get information about the connected digital inputs."},{"id":"19475063307","fileName":"1947506330728074443403.html","title":"Socket Selector Configuration","level":4,"position":267,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Selector Configuration"],"content":" Socket selector is a socket tray with LEDs that can be used to guide the user through, for example, a Batch sequence. When using more than one tightening program, it is convenient to use a selector. When a socket is lifted, the corresponding tightening program is selected. Several socket selectors can be connected to each virtual station. On the home view, go to the Sourcestab, select Tighteningand then Socket selectorto get Information about the connected socket selectors. "},{"id":"19055713547","fileName":"19055713547.html","title":"Configuring a Socket Selector","level":5,"position":268,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Selector Configuration","Socket Selector Configuration"],"content":"    On the home view, go to the Configurationstab and select Socket selectoron the left pane. Select the plusicon in the upper-right corner of the screen to create a new configuration.  Give the configuration a name.  Select Edit.  Select Addor Removefor the correct number of socket slots, then select all the slots that need to be active (indicated in blue).  Set Controlto Externalif the socket selection is to be controlled by an external system."},{"id":"19475072139","fileName":"19475072139.html","title":"Connecting a Socket Selector to a Virtual Station","level":5,"position":269,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Selector Configuration","Socket Selector Configuration"],"content":"    On home view, go to the Virtual stationtab and select the virtual station to use on the left pane.  Go to the Accessorieswindow and select Choose accessories, then go to the Socket Selectortab.  In the Configurationcolumn, select the configuration you want to use with the socket selector. For more information, seeConfiguring a Socket Selector.  In the Assigned Accessoriescolumn, select the socket selector to use. "},{"id":"19475103627","fileName":"19475103627.html","title":"Setting up a Socket Selector via I\/o Bus","level":4,"position":270,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Selector Configuration"],"content":"    Connect a socket selector to the controller's I\/O bus.  On the home view, go to the Virtual stationtab, select a Virtual Station on the left pane, go to the Accessorieswindow and select Choose Accessories.  Go to the Socket Selectortab to check that the selector shows up in the Assigned accessoriescolumn."},{"id":"18997417355","fileName":"18997417355.html","title":"Setting up a Selector 6 via Ethernet Cable\/Wireless","level":4,"position":271,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Selector Configuration"],"content":"  Selector 6 main overview  Selector front view      A  Holder for socket or bit   B  Indicator LEDs for the position   C  Sticker area   D  Mounting holes in each corner   E  Service port   F  Battery status LED (only available on wireless versions)   G  WLAN status LED (available on some selectors)   H  Battery (only available on wireless versions)   I  Mobility module (only available on wireless versions)  Selector 6 connection overview  Selector bottom view      A  Connector cover   B  External DC power in; Kycon (DC DIN) connector   C  Ethernet in, upstream connection; M12 D-coded female connector   D  Selector back side   E  Digital input and output connector   F  Ethernet out, downstream connection; M12 D-coded female connector   G  Battery  Selector 6 service port overview  Service interface      A  RJ45 Service port   B  RBU slot   C  Function button    On the home view, go to Settingstab and select Networkon the left pane.  Go to the Factory Ethernet Portwindow and check the IP address (only required when setting up via wireless connection).  Open the service port cover on the selector. The cover is secured by a 2 mm allen screw.  Connect an ethernet cable between a PC and the RJ-45 connector in the service interface.  Make sure the selector powered, either by PoE, by external power supply or by battery.  Open a web browser window in the PC.  Type the web address 169.251.1.1 and press the Enterkey. The web server in the selector will respond and show the selector web interface.  Select Settingson the left pane (this is selected by default). The Settingsworkspace shows the configuration menus and is divided into five different settings: Basic settings, Service port, Ethernet in, WLAN, and the POWER FOCUS 8.  In the Ethernet insection, select External modeOn or Off for the desired LED control source.  The next steps in the set-up depend on how the socket selector will be connected to the controller (Ethernet cable directly to the controller (default), Ethernet cable to factory network, or wireless to factory network). See the instructions below for your set-up.    In the Ethernet Insection, select PF8(default) in the Connected to drop-down.  Click the Savebutton in top right of the workspace.  Remove the ethernet cable from the service port.  Close the service port with the lid and secure it with the allen screw.  The socket selector shows up in the Connected accessories list ( Virtual station > Accessories > Choose accessories > Socket selector)    In the Ethernet Insection, select Factory netfrom the Connected to drop-down  Select DHCP On or Off for dynamic or static IP address configuration. If a static IP address is required, in the IP address field, enter the IP address for the socket selector.  In the PF8section, enter the controller IP address (see above) for the controller the selector will be connected to.  Click the Savebutton in top right of the workspace.  Remove the ethernet cable from the service port.  Close the service port with the lid and secure it with the allen screw.  The socket selector shows up in the Connected accessories list ( Virtual station > Accessories > Choose accessories > Socket selector)    In the Ethernet Insection, select Factory netfrom the Connected to drop-down   In the WLAN section, fill out the following parameters:  Enable: set radio button to YES  SSID: fill out the SSID name for the socket selector  Password: fill out the password for the wireless network to be connected to  Encryption type: choose the correct encryption type for the wireless network (WPA-PSK, or WPA2-PSK, EAP-TLS)  In the PF8section, enter the controller IP address (see above) for the controller the selector will be connected to.  Click the Savebutton in top right of the workspace.  Remove the ethernet cable from the service port.  Close the service port with the lid and secure it with the allen screw.  The socket selector shows up in the Connected accessories list ( Virtual station > Accessories > Choose accessories > Socket selector)     "},{"id":"19475112587","fileName":"1947511258728074493323.html","title":"General Virtual Station","level":3,"position":272,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab"],"content":" In General Virtual Station, different specific result reporting and tightening settings can be saved. Different filters can be created to present specific results. In the tightening settings, characteristics like the tool unlocking behavior can be set. These configurations can then be assigned to virtual stations. Adding and editing a configuration    On the home view, go to the Configurationstab, select General Virtual Stationon the left pane and select the plusicon in the upper-right corner of the screen.  Give the new configuration a name and select Edit.  On the Result filter for reportingwindow, set the switch to Onfor those parameters you want to include in the results. By default, all parameters are set to On.  Turning on a result filter prevents the respective result from being sent, but the result is still shown on the controller.  The following parameters can be set in the Result filter for reportingsection:  Loosening  Batch increment  Batch decrement  Reset batch  Bypass Tightening Program  Abort sequence  Abort not started sequence  Reset batch sequence  In the Tightening Settingswindow, set a value for any of the parameters listed. By default, all parameters are set to Off.  The following parameters can be set in the Tightening Settingssection:  Unlock tool on loosening: ensures that the tool is locked after an NOK tightening.  Disable loosening: ensures that the operator does not loosen a bolt when it is not allowed.  Disable tightening: ensures that the operator does not tighten a bolt when it is not allowed.  Maximum consecutive loosenings: ensures that the operator cannot do more than the configured number of loosenings before the tool locks. Unlock tool on loosening settings      Setting  Description    Off  A disabled tool stays disabled regardless of the loosening status.   On OK  A disabled tool is unlocked after an OK loosening has been done.   Always  A disabled tool is unlocked as soon as a loosening has been done, regardless of the loosening status. Disable loosening settings To ensure that a bolt cannot be loosened by mistake, use the disable loosening function. There are four disable loosening settings:      Settings  Description    Off  Loosening is always enabled. It is always possible to loosen a bolt.   On OK tightening  Loosening is disabled after an OK tightening. It is not possible to loosen a correct tightened bolt.   On NOK tightening  Loosening is disabled after an NOK tightening. It is not possible to loosen a not correct tightened bolt.   Always  Loosening is always disabled. It is not possible to loosen a bolt.   After every operation  Loosening is disabled after any operation, including tightening OK\/NOK, loosening OK\/NOK and if the tool is doing a free run (no result) These settings are valid during the execution of a task. Loosening enables and disables depending on the setting and the status of the last tightening. For a new task the start state for disable loosening is set as follows:      Settings  Start state for new task    Off  Loosening enabled. It is possible to loosen a bolt.   On OK Tightening  Loosening disabled. It is not possible to loosen a bolt.   On NOK Tightening  Loosening disabled. It is not possible to loosen a bolt.   Always  Loosening disabled. It is not possible to loosen a bolt.   After every operation  Loosening disabled. It is not possible to loosen a bolt The start state applies whenever a new task is assigned to a Virtual station or when a task starts again. The start state can differ depending on the type of task, described as follows.  Tightening program and Sync mode Enable and disable of loosening follows the disable loosening setting and is set to the status of the last tightening.  Batch Sequence During a batch sequence the enable or disable of loosening follows the disable loosening setting and is set to the status of the last tightening. This also applies when a batch goes to the next one within a batch sequence. If a batch sequence starts again, the loosening is enabled or disabled according to the start state for a new task.  Source Batch Enable and disable of loosening follow the same procedure as described in Batch sequence. If an ongoing source batch starts again or if a new one is selected, the loosening is enabled or disabled according to the start state for new task.  Source Tightening (No batch control) During a batch, enable and disable is set according to the status of the last tightening. If another program is selected, enable and disable is set according to the start state for new task. If any change of program, tool or socket is done, enable and disable is set according to the start state for new task.  Multispindle tightening Enable and disable of loosening always follows the status of the last tightening. This is also applicable for a new sync mode. Disable tightening settings To make sure that an operator does not tighten a bolt by mistake there is a function called disable tightening. There are four disable tightening settings:      Settings  Description    Off  Tightening is always enabled. It is always possible to tighten a bolt.   On NOK tightening  Tightening is disabled after an NOK tightening. It is not possible to tighten a not correct tightened bolt until tool is unlocked.   On OK tightening  Tightening is disabled after an OK tightening. It is not possible to tighten a correct tightened bolt until tool is unlocked.   After every tightening  Tightening is always disabled after every tightening and must be unlocked by signal or loosening to enable tool for next tightening.   After every operation  Tightening is disabled after any operation, including tightening OK\/NOK, loosening OK\/NOK and if the tool is doing a free run (no result). It must be unlocked by signal or loosening to enable the tool for the next tightening. These settings are valid during the execution of a task. Tightening enables and disables depending on the setting and the status of the last tightening. For a new task the start state for disable tightening is set as follows:      Settings  Start state for new task    Off  Tightening enabled   On OK Tightening  Tightening enabled   On NOK Tightening  Tightening enabled   After every tightening  Tightening disabled   After every operation  Tightening disabled The start state applies whenever a new task is assigned to a Virtual station or when the task starts again. The start state can differ depending on the type of task, as described in the Disable Loosening settings section.   When using tightening settings with STB, SRB, and TBP in radio shadow, there are some limitations:  The disable looseningsetting, After every operation, only works when the tool is connected to the controller. In radio shadow, the behavior defaults to On OK tightening.  The disable tighteningsetting, After every operation, only works when the tool is connected to the controller. In radio shadow, the behavior defaults to After every tightening.  The maximum consecutive looseningssetting only works when the tool is connected to the controller. The counter will not work, and the tool will not lock while in radio shadow. Maximum consecutive loosenings settings To ensure the operator does not loosen the bolt more than the allowed number of times, configure the tool to lock after reaching the maximum consecutive loosenings. You can set this value between 0 and 250.   If set to 0, the operator can loosen the bolt an infinite number of times, and the tool will never lock.  If set to a number greater than 0, the tool will count each loosening. Once it reaches the configured number, it will lock and prevent further loosenings. The consecutive loosening counter resets with each tightening attempt, whether successful (OK) or unsuccessful (NOK). When the tool locks, it cannot perform loosenings but can still perform tightenings. If an attempt is made to loosen, event 4021 – Too many consecutive looseningswill show. The Max consecutive loosening reached – 245signal will also activate and can be sent to external systems via Fieldbus or shown on a stack light. To unlock and reset the counter, an external system must trigger the signal Reset too many loosenings – 10151via Fieldbus or an accessory. The Master unlock – 10005signal can also unlock the tool for loosening but will not reset the counter. A tightening performed while loosening is locked will unlock the tool for further loosenings and reset the counter. Allowing a disabled tool to unlock after loosening   In the Tightening Settingsfor the assigned Virtual station and connected tool, set the Unlock tool on looseningto On OKor Always.  To enable the settings above, the following conditions need to be met:   The Disable looseningparameter cannot be set to Offor Always.  The Disable looseningparameter cannot be set to the same value as the Disable tightening.  The tightening program used must have loosening enabled. When the tool is locked for either tightening or loosening due to a disable state, it can be unlocked with one of the following input signals:   Master Unlock - 10005  Unlock Tool on Disable - 10059  Unlock tightening on disable - 10149  Unlock loosening on disable - 10150  It is not possible to unlock a disabled tool with the input signals if Lock tool on looseningis set to Always. Assigning a configuration to a virtual station Each virtual station can have its own configuration and multiple virtual stations can share the same configuration. A configuration needs to be assigned to a virtual station to become active.    On the home view, select the Virtual Stationtab. Select the Virtual Station you want to assign a configuration to on the left pane.  In the right menu scroll down to General, the first configuration is selected by default. Select the ellipsisicon next to the configuration name.  In the pop-up window, select a configuration from the list. The pop-up window closes upon selection.  To finalize the assignment, select APPLYor UNDOto the right. "},{"id":"18698602891","fileName":"1869860289128074507659.html","title":"Configuring Live Result Presentation Settings","level":4,"position":273,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","General Virtual Station"],"content":" The Live Result Presentation Settingswindow allows a user to show the final torque without the PrT compensation value included, and PrT compensation value on the Live results. Configure the Live Result Presentation Settings Window    On the home view, go to the Configurationstab and select General Virtual Stationon the left pane.  On the Configurationwindow you want to work with, select Edit. The Edit Configurationscreen appears.  On the Live Result Presentation Settingswindow, set the relevant switches to ONor OFFdepending on the wanted results. If the Show PrT Compensation Valueswitch is set to ON, the Live Resultswindow displays the PrT compensationvalue. If the Show Final Torque with PrT Compensationswitch is set to ON, the Live Resultswindow displays the final torque with the PrT compensationincluded.  Setting the switches in the Live Results Presentations Settingswindow to either ONor OFFhas no impact unless the multistep program has a tightening step including a Prevailing Torquestep monitor with the Compensationswitch set to ON. Live Result Presentation Settings Here are the different configuration options in the Live Results Presentations Settingswindow.      Show PrT Compensation Value: ON Show Final Torque with PrT Compensation: ON  Show PrT Compensation Value: ON Show Final Torque with PrT Compensation: OFF  Show PrT Compensation Value: OFF Show Final Torque with PrT Compensation: ON  Show PrT Compensation Value: OFF Show Final Torque with PrT Compensation: OFF                   "},{"id":"18287356043","fileName":"18287356043.html","title":"Show Final Torque with PrT Compensation: ON \/ Show PrT Compensation Value: ON","level":5,"position":274,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","General Virtual Station","Configuring Live Result Presentation Settings"],"content":" Show Final Torque with PrT Compensation: ON The Live Result window shows the Final Torque with the PrT compensation value included. If the EHMI and ST Selector are on and configured, they show the Final Torque with the PrT compensation value included. Show PrT Compensation Value on Live Result: ON The Live Result window shows the PrT compensation value with the related compensation icon (). If there are several compensation values, the compensation value applied to the latest available step appears.   Configuring the Show Final Torque with PrT Compensationand Show PrT Compensation Valueswitches does not impact:   The final torque values sent to ToolsNet and ToolsTalk: the final torque values with PrT compensation are always sent to ToolsNet and ToolsTalk.  The final torque value displayed with the historical results.  The traces based on live and historical results.  The values in Open Protocol messages.  The signals.  The protocol adapters.  "},{"id":"18287365003","fileName":"18287365003.html","title":"Show Final Torque with PrT Compensation: OFF \/ Show PrT Compensation Value: ON","level":5,"position":275,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","General Virtual Station","Configuring Live Result Presentation Settings"],"content":" Show Final Torque with PrT Compensation: OFF The Live Result window shows the Final Torque without the PrT compensation value included. Since the Final Torque does not include the PrT compensation value, it shows in italic. Show PrT Compensation Value: ON The Live Result window shows the PrT compensation value with the related compensation icon (). If there are several compensation values, the compensation value applied to the latest available step appears.   Configuring the Show Final Torque with PrT Compensationand Show PrT Compensation Valueswitches does not impact:   The final torque values sent to ToolsNet and ToolsTalk: the final torque values with PrT compensation are always sent to ToolsNet and ToolsTalk.  The final torque value displayed with the historical results.  The traces based on live and historical results.  The values in Open Protocol messages.  The signals.  The protocol adapters.  "},{"id":"18287957899","fileName":"18287957899.html","title":"Show Final Torque with PrT Compensation: OFF \/ Show PrT Compensation Value: OFF","level":5,"position":276,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","General Virtual Station","Configuring Live Result Presentation Settings"],"content":" Show Final Torque with PrT Compensation: OFF The Live Result window shows the Final Torque without the PrT compensation value included. Since the Final Torque does not include the PrT compensation value, it shows in italic. Show PrT Compensation Value: OFF The Live Result window does not display the PrT compensation value and the related compensation icon ().   Configuring the Show Final Torque with PrT Compensationand Show PrT Compensation Valueswitches does not impact:   The final torque values sent to ToolsNet and ToolsTalk: the final torque values with PrT compensation are always sent to ToolsNet and ToolsTalk.  The final torque value displayed with the historical results.  The traces based on live and historical results.  The values in Open Protocol messages.  The signals.  The protocol adapters.  "},{"id":"18287961995","fileName":"18287961995.html","title":"Show Final Torque with PrT Compensation: ON \/ Show PrT Compensation Value: OFF","level":5,"position":277,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","General Virtual Station","Configuring Live Result Presentation Settings"],"content":" Show Final Torque with PrT Compensation: ON The Live Result window shows the Final Torque with the PrT compensation value included. If the EHMI and ST Selector are on and configured, they show the Final Torque with the PrT compensation value included. Show PrT Compensation Value: OFF The Live Result window does not display the PrT compensation value and the related compensation icon ().   Configuring the Show Final Torque with PrT Compensationand Show PrT Compensation Valueswitches does not impact:   The final torque values sent to ToolsNet and ToolsTalk: the final torque values with PrT compensation are always sent to ToolsNet and ToolsTalk.  The final torque value displayed with the historical results.  The traces based on live and historical results.  The values in Open Protocol messages.  The signals.  The protocol adapters.  "},{"id":"25791794827","fileName":"25791794827.html","title":"Configuring the storage of Final Torque and Trace","level":4,"position":278,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","General Virtual Station"],"content":" The switch Store with PrT compensationis by default set to ONwhich means that the final torque and trace are stored with the PrT compensation value.  Show Final Torque with PrT compensationin the Live Result Presentation Settingsdetermines what is shown in Live result. Changing the Store with PrT compensation setting    On the home view, select Configurations.  Scroll down and select General Virtual Stationon the left pane.  In the Configuration window, select a Configurationand then Edit. The Edit configurationwindow appears.  Scroll down to Storage of Final torque and Trace, set the switch Store with PrT compensationinto the wanted position."},{"id":"91120907","fileName":"9112090728074450827.html","title":"Configuring QIF Accessories","level":3,"position":279,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab"],"content":" A total of 15 QIF accessories can be connected to one controller. It is possible to add several scanners to each controller. All QIF accessories connected to the controller can be connected to the same virtual station. One of each type of accessory and multiple socket selectors. The functions of the QIF accessory can be connected to various input and output signals. "},{"id":"18224645771","fileName":"18224645771.html","title":"Connecting QIF Accessories to a Virtual Station","level":4,"position":280,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Configuring QIF Accessories"],"content":" To connect a QIF accessory to a virtual station:    Configure the accessory in the Configurationstab.  Connect the accessory to the controller I\/O bus.  On the home view, go to the Virtual stationtab, select a virtual station on the left pane.  Go to the Accessorieswindow and select Choose accessories.  On the relevant accessory tab, select both an accessory and a configuration to connect them. Connected accessories show up in the Assigned accessoriescolumn."},{"id":"19475140619","fileName":"19475140619.html","title":"Disconnecting QIF Accessories From a Virtual Station","level":4,"position":281,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Configuring QIF Accessories"],"content":"    On the home view, go to the Virtual stationtab and select the relevant virtual station on the left pane.  Go to the Accessorieswindow and select Choose accessories.  Go to the Assigned Accessoriescolumn and choose the accessory to disconnect. Select the removeicon on the right to disconnect. "},{"id":"19475159307","fileName":"1947515930728074514571.html","title":"Configuration of the Scanner","level":3,"position":282,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab"],"content":" In this menu, scanner configurations can be added. Scanners can be configured to either have scanned strings handled by the controller, or passed through to a an external system. When the scanned string is passed through, the controller does not select a task based on the string, but instead passes the string to an external device via an output signal. Adding a scanner and enabling pass through    On the home view, go to the Configurationstab, select Scanneron the left pane and select the plusicon in the upper-right corner of the screen.  Give the scanner configuration a name.  To enable pass through, select Edit, and set Pass Through Modeto On. "},{"id":"59271435","fileName":"5927143528074521483.html","title":"Scanner Configuration","level":4,"position":283,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Configuration of the Scanner"],"content":" A scanner is used to read a barcode string or a QR code containing information to choose the appropriate batch sequence.  The scanner is configured in the Sourcestab. The scanner reads the characters you specify and puts them together to form a string of text. This text string is matched to the pre-defined strings you have specified in the controller, and if they match, the batch sequence linked to your pre-defined string is selected. Barcode strings of a length of up to 1024 characters can be read and they can contain characters in the positions 32-126 in the ASCII table. If the barcode contains a string longer than 1024 characters, the remaining part of the string, from position 1025 and forward, is discarded. "},{"id":"59280907","fileName":"59280907.html","title":"Configuring the Scanner","level":5,"position":284,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Configuration of the Scanner","Scanner Configuration"],"content":" The scanner itself must be set up using a US keyboard, and the scanner will emit a carriage return character to terminate the barcode string."},{"id":"59283979","fileName":"59283979.html","title":"Valid Scanners","level":5,"position":285,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Configuration of the Scanner","Scanner Configuration"],"content":" For a list of scanners verified for use with the POWER FOCUS 8controller, contact your local Atlas Copco sales representative."},{"id":"91178763","fileName":"9117876328074070923.html","title":"Working with the Controller Tab","level":2,"position":286,"hasContent":true,"hierarchy":["Configuration"],"content":" The system administration tasks for the POWER FOCUS 8controller are handled in the Controllermenu. The menu is accessed through the controller GUI, the web GUI, or the Tools Talk 2 GUI. "},{"id":"18702702987","fileName":"18702702987.html","title":"Intelligent Application Module","level":3,"position":287,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab"],"content":" The Intelligent Application module (IAM)is a non volatile storage that is located in the controller. The storage module contains all the controller programs, configurations and results. Certain modules may also include additional loaded feature items. The IAM can store up to 100,000 results with traces. For a complete list of available IAMs and their capabilities, please consult an Atlas Copco sales representative.  IAM Information  "},{"id":"18998164491","fileName":"1899816449128074174859.html","title":"Software","level":3,"position":288,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab"],"content":" The version number of two versions of software available in the POWER FOCUS 8controller are under the Software tab. Installing a second version of the controller software is useful when performing upgrades on multiple controllers. When production is ready for switching to the upgraded software, activation of the new software version is done locally on the controller GUI, from a remote computer with the web GUI, or with Tools Talk. A new software distribution can be installed either by connecting a USB flash drive containing the software to the controller’s USB port, or by using the web GUI.  The software update option is visible only when accessing the controller GUI from a PC. When a mass storage device with a valid software version is inserted in the USB port a prompt to update the software will appear. The software update file must not be unzipped and must be stored in a folder named PFImagesin the root directory on the USB flash drive.  An unexpected failure during software upgrade might lead to loss of data. Before upgrading software versions, it is recommended to take a backup of the controller configuration by exporting “All controller information”.  Do not remove the USB device or disconnect the IAM until the upgrade is completed. "},{"id":"18997873163","fileName":"18997873163.html","title":"Updating Controller Software through USB","level":4,"position":289,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Software"],"content":"    Connect the USB flash drive to the controller: the installation wizard starts automatically.  If several software versions are available on the USB flash drive, a list with the different software upgrade files is displayed.  Select the software upgrade file to install and follow the instructions to finish the installation.  The USB flash drive needs to have a partition available and be formatted to work for Linux. Possible formats are for example FAT or NTFS.  Do not remove the USB device or disconnect the IAM until the upgrade is completed. For synchronized tightening, manually restart all Sync Member controllers after upgrading to a new software version or downgrading from a new software version. If the controller application fails to start repeatedly the controller will boot up in rescue mode. In rescue mode a new firmware can be installed. The rescue image is distributed with the software update and can be updated if a newer rescue image exists.  Do not power off the system during rescue image update. The system will reboot when starting the update."},{"id":"18998173707","fileName":"18998173707.html","title":"Updating Controller Software through Web GUI","level":4,"position":290,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Software"],"content":"    Access to the Web GUI by connecting a PC with a straight-through Ethernet cable (RJ45) to the Service Ethernet port. Access the controller with the IP address from a web browser.  On the home view of the Web GUI, go to the Controllertab, select Softwareon the left pane and then go to the Software updatewindow and select Browse.  Browse and choose the .zip file with the software and follow the instructions to complete the installation. For synchronized tightening, manually restart all Sync Member controllers after upgrading to a new software version or downgrading from a new software version. If the controller application fails to start repeatedly the controller will boot up in rescue mode. In rescue mode a new firmware can be installed. The rescue image is distributed with the software update and can be updated if a newer rescue image exists.  Do not power off the system during rescue image update. The system will reboot when starting the update."},{"id":"19475357835","fileName":"19475357835.html","title":"Activating the Software on the Controller","level":4,"position":291,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Software"],"content":" The controller can store two installed software versions. On the home view, go to the Controllertab, select Softwareon the left pane and go to the Software activationwindow to choose which software version to use. Software activation can be performed either locally from the controller GUI or remotely from the web GUI.  The activation process requires a restart of the controller.    On the home view, go to the Controllertab and select Softwareon the left pane.  On the Software activationwindow, swipe the switch to Storedor to Currentand follow the instructions."},{"id":"3245009547","fileName":"324500954728074077835.html","title":"Hardware","level":3,"position":292,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab"],"content":" The Hardware tab contains Controller information, such as model designation and serial number, Health, Touch screen calibration, and information about the various electronics boards in the controller. "},{"id":"19475369867","fileName":"19475369867.html","title":"Health","level":4,"position":293,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Hardware"],"content":" On the home view, go to the Controllertab, select Hardwareon the left pane and go to the Healthwindow to find information about the Battery statusand the temperature of the various components. Battery status The POWER FOCUS 8battery is located inside the controller's front panel and serves as backup power for some system elements, such as the internal clock. The status of the battery is updated once a day and when the controller restarts. When the battery is close to being completely depleted, a warning (3011) will be displayed. Replace the battery as soon as possible when the warning appears. The status of the battery appears in the Battery statusfield on the Healthwindow. Controller components temperature The temperature of the various components in the controller is monitored continuously by the POWER FOCUS 8. Supported temperature units are degrees Celsius (°C) and degrees Fahrenheit (°F), with Celsius as the default unit. It is possible to switch between the two units without requiring a restart of the controller. When a critical component temperature exceeds the maximum temperature, the drive stage is disabled and an alert (3010) is shown. The drive stage is once again enabled when the component temperature drops below the maximum temperature limit. For each component, the latest controller temperature measured together with the timestamp when the measurement was taken appears in the Controller temperaturefield on the Healthwindow. It is possible to monitor the temperature continuously in a graph view for a component."},{"id":"18725990411","fileName":"1872599041128074084747.html","title":"Export\/Import","level":3,"position":294,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab"],"content":" On the Controllertab, the Export\/Importpane allows to perform the following operations: Export, Import, and Automated backup. Use the Exportwindow to export controller configurations, settings, results, events and tool logs, which can be shared with Atlas Copco Service personnel to troubleshoot problems with the tools. Use the Importwindow to import controller configurations and settings.  It is only possible to have one export or import process active at the same time. Any attempt to start a new export or import process while there is one ongoing is rejected. Use the Automated backupwindow to generate a backup file.  It is possible to export or to import data through one of the following devices:  USB flash drive (formatted and with a partition to work for Linux: possible formats are, for example, FAT or NTFS)  Web GUI  ToolsTalk 2 During export or import processes, a progress bar informs of that an export or an import process is ongoing. The time to perform an export or an import depends on the number of results, events, and log files that are imported or exported. Export\/Import Between Controllers Controllers may have different IAM types that could have different capabilities. A controller can export all the configurations that are applicable to the current type of IAM module.  A controller cannot import a file exported from a different type of IAM module. This is applicable also when using ToolsTalk 2. "},{"id":"18703315723","fileName":"18703315723.html","title":"Exporting All Controller Information","level":4,"position":295,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Export\/Import"],"content":"    On the home view, go to the Controllertab and then select Export\/Importon the left pane.  Go to the Exportwindow, select the ellipsisicon and then All controller informationon the pop-up window.  On the Exportwindow, select Export. At the end of the exporting process, an exporting pop-up window confirms that the export is completed. A PF\/IXBExport_<IAM name>_<datetime>.tar.gzfile is automatically downloaded. When exporting All controller information, the controller configuration, the tightening programs, the settings, the results, and the events are exported for further processing. Part of the export is done both from the cable tool and from the connected wireless tools. All data included in the export is stored in a file \"PFExport_<IAM name>_<datetime (lowest value displayed for time is seconds)>.tar.gz\", which includes the following files and directories:    \"PFExport_<datetime>_Results.csv\": All available results. The results are exported in a CSV formatted text file. The latest performed result is the first in the CSV file. It is possible to export the following result information for tightenings and loosenings:      Result Information  Tightening Programs  Multistep Programs  Synchronized tightening    Identity number  -  -  X   Type of tightening  X  X  X   Virtual Station name  X  X  X   VIN (Identifier String)  X  X  X   Date and Time  X  X  X   Unique tool identifier  X  X  -   Batch Sequence Name  X  X  -   Batch Sequence Counter  X  X  -   Batch Count  X  X  -   Bolt name  -  -  X   Total status  -  -  X   Total status info  -  -  X   Status  X  X  X   Status info  X  X  X   Mode Name  -  -  X   Tightening program\/Multistep Name  X  X  X   Stopping error  -  X  X   Errors  -  X  X   Failing Step  -  X  X   Channel  -  -  X   Target Torque (Nm)  X  X  -   Final Torque (Nm)  X  X  X   Target Angle (deg)  X  X  -   Start Final Angle (Nm)  X  X  X   Final Angle (deg)  X  X  X   Rundown Angle (deg)  X  -  -   Residual torque correlation factor  X  X  -   Elapsed time (s)  -  X  X   Angle low limit (deg)  X  X  X   Angle high limit (deg)  X  X  X   Torque low limit (Nm)  X  X  X   Torque high limit (Nm)  X  X  X   Number of pulses  X  -  -   Current at shutoff (A)  X  X  X   TrueAngle compensation (deg)  X  X  -   Time to rundown complete (ms)  X  -  -   Time to final torque (ms)  X  -  -   Target Text  X  X  -   Step Data  -  X  X   Selftap Torque  X  X  X   Prevailing Torque  X  X  X   Rundown Angle Trigger  X  X  X The field delimiter and the number format depends on the language settings:      Language  Date\/time  Field delimiter  Number format    English (en_US)   MM\/dd\/yyyy hh:mm:ss   ,   123.456   Czech (cs)   dd.MM.yyyy hh:mm:ss   ;   123,456   German (de_DE)   dd.MM.yyyy hh:mm:ss   ;   123,456   Spanish (es_ES)   dd\/MM\/yyyy hh:mm:ss   ;   123,456   French (fr_FR)   dd\/MM\/yyyy hh:mm:ss   ;   123,456   Korean (ko_KR)   yyyy-MM-dd hh:mm:ss   ,   123.456   Italian (it_IT)   dd\/MM\/yyyy hh:mm:ss   ;   123,456   Japanese (ja_JP)   yyyy\/MM\/dd hh:mm:ss   ,   123.456   Portugese (pt_BR)   Dd\/MM\/yyyy hh:mm:ss   ;   123,456   Russian (ru_RU)   dd.MM.yyyy hh:mm:ss   ;   123,456   Swedish (sv_SE)   yyyy-MM-dd hh:mm:ss   ;   123,456   Chinese (zh_CN)   yyyy\/MM\/dd hh:mm:ss   ,   123.456  For synchronized tightening, all available results are in the file named “PFExport_<datetime>_Results.csv.zip”.    \"PFExport_<datetime>_Events.csv\": All available events. The following event information is exported in a CSV formatted text file:   Severity  Date  Time  Code  Description  Virtual Station that triggered the event (only exported for PF8-Handheld)  Carrier (only exported for synchronized tightening)  Channel (only exported for synchronized tightening)   \"\/settings\"- Settings and configurations (used by Import)   For fieldbus exported settings and configurations:  General Fieldbus configuration (including IP address)  Fieldbus configuration  Fieldbus mapping (Virtual station mapping to ProcessDataFrame)    \"jsonConfigurations.zip\": Multistep Tightening and Loosening programs are exported as .json files (to be used with MID2500).   \"atlas_sys_d.zip\": Logfiles from Drive application.   \"atlas_sys_i.zip\": Logfiles from IT application. Only readable by Atlas Copco personnel.   \"atlas_protocol_log.zip\": Logfiles from external protocol adapters.   “ExportInfo.txt”: Text document containing information about the IAM and the Controller.   \"atlas_plc.zip\": PLC configuration.   “licenseInformation.zip”: License Information and System Capabilities."},{"id":"19475389067","fileName":"19475389067.html","title":"Exporting Settings and Configurations","level":4,"position":296,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Export\/Import"],"content":"    On the home view, go to the Controllertab and select Export\/Importon the left pane.  Go to the Exportwindow, select the ellipsisicon and then Settings and configurationson the pop-up window.  On the Exportwindow, select Export. At the end of the exporting process, an exporting pop-up window confirms that the export is completed. A PFExport_<IAM name>_<datetime>.tar.gzfile is automatically downloaded. This export option only exports controller configurations and settings. The exported data is stored in a compressed file identified with the IAM name and exported date and time. The data in the file include all configurations and settings of the controller, so that the export file can be imported and setup in another controller with the same or a newer release version. The exported data includes information about the IAM, the controller and the pre-formatted Multistep Tightening and Loosening programs to be used with the MID2500 solution."},{"id":"19475527947","fileName":"19475527947.html","title":"Exporting Logs from Connected Tools","level":4,"position":297,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Export\/Import"],"content":"    On the home view, go to the Controllertab and select Export\/Importon the left pane.  Go to the Exportwindow, select the ellipsisicon and then Logs from connected toolson the pop-up window.  On the Exportwindow, select Export. At the end of the exporting process, an exporting pop-up window confirms that the export is completed. A PFExport_<IAM name>_<datetime>.tar.gzfile is automatically downloaded. The export of tool logs enables a service technician to share the tool log data with Atlas Copco Service personnel to troubleshoot problems with the tools. This tool log export option is available for STB, SRB, TBP\/TBP-S, IxB and QST-M connected tools. To export the tool logs, the tool has to be connected to the controller. It is not necessary that the tool is assigned to a virtual station.  For STB, SRB, TBP\/TBP-S tools  All data included in the tool log export is stored in a file \"PFExport_<IAM name>_<datetime>.tar.gz\", which includes the following files and directories:   \"atlas_tool_i.zip\": All available results. For each connected tool an individual file is created. The file format for tool log files is \"tool-<tool type>-<tool serial number>.log\".  For IxB Connect tools   All data included in the tool log export is stored in a file \"pfconnecttool\/<Serial number>\/PFSyncExport_<Date>T<Time>.tar.gz\",which has to be decrypted as well.  Log export function is not availible for IxB Connect tools over Bluetooth. In Bluetooth case logs has to be fetched from each tool separately through network or service interface.    \"ExportInfo.txt\": Text document containing information about the IAM, the controller and the connected tools."},{"id":"19475538827","fileName":"19475538827.html","title":"Exporting Results","level":4,"position":298,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Export\/Import"],"content":"    On the home view, go to the Controllertab and select Export\/Importon the left pane.  Go to the Exportwindow, select the ellipsisicon and then Resultson the pop-up window.  On the Exportwindow, select Export. At the end of the exporting process, an exporting pop-up window confirms that the export is completed. In case of a multi-spindle systems (fixtured), the exported file automatically downloaded is in a .zip format, otherwise it is in a .csv format. This export option only exports tightening results from the controller."},{"id":"22007855499","fileName":"22007855499.html","title":"Exporting \"System Logs and Information\"","level":4,"position":299,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Export\/Import"],"content":" The export of system logs and information enables a service technician to share the logs of the system and its information with Atlas Copco Service technician. Troubleshooting problems with the system - such as controllers - is easier through the export of system logs and information.  The export of system logs and information does not include logs from the connected tool(s). If you need the export logs from the connected tool(s), select the necessary export method. All data included in the export of system logs and information are stored in a file PF\/IXBExport_<IAM name>_<datetime>.tar.gz, which includes the following files and directories:    atlas_sys_d.zip- Log files from Drive application   atlas_sys_i.zip- Log files from IT application   atlas_protocol_log.zip– Log files from external protocol adapters   ExportInfo.txt- Text document containing information about the IAM and controller   licenseInformation.zip– License information and system capabilities   atlas_systeminformation.zip– Information to Atlas Copco R&D for current system health and setup   atlas_workflow_log.zip– Log files for the workflow from external protocol adapters How to Export \"System Logs and Information\"    On the Home view, select the ControllerTab. Then, on the left side, select the Export\/ImportTab.  In the Exportwindow, open the drop-down menu and select System logs and information.  In the Exportwindow, select Export. At the end of the exporting process, an exporting pop-up window confirms that the export is done. A PF\/IXBExport_<IAM name>_<datetime>.tar.gzfile is automatically downloaded. "},{"id":"19475549707","fileName":"19475549707.html","title":"Importing Controller Configurations and Settings","level":4,"position":300,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Export\/Import"],"content":"    On the home view, go to he Controllertab and select Export\/Importon the left pane.  Go to the Importwindow and select Import. An Informationpop-up window confirms that all settings for tightening programs, batches, accessories, and controllers will be replaced with the settings of the imported file. However, settings for network, PIN, results, and events will not be imported. Select Continue.  On the Importpop-up window, select Choose File. Then, select the file to be imported on the controller. At the end of the importing process, the controller will restart automatically.  If the importing process is interrupted before it has started or the file disappears, an informative message appears and the controller must be restarted to assure it is in a valid state. An interrupted importing process can be completed if the file is existent and non-corrupted. When importing controller configuration and settings, existing configurations and settings are replaced by the imported controller configuration and settings.  The following configurations are not imported or deselected:  Controller Network settings are not imported.  Results and Events are not imported.  License Assignment is not imported.  Assigned task in Virtual Station\/s is deselected.   \"jsonConfigurations.zip\"(Multistep Tightening and Loosening programs) is not imported.   \"licenseInformation.zip\"(License Information and System Capabilities) is not imported."},{"id":"16695644811","fileName":"16695644811.html","title":"Automated Backup","level":4,"position":301,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Export\/Import"],"content":" The Automated Backupwindow enables or disables sFTP export. By default, Enable sFTP exportswitch is set to OFF. When turning ON Enable sFTP exportswitch, an export file is created 10 minutes after the last configuration change. If Enable sFTP exportswitch is set to ON on system startup, an export file is automatically created within 2-3 minutes. The export file is created within 2-3 minutes to reflect changes that might have been done before the system was shutdown.  The old Backup file is deleted before the new Backup file is available. The data in the exported file include all configurations and settings of the controller. The sFTP users can retrieve the exported file stored in the following directory of the system: \/Export\/<export file name>.  A system supporting sFTP is needed. To retrieve the file sFTP users do not need to use any password. The username for sFTP users is as follows:      Username   autoexport"},{"id":"18726051211","fileName":"1872605121128074091659.html","title":"Synchronized tightening","level":3,"position":302,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab"],"content":"   Controller features, such as the Low Reaction Tightening Strategies and controller-wide functions among others, require licenses distributed through the Functionality Management System (FMS). Whereas configuration of features is possible without specific licenses, the assignment and use of those features will require the correct license to be installed on the controller. Please refer to Licenses (FMS) for more detailed information on licenses.   Configuration of Synchronized tightening is done through ToolsTalk 2. With Synchronized tightening it is possible to connect and to run several PF8 controllers together. The first controller in the configuration is called the Sync Reference and controls all the tightening and data reporting. Up to 5 additional PF8 controllers, called Sync Members, can be connected to the Sync Reference through a PF8 daisy-chain cable. Refer to Setting up hardware for Synchronized tightening. The Sync Members control the tools. Sync Reference The Sync Reference is the brain in the system. It controls:   the tightening settings  the data reporting  the configuration of the complete system  the connection to Tools Talk and ToolsNet Accessories and field buses are connected directly to the Sync Reference. Sync Member The Sync Member works as a drive without any extra functionality. The IT part does not run and it is not possible to connect any external accessories or protocols to the Sync Member. Each Sync Member has an assigned channel number. The channel number is used to:   identify a connected tool and drive within the Hardware Layout Configuration in ToolsTalk 2.  select tools and drives that should be included in the tightening in Sync Mode.  produce result reports.  identify faulty parts in error events. Tightenings It is only possible to run Synchronized tightening for Multistep tightening programs. To synchronize tightenings between each tool, synchronization points are used. At these points, the tools wait for each other before continuing with the next step in the tightening program. A tightening program can contain up to 25 steps (synchronization points not included).  The assignment of tightening programs can only be done through ToolsTalk 2 and is not possible to do through the controller. Licensing Synchronized tightening is an FMS feature. Only the Sync Reference requires a license. It is possible to change any PF8 Controller into a Sync Member without any additional licenses. The Sync Reference license is an add-on FMS controller feature.  If the sync reference license is removed, no tightening can be done in Synchronized tightening mode. If the connection to the license server is lost, the license is still valid for 48 hours. The controller will search for a valid Sync Reference license every hour. "},{"id":"19090120843","fileName":"19090120843.html","title":"User Interface Synchronized tightening","level":4,"position":303,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening"],"content":" The user interface for Synchronized Tightening is a simplified version of the regular POWER FOCUS 8interface. For detailed descriptions on the various interface elements, refer to the dedicated chapters and sections in this user guide. Note that the user interface is only accessible on the Sync Reference. Not all functions are available in the Synchronized tightening interface. The following functions exist and can be edited in the interface:    Tool: all information available.   Virtual Station: all functions accessible, except creation of new Virtual Stations, assignment of Tasks (tightening program), and assignment of tool among others.   Configurations: all functions available.   Controller: all functions available. Note that there is an extra section here called Channels where information on the tools connected to the Sync Reference and Sync Members is given.   Reports: Events (view all events).   Settings: the following functions are not available:   Tightening  Wireless  Events   Diagnostics: menu specific for Synchronized tightening.   License assignment: all functions available."},{"id":"18734392971","fileName":"18734392971.html","title":"Configuring Synchronized tightening","level":4,"position":304,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening"],"content":"  The configuration of the Sync Reference and all Sync Members needs to be completed before the hardware set-up. Configuring the Sync Reference    On the home view, go to the Controllertab and select Synchronized tighteningon the left pane.  In the Synchronized Tighteningwindow, select the ellipsisicon next to No Sync.  The Synchronized Tightening Modewindow appears.  Select Sync Reference.  The Synchronized Tightening Modewindow closes.  Select Apply.  The controller will reboot and boot into the Sync reference configuration, which is a simplified version of the regular PF8 GUI. Enabling Synchronized tightening Synchronized tightening need to be enabled on the Sync Reference controller and there are two ways of doing it:   Set the I\/O signal Enable Operation (10055) to High, or  In the Sync reference controller, go to the Configurationstab, select General Virtual Stationon the left pane and then select Editfor the applicable configuration. Then, in the Fixtured Stationswindow, set Auto Enableto Always.  If Synchronized tightening has not been enabled, a runtime an error message appears saying \"Unable to start, enable signal is low.\" Configuring the Sync Member    On the home view, go to the Controllertab and select Synchronized Tighteningon the left pane.  On the Synchronized Tightening Modewindow, select the ellipsisicon next to No Sync.  The Synchronized Tightening Modewindow appears.  Select Sync Member.  The Synchronized tighteningwindow closes.  In the Channelwindow, select the channel number for the Sync Member. Then select the appropriate channel for the Sync Member.  The channel numbers of the Sync Members in the same set-up must be unique.  Select Apply.  The controller will reboot and boot into the Sync Member configuration, which will only display the Sync Member's channel number. Switching back to regular PF8 mode (exiting synchronized tightening)    On the home view, go to the Controllertab and select Synchronized tighteningon the left pane.  On the Synchronized Tighteningwindow, select the ellipsisicon next to Sync Reference.  The Synchronized Tightening Modewindow appears.  Select No Sync.  The Synchronized Tightening Modewindow closes.  Select Apply.  The controller will reboot and boot into the regular configuration."},{"id":"18734397707","fileName":"18734397707.html","title":"Setting up Synchronized tightening (hardware)","level":4,"position":305,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening"],"content":"  Note that software configuration needs to be done before hardware set-up is completed to avoid possible set-up conflicts. Synchronized tightening allows several POWER FOCUS 8to be connected to run synchronized tightenings.    Make sure that each controller has been configured correctly (see Synchronized Tightening Configuration for more information).  Use a PF8 daisy-chain cable to connect the Sync Reference Com Port B to the first Sync Member's Com Port A.  Use another PF8 daisy-chain cable to connect the first Sync Member's Com Port B to the second Sync Member's Com Port A. Do the same for all subsequent controllers.  A synchronized tightening system can be configured with a maximum of 5 Sync Members.  The controllers need to be interconnected with an Estop cable. See EM Stop Connection Scenarios. "},{"id":"9855031051","fileName":"9855031051.html","title":"Synchronized Tightenings","level":4,"position":306,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening"],"content":" It is only possible to use Multistep tightening programsfor Synchronized tightening. Synchronization points are used to synchronize the tools in a set-up. At these points, the tools will wait for each other before continuing with the next step in the multistep tightening program.  It is only possible to assign tightening programs to different tools in ToolsTalk2.  Example of a Multistep tightening program for Synchronized tightening      A  Synchronization point A tightening program can consist of a maximum of 25 steps (Synchronization points not included). Available steps   Tighten to Angle  Tighten to Torque  Tighten to Torque plus Angle  Tighten to DynaTork  Wait  Socket Release  Tighten to Torque or Angle  Loosen to Angle  Loosen to Torque  Rundown  Tighten to Yield M2  Tighten to Yield  Tighten to Torque and Angle  Thread cutting to torque  Engage Available Monitors   Angle  Peak Torque  Shut Off Torque  Torque rate and deviation  Torque in angle window  Post view torque high  Post view torque los  Angle from Yield  Prevailing Torque  Shut Off Current  Post Thread cut angle  Post Thread cut peak torque  Stick Slip Detection  Time Available Step Restrictions   Maximum Torque  Maximum Angle  Cross Thread  Rescinding Torque  Torque Gradient  Torque in Angle View  Torque vs Current Deviation   Reject Management When switch to Off:       Action if failure   Description   End all    All channels will end the tightening and report status NOK.  The tightening that did not have an error itself will report additional info Terminated by other bolt.   Continue OK    The failing channels will end the tightening with status NOK.  The remaining channels will continue with the rest of the tightening program. When switch to On:      Parameter  Description     Max number of failing steps  Specifies the maximum number of different steps that can fail during the whole tightening. It does not matter if the same step fail more than once, it still only counts as one failing step. If not set an unlimited number of steps can fail.    Action if exceeded  Specifies the action if Maximum number of failing stepsis exceeded.    Action if NOK during repair  Specifies the action if a new error ( NOK) is detected while a repair is ongoing.  "},{"id":"19477406987","fileName":"19477406987.html","title":"Synchronized tightening Live Results","level":4,"position":307,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening"],"content":" On the home view, select the Go Resultbutton to access to the Synchronized tightening live results. The results for all the tools in the Synchronized tightening will be shown on the controller GUI of the Sync Reference and in its corresponding Web GUI. The GUI on the Sync Members will not show any results. Select a Synchronized tightening result pane to open a window where you can step through the different result views by tapping the arrows at the sides of the result window. Result View: Sync Mode Overview This screen shows an overview of the total status for the entire tightening (OK or NOK) and the total number of OK and NOK bolts. The rhombus at top shows the status of the whole mode. The hexagons at the bottom show the status of each channel. The blue bar under the hexagons indicates the selected channel. Select the different hexagons to see the results of the different channels. The result view shown applies only to the selected channel.  OK result  NOK result In the NOK result, the channel originating the NOK result has a different layout to make it easier to identify the channel that has originated the problem. This is the channel that has made all other channels stop. Select the ellipsisicon at the top to see the list of all errors.  Select the ellipsisicon at the bottom to see a grid view of all the channels. This icon is only visible if there are more than six channels, if there are less than six channels, this icon is hidden.   If the result is NOK, an explanatory message appears. Result view: Channel overview This screen shows an overview of the result of one channel.  NOK result To see the results of the other channels, select the ellipsisbutton at the top and choose another channel on the pop-up window that appears. The result views will now show the results applicable to the newly selected channel.   If the result is NOK, an explanatory message appears. Result View: Channel Detailed Result This screen shows a detailed view of one channel result. If the set limits for torque or angle are exceeded or not reached, an arrow pointing up or down appears next to the corresponding failed result. Select the side arrows next to the Channelbox to move among the different channels. The results shown on this view apply only to the selected channel.  NOK result  If the result is NOK, an explanatory message appears. Result View: Step Results List This screen shows a list with all the step results used in a channel tightening.   The step result originating the NOK result shows a red bar. Select the different step results listed to get further information.  Result View: Batch Sequence Overview This result view shows information about the status of the different batches in a batch sequence ( Batch\/Overview) and information about the tightenings in every batch ( Count\/Overview). The results shown apply to the selected batch sequence.  The squares symbolize each batch in a batch sequence. The currently selected batch has a blue background. A batch that contains a NOK tightening has red borders and a diagonal red line. The circles symbolize each tightening in every batch. NOK tightenings have a red border and a red diagonal line.           "},{"id":"9808357643","fileName":"980835764328074098571.html","title":"Synchronized Tightening Signals","level":4,"position":308,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening"],"content":" The synchronized tightening system supports the same I\/O signals listed in the tables below. These can be mapped in fieldbus configuration and accessory configuration. Some are also available through Open Protocol. "},{"id":"18265939851","fileName":"1826593985128074105995.html","title":"Input Signals","level":5,"position":309,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals"],"content":"      Signal  Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]  Devices     title   item   item   item   none   none   subnodes "},{"id":"15043972875","fileName":"15043972875.html","title":"Abort Sequence - 10012","level":6,"position":310,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" When a Batch sequence abort request is received, the Batch sequence functionality aborts the batch sequence only after getting the ongoing tightening result.  Name in SoftPLC: ABORT_BATCH_SEQUENCE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":311,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Abort Sequence - 10012"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":312,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Abort Sequence - 10012"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":313,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Abort Sequence - 10012"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":314,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Abort Sequence - 10012"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":315,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Abort Sequence - 10012"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":316,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Abort Sequence - 10012"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":317,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Abort Sequence - 10012"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":318,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Abort Sequence - 10012"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":319,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Abort Sequence - 10012"],"content":"  I\/O Expander: TRUE"},{"id":"19436912523","fileName":"19436912523.html","title":"Abort Sequence and Clear Results - 10127","level":6,"position":320,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" When signal \"Abort sequence and clear results\" is set, the ongoing sequence is aborted and signals related to \"Clear results\" are cleared.  Name in SoftPLC:ABORT_SEQ_AND_CLEAR_RES      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":321,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Abort Sequence and Clear Results - 10127"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":322,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Abort Sequence and Clear Results - 10127"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":323,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Abort Sequence and Clear Results - 10127"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":324,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Abort Sequence and Clear Results - 10127"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":325,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Abort Sequence and Clear Results - 10127"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":326,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Abort Sequence and Clear Results - 10127"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":327,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Abort Sequence and Clear Results - 10127"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":328,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Abort Sequence and Clear Results - 10127"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":329,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Abort Sequence and Clear Results - 10127"],"content":"  I\/O Expander: TRUE"},{"id":"15110504331","fileName":"15110504331.html","title":"Batch Decrement - 10002","level":6,"position":330,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Incrementally decreases the batch counter by one.  Name in SoftPLC: BATCH_DECREMENT      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":331,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Batch Decrement - 10002"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":332,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Batch Decrement - 10002"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":333,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Batch Decrement - 10002"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":334,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Batch Decrement - 10002"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":335,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Batch Decrement - 10002"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":336,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Batch Decrement - 10002"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":337,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Batch Decrement - 10002"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":338,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Batch Decrement - 10002"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":339,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Batch Decrement - 10002"],"content":"  I\/O Expander: TRUE"},{"id":"15110848523","fileName":"15110848523.html","title":"Batch Increment - 10001","level":6,"position":340,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Incrementally increases the batch counter by one.  Name in SoftPLC: BATCH_INCREMENT      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":341,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Batch Increment - 10001"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":342,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Batch Increment - 10001"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":343,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Batch Increment - 10001"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":344,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Batch Increment - 10001"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":345,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Batch Increment - 10001"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":346,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Batch Increment - 10001"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":347,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Batch Increment - 10001"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":348,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Batch Increment - 10001"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":349,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Batch Increment - 10001"],"content":"  I\/O Expander: TRUE"},{"id":"15632943499","fileName":"15632943499.html","title":"Bypass Identifier - 10123","level":6,"position":350,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" In source batch string used to bypass an identifier string in string receiving sequence.      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":351,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Bypass Identifier - 10123"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":352,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Bypass Identifier - 10123"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":353,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Bypass Identifier - 10123"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":354,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Bypass Identifier - 10123"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":355,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Bypass Identifier - 10123"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":356,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Bypass Identifier - 10123"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":357,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Bypass Identifier - 10123"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":358,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Bypass Identifier - 10123"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":359,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Bypass Identifier - 10123"],"content":"  I\/O Expander: TRUE"},{"id":"15137503371","fileName":"15137503371.html","title":"Bypass Tightening Program - 10008","level":6,"position":360,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Skips the next tightening program in the running batch sequence.  Name in SoftPLC: BYPASS_PSET      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":361,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Bypass Tightening Program - 10008"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":362,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Bypass Tightening Program - 10008"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":363,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Bypass Tightening Program - 10008"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":364,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Bypass Tightening Program - 10008"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":365,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Bypass Tightening Program - 10008"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":366,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Bypass Tightening Program - 10008"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":367,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Bypass Tightening Program - 10008"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":368,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Bypass Tightening Program - 10008"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":369,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Bypass Tightening Program - 10008"],"content":"  I\/O Expander: TRUE"},{"id":"15415511691","fileName":"15415511691.html","title":"Channel Command - 10054","level":6,"position":370,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Channel Command is an input signal that inhibits individual tools and prevents that those tools are included in the next tightening. It is also possible to replace the tightening program or bolt number configured in the sync mode configuration. Up to 64 channels are supported.  Name in SoftPLC: CHANNEL_COMMAND      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  uint32 array  1  64 The signal Channel Command -10054contains sub-signals (for more information, see \"Input Signals: Sub-signals\").   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":371,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Channel Command - 10054"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":372,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Channel Command - 10054"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":373,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Channel Command - 10054"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":374,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Channel Command - 10054"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":375,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Channel Command - 10054"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":376,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Channel Command - 10054"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":377,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Channel Command - 10054"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":378,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Channel Command - 10054"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":379,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Channel Command - 10054"],"content":"  I\/O Expander: TRUE"},{"id":"19292536075","fileName":"19292536075.html","title":"Continue Step - 10128","level":6,"position":380,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Continue Stepis an input signal that stops the Waittightening step. When the tightening has reached a Waittightening step with the condition Signalconfigured as Wait Type, a rising edge of the signal Continue Stepcauses the system (one or more spindles) to release. For more information, see the sub-signalChannel Command - 10054: Continue Step.  Name in SoftPLC: CONTINUE_STEP      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":381,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Continue Step - 10128"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":382,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Continue Step - 10128"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":383,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Continue Step - 10128"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":384,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Continue Step - 10128"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":385,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Continue Step - 10128"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":386,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Continue Step - 10128"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":387,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Continue Step - 10128"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":388,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Continue Step - 10128"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":389,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Continue Step - 10128"],"content":"  I\/O Expander: TRUE"},{"id":"18199003147","fileName":"18199003147.html","title":"Data Drop - 10125","level":6,"position":390,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" When set DATADROP to true at the end of a tightening DATADROP signal will drop result from the tightening. The result will not be stored persistently or sent to any device or clients like ToolsNet or protocol adapters.  Name in SoftPLC: DATADROP      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":391,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Data Drop - 10125"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":392,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Data Drop - 10125"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":393,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Data Drop - 10125"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":394,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Data Drop - 10125"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":395,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Data Drop - 10125"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":396,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Data Drop - 10125"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":397,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Data Drop - 10125"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":398,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Data Drop - 10125"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":399,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Data Drop - 10125"],"content":"  I\/O Expander: TRUE"},{"id":"18181823371","fileName":"18181823371.html","title":"Data Hold - 10124","level":6,"position":400,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" When signal DATAHOLD is set to true at the end of a tightening, transmission of the result data will be stopped.  Name in SoftPLC: DATAHOLD      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":401,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Data Hold - 10124"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":402,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Data Hold - 10124"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":403,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Data Hold - 10124"],"content":" Internal I\/O: TRUE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":404,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Data Hold - 10124"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":405,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Data Hold - 10124"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":406,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Data Hold - 10124"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":407,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Data Hold - 10124"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":408,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Data Hold - 10124"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":409,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Data Hold - 10124"],"content":"  I\/O Expander: TRUE"},{"id":"15138424331","fileName":"15138424331.html","title":"Disable Fieldbus - 10049","level":6,"position":410,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Disables the fieldbus.  Name in SoftPLC: DISABLE_FIELDBUS      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":411,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable Fieldbus - 10049"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":412,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable Fieldbus - 10049"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":413,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable Fieldbus - 10049"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":414,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable Fieldbus - 10049"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":415,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable Fieldbus - 10049"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":416,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable Fieldbus - 10049"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":417,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable Fieldbus - 10049"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":418,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable Fieldbus - 10049"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":419,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable Fieldbus - 10049"],"content":"  I\/O Expander: TRUE"},{"id":"15415522699","fileName":"15415522699.html","title":"Disable Test Bolt - 10057","level":6,"position":420,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC: DISABLE_TESTBOLT      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":421,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable Test Bolt - 10057"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":422,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable Test Bolt - 10057"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":423,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable Test Bolt - 10057"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":424,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable Test Bolt - 10057"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":425,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable Test Bolt - 10057"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":426,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable Test Bolt - 10057"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":427,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable Test Bolt - 10057"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":428,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable Test Bolt - 10057"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":429,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable Test Bolt - 10057"],"content":"  I\/O Expander: TRUE"},{"id":"15138445451","fileName":"15138445451.html","title":"Disable tool - 30000","level":6,"position":430,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" If the signal is set to True, a tool is immediately stopped and locked.      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":431,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable tool - 30000"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":432,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable tool - 30000"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":433,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable tool - 30000"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":434,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable tool - 30000"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":435,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable tool - 30000"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":436,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable tool - 30000"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":437,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable tool - 30000"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":438,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable tool - 30000"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":439,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Disable tool - 30000"],"content":" I\/O Expander: FALSE"},{"id":"15138487691","fileName":"15138487691.html","title":"Dynamic Batch Size - 10074","level":6,"position":440,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC: DYNAMIC_BATCH_SIZE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  16   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":441,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Dynamic Batch Size - 10074"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":442,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Dynamic Batch Size - 10074"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":443,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Dynamic Batch Size - 10074"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":444,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Dynamic Batch Size - 10074"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":445,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Dynamic Batch Size - 10074"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":446,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Dynamic Batch Size - 10074"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":447,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Dynamic Batch Size - 10074"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":448,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Dynamic Batch Size - 10074"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":449,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Dynamic Batch Size - 10074"],"content":" I\/O Expander: FALSE"},{"id":"15415742347","fileName":"15415742347.html","title":"Enable Operation - 10055","level":6,"position":450,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC: ENABLE_OPERATION      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":451,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Enable Operation - 10055"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":452,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Enable Operation - 10055"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":453,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Enable Operation - 10055"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":454,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Enable Operation - 10055"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":455,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Enable Operation - 10055"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":456,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Enable Operation - 10055"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":457,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Enable Operation - 10055"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":458,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Enable Operation - 10055"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":459,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Enable Operation - 10055"],"content":"  I\/O Expander: TRUE"},{"id":"15415810315","fileName":"15415810315.html","title":"Fieldbus AsyncData To PF - 10077","level":6,"position":460,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC:      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  uint8 array  16  2048   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":461,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus AsyncData To PF - 10077"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":462,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus AsyncData To PF - 10077"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":463,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus AsyncData To PF - 10077"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":464,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus AsyncData To PF - 10077"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":465,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus AsyncData To PF - 10077"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":466,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus AsyncData To PF - 10077"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":467,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus AsyncData To PF - 10077"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":468,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus AsyncData To PF - 10077"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":469,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus AsyncData To PF - 10077"],"content":" I\/O Expander: FALSE"},{"id":"15293574027","fileName":"15293574027.html","title":"Fieldbus Lock Loosening - 20021","level":6,"position":470,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" A Virtual Station is locked when starting a loosening if the signal is set from a connected and supported accessory. An ongoing loosening is aborted immediately when Fieldbus Lock Loosening is set to True, due to the Stop Drive setting.      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":471,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus Lock Loosening - 20021"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":472,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus Lock Loosening - 20021"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":473,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus Lock Loosening - 20021"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":474,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus Lock Loosening - 20021"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":475,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus Lock Loosening - 20021"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":476,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus Lock Loosening - 20021"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":477,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus Lock Loosening - 20021"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":478,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus Lock Loosening - 20021"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":479,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus Lock Loosening - 20021"],"content":" I\/O Expander: FALSE"},{"id":"15293577739","fileName":"15293577739.html","title":"Fieldbus Lock Tightening - 20020","level":6,"position":480,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" A Virtual Station is locked when starting a tightening if the signal is set from a connected and supported accessory. An ongoing tightening is aborted immediately when Fieldbus Lock Tightening is set to True, due to the Stop Drive setting.      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":481,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus Lock Tightening - 20020"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":482,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus Lock Tightening - 20020"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":483,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus Lock Tightening - 20020"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":484,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus Lock Tightening - 20020"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":485,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus Lock Tightening - 20020"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":486,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus Lock Tightening - 20020"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":487,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus Lock Tightening - 20020"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":488,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus Lock Tightening - 20020"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":489,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Fieldbus Lock Tightening - 20020"],"content":" I\/O Expander: FALSE"},{"id":"15293581451","fileName":"15293581451.html","title":"Flush Read Result Queue - 30005","level":6,"position":490,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":491,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Flush Read Result Queue - 30005"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":492,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Flush Read Result Queue - 30005"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":493,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Flush Read Result Queue - 30005"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":494,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Flush Read Result Queue - 30005"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":495,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Flush Read Result Queue - 30005"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":496,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Flush Read Result Queue - 30005"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":497,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Flush Read Result Queue - 30005"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":498,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Flush Read Result Queue - 30005"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":499,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Flush Read Result Queue - 30005"],"content":" I\/O Expander: FALSE"},{"id":"15293585163","fileName":"15293585163.html","title":"ID for Dynamic Batch Size - 10073","level":6,"position":500,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC: DYNAMIC_BATCH_SIZE_TPID      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Integer  1  16   TreatZeroAsOne  State  Integer  1  16   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":501,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","ID for Dynamic Batch Size - 10073"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":502,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","ID for Dynamic Batch Size - 10073"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":503,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","ID for Dynamic Batch Size - 10073"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":504,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","ID for Dynamic Batch Size - 10073"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":505,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","ID for Dynamic Batch Size - 10073"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":506,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","ID for Dynamic Batch Size - 10073"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":507,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","ID for Dynamic Batch Size - 10073"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":508,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","ID for Dynamic Batch Size - 10073"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":509,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","ID for Dynamic Batch Size - 10073"],"content":" I\/O Expander: FALSE"},{"id":"15294283787","fileName":"15294283787.html","title":"Lock Loosening - 20003","level":6,"position":510,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":511,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Loosening - 20003"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":512,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Loosening - 20003"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":513,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Loosening - 20003"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":514,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Loosening - 20003"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":515,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Loosening - 20003"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":516,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Loosening - 20003"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":517,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Loosening - 20003"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":518,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Loosening - 20003"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":519,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Loosening - 20003"],"content":"  I\/O Expander: TRUE"},{"id":"15294287499","fileName":"15294287499.html","title":"Lock Tightening - 20002","level":6,"position":520,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Tool locked for tightening by digital input.      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":521,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tightening - 20002"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":522,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tightening - 20002"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":523,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tightening - 20002"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":524,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tightening - 20002"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":525,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tightening - 20002"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":526,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tightening - 20002"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":527,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tightening - 20002"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":528,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tightening - 20002"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":529,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tightening - 20002"],"content":"  I\/O Expander: TRUE"},{"id":"15294995211","fileName":"15294995211.html","title":"Lock Tool Active High - 20004","level":6,"position":530,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":531,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tool Active High - 20004"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":532,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tool Active High - 20004"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":533,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tool Active High - 20004"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":534,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tool Active High - 20004"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":535,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tool Active High - 20004"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":536,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tool Active High - 20004"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":537,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tool Active High - 20004"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":538,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tool Active High - 20004"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":539,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tool Active High - 20004"],"content":"  I\/O Expander: TRUE"},{"id":"15294998923","fileName":"15294998923.html","title":"Lock Tool Active Low - 20061","level":6,"position":540,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Locks the tool when this signal is low.      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":541,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tool Active Low - 20061"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":542,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tool Active Low - 20061"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":543,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tool Active Low - 20061"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":544,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tool Active Low - 20061"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":545,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tool Active Low - 20061"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":546,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tool Active Low - 20061"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":547,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tool Active Low - 20061"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":548,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tool Active Low - 20061"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":549,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Lock Tool Active Low - 20061"],"content":"  I\/O Expander: TRUE"},{"id":"15295006603","fileName":"15295006603.html","title":"Master Unlock - 10005","level":6,"position":550,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Master Unlock is an input signal which unlocks the following functions and signals.  FUNCTIONS:   Disable loosening at OK tightening  Disable loosening at NOK tightening  Disable tightening  Max consecutive NOK  Tool Lock on Sequence complete  SIGNALS:   20001 - Pending Event Acknowledge Lock  20002 - Lock Tightening  20003 - Lock Loosening  20004 - Lock Tool Active High  20013 - WorkTask Lock Tightening  20014 - WorkTask Lock Loosening  20015 - Batch Done lLock  20018 - Open Protocol Lock  20020 - Fieldbus Lock Tightening  20021 - Fieldbus Lock Loosening  20022 - Disable Loosening At OK Tight  20023 - Too Many NOK Tightenings Lock  20033 - Line Control Lock  20034 - Locked By Alternative Identifier  Name in SoftPLC: MASTER_UNLOCK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":551,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Master Unlock - 10005"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":552,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Master Unlock - 10005"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":553,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Master Unlock - 10005"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":554,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Master Unlock - 10005"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":555,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Master Unlock - 10005"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":556,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Master Unlock - 10005"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":557,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Master Unlock - 10005"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":558,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Master Unlock - 10005"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":559,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Master Unlock - 10005"],"content":"  I\/O Expander: TRUE"},{"id":"15295151115","fileName":"15295151115.html","title":"Pulse Stop - 10030","level":6,"position":560,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" If this signal is generated any ongoing tightening or loosening will be stopped. Used in combination with 10024 or 10072.  Name in SoftPLC: TIGHTENING_STOP_PULSE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":561,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Pulse Stop - 10030"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":562,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Pulse Stop - 10030"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":563,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Pulse Stop - 10030"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":564,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Pulse Stop - 10030"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":565,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Pulse Stop - 10030"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":566,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Pulse Stop - 10030"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":567,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Pulse Stop - 10030"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":568,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Pulse Stop - 10030"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":569,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Pulse Stop - 10030"],"content":"  I\/O Expander: TRUE"},{"id":"15307366411","fileName":"15307366411.html","title":"Read Result Handshake Ack - 30004","level":6,"position":570,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Enable the Read Result Handshake feature in the Fieldbus device for making the controller available for the signal Rear Result Handshake Ack.      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":571,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Read Result Handshake Ack - 30004"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":572,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Read Result Handshake Ack - 30004"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":573,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Read Result Handshake Ack - 30004"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":574,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Read Result Handshake Ack - 30004"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":575,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Read Result Handshake Ack - 30004"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":576,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Read Result Handshake Ack - 30004"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":577,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Read Result Handshake Ack - 30004"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":578,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Read Result Handshake Ack - 30004"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":579,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Read Result Handshake Ack - 30004"],"content":" I\/O Expander: FALSE"},{"id":"15307370379","fileName":"15307370379.html","title":"Reset All Identifiers - 10115","level":6,"position":580,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" In Source batch string used to reset all received string identifiers from string receiving sequence at once. In other worktasks clears VIN number.  Name in SoftPLC: RESET_ALL_IDENTIFIERS      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":581,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset All Identifiers - 10115"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":582,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset All Identifiers - 10115"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":583,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset All Identifiers - 10115"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":584,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset All Identifiers - 10115"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":585,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset All Identifiers - 10115"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":586,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset All Identifiers - 10115"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":587,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset All Identifiers - 10115"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":588,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset All Identifiers - 10115"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":589,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset All Identifiers - 10115"],"content":"  I\/O Expander: TRUE"},{"id":"15307374091","fileName":"15307374091.html","title":"Reset Batch - 10003","level":6,"position":590,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Resets the batch counter to 0. No batch OK (nxOK). If batch OK is activated, it will be deactivated.  Name in SoftPLC: RESET_BATCH      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":591,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Batch - 10003"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":592,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Batch - 10003"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":593,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Batch - 10003"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":594,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Batch - 10003"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":595,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Batch - 10003"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":596,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Batch - 10003"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":597,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Batch - 10003"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":598,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Batch - 10003"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":599,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Batch - 10003"],"content":"  I\/O Expander: TRUE"},{"id":"15308184203","fileName":"15308184203.html","title":"Reset Batch Sequence - 10053","level":6,"position":600,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Resets the Batch Sequence. Unlocks a tool that is locked by Tool Lock on Complete.  Name in SoftPLC: RESET_BATCH_SEQUENCE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":601,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Batch Sequence - 10053"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":602,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Batch Sequence - 10053"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":603,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Batch Sequence - 10053"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":604,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Batch Sequence - 10053"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":605,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Batch Sequence - 10053"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":606,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Batch Sequence - 10053"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":607,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Batch Sequence - 10053"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":608,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Batch Sequence - 10053"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":609,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Batch Sequence - 10053"],"content":"  I\/O Expander: TRUE"},{"id":"15308187915","fileName":"15308187915.html","title":"Reset Bistable Relay - 10022","level":6,"position":610,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Reset the bistable relay output.  Name in SoftPLC: RESET_BISTABLE_RELAY      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":611,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Bistable Relay - 10022"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":612,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Bistable Relay - 10022"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":613,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Bistable Relay - 10022"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":614,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Bistable Relay - 10022"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":615,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Bistable Relay - 10022"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":616,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Bistable Relay - 10022"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":617,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Bistable Relay - 10022"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":618,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Bistable Relay - 10022"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":619,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Bistable Relay - 10022"],"content":"  I\/O Expander: TRUE"},{"id":"15415916939","fileName":"15415916939.html","title":"Reset Cycle Status - 10056","level":6,"position":620,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC: RESET_CYCLE_STATUS      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":621,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Cycle Status - 10056"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":622,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Cycle Status - 10056"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":623,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Cycle Status - 10056"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":624,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Cycle Status - 10056"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":625,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Cycle Status - 10056"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":626,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Cycle Status - 10056"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":627,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Cycle Status - 10056"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":628,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Cycle Status - 10056"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":629,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Cycle Status - 10056"],"content":"  I\/O Expander: TRUE"},{"id":"15308191627","fileName":"15308191627.html","title":"Reset Latest Identifier - 10114","level":6,"position":630,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" In Source batch string used to reset latest received string from string receiving sequence. In other worktasks clears VIN number.  Name in SoftPLC: RESET_LATEST_IDENTIFIER      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":631,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Latest Identifier - 10114"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":632,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Latest Identifier - 10114"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":633,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Latest Identifier - 10114"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":634,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Latest Identifier - 10114"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":635,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Latest Identifier - 10114"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":636,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Latest Identifier - 10114"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":637,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Latest Identifier - 10114"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":638,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Latest Identifier - 10114"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":639,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Latest Identifier - 10114"],"content":"  I\/O Expander: TRUE"},{"id":"15309466251","fileName":"15309466251.html","title":"Reset Sequence Status - 10118","level":6,"position":640,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Resets signals Batch Sequence Done\/OK\/NOK and Sequence Aborted.  Name in SoftPLC: RESET_SEQUENCE_STATUS      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":641,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Sequence Status - 10118"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":642,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Sequence Status - 10118"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":643,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Sequence Status - 10118"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":644,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Sequence Status - 10118"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":645,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Sequence Status - 10118"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":646,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Sequence Status - 10118"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":647,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Sequence Status - 10118"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":648,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Sequence Status - 10118"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":649,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Sequence Status - 10118"],"content":"  I\/O Expander: TRUE"},{"id":"15415986315","fileName":"15415986315.html","title":"Reset System Error - 10062","level":6,"position":650,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC: RESET_SYSTEM_ERROR      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":651,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset System Error - 10062"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":652,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset System Error - 10062"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":653,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset System Error - 10062"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":654,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset System Error - 10062"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":655,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset System Error - 10062"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":656,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset System Error - 10062"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":657,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset System Error - 10062"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":658,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset System Error - 10062"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":659,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset System Error - 10062"],"content":"  I\/O Expander: TRUE"},{"id":"15309469963","fileName":"15309469963.html","title":"Reset Too Many NOK - 10013","level":6,"position":660,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Reset the batch after receiving lock Too Many NOK  Name in SoftPLC: RESET_TOO_MANY_NOK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":661,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Too Many NOK - 10013"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":662,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Too Many NOK - 10013"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":663,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Too Many NOK - 10013"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":664,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Too Many NOK - 10013"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":665,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Too Many NOK - 10013"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":666,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Too Many NOK - 10013"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":667,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Too Many NOK - 10013"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":668,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Too Many NOK - 10013"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":669,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Reset Too Many NOK - 10013"],"content":"  I\/O Expander: TRUE"},{"id":"15309473675","fileName":"15309473675.html","title":"Select Input - 10020","level":6,"position":670,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Selects Tightening Program withing Source Tightening\/Batch within sequence.  Name in SoftPLC: SELECT_INPUT_VALUE      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Integer  1  16   TreatZeroAsOne  State  Integer  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: TRUE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":671,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input - 10020"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":672,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input - 10020"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":673,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input - 10020"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":674,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input - 10020"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":675,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input - 10020"],"content":" Tool Functions: FALSE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":676,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input - 10020"],"content":" ST Selector: TRUE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":677,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input - 10020"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":678,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input - 10020"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":679,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input - 10020"],"content":" I\/O Expander: FALSE"},{"id":"15311768587","fileName":"15311768587.html","title":"Select Input and Dynamic Batch Size - 30007","level":6,"position":680,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" It is used to set the Batch Size for a specific \"Identifier Number\" in a Source Tightening Task, running \"External batch control\". Batch size can be set to 1-250.  If Batch size is set to 0, it is treated as infinite batch. The user is not able to un-set a Batch back to a state where it has no size, once it has been set.      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Integer  16  16   TreatZeroAsOne  State  Integer  16  16   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":681,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input and Dynamic Batch Size - 30007"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":682,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input and Dynamic Batch Size - 30007"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":683,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input and Dynamic Batch Size - 30007"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":684,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input and Dynamic Batch Size - 30007"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":685,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input and Dynamic Batch Size - 30007"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":686,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input and Dynamic Batch Size - 30007"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":687,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input and Dynamic Batch Size - 30007"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":688,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input and Dynamic Batch Size - 30007"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":689,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input and Dynamic Batch Size - 30007"],"content":" I\/O Expander: FALSE"},{"id":"15138529931","fileName":"15138529931.html","title":"Select Input Bit 0 - 10016","level":6,"position":690,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_0      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":691,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 0 - 10016"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":692,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 0 - 10016"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":693,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 0 - 10016"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":694,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 0 - 10016"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":695,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 0 - 10016"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":696,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 0 - 10016"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":697,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 0 - 10016"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":698,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 0 - 10016"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":699,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 0 - 10016"],"content":"  I\/O Expander: TRUE"},{"id":"15210523147","fileName":"15210523147.html","title":"Select Input Bit 1 - 10017","level":6,"position":700,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_1      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":701,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 1 - 10017"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":702,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 1 - 10017"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":703,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 1 - 10017"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":704,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 1 - 10017"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":705,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 1 - 10017"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":706,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 1 - 10017"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":707,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 1 - 10017"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":708,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 1 - 10017"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":709,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 1 - 10017"],"content":"  I\/O Expander: TRUE"},{"id":"15217407371","fileName":"15217407371.html","title":"Select Input Bit 2 - 10018","level":6,"position":710,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_2      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":711,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 2 - 10018"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":712,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 2 - 10018"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":713,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 2 - 10018"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":714,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 2 - 10018"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":715,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 2 - 10018"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":716,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 2 - 10018"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":717,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 2 - 10018"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":718,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 2 - 10018"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":719,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 2 - 10018"],"content":"  I\/O Expander: TRUE"},{"id":"15217430795","fileName":"15217430795.html","title":"Select Input Bit 3 - 10019","level":6,"position":720,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_3      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":721,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 3 - 10019"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":722,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 3 - 10019"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":723,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 3 - 10019"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":724,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 3 - 10019"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":725,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 3 - 10019"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":726,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 3 - 10019"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":727,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 3 - 10019"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":728,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 3 - 10019"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":729,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 3 - 10019"],"content":"  I\/O Expander: TRUE"},{"id":"15294280075","fileName":"15294280075.html","title":"Select Input Bit 4 - 10066","level":6,"position":730,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_4      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":731,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 4 - 10066"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":732,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 4 - 10066"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":733,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 4 - 10066"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":734,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 4 - 10066"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":735,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 4 - 10066"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":736,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 4 - 10066"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":737,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 4 - 10066"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":738,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 4 - 10066"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":739,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 4 - 10066"],"content":"  I\/O Expander: TRUE"},{"id":"15189453323","fileName":"15189453323.html","title":"Select Input Bit 5 - 10067","level":6,"position":740,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_5      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":741,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 5 - 10067"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":742,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 5 - 10067"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":743,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 5 - 10067"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":744,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 5 - 10067"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":745,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 5 - 10067"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":746,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 5 - 10067"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":747,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 5 - 10067"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":748,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 5 - 10067"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":749,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 5 - 10067"],"content":"  I\/O Expander: TRUE"},{"id":"15217501067","fileName":"15217501067.html","title":"Select Input Bit 6 - 10068","level":6,"position":750,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_6      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":751,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 6 - 10068"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":752,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 6 - 10068"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":753,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 6 - 10068"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":754,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 6 - 10068"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":755,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 6 - 10068"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":756,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 6 - 10068"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":757,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 6 - 10068"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":758,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 6 - 10068"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":759,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 6 - 10068"],"content":"  I\/O Expander: TRUE"},{"id":"15217524491","fileName":"15217524491.html","title":"Select Input Bit 7 - 10069","level":6,"position":760,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_7      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":761,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 7 - 10069"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":762,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 7 - 10069"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":763,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 7 - 10069"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":764,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 7 - 10069"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":765,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 7 - 10069"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":766,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 7 - 10069"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":767,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 7 - 10069"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":768,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 7 - 10069"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":769,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 7 - 10069"],"content":"  I\/O Expander: TRUE"},{"id":"15217550603","fileName":"15217550603.html","title":"Select Input Bit 8 - 10070","level":6,"position":770,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_8      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":771,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 8 - 10070"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":772,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 8 - 10070"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":773,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 8 - 10070"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":774,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 8 - 10070"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":775,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 8 - 10070"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":776,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 8 - 10070"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":777,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 8 - 10070"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":778,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 8 - 10070"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":779,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 8 - 10070"],"content":"  I\/O Expander: TRUE"},{"id":"15217919627","fileName":"15217919627.html","title":"Select Input Bit 9 - 10071","level":6,"position":780,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_9      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":781,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 9 - 10071"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":782,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 9 - 10071"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":783,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 9 - 10071"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":784,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 9 - 10071"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":785,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 9 - 10071"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":786,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 9 - 10071"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":787,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 9 - 10071"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":788,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 9 - 10071"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":789,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Input Bit 9 - 10071"],"content":"  I\/O Expander: TRUE"},{"id":"15311772299","fileName":"15311772299.html","title":"Select Loosening - 10029","level":6,"position":790,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Selects loosening as default operation mode and used in combination with Start Tools -10028 signal.  Name in SoftPLC: SELECT_LOOSENING      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":791,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Loosening - 10029"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":792,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Loosening - 10029"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":793,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Loosening - 10029"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":794,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Loosening - 10029"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":795,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Loosening - 10029"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":796,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Loosening - 10029"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":797,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Loosening - 10029"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":798,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Loosening - 10029"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":799,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Loosening - 10029"],"content":"  I\/O Expander: TRUE"},{"id":"15311776267","fileName":"15311776267.html","title":"Select Next Identifier Number - 10116","level":6,"position":800,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  It is possible to use the signal Select Next Identifier Number when a task in the virtual station is configured as:   Batch Sequence   Source Tightening   Source Batch    Number Identifiermethod   String Identifiermethod  ST Selector configurable functions Take Nextand Take Previousenable the input signals Select Next Identifier Numberand Select Previous Identifier Number. Batch Sequence selected as Virtual Station Task If Free Orderswitch has been enabled, the signal Select Next Identifier Number can select different batches within the selected sequence.  Before selecting batches, it is mandatory that they have the identifier number assigned. If a batch does not have the identifier number assigned, the signal Select Next Identifier Number cannot select it, even if Free Orderswitch is enabled. It enables looping through the batches that have a configured identifier number. If identifier number is \"None\", it is possible to select it only after all Batches with configured identifier number are completed.  It is possible to do looping, but 0 is skipped. When a batch is finished, it is no longer selectable. For example, in case of batches with assigned identifier numbers 1,2,4,5, the signal runs in loop: 1,2,4,5,1,2,4... as long as the batches are not finished. Source Tightening selected as Virtual Station Task The signal selects the next identifier number from the list of tightening programs specified in the Source Tightening task. The selection runs from the currently selected identifier number to the next larger one. When the biggest identifier number is selected, this signal selects 0; after 0, the signal selects the next bigger identifier number.  If 0 is selected as identifier number, the tool is locked. If the identifier number has been added to the Source Tightening list, but no tightening program has ever been assigned to it, it is skipped while looping through the Source Tightening list. If the tightening program is assigned to an identifier number and then it is removed from the list of tightening programs, it is still possible to select this identifier number. In this case, the tool is locked because there is not a specific tightening program. When Selector Modeswitch is set to Confirm, the socket selector needs to be assigned and configured. All tightening programs can be selected, but before running them, appropriate socket must be lifted from the socket selector. Source Batch selected as Virtual Station Task In Sources > Batch Sequence > Source Batch, when the identifier method is set to Number, the signal Select Next Identifier Number selects sequences from a list of sequences shown in Source Batchtask.  It is possible to do looping through 0. The signal Select Next Identifier Number selects only the identifier numbers assigned to sequences. For example, if there are 4 sequences available with identifier numbers 1,2,4, and 8, the signal Select Next Identifier Number iterates and selects 1,2,4,8,0,1,2...  The identifier numbers not defined are not selected. In Sources > Batch Sequence > Source Batch, when the identifier method is set to String, it is necessary to select the sequence through external sources (like scanner or Open Protocol). The signal Select Next Identifier Number is able to select the batches within the selected sequence.  Name in SoftPLC: SELECT_NEXT_ID_NUMBER      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: TRUE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":801,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Next Identifier Number - 10116"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":802,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Next Identifier Number - 10116"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":803,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Next Identifier Number - 10116"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":804,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Next Identifier Number - 10116"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":805,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Next Identifier Number - 10116"],"content":" Tool Functions: TRUE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":806,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Next Identifier Number - 10116"],"content":" ST Selector: TRUE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":807,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Next Identifier Number - 10116"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":808,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Next Identifier Number - 10116"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":809,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Next Identifier Number - 10116"],"content":"  I\/O Expander: TRUE"},{"id":"15314250379","fileName":"15314250379.html","title":"Select Previous Identifier Number - 10117","level":6,"position":810,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  It is possible to use the signal Select Previous Identifier Number when a task in the virtual station is configured as:   Batch Sequence   Source Tightening   Source Batch    Number Identifiermethod   String Identifiermethod  ST Selector configurable functions Take Nextand Take Previousenable the input signals Select Next Identifier Numberand Select Previous Identifier Number. Batch Sequence selected as Virtual Station Task If Free Orderswitch has been enabled, the signal Select Previous Identifier Number can select different batches within the selected sequence.  Before selecting batches, it is mandatory that they have the identifier number assigned. If a batch does not have the identifier number assigned, the signal Select Previous Identifier Number cannot select it, even if Free Orderswitch is enabled. It enables looping through the batches that have a configured identifier number. If identifier number is \"None\", it is possible to select it only after all Batches with configured identifier number are completed.  It is possible to do looping, but 0 is skipped. When a batch is finished, it is no longer selectable. For example, in case of batches with assigned identifier numbers 1,2,4,5, the signal runs in loop: 5,4,2,1,5,4,2... as long as the batches are not finished. Source Tightening selected as Virtual Station Task The signal selects the previous identifier number from the list of tightening programs specified in the Source Tightening task. The selection runs from the currently selected identifier number to the previous lower one. When the smallest identifier number is selected, this signal selects 0; after 0, the signal selects the next smaller identifier number.  If 0 is selected as identifier number, the tool is locked. If the tightening program is assigned to an identifier number and then it is removed from the list of tightening programs, it is still possible to select this identifier number. In this case, the tool is locked because there is not a specific tightening program. When Selector Modeswitch is set to Confirm, the socket selector needs to be assigned and configured. All tightening programs can be selected, but before running them, appropriate socket must be lifted from the socket selector. Source Batch selected as Virtual Station Task In Sources > Batch Sequence > Source Batch, when the identifier method is set to Number, the signal Select Previous Identifier Number selects sequences from a list of sequences shown in Source Batchtask.  It is possible to do looping through 0. The signal Select Previous Identifier Number selects only the identifier numbers assigned to sequences. For example, if there are 4 sequences available with identifier numbers 1,2,4, and 8, the signal Select Previous Identifier Number iterates and selects 8,4,2,1,0,8,4...  The identifier numbers not defined are not selected. In Sources > Batch Sequence > Source Batch, when the identifier method is set to String, it is necessary to select the sequence through external sources (like scanner or Open Protocol). The signal Select Previous Identifier Number is able to select the batches within the selected sequence.  Name in SoftPLC: SELECT_PREVIOUS_ID_NUMBER      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: TRUE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":811,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Previous Identifier Number - 10117"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":812,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Previous Identifier Number - 10117"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":813,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Previous Identifier Number - 10117"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":814,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Previous Identifier Number - 10117"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":815,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Previous Identifier Number - 10117"],"content":" Tool Functions: TRUE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":816,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Previous Identifier Number - 10117"],"content":" ST Selector: TRUE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":817,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Previous Identifier Number - 10117"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":818,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Previous Identifier Number - 10117"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":819,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Select Previous Identifier Number - 10117"],"content":"  I\/O Expander: TRUE"},{"id":"15314254091","fileName":"15314254091.html","title":"Set Bistable Relay - 10021","level":6,"position":820,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Set the bistable relay output.  Name in SoftPLC: SET_BISTABLE_RELAY      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":821,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Set Bistable Relay - 10021"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":822,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Set Bistable Relay - 10021"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":823,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Set Bistable Relay - 10021"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":824,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Set Bistable Relay - 10021"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":825,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Set Bistable Relay - 10021"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":826,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Set Bistable Relay - 10021"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":827,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Set Bistable Relay - 10021"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":828,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Set Bistable Relay - 10021"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":829,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Set Bistable Relay - 10021"],"content":"  I\/O Expander: TRUE"},{"id":"22163331339","fileName":"22163331339.html","title":"Set Zero Position - 10135","level":6,"position":830,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" For hand-held tools, the input signal Set Zero Positionkeeps the current position of the tools as home position. The signal is silently ignored if sent during an ongoing tightening. For fixtured tools, the input signal Set Zero Positionkeeps the current position of the tools as home position. The signal affects all the tools in the system, regardless of the virtual station. The signal is silently ignored by fixtured tools that are part of an ongoing tightening.  Name in SoftPLC: IN_EXTERNAL_SET_ZERO_POSITION      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":831,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Set Zero Position - 10135"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":832,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Set Zero Position - 10135"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":833,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Set Zero Position - 10135"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":834,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Set Zero Position - 10135"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":835,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Set Zero Position - 10135"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":836,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Set Zero Position - 10135"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":837,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Set Zero Position - 10135"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":838,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Set Zero Position - 10135"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":839,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Set Zero Position - 10135"],"content":"  I\/O Expander: TRUE"},{"id":"15314726027","fileName":"15314726027.html","title":"Start Loosening - 10011","level":6,"position":840,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Active signal starts loosening. Once digital input goes inactive the loosening must be stopped.  Name in SoftPLC: START_LOOSENING      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":841,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Loosening - 10011"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":842,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Loosening - 10011"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":843,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Loosening - 10011"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":844,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Loosening - 10011"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":845,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Loosening - 10011"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":846,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Loosening - 10011"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":847,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Loosening - 10011"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":848,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Loosening - 10011"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":849,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Loosening - 10011"],"content":"  I\/O Expander: TRUE"},{"id":"15416018443","fileName":"15416018443.html","title":"Start Loosening, Pulse - 10072","level":6,"position":850,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC: SELECT_PREVIOUS_ID_NUMBER      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: TRUE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":851,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Loosening, Pulse - 10072"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":852,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Loosening, Pulse - 10072"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":853,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Loosening, Pulse - 10072"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":854,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Loosening, Pulse - 10072"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":855,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Loosening, Pulse - 10072"],"content":" Tool Functions: TRUE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":856,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Loosening, Pulse - 10072"],"content":" ST Selector: TRUE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":857,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Loosening, Pulse - 10072"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":858,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Loosening, Pulse - 10072"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":859,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Loosening, Pulse - 10072"],"content":"  I\/O Expander: TRUE"},{"id":"15319511435","fileName":"15319511435.html","title":"Start Tightening - 10010","level":6,"position":860,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Active signal starts tightening. Once input goes inactive the tightening must be stopped.  Name in SoftPLC: START_TIGHTENING      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":861,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tightening - 10010"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":862,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tightening - 10010"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":863,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tightening - 10010"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":864,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tightening - 10010"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":865,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tightening - 10010"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":866,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tightening - 10010"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":867,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tightening - 10010"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":868,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tightening - 10010"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":869,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tightening - 10010"],"content":"  I\/O Expander: TRUE"},{"id":"15319515147","fileName":"15319515147.html","title":"Start Tightening Pulse - 10024","level":6,"position":870,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" The tightening starts at signal. Runs until the tightening is finished, or until the 30 sec timeout in tightening program occurs.  Name in SoftPLC: TIGHTENING_START_PULSE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":871,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tightening Pulse - 10024"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":872,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tightening Pulse - 10024"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":873,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tightening Pulse - 10024"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":874,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tightening Pulse - 10024"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":875,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tightening Pulse - 10024"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":876,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tightening Pulse - 10024"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":877,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tightening Pulse - 10024"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":878,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tightening Pulse - 10024"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":879,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tightening Pulse - 10024"],"content":"  I\/O Expander: TRUE"},{"id":"15319518859","fileName":"15319518859.html","title":"Start Tools - 10028","level":6,"position":880,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Active signal which starts the tool (default operation mode is tightening). As soon as signal goes inactive the tool must be stopped. Used in combination with Select Loosening - 10029 signal.  Name in SoftPLC: START_DRIVE_CONTINIOUS      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":881,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tools - 10028"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":882,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tools - 10028"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":883,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tools - 10028"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":884,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tools - 10028"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":885,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tools - 10028"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":886,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tools - 10028"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":887,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tools - 10028"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":888,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tools - 10028"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":889,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tools - 10028"],"content":"  I\/O Expander: TRUE"},{"id":"15416029451","fileName":"15416029451.html","title":"Start Tools, Pulse - 10113","level":6,"position":890,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: TRUE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":891,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tools, Pulse - 10113"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":892,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tools, Pulse - 10113"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":893,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tools, Pulse - 10113"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":894,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tools, Pulse - 10113"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":895,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tools, Pulse - 10113"],"content":" Tool Functions: TRUE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":896,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tools, Pulse - 10113"],"content":" ST Selector: TRUE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":897,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tools, Pulse - 10113"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":898,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tools, Pulse - 10113"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":899,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Start Tools, Pulse - 10113"],"content":"  I\/O Expander: TRUE"},{"id":"21014041227","fileName":"21014041227.html","title":"Stop (pulse) - 10129","level":6,"position":900,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" If this signal is generated any ongoing tightening or loosening will be stopped. Used in combination with 10024 or 10072.  Name in SoftPLC: EXTERNAL_STOP_PULSE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":901,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Stop (pulse) - 10129"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":902,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Stop (pulse) - 10129"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":903,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Stop (pulse) - 10129"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":904,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Stop (pulse) - 10129"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":905,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Stop (pulse) - 10129"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":906,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Stop (pulse) - 10129"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":907,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Stop (pulse) - 10129"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":908,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Stop (pulse) - 10129"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":909,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Stop (pulse) - 10129"],"content":"  I\/O Expander: TRUE"},{"id":"21014095499","fileName":"21014095499.html","title":"Stop (state) - 10133","level":6,"position":910,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" If this signal is set, any ongoing tightening or loosening will be stopped. Will also block any start attempts while set high. Used in combination with 10024 or 10072.  Name in SoftPLC: IN_EXTERNAL_STOP_STATE      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":911,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Stop (state) - 10133"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":912,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Stop (state) - 10133"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":913,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Stop (state) - 10133"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":914,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Stop (state) - 10133"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":915,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Stop (state) - 10133"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":916,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Stop (state) - 10133"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":917,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Stop (state) - 10133"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":918,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Stop (state) - 10133"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":919,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Stop (state) - 10133"],"content":"  I\/O Expander: TRUE"},{"id":"15319522571","fileName":"15319522571.html","title":"To SoftPLC - 10065","level":6,"position":920,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC: TO_PLC      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  uint8 array  1  1   Fieldbus: FALSE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":921,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","To SoftPLC - 10065"],"content":" Fieldbus: FALSE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":922,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","To SoftPLC - 10065"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":923,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","To SoftPLC - 10065"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":924,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","To SoftPLC - 10065"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":925,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","To SoftPLC - 10065"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":926,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","To SoftPLC - 10065"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":927,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","To SoftPLC - 10065"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":928,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","To SoftPLC - 10065"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":929,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","To SoftPLC - 10065"],"content":"  I\/O Expander: TRUE"},{"id":"15292388875","fileName":"15292388875.html","title":"Unlock Tool on Complete - 10051","level":6,"position":930,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":" Unlocks a tool that is locked by \"Tool Lock on Complete\".  Name in SoftPLC: UNLOCK_TOOL_ON_COMPLETE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":931,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Unlock Tool on Complete - 10051"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":932,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Unlock Tool on Complete - 10051"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":933,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Unlock Tool on Complete - 10051"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":934,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Unlock Tool on Complete - 10051"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":935,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Unlock Tool on Complete - 10051"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":936,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Unlock Tool on Complete - 10051"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":937,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Unlock Tool on Complete - 10051"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":938,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Unlock Tool on Complete - 10051"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":939,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Unlock Tool on Complete - 10051"],"content":"  I\/O Expander: TRUE"},{"id":"15292209803","fileName":"15292209803.html","title":"Unlock Tool on Disable - 10059","level":6,"position":940,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals"],"content":"  Name in SoftPLC: UNLOCK_TOOL_ON_DISABLE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":941,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Unlock Tool on Disable - 10059"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":942,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Unlock Tool on Disable - 10059"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":943,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Unlock Tool on Disable - 10059"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":944,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Unlock Tool on Disable - 10059"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":945,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Unlock Tool on Disable - 10059"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":946,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Unlock Tool on Disable - 10059"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":947,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Unlock Tool on Disable - 10059"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":948,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Unlock Tool on Disable - 10059"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":949,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input Signals","Unlock Tool on Disable - 10059"],"content":"  I\/O Expander: TRUE"},{"id":"18265945099","fileName":"1826594509928074113419.html","title":"Output Signals","level":5,"position":950,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals"],"content":"      Signal  Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]  Devices     title   item   item   item   none   none   subnodes "},{"id":"15058671499","fileName":"15058671499.html","title":"Active Identifier String - 186","level":6,"position":951,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Set when an identifier string has been received and accepted by the work-task; it is necessary that even sequence or tightening program are running. If running Source batch-string, it is set when all scans have been received and a sequence had been selected. In that case it includes concatenated string consisted of saved positions. For other work-tasks it includes the “VIN” number.  Name in SoftPLC: ACTIVE_IDENTIFIER_STRING      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  String  8  800   IdentifierU32Hnw  State  String  8  800   IdentifierU32  State  String  8  800   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":952,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String - 186"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":953,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String - 186"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":954,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String - 186"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":955,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String - 186"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":956,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String - 186"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":957,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String - 186"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":958,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String - 186"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":959,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String - 186"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":960,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String - 186"],"content":" I\/O Expander: FALSE"},{"id":"15059027211","fileName":"15059027211.html","title":"Active Identifier String 1 - 188","level":6,"position":961,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Signal corresponding to the first configured string in Source batch-string. Active Identifier String 1 signal is sent once a scanning sequence is done and a sequence has been selected, thus the identifier parts are active. The strings is filtered with saved position. Only sent when running Source batch string.  Name in SoftPLC: ACTIVE_ID_STRING_1      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  String  8  800   IdentifierU32Hnw  State  String  8  800   IdentifierU32  State  String  8  800   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":962,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 1 - 188"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":963,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 1 - 188"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":964,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 1 - 188"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":965,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 1 - 188"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":966,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 1 - 188"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":967,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 1 - 188"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":968,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 1 - 188"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":969,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 1 - 188"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":970,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 1 - 188"],"content":" I\/O Expander: FALSE"},{"id":"15059037835","fileName":"15059037835.html","title":"Active Identifier String 2 - 189","level":6,"position":971,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Signal corresponding to the second configured string in Source batch-string. Active Identifier String 2 signal is sent once a scanning sequence is done and a sequence has been selected, thus the identifier parts are active. The strings is filtered with saved position. Only sent when running Source batch string.  Name in SoftPLC: ACTIVE_ID_STRING_2      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  String  8  800   IdentifierU32Hnw  State  String  8  800   IdentifierU32  State  String  8  800   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":972,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 2 - 189"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":973,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 2 - 189"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":974,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 2 - 189"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":975,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 2 - 189"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":976,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 2 - 189"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":977,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 2 - 189"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":978,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 2 - 189"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":979,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 2 - 189"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":980,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 2 - 189"],"content":" I\/O Expander: FALSE"},{"id":"15059713419","fileName":"15059713419.html","title":"Active Identifier String 3 - 190","level":6,"position":981,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Signal corresponding to the third configured string in Source batch-string. Active Identifier String 3 signal is sent once a scanning sequence is done and a sequence has been selected, thus the identifier parts are active. The strings is filtered with saved position. Only sent when running Source batch string.  Name in SoftPLC: ACTIVE_ID_STRING_3      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  String  8  800   IdentifierU32Hnw  State  String  8  800   IdentifierU32  State  String  8  800   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":982,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 3 - 190"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":983,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 3 - 190"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":984,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 3 - 190"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":985,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 3 - 190"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":986,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 3 - 190"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":987,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 3 - 190"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":988,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 3 - 190"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":989,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 3 - 190"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":990,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 3 - 190"],"content":" I\/O Expander: FALSE"},{"id":"15059742219","fileName":"15059742219.html","title":"Active Identifier String 4 - 191","level":6,"position":991,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Signal corresponding to the fourth configured string in Source batch-string. Active Identifier String 4 signal is sent once a scanning sequence is done and a sequence has been selected, thus the identifier parts are active. The strings is filtered with saved position. Only sent when running Source batch string.  Name in SoftPLC: ACTIVE_ID_STRING_4      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  String  8  800   IdentifierU32Hnw  State  String  8  800   IdentifierU32  State  String  8  800   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":992,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 4 - 191"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":993,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 4 - 191"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":994,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 4 - 191"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":995,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 4 - 191"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":996,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 4 - 191"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":997,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 4 - 191"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":998,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 4 - 191"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":999,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 4 - 191"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1000,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Active Identifier String 4 - 191"],"content":" I\/O Expander: FALSE"},{"id":"15059777035","fileName":"15059777035.html","title":"Batch Completed - 30","level":6,"position":1001,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Batch Completed is an output signal which is triggered when the batch is complete. The batch result status (OK or NOK) has no effect on the Batch Completed signal.  Name in SoftPLC: BATCH_COMPLETED      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1002,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed - 30"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1003,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed - 30"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1004,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed - 30"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1005,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed - 30"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1006,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed - 30"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1007,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed - 30"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1008,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed - 30"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1009,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed - 30"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1010,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed - 30"],"content":"  I\/O Expander: TRUE"},{"id":"15103018891","fileName":"15103018891.html","title":"Batch Completed NOK - 37","level":6,"position":1011,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Batch finished with status NOK.  Name in SoftPLC: BATCH_COMPLETED_NOK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1012,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed NOK - 37"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1013,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed NOK - 37"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1014,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed NOK - 37"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1015,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed NOK - 37"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1016,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed NOK - 37"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1017,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed NOK - 37"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1018,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed NOK - 37"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1019,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed NOK - 37"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1020,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed NOK - 37"],"content":"  I\/O Expander: TRUE"},{"id":"15103026955","fileName":"15103026955.html","title":"Batch Completed OK - 36","level":6,"position":1021,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Batch finished with status OK.  Name in SoftPLC: BATCH_COMPLETED_OK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1022,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed OK - 36"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1023,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed OK - 36"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1024,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed OK - 36"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1025,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed OK - 36"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1026,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed OK - 36"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1027,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed OK - 36"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1028,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed OK - 36"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1029,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed OK - 36"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1030,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Completed OK - 36"],"content":"  I\/O Expander: TRUE"},{"id":"15103048843","fileName":"15103048843.html","title":"Batch Count - 31","level":6,"position":1031,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Batch Count is an output signal which shows the current number of tightening in the batch.  Name in SoftPLC: BATCH_COUNT      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  8   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: TRUE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1032,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Count - 31"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1033,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Count - 31"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1034,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Count - 31"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1035,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Count - 31"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1036,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Count - 31"],"content":" Tool Functions: FALSE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":1037,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Count - 31"],"content":" ST Selector: TRUE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1038,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Count - 31"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1039,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Count - 31"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1040,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Count - 31"],"content":" I\/O Expander: FALSE"},{"id":"15114137867","fileName":"15114137867.html","title":"Batch Running - 32","level":6,"position":1041,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Indicates that a batch in a batch sequence is running.  Name in SoftPLC: BATCH_RUNNING      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1042,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Running - 32"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1043,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Running - 32"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1044,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Running - 32"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1045,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Running - 32"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1046,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Running - 32"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1047,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Running - 32"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1048,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Running - 32"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1049,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Running - 32"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1050,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Running - 32"],"content":"  I\/O Expander: TRUE"},{"id":"15118036619","fileName":"15118036619.html","title":"Batch Sequence Completed NOK - 46","level":6,"position":1051,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Batch sequence finished with status NOK.  Name in SoftPLC: BATCH_SEQUENCE_NOK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1052,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Completed NOK - 46"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1053,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Completed NOK - 46"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1054,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Completed NOK - 46"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1055,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Completed NOK - 46"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1056,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Completed NOK - 46"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1057,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Completed NOK - 46"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1058,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Completed NOK - 46"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1059,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Completed NOK - 46"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1060,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Completed NOK - 46"],"content":"  I\/O Expander: TRUE"},{"id":"15118064907","fileName":"15118064907.html","title":"Batch Sequence Completed OK - 45","level":6,"position":1061,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Batch sequence finished with status OK.  Name in SoftPLC: BATCH_SEQUENCE_OK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1062,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Completed OK - 45"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1063,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Completed OK - 45"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1064,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Completed OK - 45"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1065,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Completed OK - 45"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1066,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Completed OK - 45"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1067,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Completed OK - 45"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1068,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Completed OK - 45"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1069,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Completed OK - 45"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1070,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Completed OK - 45"],"content":"  I\/O Expander: TRUE"},{"id":"15118080907","fileName":"15118080907.html","title":"Batch Sequence Done - 48","level":6,"position":1071,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Indicates when a sequence is completed, both in case Batch Sequence Completed OK and Batch Sequence Completed NOK.  Name in SoftPLC: BATCH_SEQUENCE_COMPLETED      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  Event  Boolean  1  1   Invert  Event  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1072,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Done - 48"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1073,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Done - 48"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1074,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Done - 48"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1075,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Done - 48"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1076,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Done - 48"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1077,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Done - 48"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1078,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Done - 48"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1079,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Done - 48"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1080,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Done - 48"],"content":"  I\/O Expander: TRUE"},{"id":"15127467659","fileName":"15127467659.html","title":"Batch Sequence Running - 47","level":6,"position":1081,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Indicates if the Batch Sequence is running or not.  Name in SoftPLC: BATCHSEQUENCE_RUNNING      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1082,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Running - 47"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1083,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Running - 47"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1084,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Running - 47"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1085,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Running - 47"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1086,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Running - 47"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1087,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Running - 47"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1088,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Running - 47"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1089,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Running - 47"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1090,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Batch Sequence Running - 47"],"content":"  I\/O Expander: TRUE"},{"id":"15128100363","fileName":"15128100363.html","title":"Bistable Relay - 40","level":6,"position":1091,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Bistable Relay is a signal controlled by the inputs \"Set Bistable Relay\" and \"Reset Bistable Relay\". After receiving the input \"Set Bistable Relay\", Bistable Relay signal is set to True. After receiving the input \"Reset Bistable Relay\", Bistable Relay signal is set to False. If \"Set Bistable Relay\" or \"Reset Bistable Relay\" goes low, the Bistable relay keeps its state. The state for the Bistable relay changes when \"Set Bistable Relay\" or \"Reset Bistable Relay\" goes high. After restarting the controller, the Bistable relay is set to False as default.  Name in SoftPLC: BISTABLE_RELAY      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1092,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Bistable Relay - 40"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1093,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Bistable Relay - 40"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1094,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Bistable Relay - 40"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1095,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Bistable Relay - 40"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1096,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Bistable Relay - 40"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1097,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Bistable Relay - 40"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1098,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Bistable Relay - 40"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1099,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Bistable Relay - 40"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1100,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Bistable Relay - 40"],"content":"  I\/O Expander: TRUE"},{"id":"15413918731","fileName":"15413918731.html","title":"Bolt Tightening Status - 79","level":6,"position":1101,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Bolt Tightening Status is an output signal that identifies the status for individual bolts in a synchronized tightening. 100 bolts are supported. Bolt Tightening Status signal shows information related to the running tightening and the result of the last tightening.  Name in SoftPLC: BOLT_TIGHTENING_STATUS      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  uint32 array  32  32   FordResultStatus  State   4  4   CompactErrorStatus  State   4  4   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character). The signal Bolt Tightening Status - 79contains sub-signals (for more information, see \"Output Signals: Sub-signals\").   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1102,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Bolt Tightening Status - 79"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1103,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Bolt Tightening Status - 79"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1104,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Bolt Tightening Status - 79"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1105,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Bolt Tightening Status - 79"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1106,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Bolt Tightening Status - 79"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1107,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Bolt Tightening Status - 79"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1108,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Bolt Tightening Status - 79"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1109,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Bolt Tightening Status - 79"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1110,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Bolt Tightening Status - 79"],"content":"  I\/O Expander: TRUE"},{"id":"15413934859","fileName":"15413934859.html","title":"Channel Hardware Status - 81","level":6,"position":1111,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Channel Hardware Status is an output signal that identifies the hardware status for individual channels. 64 channels are supported. Channel Hardware Status signal shows information about the hardware status and possible errors.  Name in SoftPLC: CHANNEL_HARDWARE_STATUS      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  uint32 array  1  64 The signal Channel Hardware Status - 81contains sub-signals (for more information, see \"Output Signals: Sub-signals\").   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1112,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Channel Hardware Status - 81"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1113,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Channel Hardware Status - 81"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1114,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Channel Hardware Status - 81"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1115,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Channel Hardware Status - 81"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1116,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Channel Hardware Status - 81"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1117,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Channel Hardware Status - 81"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1118,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Channel Hardware Status - 81"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1119,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Channel Hardware Status - 81"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1120,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Channel Hardware Status - 81"],"content":"  I\/O Expander: TRUE"},{"id":"15414576139","fileName":"15414576139.html","title":"Channel Tightening Status - 80","level":6,"position":1121,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Channel Tightening Status is an output signal that identifies the status for individual channels in a synchronized tightening. 64 channels are supported. Channel Tightening Status signal shows information related to the running tightening and the result of the last tightening.  Name in SoftPLC: CHANNEL_TIGHTENING_STATUS      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  uint32 array  1  64   FordResultStatus  State   4  4   CompactErrorStatus  State   4  4   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character). The signal Channel Tightening Status - 80contains sub-signals (for more information, see \"Output Signals: Sub-signals\").   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1122,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Channel Tightening Status - 80"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1123,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Channel Tightening Status - 80"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1124,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Channel Tightening Status - 80"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1125,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Channel Tightening Status - 80"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1126,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Channel Tightening Status - 80"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1127,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Channel Tightening Status - 80"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1128,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Channel Tightening Status - 80"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1129,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Channel Tightening Status - 80"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1130,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Channel Tightening Status - 80"],"content":"  I\/O Expander: TRUE"},{"id":"15137552267","fileName":"15137552267.html","title":"Configuration Version - 88","level":6,"position":1131,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Name in SoftPLC: CONFIGURATION_VERSION      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  32   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1132,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Configuration Version - 88"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1133,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Configuration Version - 88"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1134,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Configuration Version - 88"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1135,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Configuration Version - 88"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1136,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Configuration Version - 88"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1137,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Configuration Version - 88"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1138,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Configuration Version - 88"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1139,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Configuration Version - 88"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1140,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Configuration Version - 88"],"content":" I\/O Expander: FALSE"},{"id":"21002018187","fileName":"21002018187.html","title":"Confirm loosening - 206","level":6,"position":1141,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Indicate if loosening is selected and possible to start. That is, a loosening sync mode or loosening program exists and are selected.  Name in SoftPLC: CONFIRM_LOOSENING      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1142,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Confirm loosening - 206"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1143,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Confirm loosening - 206"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1144,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Confirm loosening - 206"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1145,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Confirm loosening - 206"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1146,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Confirm loosening - 206"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1147,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Confirm loosening - 206"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1148,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Confirm loosening - 206"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1149,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Confirm loosening - 206"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1150,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Confirm loosening - 206"],"content":"  I\/O Expander: TRUE"},{"id":"15137804427","fileName":"15137804427.html","title":"Controller Switched On - 42","level":6,"position":1151,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Set to true at start up of IO Exchange  Name in SoftPLC: IO_ON      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1152,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Controller Switched On - 42"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1153,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Controller Switched On - 42"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1154,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Controller Switched On - 42"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1155,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Controller Switched On - 42"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1156,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Controller Switched On - 42"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1157,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Controller Switched On - 42"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1158,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Controller Switched On - 42"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1159,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Controller Switched On - 42"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1160,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Controller Switched On - 42"],"content":"  I\/O Expander: TRUE"},{"id":"15137889035","fileName":"15137889035.html","title":"Current Running Batch - 180","level":6,"position":1161,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Current Running Batch is an output signal which shows the index of the current running batch in a sequence. If the user uses a socket selector, \" Zero\" appears if none, more than one, or wrong socket is selected. If the user uses batch mode and a batch is running, \" 1\" appears for Source Tightening configurations.  Name in SoftPLC: CURRENT_RUNNING_BATCH_IX      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  8   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: TRUE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1162,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Current Running Batch - 180"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1163,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Current Running Batch - 180"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1164,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Current Running Batch - 180"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1165,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Current Running Batch - 180"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1166,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Current Running Batch - 180"],"content":" Tool Functions: FALSE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":1167,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Current Running Batch - 180"],"content":" ST Selector: TRUE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1168,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Current Running Batch - 180"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1169,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Current Running Batch - 180"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1170,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Current Running Batch - 180"],"content":" I\/O Expander: FALSE"},{"id":"15414591371","fileName":"15414591371.html","title":"Cycle Complete - 77","level":6,"position":1171,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Name in SoftPLC: CYCLE_COMPLETE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1172,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Complete - 77"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1173,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Complete - 77"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1174,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Complete - 77"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1175,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Complete - 77"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1176,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Complete - 77"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1177,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Complete - 77"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1178,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Complete - 77"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1179,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Complete - 77"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1180,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Complete - 77"],"content":"  I\/O Expander: TRUE"},{"id":"21002085643","fileName":"21002085643.html","title":"Cycle Emergency stopped - 202","level":6,"position":1181,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Indicate last tightening or loosening was interrupted by emergency stop.  Name in SoftPLC: CYCLE_EMERGENCY_STOPPED      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1182,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Emergency stopped - 202"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1183,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Emergency stopped - 202"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1184,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Emergency stopped - 202"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1185,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Emergency stopped - 202"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1186,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Emergency stopped - 202"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1187,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Emergency stopped - 202"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1188,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Emergency stopped - 202"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1189,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Emergency stopped - 202"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1190,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Emergency stopped - 202"],"content":"  I\/O Expander: TRUE"},{"id":"15414620555","fileName":"15414620555.html","title":"Cycle NOK - 76","level":6,"position":1191,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Name in SoftPLC: CYCLE_NOK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1192,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle NOK - 76"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1193,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle NOK - 76"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1194,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle NOK - 76"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1195,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle NOK - 76"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1196,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle NOK - 76"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1197,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle NOK - 76"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1198,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle NOK - 76"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1199,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle NOK - 76"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1200,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle NOK - 76"],"content":"  I\/O Expander: TRUE"},{"id":"15414663691","fileName":"15414663691.html","title":"Cycle OK - 75","level":6,"position":1201,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Name in SoftPLC: CYCLE_OK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1202,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle OK - 75"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1203,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle OK - 75"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1204,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle OK - 75"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1205,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle OK - 75"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1206,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle OK - 75"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1207,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle OK - 75"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1208,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle OK - 75"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1209,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle OK - 75"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1210,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle OK - 75"],"content":"  I\/O Expander: TRUE"},{"id":"15414791819","fileName":"15414791819.html","title":"Cycle Ready To Start - 82","level":6,"position":1211,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Name in SoftPLC: CYCLE_READY_TO_START      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1212,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Ready To Start - 82"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1213,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Ready To Start - 82"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1214,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Ready To Start - 82"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1215,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Ready To Start - 82"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1216,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Ready To Start - 82"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1217,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Ready To Start - 82"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1218,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Ready To Start - 82"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1219,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Ready To Start - 82"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1220,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Ready To Start - 82"],"content":"  I\/O Expander: TRUE"},{"id":"15414759179","fileName":"15414759179.html","title":"Cycle Running - 78","level":6,"position":1221,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Name in SoftPLC: CYCLE_RUNNING      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1222,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Running - 78"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1223,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Running - 78"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1224,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Running - 78"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1225,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Running - 78"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1226,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Running - 78"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1227,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Running - 78"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1228,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Running - 78"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1229,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Running - 78"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1230,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Cycle Running - 78"],"content":"  I\/O Expander: TRUE"},{"id":"18199369227","fileName":"18199369227.html","title":"Data Drop Active - 199","level":6,"position":1231,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" This signal will be set high whenever DATADROP function is active. When DATADROP input signal is set and worktask supporting DATADROP is selected.      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1232,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Data Drop Active - 199"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1233,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Data Drop Active - 199"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1234,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Data Drop Active - 199"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1235,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Data Drop Active - 199"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1236,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Data Drop Active - 199"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1237,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Data Drop Active - 199"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1238,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Data Drop Active - 199"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1239,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Data Drop Active - 199"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1240,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Data Drop Active - 199"],"content":"  I\/O Expander: TRUE"},{"id":"18199281419","fileName":"18199281419.html","title":"Data Hold Active - 198","level":6,"position":1241,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" This signal will be set high whenever the DATAHOLD function is active. When DATAHOLD signal is set and a worktask supporting DATAHOLD is selected.      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1242,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Data Hold Active - 198"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1243,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Data Hold Active - 198"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1244,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Data Hold Active - 198"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1245,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Data Hold Active - 198"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1246,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Data Hold Active - 198"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1247,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Data Hold Active - 198"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1248,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Data Hold Active - 198"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1249,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Data Hold Active - 198"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1250,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Data Hold Active - 198"],"content":"  I\/O Expander: TRUE"},{"id":"15138044171","fileName":"15138044171.html","title":"Emergency Stop - 20036","level":6,"position":1251,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Name in SoftPLC: EMERGENCY_STOP      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1252,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Emergency Stop - 20036"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1253,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Emergency Stop - 20036"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1254,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Emergency Stop - 20036"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1255,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Emergency Stop - 20036"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1256,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Emergency Stop - 20036"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1257,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Emergency Stop - 20036"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1258,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Emergency Stop - 20036"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1259,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Emergency Stop - 20036"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1260,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Emergency Stop - 20036"],"content":"  I\/O Expander: TRUE"},{"id":"15138065291","fileName":"15138065291.html","title":"Event Code - 30001","level":6,"position":1261,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Relay an event when it is triggered. Momentary, on for two cycle times.  Name in SoftPLC: EVENT_CODE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  16   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1262,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Code - 30001"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1263,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Code - 30001"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1264,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Code - 30001"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1265,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Code - 30001"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1266,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Code - 30001"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1267,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Code - 30001"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1268,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Code - 30001"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1269,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Code - 30001"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1270,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Code - 30001"],"content":" I\/O Expander: FALSE"},{"id":"15138086411","fileName":"15138086411.html","title":"Event Code Severity - 30003","level":6,"position":1271,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Event Code Severity is an output signal which is activated when the triggered event has severity of error or warning.  Name in SoftPLC: EVENT_CODE_SEVERITY      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1272,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Code Severity - 30003"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1273,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Code Severity - 30003"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1274,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Code Severity - 30003"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1275,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Code Severity - 30003"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1276,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Code Severity - 30003"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1277,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Code Severity - 30003"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1278,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Code Severity - 30003"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1279,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Code Severity - 30003"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1280,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Code Severity - 30003"],"content":" I\/O Expander: FALSE"},{"id":"15138107531","fileName":"15138107531.html","title":"Event Present - 161","level":6,"position":1281,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Indicates if event is triggered. It is only triggered on accessories if event requires an ACK.  Name in SoftPLC: EVENT_PRESENT      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1282,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Present - 161"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1283,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Present - 161"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1284,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Present - 161"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1285,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Present - 161"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1286,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Present - 161"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1287,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Present - 161"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1288,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Present - 161"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1289,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Present - 161"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1290,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Event Present - 161"],"content":"  I\/O Expander: TRUE"},{"id":"15415015819","fileName":"15415015819.html","title":"Fieldbus AsyncData From PF - 107","level":6,"position":1291,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Name in SoftPLC:      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  uint8 array  48  2048   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1292,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Fieldbus AsyncData From PF - 107"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1293,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Fieldbus AsyncData From PF - 107"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1294,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Fieldbus AsyncData From PF - 107"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1295,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Fieldbus AsyncData From PF - 107"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1296,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Fieldbus AsyncData From PF - 107"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1297,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Fieldbus AsyncData From PF - 107"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1298,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Fieldbus AsyncData From PF - 107"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1299,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Fieldbus AsyncData From PF - 107"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1300,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Fieldbus AsyncData From PF - 107"],"content":" I\/O Expander: FALSE"},{"id":"15138128651","fileName":"15138128651.html","title":"Fieldbus Disconnected - 96","level":6,"position":1301,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Name in SoftPLC: FIELDBUS_DISCONNECTED      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":1302,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Fieldbus Disconnected - 96"],"content":" Fieldbus: FALSE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1303,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Fieldbus Disconnected - 96"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1304,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Fieldbus Disconnected - 96"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1305,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Fieldbus Disconnected - 96"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1306,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Fieldbus Disconnected - 96"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1307,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Fieldbus Disconnected - 96"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1308,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Fieldbus Disconnected - 96"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1309,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Fieldbus Disconnected - 96"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1310,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Fieldbus Disconnected - 96"],"content":"  I\/O Expander: TRUE"},{"id":"15228941067","fileName":"15228941067.html","title":"From SoftPLC - 10064","level":6,"position":1311,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Allocated bytes for data transfer from PLC to accessories.  Name in SoftPLC: FROM_PLC      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  uint8 array  8  8   Fieldbus: FALSE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":1312,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","From SoftPLC - 10064"],"content":" Fieldbus: FALSE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1313,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","From SoftPLC - 10064"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1314,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","From SoftPLC - 10064"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1315,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","From SoftPLC - 10064"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1316,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","From SoftPLC - 10064"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1317,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","From SoftPLC - 10064"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1318,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","From SoftPLC - 10064"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1319,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","From SoftPLC - 10064"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1320,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","From SoftPLC - 10064"],"content":"  I\/O Expander: TRUE"},{"id":"15138234251","fileName":"15138234251.html","title":"Identifier Received - 100","level":6,"position":1321,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Name in SoftPLC: IDENTIFIER_RECEIVED      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1322,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Identifier Received - 100"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1323,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Identifier Received - 100"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1324,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Identifier Received - 100"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1325,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Identifier Received - 100"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1326,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Identifier Received - 100"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1327,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Identifier Received - 100"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1328,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Identifier Received - 100"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1329,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Identifier Received - 100"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1330,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Identifier Received - 100"],"content":"  I\/O Expander: TRUE"},{"id":"21049062283","fileName":"21049062283.html","title":"Last Cycle No Result - 200","level":6,"position":1331,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" This signal shall be set after a tightening is done if the tightening is considered as a free running.  Name in SoftPLC: LAST_CYCLE_NO_RESULT      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1332,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Last Cycle No Result - 200"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1333,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Last Cycle No Result - 200"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1334,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Last Cycle No Result - 200"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1335,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Last Cycle No Result - 200"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1336,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Last Cycle No Result - 200"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1337,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Last Cycle No Result - 200"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1338,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Last Cycle No Result - 200"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1339,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Last Cycle No Result - 200"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1340,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Last Cycle No Result - 200"],"content":"  I\/O Expander: TRUE"},{"id":"15228962187","fileName":"15228962187.html","title":"Last Received Identifier String - 187","level":6,"position":1341,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Set directly when an identifier has been received in the work-task. For Source batch-string, it is set at every scanning in scan process, thus it is changed for every scanning and sent even if it does not match in length. String set is in raw format and not only \"saved positions\" in the string. For other work-tasks this signal is equal to Active Identifier String signal.  Name in SoftPLC: LAST_RECEIVED_ID_STRING      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  String  8  800   IdentifierU32Hnw  State  String  8  800   IdentifierU32  State  String  8  800   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1342,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Last Received Identifier String - 187"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1343,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Last Received Identifier String - 187"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1344,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Last Received Identifier String - 187"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1345,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Last Received Identifier String - 187"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1346,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Last Received Identifier String - 187"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1347,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Last Received Identifier String - 187"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1348,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Last Received Identifier String - 187"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1349,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Last Received Identifier String - 187"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1350,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Last Received Identifier String - 187"],"content":" I\/O Expander: FALSE"},{"id":"15228983307","fileName":"15228983307.html","title":"License Server Connection Lost - 134","level":6,"position":1351,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Indicates that the connection to the Atlas Copco license server has been lost or the synchronization has failed. The signal is cleared when the License manager synchronization has been done successfully  Name in SoftPLC: LICENSE_SERVER_CONN_LOST      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1352,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","License Server Connection Lost - 134"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1353,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","License Server Connection Lost - 134"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1354,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","License Server Connection Lost - 134"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1355,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","License Server Connection Lost - 134"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1356,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","License Server Connection Lost - 134"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1357,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","License Server Connection Lost - 134"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1358,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","License Server Connection Lost - 134"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1359,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","License Server Connection Lost - 134"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1360,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","License Server Connection Lost - 134"],"content":"  I\/O Expander: TRUE"},{"id":"15229004427","fileName":"15229004427.html","title":"Loosening Disabled - 184","level":6,"position":1361,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Loosening Disabled is an output signal which is activated when the loosening is externally locked by any of the following signals:  20003 - Lock Loosening  20004 - Lock Tool Active High  20033 - Line Control Lock  20018 - Open Protocol Lock  20021 - Fieldbus Lock Loosening  20041 - Soft PLC Lock Loosening  20061 - Lock Tool Active Low  Name in SoftPLC: LOOSENING_DISABLED      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1362,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening Disabled - 184"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1363,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening Disabled - 184"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1364,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening Disabled - 184"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1365,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening Disabled - 184"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1366,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening Disabled - 184"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1367,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening Disabled - 184"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1368,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening Disabled - 184"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1369,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening Disabled - 184"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1370,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening Disabled - 184"],"content":"  I\/O Expander: TRUE"},{"id":"15229025547","fileName":"15229025547.html","title":"Loosening Enabled - 185","level":6,"position":1371,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Loosening Disabled is an output signal which is activated when the loosening is not externally locked by any of the following signals:  20003 - Lock Loosening  20004 - Lock Tool Active High  20033 - Line Control Lock  20018 - Open Protocol Lock  20021 - Fieldbus Lock Loosening  20041 - Soft PLC Lock Loosening  20061 - Lock Tool Active Low  Name in SoftPLC: LOOSENING_ENABLED      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1372,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening Enabled - 185"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1373,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening Enabled - 185"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1374,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening Enabled - 185"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1375,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening Enabled - 185"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1376,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening Enabled - 185"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1377,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening Enabled - 185"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1378,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening Enabled - 185"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1379,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening Enabled - 185"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1380,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening Enabled - 185"],"content":"  I\/O Expander: TRUE"},{"id":"15229046667","fileName":"15229046667.html","title":"Loosening is Locked - 28","level":6,"position":1381,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" The loosening is disabled.  Name in SoftPLC: LOOSENING_IS_LOCKED      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1382,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening is Locked - 28"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1383,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening is Locked - 28"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1384,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening is Locked - 28"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1385,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening is Locked - 28"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1386,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening is Locked - 28"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1387,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening is Locked - 28"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1388,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening is Locked - 28"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1389,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening is Locked - 28"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1390,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening is Locked - 28"],"content":"  I\/O Expander: TRUE"},{"id":"15229067787","fileName":"15229067787.html","title":"Loosening NOK - 74","level":6,"position":1391,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" NOK loosening took place.  Name in SoftPLC: LOOSENING_NOK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1392,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening NOK - 74"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1393,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening NOK - 74"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1394,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening NOK - 74"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1395,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening NOK - 74"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1396,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening NOK - 74"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1397,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening NOK - 74"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1398,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening NOK - 74"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1399,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening NOK - 74"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1400,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening NOK - 74"],"content":"  I\/O Expander: TRUE"},{"id":"15225623563","fileName":"15225623563.html","title":"Loosening OK - 70","level":6,"position":1401,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" OK loosening took place.  Name in SoftPLC: LOOSENING_OK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1402,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening OK - 70"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1403,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening OK - 70"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1404,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening OK - 70"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1405,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening OK - 70"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1406,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening OK - 70"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1407,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening OK - 70"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1408,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening OK - 70"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1409,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening OK - 70"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1410,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Loosening OK - 70"],"content":"  I\/O Expander: TRUE"},{"id":"15226951819","fileName":"15226951819.html","title":"Max Consecutive NOK Reached - 35","level":6,"position":1411,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Indicates Max coherent NOK tightening counter is reachead.  Name in SoftPLC: MAX_COHERENT_NOK_REACHED      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1412,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Max Consecutive NOK Reached - 35"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1413,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Max Consecutive NOK Reached - 35"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1414,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Max Consecutive NOK Reached - 35"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1415,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Max Consecutive NOK Reached - 35"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1416,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Max Consecutive NOK Reached - 35"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1417,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Max Consecutive NOK Reached - 35"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1418,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Max Consecutive NOK Reached - 35"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1419,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Max Consecutive NOK Reached - 35"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1420,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Max Consecutive NOK Reached - 35"],"content":"  I\/O Expander: TRUE"},{"id":"15415254411","fileName":"15415254411.html","title":"No System Error - 83","level":6,"position":1421,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Name in SoftPLC: NO_SYSTEM_ERROR      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1422,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","No System Error - 83"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1423,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","No System Error - 83"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1424,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","No System Error - 83"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1425,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","No System Error - 83"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1426,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","No System Error - 83"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1427,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","No System Error - 83"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1428,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","No System Error - 83"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1429,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","No System Error - 83"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1430,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","No System Error - 83"],"content":"  I\/O Expander: TRUE"},{"id":"15415403403","fileName":"15415403403.html","title":"No System Warning - 102","level":6,"position":1431,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Name in SoftPLC: NO_SYSTEM_WARNING      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1432,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","No System Warning - 102"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1433,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","No System Warning - 102"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1434,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","No System Warning - 102"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1435,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","No System Warning - 102"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1436,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","No System Warning - 102"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1437,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","No System Warning - 102"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1438,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","No System Warning - 102"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1439,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","No System Warning - 102"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1440,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","No System Warning - 102"],"content":"  I\/O Expander: TRUE"},{"id":"15226999435","fileName":"15226999435.html","title":"Open Protocol Disconnected - 95","level":6,"position":1441,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" If Open Protocol is set to off in the Virtual Station, \"Open Protocol Disconnected\" signal is set to False. If Open Protocol is turned on in the Virtual Station the \"Open Protocol Disconnected\" signal is set to True. When at least one client (several Open Protocol clients can connect to the same Virtual Station) is connected the \"Open Protocol Disconnected\" signal is set to False.  Name in SoftPLC: OPEN_PROTOCOL_DISCONNECTED      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1442,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Open Protocol Disconnected - 95"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1443,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Open Protocol Disconnected - 95"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1444,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Open Protocol Disconnected - 95"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1445,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Open Protocol Disconnected - 95"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1446,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Open Protocol Disconnected - 95"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1447,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Open Protocol Disconnected - 95"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1448,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Open Protocol Disconnected - 95"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1449,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Open Protocol Disconnected - 95"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1450,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Open Protocol Disconnected - 95"],"content":"  I\/O Expander: TRUE"},{"id":"15227070859","fileName":"15227070859.html","title":"Program Start - 132","level":6,"position":1451,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Defines the starting level for a tightening cycle.  Name in SoftPLC: PROGRAM_START      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1452,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Program Start - 132"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1453,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Program Start - 132"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1454,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Program Start - 132"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1455,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Program Start - 132"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1456,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Program Start - 132"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1457,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Program Start - 132"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1458,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Program Start - 132"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1459,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Program Start - 132"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1460,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Program Start - 132"],"content":"  I\/O Expander: TRUE"},{"id":"15227142283","fileName":"15227142283.html","title":"Read Result Queue Flushed - 30006","level":6,"position":1461,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1462,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Read Result Queue Flushed - 30006"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1463,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Read Result Queue Flushed - 30006"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1464,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Read Result Queue Flushed - 30006"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1465,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Read Result Queue Flushed - 30006"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1466,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Read Result Queue Flushed - 30006"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1467,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Read Result Queue Flushed - 30006"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1468,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Read Result Queue Flushed - 30006"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1469,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Read Result Queue Flushed - 30006"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1470,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Read Result Queue Flushed - 30006"],"content":" I\/O Expander: FALSE"},{"id":"15227166091","fileName":"15227166091.html","title":"Ready to Start - 29","level":6,"position":1471,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" If a tool is connected to the virtual station, there is not any active tightening locks, emergency stop is not activated, and a valid Tightening Program is selected, this signal indicates that it is possible to start a tightening.  Name in SoftPLC: READY_TO_START      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1472,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Ready to Start - 29"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1473,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Ready to Start - 29"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1474,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Ready to Start - 29"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1475,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Ready to Start - 29"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1476,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Ready to Start - 29"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1477,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Ready to Start - 29"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1478,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Ready to Start - 29"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1479,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Ready to Start - 29"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1480,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Ready to Start - 29"],"content":"  I\/O Expander: TRUE"},{"id":"15227189899","fileName":"15227189899.html","title":"Received Identifier 1 - 192","level":6,"position":1481,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Signal corresponding to the first configured string in Source batch-string. Active Identifier String 1 signal is sent in the order the strings\/identifiers are received by the system as soon as a string has been received. If running in forced order scan, it is in the configured order, but if running free order scan, 1 might not correspond to the first configured string, but to the first received string. The strings is the raw received string and not have the \"saved position\" applied. Only sent when running Source batch string.  Name in SoftPLC: RECEIVED_IDENTIFIER_1      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  String  8  800   IdentifierU32Hnw  State  String  8  800   IdentifierU32  State  String  8  800   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1482,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 1 - 192"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1483,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 1 - 192"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1484,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 1 - 192"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1485,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 1 - 192"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1486,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 1 - 192"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1487,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 1 - 192"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1488,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 1 - 192"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1489,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 1 - 192"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1490,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 1 - 192"],"content":" I\/O Expander: FALSE"},{"id":"15285745931","fileName":"15285745931.html","title":"Received Identifier 2 - 193","level":6,"position":1491,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Signal corresponding to the second configured string in Source batch-string. Active Identifier String 2 signal is sent in the order the strings\/identifiers are received by the system as soon as a string has been received. If running in forced order scan, it is in the configured order, but if running free order scan, 2 might not correspond to the second configured string, but to the second received string. The strings is the raw received string and not have the \"saved position\" applied. Only sent when running Source batch string.  Name in SoftPLC: RECEIVED_IDENTIFIER_2      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  String  8  800   IdentifierU32Hnw  State  String  8  800   IdentifierU32  State  String  8  800   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1492,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 2 - 193"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1493,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 2 - 193"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1494,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 2 - 193"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1495,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 2 - 193"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1496,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 2 - 193"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1497,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 2 - 193"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1498,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 2 - 193"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1499,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 2 - 193"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1500,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 2 - 193"],"content":" I\/O Expander: FALSE"},{"id":"15286282123","fileName":"15286282123.html","title":"Received Identifier 3 - 194","level":6,"position":1501,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Signal corresponding to the third configured string in Source batch-string. Active Identifier String 3 signal is sent in the order the strings\/identifiers are received by the system as soon as a string has been received. If running in forced order scan, it is in the configured order, but if running free order scan, 3 might not correspond to the third configured string, but to the third received string. The strings is the raw received string and not have the \"saved position\" applied. Only sent when running Source batch string.  Name in SoftPLC: RECEIVED_IDENTIFIER_3      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  String  8  800   IdentifierU32Hnw  State  String  8  800   IdentifierU32  State  String  8  800   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1502,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 3 - 194"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1503,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 3 - 194"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1504,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 3 - 194"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1505,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 3 - 194"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1506,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 3 - 194"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1507,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 3 - 194"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1508,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 3 - 194"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1509,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 3 - 194"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1510,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 3 - 194"],"content":" I\/O Expander: FALSE"},{"id":"15286306315","fileName":"15286306315.html","title":"Received Identifier 4 - 195","level":6,"position":1511,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Signal corresponding to the fourth configured string in Source batch-string. Active Identifier String 4 signal is sent in the order the strings\/identifiers are received by the system as soon as a string has been received. If running in forced order scan, it is in the configured order, but if running free order scan, 4 might not correspond to the fourth configured string, but to the fourth received string. The strings is the raw received string and not have the \"saved position\" applied. Only sent when running Source batch string.  Name in SoftPLC: RECEIVED_IDENTIFIER_4      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  String  8  800   IdentifierU32Hnw  State  String  8  800   IdentifierU32  State  String  8  800   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1512,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 4 - 195"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1513,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 4 - 195"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1514,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 4 - 195"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1515,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 4 - 195"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1516,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 4 - 195"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1517,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 4 - 195"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1518,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 4 - 195"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1519,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 4 - 195"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1520,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Received Identifier 4 - 195"],"content":" I\/O Expander: FALSE"},{"id":"15227237515","fileName":"15227237515.html","title":"Remaining Batch - 33","level":6,"position":1521,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Remaining tightenings in a batch. Can only be viewed on a display.  Name in SoftPLC: REMAINING_BATCH      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  8   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: TRUE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1522,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Remaining Batch - 33"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1523,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Remaining Batch - 33"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1524,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Remaining Batch - 33"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1525,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Remaining Batch - 33"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1526,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Remaining Batch - 33"],"content":" Tool Functions: FALSE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":1527,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Remaining Batch - 33"],"content":" ST Selector: TRUE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1528,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Remaining Batch - 33"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1529,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Remaining Batch - 33"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1530,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Remaining Batch - 33"],"content":" I\/O Expander: FALSE"},{"id":"15415425547","fileName":"15415425547.html","title":"Selected Mode Id - 72","level":6,"position":1531,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Name in SoftPLC: SELECTED_MODE_ID      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Integer  1  32   TreatZeroAsOne  State  Integer  1  32   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1532,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Mode Id - 72"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1533,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Mode Id - 72"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1534,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Mode Id - 72"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1535,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Mode Id - 72"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1536,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Mode Id - 72"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1537,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Mode Id - 72"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1538,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Mode Id - 72"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1539,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Mode Id - 72"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1540,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Mode Id - 72"],"content":" I\/O Expander: FALSE"},{"id":"15138149771","fileName":"15138149771.html","title":"Selected Sequence Bit 0 - 139","level":6,"position":1541,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Bit pattern showing selected sequence.  Name in SoftPLC: SELECTED_SEQUENCE_BIT_0      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":1542,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 0 - 139"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1543,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 0 - 139"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1544,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 0 - 139"],"content":" Internal I\/O: TRUE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1545,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 0 - 139"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1546,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 0 - 139"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1547,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 0 - 139"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1548,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 0 - 139"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1549,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 0 - 139"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1550,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 0 - 139"],"content":"  I\/O Expander: TRUE"},{"id":"15221259915","fileName":"15221259915.html","title":"Selected Sequence Bit 1 - 140","level":6,"position":1551,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Bit pattern showing selected sequence.  Name in SoftPLC: SELECTED_SEQUENCE_BIT_1      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":1552,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 1 - 140"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1553,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 1 - 140"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1554,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 1 - 140"],"content":" Internal I\/O: TRUE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1555,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 1 - 140"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1556,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 1 - 140"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1557,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 1 - 140"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1558,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 1 - 140"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1559,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 1 - 140"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1560,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 1 - 140"],"content":"  I\/O Expander: TRUE"},{"id":"15219319179","fileName":"15219319179.html","title":"Selected Sequence Bit 2 - 141","level":6,"position":1561,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Bit pattern showing selected sequence.  Name in SoftPLC: SELECTED_SEQUENCE_BIT_2      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":1562,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 2 - 141"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1563,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 2 - 141"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1564,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 2 - 141"],"content":" Internal I\/O: TRUE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1565,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 2 - 141"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1566,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 2 - 141"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1567,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 2 - 141"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1568,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 2 - 141"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1569,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 2 - 141"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1570,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 2 - 141"],"content":"  I\/O Expander: TRUE"},{"id":"15221146635","fileName":"15221146635.html","title":"Selected Sequence Bit 3 - 142","level":6,"position":1571,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Bit pattern showing selected sequence.  Name in SoftPLC: SELECTED_SEQUENCE_BIT_3      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":1572,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 3 - 142"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1573,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 3 - 142"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1574,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 3 - 142"],"content":" Internal I\/O: TRUE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1575,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 3 - 142"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1576,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 3 - 142"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1577,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 3 - 142"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1578,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 3 - 142"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1579,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 3 - 142"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1580,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 3 - 142"],"content":"  I\/O Expander: TRUE"},{"id":"15221169291","fileName":"15221169291.html","title":"Selected Sequence Bit 4 - 143","level":6,"position":1581,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Bit pattern showing selected sequence.  Name in SoftPLC: SELECTED_SEQUENCE_BIT_4      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":1582,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 4 - 143"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1583,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 4 - 143"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1584,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 4 - 143"],"content":" Internal I\/O: TRUE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1585,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 4 - 143"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1586,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 4 - 143"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1587,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 4 - 143"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1588,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 4 - 143"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1589,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 4 - 143"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1590,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 4 - 143"],"content":"  I\/O Expander: TRUE"},{"id":"15221191947","fileName":"15221191947.html","title":"Selected Sequence Bit 5 - 144","level":6,"position":1591,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Bit pattern showing selected sequence.  Name in SoftPLC: SELECTED_SEQUENCE_BIT_5      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":1592,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 5 - 144"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1593,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 5 - 144"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1594,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 5 - 144"],"content":" Internal I\/O: TRUE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1595,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 5 - 144"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1596,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 5 - 144"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1597,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 5 - 144"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1598,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 5 - 144"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1599,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 5 - 144"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1600,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 5 - 144"],"content":"  I\/O Expander: TRUE"},{"id":"15221214603","fileName":"15221214603.html","title":"Selected Sequence Bit 6 - 145","level":6,"position":1601,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Bit pattern showing selected sequence.  Name in SoftPLC: SELECTED_SEQUENCE_BIT_6      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":1602,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 6 - 145"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1603,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 6 - 145"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1604,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 6 - 145"],"content":" Internal I\/O: TRUE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1605,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 6 - 145"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1606,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 6 - 145"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1607,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 6 - 145"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1608,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 6 - 145"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1609,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 6 - 145"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1610,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 6 - 145"],"content":"  I\/O Expander: TRUE"},{"id":"15221237259","fileName":"15221237259.html","title":"Selected Sequence Bit 7 - 146","level":6,"position":1611,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Bit pattern showing selected sequence.  Name in SoftPLC: SELECTED_SEQUENCE_BIT_7      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":1612,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 7 - 146"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1613,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 7 - 146"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1614,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 7 - 146"],"content":" Internal I\/O: TRUE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1615,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 7 - 146"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1616,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 7 - 146"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1617,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 7 - 146"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1618,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 7 - 146"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1619,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 7 - 146"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1620,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 7 - 146"],"content":"  I\/O Expander: TRUE"},{"id":"15221282571","fileName":"15221282571.html","title":"Selected Sequence Bit 8 - 147","level":6,"position":1621,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Bit pattern showing selected sequence.  Name in SoftPLC: SELECTED_SEQUENCE_BIT_8      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":1622,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 8 - 147"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1623,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 8 - 147"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1624,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 8 - 147"],"content":" Internal I\/O: TRUE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1625,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 8 - 147"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1626,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 8 - 147"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1627,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 8 - 147"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1628,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 8 - 147"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1629,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 8 - 147"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1630,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 8 - 147"],"content":"  I\/O Expander: TRUE"},{"id":"15221308299","fileName":"15221308299.html","title":"Selected Sequence Bit 9 - 163","level":6,"position":1631,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Bit pattern showing selected sequence.  Name in SoftPLC: SELECTED_SEQUENCE_BIT_9      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":7,"position":1632,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 9 - 163"],"content":" Fieldbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1633,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 9 - 163"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1634,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 9 - 163"],"content":" Internal I\/O: TRUE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1635,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 9 - 163"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1636,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 9 - 163"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1637,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 9 - 163"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1638,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 9 - 163"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1639,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 9 - 163"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1640,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Bit 9 - 163"],"content":"  I\/O Expander: TRUE"},{"id":"15229278987","fileName":"15229278987.html","title":"Selected Sequence Id - 84","level":6,"position":1641,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Shows the index of the selected batch sequence.  Name in SoftPLC: SELECTED_BATCH_SEQUENCE_ID      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Integer  1  16   TreatZeroAsOne  State  Integer  1  16   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: TRUE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1642,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Id - 84"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1643,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Id - 84"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1644,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Id - 84"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1645,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Id - 84"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1646,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Id - 84"],"content":" Tool Functions: FALSE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":1647,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Id - 84"],"content":" ST Selector: TRUE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1648,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Id - 84"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1649,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Id - 84"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1650,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Selected Sequence Id - 84"],"content":" I\/O Expander: FALSE"},{"id":"15229469067","fileName":"15229469067.html","title":"Sequence Aborted - 160","level":6,"position":1651,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Output signal indicating if sequence was aborted.  Name in SoftPLC: SEQUENCE_ABORTED      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1652,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Sequence Aborted - 160"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1653,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Sequence Aborted - 160"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1654,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Sequence Aborted - 160"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1655,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Sequence Aborted - 160"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1656,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Sequence Aborted - 160"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1657,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Sequence Aborted - 160"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1658,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Sequence Aborted - 160"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1659,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Sequence Aborted - 160"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1660,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Sequence Aborted - 160"],"content":"  I\/O Expander: TRUE"},{"id":"15229321227","fileName":"15229321227.html","title":"Size of Sequence - 181","level":6,"position":1661,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Shows the size of the currently running sequence. Only set when a sequence is loaded and not reset when sequence is done.  Name in SoftPLC: SIZE_OF_RUNNING_SEQUENCE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  8   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: TRUE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1662,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Size of Sequence - 181"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1663,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Size of Sequence - 181"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1664,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Size of Sequence - 181"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1665,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Size of Sequence - 181"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1666,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Size of Sequence - 181"],"content":" Tool Functions: FALSE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":1667,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Size of Sequence - 181"],"content":" ST Selector: TRUE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1668,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Size of Sequence - 181"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1669,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Size of Sequence - 181"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1670,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Size of Sequence - 181"],"content":" I\/O Expander: FALSE"},{"id":"15229342347","fileName":"15229342347.html","title":"Software Major Version - 86","level":6,"position":1671,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Name in SoftPLC: SOFTWARE_MAJOR_VERSION      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  32   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1672,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Major Version - 86"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1673,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Major Version - 86"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1674,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Major Version - 86"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1675,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Major Version - 86"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1676,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Major Version - 86"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1677,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Major Version - 86"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1678,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Major Version - 86"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1679,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Major Version - 86"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1680,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Major Version - 86"],"content":" I\/O Expander: FALSE"},{"id":"15229363467","fileName":"15229363467.html","title":"Software Minor Version - 87","level":6,"position":1681,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Name in SoftPLC: SOFTWARE_MINOR_VERSION      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  32   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1682,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Minor Version - 87"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1683,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Minor Version - 87"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1684,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Minor Version - 87"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1685,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Minor Version - 87"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1686,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Minor Version - 87"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1687,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Minor Version - 87"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1688,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Minor Version - 87"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1689,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Minor Version - 87"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1690,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Minor Version - 87"],"content":" I\/O Expander: FALSE"},{"id":"15229384587","fileName":"15229384587.html","title":"Software Release Version - 85","level":6,"position":1691,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Version of the software running.  Name in SoftPLC: SOFTWARE_RELEASE_VERSION      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  32   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1692,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Release Version - 85"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1693,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Release Version - 85"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1694,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Release Version - 85"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1695,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Release Version - 85"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1696,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Release Version - 85"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1697,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Release Version - 85"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1698,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Release Version - 85"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1699,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Release Version - 85"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1700,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Software Release Version - 85"],"content":" I\/O Expander: FALSE"},{"id":"15227404171","fileName":"15227404171.html","title":"Station Ready - 71","level":6,"position":1701,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Indicates when the Virtual Station is ready.  Name in SoftPLC: STATION_READY      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1702,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Station Ready - 71"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1703,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Station Ready - 71"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1704,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Station Ready - 71"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1705,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Station Ready - 71"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1706,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Station Ready - 71"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1707,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Station Ready - 71"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1708,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Station Ready - 71"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1709,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Station Ready - 71"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1710,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Station Ready - 71"],"content":"  I\/O Expander: TRUE"},{"id":"21001130635","fileName":"21001130635.html","title":"Sync Mode Valid - 207","level":6,"position":1711,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Indicate if selected sync mode is valid or not. That is, if it exists and is configured properly.  Name in SoftPLC: SYNC_MODE_VALID      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1712,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Sync Mode Valid - 207"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1713,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Sync Mode Valid - 207"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1714,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Sync Mode Valid - 207"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1715,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Sync Mode Valid - 207"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1716,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Sync Mode Valid - 207"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1717,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Sync Mode Valid - 207"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1718,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Sync Mode Valid - 207"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1719,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Sync Mode Valid - 207"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1720,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Sync Mode Valid - 207"],"content":"  I\/O Expander: TRUE"},{"id":"15415461643","fileName":"15415461643.html","title":"Test Bolt Activated - 91","level":6,"position":1721,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Name in SoftPLC: SELECTED_MODE_ID      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1722,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Test Bolt Activated - 91"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1723,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Test Bolt Activated - 91"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1724,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Test Bolt Activated - 91"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1725,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Test Bolt Activated - 91"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1726,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Test Bolt Activated - 91"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1727,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Test Bolt Activated - 91"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1728,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Test Bolt Activated - 91"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1729,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Test Bolt Activated - 91"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1730,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Test Bolt Activated - 91"],"content":"  I\/O Expander: TRUE"},{"id":"15227451787","fileName":"15227451787.html","title":"Tightening Disabled - 182","level":6,"position":1731,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Tightening Disabled is an output signal which is activated when the tightening is externally disabled by any of the following signals:  20002 - Lock Tightening  20004 - Lock Tool Active High  20033 - Line Control Lock  20018 - Open Protocol Lock  20020 - Fieldbus Lock Tightening  20040 - Soft PLC Lock Tightening  20061 - Lock Tool Active Low  Name in SoftPLC: TIGHTENING_DISABLED      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1732,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening Disabled - 182"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1733,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening Disabled - 182"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1734,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening Disabled - 182"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1735,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening Disabled - 182"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1736,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening Disabled - 182"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1737,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening Disabled - 182"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1738,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening Disabled - 182"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1739,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening Disabled - 182"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1740,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening Disabled - 182"],"content":"  I\/O Expander: TRUE"},{"id":"15227475595","fileName":"15227475595.html","title":"Tightening Enabled - 183","level":6,"position":1741,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  Tightening Enabled is an output signal which is activated when the tightening is not externally disabled by any of the following signals:  20002 - Lock Tightening  20004 - Lock Tool Active High  20033 - Line Control Lock  20018 - Open Protocol Lock  20020 - Fieldbus Lock Tightening  20040 - Soft PLC Lock Tightening  20061 - Lock Tool Active Low  Name in SoftPLC: TIGHTENING_ENABLED      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1742,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening Enabled - 183"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1743,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening Enabled - 183"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1744,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening Enabled - 183"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1745,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening Enabled - 183"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1746,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening Enabled - 183"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1747,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening Enabled - 183"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1748,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening Enabled - 183"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1749,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening Enabled - 183"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1750,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening Enabled - 183"],"content":"  I\/O Expander: TRUE"},{"id":"15227499403","fileName":"15227499403.html","title":"Tightening is Locked - 27","level":6,"position":1751,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" The tightening is disabled; it is not possible to make any tightening.  Name in SoftPLC: TIGHTENING_IS_LOCKED      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1752,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening is Locked - 27"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1753,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening is Locked - 27"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1754,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening is Locked - 27"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1755,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening is Locked - 27"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1756,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening is Locked - 27"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1757,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening is Locked - 27"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1758,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening is Locked - 27"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1759,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening is Locked - 27"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1760,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening is Locked - 27"],"content":"  I\/O Expander: TRUE"},{"id":"15229532427","fileName":"15229532427.html","title":"Tightening NOK - 4","level":6,"position":1761,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" At least one result of the tightening is outside the specified limits.  Name in SoftPLC: TIGHTENING_NOK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1762,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening NOK - 4"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1763,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening NOK - 4"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1764,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening NOK - 4"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1765,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening NOK - 4"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1766,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening NOK - 4"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1767,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening NOK - 4"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1768,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening NOK - 4"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1769,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening NOK - 4"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1770,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening NOK - 4"],"content":"  I\/O Expander: TRUE"},{"id":"15315317259","fileName":"15315317259.html","title":"Tightening OK - 3","level":6,"position":1771,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" The result of the tightening is within the specified limits.  Name in SoftPLC: TIGHTENING_OK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1772,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening OK - 3"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1773,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening OK - 3"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1774,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening OK - 3"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1775,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening OK - 3"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1776,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening OK - 3"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1777,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening OK - 3"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1778,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening OK - 3"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1779,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening OK - 3"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1780,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tightening OK - 3"],"content":"  I\/O Expander: TRUE"},{"id":"15229194507","fileName":"15229194507.html","title":"Tool Loosening - 22","level":6,"position":1781,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Indicates that the tool is loosening.  Name in SoftPLC: TOOL_LOOSENING      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1782,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Loosening - 22"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1783,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Loosening - 22"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1784,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Loosening - 22"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1785,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Loosening - 22"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1786,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Loosening - 22"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1787,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Loosening - 22"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1788,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Loosening - 22"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1789,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Loosening - 22"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1790,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Loosening - 22"],"content":"  I\/O Expander: TRUE"},{"id":"15229236747","fileName":"15229236747.html","title":"Tool Running - 23","level":6,"position":1791,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Indicates that the tool is rotating (clockwise [CW] or counter-clockwise [CCW]).  Name in SoftPLC: TOOL_RUNNING      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1792,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Running - 23"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1793,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Running - 23"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1794,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Running - 23"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1795,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Running - 23"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1796,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Running - 23"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1797,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Running - 23"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1798,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Running - 23"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1799,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Running - 23"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1800,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Running - 23"],"content":"  I\/O Expander: TRUE"},{"id":"15229257867","fileName":"15229257867.html","title":"Tool Tightening - 21","level":6,"position":1801,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Indicates that the tool is tightening.  Name in SoftPLC: TOOL_TIGHTENING      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1802,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Tightening - 21"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1803,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Tightening - 21"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1804,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Tightening - 21"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1805,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Tightening - 21"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1806,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Tightening - 21"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1807,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Tightening - 21"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1808,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Tightening - 21"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1809,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Tightening - 21"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1810,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tool Tightening - 21"],"content":"  I\/O Expander: TRUE"},{"id":"22259137675","fileName":"22259137675.html","title":"Tools in Zero Position - 210","level":6,"position":1811,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":"  The output signal Tools in Zero Positionis available only for hand-held tool. The output signal Tools in Zero Positiondefines if the tool is in home position - for example, at the end of a forward or backward position step. The signal is not updated in real time, so if the tool for any reason is moved out of position, the signal will not work.  Name in SoftPLC: TOOLS_IN_ZERO_POSITION      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1812,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tools in Zero Position - 210"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1813,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tools in Zero Position - 210"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1814,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tools in Zero Position - 210"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1815,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tools in Zero Position - 210"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1816,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tools in Zero Position - 210"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1817,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tools in Zero Position - 210"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1818,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tools in Zero Position - 210"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1819,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tools in Zero Position - 210"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1820,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Tools in Zero Position - 210"],"content":"  I\/O Expander: TRUE"},{"id":"18269114891","fileName":"18269114891.html","title":"ToolsNet Connection Lost - 133","level":6,"position":1821,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Indicates if enabled connection between ToolsNet and controller got interrupted or is working as expected.  Name in SoftPLC: TOOLSNET_CONNECTION_LOST      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1822,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","ToolsNet Connection Lost - 133"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1823,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","ToolsNet Connection Lost - 133"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1824,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","ToolsNet Connection Lost - 133"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1825,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","ToolsNet Connection Lost - 133"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1826,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","ToolsNet Connection Lost - 133"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1827,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","ToolsNet Connection Lost - 133"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1828,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","ToolsNet Connection Lost - 133"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1829,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","ToolsNet Connection Lost - 133"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1830,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","ToolsNet Connection Lost - 133"],"content":"  I\/O Expander: TRUE"},{"id":"21000319627","fileName":"21000319627.html","title":"ToolsTalk Connection Lost - 208","level":6,"position":1831,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Indicates if enabled connection between ToolsTalk and controller got interrupted or is working as expected.  Name in SoftPLC: TOOLSTALK_CONNECTION_LOST      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: TRUE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1832,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","ToolsTalk Connection Lost - 208"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1833,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","ToolsTalk Connection Lost - 208"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1834,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","ToolsTalk Connection Lost - 208"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1835,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","ToolsTalk Connection Lost - 208"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":1836,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","ToolsTalk Connection Lost - 208"],"content":" Tool Functions: TRUE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":1837,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","ToolsTalk Connection Lost - 208"],"content":" ST Selector: TRUE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1838,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","ToolsTalk Connection Lost - 208"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":1839,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","ToolsTalk Connection Lost - 208"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1840,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","ToolsTalk Connection Lost - 208"],"content":"  I\/O Expander: TRUE"},{"id":"20973171979","fileName":"20973171979.html","title":"Total Remaining Sequence Counter - 205","level":6,"position":1841,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" The amount of remaining tightenings to be completed in a batch sequence.  Name in SoftPLC: TOTAL_REMAINING_SEQ_COUNT      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  16   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: TRUE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1842,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Remaining Sequence Counter - 205"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1843,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Remaining Sequence Counter - 205"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1844,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Remaining Sequence Counter - 205"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1845,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Remaining Sequence Counter - 205"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1846,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Remaining Sequence Counter - 205"],"content":" Tool Functions: FALSE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":1847,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Remaining Sequence Counter - 205"],"content":" ST Selector: TRUE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1848,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Remaining Sequence Counter - 205"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1849,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Remaining Sequence Counter - 205"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1850,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Remaining Sequence Counter - 205"],"content":" I\/O Expander: FALSE"},{"id":"20973170059","fileName":"20973170059.html","title":"Total Sequence Counter - 204","level":6,"position":1851,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" The amount of completed tightenings in a batch sequence.  Name in SoftPLC: TOTAL_SEQ_COUNTER      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  16   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: TRUE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1852,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Sequence Counter - 204"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1853,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Sequence Counter - 204"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1854,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Sequence Counter - 204"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1855,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Sequence Counter - 204"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1856,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Sequence Counter - 204"],"content":" Tool Functions: FALSE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":1857,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Sequence Counter - 204"],"content":" ST Selector: TRUE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1858,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Sequence Counter - 204"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1859,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Sequence Counter - 204"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1860,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Sequence Counter - 204"],"content":" I\/O Expander: FALSE"},{"id":"20973167115","fileName":"20973167115.html","title":"Total Sequence Size - 203","level":6,"position":1861,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" The total amount of tightenings to be completed in a batch sequence.  Name in SoftPLC: TOTAL_SEQ_SIZE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  16   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  I\/O Expander: FALSE  Operator Panel: FALSE  ST Selector: TRUE  Stacklight: FALSE  Tool Functions: FALSE  TLS Tag: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1862,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Sequence Size - 203"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1863,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Sequence Size - 203"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":1864,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Sequence Size - 203"],"content":" Internal I\/O: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":1865,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Sequence Size - 203"],"content":" I\/O Expander: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":1866,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Sequence Size - 203"],"content":" Operator Panel: FALSE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":1867,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Sequence Size - 203"],"content":" ST Selector: TRUE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":1868,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Sequence Size - 203"],"content":" Stacklight: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1869,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Sequence Size - 203"],"content":" Tool Functions: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1870,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Total Sequence Size - 203"],"content":" TLS Tag: FALSE"},{"id":"19292537611","fileName":"19292537611.html","title":"Waiting To Continue - 201","level":6,"position":1871,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals"],"content":" Waiting To Continue is an output signal, which means that the tightening has reached a Waittightening step with the condition Signalconfigured as Wait Type. The system (one or more spindles) pauses the tightening waiting for the signalContinue Step - 10128(for system release) or the sub-signalChannel Command - 10054: Continue Step(for individual spindle release). For more information, see the sub-signalsBolt Tightening Status - 79: Waiting To ContinueandChannel Tightening Status - 80: Waiting To Continue.  Name in SoftPLC: WAITING_FOR_CONTINUE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1872,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Waiting To Continue - 201"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":1873,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Waiting To Continue - 201"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1874,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Waiting To Continue - 201"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1875,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Waiting To Continue - 201"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1876,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Waiting To Continue - 201"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":1877,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Waiting To Continue - 201"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":1878,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Waiting To Continue - 201"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":1879,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Waiting To Continue - 201"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":1880,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Output Signals","Waiting To Continue - 201"],"content":"  I\/O Expander: TRUE"},{"id":"18266031371","fileName":"1826603137128074166411.html","title":"Input\/Output Signals","level":5,"position":1881,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals"],"content":"      Signal  Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]  Devices     title   item   item   item   none   none   subnodes "},{"id":"15110494091","fileName":"15110494091.html","title":"Clear Results - 39","level":6,"position":1882,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input\/Output Signals"],"content":" Clears status of other signals set to next tightening.  Name in SoftPLC: CLEAR_RESULTS      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":1883,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input\/Output Signals","Clear Results - 39"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":1884,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input\/Output Signals","Clear Results - 39"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":1885,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input\/Output Signals","Clear Results - 39"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":1886,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input\/Output Signals","Clear Results - 39"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":1887,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Synchronized tightening","Synchronized Tightening Signals","Input\/Output Signals","Cl