﻿tableData = {"title":"Event Codes","type":"default","columns":[{"name":"event-code","data":{"_":"event-code.htmlContent","sort":"event-code.content"},"render":"[<br\/>]","type":"none","title":"Event Code","defaultContent":"","filterType":"multiple","lexiconLink":{"title":"Event code","content":"The unique event number.","href":"27991821835.html#15567259915","lexiconTitle":"Glossary"}},{"name":"event-type","data":{"_":"event-type.htmlContent","sort":"event-type.content"},"render":"[<br\/>]","type":"item","title":"Event Type","defaultContent":"","filterType":"multiple","lexiconLink":{"title":"Type of events - Event Codes list","content":"Type of event: Info, Warning, and Error.","href":"27991821835.html#12891777419","lexiconTitle":"Glossary"}},{"name":"event-name","data":{"_":"event-name.htmlContent","sort":"event-name.content"},"render":"[<br\/>]","type":"none","title":"Event Name","defaultContent":"","filterType":"multiple","lexiconLink":{"title":"Event name","content":"A descriptive name of the event.","href":"27991821835.html#15572875403","lexiconTitle":"Glossary"}},{"name":"description","data":{"_":"description.htmlContent","sort":"description.content"},"render":"[<br\/>]","type":"none","title":"Description","defaultContent":"","filterType":"multiple","lexiconLink":{"title":"Event Description","content":"A short description of the event and why it occurs.","href":"27991821835.html#15567665291","lexiconTitle":"Glossary"}},{"name":"procedure","data":{"_":"procedure.htmlContent","sort":"procedure.content"},"render":"[<br\/>]","type":"none","title":"Procedure","defaultContent":"","filterType":"multiple","lexiconLink":{"title":"Procedure - Event Codes list","content":"If applicable, the procedure contains an instruction on how to clear the event.","href":"27991821835.html#19197888651","lexiconTitle":"Glossary"}},{"name":"log-display-ack-conf","data":{"_":"log-display-ack-conf.htmlContent","sort":"log-display-ack-conf.content"},"render":"[, ]","type":"column","title":"Log \/ Display \/ Ack \/ Conf","defaultContent":"","filterType":"multiple"},{"name":"available-for","data":{"_":"available-for.htmlContent","sort":"available-for.content"},"render":"[, ]","type":"list","title":"Available for","defaultContent":"","filterType":"multiple","lexiconLink":{"title":"Available for - Event Codes list","content":"List of products for which the event code is available.","href":"27991821835.html#19521829899","lexiconTitle":"Glossary"}},{"name":"group","data":{"_":"group.htmlContent","sort":"group.content"},"render":"[, ]","type":"list","title":"Group","defaultContent":"","filterType":"multiple","lexiconLink":{"title":"Groups - Event Codes list","content":"Group which the event codes belong to.","href":"27991821835.html#19525353483","lexiconTitle":"Glossary"}}],"items":[{"id":"64568843-1","title":"Event Codes","event-code":{"content":["1000"],"htmlContent":["1000"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Controller Started"],"htmlContent":["Controller Started"],"lexiconLinks":[]},"description":{"content":["The controller is started."],"htmlContent":["The controller is started."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Conf"],"htmlContent":["Log","Conf"],"lexiconLinks":[{"title":"Log - Event Codes list","content":"Tells the user whether the event is to be saved in the event log or not. The value in this list is the default value.","href":"27991821835.html#15568240779","lexiconTitle":"Glossary","linkText":"Log"},{"title":"Conf - Event Codes list","content":"Tells the user whether it is possible to configure the event through the \"Configure Event\" page.","href":"27991821835.html#19521822475","lexiconTitle":"Glossary","linkText":"Conf"}]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller and Tool"],"htmlContent":["Controller and Tool"],"lexiconLinks":[]}},{"id":"64568843-2","title":"Event Codes","event-code":{"content":["1001"],"htmlContent":["1001"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Controller Serial Number Updated"],"htmlContent":["Controller Serial Number Updated"],"lexiconLinks":[]},"description":{"content":["Generated at start-up if IT-board box serial number (controller serial number) differs from AUX-board box serial number. AUX-board is considered to be non-replaceable in field. The controller will reboot when the serial number is updated."],"htmlContent":["Generated at start-up if IT-board box serial number (controller serial number) differs from AUX-board box serial number. AUX-board is considered to be non-replaceable in field. The controller will reboot when the serial number is updated."],"lexiconLinks":[]},"procedure":{"content":["Replace IT-board or box."],"htmlContent":["Replace IT-board or box."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[{"title":"display - Event Codes list","content":"Tells the user whether the event is to be displayed on the screen or not. The value in this list is the default value.","href":"27991821835.html#15567842059","lexiconTitle":"Glossary","linkText":"Display"},{"title":"Ack - Event Codes list","content":"Tells the user whether the event must be acknowledged or not before you can proceed. The value in this list is the default value.","href":"27991821835.html#15566208395","lexiconTitle":"Glossary","linkText":"Ack"}]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"htmlContent":["Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller and Tool"],"htmlContent":["Controller and Tool"],"lexiconLinks":[]}},{"id":"64568843-3","title":"Event Codes","event-code":{"content":["1010"],"htmlContent":["1010"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tool Connected"],"htmlContent":["Tool Connected"],"lexiconLinks":[]},"description":{"content":["A tool is connected."],"htmlContent":["A tool is connected."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller and Tool"],"htmlContent":["Controller and Tool"],"lexiconLinks":[]}},{"id":"64568843-4","title":"Event Codes","event-code":{"content":["1011"],"htmlContent":["1011"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tool Disconnected"],"htmlContent":["Tool Disconnected"],"lexiconLinks":[]},"description":{"content":["A tool is disconnected."],"htmlContent":["A tool is disconnected."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller and Tool"],"htmlContent":["Controller and Tool"],"lexiconLinks":[]}},{"id":"64568843-5","title":"Event Codes","event-code":{"content":["1012"],"htmlContent":["1012"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tool Rejected Controller Connection"],"htmlContent":["Tool Rejected Controller Connection"],"lexiconLinks":[]},"description":{"content":["This event can occur if the tool is into a skip-zone."],"htmlContent":["This event can occur if the tool is into a skip-zone."],"lexiconLinks":[]},"procedure":{"content":["Verify if another controller is connected to the tool.","Make sure that the tool settings are correctly set up."],"htmlContent":["Verify if another controller is connected to the tool.","Make sure that the tool settings are correctly set up."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller and Tool"],"htmlContent":["Controller and Tool"],"lexiconLinks":[]}},{"id":"64568843-6","title":"Event Codes","event-code":{"content":["2000"],"htmlContent":["2000"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Battery Low"],"htmlContent":["Battery Low"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Replace battery."],"htmlContent":["Replace battery."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","XB"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","XB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-7","title":"Event Codes","event-code":{"content":["2001"],"htmlContent":["2001"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Battery Empty"],"htmlContent":["Battery Empty"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Replace battery."],"htmlContent":["Replace battery."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-8","title":"Event Codes","event-code":{"content":["2002"],"htmlContent":["2002"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Battery Health Low"],"htmlContent":["Tool Battery Health Low"],"lexiconLinks":[]},"description":{"content":["Tool battery health problem is detected. Valid for SRB, TBP and IxB tools only."],"htmlContent":["Tool battery health problem is detected. Valid for SRB, TBP and IxB tools only."],"lexiconLinks":[]},"procedure":{"content":["Replace battery."],"htmlContent":["Replace battery."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-9","title":"Event Codes","event-code":{"content":["2004"],"htmlContent":["2004"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool is not of the preferred type"],"htmlContent":["Tool is not of the preferred type"],"lexiconLinks":[]},"description":{"content":["Tool has been replaced by a tool with a different Tool Max Torque."],"htmlContent":["Tool has been replaced by a tool with a different Tool Max Torque."],"lexiconLinks":[]},"procedure":{"content":["Change tool."],"htmlContent":["Change tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-10","title":"Event Codes","event-code":{"content":["2006"],"htmlContent":["2006"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Backup Battery Health low"],"htmlContent":["Tool Backup Battery Health low"],"lexiconLinks":[]},"description":{"content":["The backup battery in the tool has too poor performance."],"htmlContent":["The backup battery in the tool has too poor performance."],"lexiconLinks":[]},"procedure":{"content":["The backup battery should be replaced."],"htmlContent":["The backup battery should be replaced."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-11","title":"Event Codes","event-code":{"content":["2007"],"htmlContent":["2007"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Backup Battery Missing or Broken"],"htmlContent":["Tool Backup Battery Missing or Broken"],"lexiconLinks":[]},"description":{"content":["Tool backup battery is missing or broken.Valid for SRB and TBP tools only."],"htmlContent":["Tool backup battery is missing or broken.Valid for SRB and TBP tools only."],"lexiconLinks":[]},"procedure":{"content":["Insert battery."],"htmlContent":["Insert battery."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-12","title":"Event Codes","event-code":{"content":["2008"],"htmlContent":["2008"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Backup Battery Error"],"htmlContent":["Tool Backup Battery Error"],"lexiconLinks":[]},"description":{"content":["Tool backup battery error detected. Valid for SRB and TBP tools only."],"htmlContent":["Tool backup battery error detected. Valid for SRB and TBP tools only."],"lexiconLinks":[]},"procedure":{"content":["Replace battery."],"htmlContent":["Replace battery."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-13","title":"Event Codes","event-code":{"content":["2009"],"htmlContent":["2009"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Backup Battery Voltage Low"],"htmlContent":["Backup Battery Voltage Low"],"lexiconLinks":[]},"description":{"content":["The controller's backup battery is almost empty."],"htmlContent":["The controller's backup battery is almost empty."],"lexiconLinks":[]},"procedure":{"content":["Replace battery."],"htmlContent":["Replace battery."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-14","title":"Event Codes","event-code":{"content":["2010"],"htmlContent":["2010"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Software Version Mismatch"],"htmlContent":["Tool Software Version Mismatch"],"lexiconLinks":[]},"description":{"content":["Tool and controller software versions not compatible."],"htmlContent":["Tool and controller software versions not compatible."],"lexiconLinks":[]},"procedure":{"content":["Service tool - update tool software."],"htmlContent":["Service tool - update tool software."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-15","title":"Event Codes","event-code":{"content":["2012"],"htmlContent":["2012"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Communication Disturbance"],"htmlContent":["Tool Communication Disturbance"],"lexiconLinks":[]},"description":{"content":["Communication between tool and controller interrupted."],"htmlContent":["Communication between tool and controller interrupted."],"lexiconLinks":[]},"procedure":{"content":["Relocate antenna placement."],"htmlContent":["Relocate antenna placement."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-16","title":"Event Codes","event-code":{"content":["2013"],"htmlContent":["2013"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Illegal Ring Position"],"htmlContent":["Illegal Ring Position"],"lexiconLinks":[]},"description":{"content":["Tool direction switch in faulty position."],"htmlContent":["Tool direction switch in faulty position."],"lexiconLinks":[]},"procedure":{"content":["If occurring frequently - service the tool."],"htmlContent":["If occurring frequently - service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-17","title":"Event Codes","event-code":{"content":["2014"],"htmlContent":["2014"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Overheated"],"htmlContent":["Tool Overheated"],"lexiconLinks":[]},"description":{"content":["Tool overheated. Valid for SRB, TBP and IxB tools only."],"htmlContent":["Tool overheated. Valid for SRB, TBP and IxB tools only."],"lexiconLinks":[]},"procedure":{"content":["Allow tool to cool down."],"htmlContent":["Allow tool to cool down."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl","XB"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl","XB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-18","title":"Event Codes","event-code":{"content":["2015"],"htmlContent":["2015"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Temperature Sensor Error"],"htmlContent":["Tool Temperature Sensor Error"],"lexiconLinks":[]},"description":{"content":["SRB, TBP and IxB tools only."],"htmlContent":["SRB, TBP and IxB tools only."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-19","title":"Event Codes","event-code":{"content":["2016"],"htmlContent":["2016"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Pulse Unit Overheated"],"htmlContent":["Tool Pulse Unit Overheated"],"lexiconLinks":[]},"description":{"content":["Pulse unit overheated. Tool is not locked, but the warning is displayed whenever the tool is started as long as the pulse unit temperature is over threshold. Valid for SRB, TBP and IxB tools only."],"htmlContent":["Pulse unit overheated. Tool is not locked, but the warning is displayed whenever the tool is started as long as the pulse unit temperature is over threshold. Valid for SRB, TBP and IxB tools only."],"lexiconLinks":[]},"procedure":{"content":["Allow tool to cool down."],"htmlContent":["Allow tool to cool down."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-20","title":"Event Codes","event-code":{"content":["2019"],"htmlContent":["2019"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Could not Start Motor"],"htmlContent":["Tool Could not Start Motor"],"lexiconLinks":[]},"description":{"content":["Tool motor failure. Valid for SRB, TBP and IxB tools only."],"htmlContent":["Tool motor failure. Valid for SRB, TBP and IxB tools only."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-21","title":"Event Codes","event-code":{"content":["2020"],"htmlContent":["2020"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Requires Motor Tuning"],"htmlContent":["Tool Requires Motor Tuning"],"lexiconLinks":[]},"description":{"content":["Tool requires motor tuning."],"htmlContent":["Tool requires motor tuning."],"lexiconLinks":[]},"procedure":{"content":["Perform a motor tuning."],"htmlContent":["Perform a motor tuning."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl","XB"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl","XB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-22","title":"Event Codes","event-code":{"content":["2021"],"htmlContent":["2021"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Motor Tuning Failed"],"htmlContent":["Motor Tuning Failed"],"lexiconLinks":[]},"description":{"content":["Motor tuning failed."],"htmlContent":["Motor tuning failed."],"lexiconLinks":[]},"procedure":{"content":["Complete motor tuning or service the tool."],"htmlContent":["Complete motor tuning or service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log"],"htmlContent":["Log"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-23","title":"Event Codes","event-code":{"content":["2022"],"htmlContent":["2022"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Motor Tuning Completed"],"htmlContent":["Motor Tuning Completed"],"lexiconLinks":[]},"description":{"content":["Motor tuning completed."],"htmlContent":["Motor tuning completed."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Conf"],"htmlContent":["Log","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-24","title":"Event Codes","event-code":{"content":["2023"],"htmlContent":["2023"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["The Tool Requires Open End Tuning"],"htmlContent":["The Tool Requires Open End Tuning"],"lexiconLinks":[]},"description":{"content":["The tool requires open end tuning."],"htmlContent":["The tool requires open end tuning."],"lexiconLinks":[]},"procedure":{"content":["Perform open end tuning."],"htmlContent":["Perform open end tuning."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-25","title":"Event Codes","event-code":{"content":["2024"],"htmlContent":["2024"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Open End Tuning Failed"],"htmlContent":["Open End Tuning Failed"],"lexiconLinks":[]},"description":{"content":["Open end tuning failed."],"htmlContent":["Open end tuning failed."],"lexiconLinks":[]},"procedure":{"content":["Try to perform open end tuning one more time. If it fails again, service the tool."],"htmlContent":["Try to perform open end tuning one more time. If it fails again, service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Conf"],"htmlContent":["Log","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-26","title":"Event Codes","event-code":{"content":["2025"],"htmlContent":["2025"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Open End Tuning Successful"],"htmlContent":["Open End Tuning Successful"],"lexiconLinks":[]},"description":{"content":["Open end tuning successful."],"htmlContent":["Open end tuning successful."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Conf"],"htmlContent":["Log","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-27","title":"Event Codes","event-code":{"content":["2026"],"htmlContent":["2026"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Open End Position Failed"],"htmlContent":["Open End Position Failed"],"lexiconLinks":[]},"description":{"content":["Open end position failed."],"htmlContent":["Open end position failed."],"lexiconLinks":[]},"procedure":{"content":["Press the tool trigger again and wait for the positioning to be completed. If it fails again, service the tool."],"htmlContent":["Press the tool trigger again and wait for the positioning to be completed. If it fails again, service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-28","title":"Event Codes","event-code":{"content":["2027"],"htmlContent":["2027"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Usage Limited Due To High Tool Temperature"],"htmlContent":["Usage Limited Due To High Tool Temperature"],"lexiconLinks":[]},"description":{"content":["Temperature limit value has been reached. Tightening has been inhibited to reduce risk for tool shutting down due to overheating."],"htmlContent":["Temperature limit value has been reached. Tightening has been inhibited to reduce risk for tool shutting down due to overheating."],"lexiconLinks":[]},"procedure":{"content":["Wait until tool temperature has been reduced."],"htmlContent":["Wait until tool temperature has been reduced."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl","XB"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl","XB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-29","title":"Event Codes","event-code":{"content":["2030"],"htmlContent":["2030"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Memory Failure: Change Tool"],"htmlContent":["Tool Memory Failure: Change Tool"],"lexiconLinks":[]},"description":{"content":["Tool memory corrupt."],"htmlContent":["Tool memory corrupt."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-30","title":"Event Codes","event-code":{"content":["2031"],"htmlContent":["2031"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Accessory Memory Corrupt"],"htmlContent":["Tool Accessory Memory Corrupt"],"lexiconLinks":[]},"description":{"content":["Tool accessory memory corrupt."],"htmlContent":["Tool accessory memory corrupt."],"lexiconLinks":[]},"procedure":{"content":["Service the tool accessory."],"htmlContent":["Service the tool accessory."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-31","title":"Event Codes","event-code":{"content":["2040"],"htmlContent":["2040"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["System Check Failure"],"htmlContent":["System Check Failure"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl","XB"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl","XB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-32","title":"Event Codes","event-code":{"content":["2041"],"htmlContent":["2041"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Torque Transducer Error"],"htmlContent":["Torque Transducer Error"],"lexiconLinks":[]},"description":{"content":["Will be generated either on calibration error or if tool reports transducer error."],"htmlContent":["Will be generated either on calibration error or if tool reports transducer error."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-33","title":"Event Codes","event-code":{"content":["2042"],"htmlContent":["2042"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Angle Transducer Error"],"htmlContent":["Angle Transducer Error"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-34","title":"Event Codes","event-code":{"content":["2043"],"htmlContent":["2043"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Ground Fault Error"],"htmlContent":["Tool Ground Fault Error"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-35","title":"Event Codes","event-code":{"content":["2044"],"htmlContent":["2044"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tool Service Interval Expired"],"htmlContent":["Tool Service Interval Expired"],"lexiconLinks":[]},"description":{"content":["Indicates that servicing of the tool is needed. Triggered when the number of set tightenings has been exceeded."],"htmlContent":["Indicates that servicing of the tool is needed. Triggered when the number of set tightenings has been exceeded."],"lexiconLinks":[]},"procedure":{"content":["Perform service of tool."],"htmlContent":["Perform service of tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-36","title":"Event Codes","event-code":{"content":["2045"],"htmlContent":["2045"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Calibration Data Invalid"],"htmlContent":["Tool Calibration Data Invalid"],"lexiconLinks":[]},"description":{"content":["If validation of calibration data fails."],"htmlContent":["If validation of calibration data fails."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl","XB"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl","XB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-37","title":"Event Codes","event-code":{"content":["2046"],"htmlContent":["2046"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tool: Next Calibration Date Has Passed"],"htmlContent":["Tool: Next Calibration Date Has Passed"],"lexiconLinks":[]},"description":{"content":["Indicates that calibration of tool is needed. Triggered when calibration alarm is enabled in settings and the current time is greater than next calibration date."],"htmlContent":["Indicates that calibration of tool is needed. Triggered when calibration alarm is enabled in settings and the current time is greater than next calibration date."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-38","title":"Event Codes","event-code":{"content":["2048"],"htmlContent":["2048"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tool Calibration Value Updated By QA Device"],"htmlContent":["Tool Calibration Value Updated By QA Device"],"lexiconLinks":[]},"description":{"content":["Tool calibration was updated when a calibration with a QA device was performed."],"htmlContent":["Tool calibration was updated when a calibration with a QA device was performed."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-39","title":"Event Codes","event-code":{"content":["2050"],"htmlContent":["2050"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Parameter File Not Supported"],"htmlContent":["Tool Parameter File Not Supported"],"lexiconLinks":[]},"description":{"content":["Required tool parameters are missing."],"htmlContent":["Required tool parameters are missing."],"lexiconLinks":[]},"procedure":{"content":["Update tool parameters."],"htmlContent":["Update tool parameters."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-40","title":"Event Codes","event-code":{"content":["2060"],"htmlContent":["2060"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Unexpected Trigger Behavior"],"htmlContent":["Unexpected Trigger Behavior"],"lexiconLinks":[]},"description":{"content":["Used to prevent start of tool if accessory is connected."],"htmlContent":["Used to prevent start of tool if accessory is connected."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-41","title":"Event Codes","event-code":{"content":["2071"],"htmlContent":["2071"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Memory Corrupt"],"htmlContent":["Tool Memory Corrupt"],"lexiconLinks":[]},"description":{"content":["Tool descriptor is corrupt."],"htmlContent":["Tool descriptor is corrupt."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-42","title":"Event Codes","event-code":{"content":["2072"],"htmlContent":["2072"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Unknown Device Connected"],"htmlContent":["Unknown Device Connected"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-43","title":"Event Codes","event-code":{"content":["2073"],"htmlContent":["2073"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Trigger Supervision Failure"],"htmlContent":["Tool Trigger Supervision Failure"],"lexiconLinks":[]},"description":{"content":["HW channel failure. Mismatch between hardware and software of tool trigger."],"htmlContent":["HW channel failure. Mismatch between hardware and software of tool trigger."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-44","title":"Event Codes","event-code":{"content":["2074"],"htmlContent":["2074"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Indicator Board Failure"],"htmlContent":["Tool Indicator Board Failure"],"lexiconLinks":[]},"description":{"content":["Tool indicator board failure."],"htmlContent":["Tool indicator board failure."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-45","title":"Event Codes","event-code":{"content":["2075"],"htmlContent":["2075"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Fan Voltage Failure"],"htmlContent":["Tool Fan Voltage Failure"],"lexiconLinks":[]},"description":{"content":["Tool fan voltage failure."],"htmlContent":["Tool fan voltage failure."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-46","title":"Event Codes","event-code":{"content":["2076"],"htmlContent":["2076"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Accessory Bus Voltage Failure"],"htmlContent":["Tool Accessory Bus Voltage Failure"],"lexiconLinks":[]},"description":{"content":["Tool accessory bus voltage failure."],"htmlContent":["Tool accessory bus voltage failure."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-47","title":"Event Codes","event-code":{"content":["2077"],"htmlContent":["2077"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Trigger Sensor Error"],"htmlContent":["Tool Trigger Sensor Error"],"lexiconLinks":[]},"description":{"content":["Tool trigger sensor error."],"htmlContent":["Tool trigger sensor error."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-48","title":"Event Codes","event-code":{"content":["2078"],"htmlContent":["2078"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tool Tightening Program Updated"],"htmlContent":["Tool Tightening Program Updated"],"lexiconLinks":[]},"description":{"content":["Tool locked due to tightening program update. "],"htmlContent":["Tool locked due to tightening program update. "],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-49","title":"Event Codes","event-code":{"content":["2079"],"htmlContent":["2079"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Cable Not Supported"],"htmlContent":["Tool Cable Not Supported"],"lexiconLinks":[]},"description":{"content":["Tool cable is corrupt. The chip in the cable is not responding or is damaged."],"htmlContent":["Tool cable is corrupt. The chip in the cable is not responding or is damaged."],"lexiconLinks":[]},"procedure":{"content":["Switch cable."],"htmlContent":["Switch cable."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-50","title":"Event Codes","event-code":{"content":["2080"],"htmlContent":["2080"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Battery Failure"],"htmlContent":["Tool Battery Failure"],"lexiconLinks":[]},"description":{"content":["DC voltage too high or too low. Battery failure."],"htmlContent":["DC voltage too high or too low. Battery failure."],"lexiconLinks":[]},"procedure":{"content":["Contact the Atlas Copco service representative and send back battery to Atlas Copco (do not reuse it!)."],"htmlContent":["Contact the Atlas Copco service representative and send back battery to Atlas Copco (do not reuse it!)."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","XB"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","XB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-51","title":"Event Codes","event-code":{"content":["2081"],"htmlContent":["2081"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Current Limit Reached"],"htmlContent":["Tool Current Limit Reached"],"lexiconLinks":[]},"description":{"content":["The current limit value has been reached and the drive is disabled."],"htmlContent":["The current limit value has been reached and the drive is disabled."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-52","title":"Event Codes","event-code":{"content":["2082"],"htmlContent":["2082"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Current Measurement Error"],"htmlContent":["Tool Current Measurement Error"],"lexiconLinks":[]},"description":{"content":["Current measurement error. Current cannot be measured with a reliable result."],"htmlContent":["Current measurement error. Current cannot be measured with a reliable result."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","XB"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","XB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-53","title":"Event Codes","event-code":{"content":["2083"],"htmlContent":["2083"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Internal Error"],"htmlContent":["Tool Internal Error"],"lexiconLinks":[]},"description":{"content":["Various internal hardware errors. Valid for STB and IxB tools only."],"htmlContent":["Various internal hardware errors. Valid for STB and IxB tools only."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","XB"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","XB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-54","title":"Event Codes","event-code":{"content":["2084"],"htmlContent":["2084"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Internal Software Error"],"htmlContent":["Tool Internal Software Error"],"lexiconLinks":[]},"description":{"content":["Various internal software errors. Valid for STB and IxB tools only."],"htmlContent":["Various internal software errors. Valid for STB and IxB tools only."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","XB"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","XB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-55","title":"Event Codes","event-code":{"content":["2085"],"htmlContent":["2085"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool RBU Error"],"htmlContent":["Tool RBU Error"],"lexiconLinks":[]},"description":{"content":["An RBU error was detected by the tool software."],"htmlContent":["An RBU error was detected by the tool software."],"lexiconLinks":[]},"procedure":{"content":["Check that the RBU is correctly installed. If error is still present then service the tool."],"htmlContent":["Check that the RBU is correctly installed. If error is still present then service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-56","title":"Event Codes","event-code":{"content":["2086"],"htmlContent":["2086"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Stall"],"htmlContent":["Tool Stall"],"lexiconLinks":[]},"description":{"content":["Tool motor is stalling."],"htmlContent":["Tool motor is stalling."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","XB"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","XB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-57","title":"Event Codes","event-code":{"content":["2087"],"htmlContent":["2087"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Motor Current High"],"htmlContent":["Tool Motor Current High"],"lexiconLinks":[]},"description":{"content":["Tool motor current limit value is exceeded, and the tool is locked. Tool will enter failsafe mode. Valid for SRB, TBP and IxB tools only."],"htmlContent":["Tool motor current limit value is exceeded, and the tool is locked. Tool will enter failsafe mode. Valid for SRB, TBP and IxB tools only."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","XB"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","XB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-58","title":"Event Codes","event-code":{"content":["2088"],"htmlContent":["2088"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Battery Current High"],"htmlContent":["Tool Battery Current High"],"lexiconLinks":[]},"description":{"content":["Tool battery current is too high. Valid for SRB, TBP and IxB tools only."],"htmlContent":["Tool battery current is too high. Valid for SRB, TBP and IxB tools only."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","XB"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","XB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-59","title":"Event Codes","event-code":{"content":["2089"],"htmlContent":["2089"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Drive Voltage Low"],"htmlContent":["Tool Drive Voltage Low"],"lexiconLinks":[]},"description":{"content":["Tool drive voltage is below the monitored lower voltage limit value. Valid for SRB, TBP and IxB tools only."],"htmlContent":["Tool drive voltage is below the monitored lower voltage limit value. Valid for SRB, TBP and IxB tools only."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-60","title":"Event Codes","event-code":{"content":["2090"],"htmlContent":["2090"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Drive Voltage High"],"htmlContent":["Tool Drive Voltage High"],"lexiconLinks":[]},"description":{"content":["Tool drive voltage is above monitored higher voltage limit value. Valid for SRB, TBP and IxB tools only."],"htmlContent":["Tool drive voltage is above monitored higher voltage limit value. Valid for SRB, TBP and IxB tools only."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-61","title":"Event Codes","event-code":{"content":["2091"],"htmlContent":["2091"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Main Board Error"],"htmlContent":["Tool Main Board Error"],"lexiconLinks":[]},"description":{"content":["Tool main board internal error. Valid for SRB, TBP and IxB tools only."],"htmlContent":["Tool main board internal error. Valid for SRB, TBP and IxB tools only."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","XB"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","XB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-62","title":"Event Codes","event-code":{"content":["2092"],"htmlContent":["2092"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Power Module Error"],"htmlContent":["Tool Power Module Error"],"lexiconLinks":[]},"description":{"content":["Tool power module internal error. Valid for SRB, TBP and IxB tools only."],"htmlContent":["Tool power module internal error. Valid for SRB, TBP and IxB tools only."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-63","title":"Event Codes","event-code":{"content":["2093"],"htmlContent":["2093"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Pulse Unit Oil Level Low"],"htmlContent":["Pulse Unit Oil Level Low"],"lexiconLinks":[]},"description":{"content":["The oil level of the connected pulse tool is low."],"htmlContent":["The oil level of the connected pulse tool is low."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-64","title":"Event Codes","event-code":{"content":["2094"],"htmlContent":["2094"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Pulse Unit Oil Level Empty"],"htmlContent":["Pulse Unit Oil Level Empty"],"lexiconLinks":[]},"description":{"content":["The oil level of the connected pulse tool is below required operational level."],"htmlContent":["The oil level of the connected pulse tool is below required operational level."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-65","title":"Event Codes","event-code":{"content":["2095"],"htmlContent":["2095"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Battery Communication Lost"],"htmlContent":["Tool Battery Communication Lost"],"lexiconLinks":[]},"description":{"content":["Tool lost communication with battery. Valid for SRB, TBP and IxB tools only."],"htmlContent":["Tool lost communication with battery. Valid for SRB, TBP and IxB tools only."],"lexiconLinks":[]},"procedure":{"content":["Make sure battery is snugged correctly. Otherwise change battery."],"htmlContent":["Make sure battery is snugged correctly. Otherwise change battery."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-66","title":"Event Codes","event-code":{"content":["2096"],"htmlContent":["2096"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Battery Software Version Mismatch"],"htmlContent":["Tool Battery Software Version Mismatch"],"lexiconLinks":[]},"description":{"content":["Tool battery software incompatible with tool software.Valid for SRB, TBP and IxB tools only."],"htmlContent":["Tool battery software incompatible with tool software.Valid for SRB, TBP and IxB tools only."],"lexiconLinks":[]},"procedure":{"content":["Update software."],"htmlContent":["Update software."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-67","title":"Event Codes","event-code":{"content":["2100"],"htmlContent":["2100"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["STwrench smartHEAD Removed"],"htmlContent":["STwrench smartHEAD Removed"],"lexiconLinks":[]},"description":{"content":["STwrench smartHEAD has been removed."],"htmlContent":["STwrench smartHEAD has been removed."],"lexiconLinks":[]},"procedure":{"content":["Reconnect smartHEAD and restart the wrench."],"htmlContent":["Reconnect smartHEAD and restart the wrench."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-68","title":"Event Codes","event-code":{"content":["2101"],"htmlContent":["2101"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Wrench Tightening When Locked"],"htmlContent":["Wrench Tightening When Locked"],"lexiconLinks":[]},"description":{"content":["A wrench tightening was performed when the tool status was locked in the controller."],"htmlContent":["A wrench tightening was performed when the tool status was locked in the controller."],"lexiconLinks":[]},"procedure":{"content":["Wait until the tool status in controller is unlocked."],"htmlContent":["Wait until the tool status in controller is unlocked."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","ToolsControl"],"htmlContent":["Power Focus 6000","Power Focus 8","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-69","title":"Event Codes","event-code":{"content":["2120"],"htmlContent":["2120"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Unable To Start: Tool Has No Active Torque Transducer"],"htmlContent":["Unable To Start: Tool Has No Active Torque Transducer"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-70","title":"Event Codes","event-code":{"content":["2121"],"htmlContent":["2121"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Transducers Are Disabled For Connected Tool"],"htmlContent":["Transducers Are Disabled For Connected Tool"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-71","title":"Event Codes","event-code":{"content":["2122"],"htmlContent":["2122"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Unable To Start: Tool Is Missing Required Torque Transducer"],"htmlContent":["Unable To Start: Tool Is Missing Required Torque Transducer"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Change to a tool with multiple torque transducers or update the setting \"Require dual torque\" in Tool Configuration."],"htmlContent":["Change to a tool with multiple torque transducers or update the setting \"Require dual torque\" in Tool Configuration."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB"],"htmlContent":["Flex","IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-72","title":"Event Codes","event-code":{"content":["2123"],"htmlContent":["2123"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Unable To Start: Tool Is Missing Required Angle Transducer"],"htmlContent":["Unable To Start: Tool Is Missing Required Angle Transducer"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Change to a tool with multiple torque transducers or update the setting \"Require dual torque\" in Tool Configuration."],"htmlContent":["Change to a tool with multiple torque transducers or update the setting \"Require dual torque\" in Tool Configuration."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-73","title":"Event Codes","event-code":{"content":["2125"],"htmlContent":["2125"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Torque Transducer Error On Transducer 2"],"htmlContent":["Torque Transducer Error On Transducer 2"],"lexiconLinks":[]},"description":{"content":["There is an error on torque transducer 2 of a tool with multiple transducers."],"htmlContent":["There is an error on torque transducer 2 of a tool with multiple transducers."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-74","title":"Event Codes","event-code":{"content":["2127"],"htmlContent":["2127"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Torque Transducer Calibration Error"],"htmlContent":["Tool Torque Transducer Calibration Error"],"lexiconLinks":[]},"description":{"content":["There is an error on the torque transducer."],"htmlContent":["There is an error on the torque transducer."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex","Synchronized tightening"],"htmlContent":["Flex","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-75","title":"Event Codes","event-code":{"content":["2129"],"htmlContent":["2129"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Torque Transducer: Shunt Test Failed"],"htmlContent":["Tool Torque Transducer: Shunt Test Failed"],"lexiconLinks":[]},"description":{"content":["There is an error on the torque transducer."],"htmlContent":["There is an error on the torque transducer."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex","Synchronized tightening","XB"],"htmlContent":["Flex","Synchronized tightening","XB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-76","title":"Event Codes","event-code":{"content":["2131"],"htmlContent":["2131"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Torque Transducer: Zero Offset Compensation Failed"],"htmlContent":["Tool Torque Transducer: Zero Offset Compensation Failed"],"lexiconLinks":[]},"description":{"content":["There is an error on the torque transducer."],"htmlContent":["There is an error on the torque transducer."],"lexiconLinks":[]},"procedure":{"content":["Ensure the tightening is started with zero torque on the tool. Service the tool."],"htmlContent":["Ensure the tightening is started with zero torque on the tool. Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex","Synchronized tightening"],"htmlContent":["Flex","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-77","title":"Event Codes","event-code":{"content":["2133"],"htmlContent":["2133"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Torque Transducer Hardware Error"],"htmlContent":["Tool Torque Transducer Hardware Error"],"lexiconLinks":[]},"description":{"content":["There is an error on the torque transducer."],"htmlContent":["There is an error on the torque transducer."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex","Synchronized tightening"],"htmlContent":["Flex","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-78","title":"Event Codes","event-code":{"content":["2135"],"htmlContent":["2135"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Torque Transducer Error: Overflow In A\/D Converter"],"htmlContent":["Tool Torque Transducer Error: Overflow In A\/D Converter"],"lexiconLinks":[]},"description":{"content":["There is an error on the torque transducer."],"htmlContent":["There is an error on the torque transducer."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex","Synchronized tightening"],"htmlContent":["Flex","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-79","title":"Event Codes","event-code":{"content":["2136"],"htmlContent":["2136"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Torque Transducer Calibration Error On Transducer 2"],"htmlContent":["Tool Torque Transducer Calibration Error On Transducer 2"],"lexiconLinks":[]},"description":{"content":["There is an error on torque transducer 2 of a tool with multiple transducers."],"htmlContent":["There is an error on torque transducer 2 of a tool with multiple transducers."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-80","title":"Event Codes","event-code":{"content":["2137"],"htmlContent":["2137"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Torque Transducer Error: Shunt Test Failed On Transducer 2"],"htmlContent":["Tool Torque Transducer Error: Shunt Test Failed On Transducer 2"],"lexiconLinks":[]},"description":{"content":["There is an error on torque transducer 2 of a tool with multiple transducers."],"htmlContent":["There is an error on torque transducer 2 of a tool with multiple transducers."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-81","title":"Event Codes","event-code":{"content":["2138"],"htmlContent":["2138"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Torque Transducer Error: Zero Offset Compensation Failed On Transducer 2"],"htmlContent":["Tool Torque Transducer Error: Zero Offset Compensation Failed On Transducer 2"],"lexiconLinks":[]},"description":{"content":["There is an error on torque transducer 2 of a tool with multiple transducers."],"htmlContent":["There is an error on torque transducer 2 of a tool with multiple transducers."],"lexiconLinks":[]},"procedure":{"content":["Ensure the tightening is started with zero torque on the tool. Service the tool."],"htmlContent":["Ensure the tightening is started with zero torque on the tool. Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-82","title":"Event Codes","event-code":{"content":["2139"],"htmlContent":["2139"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Torque Transducer Hardware Error On Transducer 2"],"htmlContent":["Tool Torque Transducer Hardware Error On Transducer 2"],"lexiconLinks":[]},"description":{"content":["There is an error on torque transducer 2 of a tool with multiple transducers."],"htmlContent":["There is an error on torque transducer 2 of a tool with multiple transducers."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-83","title":"Event Codes","event-code":{"content":["2140"],"htmlContent":["2140"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool Torque Transducer Error: Overflow In A\/D Converter On Transducer 2"],"htmlContent":["Tool Torque Transducer Error: Overflow In A\/D Converter On Transducer 2"],"lexiconLinks":[]},"description":{"content":["There is an error on torque transducer 2 of a tool with multiple transducers."],"htmlContent":["There is an error on torque transducer 2 of a tool with multiple transducers."],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-84","title":"Event Codes","event-code":{"content":["2142"],"htmlContent":["2142"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Torque tranceducer redunduncy error"],"htmlContent":["Torque tranceducer redunduncy error"],"lexiconLinks":[]},"description":{"content":["There is an error on torque transducer 2 of a tool with multiple transducers."],"htmlContent":["There is an error on torque transducer 2 of a tool with multiple transducers."],"lexiconLinks":[]},"procedure":{"content":["Reset redunduncy error"],"htmlContent":["Reset redunduncy error"],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Tools control"],"htmlContent":["Power Focus 6000","Tools control"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-85","title":"Event Codes","event-code":{"content":["2143"],"htmlContent":["2143"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Angle tranceducer redundancy error"],"htmlContent":["Angle tranceducer redundancy error"],"lexiconLinks":[]},"description":{"content":["There is an error on torque transducer 2 of a tool with multiple transducers."],"htmlContent":["There is an error on torque transducer 2 of a tool with multiple transducers."],"lexiconLinks":[]},"procedure":{"content":["Reset redunduncy error"],"htmlContent":["Reset redunduncy error"],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Tools control"],"htmlContent":["Power Focus 6000","Tools control"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-86","title":"Event Codes","event-code":{"content":["2202"],"htmlContent":["2202"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool HMI overcurrent occurred"],"htmlContent":["Tool HMI overcurrent occurred"],"lexiconLinks":[]},"description":{"content":["Tool HMI overcurrent was detected."],"htmlContent":["Tool HMI overcurrent was detected."],"lexiconLinks":[]},"procedure":{"content":["Service the tool. Replace tool HMI."],"htmlContent":["Service the tool. Replace tool HMI."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-87","title":"Event Codes","event-code":{"content":["2203"],"htmlContent":["2203"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool front light overcurrent occurred"],"htmlContent":["Tool front light overcurrent occurred"],"lexiconLinks":[]},"description":{"content":["Tool front light overcurrent was detected"],"htmlContent":["Tool front light overcurrent was detected"],"lexiconLinks":[]},"procedure":{"content":["Service the tool. Replace tool front light."],"htmlContent":["Service the tool. Replace tool front light."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-88","title":"Event Codes","event-code":{"content":["2204"],"htmlContent":["2204"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Accessory bus overcurrent occurred"],"htmlContent":["Accessory bus overcurrent occurred"],"lexiconLinks":[]},"description":{"content":["Accessory bus overcurrent was detected."],"htmlContent":["Accessory bus overcurrent was detected."],"lexiconLinks":[]},"procedure":{"content":["Service the tool. Replace accessory bus."],"htmlContent":["Service the tool. Replace accessory bus."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-89","title":"Event Codes","event-code":{"content":["2207"],"htmlContent":["2207"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Vibrator overcurrent occurred"],"htmlContent":["Vibrator overcurrent occurred"],"lexiconLinks":[]},"description":{"content":["Vibrator overcurrent was detected."],"htmlContent":["Vibrator overcurrent was detected."],"lexiconLinks":[]},"procedure":{"content":["Service the tool. Replace the vibrator."],"htmlContent":["Service the tool. Replace the vibrator."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-90","title":"Event Codes","event-code":{"content":["2208"],"htmlContent":["2208"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["System CPU temperature high"],"htmlContent":["System CPU temperature high"],"lexiconLinks":[]},"description":{"content":["System CPU temperature high."],"htmlContent":["System CPU temperature high."],"lexiconLinks":[]},"procedure":{"content":["Wait until tool temperature has been reduced."],"htmlContent":["Wait until tool temperature has been reduced."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-91","title":"Event Codes","event-code":{"content":["2209"],"htmlContent":["2209"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["System CPU temperature critical"],"htmlContent":["System CPU temperature critical"],"lexiconLinks":[]},"description":{"content":["System CPU temperature critical."],"htmlContent":["System CPU temperature critical."],"lexiconLinks":[]},"procedure":{"content":["Wait until tool temperature has been reduced."],"htmlContent":["Wait until tool temperature has been reduced."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","XB"],"htmlContent":["IxB","XB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-92","title":"Event Codes","event-code":{"content":["2210"],"htmlContent":["2210"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Unsupported power source: tightening not permitted"],"htmlContent":["Unsupported power source: tightening not permitted"],"lexiconLinks":[]},"description":{"content":["Battery with too low voltage attached to the tool."],"htmlContent":["Battery with too low voltage attached to the tool."],"lexiconLinks":[]},"procedure":{"content":["Attach battery with higher voltage to the tool."],"htmlContent":["Attach battery with higher voltage to the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-93","title":"Event Codes","event-code":{"content":["2217"],"htmlContent":["2217"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Running on backup battery"],"htmlContent":["Running on backup battery"],"lexiconLinks":[]},"description":{"content":["Running on backup battery."],"htmlContent":["Running on backup battery."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log"],"htmlContent":["Log"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-94","title":"Event Codes","event-code":{"content":["2218"],"htmlContent":["2218"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Battery connected"],"htmlContent":["Battery connected"],"lexiconLinks":[]},"description":{"content":["Battery connected or controller\/tool started."],"htmlContent":["Battery connected or controller\/tool started."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log"],"htmlContent":["Log"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-95","title":"Event Codes","event-code":{"content":["2219"],"htmlContent":["2219"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Power source: unknown"],"htmlContent":["Power source: unknown"],"lexiconLinks":[]},"description":{"content":["Unknown power source connected or controller\/tool started with unknown power source."],"htmlContent":["Unknown power source connected or controller\/tool started with unknown power source."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log"],"htmlContent":["Log"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-96","title":"Event Codes","event-code":{"content":["2220"],"htmlContent":["2220"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool fan failure"],"htmlContent":["Tool fan failure"],"lexiconLinks":[]},"description":{"content":["Applies to IPB-P. "],"htmlContent":["Applies to IPB-P. "],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-97","title":"Event Codes","event-code":{"content":["2221"],"htmlContent":["2221"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Battery overheated"],"htmlContent":["Battery overheated"],"lexiconLinks":[]},"description":{"content":["Battery temperature is too high."],"htmlContent":["Battery temperature is too high."],"lexiconLinks":[]},"procedure":{"content":["Change battery and let overheated battery cool down."],"htmlContent":["Change battery and let overheated battery cool down."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-98","title":"Event Codes","event-code":{"content":["2222"],"htmlContent":["2222"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Usage limited due to high battery temperature"],"htmlContent":["Usage limited due to high battery temperature"],"lexiconLinks":[]},"description":{"content":["Battery temperature is too high."],"htmlContent":["Battery temperature is too high."],"lexiconLinks":[]},"procedure":{"content":["Change battery and let overheated battery cool down."],"htmlContent":["Change battery and let overheated battery cool down."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-99","title":"Event Codes","event-code":{"content":["2223"],"htmlContent":["2223"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Front LED is not available"],"htmlContent":["Front LED is not available"],"lexiconLinks":[]},"description":{"content":["When the tool boots up, if the front LED is not detected, this event will be triggered."],"htmlContent":["When the tool boots up, if the front LED is not detected, this event will be triggered."],"lexiconLinks":[]},"procedure":{"content":["Fix the front light or the front light cable connection."],"htmlContent":["Fix the front light or the front light cable connection."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8"],"lexiconLinks":[]},"group":{"content":["Controller and Tool"],"htmlContent":["Controller and Tool"],"lexiconLinks":[]}},{"id":"64568843-100","title":"Event Codes","event-code":{"content":["2224"],"htmlContent":["2224"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Front LED color is not available"],"htmlContent":["Front LED color is not available"],"lexiconLinks":[]},"description":{"content":["When the tool boots up, if the front LED color is not detected, this event will be triggered."],"htmlContent":["When the tool boots up, if the front LED color is not detected, this event will be triggered."],"lexiconLinks":[]},"procedure":{"content":["Fix the front light color or the front light cable connection"],"htmlContent":["Fix the front light color or the front light cable connection"],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8"],"lexiconLinks":[]},"group":{"content":["Controller and Tool"],"htmlContent":["Controller and Tool"],"lexiconLinks":[]}},{"id":"64568843-101","title":"Event Codes","event-code":{"content":["2225"],"htmlContent":["2225"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["RHMI buttons are not available"],"htmlContent":["RHMI buttons are not available"],"lexiconLinks":[]},"description":{"content":["When the tool boots up, if the RHMI buttons are not detected, an event will be triggered."],"htmlContent":["When the tool boots up, if the RHMI buttons are not detected, an event will be triggered."],"lexiconLinks":[]},"procedure":{"content":["Fix the RHMI buttons."],"htmlContent":["Fix the RHMI buttons."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8"],"lexiconLinks":[]},"group":{"content":["Controller and Tool"],"htmlContent":["Controller and Tool"],"lexiconLinks":[]}},{"id":"64568843-102","title":"Event Codes","event-code":{"content":["2226"],"htmlContent":["2226"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["LED ring is not available"],"htmlContent":["LED ring is not available"],"lexiconLinks":[]},"description":{"content":["When the tool boots up, if the LED ring is not detected, an event will be triggered."],"htmlContent":["When the tool boots up, if the LED ring is not detected, an event will be triggered."],"lexiconLinks":[]},"procedure":{"content":["Fix the back ring lights or the back ring light connection."],"htmlContent":["Fix the back ring lights or the back ring light connection."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8"],"lexiconLinks":[]},"group":{"content":["Controller and Tool"],"htmlContent":["Controller and Tool"],"lexiconLinks":[]}},{"id":"64568843-103","title":"Event Codes","event-code":{"content":["2227"],"htmlContent":["2227"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Fan is not available"],"htmlContent":["Fan is not available"],"lexiconLinks":[]},"description":{"content":["When the tool boots up, if the fan is not detected, an event will be triggered."],"htmlContent":["When the tool boots up, if the fan is not detected, an event will be triggered."],"lexiconLinks":[]},"procedure":{"content":["Fix the fan."],"htmlContent":["Fix the fan."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8"],"lexiconLinks":[]},"group":{"content":["Controller and Tool"],"htmlContent":["Controller and Tool"],"lexiconLinks":[]}},{"id":"64568843-104","title":"Event Codes","event-code":{"content":["2228"],"htmlContent":["2228"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["RRE board is not available"],"htmlContent":["RRE board is not available"],"lexiconLinks":[]},"description":{"content":["When the tool boots up, if the tool board interface is not detected, an event will be triggered."],"htmlContent":["When the tool boots up, if the tool board interface is not detected, an event will be triggered."],"lexiconLinks":[]},"procedure":{"content":["Fix the tool board interface."],"htmlContent":["Fix the tool board interface."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8"],"lexiconLinks":[]},"group":{"content":["Controller and Tool"],"htmlContent":["Controller and Tool"],"lexiconLinks":[]}},{"id":"64568843-105","title":"Event Codes","event-code":{"content":["2229"],"htmlContent":["2229"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Backup battery empty"],"htmlContent":["Tool Backup battery empty"],"lexiconLinks":[]},"description":{"content":["Tool backup battery is empty."],"htmlContent":["Tool backup battery is empty."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-106","title":"Event Codes","event-code":{"content":["2230"],"htmlContent":["2230"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tool Backup battery fully charged"],"htmlContent":["Tool Backup battery fully charged"],"lexiconLinks":[]},"description":{"content":["Tool backup battery is fully charged."],"htmlContent":["Tool backup battery is fully charged."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-107","title":"Event Codes","event-code":{"content":["2231"],"htmlContent":["2231"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Backup Battery Missing"],"htmlContent":["Tool Backup Battery Missing"],"lexiconLinks":[]},"description":{"content":["Tool backup battery is missing."],"htmlContent":["Tool backup battery is missing."],"lexiconLinks":[]},"procedure":{"content":["Insert battery."],"htmlContent":["Insert battery."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-108","title":"Event Codes","event-code":{"content":["2232"],"htmlContent":["2232"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tool Backup Battery Broken"],"htmlContent":["Tool Backup Battery Broken"],"lexiconLinks":[]},"description":{"content":["Tool backup battery is broken."],"htmlContent":["Tool backup battery is broken."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-109","title":"Event Codes","event-code":{"content":["2300"],"htmlContent":["2300"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool main board error - Voltage out of range (Torque)"],"htmlContent":["Tool main board error - Voltage out of range (Torque)"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Restart the tool. If the error persist, service the tool an look for lose connections in the cable connectors. Inspect any possible damage in the cables."],"htmlContent":["Restart the tool. If the error persist, service the tool an look for lose connections in the cable connectors. Inspect any possible damage in the cables."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-110","title":"Event Codes","event-code":{"content":["2301"],"htmlContent":["2301"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool main board error - Voltage out of range (Analog)"],"htmlContent":["Tool main board error - Voltage out of range (Analog)"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Restart the tool. If the error persist, service the tool an look for lose connections in the cable connectors. Inspect any possible damage in the cables."],"htmlContent":["Restart the tool. If the error persist, service the tool an look for lose connections in the cable connectors. Inspect any possible damage in the cables."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-111","title":"Event Codes","event-code":{"content":["2302"],"htmlContent":["2302"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool main board error - Voltage out of range (MCU Vdd)"],"htmlContent":["Tool main board error - Voltage out of range (MCU Vdd)"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Restart the tool. If the error persist, service the tool an look for lose connections in the cable connectors. Inspect any possible damage in the cables."],"htmlContent":["Restart the tool. If the error persist, service the tool an look for lose connections in the cable connectors. Inspect any possible damage in the cables."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-112","title":"Event Codes","event-code":{"content":["2303"],"htmlContent":["2303"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool main board error - Voltage out of range (Step up)"],"htmlContent":["Tool main board error - Voltage out of range (Step up)"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Restart the tool. If the error persist, service the tool an look for lose connections in the cable connectors. Inspect any possible damage in the cables."],"htmlContent":["Restart the tool. If the error persist, service the tool an look for lose connections in the cable connectors. Inspect any possible damage in the cables."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-113","title":"Event Codes","event-code":{"content":["2304"],"htmlContent":["2304"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool main board error - Voltage out of range (UPS)"],"htmlContent":["Tool main board error - Voltage out of range (UPS)"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Restart the tool. If the error persist, service the tool an look for lose connections in the cable connectors. Inspect any possible damage in the cables."],"htmlContent":["Restart the tool. If the error persist, service the tool an look for lose connections in the cable connectors. Inspect any possible damage in the cables."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-114","title":"Event Codes","event-code":{"content":["2305"],"htmlContent":["2305"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool main board error - Voltage out of range (Tool power)"],"htmlContent":["Tool main board error - Voltage out of range (Tool power)"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Restart the tool. If the error persist, service the tool an look for lose connections in the cable connectors. Inspect any possible damage in the cables."],"htmlContent":["Restart the tool. If the error persist, service the tool an look for lose connections in the cable connectors. Inspect any possible damage in the cables."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-115","title":"Event Codes","event-code":{"content":["2306"],"htmlContent":["2306"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool main board error - Voltage out of range (Vdd)"],"htmlContent":["Tool main board error - Voltage out of range (Vdd)"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Restart the tool. If the error persist, service the tool an look for lose connections in the cable connectors. Inspect any possible damage in the cables."],"htmlContent":["Restart the tool. If the error persist, service the tool an look for lose connections in the cable connectors. Inspect any possible damage in the cables."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-116","title":"Event Codes","event-code":{"content":["2307"],"htmlContent":["2307"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool main board error - Hardware failure (IMU)"],"htmlContent":["Tool main board error - Hardware failure (IMU)"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-117","title":"Event Codes","event-code":{"content":["2331"],"htmlContent":["2331"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool power module error - Voltage low (Reference)"],"htmlContent":["Tool power module error - Voltage low (Reference)"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-118","title":"Event Codes","event-code":{"content":["2332"],"htmlContent":["2332"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool power module error - Voltage high (Reference)"],"htmlContent":["Tool power module error - Voltage high (Reference)"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-119","title":"Event Codes","event-code":{"content":["2333"],"htmlContent":["2333"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool power module error - Voltage low (UPS)"],"htmlContent":["Tool power module error - Voltage low (UPS)"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-120","title":"Event Codes","event-code":{"content":["2334"],"htmlContent":["2334"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool power module error - Voltage high (UPS)"],"htmlContent":["Tool power module error - Voltage high (UPS)"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-121","title":"Event Codes","event-code":{"content":["2335"],"htmlContent":["2335"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool power module error - Voltage low (Backup domain)"],"htmlContent":["Tool power module error - Voltage low (Backup domain)"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-122","title":"Event Codes","event-code":{"content":["2336"],"htmlContent":["2336"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tool power module error - Voltage high (Backup domain)"],"htmlContent":["Tool power module error - Voltage high (Backup domain)"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Service the tool."],"htmlContent":["Service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-123","title":"Event Codes","event-code":{"content":["2500"],"htmlContent":["2500"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tensioner puller bar max number"],"htmlContent":["Tensioner puller bar max number"],"lexiconLinks":[]},"description":{"content":["Tensioner puller bar must be replaced. System is locked for usage. Pressure can only be released."],"htmlContent":["Tensioner puller bar must be replaced. System is locked for usage. Pressure can only be released."],"lexiconLinks":[]},"procedure":{"content":["Send the tensioner to service organization for replacement of the puller bar."],"htmlContent":["Send the tensioner to service organization for replacement of the puller bar."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["PFHC"],"htmlContent":["PFHC"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-124","title":"Event Codes","event-code":{"content":["2501"],"htmlContent":["2501"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Pump motor protection alarm"],"htmlContent":["Pump motor protection alarm"],"lexiconLinks":[]},"description":{"content":["The pump motor protection has stopped the motor. The system must stop. If the system is under pressure, it needs manual actions to release pressure."],"htmlContent":["The pump motor protection has stopped the motor. The system must stop. If the system is under pressure, it needs manual actions to release pressure."],"lexiconLinks":[]},"procedure":{"content":["Turn off the system. If under pressure, mechanically release the pressure and send the pump to service."],"htmlContent":["Turn off the system. If under pressure, mechanically release the pressure and send the pump to service."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["PFHC"],"htmlContent":["PFHC"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-125","title":"Event Codes","event-code":{"content":["2502"],"htmlContent":["2502"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Pump motor oil level low alarm"],"htmlContent":["Pump motor oil level low alarm"],"lexiconLinks":[]},"description":{"content":["The pump motor oil level is low which has stopped the motor. If the system is under pressure, it needs manual actions to release pressure."],"htmlContent":["The pump motor oil level is low which has stopped the motor. If the system is under pressure, it needs manual actions to release pressure."],"lexiconLinks":[]},"procedure":{"content":["Turn off the system. If under pressure, mechanically release the pressure and top up oil."],"htmlContent":["Turn off the system. If under pressure, mechanically release the pressure and top up oil."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["PFHC"],"htmlContent":["PFHC"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-126","title":"Event Codes","event-code":{"content":["2503"],"htmlContent":["2503"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Pump motor oil temperature high alarm"],"htmlContent":["Pump motor oil temperature high alarm"],"lexiconLinks":[]},"description":{"content":["The pump motor oil temperature is high."],"htmlContent":["The pump motor oil temperature is high."],"lexiconLinks":[]},"procedure":{"content":["Turn off the system and wait for the oil to cool down. "],"htmlContent":["Turn off the system and wait for the oil to cool down. "],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["PFHC"],"htmlContent":["PFHC"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-127","title":"Event Codes","event-code":{"content":["2504"],"htmlContent":["2504"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tensioner pressure sensor alarm"],"htmlContent":["Tensioner pressure sensor alarm"],"lexiconLinks":[]},"description":{"content":["Failure in the pressure sensor electronics of the tensioner. No pressure can be read nor reported to the system."],"htmlContent":["Failure in the pressure sensor electronics of the tensioner. No pressure can be read nor reported to the system."],"lexiconLinks":[]},"procedure":{"content":["Turn off the system. If under pressure, mechanically release the pressure and send the tensioner to service."],"htmlContent":["Turn off the system. If under pressure, mechanically release the pressure and send the tensioner to service."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["PFHC"],"htmlContent":["PFHC"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-128","title":"Event Codes","event-code":{"content":["2505"],"htmlContent":["2505"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Pump pressure sensor alarm"],"htmlContent":["Pump pressure sensor alarm"],"lexiconLinks":[]},"description":{"content":["Failure in the pressure sensor electronics of the pump. No pressure can be read nor reported to the system."],"htmlContent":["Failure in the pressure sensor electronics of the pump. No pressure can be read nor reported to the system."],"lexiconLinks":[]},"procedure":{"content":["Turn off the system. If under pressure, mechanically release the pressure and send the pump to service."],"htmlContent":["Turn off the system. If under pressure, mechanically release the pressure and send the pump to service."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["PFHC"],"htmlContent":["PFHC"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-129","title":"Event Codes","event-code":{"content":["2506"],"htmlContent":["2506"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Unexpected clockwise rotation detected"],"htmlContent":["Unexpected clockwise rotation detected"],"lexiconLinks":[]},"description":{"content":["A clockwise nut rotation while waiting for pressure release after completed tensioning. The result is invalidated."],"htmlContent":["A clockwise nut rotation while waiting for pressure release after completed tensioning. The result is invalidated."],"lexiconLinks":[]},"procedure":{"content":["Release pressure and tension the nut again."],"htmlContent":["Release pressure and tension the nut again."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["PFHC"],"htmlContent":["PFHC"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-130","title":"Event Codes","event-code":{"content":["2507"],"htmlContent":["2507"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Unexpected counter clockwise rotation detected"],"htmlContent":["Unexpected counter clockwise rotation detected"],"lexiconLinks":[]},"description":{"content":["A counter clockwise nut rotation while waiting for pressure release after completed tensioning. The result is invalidated."],"htmlContent":["A counter clockwise nut rotation while waiting for pressure release after completed tensioning. The result is invalidated."],"lexiconLinks":[]},"procedure":{"content":["Release pressure and tension the nut again."],"htmlContent":["Release pressure and tension the nut again."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["PFHC"],"htmlContent":["PFHC"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-131","title":"Event Codes","event-code":{"content":["2508"],"htmlContent":["2508"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Pump or tensioner pressure sensor failure"],"htmlContent":["Pump or tensioner pressure sensor failure"],"lexiconLinks":[]},"description":{"content":["Too large difference between the pressure sensor readings in the pump and the tensioner. Pressurization is halted."],"htmlContent":["Too large difference between the pressure sensor readings in the pump and the tensioner. Pressurization is halted."],"lexiconLinks":[]},"procedure":{"content":["Problem in the hydraulics or the calibration of the pressure sensors. Restart the system and try again. If the problem repeats, contact your local Atlas Copco sales representative."],"htmlContent":["Problem in the hydraulics or the calibration of the pressure sensors. Restart the system and try again. If the problem repeats, contact your local Atlas Copco sales representative."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["PFHC"],"htmlContent":["PFHC"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-132","title":"Event Codes","event-code":{"content":["2509"],"htmlContent":["2509"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Tensioner pressure sensor failure or hydraulic hose failure"],"htmlContent":["Tensioner pressure sensor failure or hydraulic hose failure"],"lexiconLinks":[]},"description":{"content":["The tensioner's pressure sensor indicates no pressure but the pump's sensor reads a pressure increase. Pressurization is halted. "],"htmlContent":["The tensioner's pressure sensor indicates no pressure but the pump's sensor reads a pressure increase. Pressurization is halted. "],"lexiconLinks":[]},"procedure":{"content":["Problem in the hydraulics or the calibration of the pressure sensors. Restart the system and try again. If the problem repeats, contact your local Atlas Copco sales representative. "],"htmlContent":["Problem in the hydraulics or the calibration of the pressure sensors. Restart the system and try again. If the problem repeats, contact your local Atlas Copco sales representative. "],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["PFHC"],"htmlContent":["PFHC"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-133","title":"Event Codes","event-code":{"content":["2510"],"htmlContent":["2510"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Set custom ID failed"],"htmlContent":["Set custom ID failed"],"lexiconLinks":[]},"description":{"content":["Setting custom ID failed. "],"htmlContent":["Setting custom ID failed. "],"lexiconLinks":[]},"procedure":{"content":["Restart the system and check the connected devices. If Custom ID for the unit is wrong, redo the setting. "],"htmlContent":["Restart the system and check the connected devices. If Custom ID for the unit is wrong, redo the setting. "],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["PFHC"],"htmlContent":["PFHC"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-134","title":"Event Codes","event-code":{"content":["2511"],"htmlContent":["2511"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Custom ID is set"],"htmlContent":["Custom ID is set"],"lexiconLinks":[]},"description":{"content":["Setting custom ID succeeded."],"htmlContent":["Setting custom ID succeeded."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["PFHC"],"htmlContent":["PFHC"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-135","title":"Event Codes","event-code":{"content":["2512"],"htmlContent":["2512"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Malformed Barcode string, ignored"],"htmlContent":["Malformed Barcode string, ignored"],"lexiconLinks":[]},"description":{"content":["The scanned string could not be parsed as a tower data bar code."],"htmlContent":["The scanned string could not be parsed as a tower data bar code."],"lexiconLinks":[]},"procedure":{"content":["Scan a proper tower data qr code or scan tower section id."],"htmlContent":["Scan a proper tower data qr code or scan tower section id."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["PFHC"],"htmlContent":["PFHC"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-136","title":"Event Codes","event-code":{"content":["2513"],"htmlContent":["2513"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["No pump pressure detected "],"htmlContent":["No pump pressure detected "],"lexiconLinks":[]},"description":{"content":["The system is trying to pressurize but no pressure increase is registered in the pump. Possible cause is incorrect phase order in the three phase connector."],"htmlContent":["The system is trying to pressurize but no pressure increase is registered in the pump. Possible cause is incorrect phase order in the three phase connector."],"lexiconLinks":[]},"procedure":{"content":["Power off the system and reverse the phases of the power connector. "],"htmlContent":["Power off the system and reverse the phases of the power connector. "],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["PFHC"],"htmlContent":["PFHC"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-137","title":"Event Codes","event-code":{"content":["2514"],"htmlContent":["2514"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tensioner overtorque alarm"],"htmlContent":["Tensioner overtorque alarm"],"lexiconLinks":[]},"description":{"content":["Too high torque is applied to the click wrench. This causes damage to the torque sensor."],"htmlContent":["Too high torque is applied to the click wrench. This causes damage to the torque sensor."],"lexiconLinks":[]},"procedure":{"content":["Relax the torque."],"htmlContent":["Relax the torque."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log"],"htmlContent":["Log"],"lexiconLinks":[]},"available-for":{"content":["PFHC"],"htmlContent":["PFHC"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-138","title":"Event Codes","event-code":{"content":["2515"],"htmlContent":["2515"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Tensioner overpressure alarm"],"htmlContent":["Tensioner overpressure alarm"],"lexiconLinks":[]},"description":{"content":["The pressure in the tensioner is too high."],"htmlContent":["The pressure in the tensioner is too high."],"lexiconLinks":[]},"procedure":{"content":["Let the pressure drop, or release the pressure. Check the hydraulic pressure parameters."],"htmlContent":["Let the pressure drop, or release the pressure. Check the hydraulic pressure parameters."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log"],"htmlContent":["Log"],"lexiconLinks":[]},"available-for":{"content":["PFHC"],"htmlContent":["PFHC"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-139","title":"Event Codes","event-code":{"content":["2516"],"htmlContent":["2516"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Unexpected Pump or Tensioner firmware"],"htmlContent":["Unexpected Pump or Tensioner firmware"],"lexiconLinks":[]},"description":{"content":["Unexpected Pump or Tensioner firmware version detected, restart system. If the problem persists, the system may be possible to run, but carefully observe any unexpected behaviour."],"htmlContent":["Unexpected Pump or Tensioner firmware version detected, restart system. If the problem persists, the system may be possible to run, but carefully observe any unexpected behaviour."],"lexiconLinks":[]},"procedure":{"content":["Power cycle system"],"htmlContent":["Power cycle system"],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["PFHC"],"htmlContent":["PFHC"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-140","title":"Event Codes","event-code":{"content":["2517"],"htmlContent":["2517"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Incompatible Pump or Tensioner firmware version, restart system. The system cannot run."],"htmlContent":["Incompatible Pump or Tensioner firmware version, restart system. The system cannot run."],"lexiconLinks":[]},"description":{"content":["Incompatible Pump or Tensioner firmware version, restart system. The system cannot run."],"htmlContent":["Incompatible Pump or Tensioner firmware version, restart system. The system cannot run."],"lexiconLinks":[]},"procedure":{"content":["Restart system, if this doesn’t help replace the failing unit. Check connected devices to see which one has not connected."],"htmlContent":["Restart system, if this doesn’t help replace the failing unit. Check connected devices to see which one has not connected."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["PFHC"],"htmlContent":["PFHC"],"lexiconLinks":[]},"group":{"content":["Tool"],"htmlContent":["Tool"],"lexiconLinks":[]}},{"id":"64568843-141","title":"Event Codes","event-code":{"content":["3000"],"htmlContent":["3000"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Controller Internal Software Error"],"htmlContent":["Controller Internal Software Error"],"lexiconLinks":[]},"description":{"content":["Software error in the controller."],"htmlContent":["Software error in the controller."],"lexiconLinks":[]},"procedure":{"content":["Contact service."],"htmlContent":["Contact service."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-142","title":"Event Codes","event-code":{"content":["3001"],"htmlContent":["3001"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Controller Clock Battery Empty"],"htmlContent":["Controller Clock Battery Empty"],"lexiconLinks":[]},"description":{"content":["Internal battery is getting close to end of life."],"htmlContent":["Internal battery is getting close to end of life."],"lexiconLinks":[]},"procedure":{"content":["Replace battery."],"htmlContent":["Replace battery."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-143","title":"Event Codes","event-code":{"content":["3010"],"htmlContent":["3010"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["System Overheated"],"htmlContent":["System Overheated"],"lexiconLinks":[]},"description":{"content":["The controller is overheated."],"htmlContent":["The controller is overheated."],"lexiconLinks":[]},"procedure":{"content":["Cool down."],"htmlContent":["Cool down."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Power Focus XC"],"htmlContent":["Power Focus 6000","Power Focus 8","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-144","title":"Event Codes","event-code":{"content":["3011"],"htmlContent":["3011"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Drive Overheated Controller Hardware"],"htmlContent":["Drive Overheated Controller Hardware"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Cool down."],"htmlContent":["Cool down."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","ToolsControl"],"htmlContent":["Flex","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-145","title":"Event Codes","event-code":{"content":["3013"],"htmlContent":["3013"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Usage Limited Due To High Controller Temperature"],"htmlContent":["Usage Limited Due To High Controller Temperature"],"lexiconLinks":[]},"description":{"content":["Temperature limit value has been reached. Tightening has been inhibited to reduce risk for controller shutting down due to overheating."],"htmlContent":["Temperature limit value has been reached. Tightening has been inhibited to reduce risk for controller shutting down due to overheating."],"lexiconLinks":[]},"procedure":{"content":["Wait until controller temperature has been reduced."],"htmlContent":["Wait until controller temperature has been reduced."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"htmlContent":["Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-146","title":"Event Codes","event-code":{"content":["3020"],"htmlContent":["3020"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Controller Hardware Failure"],"htmlContent":["Controller Hardware Failure"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-147","title":"Event Codes","event-code":{"content":["3021"],"htmlContent":["3021"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["System Voltage Problem"],"htmlContent":["System Voltage Problem"],"lexiconLinks":[]},"description":{"content":["DC voltage too high or too low."],"htmlContent":["DC voltage too high or too low."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-148","title":"Event Codes","event-code":{"content":["3022"],"htmlContent":["3022"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Controller Voltage Problem: AC Input Voltage Too High"],"htmlContent":["Controller Voltage Problem: AC Input Voltage Too High"],"lexiconLinks":[]},"description":{"content":["DC voltage too high or too low."],"htmlContent":["DC voltage too high or too low."],"lexiconLinks":[]},"procedure":{"content":["Fix the input voltage."],"htmlContent":["Fix the input voltage."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"htmlContent":["Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-149","title":"Event Codes","event-code":{"content":["3023"],"htmlContent":["3023"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Controller Voltage Problem: AC Input Voltage Too Low"],"htmlContent":["Controller Voltage Problem: AC Input Voltage Too Low"],"lexiconLinks":[]},"description":{"content":["DC voltage too high or too low."],"htmlContent":["DC voltage too high or too low."],"lexiconLinks":[]},"procedure":{"content":["Fix the input voltage."],"htmlContent":["Fix the input voltage."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"htmlContent":["Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-150","title":"Event Codes","event-code":{"content":["3024"],"htmlContent":["3024"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Drive Voltage Problem: AC Input Voltage Too High"],"htmlContent":["Drive Voltage Problem: AC Input Voltage Too High"],"lexiconLinks":[]},"description":{"content":["DC voltage too high or too low."],"htmlContent":["DC voltage too high or too low."],"lexiconLinks":[]},"procedure":{"content":["Fix the input voltage."],"htmlContent":["Fix the input voltage."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex","ToolsControl"],"htmlContent":["Flex","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-151","title":"Event Codes","event-code":{"content":["3025"],"htmlContent":["3025"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Drive Voltage Problem: AC Input Voltage Too Low"],"htmlContent":["Drive Voltage Problem: AC Input Voltage Too Low"],"lexiconLinks":[]},"description":{"content":["DC voltage too high or too low."],"htmlContent":["DC voltage too high or too low."],"lexiconLinks":[]},"procedure":{"content":["Fix the input voltage."],"htmlContent":["Fix the input voltage."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex","ToolsControl"],"htmlContent":["Flex","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-152","title":"Event Codes","event-code":{"content":["3026"],"htmlContent":["3026"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Max number of IxB Connect tools already connected."],"htmlContent":["Max number of IxB Connect tools already connected."],"lexiconLinks":[]},"description":{"content":["Indicates that the number of IxB Connect tools connected to the controller has reached the max. allowed connected tools."],"htmlContent":["Indicates that the number of IxB Connect tools connected to the controller has reached the max. allowed connected tools."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log"],"htmlContent":["Log"],"lexiconLinks":[]},"available-for":{"content":["ToolsControl"],"htmlContent":["ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller and Tool"],"htmlContent":["Controller and Tool"],"lexiconLinks":[]}},{"id":"64568843-153","title":"Event Codes","event-code":{"content":["3029"],"htmlContent":["3029"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["The client lost network connection"],"htmlContent":["The client lost network connection"],"lexiconLinks":[]},"description":{"content":["The tool has lost the network connection by either leaving the network coverage or due to another cause."],"htmlContent":["The tool has lost the network connection by either leaving the network coverage or due to another cause."],"lexiconLinks":[]},"procedure":{"content":["Troubleshoot by checking the roaming threshold and reduce the selected channel numbers to less than 24 to make sure roaming is enabled."],"htmlContent":["Troubleshoot by checking the roaming threshold and reduce the selected channel numbers to less than 24 to make sure roaming is enabled."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf","Ack"],"htmlContent":["Log","Display","Conf","Ack"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Controller and Tool"],"htmlContent":["Controller and Tool"],"lexiconLinks":[]}},{"id":"64568843-154","title":"Event Codes","event-code":{"content":["3030"],"htmlContent":["3030"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["IP Address Conflicting With Another Node On The Network"],"htmlContent":["IP Address Conflicting With Another Node On The Network"],"lexiconLinks":[]},"description":{"content":["The set IP address is in use by another device on the same network."],"htmlContent":["The set IP address is in use by another device on the same network."],"lexiconLinks":[]},"procedure":{"content":["Change IP address on one of the devices."],"htmlContent":["Change IP address on one of the devices."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-155","title":"Event Codes","event-code":{"content":["3031"],"htmlContent":["3031"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Network Cable Unplugged"],"htmlContent":["Network Cable Unplugged"],"lexiconLinks":[]},"description":{"content":["The carrier of the factory port is lost (cable disconnected)."],"htmlContent":["The carrier of the factory port is lost (cable disconnected)."],"lexiconLinks":[]},"procedure":{"content":["Check the cable connection."],"htmlContent":["Check the cable connection."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-156","title":"Event Codes","event-code":{"content":["3032"],"htmlContent":["3032"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Pairing Started"],"htmlContent":["Pairing Started"],"lexiconLinks":[]},"description":{"content":["Tool pairing started."],"htmlContent":["Tool pairing started."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Power Focus XC"],"htmlContent":["Power Focus 6000","Power Focus 8","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-157","title":"Event Codes","event-code":{"content":["3033"],"htmlContent":["3033"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Pairing Successful "],"htmlContent":["Pairing Successful "],"lexiconLinks":[]},"description":{"content":["Tool pairing successful."],"htmlContent":["Tool pairing successful."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Power Focus XC"],"htmlContent":["Power Focus 6000","Power Focus 8","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-158","title":"Event Codes","event-code":{"content":["3034"],"htmlContent":["3034"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Pairing Unsuccessful: No Tool Found"],"htmlContent":["Pairing Unsuccessful: No Tool Found"],"lexiconLinks":[]},"description":{"content":["The controller found no tool to pair with when scanning for radio peers."],"htmlContent":["The controller found no tool to pair with when scanning for radio peers."],"lexiconLinks":[]},"procedure":{"content":["Set the tool in pairing mode and try again."],"htmlContent":["Set the tool in pairing mode and try again."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Power Focus XC"],"htmlContent":["Power Focus 6000","Power Focus 8","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-159","title":"Event Codes","event-code":{"content":["3035"],"htmlContent":["3035"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Pairing Unsuccessful: More Than One Tool Found"],"htmlContent":["Pairing Unsuccessful: More Than One Tool Found"],"lexiconLinks":[]},"description":{"content":["The controller found more than one tool when scanning for radio peers."],"htmlContent":["The controller found more than one tool when scanning for radio peers."],"lexiconLinks":[]},"procedure":{"content":["Ensure that only one tool is in pairing mode when starting the pairing mode on the controller."],"htmlContent":["Ensure that only one tool is in pairing mode when starting the pairing mode on the controller."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Power Focus XC"],"htmlContent":["Power Focus 6000","Power Focus 8","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-160","title":"Event Codes","event-code":{"content":["3036"],"htmlContent":["3036"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Pairing Unsuccessful: Communication Error"],"htmlContent":["Pairing Unsuccessful: Communication Error"],"lexiconLinks":[]},"description":{"content":["The controller experienced a loss of connection, an unexpected answer or timeout during the pairing process."],"htmlContent":["The controller experienced a loss of connection, an unexpected answer or timeout during the pairing process."],"lexiconLinks":[]},"procedure":{"content":["Try to perform pairing one more time. If it fails again, service the tool."],"htmlContent":["Try to perform pairing one more time. If it fails again, service the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Power Focus XC"],"htmlContent":["Power Focus 6000","Power Focus 8","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-161","title":"Event Codes","event-code":{"content":["3037"],"htmlContent":["3037"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Pairing Unsuccessful: Tool Slot Is Full"],"htmlContent":["Pairing Unsuccessful: Tool Slot Is Full"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Clear one tool slot."],"htmlContent":["Clear one tool slot."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Power Focus XC"],"htmlContent":["Power Focus 6000","Power Focus 8","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-162","title":"Event Codes","event-code":{"content":["3040"],"htmlContent":["3040"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Emergency Stop"],"htmlContent":["Emergency Stop"],"lexiconLinks":[]},"description":{"content":["Drive disabled due to emergency stop."],"htmlContent":["Drive disabled due to emergency stop."],"lexiconLinks":[]},"procedure":{"content":["Reset emergency stop."],"htmlContent":["Reset emergency stop."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-163","title":"Event Codes","event-code":{"content":["3050"],"htmlContent":["3050"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["System Clock Updated"],"htmlContent":["System Clock Updated"],"lexiconLinks":[]},"description":{"content":["System clock has been updated."],"htmlContent":["System clock has been updated."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Conf"],"htmlContent":["Log","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-164","title":"Event Codes","event-code":{"content":["3051"],"htmlContent":["3051"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["System Clock Error"],"htmlContent":["System Clock Error"],"lexiconLinks":[]},"description":{"content":["Wrong time read from hardware Real Time Clock (RTC)."],"htmlContent":["Wrong time read from hardware Real Time Clock (RTC)."],"lexiconLinks":[]},"procedure":{"content":["Change RTC battery."],"htmlContent":["Change RTC battery."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-165","title":"Event Codes","event-code":{"content":["3052"],"htmlContent":["3052"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Remote Start Configuration Error"],"htmlContent":["Remote Start Configuration Error"],"lexiconLinks":[]},"description":{"content":["Mismatch between HW and SW remote start configuration."],"htmlContent":["Mismatch between HW and SW remote start configuration."],"lexiconLinks":[]},"procedure":{"content":["Verify that HW dip switch matches the selected start source."],"htmlContent":["Verify that HW dip switch matches the selected start source."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-166","title":"Event Codes","event-code":{"content":["3053"],"htmlContent":["3053"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Drive Connected"],"htmlContent":["Drive Connected"],"lexiconLinks":[]},"description":{"content":["Synchronized tightening drive has been connected."],"htmlContent":["Synchronized tightening drive has been connected."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-167","title":"Event Codes","event-code":{"content":["3054"],"htmlContent":["3054"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Drive Disconnected"],"htmlContent":["Drive Disconnected"],"lexiconLinks":[]},"description":{"content":["Drive disconnected from controller."],"htmlContent":["Drive disconnected from controller."],"lexiconLinks":[]},"procedure":{"content":["Check cabling and power-supply for externally connected drives or replace the controller."],"htmlContent":["Check cabling and power-supply for externally connected drives or replace the controller."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-168","title":"Event Codes","event-code":{"content":["3055"],"htmlContent":["3055"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Mode Configuration Error"],"htmlContent":["Mode Configuration Error"],"lexiconLinks":[]},"description":{"content":["Generated when selected mode is configured wrongly. E.g. configuring two bolts with the same bolt number or the same channel, incomplete mode configuration."],"htmlContent":["Generated when selected mode is configured wrongly. E.g. configuring two bolts with the same bolt number or the same channel, incomplete mode configuration."],"lexiconLinks":[]},"procedure":{"content":["Check ToolsTalk 2 for mode configuration error."],"htmlContent":["Check ToolsTalk 2 for mode configuration error."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex","Synchronized tightening"],"htmlContent":["Flex","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-169","title":"Event Codes","event-code":{"content":["3056"],"htmlContent":["3056"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Unable to Start: Tool Or Drive Is Missing"],"htmlContent":["Unable to Start: Tool Or Drive Is Missing"],"lexiconLinks":[]},"description":{"content":["Generated when a used channel is missing a drive or tool. "],"htmlContent":["Generated when a used channel is missing a drive or tool. "],"lexiconLinks":[]},"procedure":{"content":["Verify Channel Menu on the HMI. Connect missing drive or tool. "],"htmlContent":["Verify Channel Menu on the HMI. Connect missing drive or tool. "],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex","Synchronized tightening"],"htmlContent":["Flex","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-170","title":"Event Codes","event-code":{"content":["3057"],"htmlContent":["3057"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Unable to Start: Channel Is Already In Use"],"htmlContent":["Unable to Start: Channel Is Already In Use"],"lexiconLinks":[]},"description":{"content":["Generated when a needed channel has been allocated to another virtual station."],"htmlContent":["Generated when a needed channel has been allocated to another virtual station."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-171","title":"Event Codes","event-code":{"content":["3058"],"htmlContent":["3058"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["No Mode Selected"],"htmlContent":["No Mode Selected"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Select mode."],"htmlContent":["Select mode."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex","Synchronized tightening"],"htmlContent":["Flex","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-172","title":"Event Codes","event-code":{"content":["3059"],"htmlContent":["3059"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Failed To Connect To Atlas Copco License Manager"],"htmlContent":["Failed To Connect To Atlas Copco License Manager"],"lexiconLinks":[]},"description":{"content":["Indicates that the controller failed to connect to the local license manager to get licenses."],"htmlContent":["Indicates that the controller failed to connect to the local license manager to get licenses."],"lexiconLinks":[]},"procedure":{"content":["Verify the local network. If it fails again, service the controller."],"htmlContent":["Verify the local network. If it fails again, service the controller."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-173","title":"Event Codes","event-code":{"content":["3060"],"htmlContent":["3060"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Number of Virtual Station licenses is exceeded."],"htmlContent":["Number of Virtual Station licenses is exceeded."],"lexiconLinks":[]},"description":{"content":["Virtual Station license greater than available licenses."],"htmlContent":["Virtual Station license greater than available licenses."],"lexiconLinks":[]},"procedure":{"content":["Update licenses or Virtual Station configuration."],"htmlContent":["Update licenses or Virtual Station configuration."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["ToolsControl"],"htmlContent":["ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller"],"htmlContent":["Controller"],"lexiconLinks":[]}},{"id":"64568843-174","title":"Event Codes","event-code":{"content":["3061"],"htmlContent":["3061"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Unable To Start: Enable Signal Is Low"],"htmlContent":["Unable To Start: Enable Signal Is Low"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Ensure the signal \"Enable Operation\" is set to high before tightening is started."],"htmlContent":["Ensure the signal \"Enable Operation\" is set to high before tightening is started."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex","Synchronized tightening"],"htmlContent":["Flex","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-175","title":"Event Codes","event-code":{"content":["3062"],"htmlContent":["3062"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Unable To Start: Stop Signal Is High"],"htmlContent":["Unable To Start: Stop Signal Is High"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Ensure the signal \"Enable Operation\" is set to low before tightening is started."],"htmlContent":["Ensure the signal \"Enable Operation\" is set to low before tightening is started."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex","Synchronized tightening"],"htmlContent":["Flex","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-176","title":"Event Codes","event-code":{"content":["3063"],"htmlContent":["3063"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Unable To Start: All Channels Inhibited"],"htmlContent":["Unable To Start: All Channels Inhibited"],"lexiconLinks":[]},"description":{"content":["All channels have been set inhibited, so no tightening can be started."],"htmlContent":["All channels have been set inhibited, so no tightening can be started."],"lexiconLinks":[]},"procedure":{"content":["Set at least one channel to not be inhibited."],"htmlContent":["Set at least one channel to not be inhibited."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex","Synchronized tightening"],"htmlContent":["Flex","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-177","title":"Event Codes","event-code":{"content":["3064"],"htmlContent":["3064"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier Number Faulty"],"htmlContent":["Carrier Number Faulty"],"lexiconLinks":[]},"description":{"content":["A FlexCarrier hex switch is set to zero."],"htmlContent":["A FlexCarrier hex switch is set to zero."],"lexiconLinks":[]},"procedure":{"content":["Turn the switch to a non-zero value."],"htmlContent":["Turn the switch to a non-zero value."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-178","title":"Event Codes","event-code":{"content":["3065"],"htmlContent":["3065"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier E-Stop Configuration Plug Wrong Type Or Missing"],"htmlContent":["Carrier E-Stop Configuration Plug Wrong Type Or Missing"],"lexiconLinks":[]},"description":{"content":["A Carrier is missing its E-stop configuration plug, or the plug type is wrong."],"htmlContent":["A Carrier is missing its E-stop configuration plug, or the plug type is wrong."],"lexiconLinks":[]},"procedure":{"content":["Insert correct plug type."],"htmlContent":["Insert correct plug type."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-179","title":"Event Codes","event-code":{"content":["3066"],"htmlContent":["3066"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier Voltage Inlet: No 3-Phase AC"],"htmlContent":["Carrier Voltage Inlet: No 3-Phase AC"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Ensure the 3-phase power to the carrier is within acceptable limits and fully functional. Ensure the 3-phase cables are in good condition and properly connected."],"htmlContent":["Ensure the 3-phase power to the carrier is within acceptable limits and fully functional. Ensure the 3-phase cables are in good condition and properly connected."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-180","title":"Event Codes","event-code":{"content":["3067"],"htmlContent":["3067"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier Voltage Inlet: One AC Phase Missing"],"htmlContent":["Carrier Voltage Inlet: One AC Phase Missing"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Ensure the 3-phase power to the carrier is within acceptable limits and fully functional. Ensure the 3-phase cables are in good condition and properly connected."],"htmlContent":["Ensure the 3-phase power to the carrier is within acceptable limits and fully functional. Ensure the 3-phase cables are in good condition and properly connected."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-181","title":"Event Codes","event-code":{"content":["3068"],"htmlContent":["3068"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier: Internal 24 VDC Power Supply Unit Broken"],"htmlContent":["Carrier: Internal 24 VDC Power Supply Unit Broken"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Service the carrier."],"htmlContent":["Service the carrier."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-182","title":"Event Codes","event-code":{"content":["3069"],"htmlContent":["3069"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier 24 Voltage OUT-Port Disabled Due To Over-Current"],"htmlContent":["Carrier 24 Voltage OUT-Port Disabled Due To Over-Current"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Reset the system."],"htmlContent":["Reset the system."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-183","title":"Event Codes","event-code":{"content":["3070"],"htmlContent":["3070"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier, Hardware Error In PF6 FlexControl Cable OUT"],"htmlContent":["Carrier, Hardware Error In PF6 FlexControl Cable OUT"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Reset the system."],"htmlContent":["Reset the system."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-184","title":"Event Codes","event-code":{"content":["3071"],"htmlContent":["3071"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier, Hardware Error In PF6 FlexControl Cable IN"],"htmlContent":["Carrier, Hardware Error In PF6 FlexControl Cable IN"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Reset the system."],"htmlContent":["Reset the system."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-185","title":"Event Codes","event-code":{"content":["3072"],"htmlContent":["3072"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Emergency Stop 24 VDC Power Failure Due To Short-Circuit"],"htmlContent":["Emergency Stop 24 VDC Power Failure Due To Short-Circuit"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Service the carrier."],"htmlContent":["Service the carrier."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-186","title":"Event Codes","event-code":{"content":["3073"],"htmlContent":["3073"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Unable To Start: System Is Emergency Stopped"],"htmlContent":["Unable To Start: System Is Emergency Stopped"],"lexiconLinks":[]},"description":{"content":["When allocating multiple spindles, this event is invoked by \"preStartCheckFailed\" due to emergency stop. "],"htmlContent":["When allocating multiple spindles, this event is invoked by \"preStartCheckFailed\" due to emergency stop. "],"lexiconLinks":[]},"procedure":{"content":["Reset the emergency stop."],"htmlContent":["Reset the emergency stop."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex","Synchronized tightening"],"htmlContent":["Flex","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-187","title":"Event Codes","event-code":{"content":["3074"],"htmlContent":["3074"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier Overheated"],"htmlContent":["Carrier Overheated"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Cool down."],"htmlContent":["Cool down."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-188","title":"Event Codes","event-code":{"content":["3075"],"htmlContent":["3075"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier Temperature OK"],"htmlContent":["Carrier Temperature OK"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-189","title":"Event Codes","event-code":{"content":["3076"],"htmlContent":["3076"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier: Internal 24 VDC Power Supply Overload"],"htmlContent":["Carrier: Internal 24 VDC Power Supply Overload"],"lexiconLinks":[]},"description":{"content":["Current output from internal PSU is too high."],"htmlContent":["Current output from internal PSU is too high."],"lexiconLinks":[]},"procedure":{"content":["Disconnect other carriers that are powered from the PSU. Disconnect any external equipment using 24 VDC."],"htmlContent":["Disconnect other carriers that are powered from the PSU. Disconnect any external equipment using 24 VDC."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-190","title":"Event Codes","event-code":{"content":["3077"],"htmlContent":["3077"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier: Internal 24 VDC Power Supply Over Voltage"],"htmlContent":["Carrier: Internal 24 VDC Power Supply Over Voltage"],"lexiconLinks":[]},"description":{"content":["Voltage output from internal PSU is too high."],"htmlContent":["Voltage output from internal PSU is too high."],"lexiconLinks":[]},"procedure":{"content":["Replace the carrier."],"htmlContent":["Replace the carrier."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-191","title":"Event Codes","event-code":{"content":["3078"],"htmlContent":["3078"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier: Internal 24 VDC Power Supply Under Voltage"],"htmlContent":["Carrier: Internal 24 VDC Power Supply Under Voltage"],"lexiconLinks":[]},"description":{"content":["Voltage output from internal PSU is too low."],"htmlContent":["Voltage output from internal PSU is too low."],"lexiconLinks":[]},"procedure":{"content":["Replace the carrier."],"htmlContent":["Replace the carrier."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-192","title":"Event Codes","event-code":{"content":["3079"],"htmlContent":["3079"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["External Supply To Carrier: 24 VDC Over Voltage"],"htmlContent":["External Supply To Carrier: 24 VDC Over Voltage"],"lexiconLinks":[]},"description":{"content":["Backup input voltage is more than 27 VDC."],"htmlContent":["Backup input voltage is more than 27 VDC."],"lexiconLinks":[]},"procedure":{"content":["Adjust the backup input voltage."],"htmlContent":["Adjust the backup input voltage."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-193","title":"Event Codes","event-code":{"content":["3080"],"htmlContent":["3080"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["External Supply To Carrier: 24 VDC Under Voltage"],"htmlContent":["External Supply To Carrier: 24 VDC Under Voltage"],"lexiconLinks":[]},"description":{"content":["Backup input voltage is less than 19 VDC."],"htmlContent":["Backup input voltage is less than 19 VDC."],"lexiconLinks":[]},"procedure":{"content":["Adjust the backup input voltage."],"htmlContent":["Adjust the backup input voltage."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-194","title":"Event Codes","event-code":{"content":["3081"],"htmlContent":["3081"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier Voltage Inlet: 3-Phase AC Over Voltage"],"htmlContent":["Carrier Voltage Inlet: 3-Phase AC Over Voltage"],"lexiconLinks":[]},"description":{"content":["Input voltage is too high."],"htmlContent":["Input voltage is too high."],"lexiconLinks":[]},"procedure":{"content":["Lower input voltage: must be 400 VAC or 480 VAC."],"htmlContent":["Lower input voltage: must be 400 VAC or 480 VAC."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-195","title":"Event Codes","event-code":{"content":["3082"],"htmlContent":["3082"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier Voltage Inlet: 3-Phase AC Under Voltage"],"htmlContent":["Carrier Voltage Inlet: 3-Phase AC Under Voltage"],"lexiconLinks":[]},"description":{"content":["Input voltage is too low."],"htmlContent":["Input voltage is too low."],"lexiconLinks":[]},"procedure":{"content":["Higher input voltage: must be 400 VAC or 480 VAC."],"htmlContent":["Higher input voltage: must be 400 VAC or 480 VAC."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-196","title":"Event Codes","event-code":{"content":["3083"],"htmlContent":["3083"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Wrong Anybus\/Profisafe Module Firmware"],"htmlContent":["Wrong Anybus\/Profisafe Module Firmware"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Update the firmware in the anybus module to the latest version."],"htmlContent":["Update the firmware in the anybus module to the latest version."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-197","title":"Event Codes","event-code":{"content":["3084"],"htmlContent":["3084"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Soft PLC Runtime Error"],"htmlContent":["Soft PLC Runtime Error"],"lexiconLinks":[]},"description":{"content":["eCLR has terminated in an uncontrolled way."],"htmlContent":["eCLR has terminated in an uncontrolled way."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-198","title":"Event Codes","event-code":{"content":["3085"],"htmlContent":["3085"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier: Fan Module Out Of Order"],"htmlContent":["Carrier: Fan Module Out Of Order"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Replace fan module."],"htmlContent":["Replace fan module."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-199","title":"Event Codes","event-code":{"content":["3086"],"htmlContent":["3086"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier: Fan Module Partly Out Of Order"],"htmlContent":["Carrier: Fan Module Partly Out Of Order"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Replace fan module."],"htmlContent":["Replace fan module."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-200","title":"Event Codes","event-code":{"content":["3087"],"htmlContent":["3087"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier: Left Fan Module Out Of Order"],"htmlContent":["Carrier: Left Fan Module Out Of Order"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Replace fan module."],"htmlContent":["Replace fan module."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-201","title":"Event Codes","event-code":{"content":["3088"],"htmlContent":["3088"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier: Left Fan Module Partly Out Of Order"],"htmlContent":["Carrier: Left Fan Module Partly Out Of Order"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Replace fan module."],"htmlContent":["Replace fan module."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-202","title":"Event Codes","event-code":{"content":["3089"],"htmlContent":["3089"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier: Right Fan Module Out Of Order"],"htmlContent":["Carrier: Right Fan Module Out Of Order"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Replace fan module."],"htmlContent":["Replace fan module."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-203","title":"Event Codes","event-code":{"content":["3090"],"htmlContent":["3090"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Carrier: Right Fan Module Partly Out Of Order"],"htmlContent":["Carrier: Right Fan Module Partly Out Of Order"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Replace fan module."],"htmlContent":["Replace fan module."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex"],"htmlContent":["Flex"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-204","title":"Event Codes","event-code":{"content":["3091"],"htmlContent":["3091"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Sync member channel collision"],"htmlContent":["Sync member channel collision"],"lexiconLinks":[]},"description":{"content":["Generated when two or more sync members are configured to the same channel."],"htmlContent":["Generated when two or more sync members are configured to the same channel."],"lexiconLinks":[]},"procedure":{"content":["Reconfigure the colliding sync member to have a unique or different channel that has not been allocated to another sync member."],"htmlContent":["Reconfigure the colliding sync member to have a unique or different channel that has not been allocated to another sync member."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Conf","Display","Ack"],"htmlContent":["Log","Conf","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 8","Synchronized tightening","ToolsControl"],"htmlContent":["Power Focus 8","Synchronized tightening","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-205","title":"Event Codes","event-code":{"content":["3095"],"htmlContent":["3095"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["WiFi Signal Strength Low"],"htmlContent":["WiFi Signal Strength Low"],"lexiconLinks":[]},"description":{"content":["The wireless network signal strength is below the value set in setting \"Warn on signal strength below (dBm)\"."],"htmlContent":["The wireless network signal strength is below the value set in setting \"Warn on signal strength below (dBm)\"."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","STRw"],"htmlContent":["IxB","STRw"],"lexiconLinks":[]},"group":{"content":["Controller and Tool"],"htmlContent":["Controller and Tool"],"lexiconLinks":[]}},{"id":"64568843-206","title":"Event Codes","event-code":{"content":["3096"],"htmlContent":["3096"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Cellular signal strength low"],"htmlContent":["Cellular signal strength low"],"lexiconLinks":[]},"description":{"content":["The RSSI value for the cellular connection is under the defined threshold value of -98 dBm."],"htmlContent":["The RSSI value for the cellular connection is under the defined threshold value of -98 dBm."],"lexiconLinks":[]},"procedure":{"content":["Move the tool closer to the cellular antennas for a stronger connection and avoid data loss."],"htmlContent":["Move the tool closer to the cellular antennas for a stronger connection and avoid data loss."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-207","title":"Event Codes","event-code":{"content":["3097"],"htmlContent":["3097"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Cellular connection lost"],"htmlContent":["Cellular connection lost"],"lexiconLinks":[]},"description":{"content":["The system lost connection to the cellular network."],"htmlContent":["The system lost connection to the cellular network."],"lexiconLinks":[]},"procedure":{"content":["Move the tool closer to the cellular antennas. Check the cellular connection setup so correct APN is still configured. Check the cellular network for any problems."],"htmlContent":["<ul class='unordered'><li>Move the tool closer to the cellular antennas. <\/li><li>Check the cellular connection setup so correct APN is still configured. <\/li><li>Check the cellular network for any problems.<\/li><\/ul>"],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB"],"htmlContent":["IxB"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-208","title":"Event Codes","event-code":{"content":["3100"],"htmlContent":["3100"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Mode Configuration Does Not Exist"],"htmlContent":["Mode Configuration Does Not Exist"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Select an existing sync mode before starting a tightening."],"htmlContent":["Select an existing sync mode before starting a tightening."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Flex","Synchronized tightening"],"htmlContent":["Flex","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-209","title":"Event Codes","event-code":{"content":["3150"],"htmlContent":["3150"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Software IAM Incompatibility"],"htmlContent":["Software IAM Incompatibility"],"lexiconLinks":[]},"description":{"content":["IAM is incompatible with the software that is installed on the controller."],"htmlContent":["IAM is incompatible with the software that is installed on the controller."],"lexiconLinks":[]},"procedure":{"content":["Replace IAM."],"htmlContent":["Replace IAM."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-210","title":"Event Codes","event-code":{"content":["3160"],"htmlContent":["3160"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Failed To Activate Newly Installed Software"],"htmlContent":["Failed To Activate Newly Installed Software"],"lexiconLinks":[]},"description":{"content":["Something went wrong during the activation. When the newly installed software starts, a fallback to the previous working software happens. This error happens when the new software fails to start for three times and only during software installation."],"htmlContent":["Something went wrong during the activation. When the newly installed software starts, a fallback to the previous working software happens. This error happens when the new software fails to start for three times and only during software installation."],"lexiconLinks":[]},"procedure":{"content":["Take an export and contact Atlas Copco for further assistance. Note down the software version you are trying to install as well as the software version that is working."],"htmlContent":["Take an export and contact Atlas Copco for further assistance. Note down the software version you are trying to install as well as the software version that is working."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-211","title":"Event Codes","event-code":{"content":["3161"],"htmlContent":["3161"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Started On Unexpected Software Partition"],"htmlContent":["Started On Unexpected Software Partition"],"lexiconLinks":[]},"description":{"content":["The controller has started on the inactive software side and not on the expected software side."],"htmlContent":["The controller has started on the inactive software side and not on the expected software side."],"lexiconLinks":[]},"procedure":{"content":["Note down the software information (on the Home screen of the controller, select Controller > Software). Try to restart the controller and make sure its running on correct software when started again. If error persists, do an export and contact Atlas Copco."],"htmlContent":["Note down the software information (on the Home screen of the controller, select Controller > Software). Try to restart the controller and make sure its running on correct software when started again. If error persists, do an export and contact Atlas Copco."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-212","title":"Event Codes","event-code":{"content":["3162"],"htmlContent":["3162"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Software Upgrade Verification Failed"],"htmlContent":["Software Upgrade Verification Failed"],"lexiconLinks":[]},"description":{"content":["Failed to verify the integrity and authenticity of the software package. "],"htmlContent":["Failed to verify the integrity and authenticity of the software package. "],"lexiconLinks":[]},"procedure":{"content":["Ensure that the software package that is being upgraded to is a signed, software package. Note down the software information (on the Home screen of the controller, select Controller > Software). If error persists, do an export and contact Atlas Copco."],"htmlContent":["Ensure that the software package that is being upgraded to is a signed, software package. Note down the software information (on the Home screen of the controller, select Controller > Software). If error persists, do an export and contact Atlas Copco."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-213","title":"Event Codes","event-code":{"content":["3180"],"htmlContent":["3180"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Software Adapter Import Verification Failed"],"htmlContent":["Software Adapter Import Verification Failed"],"lexiconLinks":[]},"description":{"content":["Failed to verify the integrity and authenticity of the imported protocol adapters. "],"htmlContent":["Failed to verify the integrity and authenticity of the imported protocol adapters. "],"lexiconLinks":[]},"procedure":{"content":["Make sure that the protocol adapters that are being imported are signed, protocol adapters. If error persists, do an export and contact Atlas Copco."],"htmlContent":["Make sure that the protocol adapters that are being imported are signed, protocol adapters. If error persists, do an export and contact Atlas Copco."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-214","title":"Event Codes","event-code":{"content":["3500"],"htmlContent":["3500"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Generic License Manager Error"],"htmlContent":["Generic License Manager Error"],"lexiconLinks":[]},"description":{"content":["Inconsistency detected in the feature management system used."],"htmlContent":["Inconsistency detected in the feature management system used."],"lexiconLinks":[]},"procedure":{"content":["Contact Atlas Copco representative."],"htmlContent":["Contact Atlas Copco representative."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-215","title":"Event Codes","event-code":{"content":["3501"],"htmlContent":["3501"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["License Manager Synchronization Error"],"htmlContent":["License Manager Synchronization Error"],"lexiconLinks":[]},"description":{"content":["Synchronization with the license server failed."],"htmlContent":["Synchronization with the license server failed."],"lexiconLinks":[]},"procedure":{"content":["Contact Atlas Copco service representative."],"htmlContent":["Contact Atlas Copco service representative."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-216","title":"Event Codes","event-code":{"content":["3502"],"htmlContent":["3502"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["License Manager Synchronization Done"],"htmlContent":["License Manager Synchronization Done"],"lexiconLinks":[]},"description":{"content":["Synchronization with the license server completed."],"htmlContent":["Synchronization with the license server completed."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":[],"htmlContent":[],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-217","title":"Event Codes","event-code":{"content":["3503"],"htmlContent":["3503"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["License Manager: Another Source in Use"],"htmlContent":["License Manager: Another Source in Use"],"lexiconLinks":[]},"description":{"content":["License is used by another source."],"htmlContent":["License is used by another source."],"lexiconLinks":[]},"procedure":{"content":["Verify license assignment."],"htmlContent":["Verify license assignment."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-218","title":"Event Codes","event-code":{"content":["3504"],"htmlContent":["3504"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["License Manager Restart Needed"],"htmlContent":["License Manager Restart Needed"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Restart license manager."],"htmlContent":["Restart license manager."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-219","title":"Event Codes","event-code":{"content":["3505"],"htmlContent":["3505"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["USB License Synchronization Started"],"htmlContent":["USB License Synchronization Started"],"lexiconLinks":[]},"description":{"content":["Moving licenses from the USB license dongle started."],"htmlContent":["Moving licenses from the USB license dongle started."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log"],"htmlContent":["Log"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","PFHC"],"htmlContent":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","PFHC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-220","title":"Event Codes","event-code":{"content":["3506"],"htmlContent":["3506"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["USB License Synchronization Error"],"htmlContent":["USB License Synchronization Error"],"lexiconLinks":[]},"description":{"content":["Moving licenses from the USB license dongle failed."],"htmlContent":["Moving licenses from the USB license dongle failed."],"lexiconLinks":[]},"procedure":{"content":["Contact Atlas Copco service representative."],"htmlContent":["Contact Atlas Copco service representative."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log"],"htmlContent":["Log"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","PFHC"],"htmlContent":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl","PFHC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-221","title":"Event Codes","event-code":{"content":["3507"],"htmlContent":["3507"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["USB License Synchronization Done"],"htmlContent":["USB License Synchronization Done"],"lexiconLinks":[]},"description":{"content":["Moving licenses from the USB license dongle done."],"htmlContent":["Moving licenses from the USB license dongle done."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log"],"htmlContent":["Log"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","PFHC"],"htmlContent":["Power Focus 6000","Power Focus 8","PFHC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-222","title":"Event Codes","event-code":{"content":["3508"],"htmlContent":["3508"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["One or more of your licenses are about to expire. Please make sure you have a license server configured"],"htmlContent":["One or more of your licenses are about to expire. Please make sure you have a license server configured"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Update licenses."],"htmlContent":["Update licenses."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-223","title":"Event Codes","event-code":{"content":["3510"],"htmlContent":["3510"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["There is already a Local License Server in use. Return all licenses to the server prior to configuring a new one."],"htmlContent":["There is already a Local License Server in use. Return all licenses to the server prior to configuring a new one."],"lexiconLinks":[]},"description":{"content":["Inconsistency detected in a license to be used during configuration."],"htmlContent":["Inconsistency detected in a license to be used during configuration."],"lexiconLinks":[]},"procedure":{"content":["Update licenses."],"htmlContent":["Update licenses."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["ToolsControl"],"htmlContent":["ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller"],"htmlContent":["Controller"],"lexiconLinks":[]}},{"id":"64568843-224","title":"Event Codes","event-code":{"content":["3511"],"htmlContent":["3511"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["One of your licenses has a different license definition"],"htmlContent":["One of your licenses has a different license definition"],"lexiconLinks":[]},"description":{"content":["Inconsistency detected in a license to be used."],"htmlContent":["Inconsistency detected in a license to be used."],"lexiconLinks":[]},"procedure":{"content":["Contact Atlas Copco representative."],"htmlContent":["Contact Atlas Copco representative."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl","PFHC"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl","PFHC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-225","title":"Event Codes","event-code":{"content":["3512"],"htmlContent":["3512"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["Unexpected license service error. Contact Atlas Copco for further assistance."],"htmlContent":["Unexpected license service error. Contact Atlas Copco for further assistance."],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Contact Atlas Copco representative."],"htmlContent":["Contact Atlas Copco representative."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Conf","Display","Ack"],"htmlContent":["Log","Conf","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["ToolsControl"],"htmlContent":["ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller"],"htmlContent":["Controller"],"lexiconLinks":[]}},{"id":"64568843-226","title":"Event Codes","event-code":{"content":["3550"],"htmlContent":["3550"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["License Is Missing"],"htmlContent":["License Is Missing"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Install the correct license."],"htmlContent":["Install the correct license."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl","PFHC"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl","PFHC"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-227","title":"Event Codes","event-code":{"content":["3551"],"htmlContent":["3551"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Wireless Communication Disabled By Licensing"],"htmlContent":["Wireless Communication Disabled By Licensing"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Unassign Standalone license from the Virtual Station."],"htmlContent":["Unassign Standalone license from the Virtual Station."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller, Drive and Synchronized tightening"],"htmlContent":["Controller, Drive and Synchronized tightening"],"lexiconLinks":[]}},{"id":"64568843-228","title":"Event Codes","event-code":{"content":["3600"],"htmlContent":["3600"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["System restart triggered by user"],"htmlContent":["System restart triggered by user"],"lexiconLinks":[]},"description":{"content":["Restart is triggered as a consequence of a user action within the system, such as:After importing an export.Activating new software after software update.Swapping software side.Performing a service task that require a system restart.Open end tuning on IxB.Switching from WiFi to Bluetooth on IxB."],"htmlContent":["Restart is triggered as a consequence of a user action within the system, such as:<ul class='unordered'><li>After importing an export.<\/li><li>Activating new software after software update.<\/li><li>Swapping software side.<\/li><li>Performing a service task that require a system restart.<\/li><li>Open end tuning on IxB.<\/li><li>Switching from WiFi to Bluetooth on IxB.<\/li><\/ul>"],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Conf"],"htmlContent":["Log","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC"],"lexiconLinks":[]},"group":{"content":["Controller and Tool"],"htmlContent":["Controller and Tool"],"lexiconLinks":[]}},{"id":"64568843-229","title":"Event Codes","event-code":{"content":["3601"],"htmlContent":["3601"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Unexpected system shut down"],"htmlContent":["Unexpected system shut down"],"lexiconLinks":[]},"description":{"content":["The system rebooted or shut down unexpectedly"],"htmlContent":["The system rebooted or shut down unexpectedly"],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Conf"],"htmlContent":["Log","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller and Tool"],"htmlContent":["Controller and Tool"],"lexiconLinks":[]}},{"id":"64568843-230","title":"Event Codes","event-code":{"content":["3610"],"htmlContent":["3610"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["System shut down due to power loss"],"htmlContent":["System shut down due to power loss"],"lexiconLinks":[]},"description":{"content":["Power switch is pressed or controller is disconnected from power source"],"htmlContent":["Power switch is pressed or controller is disconnected from power source"],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Conf"],"htmlContent":["Log","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller and Tool"],"htmlContent":["Controller and Tool"],"lexiconLinks":[]}},{"id":"64568843-231","title":"Event Codes","event-code":{"content":["3611"],"htmlContent":["3611"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Backup battery timer timed out, shutting down"],"htmlContent":["Backup battery timer timed out, shutting down"],"lexiconLinks":[]},"description":{"content":["Tool have been runnning on backup battery for more than 20s"],"htmlContent":["Tool have been runnning on backup battery for more than 20s"],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Conf"],"htmlContent":["Log","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller and Tool"],"htmlContent":["Controller and Tool"],"lexiconLinks":[]}},{"id":"64568843-232","title":"Event Codes","event-code":{"content":["3612"],"htmlContent":["3612"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["System shut down due to inactivity"],"htmlContent":["System shut down due to inactivity"],"lexiconLinks":[]},"description":{"content":["Inactivity timeout has expired"],"htmlContent":["Inactivity timeout has expired"],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Conf"],"htmlContent":["Log","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Controller and Tool"],"htmlContent":["Controller and Tool"],"lexiconLinks":[]}},{"id":"64568843-233","title":"Event Codes","event-code":{"content":["4010"],"htmlContent":["4010"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tool Locked By Digital Input"],"htmlContent":["Tool Locked By Digital Input"],"lexiconLinks":[]},"description":{"content":["The tool is locked by a digital input signal."],"htmlContent":["The tool is locked by a digital input signal."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-234","title":"Event Codes","event-code":{"content":["4011"],"htmlContent":["4011"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tool Locked By Open Protocol"],"htmlContent":["Tool Locked By Open Protocol"],"lexiconLinks":[]},"description":{"content":["The tool is locked by Open Protocol."],"htmlContent":["The tool is locked by Open Protocol."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-235","title":"Event Codes","event-code":{"content":["4012"],"htmlContent":["4012"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tool Locked By Fieldbus"],"htmlContent":["Tool Locked By Fieldbus"],"lexiconLinks":[]},"description":{"content":["The tool is locked by the Fieldbus."],"htmlContent":["The tool is locked by the Fieldbus."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-236","title":"Event Codes","event-code":{"content":["4013"],"htmlContent":["4013"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tool Locked By Socket Selector"],"htmlContent":["Tool Locked By Socket Selector"],"lexiconLinks":[]},"description":{"content":["Tool is locked when the socket selector is disconnected from the Virtual Station."],"htmlContent":["Tool is locked when the socket selector is disconnected from the Virtual Station."],"lexiconLinks":[]},"procedure":{"content":["Unlock by Master Unlock."],"htmlContent":["Unlock by Master Unlock."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-237","title":"Event Codes","event-code":{"content":["4014"],"htmlContent":["4014"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tool Locked By Soft PLC"],"htmlContent":["Tool Locked By Soft PLC"],"lexiconLinks":[]},"description":{"content":["Soft PLC signal locked the tool. "],"htmlContent":["Soft PLC signal locked the tool. "],"lexiconLinks":[]},"procedure":{"content":["Unlock by Master Unlock."],"htmlContent":["Unlock by Master Unlock."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-238","title":"Event Codes","event-code":{"content":["4015"],"htmlContent":["4015"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Loosening Disabled"],"htmlContent":["Loosening Disabled"],"lexiconLinks":[]},"description":{"content":["Loosening is disabled in the tightening program."],"htmlContent":["Loosening is disabled in the tightening program."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl","XB"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl","XB"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-239","title":"Event Codes","event-code":{"content":["4016"],"htmlContent":["4016"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tightening Disabled"],"htmlContent":["Tightening Disabled"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl","XB"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl","XB"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-240","title":"Event Codes","event-code":{"content":["4017"],"htmlContent":["4017"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Loosening Not Configured"],"htmlContent":["Loosening Not Configured"],"lexiconLinks":[]},"description":{"content":["Loosening is not configured in the selected tightening program"],"htmlContent":["Loosening is not configured in the selected tightening program"],"lexiconLinks":[]},"procedure":{"content":["Select different tightening program."],"htmlContent":["Select different tightening program."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-241","title":"Event Codes","event-code":{"content":["4020"],"htmlContent":["4020"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Too Many NOK Tightenings"],"htmlContent":["Too Many NOK Tightenings"],"lexiconLinks":[]},"description":{"content":["Maximum consecutive NOK tightenings in batch is exceeded"],"htmlContent":["Maximum consecutive NOK tightenings in batch is exceeded"],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-242","title":"Event Codes","event-code":{"content":["4021"],"htmlContent":["4021"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Too many consecutive loosenings"],"htmlContent":["Too many consecutive loosenings"],"lexiconLinks":[]},"description":{"content":["Maximum consecutive loosenings configured in General Virtual Station has been reached"],"htmlContent":["Maximum consecutive loosenings configured in General Virtual Station has been reached"],"lexiconLinks":[]},"procedure":{"content":["An external input has to unlock and reset by signal Reset too many loosening lock or Master unlock."],"htmlContent":["An external input has to unlock and reset by signal <span class='emphasis-general'>Reset too many loosening lock<\/span> or <span class='emphasis-general'>Master unlock<\/span>."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Sync","PFXC","Tools Control"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Sync","PFXC","Tools Control"],"lexiconLinks":[]},"group":{"content":["Group"],"htmlContent":["Group"],"lexiconLinks":[]}},{"id":"64568843-243","title":"Event Codes","event-code":{"content":["4025"],"htmlContent":["4025"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["No Tightening Program Selected"],"htmlContent":["No Tightening Program Selected"],"lexiconLinks":[]},"description":{"content":["No tightening program selected."],"htmlContent":["No tightening program selected."],"lexiconLinks":[]},"procedure":{"content":["Select tightening program or batch sequence."],"htmlContent":["Select tightening program or batch sequence."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Display","Conf"],"htmlContent":["Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-244","title":"Event Codes","event-code":{"content":["4030"],"htmlContent":["4030"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Batch Sequence Aborted"],"htmlContent":["Batch Sequence Aborted"],"lexiconLinks":[]},"description":{"content":["The batch sequence has been aborted."],"htmlContent":["The batch sequence has been aborted."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Conf"],"htmlContent":["Log","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-245","title":"Event Codes","event-code":{"content":["4031"],"htmlContent":["4031"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Max Time To Complete Batch Sequence Reached"],"htmlContent":["Max Time To Complete Batch Sequence Reached"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-246","title":"Event Codes","event-code":{"content":["4032"],"htmlContent":["4032"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Max Time To Complete First Tightening Reached"],"htmlContent":["Max Time To Complete First Tightening Reached"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-247","title":"Event Codes","event-code":{"content":["4035"],"htmlContent":["4035"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Locked By Line Control"],"htmlContent":["Locked By Line Control"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-248","title":"Event Codes","event-code":{"content":["4040"],"htmlContent":["4040"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Locked By Alternative Identifier"],"htmlContent":["Locked By Alternative Identifier"],"lexiconLinks":[]},"description":{"content":["Tool locked by alternative identifier."],"htmlContent":["Tool locked by alternative identifier."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-249","title":"Event Codes","event-code":{"content":["4050"],"htmlContent":["4050"],"lexiconLinks":[]},"event-type":{"content":[],"htmlContent":[],"lexiconLinks":[]},"event-name":{"content":["Invalid Socket Configuration"],"htmlContent":["Invalid Socket Configuration"],"lexiconLinks":[]},"description":{"content":["Tightening program assigned to multiple sockets."],"htmlContent":["Tightening program assigned to multiple sockets."],"lexiconLinks":[]},"procedure":{"content":["Tightening program assigned to multiple sockets."],"htmlContent":["Tightening program assigned to multiple sockets."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-250","title":"Event Codes","event-code":{"content":["4060"],"htmlContent":["4060"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tool Locked On Batch Complete"],"htmlContent":["Tool Locked On Batch Complete"],"lexiconLinks":[]},"description":{"content":["When running a batch with flag Tool lock on batch sequence complete this event is generated when the user press the trigger."],"htmlContent":["When running a batch with flag Tool lock on batch sequence complete this event is generated when the user press the trigger."],"lexiconLinks":[]},"procedure":{"content":["Unlock with signal Unlock Tool on complete."],"htmlContent":["Unlock with signal Unlock Tool on complete."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-251","title":"Event Codes","event-code":{"content":["4062"],"htmlContent":["4062"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tool Locked By Result Synchronization"],"htmlContent":["Tool Locked By Result Synchronization"],"lexiconLinks":[]},"description":{"content":["Results from tool are being synchronized with the controller."],"htmlContent":["Results from tool are being synchronized with the controller."],"lexiconLinks":[]},"procedure":{"content":["Wait until result sync is done to restart work."],"htmlContent":["Wait until result sync is done to restart work."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf","Ack"],"htmlContent":["Log","Display","Conf","Ack"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-252","title":"Event Codes","event-code":{"content":["4063"],"htmlContent":["4063"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tool Locked due to transducer redundancy error"],"htmlContent":["Tool Locked due to transducer redundancy error"],"lexiconLinks":[]},"description":{"content":["Tool is locked due toredundancy error."],"htmlContent":["Tool is locked due toredundancy error."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display"],"htmlContent":["Log","Display"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","ToolsControl"],"htmlContent":["Power Focus 6000","ToolsControl"],"lexiconLinks":[]},"group":{"content":[],"htmlContent":[],"lexiconLinks":[]}},{"id":"64568843-253","title":"Event Codes","event-code":{"content":["4064"],"htmlContent":["4064"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tool Locked by Automation Rules"],"htmlContent":["Tool Locked by Automation Rules"],"lexiconLinks":[]},"description":{"content":["Tool is locked by Automation rules."],"htmlContent":["Tool is locked by Automation rules."],"lexiconLinks":[]},"procedure":{"content":["No action"],"htmlContent":["No action"],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":[],"htmlContent":[],"lexiconLinks":[]}},{"id":"64568843-254","title":"Event Codes","event-code":{"content":["4070"],"htmlContent":["4070"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Process Enter Manual Mode"],"htmlContent":["Process Enter Manual Mode"],"lexiconLinks":[]},"description":{"content":["Indicates that manual mode has been activated for a virtual station."],"htmlContent":["Indicates that manual mode has been activated for a virtual station."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-255","title":"Event Codes","event-code":{"content":["4071"],"htmlContent":["4071"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Process Enter Automatic Mode"],"htmlContent":["Process Enter Automatic Mode"],"lexiconLinks":[]},"description":{"content":["Indicates that automatic mode has been entered for a virtual station."],"htmlContent":["Indicates that automatic mode has been entered for a virtual station."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-256","title":"Event Codes","event-code":{"content":["4072"],"htmlContent":["4072"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Test Bolt"],"htmlContent":["Test Bolt"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","Synchronized tightening"],"htmlContent":["Flex","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-257","title":"Event Codes","event-code":{"content":["4073"],"htmlContent":["4073"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tool zero position updated"],"htmlContent":["Tool zero position updated"],"lexiconLinks":[]},"description":{"content":["Indicates that the tool zero position is set using signals."],"htmlContent":["Indicates that the tool zero position is set using signals."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-258","title":"Event Codes","event-code":{"content":["4100"],"htmlContent":["4100"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Identifier Not Accepted: Invalid String Length"],"htmlContent":["Identifier Not Accepted: Invalid String Length"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Display","Conf"],"htmlContent":["Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-259","title":"Event Codes","event-code":{"content":["4101"],"htmlContent":["4101"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["String Selection Unsuccessful: Multiple Matches"],"htmlContent":["String Selection Unsuccessful: Multiple Matches"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Display","Conf"],"htmlContent":["Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-260","title":"Event Codes","event-code":{"content":["4102"],"htmlContent":["4102"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["String Selection Unsuccessful: No Match Found"],"htmlContent":["String Selection Unsuccessful: No Match Found"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Display","Conf"],"htmlContent":["Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-261","title":"Event Codes","event-code":{"content":["4103"],"htmlContent":["4103"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Identifier Not Accepted: Identical String Already Received"],"htmlContent":["Identifier Not Accepted: Identical String Already Received"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Display","Conf"],"htmlContent":["Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-262","title":"Event Codes","event-code":{"content":["4104"],"htmlContent":["4104"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Identifier Not Accepted: No Match Found"],"htmlContent":["Identifier Not Accepted: No Match Found"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Display","Conf"],"htmlContent":["Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-263","title":"Event Codes","event-code":{"content":["4500"],"htmlContent":["4500"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result DriveError"],"htmlContent":["Result DriveError"],"lexiconLinks":[]},"description":{"content":["Internal driver error or driver loss detected. "],"htmlContent":["Internal driver error or driver loss detected. "],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-264","title":"Event Codes","event-code":{"content":["4501"],"htmlContent":["4501"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Rehit"],"htmlContent":["Result Rehit"],"lexiconLinks":[]},"description":{"content":["Attempt to tighten an already tightened bolt when Rehit detection is on."],"htmlContent":["Attempt to tighten an already tightened bolt when Rehit detection is on."],"lexiconLinks":[]},"procedure":{"content":["Step Category for the Start Stage must be set to Soft Start."],"htmlContent":["Step Category for the Start Stage must be set to Soft Start."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-265","title":"Event Codes","event-code":{"content":["4502"],"htmlContent":["4502"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Soft Start Torque Low"],"htmlContent":["Result Soft Start Torque Low"],"lexiconLinks":[]},"description":{"content":["Soft start torque below minimum level."],"htmlContent":["Soft start torque below minimum level."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-266","title":"Event Codes","event-code":{"content":["4503"],"htmlContent":["4503"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Soft Start Torque High"],"htmlContent":["Result Soft Start Torque High"],"lexiconLinks":[]},"description":{"content":["Soft start torque exceeded maximum level."],"htmlContent":["Soft start torque exceeded maximum level."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-267","title":"Event Codes","event-code":{"content":["4504"],"htmlContent":["4504"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Self Tap Torque High"],"htmlContent":["Result Self Tap Torque High"],"lexiconLinks":[]},"description":{"content":["Self-tap torque exceeded maximum level."],"htmlContent":["Self-tap torque exceeded maximum level."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-268","title":"Event Codes","event-code":{"content":["4505"],"htmlContent":["4505"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Self Tap Torque Low"],"htmlContent":["Result Self Tap Torque Low"],"lexiconLinks":[]},"description":{"content":["Self-tap torque below minimum limit."],"htmlContent":["Self-tap torque below minimum limit."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-269","title":"Event Codes","event-code":{"content":["4506"],"htmlContent":["4506"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Safety Torque Low"],"htmlContent":["Result Safety Torque Low"],"lexiconLinks":[]},"description":{"content":["Automatically calculated torque value to ensure torque sensor is mounted correctly."],"htmlContent":["Automatically calculated torque value to ensure torque sensor is mounted correctly."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-270","title":"Event Codes","event-code":{"content":["4507"],"htmlContent":["4507"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Rundown Torque High"],"htmlContent":["Result Rundown Torque High"],"lexiconLinks":[]},"description":{"content":["Rundown torque exceeded maximum level."],"htmlContent":["Rundown torque exceeded maximum level."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-271","title":"Event Codes","event-code":{"content":["4508"],"htmlContent":["4508"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Rundown Angle High"],"htmlContent":["Result Rundown Angle High"],"lexiconLinks":[]},"description":{"content":["Rundown angle exceeded maximum level."],"htmlContent":["Rundown angle exceeded maximum level."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-272","title":"Event Codes","event-code":{"content":["4509"],"htmlContent":["4509"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Rundown Time High"],"htmlContent":["Result Rundown Time High"],"lexiconLinks":[]},"description":{"content":["Rundown time exceeded maximum limit."],"htmlContent":["Rundown time exceeded maximum limit."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-273","title":"Event Codes","event-code":{"content":["4510"],"htmlContent":["4510"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Rundown Time Low"],"htmlContent":["Result Rundown Time Low"],"lexiconLinks":[]},"description":{"content":["Rundown time below minimum limit."],"htmlContent":["Rundown time below minimum limit."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-274","title":"Event Codes","event-code":{"content":["4511"],"htmlContent":["4511"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Rundown Torque Low"],"htmlContent":["Result Rundown Torque Low"],"lexiconLinks":[]},"description":{"content":["Rundown torque below minimum level."],"htmlContent":["Rundown torque below minimum level."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-275","title":"Event Codes","event-code":{"content":["4512"],"htmlContent":["4512"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Rundown Angle Low"],"htmlContent":["Result Rundown Angle Low"],"lexiconLinks":[]},"description":{"content":["Rundown angle below minimum level."],"htmlContent":["Rundown angle below minimum level."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-276","title":"Event Codes","event-code":{"content":["4513"],"htmlContent":["4513"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Final Torque High"],"htmlContent":["Result Final Torque High"],"lexiconLinks":[]},"description":{"content":["Final step torque exceeded maximum level."],"htmlContent":["Final step torque exceeded maximum level."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-277","title":"Event Codes","event-code":{"content":["4514"],"htmlContent":["4514"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Final Angle High"],"htmlContent":["Result Final Angle High"],"lexiconLinks":[]},"description":{"content":["Final step angle exceeded maximum level."],"htmlContent":["Final step angle exceeded maximum level."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-278","title":"Event Codes","event-code":{"content":["4515"],"htmlContent":["4515"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Final Torque Low"],"htmlContent":["Result Final Torque Low"],"lexiconLinks":[]},"description":{"content":["Final step torque below minimum level."],"htmlContent":["Final step torque below minimum level."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-279","title":"Event Codes","event-code":{"content":["4516"],"htmlContent":["4516"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Final Angle Low"],"htmlContent":["Result Final Angle Low"],"lexiconLinks":[]},"description":{"content":["Final step angle below minimum level."],"htmlContent":["Final step angle below minimum level."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-280","title":"Event Codes","event-code":{"content":["4517"],"htmlContent":["4517"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Tightening Timeout"],"htmlContent":["Result Tightening Timeout"],"lexiconLinks":[]},"description":{"content":["Tightening time limit exceeded. For General Tightening Strategies max tightening time is 30 seconds. For Multistep max tightening time depends on step restriction Maximum Time Limit. Error code is dependent on tightening stage."],"htmlContent":["Tightening time limit exceeded. For General Tightening Strategies max tightening time is 30 seconds. For Multistep max tightening time depends on step restriction Maximum Time Limit. Error code is dependent on tightening stage."],"lexiconLinks":[]},"procedure":{"content":["Redo tightening."],"htmlContent":["Redo tightening."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-281","title":"Event Codes","event-code":{"content":["4518"],"htmlContent":["4518"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Trigger Lost"],"htmlContent":["Result Trigger Lost"],"lexiconLinks":[]},"description":{"content":["Tool trigger was released before target was reached.","For General Tightening Strategies it is not allowed to release the trigger before the tightening stage has finished.","For Multistep, the error is displayed when trigger is lost before the target in a specific step is reached."],"htmlContent":["Tool trigger was released before target was reached.","For General Tightening Strategies it is not allowed to release the trigger before the tightening stage has finished.","For Multistep, the error is displayed when trigger is lost before the target in a specific step is reached."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-282","title":"Event Codes","event-code":{"content":["4519"],"htmlContent":["4519"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Premature Torque Loss"],"htmlContent":["Premature Torque Loss"],"lexiconLinks":[]},"description":{"content":["Socket has slipped off the nut."],"htmlContent":["Socket has slipped off the nut."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-283","title":"Event Codes","event-code":{"content":["4520"],"htmlContent":["4520"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Target Reached Before Final Step"],"htmlContent":["Result Target Reached Before Final Step"],"lexiconLinks":[]},"description":{"content":["Target torque reached before final step in tightening program."],"htmlContent":["Target torque reached before final step in tightening program."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-284","title":"Event Codes","event-code":{"content":["4521"],"htmlContent":["4521"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Post View Torque Low"],"htmlContent":["Result Post View Torque Low"],"lexiconLinks":[]},"description":{"content":["Post view torque below minimum level."],"htmlContent":["Post view torque below minimum level."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-285","title":"Event Codes","event-code":{"content":["4522"],"htmlContent":["4522"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Post View Torque High"],"htmlContent":["Result Post View Torque High"],"lexiconLinks":[]},"description":{"content":["Post view torque exceeded maximum level."],"htmlContent":["Post view torque exceeded maximum level."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-286","title":"Event Codes","event-code":{"content":["4523"],"htmlContent":["4523"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Post View Torque Interval Not Reached"],"htmlContent":["Result Post View Torque Interval Not Reached"],"lexiconLinks":[]},"description":{"content":["Post view torque interval not reached."],"htmlContent":["Post view torque interval not reached."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-287","title":"Event Codes","event-code":{"content":["4524"],"htmlContent":["4524"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Torque Compensation Interval Not Reached"],"htmlContent":["Result Torque Compensation Interval Not Reached"],"lexiconLinks":[]},"description":{"content":["Torque compensation interval angle before rundown end not reached."],"htmlContent":["Torque compensation interval angle before rundown end not reached."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-288","title":"Event Codes","event-code":{"content":["4525"],"htmlContent":["4525"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Tool Movement Exceeded"],"htmlContent":["Result Tool Movement Exceeded"],"lexiconLinks":[]},"description":{"content":["From a NOK tightening detailed status."],"htmlContent":["From a NOK tightening detailed status."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-289","title":"Event Codes","event-code":{"content":["4526"],"htmlContent":["4526"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result SafetyCurrMon Sensor Mismatch"],"htmlContent":["Result SafetyCurrMon Sensor Mismatch"],"lexiconLinks":[]},"description":{"content":["Current monitoring error."],"htmlContent":["Current monitoring error."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":[],"htmlContent":[],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-290","title":"Event Codes","event-code":{"content":["4527"],"htmlContent":["4527"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Tool Movement Exceeded"],"htmlContent":["Result Tool Movement Exceeded"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":[],"htmlContent":[],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-291","title":"Event Codes","event-code":{"content":["4538"],"htmlContent":["4538"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Final Supervision Torque Low"],"htmlContent":["Result Final Supervision Torque Low"],"lexiconLinks":[]},"description":{"content":["Final Supervision Torque was not reached."],"htmlContent":["Final Supervision Torque was not reached."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-292","title":"Event Codes","event-code":{"content":["4543"],"htmlContent":["4543"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Snug Monitor High"],"htmlContent":["Result Snug Monitor High"],"lexiconLinks":[]},"description":{"content":["Wrench only. Monitor detected snug value exceeded."],"htmlContent":["Wrench only. Monitor detected snug value exceeded."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-293","title":"Event Codes","event-code":{"content":["4545"],"htmlContent":["4545"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result No Residual Torque"],"htmlContent":["Result No Residual Torque"],"lexiconLinks":[]},"description":{"content":["Wrench only. Residual torque was under threshold."],"htmlContent":["Wrench only. Residual torque was under threshold."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-294","title":"Event Codes","event-code":{"content":["4546"],"htmlContent":["4546"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Overspeed"],"htmlContent":["Result Overspeed"],"lexiconLinks":[]},"description":{"content":["Wrench only. Wrench gyro failed to measure angle due to high speed."],"htmlContent":["Wrench only. Wrench gyro failed to measure angle due to high speed."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-295","title":"Event Codes","event-code":{"content":["4547"],"htmlContent":["4547"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Effective Loosening"],"htmlContent":["Result Effective Loosening"],"lexiconLinks":[]},"description":{"content":["Wrench only. Wrench detected unexpected loosening."],"htmlContent":["Wrench only. Wrench detected unexpected loosening."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-296","title":"Event Codes","event-code":{"content":["4548"],"htmlContent":["4548"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Final Less Than Target"],"htmlContent":["Result Final Less Than Target"],"lexiconLinks":[]},"description":{"content":["Final torque is below target torque set in tightening program."],"htmlContent":["Final torque is below target torque set in tightening program."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-297","title":"Event Codes","event-code":{"content":["4549"],"htmlContent":["4549"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["TurboTight Time Limit Exceeded"],"htmlContent":["TurboTight Time Limit Exceeded"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-298","title":"Event Codes","event-code":{"content":["4550"],"htmlContent":["4550"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Rundown Pulses High"],"htmlContent":["Result Rundown Pulses High"],"lexiconLinks":[]},"description":{"content":["Maximum number of rundown pulses is exceeded."],"htmlContent":["Maximum number of rundown pulses is exceeded."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-299","title":"Event Codes","event-code":{"content":["4551"],"htmlContent":["4551"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Rundown Pulses Low"],"htmlContent":["Result Rundown Pulses Low"],"lexiconLinks":[]},"description":{"content":["Rundown is completed before the minimum number of rundown pulses is reached."],"htmlContent":["Rundown is completed before the minimum number of rundown pulses is reached."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-300","title":"Event Codes","event-code":{"content":["4552"],"htmlContent":["4552"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Final Pulses High"],"htmlContent":["Result Final Pulses High"],"lexiconLinks":[]},"description":{"content":["Maximum number of pulses is exceeded."],"htmlContent":["Maximum number of pulses is exceeded."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-301","title":"Event Codes","event-code":{"content":["4553"],"htmlContent":["4553"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Final Pulses Low"],"htmlContent":["Result Final Pulses Low"],"lexiconLinks":[]},"description":{"content":["Tightening is completed before the minimum number of pulses is reached."],"htmlContent":["Tightening is completed before the minimum number of pulses is reached."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-302","title":"Event Codes","event-code":{"content":["4554"],"htmlContent":["4554"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Current At Shutoff High"],"htmlContent":["Current At Shutoff High"],"lexiconLinks":[]},"description":{"content":["Current at shut off exceeded Current Limit High."],"htmlContent":["Current at shut off exceeded Current Limit High."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-303","title":"Event Codes","event-code":{"content":["4555"],"htmlContent":["4555"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Current At Shutoff Low"],"htmlContent":["Current At Shutoff Low"],"lexiconLinks":[]},"description":{"content":["Shut off current measured was below Current Limit Low."],"htmlContent":["Shut off current measured was below Current Limit Low."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-304","title":"Event Codes","event-code":{"content":["4556"],"htmlContent":["4556"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Uncategorized Multistep Error"],"htmlContent":["Uncategorized Multistep Error"],"lexiconLinks":[]},"description":{"content":["An error in the multistep configuration, often with tool validation."],"htmlContent":["An error in the multistep configuration, often with tool validation."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-305","title":"Event Codes","event-code":{"content":["4557"],"htmlContent":["4557"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Overload"],"htmlContent":["Result Overload"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-306","title":"Event Codes","event-code":{"content":["4559"],"htmlContent":["4559"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Result Stopped"],"htmlContent":["Result Stopped"],"lexiconLinks":[]},"description":{"content":["The event is triggered when an external stop signal or lock signal is aborting an ongoing tightening. The event is introduced to distinguish between trigger loss and external stop."],"htmlContent":["The event is triggered when an external stop signal or lock signal is aborting an ongoing tightening. The event is introduced to distinguish between trigger loss and external stop."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Conf"],"htmlContent":["Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-307","title":"Event Codes","event-code":{"content":["4600"],"htmlContent":["4600"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Data Drop or Data Hold used in combination with Batch Tightening. The signals have no effect"],"htmlContent":["Data Drop or Data Hold used in combination with Batch Tightening. The signals have no effect"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":["Data Drop and Data Hold are only supported for worktasks, without batch control. Select another worktask if the signals must be used."],"htmlContent":["Data Drop and Data Hold are only supported for worktasks, without batch control. Select another worktask if the signals must be used."],"lexiconLinks":[]},"log-display-ack-conf":{"content":[],"htmlContent":[],"lexiconLinks":[]},"available-for":{"content":["Flex","Synchronized tightening"],"htmlContent":["Flex","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-308","title":"Event Codes","event-code":{"content":["4601"],"htmlContent":["4601"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Data Hold Active: tightening result is sent once signal is low"],"htmlContent":["Data Hold Active: tightening result is sent once signal is low"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":[],"htmlContent":[],"lexiconLinks":[]},"available-for":{"content":["Flex","Synchronized tightening"],"htmlContent":["Flex","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-309","title":"Event Codes","event-code":{"content":["4602"],"htmlContent":["4602"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Data Drop active: tightening result discarded"],"htmlContent":["Data Drop active: tightening result discarded"],"lexiconLinks":[]},"description":{"content":[],"htmlContent":[],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":[],"htmlContent":[],"lexiconLinks":[]},"available-for":{"content":["Flex","Synchronized tightening"],"htmlContent":["Flex","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Tightening Process"],"htmlContent":["Tightening Process"],"lexiconLinks":[]}},{"id":"64568843-310","title":"Event Codes","event-code":{"content":["5010"],"htmlContent":["5010"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Invalid Tightening Program Parameter Value"],"htmlContent":["Invalid Tightening Program Parameter Value"],"lexiconLinks":[]},"description":{"content":["The parameter in the selected tightening program are invalid."],"htmlContent":["The parameter in the selected tightening program are invalid."],"lexiconLinks":[]},"procedure":{"content":["Check the configuration of the selected tightening program to find and to change the value of the parameter."],"htmlContent":["Check the configuration of the selected tightening program to find and to change the value of the parameter."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Program Configuration"],"htmlContent":["Program Configuration"],"lexiconLinks":[]}},{"id":"64568843-311","title":"Event Codes","event-code":{"content":["5011"],"htmlContent":["5011"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Couldn't prepare program storage in tool"],"htmlContent":["Couldn't prepare program storage in tool"],"lexiconLinks":[]},"description":{"content":["It is not possible to read the current program storage size in the tool, or to prepare the program storage for downloading the updated, or newly selected program to the tool."],"htmlContent":["It is not possible to read the current program storage size in the tool, or to prepare the program storage for downloading the updated, or newly selected program to the tool."],"lexiconLinks":[]},"procedure":{"content":["Check the tool for supported software version.Reboot the tool. Select the tightening program again. Check network connection for data consistency and quality."],"htmlContent":["<ul class='unordered'><li>Check the tool for supported software version.<\/li><li>Reboot the tool. <\/li><li>Select the tightening program again. <\/li><li>Check network connection for data consistency and quality.<\/li><\/ul>"],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Program Configuration"],"htmlContent":["Program Configuration"],"lexiconLinks":[]}},{"id":"64568843-312","title":"Event Codes","event-code":{"content":["5020"],"htmlContent":["5020"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Main Trigger Is Not The Active Start Source"],"htmlContent":["Main Trigger Is Not The Active Start Source"],"lexiconLinks":[]},"description":{"content":["Generated when configured for push start only and user presses main trigger. Will be generated until user presses the push start."],"htmlContent":["Generated when configured for push start only and user presses main trigger. Will be generated until user presses the push start."],"lexiconLinks":[]},"procedure":{"content":["Press push start to start the tool."],"htmlContent":["Press push start to start the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Program Configuration"],"htmlContent":["Program Configuration"],"lexiconLinks":[]}},{"id":"64568843-313","title":"Event Codes","event-code":{"content":["5030"],"htmlContent":["5030"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Tightening Program Complexity Exceeds Tool Capacity"],"htmlContent":["Tightening Program Complexity Exceeds Tool Capacity"],"lexiconLinks":[]},"description":{"content":["The selected tightening program is too complex for the STB tool that is used. Tool will be locked."],"htmlContent":["The selected tightening program is too complex for the STB tool that is used. Tool will be locked."],"lexiconLinks":[]},"procedure":{"content":["Reduce complexity of the tightening program, or choose different program."],"htmlContent":["Reduce complexity of the tightening program, or choose different program."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Program Configuration"],"htmlContent":["Program Configuration"],"lexiconLinks":[]}},{"id":"64568843-314","title":"Event Codes","event-code":{"content":["6010"],"htmlContent":["6010"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Accessory Connected"],"htmlContent":["Accessory Connected"],"lexiconLinks":[]},"description":{"content":["Accessory is connected to the controller."],"htmlContent":["Accessory is connected to the controller."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Accessory"],"htmlContent":["Accessory"],"lexiconLinks":[]}},{"id":"64568843-315","title":"Event Codes","event-code":{"content":["6020"],"htmlContent":["6020"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Accessory Disconnected"],"htmlContent":["Accessory Disconnected"],"lexiconLinks":[]},"description":{"content":["Accessory is disconnected from the controller."],"htmlContent":["Accessory is disconnected from the controller."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Accessory"],"htmlContent":["Accessory"],"lexiconLinks":[]}},{"id":"64568843-316","title":"Event Codes","event-code":{"content":["6021"],"htmlContent":["6021"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Fieldbus Offline"],"htmlContent":["Fieldbus Offline"],"lexiconLinks":[]},"description":{"content":["No communication with Fieldbus."],"htmlContent":["No communication with Fieldbus."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Accessory"],"htmlContent":["Accessory"],"lexiconLinks":[]}},{"id":"64568843-317","title":"Event Codes","event-code":{"content":["6030"],"htmlContent":["6030"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Accessory Address Collision"],"htmlContent":["Accessory Address Collision"],"lexiconLinks":[]},"description":{"content":["Two or more accessories with the same address are connected."],"htmlContent":["Two or more accessories with the same address are connected."],"lexiconLinks":[]},"procedure":{"content":["Change address on accessory."],"htmlContent":["Change address on accessory."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Accessory"],"htmlContent":["Accessory"],"lexiconLinks":[]}},{"id":"64568843-318","title":"Event Codes","event-code":{"content":["6040"],"htmlContent":["6040"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Accessory Communication Error"],"htmlContent":["Accessory Communication Error"],"lexiconLinks":[]},"description":{"content":["Intermittent communication error with accessory."],"htmlContent":["Intermittent communication error with accessory."],"lexiconLinks":[]},"procedure":{"content":["Check cables and connectors."],"htmlContent":["Check cables and connectors."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Accessory"],"htmlContent":["Accessory"],"lexiconLinks":[]}},{"id":"64568843-319","title":"Event Codes","event-code":{"content":["6041"],"htmlContent":["6041"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Fieldbus Error"],"htmlContent":["Fieldbus Error"],"lexiconLinks":[]},"description":{"content":["Communication error with Fieldbus."],"htmlContent":["Communication error with Fieldbus."],"lexiconLinks":[]},"procedure":{"content":[""],"htmlContent":[""],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Accessory"],"htmlContent":["Accessory"],"lexiconLinks":[]}},{"id":"64568843-320","title":"Event Codes","event-code":{"content":["6042"],"htmlContent":["6042"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Fieldbus Module Mismatch"],"htmlContent":["Fieldbus Module Mismatch"],"lexiconLinks":[]},"description":{"content":["The installed Fieldbus module does not match with the configured module."],"htmlContent":["The installed Fieldbus module does not match with the configured module."],"lexiconLinks":[]},"procedure":{"content":["Change the configuration to match with the installed module, or replace the installed module with the correct one."],"htmlContent":["Change the configuration to match with the installed module, or replace the installed module with the correct one."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Accessory"],"htmlContent":["Accessory"],"lexiconLinks":[]}},{"id":"64568843-321","title":"Event Codes","event-code":{"content":["6043"],"htmlContent":["6043"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Fieldbus Output Buffer Overflow"],"htmlContent":["Fieldbus Output Buffer Overflow"],"lexiconLinks":[]},"description":{"content":["The output buffer used for the Fieldbus communication is exhausted and an overflow of the buffer has occurred. One or more signal updates have been discarded."],"htmlContent":["The output buffer used for the Fieldbus communication is exhausted and an overflow of the buffer has occurred. One or more signal updates have been discarded."],"lexiconLinks":[]},"procedure":{"content":["Stop Fieldbus communication and Fieldbus diagnostics (if used) to recover the buffer.","If this event occurs frequently, check your Fieldbus communication setup, including the PLC program: too frequent updates compared to your update interval can lead to this scenario."],"htmlContent":["Stop Fieldbus communication and Fieldbus diagnostics (if used) to recover the buffer.","If this event occurs frequently, check your Fieldbus communication setup, including the PLC program: too frequent updates compared to your update interval can lead to this scenario."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening"],"lexiconLinks":[]},"group":{"content":["Accessory"],"htmlContent":["Accessory"],"lexiconLinks":[]}},{"id":"64568843-322","title":"Event Codes","event-code":{"content":["6044"],"htmlContent":["6044"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Fieldbus Provider ID mismatch"],"htmlContent":["Fieldbus Provider ID mismatch"],"lexiconLinks":[]},"description":{"content":["The installed Fieldbus module is not supported."],"htmlContent":["The installed Fieldbus module is not supported."],"lexiconLinks":[]},"procedure":{"content":["Connect a supported Atlas Copco fieldbus module."],"htmlContent":["Connect a supported Atlas Copco fieldbus module."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack"],"htmlContent":["Log","Display","Ack"],"lexiconLinks":[]},"available-for":{"content":["Power Focus 8"],"htmlContent":["Power Focus 8"],"lexiconLinks":[]},"group":{"content":["Accessory"],"htmlContent":["Accessory"],"lexiconLinks":[]}},{"id":"64568843-323","title":"Event Codes","event-code":{"content":["6050"],"htmlContent":["6050"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Wrong Socket Selected"],"htmlContent":["Wrong Socket Selected"],"lexiconLinks":[]},"description":{"content":["Generated when no or incorrect socket is selected."],"htmlContent":["Generated when no or incorrect socket is selected."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Accessory"],"htmlContent":["Accessory"],"lexiconLinks":[]}},{"id":"64568843-324","title":"Event Codes","event-code":{"content":["6090"],"htmlContent":["6090"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Barcode Scanner Could Not Be Identified"],"htmlContent":["Barcode Scanner Could Not Be Identified"],"lexiconLinks":[]},"description":{"content":["When no unique serial number is found."],"htmlContent":["When no unique serial number is found."],"lexiconLinks":[]},"procedure":{"content":["Configure the barcode reader device."],"htmlContent":["Configure the barcode reader device."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC"],"htmlContent":["Flex","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC"],"lexiconLinks":[]},"group":{"content":["Accessory"],"htmlContent":["Accessory"],"lexiconLinks":[]}},{"id":"64568843-325","title":"Event Codes","event-code":{"content":["6500"],"htmlContent":["6500"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Invalid Rule Configuration"],"htmlContent":["Invalid Rule Configuration"],"lexiconLinks":[]},"description":{"content":["Rule configuration is invalid if the virtual station mapped does not exist, invalid cease configuration or if the rule has no triggers or no actions"],"htmlContent":["Rule configuration is invalid if the virtual station mapped does not exist, invalid cease configuration or if the rule has no triggers or no actions"],"lexiconLinks":[]},"procedure":{"content":["Verify the configuration of the tool."],"htmlContent":["Verify the configuration of the tool."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":[],"htmlContent":[],"lexiconLinks":[]}},{"id":"64568843-326","title":"Event Codes","event-code":{"content":["6501"],"htmlContent":["6501"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Rule Triggered While Running"],"htmlContent":["Rule Triggered While Running"],"lexiconLinks":[]},"description":{"content":["Running rule is re-triggered by the same trigger."],"htmlContent":["Running rule is re-triggered by the same trigger."],"lexiconLinks":[]},"procedure":{"content":["Disable and enable the rule."],"htmlContent":["Disable and enable the rule."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Conf"],"htmlContent":["Log","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":[],"htmlContent":[],"lexiconLinks":[]}},{"id":"64568843-327","title":"Event Codes","event-code":{"content":["6502"],"htmlContent":["6502"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Failed to execute Action"],"htmlContent":["Failed to execute Action"],"lexiconLinks":[]},"description":{"content":["Rule fails to execute an event when it cannot perform an action on a deleted or non-existent virtual station. This occurs when the virtual station configured for the rule has been removed."],"htmlContent":["Rule fails to execute an event when it cannot perform an action on a deleted or non-existent virtual station. This occurs when the virtual station configured for the rule has been removed."],"lexiconLinks":[]},"procedure":{"content":["Action is corrected rule is disabled and enabled. "],"htmlContent":["Action is corrected rule is disabled and enabled. "],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":[],"htmlContent":[],"lexiconLinks":[]}},{"id":"64568843-328","title":"Event Codes","event-code":{"content":["6503"],"htmlContent":["6503"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Running Rule Deleted"],"htmlContent":["Running Rule Deleted"],"lexiconLinks":[]},"description":{"content":["This event occurs if a currently running rule is deleted. The action will not be reset if running rule is deleted. "],"htmlContent":["This event occurs if a currently running rule is deleted. The action will not be reset if running rule is deleted. "],"lexiconLinks":[]},"procedure":{"content":["No action."],"htmlContent":["No action."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Conf"],"htmlContent":["Log","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":[],"htmlContent":[],"lexiconLinks":[]}},{"id":"64568843-329","title":"Event Codes","event-code":{"content":["6504"],"htmlContent":["6504"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Running Rule Disabled"],"htmlContent":["Running Rule Disabled"],"lexiconLinks":[]},"description":{"content":[" This event occurs if a currently running rule is disabled. The action will not be reset if running rule is disabled."],"htmlContent":[" This event occurs if a currently running rule is disabled. The action will not be reset if running rule is disabled."],"lexiconLinks":[]},"procedure":{"content":["No action."],"htmlContent":["No action."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Conf"],"htmlContent":["Log","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":[],"htmlContent":[],"lexiconLinks":[]}},{"id":"64568843-330","title":"Event Codes","event-code":{"content":["6505"],"htmlContent":["6505"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Running Rule Updated"],"htmlContent":["Running Rule Updated"],"lexiconLinks":[]},"description":{"content":[" Running rule updated event if a currently running rule is updated. "],"htmlContent":[" Running rule updated event if a currently running rule is updated. "],"lexiconLinks":[]},"procedure":{"content":["No action."],"htmlContent":["No action."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Conf"],"htmlContent":["Log","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":[],"htmlContent":[],"lexiconLinks":[]}},{"id":"64568843-331","title":"Event Codes","event-code":{"content":["7010"],"htmlContent":["7010"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Message Text To Display"],"htmlContent":["Message Text To Display"],"lexiconLinks":[]},"description":{"content":["General event for displaying of messages."],"htmlContent":["General event for displaying of messages."],"lexiconLinks":[]},"procedure":{"content":[],"htmlContent":[],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Display","Ack","Conf"],"htmlContent":["Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","PFHC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Message"],"htmlContent":["Message"],"lexiconLinks":[]}},{"id":"64568843-332","title":"Event Codes","event-code":{"content":["8200"],"htmlContent":["8200"],"lexiconLinks":[]},"event-type":{"content":["Info"],"htmlContent":["Info"],"lexiconLinks":[]},"event-name":{"content":["Failed To Open Serial Port"],"htmlContent":["Failed To Open Serial Port"],"lexiconLinks":[]},"description":{"content":["Serial port to be used could not be opened."],"htmlContent":["Serial port to be used could not be opened."],"lexiconLinks":[]},"procedure":{"content":["Check serial port connections."],"htmlContent":["Check serial port connections."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Display","Conf"],"htmlContent":["Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC"],"lexiconLinks":[]},"group":{"content":["Miscellaneous"],"htmlContent":["Miscellaneous"],"lexiconLinks":[]}},{"id":"64568843-333","title":"Event Codes","event-code":{"content":["8300"],"htmlContent":["8300"],"lexiconLinks":[]},"event-type":{"content":["Warning"],"htmlContent":["Warning"],"lexiconLinks":[]},"event-name":{"content":["Open Protocol client communication timed out"],"htmlContent":["Open Protocol client communication timed out"],"lexiconLinks":[]},"description":{"content":["Communication to an Open Protocol client has timed out. No keep alive message or command sent within expected time."],"htmlContent":["Communication to an Open Protocol client has timed out. No keep alive message or command sent within expected time."],"lexiconLinks":[]},"procedure":{"content":["Check controller network connection.Check network setup: firewall and switches. Check client side application software."],"htmlContent":["<ul class='unordered'><li>Check controller network connection.<\/li><li>Check network setup: firewall and switches. <\/li><li>Check client side application software.<\/li><\/ul>"],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Conf"],"htmlContent":["Log","Display","Conf"],"lexiconLinks":[]},"available-for":{"content":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"htmlContent":["Flex","IxB","Power Focus 6000","Power Focus 8","Synchronized tightening","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Miscellaneous"],"htmlContent":["Miscellaneous"],"lexiconLinks":[]}},{"id":"64568843-334","title":"Event Codes","event-code":{"content":["8214"],"htmlContent":["8214"],"lexiconLinks":[]},"event-type":{"content":["Error"],"htmlContent":["Error"],"lexiconLinks":[]},"event-name":{"content":["EHMI Software Version Mismatch"],"htmlContent":["EHMI Software Version Mismatch"],"lexiconLinks":[]},"description":{"content":["EHMI software version does not match in compatibility with the controller."],"htmlContent":["EHMI software version does not match in compatibility with the controller."],"lexiconLinks":[]},"procedure":{"content":["Update the software version of the EHMI."],"htmlContent":["Update the software version of the EHMI."],"lexiconLinks":[]},"log-display-ack-conf":{"content":["Log","Display","Ack","Conf"],"htmlContent":["Log","Display","Ack","Conf"],"lexiconLinks":[]},"available-for":{"content":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"htmlContent":["IxB","Power Focus 6000","Power Focus 8","Power Focus XC","ToolsControl"],"lexiconLinks":[]},"group":{"content":["Miscellaneous"],"htmlContent":["Miscellaneous"],"lexiconLinks":[]}}]};