﻿contentPages = [{"id":"8850723979","fileName":"885072397923858328459.html","title":"Introduction","level":1,"position":1,"hasContent":false,"hierarchy":[],"content":"  In this section, you can find the basic information about the product and also the formatting conventions used in the topics. "},{"id":"19665264139","fileName":"19665264139.html","title":"General Description","level":2,"position":2,"hasContent":true,"hierarchy":["Introduction"],"content":" The Power Focus 6000 from Atlas Copco takes productivity, ergonomics, quality and connectivity to entirely new levels. The Power Focus 6000 connects a wide range of Atlas Copco assembly tools, giving you a single platform assembly solution. Using virtual stations each tool can have unique programing and operate independently, with several tools to one single controller. The perfect option for your smart connected assembly operation."},{"id":"78927883","fileName":"78927883.html","title":"Conventions","level":2,"position":3,"hasContent":true,"hierarchy":["Introduction"],"content":" To enhance user understanding, certain formatting conventions are used throughout this document. The formatting conventions used are listed below.  User Guide Conventions     Element  Notation  Description  Output    General emphasis  In the Programworkspace.  To make certain text elements stand out, or to highlight.  Text in Bold   Graphical User Interface (GUI) items  Select the Functionbutton.  Any reference to items found on screen in the GUI (for example, command buttons, icon names and field names).  Text in Bold   Graphical User Interface (GUI) Path >  Generally, on the top of the GUI.  Navigation aid which keeps track of the location in the GUI.  For example: Controller > Program > Edit   User input  Enter a Descriptionfor the program.  Any text input by the user.  Text in Bold   File names  Enter a File Namefor the export.  Files either exported from, or imported into the system.  Text in Bold Italic   Variable and parameter names  Enter a Namefor the export.  Variable and parameter names (not values).  Text in Italic   Variable and parameter values  Enter a VALUEfor the export.  Variable and parameter values.  Text in BOLD CAPS   System output   Client.Domain.Models.ExportImportConfiguration  Any text output by the system.  Text in Monospace   External links         Links to external sites that have information connected to the document or subject content. These could include:   Technical Product Data  Dimensional Drawings  Accessories  Product Specific Information  Selectable text to external sites   Internal documentation links      Relevant Information- links to information which is directly related to the current topic and needs to be considered for certain configurations that are made.   In this Section- links to all the topics within the section, which can be useful when understanding a feature, or configuration. If available, these links will be presented below the text.  Selectable text to internal content "},{"id":"7043427595","fileName":"7043427595.html","title":"General Data Protection Regulation (GDPR)","level":2,"position":4,"hasContent":true,"hierarchy":["Introduction"],"content":" This product offers the possibility to process personal identifiable information such as system user name, role and IP-address. The purpose of this processing capability could be to enhance quality control through traceability and proper access management. If you decide to process personal data you need to be aware of and comply with relevant personal data protection rules, including, in the EU the GDPR as well as other applicable laws, directives and regulations. Atlas Copco can in no way be held liable for any use made by you of the product."},{"id":"8955112331","fileName":"895511233123858382987.html","title":"Liabilities and Warnings","level":2,"position":5,"hasContent":false,"hierarchy":["Introduction"],"content":""},{"id":"2505623179","fileName":"2505623179.html","title":"Liability","level":3,"position":6,"hasContent":true,"hierarchy":["Introduction","Liabilities and Warnings"],"content":" Many events in the operating environment may affect the tightening process and shall require a validation of results. In compliance with applicable standards and\/or regulations, we hereby require you to check the installed torque and rotational direction after any event that can influence the tightening result. Examples of such events include but are not limited to:   initial installation of the tooling system  change of part batch, bolt, screw batch, tool, software, configuration or environment  change of air- or electrical connections  change in line ergonomics, process, quality procedures or practices  changing of operator  any other change that influences the result of the tightening process The check should:   Ensure that the joint conditions have not changed due to events of influence.  Be done after initial installation, maintenance or repair of the equipment.  Occur at least once per shift or at another suitable frequency."},{"id":"13413616779","fileName":"13413616779.html","title":"Warnings","level":3,"position":7,"hasContent":true,"hierarchy":["Introduction","Liabilities and Warnings"],"content":"  Changing parameters may lead to a decrease in tool performance and may also slow down the production.  Risk of Property Damage or Severe Injury  Ensure that you read, understand and follow all instructions before operating the tool. Failure to follow all the instructions may result in electric shock, fire, property damage and\/or severe bodily injury.   Read all Safety Information delivered together with the different parts of the system.  Read all Product Instructions for installation, operation and maintenance of the different parts of the system.  Read all locally legislated safety regulations regarding the system and parts thereof.  Save all Safety Information and instructions for future reference. "},{"id":"58897291","fileName":"58897291.html","title":"About the User Guide","level":2,"position":8,"hasContent":true,"hierarchy":["Introduction"],"content":" The User Guide describes how to set up and configure the POWER FOCUS 6000. It is intended for anyone operating or servicing the POWER FOCUS 6000.  In the Search window on the top menu bar, search for Product Essentials Tutorialsfor checking the available video tutorials. Each Product Essentials Tutorial will provide an overview of how to do a specific task with an Atlas Copco product. These tutorials are designed so that users can watch and follow along with their own equipment. The Product Essentials Tutorials are available online to ensure they are always available to users on-demand, and provide baseline knowledge needed to work with Atlas Copco products."},{"id":"9926714251","fileName":"9926714251.html","title":"Revision History","level":2,"position":9,"hasContent":true,"hierarchy":["Introduction"],"content":"      Release Number  Revision Date  Revision Description     item   item   none   3.10  06\/2023    NEW content:  Troubleshooting and Service > Troubleshooting Matrix   UPDATED content:  Working with the Virtual Station Tab > Configuring Protocols Window in a Virtual Station  Working with the Tool Tab > Tool Diagnostics  Reports and Statistics > Working with the Reports Tab > Events > Event Codes  Configuration > Working with the Settings Tab > Configuration of the Wireless Settings   3.9  01\/2023    NEW content:  Tool Tab > Tool Diagnostics  Tool Tab > Zero Position  Settings Tab > Configuration of IXB Connect  Configurations Tab > Tool Configuration > Configuration of the Dual Transducers  Tool Tab > Front End Configuration   UPDATED content:  Configurations Tab > General Virtual Station  Event Codes list  Tightening Tab > Multistep Programs > Tightening Steps (\"Tighten to Torque AND Angle\" and \"Tighten to Torque OR Angle\")  Third-Party Licenses  Multistep Programs > Step Monitors (A - Angle, PTCA - Post Thread Cut Angle)   DELETED content:  Open End Tuning   3.8  06\/2022    NEW content:  Controller Tab > Export \/ Import > Exporting \"System Logs and Information\"   UPDATED content:  Configurations Tab > Tool Configuration > Configuration of the Accessory Bus > ST Selector  Tightening Tab > Multistep Programs (new filterable tables for tightening steps, monitors and restrictions)  Configurations Tab > Tool Configuration > Configuration of the Open End  Event Codes list  Tightening Tab > Multistep Programs > Settings for a Multistep Program (NOK on trigger lost)  Input Signals - Power Focus 6000  Input Signals - StepSync  Output Signals - Power Focus 6000  Output Signals - StepSync  Controller Tab > StepSync  Controller Tab > StepSync > Tool Box for StepSync  Controller Tab > StepSync > StepSync Tightenings  Sources Tab   3.7  01\/2022    NEW content:  Configurations Tab > Tool Configuration > Configuration of the Open End  Settings Tab > Configuration of the Protocol > Configuring the Remote Logging Connection  Settings Tab > Configuration of the Extended Logging  Settings Tab > Configuration of the Extended Logging > Configuring the Log Groups   UPDATED content:  Multistep Programs > Tightening Steps (TC - Torque Calibration)  Multistep Programs > Step Monitors (C - Current, TC - Torque Calibration)  Multistep Programs > Settings for a Multistep Program (Program Monitor - Time, Program Restriction - Angle, Program Restriction - Time)  Multistep Programs > Step Restrictions (C - Current)  Event Codes list  Input Signals - Power Focus 6000  Input Signals - StepSync  Output Signals - Power Focus 6000  Output Signals - StepSync   3.6  06\/2021    UPDATED content:  Multistep Programs > Tightening Steps (Wait tightening step)  Multistep Programs > Step Restrictions (RH - Rehit, RT - Rescinding Torque)  Event Codes list  Input Signals - Power Focus 6000  Input Signals - StepSync  Output Signals - Power Focus 6000  Output Signals - StepSync  Input\/Output Signals - StepSync   DELETED content:  Four step tightening strategy   3.5  12\/2020   Added or updated paragraphs:  Updated \"Multistep Programs > Tightening Steps\" paragraph  Updated \"Multistep Programs > Step Monitors\" paragraph  Updated \"Multistep Programs > Step Restrictions\" paragraph  Updated \"Multistep Programs > Result Reporters\" paragraph  Updated \"Trigger Lost\" paragraph  Added \"Configuring Result Presentation Settings\" paragraph  Added \"Show Final Torque with PrT Compensation: ON \/ Show PrT Compensation Value on Live Result: ON\" paragraph  Added \"Show Final Torque with PrT Compensation: OFF \/ Show PrT Compensation Value on Live Result: ON\" paragraph  Added \"Show Final Torque with PrT Compensation: OFF \/ Show PrT Compensation Value on Live Result: OFF\" paragraph  Added \"Show Final Torque with PrT Compensation: ON \/ Show PrT Compensation Value on Live Result: OFF\" paragraph  Updated \"StepSync Signals > Input Signals\" paragraph  Updated \"StepSync Signals > Output Signals\" paragraph  Updated \"Configuring the ToolsTalk Connection\" paragraph  Updated \"Configuring the ToolsNet Connection\" paragraph  Updated \"Configuring the PIN\" paragraph  Updated \"Clear Results\" paragraph  Added \"Viewing Protocol Status\" paragraph  Updated \"Stored Results\" paragraph  Added \"Viewing Synchronized Traces\" paragraph  Updated \"Event Codes\" paragraph  Added \"SPC - Statistics Process Control\" paragraph  Added \"Configuring SPC Parameters\" paragraph  Added \"Configuring SPC Variables\" paragraph  Added \"Calculating Statistics\" paragraph  Added \"Viewing Statistics Results\" paragraph  Updated \"Input Signals\" paragraph  Updated \"Output Signals\" paragraph  Updated \"Input\/Output Signals\" paragraph   3.4  04\/2020   Added or updated paragraphs:  Updated \"Software\" paragraph  Updated \"Export\/Import\" paragraph  Added \"Exporting \"All Controller Information\"\" paragraph  Added \"Exporting \"Settings and Configurations\"\" paragraph  Added \"Exporting \"Logs from Connected Tools\"\" paragraph  Added \"Exporting \"Results\"\" paragraph  Added \"Importing Controller Configurations and Settings\" paragraph  Added \"Automated Backup\" paragraph  Added \"Supported Tools\" paragraph  Updated \"Tightening Steps\" paragraph  Updated \"Tool Motor Tuning\" paragraph  Added \"Open End Tuning\" paragraph  Updated \"Settings for a Multistep Program\" paragraph  Added \"Trace Setting\" paragraph  Added \"Setting up the Firewall\" paragraph  Updated \"General Virtual Station\" paragraph  Updated \"Configuration of the Direction Switch\" paragraph  Updated \"Event Codes\" paragraph  Updated \"Stored Results\" paragraph   3.3    Added or updated paragraphs:  Updated \"TrueAngle Compensation\" paragraph  Updated \"STwrench\" paragraph  Updated \"Configuration of the PIN Settings\" paragraph  Added \"Running the External Result Tightening Strategy with a Tool Connected\" paragraph  Added \"Running the External Result Tightening Strategy without a Tool Connected\" paragraph  Updated \"Tool Configuration\" paragraph  Updated \"TAG Check\" paragraph  Updated \"TAG Selection\" paragraph  Added \"Input Signals\" paragraph  Added \"Output Signals\" paragraph  Added \"Input\/Output Signals\" paragraph  Updated \"Tightening Steps\" paragraph  Updated \"Step Monitors\" paragraph  Updated \"Step Restrictions\" paragraph  Added \"Result Reporters\" paragraph  Updated \"Settings for a Multistep Program\" paragraph  Added \"Result View - Result Reporter\" paragraph  Updated \"Emergency Stop\" paragraph   3.1.X    Added or updated sections:  Updated Fieldbus Configuration settings  Updated General Virtual Station - Unlock tool on loosening  Updated Event Codes   3.1    Added or updated sections:  Updated license management  Copying pasting of tightening programs  Updated signal  Updated third party licenses   3.0    Added or updated sections:  License (FMS) chapter  StepSync chapter  Updated Multistep  Apply and Undo button for Tightening and Source Tightening   2.8    Added or updated sections:  Calibration using STa6000 or STpad  Configurable job counter  Decrement on OK  Scanner pass-through   2.7    Added or updated sections:  Updated multistep steps  Source Batch (barcode scanning)  Updated Event Codes for SRB and TBP tools   2.6    Added or updated sections  Multistep tightening strategy (Editor)  WLAN and Bluetooth for wireless tools   2.5    Added or updated sections:  Multistep tightening strategy  Selector confirm  Saved positions  General virtual station  Wifi socket selector  Multiple PINs  External OK  Service alarms for pulse tools  Manual mode virtual station   2.4    Added or updated sections:  Settings: License manager  Settings: PIN code  Settings: Configure start screen  Tightening: Disable tightening, Measure angle to, Trigger lost, Torque tuning factor  Tool health and battery check  Controller health and battery check  Pulse strategies  3-step tightening  Device: Accessory bus  Device: Led ring  Device: EHMI  Device: Fieldbus diagnostics  Export\/Import   2.3    Added or updated sections:  System settings: network configuration  System settings: preferences  System settings: protocol configuration  System settings: tightening  Tightening: Time monitoring and Torque tuning factor  ST Wrench  Sources  Accessory configuration: tool configuration, start condition, and socket selector configuration  System administration: Export\/Import  Tool configuration; ST Wrench  Appendix A: Front connections   2.1    Added or updated sections:  Settings: Fieldbus  Controller menu - Tightening: Current monitoring and True angle compensation  Four step tightening  System administration: Exported csv file format  Virtual station: I\/O diagnostics and Fieldbus  Appendix A: Emergency stop   2.0    Added or updated sections:  Settings: Tool alarms  Tool configuration: Tool connection, Tool maintenance, Internal Wlan for wireless tools  Tightening setup: Loosening step  Tightening results: Live results, Stored results, Status for NOK results  Virtual station  Event codes in Power Focus 6000   1.6   First official release of the configuration guide for Power Focus 6000. "},{"id":"58952203","fileName":"58952203.html","title":"Prerequisites","level":2,"position":10,"hasContent":true,"hierarchy":["Introduction"],"content":" Anyone interested in learning more about POWER FOCUS 6000can benefit from reading this User Guide.  For a complete understanding of the technical aspects described in the User Guide, we recommend the following:  Knowledge about tightening techniques  Experience of working with the previous versions of Power Focus"},{"id":"13413532427","fileName":"1341353242723858337931.html","title":"System Overview","level":2,"position":11,"hasContent":false,"hierarchy":["Introduction"],"content":""},{"id":"13414601611","fileName":"1341460161123858367627.html","title":"Software Structure","level":3,"position":12,"hasContent":false,"hierarchy":["Introduction","System Overview"],"content":""},{"id":"62559499","fileName":"6255949923858376075.html","title":"Menu Overview","level":4,"position":13,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure"],"content":" The controller has several menus available to configure tightening and hardware accessories, perform tool maintenance, administer software, and view reports. "},{"id":"62562827","fileName":"62562827.html","title":"Tightening Tab","level":5,"position":14,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  The Tighteningtab lists the Tightening programs stored on the controller that are available for an individual tightening. Tightening configurations are described in the Tighteningtab.  "},{"id":"62565387","fileName":"62565387.html","title":"Batch Sequence Tab","level":5,"position":15,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  The Batch Sequencetab lists the batch sequences stored in the controller. A Batch Sequence is one or more repetitive tightening programs in various combinations. Batch sequences are created and configured in the Batch sequencetab.  "},{"id":"62567947","fileName":"62567947.html","title":"Sources Tab","level":5,"position":16,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  The Sourcestab lists the available options for controlling the selection of a tightening program (for example, a tightening program or a batch sequence, via digital input from different hardware). Scanner configurations are done in the Sourcestab.  "},{"id":"62570507","fileName":"62570507.html","title":"Tool Tab","level":5,"position":17,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  The Tooltab provides information about the tools connected to the controller. This menu is also for wireless tools connected to the controller. Tool reference product, and when the tool was serviced and calibrated are some of the data available in the Tooltab.  "},{"id":"62573067","fileName":"62573067.html","title":"Virtual Station Tab","level":5,"position":18,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  The Virtual stationtab configures the Virtual Stations. The Virtual Station is a software abstraction of a controller system. In the Virtual stationtab the different resources, accessories, tools and tasks are assigned to a Virtual Station.  "},{"id":"62575627","fileName":"62575627.html","title":"Controller Tab","level":5,"position":19,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  The Controllertab lists hardware and software components. The software versions stored and used in the controller are listed and can be updated. The license manager for additional features is handled. It is also possible to import or export settings to and from the controller.  "},{"id":"62578187","fileName":"62578187.html","title":"Configurations Tab","level":5,"position":20,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  A list of accessory configurations are given in the Configurationstab. Accessories like tool accessories, I\/O Expander, Internal I\/O, Stacklight, Operator Panel, and Socket selectors can be configured. Digital I\/O signals are mapped to buttons, lamps, switches and connectors.  "},{"id":"62580747","fileName":"62580747.html","title":"Reports Tab","level":5,"position":21,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  In the Reportstab the tightening results and events are listed.  "},{"id":"62583307","fileName":"62583307.html","title":"Settings Tab","level":5,"position":22,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  The Settingstab is used to set up the controller specific settings such as language, pin code, wireless network, fieldbus.  "},{"id":"8427821835","fileName":"8427821835.html","title":"License Assignment Tab","level":5,"position":23,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  The License Assignmenttab is used to assign licenses and license features to Virtual Stations.  "},{"id":"62585867","fileName":"62585867.html","title":"Help Tab","level":5,"position":24,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure","Menu Overview"],"content":"  The Helptab contains useful help sections about the controller. It is possible to download PDF-files in several languages through a computer connected to the controller.  "},{"id":"2231529355","fileName":"2231529355.html","title":"Quick Start Guide","level":4,"position":25,"hasContent":true,"hierarchy":["Introduction","System Overview","Software Structure"],"content":" To create a better overview of the system, this instruction lightly goes through the different steps required to get started using the system.  This section does not cover every feature of the system, but instead focuses on the most basic features.    Decide on what kind of tool to use. The kind of tool being used affect the availability of tightening strategies.  The main purpose of the tool is to perform a tightening. This is done by defining a tightening programwhich contains all relevant parameters of a tightening, for example target angle and target torque.  One or several tightening programs can be added to a Batch Sequencewhich works as a series of tightening programs. A batch sequence can for example be a certain number of tightenings with a tightening program, or a sequence of different tightening programs.  Create a Virtual Stationand assign a tool to it. The virtual station acts as an interface between the controller and the tool, allowing for several tools to be connected to a single physical controller. A virtual station is required even if only one tool is connected to the controller.  Assign a task to the Virtual Station. The task can be either a tightening program, a batch sequence, or a specified digital input (from for example a barcode scanner). The tool assigned to the station will now be able to perform the task. "},{"id":"13414603787","fileName":"1341460378723858347403.html","title":"Hardware Structure","level":3,"position":26,"hasContent":false,"hierarchy":["Introduction","System Overview"],"content":""},{"id":"91780235","fileName":"9178023523858354315.html","title":"Operating and Handling","level":4,"position":27,"hasContent":true,"hierarchy":["Introduction","System Overview","Hardware Structure"],"content":" The POWER FOCUS 6000is set up and configured by using the controller front panel. It is also possible to access the controller interface through a web GUI by browsing to the controller’s IP address on a connected PC. "},{"id":"69376907","fileName":"6937690723858361227.html","title":"Front Panel","level":5,"position":28,"hasContent":true,"hierarchy":["Introduction","System Overview","Hardware Structure","Operating and Handling"],"content":" The front panel contains a touch-screen display and special buttons.       1  Display_A color display with touch screen showing configuration views and results.   2  Special buttons_Special function buttons  "},{"id":"69379723","fileName":"69379723.html","title":"Front Panel Buttons","level":6,"position":29,"hasContent":true,"hierarchy":["Introduction","System Overview","Hardware Structure","Operating and Handling","Front Panel"],"content":"  These buttons are available as clickable icons in the web GUI.     Button  Name  Description       Home  Go to the Home screen.      Result  Go to the live result view.   "},{"id":"69382283","fileName":"69382283.html","title":"Touch Screen Buttons","level":6,"position":30,"hasContent":true,"hierarchy":["Introduction","System Overview","Hardware Structure","Operating and Handling","Front Panel"],"content":"      Button  Name  Description       Add  Adds an additional item.      Back  Return to previous view.       Scroll up \/ Scroll down  Move in a list that is too long for the screen.       Maximize \/ Minimize  Maximize or minimize a section with parameters.      Back (in a list)  Back (and forward) between pages of a list.      Close  Tap to close the window.      Notice  Sign showing that a parameter is configured wrong.      Home  Go to the Home screen. Only available in the web GUI.      Go Result  Go to the live results screen. Only available in the web GUI.            "},{"id":"69384843","fileName":"69384843.html","title":"Navigation","level":6,"position":31,"hasContent":true,"hierarchy":["Introduction","System Overview","Hardware Structure","Operating and Handling","Front Panel"],"content":"   To navigate in the controller GUI either tap on a menu item or move a finger (drag) across the display to scroll through items.  Options are selected by tapping the required option.  To enter data into a text box, tap the text box and a keyboard appears on the display.  50305931  "},{"id":"62541195","fileName":"62541195.html","title":"Web GUI","level":5,"position":32,"hasContent":true,"hierarchy":["Introduction","System Overview","Hardware Structure","Operating and Handling"],"content":" The web GUI is very similar to the controller display. It enables configuration and programming of the controller through a web browser on a computer connected to the controller.  Users can program the controller from the controller and the web interface at the same time. "},{"id":"9829248907","fileName":"9829248907.html","title":"License Introduction","level":2,"position":33,"hasContent":true,"hierarchy":["Introduction"],"content":" Licenses for controller features are managed through the Functionality Management System (FMS). This allows customers to tailor controller functions to their specific needs through a dynamic licensing scheme. Licenses can be obtained for individual features or collections of features and can be deployed across multiple Virtual Stations. The licenses can be returned to the pool when they are no longer required. Licenses can be obtained through the Atlas Copco License Portal (ACLP). Licenses can be downloaded from the ACLP and managed\/distributed through ToolsTalk, or can be stored on a FMS Portable (USB drive) to be inserted into the controller.  Note that the creation and management of a customer account in the ACLP is not covered in this documentation. Contact your local Atlas Copco representative for more information."},{"id":"9848246155","fileName":"9848246155.html","title":"Licenses Overview","level":2,"position":34,"hasContent":true,"hierarchy":["Introduction"],"content":" Configuration of features governed by licenses can be done even in the absence of an installed license. For example configuration of tightening programs and configuration of Multistep programs. Assigning these features to a tool or virtual station is also possible. Running the feature without a valid license, however, will require the installation of the appropriate license. License enforcement is performed at two stages: assignment and runtime (trigger pressed). If a feature for which no license is installed is assigned to a Virtual Station, a red exclamation mark will appear at the Virtual Station View in ToolsTalk 2. The controller GUI will also show a warning triangle at the tool or task section (depending on what is missing). If a feature for which no license is installed is started (i.e. trigger pressed), an event will be presented to the user informing the user of which license is missing. It will not be possible to proceed without a correct license installed.  Running an unlicensed feature will, in most cases, result in a locked tool. Many features and functions in the controller require a license in order to be assigned and used by a virtual station. There are four types of licenses: Virtual Station Type Fixed collection of features bundled together in a single package. The Virtual Station Type determines, among other things, what tools can be run, how many programs and sequences can be used, which tightening strategies are available, and the type of reporting that can be done. The features contained in each Virtual Station Type are features that often are used in conjunction with each other, or which have internal dependencies that require the presence of other features in the package. Virtual Station Types are assigned in their entirety to a virtual station. The virtual station can then make use of all features contained in the Virtual Station Type. In order to be able to perform tightenings, a Virtual Station has to be assigned a Virtual Station Typelicense. Depending on the license type, various tightening options will be enabled or blocked. Sync Functionality Type Works in the same way as described in Virtual Station Type but used for fixtured systems. To be able to run several tools on a virtual station each tool need a sync functionality license. Virtual Station Feature Individual features which can complement Virtual Station Types. A lot of features can be purchased as a single license. Controller Feature Features that are controller-wide. These are features which are assigned to a controller and once assigned can be used by all virtual stations on that controller."},{"id":"12071037195","fileName":"12071037195.html","title":"License Sources","level":2,"position":35,"hasContent":true,"hierarchy":["Introduction"],"content":" Licenses used on a controller can be pulled from several different sources. The number of simultaneous sources is limited to 10 (either 10 FMS Portable sources, or one License Server (TT2) in addition to 9 FMS Portable sources). If you would like to add licenses from a source when the source limit (10) has been reached, all licenses from one source need to be removed from the controller to make room for licenses from the other source. Source Overview The Source Overview tab ( License assignment> Source Overview) provides the user with an overview of the licenses installed on the controller, as well as where they were installed from. A maximum number of 10 different sources can be displayed here, and each will be designated with FMS P (for FMS Portable, or dongle), or License Server (TT2). Clicking on any license source will present that source's detailed license source information. It lists the source name and type, as well as the number and type of licenses in each category (Virtual Station Type, Virtual Station Feature and Controller Feature)."},{"id":"16865464075","fileName":"16865464075.html","title":"Supported Tools","level":2,"position":36,"hasContent":true,"hierarchy":["Introduction"],"content":"  Tools supported by a Virtual Station may vary depending on the Virtual Station type on the controller.      Supported Tools  BatchControl  JointControl  StationControl  CriticalControl  ProcessControl    BCP \/ BCV  X  -  -  -  -   TensorSB  -  X  X  -  -   TensorSL  -  -  X  X  X   TBP  -  -  X  X  X   TensorST  -  -  X  X  X   TensorSTR  -  -  X  X  X   SRB  -  -  X  X  X   TensorSTB  -  -  X  X  X   STWrench  -  -  X  X  X   TensorES  -  X  X  -  -   TensorSR  -  -  X  X  X   QST (Fixtured spindle)  -  -  X  X  X   TBPS  -  X  X  -  -   MWR-S (Mechatronic Wrench Signal)  -  -  -  -  -   MWR-T (Mechatronic Wrench Torque)  X  X  X  X  -   MWR-TA (Mechatronic Wrench Torque Angle)  -  -  X  X  X   External tool  X  X  X  X  X"},{"id":"8850725515","fileName":"885072551523858392459.html","title":"Installation and Upgrade","level":1,"position":37,"hasContent":false,"hierarchy":[],"content":"  In this section, you can find information to help with the initial installation of the product, or upgrading from one version to another. "},{"id":"13414969739","fileName":"1341496973923858401931.html","title":"License Installation","level":2,"position":38,"hasContent":false,"hierarchy":["Installation and Upgrade"],"content":""},{"id":"9844852107","fileName":"9844852107.html","title":"Installing Licenses on the Controller","level":3,"position":39,"hasContent":true,"hierarchy":["Installation and Upgrade","License Installation"],"content":"  Note that licenses sources are limited to 1 License Server (TT2) and 9 FMS Portables (dongles) simultaneously. Licenses are installed either through the server (ToolsTalk 2) or FMS Portable. If the license source limit is reached, all licenses from one source need to be removed from the controller in order to add licenses from another source.  Before installing licenses through the server (ToolsTalk 2), make sure that the controller time is synced with the server time. Installing from the Server Distributing server-based licenses is done through ToolsTalk 2. Please refer to the ToolsTalk 2User Guide for instructions on installing licenses.  In order to be able to install licenses using ToolsTalk 2, the correct license server needs to be configured:    Select the Settingsmenu, and select the Server connectionstab.  In the Atlas Copco License Managerfield, set the switch to On.  Insert the correct Server hostIP address (usually the same as the IP address for ToolsTalk 2) and Server Port.  Select Apply. Installing from FMS Portable (USB) The Functionality Management System (FMS) uses a special FMS Portable device to transfer functionality to and from a controller. The USB flash drive contains both a general purpose memory area and a trusted storage area that is only accessible by the License manager in a controller. The purchased feature items are downloaded from Atlas Copco to the general purpose area. The first time the FMS Portable is inserted into a controller with a License manager, the file is detected and decoded and the feature items are transferred to the trusted storage area that is only accessible from a License manager. If you have a USB drive with the licenses installed, perform the following steps to install them on the controller.    Insert the USB into the USB port in the controller  The USB License Management window will pop up in the GUI. The Poolcolumn will show the total license count on the controller from all sources. The Available on FMS Pcolumn shows the licenses available on this dongle, while the From this FMS Pcolumn shows the number of licenses that have been moved to this controller from this particular FMS P.  Select the left-pointing arrow next to license you want to install on the controller.  The number in the Available on FMS Pcolumn will decrease by 1 and the number in the From this FMS Pcolumn will increase by 1. The user will be presented with events on the controller for both license transfer start and end. License sync Existing licenses are checked against the license server every two hours. If no response from the license server is obtained within a 14 day period, the affected licenses will be revoked. The user will also be warned when licenses are about to expire. When a license is within 7 days of expiration, the user will be presented with a warning once every two hours. If licenses are not renewed, they will expire and the affected functions will no longer be available. "},{"id":"9844855819","fileName":"9844855819.html","title":"Removing Licenses from the Controller","level":3,"position":40,"hasContent":true,"hierarchy":["Installation and Upgrade","License Installation"],"content":" One way of removing an FMS Portable-installed licenses are described, for instructions how to remove server-installed licenses, please refer to the ToolsTalk 2User Guide. Removing FMS Portable-Installed Licenses    Make sure the FMS Portable is inserted into the USB port in the controller.  [If the USB License Manager window is not visible] Select the License Assignmentmenu.  Select the USB icon in the top right of the window.  The USB License Manager window pops up.  Select the right-pointing arrow next to the license you want to remove from the controller.  Licenses that are assigned to virtual stations can be removed from the controller. However, the Virtual Station will become unusable as a result. "},{"id":"8850727051","fileName":"885072705123858449035.html","title":"Configuration","level":1,"position":41,"hasContent":false,"hierarchy":[],"content":"  In this section, you can find detailed information about how to create, modify, and verify product settings. "},{"id":"80998923","fileName":"8099892323858764939.html","title":"Working with the Tightening Tab","level":2,"position":42,"hasContent":true,"hierarchy":["Configuration"],"content":"  Risk of injury  A change in the configuration of the tightening program may cause unexpected torque, rotational direction, or speed in the system(s) where the tightening program is currently in use. This could result in severe bodily injury and\/or property damage.   Check the tightening program configurations after adding a new program or after applying changes to an existing program.  Changes made to tightening programs in any section need to be actively applied by clicking the Apply button in the bottom right corner of the GUI. Alternatively, changes can be undone by clicking the Undo button in the same location. When navigating away from the section where changes have been made (by using the Back, Home or Result button), the user will be presented with a warning pop-up where the changes can also be applied or undone. The user cannot proceed without applying or undoing changes.   Controller features, such as the Low Reaction Tightening Strategies and controller-wide functions among others, require licenses distributed through the Functionality Management System (FMS). Whereas configuration of features is possible without specific licenses, the assignment and use of those features will require the correct license to be installed on the controller. Please refer to Licenses (FMS) for more detailed information on licenses.  The POWER FOCUS 6000tightening programs need parameters to be set in order to perform tightening. Selecting a Strategy and either the Target torqueor Target angleare mandatory. Other settings are optional, such as Soft start, Selftap, and Torque compensation. It is also possible to monitor the tightening as it progresses by adding limits within which the torque, or angle the nut turns, must remain. The tightening procedure is divided into four steps: Start, Rundown, Tightening and Stop.   "},{"id":"60958731","fileName":"6095873123858807435.html","title":"Tightening Programs","level":3,"position":43,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab"],"content":" By selecting the tightening program it is possible to choose the method for applying clamping force (or pre-load) to the joint. Different joints require different strategies for how to apply the desired clamping force and to minimize unwanted in-service effects.    TurboTightstrategy, enables the option to use Manual programming or Quick prog - for more information, see the paragraph TurboTight.   Quick step, Two stepand Three stepstrategies enable the choice of tightening towards a Target torque or a Target angle value.   External resultstrategy, is used when OK tightenings are indicated by an external digital signal - for more information, see the paragraph External result. All tightening programs require that you at least set the Target torqueor Target anglevalue.      Parameter  Description  Default value    Strategy  Available tightening programs.  TurboTight: No additional tightening behavior is used as default. Only target values are used.  Quick step: Adds an initial tightening step to reduce pre-load scatter.  Two step: Adds a pause between the first and final tightening step to further counteract short-term relaxation effects.  Three step: Tightens to a defined First torque value, then loosens the screw and immediately retightens it to Target torque or Target angle.  Wrench - production: Tightening strategy to use with an ST Wrench.  Wrench - quality: Strategy used for quality test of tightenings with an ST Wrench.  Rotate: Rotates the spindle a specified speed and angle.  External result: presents a predetermined tightening result instead of measured torque\/angle.  Multistep: Tightening strategy consisting of multiple configurable steps, with restrictions and monitors.  TurboTight   Target type  Defines the type of the target value in the final step.  Target torque:The tightening aims towards the specified target value when performing the final step.  Target angle:The tightening aims towards the specified target value when performing the final step.     Target torque  Defines the target torque of the tightening of the final step.     Target angle  Defines the target angle of the tightening of the final step.     Target speed  Activates setting the tool speed for the final step manually or using the default speed.  Auto:Uses a value that is calculated based on the Tool max speed.  Manual:Specify the tool speed manually.  Auto   <Manual>  Tool speed during tightening or during the final step.   "},{"id":"62055563","fileName":"62055563.html","title":"TurboTight","level":4,"position":44,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":"  TurboTight is the default tightening strategy and it is designed to perform a very fast and ergonomic tightening based on the maximum speed of the tool (Tool max speed). This strategy has two options:   Quick prog, that requires only the Target torqueto be set to perform the tightening.   Manual, that allows the user to configure several tightening parameters.  To minimize the risk of unexpected jerk at the end of the tightening when using the TurboTight tightening strategy, make sure to activate Time monitoring. To minimize the risk of unexpected jerk at the end of the tightening when using the TurboTight tightening strategy, make sure to set the Time Max Limit. Time Max Limit is enabled by default, but it is necessary to setup the related values. In the tightening stage, set Angle Limitto From Rundown Complete. Set Time Maxas low as possible, without stopping the normal tightening. In the rundown stage, set Rundown Complete Torqueso that it is triggered when the torque start to increase. Depending on the joint properties, for example if the joint is very stiff or very soft, a different tightening strategy than TurboTight might be needed.   TurboTight is not available for Joint Control. Fine-Tuning the TurboTight Strategy TurboTight tightening strategy points to the target torque, and the result can be below or above the target. The most important parameter for TurboTight tightening strategy is the speed. It is possible to keep maximum speed for most tightenings, but if all\/some of the tightenings overshoot, decrease the speed in small steps. Rundown Complete Torqueis not used for controlling of the tightening; it is only used for calculating of limits and results. "},{"id":"60968203","fileName":"60968203.html","title":"Quick Step","level":4,"position":45,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":" Quick step is a tightening strategy used to reduce the joint’s preload scatter by adding an initial step with a given torque and speed, and then reducing the target speed in the final step.       Parameter  Description  Default value    First torque  Target torque for the first step.     First torque  Torque during first step.  80% of Target Torque   First speed  Target speed for the first step.     First speed  Tool speed during first step.  50% of Tool max speed  "},{"id":"60970763","fileName":"60970763.html","title":"Two Step","level":4,"position":46,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":" The Two step strategy is very similar to the Quick step strategy except that it adds a small time delay between the first step and the final step, to further counteract short-term relaxation effects in the joint.       Parameter  Description  Default value    First torque  Torque during first step.  80% of Target Torque   First speed  Target speed for the first step.     Pause time  Time between first and second step.  50 ms Fine-Tuning the Two Step Strategy When the First target is reached, the tool makes an immediate stop for a specified time before it continues with the final step. The First torque value and the Pause time should be chosen to improve ergonomics for hand-held tools.  "},{"id":"60976395","fileName":"60976395.html","title":"Three Step","level":4,"position":47,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":" The Three step strategy adds a loosening step between the first step and the final step, to overcome short-term relaxation effects due to embedment, and reduce preload scatter. This is sometimes used to condition the joint. This can be useful in, for example, joints with many adjoining surfaces and will have a greater effect on new parts than on reused ones, due to the smoothing of surfaces, which reduces embedment. Conditioning the joint is done by tightening the first step to a given torque, First torque, and then releasing the load by turning the nut a specified Conditioning angleand then retightening the nut to its Target torqueor Target angle. The target torque can be lower than the torque reached during the first step after rundown. In order for the target torque to be lower than the first torque, set target torque (Tightening parameters > Tightening step > Final step > Target torque) to a value lower than First torque (Tightening parameters > Tightening step > First step > First torque). If Angle is used as a target in the tightening program, the Target angle is measured from the position at the end of the loosening step (conditioning). Behavior of Measure torque at, and Measure angle to The Max torque valueand Value at peak torquemeasured under Result evaluation for Measure torque at and Measure angle to, respectively, represent the highest values measured over the entire tightening. This means that if the Target torque is set lower than the First torque, the Result evaluation value will be higher than the end value. In order to view the tightening's final value, both Measure torque at, and Measure angle to should be set to Value at shutoff.       Parameter  Description  Default value    First torque  Torque during first step.  80% of Target Torque   First speed  Tool speed during first step.  50% of Tool max speed   Conditioning speed  Tool speed during the conditioning step.  50% of Tool max speed   Conditioning angle  Angle to turn the socket during the conditioning step.  180° Fine-Tuning the Three Step Strategy When the First target is reached and the conditioning step is entered, the tool makes an immediate stop and reverse before it continues with the final step. This conditioning step may need to be fine-tuned to improve ergonomics for hand-held tools.  "},{"id":"1783968907","fileName":"178396890723858813835.html","title":"STwrench","level":4,"position":48,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":" The STwrench is connected to a controller using a wireless connection and is configured through the controller GUI or the web GUI. The STwrench is configured under the tightening menu in the same way as the other tightening strategies. The STwrench has a Rapid Backup Unit (RBU). The RBU defines the wrench function and stores the tightening programs. The controller supports currently only the RBU of the type Production. The STwrench End-fitting tool(socket) contains a RFID TAG with a programmable number. This wrench uses this number to automatically recognize the tool and which program that can be used. The RFID TAG also stores the torque and angle correction coefficients. The STwrench has several programs both for production tightening and for quality control.  The STwrench can only support tightening programs supported by the tool ( Wrench Productionand Wrench Quality).  For more information about the STwrench, see the STwrench User Guide (printed matter number 9836 4134 01). "},{"id":"1271679755","fileName":"1271679755.html","title":"STwrench Start Step Parameters","level":5,"position":49,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","STwrench"],"content":"  The parameters shown in the tables are available if one of the STwrench strategies are used. There are several combinations of strategies. Some of the parameters are only available for certain strategies and may not be visible in other strategies. Parameter rules are automatically checked. If a violation occurs, the error indicatoris displayed beside the incorrect parameters. Select the error indicator to display more information about the error.  Switching between strategies can result in the error indicator being shown. This indicates that the chosen combination is invalid, and needs to be corrected.  For more information about the STwrench, see the STwrench User Guide (printed matter number 9836 4134 01).    Parameters in the STwrench start step     Parameter name  Condition  Description  Default value    Tag number    On: after enabling TAG Check switch ( Configurations > Tool Configuration > TAG Check > On), a correct TAG number is required to run the tightening program.  Off: The TAG number is not checked.  Off   Required tag number  Tag number = On  The required TAG number for this tightening program.  1   Rehit detection   The parameter options are:  Completeor Off.  Off   Torque correction coefficient   In certain cases extensions may be needed to fit the application. In this case the wrench measurement must be compensated to show a correct value. For more information about to calculate the correction coefficient, see the STwrench User Guide (printed matter number 9836 4134 01). The parameter is stored in the RFID TAG in the End-fitting tool.  1.0   Angle correction   In certain cases extensions may be needed to fit the application. In this case the wrench measurement must be compensated to show a correct value. To calculate the correction coefficient, please refer to the STwrench user guide. The parameter is stored in the RFID TAG in the End-fitting tool.  0°  The correction coefficients alter the STwrench measurement. It may cause an improper reading. Before making any corrections, refer to the latest version of the STwrench User Guide (printed matter number 9836 4134 01).  "},{"id":"1271682187","fileName":"1271682187.html","title":"STwrench Rundown Step Parameters","level":5,"position":50,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","STwrench"],"content":"  The parameters shown in the tables are available if one of the STwrench strategies are used. There are several combinations of strategies. Some of the parameters are only available for certain strategies and may not be visible in other strategies. Parameter rules are automatically checked. If a violation occurs, the error indicatoris displayed beside the incorrect parameters. Select the error indicator to display more information about the error.  Switching between strategies can result in the error indicator being shown. This indicates that the chosen combination is invalid, and needs to be corrected.  For more information about the STwrench, see the STwrench User Guide (printed matter number 9836 4134 01).     Rundown completeis in the STwrench documentation defined as Cycle start, this is when the tightening step begins.  Parameters in the STwrench rundown step     Parameter name  Description  Default value    Rundown complete torque  Definition of the Rundown complete point  Depends on the smarthead minload (usually 5% of nominal torque) in Nm   Ratchet time   5000 ms  "},{"id":"1271684107","fileName":"1271684107.html","title":"STwrench Tightening Step Parameters","level":5,"position":51,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","STwrench"],"content":"  The parameters shown in the tables are available if one of the STwrench strategies are used. There are several combinations of strategies. Some of the parameters are only available for certain strategies and may not be visible in other strategies. Parameter rules are automatically checked. If a violation occurs, the error indicatoris displayed beside the incorrect parameters. Select the error indicator to display more information about the error.  Switching between strategies can result in the error indicator being shown. This indicates that the chosen combination is invalid, and needs to be corrected.  For more information about the STwrench, see the STwrench User Guide (printed matter number 9836 4134 01).    Parameters in the STwrench tightening step     Parameter name  Condition  Description  Default value    Target   Select the target from the drop-down menu. The parameter options are:  Torque, Angle, Torque or Angle.  Torque   Target Torque    Defines the target torque for tightening step.  0 Nm   Target Angle  Target = Angle  Defines the target angle for tightening step.  360°   Torque limits  Target = Torque  Selection made by a switch.  Autoor Manuallyposition.     Torque min  Torque limits = Manual  Torque value for the lower limit  0 Nm   Torque max  Torque limits = Manual  Torque value for the upper limit  0 Nm   Angle limits  Target = Angle  Selected from a drop-down menu. The parameter options are:  Autoor Manually. Angle values for max and min can be or selected    Angle limits  Target = Torque  Selected from a drop-down menu. The parameter options are:  Off:No angle limit monitoring.  From rundown complete:The monitoring window is set from when the Rundown complete torqueis reached.  From torque:The monitoring window is set from when the specific torque value is reached.    Final angle monitoring torque    Torque value from when the angle limits are monitored  18.75 Nm   Angle min  Angle limits = on or manually  Angle value lower limit  324°   Angle max  Angle limits = on or manually  Angle value upper limit  396°   Angle search limit  Angle limits = manually     Measure torque at    Selected from a drop-down menu. The parameter options are:  Max torque value  Value at peak angle     NOK on final less than target    Selection made by a switch.  Onor Offposition.  Off   Change bolt limit     50 Nm  Parameters in the STwrench tightening step if the strategy is Wrench - Production, and PVT compensate with snug     Parameter name  Condition  Description  Default value    Torque compensation point  Torque compensation = On   0°   PCT distance  Torque compensation = On   360°   PVT interval  Torque compensation = On   180°   Delay monitoring  Torque compensation = On   0°   Torque min  Torque compensation = On  Torque value for the lower limit  1 Nm   Torque max  Torque compensation = On  Torque value for the upper limit  20 Nm   Compensation value  Torque compensation = On  Selected from a drop-down menu. The parameter options are:  Average torque  Peak torque   "},{"id":"1273077643","fileName":"1273077643.html","title":"STwrench Loosening","level":5,"position":52,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","STwrench"],"content":"  The parameters shown in the tables are available if one of the STwrench strategies are used. There are several combinations of strategies. Some of the parameters are only available for certain strategies and may not be visible in other strategies. Parameter rules are automatically checked. If a violation occurs, the error indicatoris displayed beside the incorrect parameters. Select the error indicator to display more information about the error.  Switching between strategies can result in the error indicator being shown. This indicates that the chosen combination is invalid, and needs to be corrected.  For more information about the STwrench, see the STwrench User Guide (printed matter number 9836 4134 01).    Parameters in the STwrench loosening step     Parameter name  Condition  Description  Default value    Loosening limit   If this parameter is set to a value greater than 0, Power Focus checks if a negative torque exceeding this value is applied during the tightening. In that case, the overall status of the tightening is marked as Not OK. This function is started when the wrench reaches the Cycle Start (before starting the tightening, a loosening is allowed and does not produce results). This function is used to detect unwanted loosening at the end of a tightening (for instance, when the wrench is disengaged from the joint).  0 Nm  "},{"id":"1299544203","fileName":"1299544203.html","title":"STwrench Stop Step Parameters","level":5,"position":53,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","STwrench"],"content":"  The parameters shown in the tables are available if one of the STwrench strategies are used. There are several combinations of strategies. Some of the parameters are only available for certain strategies and may not be visible in other strategies. Parameter rules are automatically checked. If a violation occurs, the error indicatoris displayed beside the incorrect parameters. Select the error indicator to display more information about the error.  Switching between strategies can result in the error indicator being shown. This indicates that the chosen combination is invalid, and needs to be corrected.  For more information about the STwrench, see the STwrench User Guide (printed matter number 9836 4134 01).    Parameters in the STwrench loosening step     Parameter name  Condition  Description  Default value    End cycle time   It is applied when torque goes below the cycle start and gets to the third percentage value set on the STwrench LEDs.  100 ms  "},{"id":"6258584587","fileName":"625858458723858820747.html","title":"Pulsing Tool Strategies","level":4,"position":54,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":" The strategy can be selected if the controller software version supports the tightening program. Pulsing tools can achieve a higher torque compared to normal rotating tools. "},{"id":"2489971723","fileName":"2489971723.html","title":"Pulse Tightening Program","level":5,"position":55,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","Pulsing Tool Strategies"],"content":" Start During the start step, the tool rotates in a speed mode without any pulsing.      Parameter name  Description    Soft start  Enables setting of the tool’s speed, angle and maximum torque to facilitate the bolt entering the thread. Selected by radio buttons.  Off:Soft start is turned off.  On:Soft start is turned on.   Speed  Defines the speed during the soft start.   Time  Defines the Soft startduration.   Angle  Defines the target angle to turn the spindle for the bolt to enter the thread.   Torque max  Defines the upper torque limit during the soft start. If Torque maxis exceeded, the tightening is considered NOK.   Rehit detection   Early:Terminates the tightening immediately when an already tightened screw\/bolt is detected. The tightening will be considered as NOK. Requires that Soft startis activated.  Complete:Even though an already tightened screw\/bolt is detected, the tightening is not terminated until all tightening steps have been executed. The tightening will be considered as NOK. To make a rehit detection when Soft startis not activated, the Rehit detection Completeoption must be selected. Rehit detection Completewill not terminate the tightening until all tightening steps have been executed. The tightening will be considered a rehit if the speed fails to reach half the rundown speed, a rehit error is then indicated.  Off:No rehit detection will be performed. Combination Soft start = Off and Rehit = Early is not allowed.   Positive  The TrueAngle compensation can detect tool rotation and make angle compensations within the set limits.   Negative  The TrueAngle compensation can detect tool rotation and make angle compensations within the set limits.   Use attachment tuning  Attachment tuning is selected by radio buttons.   Gear ratio  Socket rotation speed = Tool speed \/ gear ratio.   Efficiency tuning  For example 0.9 means 10% efficiency loss. Rundown During rundown, the tool can use either speed mode, with a constant motor speed, or pulse mode. The selection is made depending on the encountered torque and the given torque limits within the configuration.      Parameter name  Description    High-speed rundown  The rundown step can be done in high-speed in order to minimize the time, without overshooting. This is achieved by letting the tool run at a higher speed for a specified angle length. When the angle has been reached, the speed will change to the lower speed specified in Rundown speedparameter. Only available for SRBtools.  Length:Default 3600°, max 99999°  Speed: Tool max speedmust be higher than Rundown speed(rpm).   Rundown speed  Rundown speed can be set to either Maxor Manual. If Rundown speed is set to Manual; enter the tool speed in rpm.   Rundown angle limits   Off:Rundown angle limits is turned off.  From Trigger:Rundown angle limits is turned On. The system starts to monitor the tightening angle as soon as the tool trigger is pressed and reports if angle limits are violated.  From torque:Rundown angle limits is turned On. The system starts to monitor the tightening angle from the specified torque value and reports if angle limits are violated.   Rundown angle monitoring torque  Torque value from where Rundown angle limitsare set.   Angle min  Angle value for lower angle limit from starting point.   Angle max  Angle value for upper angle limit from starting point.   Time min  Minimum time for the step.   Time max  Maximum time for the step.   Rundown pulse limits  Selected from a shortcut menu:  Off:Rundown pulse limits is turned off.  From Trigger:Rundown pulse limits is turned On. The system starts to monitor the pulses as soon as the tool trigger is pressed and reports if the pulse limits are violated.  From torque:Rundown pulse limits is turned On. The system starts to monitor the pulses from the specified torque value and reports if the pulse limits are violated.   Rundown pulse monitoring torque  Torque value from where the Rundown pulse limitsmonitor starts. The value must be set to a value greater than Continuous max torque.   Pulses min  Minimum number of pulses to reach the Rundown complete torquevalue.   Pulses max  Maximum number of pulses to reach the Rundown complete torquevalue.   Rundown complete torque  Defines the torque value for when snug is reached and the rundown is completed. The program proceeds with the tightening and starts with pulse mode, if not already done so during rundown. Tightening      Parameter name  Description    Target torque  Final target torque for the tightening.   Pulse Energy  The Pulse energydelivered in the action pulse expressed in a percentage of the maximum energy that the tool can deliver in each pulse.   Reaction force tuning factor  The energy delivered by the tool expressed in a percentage value. The reaction force tuning factoris based on the action energy and results in a comfortable reaction.   Residual torque correlation factor  The term Residual torque correlation factor is similar to a calibration and adjusts between the dynamic torque, measured in the electrical tool, and the residual torque, measured by a control tool.   Torque limits  Limits can be Automaticallyor Manuallyselected.   Torque min  Minimum torque for the step.   Torque max  Maximum torque for the step.   Angle limits   Off: Angle limitsis turned off.  From Rundown complete: Angle limitsis turned On. The system starts to monitor the tightening angle as soon as Rundown completeis reached and reports if angle limits are violated.  From torque: Rundown angle limitsis turned On. The system starts to monitor the tightening angle from the specified torque value and reports if angle limits are violated.   Rundown angle monitoring torque  Torque value from where Rundown angle limitsmonitoring starts.   Angle min  Angle value for lower angle limit from the starting point.   Angle max  Angle value for the upper angle limit from starting point.   Time min  Minimum time for the step.   Time max  Maximum time for the step.   Pulse limits   Off:No pulse limit monitoring.  From rundown complete:The monitoring starts when the Rundown complete torqueis reached.  From torque:The monitoring starts when the specific torque value is reached.   Final pulse monitoring torque  Torque value from when the pulse limits are monitored.   Pulses min  Minimum number of pulses to reach the final target.   Pulses max  Maximum number of pulses to reach the final target.   Premature torque loss detection time  A constant increase in torque is assumed when moving from rundown to tightening. A socket slip off, or a broken screw head can cause the torque to decrease. This may be detected in a monitoring window."},{"id":"2493861259","fileName":"2493861259.html","title":"Pulse Tightening with Direct Driven Electrical Tools","level":5,"position":56,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","Pulsing Tool Strategies"],"content":"  The principle below is applicable for direct driven electrical tools. It is applicable to the Atlas Copco SRB series of tools.  The pulse tightening uses a technique of pulsing the electrical current in the motor and has two distinct features:  An action current that adds positive torque in the tightening direction.  A reaction current that creates a comfort reaction by applying a reverse torque.  Pulse tightening principle      A  Action pulse to apply tightening force.   B  Reaction pulse for comfort  The figure shows the general principle of a current pulse tightening strategy. The detailed curve depends on the tool type and the tightening algorithm. The pulse period consists of two phases as shown in the figure with an action current and a reaction current. Each action pulse adds torque to the tightening until the final target is reached. Each reaction pulse creates a counterforce that provides a comfortable reaction. The energy level of the action phase and the reaction phase are configurable parameters. The combination of these two parameters creates an efficient tightening combined with operator comfort.  "},{"id":"2499271307","fileName":"2499271307.html","title":"Tightening using the TensorPulse Program","level":5,"position":57,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","Pulsing Tool Strategies"],"content":"  The principle below is applicable for direct driven electrical tool. It is applicable to the Atlas Copco SRB series of tools. After each pulse period the resulting torque in the screw is increased. After a series of pulses, the final torque target is reached.  TensorPulse with maximum pulse energy      A  Maximum positive energy in pulse N   B  Maximum positive energy in pulse N+1   C  Increase in energy (torque)  The energy level in the action phase and reaction phase are user configurable parameters. The combination of these two parameters creates an efficient tightening combined with operator comfort. It is possible to set the amount of energy in the two phases as a percentage of the maximum energy that can be delivered in each period:   Pulse energy; The amount of energy that is applied to each positive pulse as a percentage of the maximum energy that can be applied in the pulse period. The value is between 10-100%.   Reaction force retention factor; The amount of energy that is applied to each reactive pulse as a percentage of the maximum energy that can be applied in the pulse period. The value is between 0-75%.  TensorPulse with reduced positive pulse energy      A  Reduced positive energy in pulse N   B  Reduced positive energy in pulse N+1   C  Resulting curve for torque build up using maximum pulse energy.   D  Resulting curve for torque build up using reduced pulse energy.   A small Pulse energy(reduced energy) requires more pulses to reach the target torque as the torque is increased in smaller steps. Smaller steps provides better accuracy to terminate the tightening when the target is reached. Smaller pulses decrease tool movement and increases operator comfort.  A correctly tuned Reaction force retention factorwill create the desired operator comfort. If the factor is too high the operator feels a clockwise rotation of the tool. If the factor is too low, the operator feels a counter clockwise rotation of the tool.  In an ideal configuration, the reaction energy does not create any loosening force. If the amount of pulses to reach the target value increases, the value is set too high and a small loosening occurs at each pulse.  The optimum values for the Pulse energyand the Reaction force retention factorneed to be tuned for optimum performance of the tool and for best operator comfort.   "},{"id":"2677489419","fileName":"2677489419.html","title":"Impulse Single Step Tightening Program","level":5,"position":58,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","Pulsing Tool Strategies"],"content":" Rundown      Parameter name  Condition  Description  Default value    Rundown speed   Selected by radio buttons. Rundown speed can be selected between Maxor Manual.  Max   Rundown speed  Rundown speed = manual  Specifies the tool speed during the rundown step.    Rundown time limits   Selected from a shortcut menu:  Off: Rundown time limitsis turned off.  From Trigger: Rundown time limitsis turned On. The system starts to monitor the time as soon as the tool trigger is pressed and reports if the time limits are violated.  From torque: Rundown time limitsis turned On. The system starts to monitor the time from the specified torque value and reports if the time limits are violated.  Off   Rundown time monitoring torque  Rundown time limits = from torque  Torque value from where Rundown time limitsmonitor starts.    Time min  Rundown time limits = On  Minimum allowed time for rundown.  10ms   Time max  Rundown time limits = On  Maximum allowed time for rundown.  5000ms   Rundown pulse limits   Selected from a shortcut menu:  Off: Rundown pulse limitsis turned off.  From Trigger: Rundown pulse limitsis turned On. The system starts to monitor the pulses as soon as the tool trigger is pressed and reports if the pulse limits are violated.  From torque: Rundown pulse limitsis turned On. The system starts to monitor the pulses from the specified torque value and reports if the pulse limits are violated.  Off   Rundown pulse monitoring torque  Rundown pulse limits = from torque  Torque value from where the Rundown pulse limitsmonitor starts.  2.5Nm   Pulses min  Rundown pulse limits = On  Minimum number of pulses to reach the target.  2   Pulses max  Rundown pulse limits = On  Maximum number of pulses to reach the target.  50   Rundown complete torque    Defines the torque value for when snug is reached and rundown is completed.  5Nm Tightening      Parameter name  Condition  Description  Default value    Target torque   Final target torque for the tightening.    Pulse Energy   The Pulse energydelivered in the action pulse expressed in a percentage of the maximum energy the tool can deliver in each pulse.    Residual torque correlation factor   The term Residual torque correlation factor is similar to a calibration and adjusts between the dynamic torque, measured in the electrical tool, and the residual torque, measured by a control tool.  100%   Torque limits   Selected by radio buttons. Limits can be Automaticallyor Manuallyselected    Torque min  Torque limits = manual  Minimum torque for the step.    Torque max  Torque limits = manual  Maximum torque for the step.    Time limits   Selected from a shortcut menu:  Off: Time limitsis turned off.  From rundown complete: Time limitsis turned On. The system starts to monitor the time as soon as rundown completeis reached and reports if the time limits are violated.  From torque: Time limitsis turned On. The system starts to monitor the time from the specified torque value and reports if the time limits are violated.  Off   Time monitoring torque  Time limits = from torque  Torque value from where the Time limitsmonitor starts.    Time min  Time limits = On  Minimum allowed time for tightening.  10ms   Time max  Time limits = On  Maximum allowed time for tightening.  1000ms   Pulse limits   Selected from a shortcut menu:  Off:No pulse limit monitoring.  From rundown complete:The monitoring starts when the Rundown complete torqueis reached and reports if the number of pulses is outside the limit.  From torque:The monitoring starts when the specific torque value is reached and reports if the number of pulses is outside the limit.  Off   Final pulse monitoring torque  Pulse limits = from torque  Torque value from when the pulse limits are monitored.    Pulses min  Pulse limits = on  Minimum number of pulses to reach the final target.  2   Pulses max  Pulse limits = on  Maximum number of pulses to reach the final target.  50   Premature torque loss detection time   A constant increase in torque is assumed when moving from rundown to tightening. A socket slip of, or a broken screw head can cause the torque decrease. This may be detected in a monitoring window.  200 ms"},{"id":"60982027","fileName":"60982027.html","title":"Rotate","level":4,"position":59,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":" The Rotate strategy is primarily a strategy for testing and demonstration purposes. When the tool is allowed to rotate freely, it turns the socket the specified angle using the lowest torque possible.      Parameter  Description  Default value    Target speed  Target speed for the Rotate strategy.     <Target speed>  Manual tool speed during the Rotate strategy.  16.5% of Tool max speed   Target angle  Angle to turn the spindle.  360°"},{"id":"4488377355","fileName":"448837735523858835083.html","title":"External Result","level":4,"position":60,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":" External result is a strategy used when an OK tightening is indicated by an external digital signal (and not by torque or angle values measured during tightening). When the signal is sent, the Result view will show the value of the Target parameter provided in the tightening program (specified torque value, angle value, or text string). These (torque and angle) values do not represent actual measured values, but only inserted text.      Parameter  Description  Default value    Torque <Target torque>  Numerical value for desired displayed target torque value  0.00   Angle <Target angle>  Numerical value for desired displayed target angle value  360°   Text  Alphanumerical string for desired displayed text.   "},{"id":"14272079755","fileName":"14272079755.html","title":"Running the External Result Tightening Strategy with a Tool Connected","level":5,"position":61,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","External Result"],"content":"    On the Home view, select the TighteningTab. Then, create a tightening program with External Resultstrategy.  Return to the Home view and select the Virtual StationTab.  In the Licenseswindow, the External Result Tightening Strategy with a Tool Connectedfeature requires a license to be assigned and used by a virtual station.  In the Toolwindow, select the necessary tool. Then, select the tool configuration.  In the Taskwindow, select the tightening program with an External Resultstrategy.  Send EXTERNAL_OKsignal to the Virtual Station.  Select Go Resultbutton to display the results. Results are sent from the Tool configuration for the tool connected to the Virtual Station. "},{"id":"14264962059","fileName":"14264962059.html","title":"Running the External Result Tightening Strategy without a Tool Connected","level":5,"position":62,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","External Result"],"content":"    On the Home view, select the TighteningTab. Then, create a tightening program with External Resultstrategy.  Return to the Home view and select the SettingsTab. Then, select External Tool.  Select the Plus icon at the upper-right corner of the GUI to create an external tool.  It is possible to create up to 10 External Tools configurations.  In the External Toolwindow, enter the model, the serial number and the description of the external tool.  Serial Number is a mandatory text box. The serial number can be used to provide an identifier for the necessary tool, for example the manufacturer serial number. The maximum number of characters for the Serial Number text box is 32.  Once the switch at the upper-right corner of the External Toolwindow is set to On, return to the Home view and select the ToolTab. The added external tool appears in the list of the available tools.  Return to the Home view and select the Virtual StationTab.  In the Licenseswindow, the External Result Tightening Strategy without a Tool Connectedfeature requires a license to be assigned and used by a virtual station.  In the Toolwindow, select the necessary external tool. Then, select the tool configuration.  In the Taskwindow, select the tightening program with an External Resultstrategy.  Send EXTERNAL_OKsignal to the Virtual Station.  Select Go Resultbutton to display the results (serial numbers). Serial numbers are sent from the External Tool configuration for the tool connected to the Virtual Station. "},{"id":"61978763","fileName":"6197876323858828171.html","title":"Tightening Program and Error Reporting Validation","level":4,"position":63,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":" The tightening program automatically validates with the parameter rules and tool properties as soon as new values are entered or changes are made. If the validation detects any errors they are reported with an error description. "},{"id":"61982091","fileName":"61982091.html","title":"Validation Error Reporting","level":5,"position":64,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","Tightening Program and Error Reporting Validation"],"content":" If the validation gives an error, it is displayed with an icon next to the parameter or parameters causing the error. When you tap on the icon, a short description of the error is given.  Example(See image):     Target torqueis set to 25 Nm with Final torque limits set to Torque min23.75 Nm and Torque max24.5 Nm (this value is hidden by the pop-up window in the image).  When you tap on the validation error icon next to the Torque maxparameter, a short description of the error is given, saying that Target torqueis greater than Torque max(Torque max <= Target torque).  To fix the error, adjust the Torque maxvalue so that it is greater than Target torque, and the error icon will disappear.  "},{"id":"61984651","fileName":"61984651.html","title":"Validate a Tool with a Tightening Program","level":5,"position":65,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs","Tightening Program and Error Reporting Validation"],"content":"    In the Tightening menu, choose Tightening program library or Multistep program library. If required, select a specific program in the list. Note that validation can be performed both for the entire list of programs, or for individual programs.  Select the tool iconin the upper right corner.  In the pop-up window, choose the tool to validate the tightening program against, and click Validate.  If a tightening program is not compatible with the selected tool, it will be indicated by a red circle with an exclamation point.  "},{"id":"8628337419","fileName":"8628337419.html","title":"Tightening Program Tool Compatibility Table","level":4,"position":66,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Programs"],"content":"   The availability of tightening strategies depends on the licenses installed on the controller.      Tightening Strategies  ES  ST  STR  SR  SB+  ETT  SL (low voltage)  QST  STB  SRB 2.0 ETP-SRB31-20  SRB 2.1 ETP-SRB31-25  SRB-HA  TBP \/ TBP-S  STW  External tool    Two step  X  X  X  X  X  X  X  X  X  X  -  X  -  -  -   Quick step  X  X  X  X  X  X  X  X  X  X  X  X  -  -  -   Three step  X  X  X  X  X  X  X  X  X  X  -  X  -  -  -   Turbo Tight  X  -  X  X*  -  X  -  -  -  X  X  -  -  -  -   Rotate  X  X  X  X  X  X  X  X  X  X  -  X  -  -  -   External Result  X  X  X  X  X  X  X  X  X  X  X  X  X  -  X   Tensor Pulse  -  -  -  -  -  -  -  -  -  X  X  -  -  -  -   Impulse - single step  -  -  -  -  -  -  -  -  -  -  -  -  X  -  -   Wrench production  -  -  -  -  -  -  -  -  -  -  -  -  -  X  -   Wrench quality  -  -  -  -  -  -  -  -  -  -  -  -  -  X  - * Available only for SR31.      Tightening Features  ES  ST  STR  SR  SB+  ETT  SL (low voltage)  QST  STB  SRB 2.0 ETP-SRB31-20  SRB 2.1 ETP-SRB31-25  TBP \/ TBP-S  STW  External tool    True Angle  -  -  X  -  -  X  -  -  -  -  -  -  -  -  "},{"id":"3922429963","fileName":"392242996323858841995.html","title":"Multistep Programs","level":3,"position":67,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab"],"content":"  Risk of injury  A change in the configuration of the tightening program may cause unexpected torque, rotational direction, or speed in the system(s) where the tightening program is currently in use. This could result in severe bodily injury and\/or property damage.   Check the tightening program configurations after adding a new program or after applying changes to an existing program.   Controller features, such as the Low Reaction Tightening Strategies and controller-wide functions among others, require licenses distributed through the Functionality Management System (FMS). Whereas configuration of features is possible without specific licenses, the assignment and use of those features will require the correct license to be installed on the controller. Please refer to Licenses (FMS) for more detailed information on licenses.  A multistep tightening is a tightening done in several steps. The number of steps and the type of steps vary depending on the tightening to be done. A multistep tightening program is highly configurable, including monitoring function and restrictions.  The multistep tightening strategy has not been implemented for STB tools. Product Essentials Tutorials  https:\/\/www.youtube.com\/watch?v=x1PbTNkwzuE "},{"id":"5148073227","fileName":"5148073227.html","title":"Multistep GUI Interface","level":4,"position":68,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs"],"content":"  While multistep tightening programs can be selected from the controller screen, editingprograms can only be done in the web GUI. The interface for mutistep programs can be divided into three main areas.  On topthere is a drop-down menu containing the Properties of the multistep tightening program. Here general properties such as program name, overal program monitor and validation can be filled out.  To the rightthere are three tabs containing the steps, monitors and restrictions that can be used to build the multistep program. To use any of the items, click on the appropriate tab, and drag the item in the list to the tightening area. Depending on its funtion, either drop the item between the beginning and the end of the program (for steps), or on top of a particular step (for monitors and restrictions). The main area of the interface is made up of the tightening area. This is the area that includes all the steps in the tightening program. At bottom left of the screen there are zoom buttons (+ and -), as well as a Delete button. Use the zoom buttons to zoom in and out on the tightening area."},{"id":"22163558155","fileName":"2216355815523858848395.html","title":"Tightening Steps","level":4,"position":69,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs"],"content":"   The availability of tightening steps, monitors and restrictions depends on the license installed on the controller. General Parameters The following step parameters are common for many of the step types. The parameters are set in the step properties window which is displayed when selecting a step in the tightening program.      Parameter  Description     Name  Name of the step.    Rotational direction  Each of the tightening steps can run either forward, that is to make a tightening, or reverse, to loosen the screw slightly. The arrows indicate this direction. Many of the tightening steps have a direction hard-coded to forward, for example Tighten to Angle, or Tighten to Torque. Steps such as Loosen to Angleor Loosen to Torquehave their direction automatically set to reverse.  The reversesetting is not allowed for tools configured with Gear Front Attachment (GFA) of type open end. The tightening direction of the tightening program must be the same as the tightening direction of the open end tool for a tightening to be allowed to be run. It is possible to assign a loosening program to a tightening program for an open end tool, but if the direction switch is set to run the loosening program, the tool will be locked.    Step category  For each step, there is an option to choose a step category. By selecting step category, the NOK tightenings will be listed in the event result view with related detailed status together with the corresponding multistep error information. If no selection is made, the detailed status will be set to \"uncategorized multistep error\". The related detailed status can be customized.    Angle window  A joint is considered Hardif the screw is tightened to its full torque and it rotates 30 degrees (or less) after it has been tightened to its snug point. A Softjoint rotates 720 degrees or more after it has been tightened to its snug point. The hardness parameter defines the Angle Windowfor the gradient calculation. The harder the joint - the smaller the angle window.    Speed Ramp \/ Acceleration (only available in ToolsTalk 2)  For most of the steps it is possible to specify how the acceleration to the target speed should be achieved. Three different settings are possible; Hard, Soft and Manual. The acceleration defined will be used whenever a step is started. Regardless whether the tool is already running with speed at the beginning of the step, the ramp will be used to accelerate to the target speed of the step. This will be the case even if the speed at the start of the step is higher, or lower than the target speed.    Speed ramp - Hardand Softmode     Hard:2000 rpm\/s (Speed Ramp between 1000 and 10000 rpm\/s is a Hard acceleration.)   Soft:500 rpm\/s (Speed Ramp between 200 and 1000 rpm\/s is a Soft acceleration.)    Speed ramp - Manualmode    Speed:   Default value: 60 rpm  Minimum limit: > 0  Maximum limit: ≤ Tool Max Speed  Acceleration:   Default value: 500 rpm\/s  Minimum limit: > 0  Maximum limit: ≤ Tool Max Acceleration    Using speed shifts  1−5 angle triggers or torque triggers can be defined during a step, where the speed will shift. Within one step, all the speed shift triggers are based on the same property, that is either torque or angle. They cannot be mixed within one step. The Torque triggers and Angle triggers must be less than the step target, depending on the type of the step and the trigger type. The Torque trigger and Torque speed also validate against the Max torque and Max speed of the tool. A warning or error indicator occurs whenever the Speed Shift settings exceed either the tool max values, or step max values. The Torque triggers and Angle triggers must be less than the step target, depending on the type of the step and the trigger type. The Torque trigger and Torque speed also validate against the Max torque and Max speed of the tool. A warning or error indicator occurs whenever the Speed Shift settings exceed either the tool max values, or step max values.  It is possible to push the settings to the tool when a tightening program has a warning, but not when a tightening program has an error (fault) indicator. The speed shifts can be added in the Configurationfield. To add a speed shift: In the dialog box of a step that can have speed shifts, select Add speed shift. Then, select an angle range or a torque range. The Speed Shift Angle\/Torque fields open. Add values according to the table below:    Angle\/Torque trigger: Must be > 0  Speed: Must be > 0  Speed ramp type: Hard or soft    Brake type  The braking behavior of a multistep tightening program can be controlled at two possible locations in the program: in a step preceding a reversal of direction of the tightening, and\/or at the final step of the tightening program. At other locations in the tightening program, the braking parameters will not be available in the step's general settings. Braking can be set to either Ergo stopor Inertia. Inertiawill brake the tool completely, while Ergo stopwill allow for a more ergonomic slowing down of the tightening.  Inertiahas no additional parameters.  Ergo stopparameters:    Adaptive brake:Set the Adaptive Brake to Onor Off   Ramp time:Only available when Adaptive Brake is set to Off. Insert time in ms.  The following tightening steps are not supported for tools configured with Gear Front Attachment (GFA) of type open end:   A - Tighten to Angle \/ Loosen to Angle  TrR - Loosen to Trigger Release  T - Tighten to Torque \/ Loosen to Torque  E - Engage  SR - Socket Release  DT - Tighten to DynaTork  TP - TensorPulse Trace Settings When the trace configuration is enabled on the program level, the trace resolution can be configured on step level. The setting for Trace Settingdefines how the sampling should be done on each specific step.      Parameter  Description     Trace Setting     Program: Use the settings as defined on program level.   Manual: The trace sample type from the program level will be used, that is, Time or Angle. Using a different sample rate will override the setting on the program level.    Sample Time  Choose the sample time from the drop-down list (0.25 - 1000 ms)    Sample Angle  Choose the sample angle from the drop-down list (0.25 - 20 degree) With this trace recording the sample rates will not be the same in all the steps, instead the sample rate depends on the configuration in each step. This means the trace is divided into one trace for each step. The maximum number of samples in a trace is 4096. If a tightening produce more than 4096 values a down-sampling will take place. This is done by removing every second trace sample from the whole tightening and when continue the recording with half the resolution. This process will be repeated every time the 4096 sample limit is reached. If more than 2048 in total was recorded, this process will result in a trace between 2048 and 4096 samples. If the limit if 4096 samples is reached the configured trace sample times will no longer be followed. Instead the sample times will be doubled or quadrupled etc., depending on how many times the down sampling has taken place. Since all steps are down sampled the relation between the steps will still be the same though. If a step was configured with double sample time compared to another step, this will still be the case in the final trace regardless how many times a down-sampling has occurred. If more than 4096 samples is recorded, the configured trace sample times will no longer be followed. Instead the sample times will be doubled or quadrupled, etc., depending on how many times the down sampling has taken place. Since all steps are down sampled the relation between the steps will still be the same though. If a step was configured with double sample time compared to another step, this will still be the case in the final trace regardless how many times a down-sampling has occurred.      Trace channel  Note    Torque  Available for all tools equipped with a torque transducer   Angle  Available for all tools   Torque Second  Only available for tools with two torque transducers   Angle Second  Only available for tools with two angle transducers   Current  Available for all tools   Gradient  Available if some step\/restriction\/monitor produces the gradient values   Available tools per each system types     Power Focus 6000 \/ Power Focus 8  Power Focus 6000 StepSync \/ Power Focus 8 StepSync  Flex  IxB    ST  ST  QST  IxB   STR  STR     SL  QST     QST      STB      IxB      Power Focus Connect         Tightening Steps  Tools     title-item   list "},{"id":"21408791307","fileName":"21408791307.html","title":"A – Tighten to Angle \/ Loosen to Angle","level":5,"position":70,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB IXB  A – Tighten to Angle This step runs the tool until the target angle is reached. The target angle is measured from the start of the step.  A – Loosen to Angle This step runs the tool with the speed n in the backward direction until the angle target is reached. The target angle is measured from the start of the step.  This step is not supported for tools configured with Gear Front Attachment (GFA) of type open end.   Parameters     Parameter  Description     Target angle  The angle target. Must be > 0.    Speed  Default: 60 rpm.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Speed ramp  If Speed ramp type is Manual, this field opens. Default: 500 rpm\/s.    Brake (Valid only for Power Focus 6000 StepSync, Power Focus 8 StepSync, and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.       A  Target Angle Microvideo  A - Tighten to Angle \/ Loosen to Angle   "},{"id":"21408783627","fileName":"21408783627.html","title":"C - Clutch","level":5,"position":71,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    BCV BCP This step will run the tool with the programmed Speed in forward direction until the Clutch has been released. When the tool has reported the release of the Clutch the step will finish with OK status. A tightening program using the Clutch step cannot have any other step assigned. This step is only valid for the Clutch tools BCV-RE and BCP-RE.      Parameter  Description     Speed Control  One Speed or Two Speed    Final Speed  Sets the final speed of the program [rpm]    Speed Ramp  Switch where speed ramp can be chosen [Hard, Soft]    Rehit  Rehit detection set to On or Off    Rehit angle  Sets the rehit angle [°]"},{"id":"21408785163","fileName":"21408785163.html","title":"CL - Clutch Loosening","level":5,"position":72,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    BCV BCP This step will run the tool with the programmed speed in reverse direction until the tool trigger is released. A loosening program using the Clutch step can not have any other step assigned. This step is only valid for the Clutch tools BCV-RE and BCP-RE.      Parameter  Description     Final  Sets the speed of the program [rpm]"},{"id":"21408789771","fileName":"21408789771.html","title":"DI – Run Until Digital Input","level":5,"position":73,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST This steps runs the tool, in the direction defined by parameter Direction, until the input specified by Digital Inputgoes high or low depending on the value of Stop Condition.      Parameter  Description     Direction  Forward, or Backward    Digital Input  One of the following local digital inputs on the controller can be selected:   Local DI 1  Local DI 2  Local DI 3  Local DI 4    Brake (Valid only for Power Focus 6000 StepSync, Power Focus 8 StepSync, and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.    Stop Condition     Falling edge: The steps runs until a falling edge is detected after step start.   Rising edge: The steps runs until a rising edge is detected after step start.   Any edge: The step runs until a falling or a rising edge is detected after step start.   Low: The step runs until low value is detected.   High: The step runs until high value is detected.    Speed (rpm)  Default: 60 rpm.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Speed ramp  Available if Speed ramp typeis Manual. Default: 500 rpm\/s. Microvideo  DI - Run Until Digital Input  "},{"id":"21408857611","fileName":"21408857611.html","title":"DT – Tighten to DynaTork","level":5,"position":74,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB  This step is not supported for tools configured with Gear Front Attachment (GFA) of type open end. This step runs the tool with speed n in the forward direction until the Target torqueis reached. The tool will then hold the current constant at the DynaTork Percentageof Target torqueduring the DynaTork time.  To avoid overheating of the tool, it is strongly recommended to never run DynaTork to more than 40% of the maximum torque of the tool.      Parameter  Description     Target torque  The torque target. Must be > 0.    DynaTork Time  The time DynaTork will be active.    DynaTork Percentage  The percentage of Torque target.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Speed ramp  If Speed ramp type is Manual, this field opens. Default: 500 rpm\/s.    Speed (rpm)  Default: 60 rpm.    Brake (Valid only for Power Focus 6000 StepSync, Power Focus 8 StepSync, and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.       A  Target Torque   B  Torque level retained during DynaTork Time   C  Percentage of Ts   D  Percentage of Ts   E  Torque level retained during DynaTork Time   F  DynaTork Time Microvideo  DT - Tighten to DynaTork   "},{"id":"21408893195","fileName":"21408893195.html","title":"E - Engage","level":5,"position":75,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST IXB  This step is not supported for tools configured with Gear Front Attachment (GFA) of type open end. This step runs the tool in both directions until the socket engages the screw. The step continues until Target torqueor Target angleis reached, provided that Continue if not Engagedis set to Yes. If Target Angle is reached in any direction, the direction is reversed. Limit the search iterations by entering Max Engage Attempts. If Target Torque is reached in any direction the step will finish with OKstatus. Microvideo  E- Engage  "},{"id":"21408894731","fileName":"21408894731.html","title":"Ext - External Result","level":5,"position":76,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB IXB BCP BCV External Tool External result is a strategy used when an OK tightening is indicated by an external digital signal (and not by torque or angle values measured during tightening). This external signal can be provided through any means that can provide a digital signal into the controller (e.g through the I\/O bus). When the signal is sent, the result view (logged data) will show the value of the Target parameter provided in the tightening program (specified torque value, angle value, or text string). These (torque and angle) values do not represent actual measured values, but only inserted text.      Parameter  Description     Torque <Target torque>  Numerical value for desired displayed target torque value. A signal could for example come from a Click Wrench and display <Target torque>.    Angle <Target angle>  Numerical value for desired displayed target angle value. A signal could for example come from a Click Wrench and display <Target angle>.    Text  Alphanumerical string for desired displayed text. For example: \"Oil has been changed\"."},{"id":"21408897803","fileName":"21408897803.html","title":"MWR - Mechatronic Wrench","level":5,"position":77,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    MWR Mechatronic Wrench is a specialized step that can be used only in conjunction with the Mechatronic Wrench (MWR). This step cannot be used in combination with other steps. No restrictions can be used with this step. By default, the step has three monitors: Peak Torque, Angle, and Click.      Parameter  Description     Loosening limit  Numerical value for negative torque (i.e. torque in the loosening direction) at which point the tightening result is marked as NOK (False direction of tightening (loosen)); in Nm.    Tool Size  Numerical value for the specific length of the end fitting tool installed on the MWR-TA; in mm.    Tool Bend  Numerical value for the end fitting tool installed on the MWR-TA; in °\/Nm.    Rehit Angle Window  Numerical value for the angle for determining if the screw was already tightened if the torque is reached; in °.    Max Angular Rate  Numerical value for the max rate at which the screw can be tightened; in °\/s."},{"id":"21408862219","fileName":"21408862219.html","title":"RD – Rundown","level":5,"position":78,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST IXB Rundown step is the part of the tightening from when the screw enters the thread until just before the screw head touches the underlying surface and snug point is reached. The torque required during rundown does not contribute to any clamping force. This step runs the tool with the speed in the forward direction, and depending on the Rundown Type, Torque or Snug the step behavior is as follows:  Rundown Type: To Torque: The step stops when the specified target torque is found.  Rundown Type: To Snug: The snug gradient calculation starts at the specified torque trigger level Tt. If no torque trigger is set the gradient calculation is started at the start of the step. The slope calculation is made between two angle points Addegrees apart and is calculated as: (Tn – Tn-1) \/ (An – An-1) and as soon as two slopes after each other are larger than TSLOPEthe snug point is found.      Parameter  Description     Rundown type   To Torqueor To Snug.    Target torque  Default: \"not set\". Must be > 0.    Speed  Default: 60 rpm. Must be > 0.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Speed ramp  If Speed ramp type is Manual, this field opens. Default: 500 rpm\/s.    Trigger Torque  If Rundown typeis To Snug, the Trigger torquefield is displayed. Default: \"not set\". Must be > 0.    Delta Angle  If Rundown typeis To Snug, the Delta anglefield is displayed. Default: \"0\". Must be > 0.    Torque Rate  If Rundown typeis To Snug, the Torque ratefield is displayed. Default: \"0\". Must be > 0.    Brake (Valid only for Power Focus 6000 StepSync, Power Focus 8 StepSync, and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.       A  Snug Point   B  Angle Delta   C  Torque Slope   D  Torque Target   E  Torque Trigger  "},{"id":"21408788235","fileName":"21408788235.html","title":"SR - Socket Release","level":5,"position":79,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB IXB  This step is not supported for tools configured with Gear Front Attachment (GFA) of type open end. This step runs the tool with speed n in the backward direction until the target angle is reached. The target angle is measured from the start of the step. This step is only allowed to use as the last step in the tightening path of a multistep tightening program. However, it is possible to add a sync point after this step.      Parameter  Description     Target angle  The angle target. Default: 3 degrees, must be > 0    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Speed ramp  If Speed ramp type is Manual, this field opens. Default: 500 rpm\/s.    Speed  Default: 60 rpm."},{"id":"22265219467","fileName":"22265219467.html","title":"SZP - Set Zero Position","level":5,"position":80,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST The step Set Zero Position sends out the signal set zero position to the tool. The position is repeated once every 360 degrees. With the steps Loosen to Zero Position or Tighten to Zero Position it is possible to return the tool to zero position. This step does not have any parameters.  The zero position is a specific position stored with either a “Set Zero Position” step or the signal “Set Zero Position”. The position is repeated once every 360 degrees."},{"id":"21408810251","fileName":"21408810251.html","title":"T - Tighten to Torque \/ Loosen to Torque","level":5,"position":81,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB IXB  T – Tighten to Torque This step runs the tool with the programmed speed in forward direction until the target torque is reached.      Parameter  Description     Target torque  The torque target. Must be > 0.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Speed  Default: 60 rpm. Must be > 0.    Speed ramp  If Speed ramp type is Manual, this field opens. Default: 500 rpm\/s.    Brake (Valid only for Power Focus 6000 StepSync, Power Focus 8 StepSync, and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool. Microvideo  T - Tighten to Torque  T – Loosen to Torque  This step is not supported for tools configured with Gear Front Attachment (GFA) of type open end. This step runs the tool with the speed in the backward direction. For the step to be active, the torque must first exceed 110 % of the Target torque. The Target torque should be set to a positive value. After reaching the target torque, the step runs until the torque drops below the target torque.      Parameter  Description     Target torque  The torque target. Must be > 0.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Speed  Default: 60 rpm. Must be > 0.    Speed ramp  If Speed ramp type is Manual, this field opens. Default: 500 rpm\/s.    Brake (Valid only for Power Focus 6000 StepSync, Power Focus 8 StepSync, and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.       A  Target Torque   "},{"id":"21408856075","fileName":"21408856075.html","title":"T&A – Tighten to Torque and Angle","level":5,"position":82,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB IXB This tightening step runs the tool with the given speed in the forward direction until both the target torque and the target angle are reached. The torque measurement starts at the beginning of the step. If the torque trigger is NOT set, the angle measurement starts at the beginning of the step. If the torque trigger is set, the angle measurement starts when the torque trigger is reached. The step ends when: Measured Torque >= Target Torque (Ts) AND (Measured Angle - Angle Measured at Torque Trigger) >= Target Angle (As).      Parameter  Description     Target torque (Ts)  Default value: 0. Must be > 0 and <= Tool Max Torque.    Target angle (As)  Default value: 0. Must be > 0.    Torque Trigger (Tt)  Default value: NOT set. Must be > 0 and < Target torque (Ts).    Speed (n)  Default: 60 rpm. Must be > 0 and <= Tool Max Speed.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, Speed ramp typeopens automatically.    Brake (Valid only for Power Focus 6000 StepSync, Power Focus 8 StepSync, and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.  Tightening to Torque AND Angle, without Torque Trigger set      A  Target Torque   B  Target Angle  Tightening to Torque AND Angle, with Torque Trigger set      A  Target Torque   B  Torque Trigger   C  Target Angle   "},{"id":"21408854539","fileName":"21408854539.html","title":"T|A – Tighten to Torque or Angle","level":5,"position":83,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB IXB This tightening step runs the tool with the given speed in the forward direction until either the target torque or the target angle is reached. The torque measurement starts at the beginning of the step. If the torque trigger is NOT set, the angle measurement starts at the beginning of the step. If the torque trigger is set, the angle measurement starts when the torque trigger is reached. The step ends when: Measured Torque >= Target Torque (Ts) OR (Measured Angle - Angle Measured at Torque Trigger) >= Target Angle (As).      Parameter  Description     Target torque (Ts)  Default value: 0. Must be > 0 and <= Tool Max Torque.    Target angle (As)  Default value: 0. Must be > 0.    Torque Trigger (Tt)  Default value: NOT set. Must be > 0 and < Target torque (Ts).    Speed (n)  Default: 60 rpm. Must be > 0 and <= Tool Max Speed.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, Speed ramp typeopens automatically.    Brake (Valid only for Power Focus 6000 StepSync, Power Focus 8 StepSync, and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.  Tightening to Torque OR Angle, without Torque Trigger set      A  Target Torque   B  Target Angle  Tighten to Torque OR Angle, with Torque Trigger set      A  Target Torque   B  Torque Trigger   C  Target Angle   "},{"id":"21408811787","fileName":"21408811787.html","title":"T+A – Tighten to Torque Plus Angle","level":5,"position":84,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB IXB This step runs the tool until the target torque is reached. From this point it continues to run an additional target angle.      Parameter  Description     Target torque  The torque target. Must be > 0.    Target angle  The angle target. Must be > 0.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Speed ramp  If Speed ramp type is Manual, this field opens. Default: 500 rpm\/s.    Speed  Default: 60 rpm.    Brake (Valid only for Power Focus 6000 StepSync, Power Focus 8 StepSync, and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.       A  Target Torque   B  Target Angle  "},{"id":"21408896267","fileName":"21408896267.html","title":"TC - Torque Calibration","level":5,"position":85,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    QST  This step is only supported for dual transducer tools. The Torque Calibrationstep runs the tool with the specified speed in the forward direction until the torque target is reached.      Parameter  Description     Target torque  Must be > 0.    Speed  Must be > 0. Default: 60 rpm.    Transducer   Mainor Secondary. Default: Main. Set to Secondaryin order to calibrate the front transducer.    Adaptive brake (Valid only for Power Focus 6000 StepSync, Power Focus 8 StepSync, and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool."},{"id":"21408860683","fileName":"21408860683.html","title":"ThCT – Thread Cutting to Torque","level":5,"position":86,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB IXB The Thread Cutting to Torquefunction enables tightening where the Rundown torque required is greater than the Rundown completetorque, for example when tightening thin layers of metal using self-threading (or self-tapping) screws. The tool runs in forward direction until the Thread Cutting Angle(Aw) is reached. The thread cutting angle window is measured from when the torque passes Thread Cut Trigger Torque(Ttc) for the first time. From the point where Thread cutting angle is reached, the step continues to run until the Target Torque(Tt) is reached.      Parameter  Description     Target torque  Must be > 0.    Thread Cutting Angle Window  Default: 0. Must be > 0.    Trigger Torque  The angle measurement starts at this trigger.    Speed  Default: 60 rpm. Must be > 0.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Brake (Valid only for Power Focus 6000 StepSync, Power Focus 8 StepSync, and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.       A  Target Torque   B  Torque Trigger   C  Thread Cutting Angle Window  "},{"id":"21408912267","fileName":"21408912267.html","title":"TP - TensorPulse","level":5,"position":87,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    STR  Before using TensorPulsetightening step, it is mandatory that the following license type is installed on the controller:    Low Reaction Strategies   TensorPulseis valid only for the following tools: ETV-STR61-100-13, ETV-STR61-70-13, ETV-STR61-50-10.  This step is not supported for tools configured with Gear Front Attachment (GFA) of type open end. This step generates tightening pulses in the forward direction, until the torque target is reached. If running TensorPulsetightening step, use the necessary PulseDrive socket\/adapter. If TensorPulsetightening step runs without the PulseDrive socket\/adapter, all the tightenings are NOK. The step error “PulseDrive socket\/adapter not detected” shows for no PulseDrive socket\/adapter.      Parameter  Description     Torque Target - Ts  Torque Target must range from 0 through the maximum torque of the tool.    Pulse Energy - Pe  Pulse Energy is used to control the amount of energy\/current in each pulse. Pulse Energy must range from 10% through 100 %. By default, it is set to 100%.    Retention Force Tuning Factor  Retention Force Tuning Factor is used to tune the reaction force when running TensorPulsestep. It is the power that moves the tool in the opposite direction after each pulse. High tuning factor makes high reaction force and high pulse frequency; low tuning factor makes low reaction force and low pulse frequency. Retention Force Tuning Factor must range from 0 through 100 %. By default, it is set to 40%.  In the trace, the angle reversal means that the tool rotates backward to enable pulsing, but the bolt head does not necessarily rotate backward because of the PulseDrive socket\/adapter."},{"id":"21408805643","fileName":"21408805643.html","title":"TrR – Loosen to Trigger Release","level":5,"position":88,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR STB IXB  This step is not supported for tools configured with Gear Front Attachment (GFA) of type open end. This step runs in the backward direction until the tool trigger is released (loosen). It can only be used as a last step in a program. For STB tools, this step is only applicable for loosening programs.      Parameter  Description     Speed  Numerical value for rotation speed; in rpm.    Speed Ramp Type  List of options where speed ramp can be chosen [Hard, Soft, Manual]"},{"id":"21408807179","fileName":"21408807179.html","title":"TTTR – Tighten to Trigger Release","level":5,"position":89,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR STB IXB This step runs until the tool trigger is released (tighten). It can only be used as a last step in a tightening program.      Parameter  Description     Speed  Numerical value for rotation speed; in rpm.    Speed Ramp Type  List of options where speed ramp can be chosen [Hard, Soft, Manual]"},{"id":"21408786699","fileName":"21408786699.html","title":"W – Wait","level":5,"position":90,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST STB IXB In this step the tool waits until the Wait Typecondition is fulfilled. The tool does not rotate while waiting, but Hold conditioncan be specified.      Parameter  Description     Wait Type     Time: Wait specified time.   Signal (valid only for Power Focus 6000 StepSync): Wait until a rising edge on the signal Continue Step is received.    Wait Time  Number of seconds the tool will stand still - valid only when Timeis selected for Wait Type.    Hold Condition     No hold: The tool is waiting without running.   Hold torque: While waiting the tool strives to hold the torque it had when entering the step.   Hold position: While waiting the tool strives to hold the position it had when entering the step."},{"id":"21408909195","fileName":"21408909195.html","title":"WP - Wrench Production","level":5,"position":91,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    STwrench Strategy used for the quality test of the tightening performed with the STwrench.      Parameter  Description     Control Strategy  The Wrench Productionstep type can be configured with the following control strategies.    Torque: This strategy guides the operator is reaching the desired target torque.   Angle: This strategy guides the operator is reaching the desired target angle.   Torque or Angle: This strategy guides the operator is reaching the desired target angle or desired target torque.   Torque and Angle: This strategy guides the operator in tightening a bolt until both target torque and angle have been reached.   Yield Point: With this strategy, the STwrench detects the yield point automatically. The torque limits specify the range in which the result is OK. Target angle specifies how far beyond the yield point the user may tighten.   Loose: This strategy is used to loosen a tightened screw.   PVT compensate with snug: This strategy guides the operator in reaching the desired target torque for joints with prevailing torque, when the prevailing torque level is higher than the final target. Based on the control strategy selected, a combination of some of the parameters listed below will be displayed.      Parameters  Description     Target Torque  Defines the target torque for tightening step.    Measure torque at  Specifies where the torque will be measured. Choose between Peak torqueor Peak angle.    Peak torque: The torque value will be set to the peak torque value.   Peak Angle: The torque value will be set to the torque measured at the peak angle.    Angle search limit  This is an offset that is used to the set the torque result value for a tightening. Measure torque atmust be set to Peak Anglefor this parameter to be available.    Ratchet time  Numerical value for ratchet time which is by default 5000 ms. This allows the operator to release the torque for a while and recharge during the tightening operation. If the Ratchet timeis exceeded the result of the tightening is marked as NOK with the reason \"Tightening timeout\".    End cycle time  Numerical value in ms to indicate the end cycle time. Applied when torque goes below the rundown complete    Torque correction coefficient  The parameter is used to correct the torque reading when using an extension or torque multiplier on the wrench. Default value is 1.    Angle correction  The parameter is used to correct the angle reading when using an extension or torque multiplier on the wrench. Default value is 0.    Target Angle  Defines the target angle for tightening step.    Rehit detection   Onor Off. Rehit detection can be used to determine when a tightening is a rehit based on the angle limit setting. Angle limit for rehitis enabled if Rehit directionis set to On.    Linear slope coefficient  Linear slope coefficient characterizes the joint stiffness in the linear part of the curve, as torque\/angle slope in the Nm\/Deg measurement unit.    Compensate value  Choose between Average torqueand Peak torque. The Compensate value specifies how the PVT will be calculated.  Average torque- The PVT will be based on an average calculated using the following:   Delay monitoring  PVT interval  PVT distance  Prevailing torque min  Prevailing torque max  Peak torque- The PVT will be based on the peak value measured before snug was detected.    Delay monitoring  PVT calculation will not start before this window has been passed, starts at tightening start.    PVT interval  Sets how many degrees the PVT window shall be calculated for, start from the PVT distance point.    PVT distance  Sets how many degrees prior to snug the system shall start the PVT window.    Prevailing torque min  Prevailing torque minimum limit.    Prevailing torque max  Prevailing torque maximum limit Microvideo  WP - Wrench Production  "},{"id":"21408910731","fileName":"21408910731.html","title":"WQ - Wrench Quality","level":5,"position":92,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    STwrench Strategy used for the quality test of the tightening performed with the STwrench.      Parameter  Description     Control Strategy  The Wrench Qualitystrategy can be configured with the following control strategies.    Residual Torque\/Time: This strategy analyzes the torque trace as a function of time. The operator shall execute this operation with a single, steady, movement. The wrench automatically recognizes the breakaway and residual point.   Residual Torque\/Angle: This strategy evaluates the residual torque on a joint, looking for the residual point of the Torque\/Angle trace.   Residual Torque\/Peak: This strategy evaluates the residual torque on a joint as the peak torque necessary to rotate the bolt further.   Loose and Retighten: This strategy loosens a bolt and retightens it back to its original position   Yield Point: With this strategy the wrench detects the yield point automatically. Target Angle specifies how far beyond the yield point the user may tighten. Based on the control strategy selected, a combination of some of the parameters listed below will be displayed.      Parameters  Description     Ratchet time  Numerical value for ratchet time which is by default 5000 ms. This allows the operator to release the torque for a while and recharge during the tightening operation. If the Ratchet timeis exceeded the result of the tightening is marked as NOK with the reason \"Tightening timeout\".    Torque correction coefficient  The parameter is used to correct the torque reading when using an extension or torque multiplier on the wrench. Default value is 1.    Angle correction  The parameter is used to correct the angle reading when using an extension or torque multiplier on the wrench. Default value is 0.    Target Angle  Defines the target angle for tightening step.    Rehit detection   Onor Off. Rehit detection can be used to determine when a tightening is a rehit based on the angle limit setting. Angle limit for rehitis enabled if Rehit directionis set to On.    Linear slope coefficient  Linear slope coefficient characterizes the joint stiffness in the linear part of the curve, as torque\/angle slope in the Nm\/Deg measurement unit."},{"id":"21408859147","fileName":"21408859147.html","title":"Y – Tighten to Yield","level":5,"position":93,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST IXB This strategy runs the tool with the speed in the forward direction until the yield point is detected. The yield point is found by monitoring the torque gradient from the point where the torque goes above the Trigger Torquelevel, calculated based on Torque and Angle distance measurements. The Angle distance parameter is set according to the specified hardness of the joint. Set the Gradient angle window(for hard joint, for soft joint or for manually setting of the Angle window). If Manualis selected, the Angle Windowmust be set. A joint is considered Hardif the screw is tightened to its full torque and it rotates 30 degrees or less after it has been tightened to its snug point. A Softjoint rotates 720 degrees or more after it has been tightened to its snug point. The hardness parameter defines the Angle Window for the gradient calculation. The harder the joint - the smaller the angle window.      Parameter  Description     Gradient Angle Window  Specifies Angle Window:   For Hard Joint: Angle Window= 1 deg.  For Soft Joint: Angle Window= 20 deg.   Manual: Manually set Angle Window.    Angle Window  Available when Gradient Angle Windowis set to Manual. Must be > 0 and <= 100.    Trigger Torque  The angle measurement starts at this trigger. Must be >= 0 and < Tool MaxTorque.    Damping  Frequency in which the gradient is being calculated. Must be > 0 and < 100 and < Angle window.    Yield Point Percentage  Must be >= 20 %    Speed  Default: 60 rpm. Must be > 0.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Torque Filter Type  The type of the filter:    None: No filtering of the torque is used. The raw values are used as-is in the gradient calculation.   Five-point: The torque value used in the calculation are filtered using a sliding average filter over 5 torque samples.   Low pass: The torque values is filtered with a simple discrete Infinite Impulse Response filter.   Sliding Average: The torque values used in the calculation are filtered using a sliding average filter over a Number of Samplesspecified by the use.    Cut-off Frequency  Needs to be specified when Torque Filter Typeis set to Low pass:   20 Hz  40 Hz  90 Hz  200 Hz  600 Hz    Number of Samples  Needs to be specified when Torque Filter Typeis set to Sliding Average:   2  4  6  8  16  32    Brake (Valid only for Power Focus 6000 StepSync, Power Focus 8 StepSync, and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.       A  Peak Gradient   B  Yield Point   C  Shut-off Point   D  Angle Distance   E  Torque Trigger  "},{"id":"21408808715","fileName":"21408808715.html","title":"YM2 - Tighten to Yield: Method 2","level":5,"position":94,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    QST This step runs the tool with the specified speed in the forward direction until the yield point is detected. Search for the yield point starts when the torque has reached Tt. The average of the torque over Afdegrees is calculated. This procedure is repeated N rstimes. A reference slope is calculated with linear regression over the N rspoints. After that, new average values are continuously calculated over A fdegrees. The actual slope is calculated with linear regression over the last N saverage points. The yield point is reached when the slope is less than Py %of the reference slope.      Parameter  Description     Target torque  Must be > 0.    Filter angle  Default: 1. Must be > 0.    Number of samples  Default: 6. Must be >=4.    Number pf samples, reference  Default: 6. Must be >=4.    Yield point percentage  Default: 90%. Must be >20%.    Speed  Default: 60 rpm. Must be > 0.    Speed ramp type  Hard, soft, or manual. Default: Hard. If you select Manual, the Speed ramp field opens.    Speed ramp  If Speed ramp type is Manual, this field opens. Default: 500 rpm\/s.    Brake (Valid only for Power Focus 6000 StepSync, Power Focus 8 StepSync, and Flex).  If Onthe tool will be stopped when the target is reached. If Offthe program goes directly to the next step without stopping the tool.       A  Torque Trigger   B  Number of samples, ref   C  Actual Slope   D  Number of samples   E  Reference Slope   F  Filter Angle  "},{"id":"22265223307","fileName":"22265223307.html","title":"ZP - Loosen to Zero Position","level":5,"position":95,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST This step runs the tool with the speed (N) in the backward direction until it reaches the zero position. If the total angle to rotate to reach the zero position is less than the minimum angle (Am) degree the rotation will continue for one more revolution, 360 degrees.  The zero position is a specific position stored with either a “Set Zero Position” step or the signal “Set Zero Position”. The position is repeated once every 360 degrees.   Parameters     Parameter  Description    Minimum Angle  Minimum Angle (Am) [°]   Speed  Rotation speed (N) [rpm]. Default value 60 rpm."},{"id":"22265221387","fileName":"22265221387.html","title":"ZP - Tighten to Zero Position","level":5,"position":96,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Tightening Steps"],"content":"      Tools    ES STR SL ST SR QST This step runs the tool with the speed (N) in the forward direction until it reaches the zero position. If the total angle to rotate to reach the zero position is less than the minimum angle (Am) degree the rotation will continue for one more revolution, 360 degrees.  The zero position is a specific position stored with either a “Set Zero Position” step or the signal “Set Zero Position”. The position is repeated once every 360 degrees.   Parameters     Parameter  Description    Minimum Angle  Minimum Angle (Am) [°]   Speed  Rotation speed (N) [rpm]. Default value 60 rpm"},{"id":"22262063627","fileName":"2226206362723858855819.html","title":"Step Monitors","level":4,"position":97,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs"],"content":"   The availability of tightening steps, monitors and restrictions depends on the license installed on the controller. The step monitors are used to verify that the tightening was achieved according to the specification, for example, angle limits or torque. Each step has mandatory step monitors and optional step monitors. The mandatory monitors are included when dragging a new step to the multistep program. The optional monitors are flexible and can be placed as needed in the multistep program. Every step can have up to eight monitors each. The following monitors are automatically added to every step that is added to the multistep tightening program.  Default step monitors     Step Monitor  Applicable steps    Angle  All   Peak Torque  All   Available tools per each system types     Power Focus 6000 \/ Power Focus 8  Power Focus 6000 StepSync \/ Power Focus 8 StepSync  Flex  IxB    ST  ST  QST  IxB   STR  STR     SL  QST     QST      STB      IxB      Power Focus Connect         Step Monitors  Tools     title-item   list "},{"id":"21896040843","fileName":"21896040843.html","title":"A - Angle","level":5,"position":98,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB MWR-TA This step monitor measures the maximum angle reached during the monitor and checks that it is between High limitand Low limit. The angle measurement starts at the start of the monitor or, if specified, at the point where the torque passes Trigger torquefor the first time during the monitor.      Parameter  Description  Default value     Stop condition  It specifies where the angle measurement ends:    End End point used: the angle at the end of the monitor.   Peak Torque End point used: the angle at the point where the highest torque is reached during the monitor.   Shut Off End point used: the angle at the shut off point of the step.   Peak End point used: the highest angle reached during the monitor.  Shut Off    Trigger torque  The angle measurement starts at this trigger.  Minimum limit: must be >= 0  Maximum limit: must be < Tool Max Torque  Not set    Low Limit  Lowest acceptable angle.  Minimum limit: must be >= 0  Maximum limit: must be < 9 999 999 and < High Limit  Not set    High Limit  Highest acceptable angle.  Minimum limit: Must be > 0 and > Low Limit  Maximum limit: must be < 9 999 999  Not set Result Values    Angle Measured: the angle measured by the monitor.  Step Monitor Angle - Stop condition End      A  Shut-off point  D  Angle high limit   B  Torque trigger  E  Measured angle   C  Angle low limit  F  Step  Step Monitor Angle - Stop condition Peak Torque      A  Peak torque  E  Angle high limit   B  Shut-off point  F  Measured angle   C  Torque trigger  G  Step   D  Angle low limit    Step Monitor Angle, Stop condition Shut Off      A  Shut-off point  D  Angle high limit   B  Torque trigger  E  Measured angle   C  Angle low limit  F  Step  Step Monitor Angle - without Torque Trigger and with stop condition Peak      A  Shut-off point  D  Measured angle   B  Angle low limit  E  Step n-1   C  Angle high limit  F  Step n     "},{"id":"21896048267","fileName":"21896048267.html","title":"C - Current","level":5,"position":99,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB This monitor measures the actual current at any point after the torque passes Torque Trigger. The result will be the first peak or low value, that made the monitor NOK. In case of OK, the result will be the last measured current value. If the torque trigger is never reached during the monitor it will end with NOK status and no measurement value.      Parameter  Description    Torque Trigger  Must be >= 0 and < Tool Max Torque.   Low limit  Lowest acceptable current.   High limit  Highest acceptable current."},{"id":"21902805771","fileName":"21902805771.html","title":"Cl - Click","level":5,"position":100,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    MWR-T MWR-TA  This step monitor is not available for IxB tools. Monitor to enable click torque and click angle results. This monitor has no settings, and can only be used with the MWR step."},{"id":"21902835083","fileName":"21902835083.html","title":"LD - Loosening Detection","level":5,"position":101,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    STwrench  This step monitor is only available for STwrench tools This monitor can be used to check the torque and direction to see if a loosening is attempted when using the Wrench Productionstep strategy for an STwrench. If the applied torque is above the value set for Loosening Limitin the direction opposite to the configured thread direction of the program, the result shall be reported as NOK."},{"id":"21900544779","fileName":"21900544779.html","title":"MT - Mean Torque","level":5,"position":102,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST IXB This monitor measures the average torque during the monitor and checks the calculated value is within the limits.      Parameter  Description     Type  Specifies start condition:    Step Start: The measurement starts from step start and ends at the shut-off point.   Torque Trigger: The measurement starts at the point where the torque passes Torque Triggerfor the first time. It ends at the shut-off point.   Angle Trigger: The measurement starts at the point where the angle is Angle Trigger, measured from the optional Trigger Torque, is reached. Without Trigger Torque, the Angle Triggeris measured from the start of the step. It ends at the shut-off point   Angle Window: Measures during an Angle Window. The window starts at the point where the torque passes Trigger Torquefor the first time plus an angle offset, Angle Trigger.   Time Interval: Measures during the last Time Intervalseconds of the tightening.    Torque Trigger  Available when Typeis set to Trigger Torque, Angle Triggeror Angle Window. Must be >= 0 and < Tool Max Torque.    Angle Trigger  Available when Typeis set to Angle Triggeror Angle Window. Must be > 0.    Angle Window  Available when Typeis set to Angle Window. Must be > 0.     Time Interval  Available when Typeis set to Time Interval. Must be > 0.    Low Limit  Lowest acceptable torque.    High Limit  Highest acceptable torque."},{"id":"21902746763","fileName":"21902746763.html","title":"PC - Pulse Count","level":5,"position":103,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    STR  This step monitor is only available for the following tools:    ETV-STR61-100-13   ETV-STR61-70-13   ETV-STR61-50-10 Before using the Pulse Countstep monitor, the Low Reaction Strategieslicense must be installed on the controller. This monitor measures the number of pulses and confirms if it is between the pulse count low limit and pulse count high limit. If the torque trigger level is set, the check starts as soon as the measured torque is above the torque trigger level. If running a tightening step with Pulse Countstep monitor, use the necessary PulseDrive socket\/adapter. If the tightening step runs without the PulseDrive socket\/adapter, all the tightenings are NOK. The step error “PulseDrive socket\/adapter not detected” shows for no PulseDrive socket\/adapter.      Parameter  Description     Pulse Count High Limit - n+  The Pulse Count limits are used to determine if the measured number of pulses is OK or NOK. The measured number of pulses is OK if it is between the pulse count low limit and pulse count high limit. The measured number of pulses is NOK if:   It is higher than the pulse count high limit.  It is lower than the pulse count low limit.  The trigger torque level is not reached. Pulse count high limit must range from 1 through 9999999. It must be greater than or equal to the pulse count low limit.  Pulse Count High Limittext box can be empty.    Pulse Count Low Limit - n-  The Pulse Count limits are used to determine if the measured number of pulses is OK or NOK. The measured number of pulses is OK if it is between the pulse count low limit and pulse count high limit. The measured number of pulses is NOK if:   It is higher than the pulse count high limit.  It is lower than the pulse count low limit.  The trigger torque level is not reached. Pulse Count Low Limit must range from 1 through 9999999. It must be lower than or equal to the Pulse Count High Limit.  Pulse Count Low Limittext box can be empty.    Torque Trigger - Tt  Torque Trigger must range from 0 through the maximum torque of the tool.  Torque Triggertext box can be empty."},{"id":"21901847051","fileName":"21901847051.html","title":"PrT - Prevailing Torque","level":5,"position":104,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB The monitor calculates the prevailing torque value in the Window Lengthand checks that it is between the Torque limits. The Angle Window starts at the angle degrees set in Start Anglein reverse direction from the shut-off point. This then spans for the angle degrees set in Angle Window Length in reverse direction. If Start Angleis left blank the angle window starts at the shut-off point. The calculated prevailing torque value is the mean or peak torque value (depending on the parameter set by the user) during the Window Length. The calculated value is saved as result data Prevailing Torque Measured. If Torque compensationis set to On, the Prevailing Torque Measured will be subtracted from all torque result values in consecutive steps. Any previously calculated prevailing torque compensation values will no longer be subtracted from torque result values. If Torque compensationis set to Off, no subtraction will be made in consecutive steps. If the total angle of the step is less than the Start Angleplus Window Length, then the monitor will report NOK. Prevailing torque can be measured as an average of measured values, or at peak torque. To choose between these two modes, set the Use Valueparameter to either Mean torque(for average values), or Peak torque(for peak value).      Parameter  Description     Torque Compensation  On or off.    Start Angle  Must be > 0    Window length  Must be >= 0    Low Limit  Must be > 0    High Limit  Must be >= 0    Use value   Mean torque(for average values), or Peak torque(for peak value)."},{"id":"21900548491","fileName":"21900548491.html","title":"PT - Peak Torque","level":5,"position":105,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB MWR-TA MWR-T This step monitor measures the maximum torque reached during the monitor, including any over shoot, and checks that it is between High limitand Low limit.      Parameter  Description     Low Limit  Lowest acceptable torque.    High Limit  Highest acceptable torque."},{"id":"21900552203","fileName":"21900552203.html","title":"PTCA - Post Thread Cut Angle","level":5,"position":106,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB This step monitor measures the maximum angle reached during the monitor and checks that it is between High limitand Low limit. The Trigger Torquelevel is ignored until the end of the Thread cut angle windowis reached. After that, the angle measuring starts as soon as the measured torque is above Trigger Torque.      Parameter  Description  Default value     Stop condition  It specifies where the angle measurement ends:    End End point used: the angle at the end of the monitor.   Peak Torque End point used: the angle at the point where the highest torque was reached during the monitor.   Shut Off End point used: the angle at the shut off point of the step.   Peak End point used: the highest angle reached during the monitor.  Shut Off    Trigger torque  The angle measurement starts at this trigger.  Minimum limit: must be >= 0  Maximum limit: must be < Tool Max Torque  0    Low Limit  Lowest acceptable angle.  Minimum limit: must be >= 0  Maximum limit: must be < 9 999 999 and < High Limit  Not set    High Limit  Highest acceptable angle.  Minimum limit: Must be > 0 and > Low Limit  Maximum limit: must be < 9 999 999  Not set    Thread cut trigger torque   Minimum limit: must be >= 0  Maximum limit: must be < Tool Max Torque  Not set    Thread cut angle window   Minimum limit: must be >= 0  Maximum limit: must be < 9 999 999  0 Result Values    Angle Measured: the angle measured by the monitor.  Step Monitor - Post Thread Cut Angle      A  Shut-off point  E  Angle low limit   B  Torque trigger  F  Angle high limit   C  Torque trigger thread cut  G  Measured angle   D  Thread cut angle window    "},{"id":"21900555915","fileName":"21900555915.html","title":"PTCPT - Post Thread Cut Peak Torque","level":5,"position":107,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB Measures the maximum torque achieved during the monitoring, including any over-shoot, and checks that it is between the Torque limits. All torque values are ignored until the end of the Thread cut angle windowhas been reached.      Parameter  Description     Thread cut trigger torque  Must be >= 0    Thread cutting angle window  Must be > 0    Low Limit  Must be >= 0    High Limit  Must be > 0 Must be > Low limit"},{"id":"21901839627","fileName":"21901839627.html","title":"PVTH - Post View Torque High","level":5,"position":108,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB This monitor checks that all torque values in the Angle Window Lengthare below the High limit. The Angle Window starts at the angle degrees set in Start Anglein reverse direction from the shut-off point. This then spans for the angle degrees set in Angle Window Length in reverse direction. If Start Angle is left blank, the Angle Window starts at the shut-off point. The torque values used in the monitor are based on the mean torque value, calculated over Number of Samples. If the total angle of the step is less than Start Angle plus Angle Window Length the monitor will report NOK.      Parameter  Description     Start Angle  Must be >= 0    Window length  Must be > 0    Number of samples  Minimum value =1 Maximum value = 80    High Limit  Highest acceptable torque."},{"id":"21901843339","fileName":"21901843339.html","title":"PVTL - Post View Torque Low","level":5,"position":109,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB Same as monitor Post View Torque High, but this monitor checks that all torque values in the Angle Window Lengthare above Low Limitinstead.      Parameter  Description     Start Angle  Must be >= 0    Window length  Must be > 0    Number of samples  Minimum value =1 Maximum value = 80    Low Limit  Lowest acceptable torque."},{"id":"21902754187","fileName":"21902754187.html","title":"SOC - Shut Off Current","level":5,"position":110,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB The shut off point is the point where the step reaches its target. The current is measured at the shut off point and checked to be between High limitand Low limit.      Parameter  Description     Low Limit  Lowest acceptable current.    High Limit  Highest acceptable current."},{"id":"21902750475","fileName":"21902750475.html","title":"SOT - Shut Off Torque","level":5,"position":111,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB The shut off point is the point where the step reaches its target. The torque is measured at the shut off point and checked to be between High limitand Low limit.      Parameter  Description     Low Limit  Lowest acceptable torque.    High Limit  Highest acceptable torque."},{"id":"21902757899","fileName":"21902757899.html","title":"SSD - Stick Slip Detection","level":5,"position":112,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST IXB This step monitor detects and reports stick slip effects during a step. The detection is done by counting the number of times the torque falls below the Trigger Level. If the number of times is larger than Maximum Number of Oscillationsthen the stick slip error is reported. The monitor operates in two different modes, Dynamicor Fixed. The difference between the modes is the way that the Trigger level is calculated.  Dynamic Torque: Trigger Levelis dynamically calculated as Peak Torque Percentageof the current max torque, which has been achieved so far during the monitoring. The monitoring is started as soon as the torque passes the Trigger Torque.  Fixed Torque: Trigger Levelis the fixed Trigger Torquespecified by the user. In this mode the percentage is not needed. If the torque never reaches the Trigger Torquethen the monitoring is not started, this will result in status NOK.      Parameter  Description     Type  Specifies what type of Stick slip detection that will be done in the monitor Stick Slip detection. Default: Dynamic torque.    Peak Torque Percentage  Default: 80%, Must be >=10 and < 100.    Trigger Torque  Default: 5, Must be >= 0 and < Tool max torque.    Maximum Number of Oscillations  Default: 5, Must be >= 3 and <20."},{"id":"21902798347","fileName":"21902798347.html","title":"TAW - Torque in Angle Window","level":5,"position":113,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB This monitor checks that all torque values in the angle window are within the torque limits.      Parameter  Description     Trigger Torque  Must be >= 0    Start Angle  Must be > 0    Window Length  Must be <= 0    Low Limit  Must be >= 0    High Limit  Must be > 0 Must be > Low limit   NOK if window is passed  If set to Yes, status of this monitor is NOK if the end of angle window is not reached."},{"id":"21902769035","fileName":"21902769035.html","title":"TC - Torque Calibration","level":5,"position":114,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    QST  This step monitor is only available for tools equipped with dual transducers. The Torque Calibrationmonitor checks if the maximum torque reached is within the torque limits.      Parameter  Description     Transducer type   Mainor Secondary Set to Secondaryfor the front transducer of the tool.    Low limit  Must be >= 0    High limit  Must be > 0 Must be > Low limit"},{"id":"21902765323","fileName":"21902765323.html","title":"TG - Torque Gradient","level":5,"position":115,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST IXB This monitor checks that the gradient is within the limit.      Parameter  Description     Gradient Angle Window  Specifies Angle Window:   For Hard Joint: Angle Window= 1 deg.  For Soft Joint: Angle Window= 20 deg.   Manual: Manually set Angle Window.    Angle Window  Available when Gradient Angle Windowis set to Manual. Must be > 0 and <= 100.    End Point Check  If set to Yes, only the gradient measured at the shut off point of the step is checked to be within the limits.    Trigger Torque  The angle measurement starts at this trigger. Must be > 0 and < Tool MaxTorque.    Damping  Frequency in which the gradient is being calculated. Must be > 0 and < 100 and < Angle window.    Low Limit  Lowest acceptable torque gradient. Must be >= -100.    High Limit  Highest acceptable torque gradient. Must be > -100 and > Low limit.    Torque Filter Type  The type of the filter:    None: No filtering of the torque is used. The raw values are used as-is in the gradient calculation.   Five-point: The torque value used in the calculation are filtered using a sliding average filter over 5 torque samples.   Low pass: The torque values is filtered with a simple discrete Infinite Impulse Response filter.   Sliding Average: The torque values used in the calculation are filtered using a sliding average filter over a Number of Samplesspecified by the use.    Cut-off Frequency  Needs to be specified when Torque Filter Typeis set to Low pass:   20 Hz  40 Hz  90 Hz  200 Hz  600 Hz    Number of Samples  Needs to be specified when Torque Filter Typeis set to Sliding Average:   2  4  6  8  16  32    Angle Offset  Available when End Point Checkis set to No. Specifies the degrees that the calculation of the gradient start after the trigger torque is passed for the first time."},{"id":"21902761611","fileName":"21902761611.html","title":"Ti - Time","level":5,"position":116,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST STB IXB Measures the elapsed time during the monitor and checks that it is between the time limits. The time measurement starts at the start of the monitor and, if the Trigger Torque is specified, at the point where the torque passes Trigger Torque for the first time during the monitor.      Parameter  Description     Trigger Torque  Must be >= 0 and < Tool max torque.    Low Limit  Must be >= 0    High Limit  Must be > 0 Must be > Low limit"},{"id":"21902802059","fileName":"21902802059.html","title":"TRD - Torque Rate and Deviation","level":5,"position":117,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST IXB This step monitor measures and checks the torque rate, i.e. the ratio of torque vs. angle. The calculated torque rate is checked if it is within the torque rate limits defined by High Limitand Low Limit.      Parameter  Description     Trigger Torque  Torque of the angle start point.    Start Point Angle  When Start point angle has been measured from Trigger torque the measuring of the torque starts.    End Point Angle  Angle point where the measuring of the torque is stopped.    End Point Torque  Torque where the measuring of the torque is stopped.    Low Limit  Lowest acceptable torque.    High Limit  Highest acceptable torque.    Limit  Must be > 0"},{"id":"21896044555","fileName":"21896044555.html","title":"YA - Angle from Yield","level":5,"position":118,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Monitors"],"content":"      Tools    ES STR SL ST SR QST IXB This monitor measures the peak angle reached from the yield point and checks that the peak angle is within the limit.      Parameter  Description     Gradient Angle Window  Specifies Angle Window:   For Hard Joint: Angle Window= 1 deg.  For Soft Joint: Angle Window= 20 deg.   Manual: Manually set Angle Window.    Angle Window  Available when Gradient Angle Windowis set to Manual. Must be > 0 and <= 100.    Yield Point Percentage  Must be >= 20 %    Trigger Torque  The angle measurement starts at this trigger. Must be > 0 and < Tool MaxTorque.    Damping  Frequency in which the gradient is being calculated. Must be > 0 and < 100 and < Angle window.    Low Limit  Lowest acceptable angle. Must be >= 0    High Limit  Highest acceptable angle. Must be > 0    Torque Filter Type  The type of the filter:    None: No filtering of the torque is used. The raw values are used as-is in the gradient calculation.   Five-point: The torque value used in the calculation are filtered using a sliding average filter over 5 torque samples.   Low pass: The torque values is filtered with a simple discrete Infinite Impulse Response filter.   Sliding Average: The torque values used in the calculation are filtered using a sliding average filter over a Number of Samplesspecified by the use.    Cut-off Frequency  Needs to be specified when Torque Filter Typeis set to Low pass:   20 Hz  40 Hz  90 Hz  200 Hz  600 Hz    Number of Samples  Needs to be specified when Torque Filter Typeis set to Sliding Average:   2  4  6  8  16  32"},{"id":"22262065547","fileName":"2226206554723858863243.html","title":"Step Restrictions","level":4,"position":119,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs"],"content":"   The availability of tightening steps, monitors and restrictions depends on the license installed on the controller. To make sure the tightening stops if something unexpected happens, it is possible to add step restrictions to the multistep tightening program. These restrictions could, for example, test that a maximum torque is not reached or that a part of the multistep tightening does not take too long to run. Each step has its own set of mandatory step restrictions and optional step restrictions. The mandatory restrictions are included when dragging a new step to the multistep program. All steps can have up to four restrictions each.  In Power Focus 6000 StepSync and Power Focus 8 StepSync controllers, it is possible to use synchronization points in the tightening program. When any condition that is set for a restriction is met, the tool will be stopped immediately and the program jumps to the next synchronization point (only valid for the Power Focus 6000 StepSync, Power Focus 8 StepSync and Flex), or the end of the program. In controllers without StepSync the tool is stopped immediately and the program jumps to the end of the program.  For Flex only: For each restriction, select Repairable= Yesto allow retry when tightening stops. The following restrictions are automatically added to every step that is added to the multistep tightening program.  Default step restrictions     Step Restriction  Applicable steps    Maximum Time  All except External Result and MWR   Maximum Torque    Tighten to Angle  Tighten to Torque+Angle  Turbo Loosening  Wait  Socket release  Run until Digital Input  Tighten to Trigger Release   Maximum Angle    Tighten to Torque  TurboTight  Turbo Loosening  Tighten to DynaTork  Wait  Run until Digital Input  Loosen to Torque  Thread Cutting to Torque  Rundown  Tighten to Yield  Pulsing Rundown Snug  TensorPulse   Available tools per each system types     Power Focus 6000 \/ Power Focus 8  Power Focus 6000 StepSync \/ Power Focus 8 StepSync  Flex  IxB    ST  ST  QST  IxB   STR  STR     SL  QST     QST      STB      IxB      Power Focus Connect         Step Restrictions  Tools     title-item   list "},{"id":"21903501323","fileName":"21903501323.html","title":"A - Maximum Angle","level":5,"position":120,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST STB IXB This restriction measures the angle. If the measured angle reaches the Maximum Limit, the tool is stopped immediately. The angle is measured from the start of the restriction or, if specified, from the point where the torque passes Trigger Torquefor the first time during the restriction.      Parameter  Description     Trigger Torque  If specified, this is the torque from where the angle is measured.    Maximum Limit  If this limit is reached the tool is stopped immediately."},{"id":"21902844811","fileName":"21902844811.html","title":"C - Current","level":5,"position":121,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST STB IXB  This step restriction is not supported for Power Focus XC. This restriction checks the actual current where torque passes Torque Trigger. If the actual current exceeds the limits, the tool will be stopped immediately and the tightening program will jump to the next synchronization point or the end of the program. The result will be the first peak or low value, that made the monitor NOK. In case of OK, the result will be the last measured current value. If the torque trigger is never reached during the restriction it will end with status OK.      Parameter  Description    Torque Trigger  Must be >= 0 and < Tool Max Torque.   Low limit  Lowest acceptable current.   High limit  Highest acceptable current."},{"id":"21902840715","fileName":"21902840715.html","title":"CTh - Cross Thread","level":5,"position":122,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST STB IXB This restriction checks the angle from the point where torque passes Start torque(T1) to the point where the torque passes End torque(T2). If the angle measured from Start torque(T1) is higher than Maximum limit(Amax), the tool is stopped immediately. When the torque passes End torque(T2), the measured angle is checked against the limit Minimum limit(Amin). If the angle is lower than this limit, the tool is stopped immediately.       Parameter  Description  In illustration     Start Torque  Must be <=0.  T1    End Torque  Must be <=0.  T2    Minimum Limit  The low angle limit.  Amin    Maximum Limit  The high angle limit.  Amax  "},{"id":"21903531403","fileName":"21903531403.html","title":"PCH - Pulse Count High","level":5,"position":123,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    STR  This restriction is only available for the following tools:    ETV-STR61-100-13   ETV-STR61-70-13   ETV-STR61-50-10 Before using the Pulse Countrestriction, the Low Reaction Strategieslicense must be installed on the controller. This restriction gives a limit to the number of pulses, and makes sure that those are below the specified pulse count high limit. If the measured number of pulses is higher than the pulse count high limit, the tool is stopped immediately and the program goes to the next synchronization point or the end of the program. If the torque trigger level is set, the check starts as soon as the measured torque is above the torque trigger level. If running a tightening step with Pulse Count Highstep restriction, use the necessary PulseDrive socket\/adapter. If the tightening step runs without the PulseDrive socket\/adapter, all the tightenings are NOK. The step error “PulseDrive socket\/adapter not detected” shows for no PulseDrive socket\/adapter.      Parameter  Description     Pulse Count High Limit - n+  Pulse count high limit must range from 1 through 9999999.  Pulse Count High Limittext box can be empty.    Torque Trigger - Tt  Torque Trigger must range from 0 through the maximum torque of the tool.  Torque Triggertext box can be empty."},{"id":"21903512459","fileName":"21903512459.html","title":"Rh - Rehit","level":5,"position":124,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST STB IXB This restriction checks the torque. If the measured torque exceeds the Detection Torque, the tool is stopped immediately and the program jumps to the next synchronization point (for Power Focus 6000 StepSync and Power Focus 8 StepSync), or the end of the program. It is only possible to add step Rehit restriction to the first step of the multistep tightening program. Once the Rehit restriction has been added to the first step it shall not be possible to move the step to any other position within the tightening program. The Rehit restriction has to be deleted from the first step in order to move it to other position in the tightening program.      Parameter  Description     Detection Torque  If the measured torque exceeds the Detection Torque, the tool is stopped immediately and the program jumps to the next synchronization point (for Power Focus 6000 StepSync and Power Focus 8 StepSync), or the end of the program. Must be greater than zero.    Angle Window  The angle window is measured from the start of the step. If no Angle Window is set, the restriction is active during the whole step."},{"id":"21903516171","fileName":"21903516171.html","title":"RT - Rescinding Torque","level":5,"position":125,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST STB IXB This restriction checks the torque. If the measured torque drops below the condition of the restriction the tool is stopped immediately and the program jumps to the next synchronization point (for Power Focus 6000 StepSync and Power Focus 8 StepSync), or the end of the program.    Torque control processes The restriction condition is the measured torque. For the restriction to be active the torque must first exceed 110 % of the Rescinding Torque Limit.   Angle control processes This restriction checks the maximum torque reached during the restriction. For the restriction to be active the torque must first exceed the Trigger Torque.  Torque control processes     Parameter  Description    Rescinding torque limit  Default: 10 Nm. Must be > 0.  Angle control processes (valid only for Power Focus 6000 StepSync and Power Focus 8 StepSync)     Parameter  Description    Trigger Torque  Must be > 0.   Peak torque percentage  Default: 95. Must be >= 50.   Rescinding torque time  Default: 20. Must be >= 5 and <= 500.   Rescinding Torque Angle  Must be > 0.  Cable tools have the option to select Rescinding Torque for Angle. This restriction is controlled by two parameters: Peak Torque Percentageand Rescending Torque Time. Percentage sets the downward deviation from the last peak torque, and Rescending Torque Timesets the duration (between 5 and 500 ms) of that deviation. Only when both conditions (equal to or lower than the indicated percentage for the set duration) are met, will the program be interrupted and jump to the end."},{"id":"21903505035","fileName":"21903505035.html","title":"T - Maximum Torque","level":5,"position":126,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST STB IXB This restriction checks the torque. If the measured torque exceeds the Maximum limit, the tool is stopped immediately.      Parameter  Description     Maximum Limit  If the torque reaches this specified limit the tool is stopped immediately."},{"id":"21903523979","fileName":"21903523979.html","title":"TAW - Torque in Angle Window","level":5,"position":127,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST STB IXB This restriction checks that the measured torque in the Angle Window Lengthis between the Torque limits. If the measured torque is outside the limits the tool is stopped immediately and the program jumps to the end. The Angle Window Length starts at the Start Anglefrom the point that the torque first passed the Trigger Torque. If Trigger Torque is not set, then the Start Angle begins at the start of the restriction. If the end of the Angle Window Length is not reached, the status of the restriction is NOK.      Parameter  Description     Trigger Torque  Must be >= 0    Start Angle  Must be >= 0    Window Length  Must be >0    Minimum Limit  Must be >= 0    Maximum Limit  Must be <= Minimum limit"},{"id":"21903527691","fileName":"21903527691.html","title":"TCD - Torque vs Current Deviation","level":5,"position":128,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST IXB This restriction verifies that all current measurements converted to the corresponding torque are, at most, the Maximum deviationaway from the actual torque measured with the torque transducer. The restriction starts when the torque reaches Trigger Torquefor the first time during the step and is active until the step reaches its target. If Trigger Torqueis never reached, the monitor will report OK.      Parameter  Description     Trigger Torque  Must be >= 0    Maximum Deviation  Default: 1, Must be > 0"},{"id":"21903520267","fileName":"21903520267.html","title":"TG - Torque Gradient","level":5,"position":129,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST IXB This restriction checks the gradient and if it is outside the limits the tool is stopped immediately and the program jumps to the end of the program.      Parameter  Description     Gradient Angle Window  Specifies Angle Window:   For Hard Joint: Angle Window= 1 deg.  For Soft Joint: Angle Window= 20 deg.   Manual: Manually set Angle Window.    Angle Window  Available when Gradient Angle Windowis set to Manual. Must be > 0 and <= 100.    Trigger Torque  Must be > 0 and < Tool MaxTorque.    Damping  Frequency in which the gradient is being calculated. Must be > 0 and < 100 and < Angle window.    Minimum Limit  Must be >= -100.    Maximum Limit  Must be > -100 and > Low limit.    Torque Filter Type  The type of the filter:    None: No filtering of the torque is used. The raw values are used as-is in the gradient calculation.   Five-point: The torque value used in the calculation are filtered using a sliding average filter over 5 torque samples.   Low pass: The torque values is filtered with a simple discrete Infinite Impulse Response filter.   Sliding Average: The torque values used in the calculation are filtered using a sliding average filter over a Number of Samplesspecified by the use.    Cut-off Frequency  Needs to be specified when Torque Filter Typeis set to Low pass:   20 Hz  40 Hz  90 Hz  200 Hz  600 Hz    Number of Samples  Needs to be specified when Torque Filter Typeis set to Sliding Average:   2  4  6  8  16  32"},{"id":"21903507467","fileName":"21903507467.html","title":"Ti - Maximum Time","level":5,"position":130,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs","Step Restrictions"],"content":"      Tools    ES STR SL ST SR QST STB IXB This restriction checks the time. If Maximum Limitis reached, the tool is stopped immediately.      Parameter  Description     Maximum Limit  If this time is elapsed, the tool is stopped immediately."},{"id":"14689638539","fileName":"14689638539.html","title":"Result Reporters","level":4,"position":131,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs"],"content":" The result reporters makes it possible to extract specific values of selected producer from the result. The result reporters belong to a step but has to be tied to the monitor\/restriction which they read the values from. Only monitors or restrictions located in the same step as the result reporter can be selected. A result reporter is added to a step using drag and drop (in the same way as monitors and restrictions). Each result reporter is responsible for reporting a specific result value, for example, Rundown Angle, Final Torque, Prevailing Torque. It is possible to tie a result reporter to:   Program monitors  Step monitors  Step restrictions Each result reporter defines a final value type:   Final Angle  Final Torque  Prevailing Torque  Self-tap Torque  Current  Rundown Angle  Number of Pulses General Parameters      Parameter  Description     Producer  Specifies which monitor\/restriction produces the value.    Value  Specifies which value to show from the selected producer.  Limitations:  It is only possible to add a result reporter on a monitor\/restriction belonging to a step in main path or a program monitor\/program restriction.  There may exist several reporters on a step if they are of different type.  There may exist a result reporter of, for example, type final angle on every step and program monitor angle.  For those monitor\/restrictions that have more than one result value, it is possible to add more than one result reporter if the result reporters are of different types.  There may not exist several result reporters of the same type on a step or on a program monitor\/restriction.  There is only one result reported for each possible final value type.  Rules:  The internal number of a result item has to be the same as for the corresponding result reporter.  The internal number of a monitor\/restriction result has to be the same as the internal number of the monitor\/restriction in the configuration.  The step results has to be ordered according to the order of execution. The first executed step has to be first.  Possible values reported by a result reporter if present in the monitor\/restriction\/step:  The monitors\/restrictions measured value (as float or integer)  The monitors\/restrictions high and low limits  Status  Torque trigger and angle trigger  Angle target and torque target (read from the step)  Possible values for status:  Low  OK  High  Other  NotSet The target values do not belong to any step monitor so the target values are taken from the step that the monitor belongs to."},{"id":"5148077963","fileName":"5148077963.html","title":"Adding a Multistep Program","level":4,"position":132,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs"],"content":"    On the Home view, select the TighteningTab. Then, on the left, select Multistep program library.  Select the Plus icon at the upper-right corner of the GUI. Then, select the needed type of program (Tightening or Loosening).  Drag and drop tightening steps, monitors and restrictions in the tightening area.  Steps can only be placed between the start and end points of the program, whilst monitors and restrictions can only be placed on steps.      Function   Description    Start and end points    Start and end points of the multistep program. All steps must be placed between these two points.   Adding a step    Drag a step from the list and drop it in the desired position between the start and end points.   Moving a step    Click and hold a step and move it to the desired position   Showing step properties    Click on the step to reveal the properties   Closing step properties    Click anywhere in the tightening area to close the properties menu   Deleting a step    Open the step properties and click Deleteat the bottom of the menu   Adding a restriction\/monitor    Drag a restriction\/monitor from the list and drop it on the appropriate step.   Moving a restriction\/monitor    Click and hold the icon (checkmark for monitor, stop sign for restriction) and drag and drop it on the appropriate step   Showing restriction\/monitor properties    Click on the restriction\/monitor icon to reveal the properties menu   Closing restriction\/monitor properties    Click anywhere in the tightening area to close the properties menu   Deleting a restriction\/monitor    Open the restriction\/monitor properties and click on Deleteat the bottom of the menu   Step error    When a validation error occurs in a step, that step will be marked. Note that when the step properties are opened, the parameter causing the error will also be marked.   Monitor\/Restriction error    When a validation error occurs in a monitor or restriction, that monitor or restriction will be marked. Note that when the monitor\/restriction properties are opened, the parameter causing the error will also be marked.   Forbidden placement    When a particular placement (of a step, monitor or restriction) is not allowed, the placeholder icon will not be shown.               "},{"id":"5148079883","fileName":"5148079883.html","title":"Deleting a Multistep Program","level":4,"position":133,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs"],"content":"    In the Tighteningmenu, click on the Multistep program library.  In the list, click on the multistep tightening program you want to delete.  In the program itself, at the bottom left, click on Delete.  Click Yesin the pop-up window to confirm your choice."},{"id":"5150672139","fileName":"5150672139.html","title":"Settings for a Multistep Program","level":4,"position":134,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs"],"content":" General Settings      Parameter  Description    Name  A user defined name for the multistep program.   Thread Direction  Direction of the threads, either clockwise (CW) or counter clockwise (CCW).   Loosening Program  Indicate if a loosening program is available. Choose from the list of available loosening programs in the controller.   Type  Type of program, either Tightening or Loosening.   Program Start  Gives the torque level for generating a result. If left blank, the result is generated every time the tool is started; otherwise result is only generated from the set torque level.   Program End Torque  Gives the torque value that stops a multistep tightening. The signal 168 - Program Endis true when, after a multistep tightening Program End Torquehas reached, and Program End Timeouthas elapsed. Default value for Program End Torqueis Tool max torque * 0.03.   Program End Timeout  Gives the time value (in seconds) that stops a multistep tightening. The signal 168 - Program Endis true when, after a multistep tightening Program End Torquehas reached, and Program End Timeouthas elapsed. Default value for Program End Timeoutis 0 seconds.   True Angle Compensation  Turns True Angle Compensation on or off (default is Off).   NOK on Trigger Lost  NOK on trigger lost switch controls whether or not it is allowed to release the tool trigger before the target condition has been reached on the last step. The toggle can be set to Onor Off.    Off- Releasing the trigger before reaching the target condition in the last step causes an OK tightening as long as all other conditions has been fulfilled.   On(default value) - Releasing the trigger before reaching the target condition in any step will be treated as a trigger lost and cause a NOK tightening. Attachment Tuning      Parameter  Description    Use attachment tuning  Select whether attachment tuning should be on or off.   Gear ratio  The gear ratio value can be between 0.5 and 4.0.   Efficiency tuning  The efficiency tuning value can be between 0.5 and 1.0. Program Monitor  Angle     Parameter  Description    Enabled  Turn angle monitoring Onor Offfor the entire program. If Active in stepsand Trigger Torqueare left blank, angle monitoring will start at program start.   Active in steps  Sets a range of steps this monitor is valid for:   If no start step is specified, this monitor will start at program start.  If no end step is specified, this monitor will stop at the last step of the program.   Type  Type of angle monitoring. Choose between:    Peak Angle: the highest angle reached during the monitor   Angle at Peak Torque: the angle at the point where the highest torque was reached during the monitor (Not available for STB tools)   Shut Off Angle: the angle at the shut-off point of the step   Angle at End: the angle at the end of the monitor, including the brake, if active.   Trigger torque  Sets the value of the trigger torque for angle monitoring. For STB tools, Trigger Torque will only activate in the tightening direction when executing a tightening program; and only in the loosening direction when executing a loosening program.   Low limit  Sets angle monitoring (program) lower limit.   High limit  Sets angle monitoring (program) higher limit.  Torque     Parameter  Description    Enabled  Turn Torque monitoring Onor Offfor the entire program. If Active in stepsis left blank, torque monitoring will start at program start.   Active in steps  Sets a range of steps this monitor is valid for:   If no start step is specified, this monitor will start at program start.  If no end step is specified, this monitor will stop at the last step of the program.   Type  Type of angle monitoring:    Peak Torque: the highest torque reached during the monitor.   Shut Off Torque: the torque at the shut-off point of the step.   Low limit  Sets torque monitoring (program) lower limit.   High limit  Sets torque monitoring (program) higher limit.  Time     Parameter  Description    Enabled  Turn time monitoring Onor Offfor the entire program. This monitor checks that the time is within the specified limits.   Active in steps  Sets a range of steps this monitor is valid for:   If no start step is specified, this monitor will start at program start.  If no end step is specified, this monitor will stop at the last step of the program.   Trigger torque  Sets the value of the trigger torque at which this monitor shall start.   Low limit  Sets time monitoring (program) lower limit.   High limit  Sets time monitoring (program) higher limit. Program Restrictions      Parameter  Description    Maximum Time Limit  Set amount in seconds. This restriction checks the total time for the tightening and if it exceeds the Time Highlimit the tool is stopped immediately. The time is measured from the start of the program.   Maximum Torque Limit  This restriction checks the torque and if the measured torque exceeds the Torque Highlimit the tool is stopped immediately.  Angle     Parameter  Description    Enabled  Turn angle restriction Onor Offfor the entire program. This restriction checks that the angle is within the specified angle limits.   Active in steps  Sets a range of steps this restriction is valid for:   If no start step is specified, this restriction will start at program start.  If no end step is specified, this restriction will stop at the last step of the program.   Trigger torque  Sets the value of the trigger torque at which the this restriction shall start.   High limit  Sets angle restriction (program) higher limit.  Time     Parameter  Description    Enabled  Turn time restriction Onor Offfor the entire program. This restriction checks that the time is within the specified time limits.   Active in steps  Sets a range of steps this restriction is valid for:   If no start step is specified, this restriction will start at program start.  If no end step is specified, this restriction will stop at the last step of the program.   Trigger torque  Sets the value of the trigger torque at which this restriction shall start.   High limit  Sets time restriction (program) higher limit. Reporters This enables the user to choose which values (from monitors\/restrictions) shall be shown as final values. Click Addto choose a result reporter to be tied to a program monitor\/restriction value.      Parameter  Description    Reporter  Select a result reporter.   Producer  Select which monitor\/restriction produces the value.   Value  Select which value to show from the selected producer. Trace Configuration The trace configuration can be done on program level or for each step. The default configuration is set on the program level and can be overridden in each step as needed. Here, enabling this function allows the configuration to be done on program level.      Parameter  Description    Enabled     On: Enables the trace resolution configuration on program level.   Off: The trace recording is done with the same resolution for the whole tightening. In this case, the trace points are evenly distributed in time over the whole tightening. For each time slot (0.25 ms) two values (the minimum and the maximum measured value) are displayed in the trace. The maximum number of samples in this format is 2000.   Sample Type     Sample Time: specifies how often samples should be stored in the trace by specifying a sample time in ms.   Sample Angle: specifies how often samples should be stored in the trace by specifying a sample in deg.    Sample Time  Choose the sample time from the drop-down list (0.25 - 1000 ms)   Sample Angle  Choose the sample angle from the drop-down list (0.25 - 20 degree) Validation      Parameter  Description    Validate against tool values  Use Onif tool is known and set Max Torqueand Max Speed. Use Offif tool is not known.   Tool  Drop-down for choosing the tool to validate against.   Max torque  Max torque of the tool to validate against.   Max speed  Max speed of the tool to validate against. "},{"id":"6359545867","fileName":"6359545867.html","title":"STB Tools and Multistep","level":4,"position":135,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Multistep Programs"],"content":" Due to the wireless nature of STB tools, some multistep functions and behaviors may differ. Besides the general limitations listed here, descriptions of multistep functions will be additional information on STB tools where necessary. Program Validation All tightening programs will be validated for compatibility with STB tools before the program is downloaded to the tool. If the chosen tightening program is not compatible with the tool, the tool will be locked. When this error occurs, it will trigger event 5030, \"Configuration complexity exceeded\". To unlock the tool, reduce the complexity of the tightening program, or choose a different tightening program altogether."},{"id":"1744545675","fileName":"174454567523858778763.html","title":"Step Configuration Stages","level":3,"position":136,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab"],"content":" The controller tightening programs need parameters to be set in order to execute the programs. Selecting a Strategyand either the Target torqueor Target angleare mandatory. Other settings are optional. It is also possible to monitor the tightening as it progresses by adding limits within which the torque or angle rotation must remain. The tightening procedure is divided into four stages: Start, Rundown, Tightening and Stop.  Typical tightening curve The figure is typical of how tightenings are described. The curves represent how speed, torque and angle vary over time. All tightening strategies are represented in this way. Parameters, monitors and limits are also shown in detailed figures. A task is defined from the time a trigger is pressed until the tightening target is reached, or an error occurs. A combination of a tightening strategy together with specific parameter settings forms a tightening program. The user can create many different tightening programs, and one of them is selected at runtime.  "},{"id":"91423499","fileName":"9142349923858800523.html","title":"Start Stage","level":4,"position":137,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages"],"content":" The optional Start step initiates the tightening, enables socket and thread finding, and the option to detect rehits. "},{"id":"61715723","fileName":"61715723.html","title":"Direction","level":5,"position":138,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Start Stage"],"content":"  Directiondefines the tightening direction of the spindle to clockwise (CW) or counterclockwise (CCW). The rotation of the spindle will always be in this direction, except when loosening and during the conditioning step used in the Three stepstrategy.      Parameter  Description  Default value    Thread direction  Defines the tightening direction of the spindle.  Clockwise"},{"id":"60633611","fileName":"60633611.html","title":"Soft Start","level":5,"position":139,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Start Stage"],"content":" During Soft startit is possible to set the speed, the maximum torque and the the rotation angle to help the screw to enter the thread, and to prevent the tool being jerked out of position when the tool trigger is pressed.       Parameter name  Description  Default value    Soft start  Enables setting of the tool’s speed, angle and maximum torque to facilitate the screw entering the thread.  Off:Soft start is turned off.  On:Soft start is turned on.  On   Speed  Defines the speed during Soft start.  35 rpm   Angle  Defines the angle to turn the spindle for the screw to enter the thread.  90°   Torque max  Defines the upper torque limit during Soft start. If Torque maxis exceeded, the tightening is aborted and an error message is given. The tightening will be considered NOK.  1.25 Nm  "},{"id":"60672907","fileName":"60672907.html","title":"Rehit Detection","level":5,"position":140,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Start Stage"],"content":" When Rehit detectionis activated, it is possible to detect a screw that has already been tightened.      Parameter  Description  Default value    Rehit detection  Detects attempts to tighten an already tightened screw.    Early:the Rehit detection Earlyoption terminates the tightening immediately when a rehit is detected and ends the tightening in the most ergonomic possible way. To be able to use the Rehit detection Early option, Soft start must be set to On. This is because the Soft start torque maxvalue is used as the torque limit beyond which the tightening is considered a rehit. The tightening is considered as NOK and a rehit error is indicated.   Complete:to make a rehit detection when Soft start is not used, the Rehit detection Completeoption must be used. Rehit detection Complete does not terminate the tightening until all tightening steps have been executed and consequently takes longer. The tightening is considered a rehit if the speed never reaches half the rundown speed, and a rehit error is indicated. The tightening is considered as NOK.   Off:no rehit detection is performed.  Early"},{"id":"81997323","fileName":"81997323.html","title":"Current Monitoring","level":5,"position":141,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Start Stage"],"content":" Current monitoring provides an extra security to monitor the tightening torque and is a complement to the torque sensor in the tool. At final target torque, the rotor current is measured and converted to a torque value. If the calculated torque is within 10% of the measured torque, the tightening is considered to be OK.      Parameter  Description  Default    Current monitoring  Switch with On - Off position.   Off: Current monitoring is disabled and the tool torque is measured by the torque sensor.  On: the current is measured at final torque target and converted to a torque value. The calculated torque is compared to the measured torque. If the difference is within 10%, the tightening is considered OK.  Off  Current monitoring is not implemented for Turbo Tight, Rotate, Pulsing and STwrench strategies."},{"id":"82022027","fileName":"82022027.html","title":"TrueAngle Compensation","level":5,"position":142,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Start Stage"],"content":" Certain tools are equipped with a gyro and measure the tool rotation during tightening. If the tool is rotated during tightening, the angle measurement may be corrupted. This leads to faulty tightening if made to angle references. For variations within specified limits, the controller can compensate for these rotations and make a correct tightening. If the tool rotation is outside specified limits, the tightening is aborted and the result status NOKis reported. Additional information reports Tool movement exceeded.      Parameter  Description  Default    TrueAngle compensation  Available for all tightening strategies except Rotate.  Tools which have a crowfoot installed as an attachment do not support the parameter TrueAngle compensation.  On   Tool movement limits - Negative  Only visible if TrueAngle compensation is on. Defines the maximum negative rotation of the tool. If the value is exceeded the tightening is terminated and an error is reported. Expressed in a numeric angle value.   Min value: 1  Max value: 180  30   Tool movement limits - Positive  Only visible if TrueAngle compensation is on. Defines the maximum positive rotation of the tool. If the value is exceeded the tightening is terminated and an error is reported. Expressed in a numeric angle value.   Min value: 1  Max value: 180  30  Only tools with gyro have the capability to measure the tool movement.   "},{"id":"91426571","fileName":"9142657123858786187.html","title":"Rundown Stage","level":4,"position":143,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages"],"content":" The part of the tightening from when the screw enters the thread until just before the screw head touches the underlying surface and snug is reached. The torque required during rundown does not contribute to any clamping force.      Parameter  Description  Default value    Rundown speed  Defines the speed during the Rundown step  Tool max speed "},{"id":"60789131","fileName":"60789131.html","title":"Selftap","level":5,"position":144,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Rundown Stage"],"content":" The Selftap step enables tightening where the rundown torque required is greater than the Rundown completetorque, for example when tightening thin layers of metal using self-threading (or self-tapping) screws. The selftap window starts when the torque value reaches SelftapTorqueMin\/2. The torque must reach over SelftapTorqueMin, but not pass SelftapTorqueMax, during the angle window.       Parameter  Description  Default value    Selftap  Activates the Selftap step.  Off   Speed  Defines the speed during Selftap.   Soft start speedor 5% of ToolMaxSpeed   Length  Defines the angle to turn the socket during Selftap. Measured from the end of the Start step.  360°   Torque min  Torque value for lower Selftap limit.  0 Nm   Torque max  Torque value for upper Selftap limit.  Tool max torque  "},{"id":"60828427","fileName":"60828427.html","title":"Rundown Torque Limits","level":5,"position":145,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Rundown Stage"],"content":" The friction between the nut and joint can vary. This can cause the torque needed to run a nut down a thread, before engagement with the joint surface takes place, to vary as well. These effects could be, for example, hole interference, prevailing torque or varying lubrication. Monitoring the rundown torque can be useful when running down a lock nut which has a plastic insert in the threads to help the fastener resist vibration. This will require a higher torque, known as prevailing torque, to overcome the interference.       Parameter  Description  Default value    Rundown torque limits  Sets Rundown torque limits to On or Off.  Off:No limits are set.  On:Torque limits and angle interval are set.  Off   Offset  Angle offset before the Angle interval begins.  0°   Length  Angle defining the Rundown torque limit section.  360°   Torque min  Torque value for lower Rundown torque limit.  0 Nm   Torque max  Torque value for upper Rundown torque limit.  19% of Target torque  "},{"id":"60880523","fileName":"60880523.html","title":"Rundown Angle Limits","level":5,"position":146,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Rundown Stage"],"content":" By monitoring the angle of rotation during rundown, errors such as missing washers or screws with incorrect thread size or length can be detected. For example, threads that are too long would require a greater turning angle for the screw to reach snug.       Parameter  Description  Default value    Rundown angle limits  Activates Rundown angle limits. The angle limits are set relative to when the tool trigger is pressed or when a specified torque value is reached. Angle limits will not be checked during Selftap if Selftap is activated.  Off:No limits are set.  From trigger:The system starts to monitor the tightening angle as soon as the tool trigger is pressed and reports if angle or time limits are violated.  From torque:The system starts to monitor the tightening angle from the specified <From torque>value and reports if angle or time limits are violated.  Off   <From torque>  Torque value from where Rundown angle limits are set.  10% of Target Torque   Angle min  Angle value for lower angle limit from starting point.  100°   Angle max  Angle value for upper angle limit from starting point.  1000°   Time min  Minimum time (in milliseconds) for the step. Measured from the start of the step.  10 ms   Time max  Maximum time (in milliseconds) for the step. Measured from the start of the step.  5000 ms  "},{"id":"61960075","fileName":"61960075.html","title":"Post View Torque","level":5,"position":147,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Rundown Stage"],"content":" Some joints have a torque peak prior to Rundown complete. Post view torque makes it possible to monitor torque values during two specified angular intervals. The interval starts are defined as an angle prior to Rundown complete and torque is then monitored for a specified angular interval. Post view torque is therefore similar to Rundown torque limits except that the maximum and minimum limits can be positioned independently of each other and can differ in length to better control the outcome of the rundown step.       Parameter  Description  Default value    Post view torque  Post view torque makes it possible to monitor torque values during two specified angular intervals.  Off   Torque min  Torque value for lower Post view torque limit.     Torque min offset  Angle offset before the Post view torque min interval begins.  720°   Torque min length  Angle length defining the Post view torque min section.  90°   Torque max  Torque value for upper Post view torque limit.     Torque max offset  Angle offset before the Post view torque max interval begins.  360°   Torque max length  Angle length defining the Post view torque max section.  90°  "},{"id":"60919819","fileName":"60919819.html","title":"Rundown Complete","level":5,"position":148,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Rundown Stage"],"content":" Rundown complete sets if the screw has reached snug. It ends the Rundown step so that the tightening step can be entered.      Parameter  Description  Default value    Rundown complete  Specifies how to control when snug is reached.  At torque:Specifies the torque value for when the rundown step is completed.  At torque   <At torque>  Defines the torque value for when snug is reached and the rundown step is completed. Rundown complete must be smaller than First torquein multi-step strategies or Target torquein the TurboTight strategy.  "},{"id":"91432715","fileName":"91432715.html","title":"Stop Stage","level":4,"position":149,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages"],"content":" The Stop stage terminates the tightening so that the socket can be released. Soft Stop Soft stop causes the tightening stop in a more ergonomic fashion.  Do not stop tools within the time interval of 50-300 ms, as this is known to make it feel like an uncomfortable stop.      Parameter  Description  Default value    Soft stop  Turns the Soft stop on or off.    Off:No Soft stop is used.   On:Soft stop is activated. When target torque is reached, the tool speed is immediately decreased to 75%. Then the speed is decreased to zero in at most 40 ms.  Off"},{"id":"65795211","fileName":"65795211.html","title":"Loosening a Screw","level":4,"position":150,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages"],"content":" By setting the loosening parameters, you can control the behavior of loosening for a specific tightening program. Specify the loosening speed and torque to ensure that the screw is unscrewed as desired, so that the screw thread does not break, regardless of what tool you use.  A loosening is considered OK when Run-up torqueis reached. However, the screw will probably not have been fully run up by then. The screw should now be able to be turned using a low torque and the speed can be increased. The operator will need to proceed with the loosening until it is considered finished.       Parameter name  Description  Default value    Detection torque  The minimum torque required to begin performing a loosening operation and produce a loosening result.  7% ToolMaxTorque   Run-up torque  When the torque falls below Run-up torque, the loosening is considered to be OK.  Note!Depending on variations in screw length, the system cannot determine when the screw has been run up completely. This is for the operator to decide.  3.5% ToolMaxTorque   Loosening speed  Loosening speed will be attained when Run-up torqueis reached.  ToolMaxSpeed  "},{"id":"84247307","fileName":"8424730723858793099.html","title":"Stage Parameter Descriptions","level":4,"position":151,"hasContent":false,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages"],"content":""},{"id":"61140619","fileName":"61140619.html","title":"Target Torque Limits","level":5,"position":152,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Stage Parameter Descriptions"],"content":" By setting the Target torque limits, it is possible to discard a tightening should the torque result not fall within the specified torque limits. A too high torque can cause the screw to deform as a result of passing the yield point, and can even break, or can cause the stripping of threads. Not enough torque result in the clamping force not being enough to withstand the forces for which the joint is designed.       Parameter  Description  Default value    Torque limits  The tightening is considered as NOK if the torque result is outside the range defined by Torque min and Torque max.  Auto:Torque limits are automatically set to the default values specified for Torque min and Torque max.  Manual:Enables the Torque limit values to be set manually.  Auto   Torque min  Torque value for lower torque limit. Can be entered if Manualhas been selected.  95% of Target torque   Torque max  Torque value for upper torque limit. Can be entered if Manualhas been selected.  120% of Target torque The parameter Measure torque atcan have different values. By default the torque is measured at torque peak. The possible values of the parameter are listed in the table below.      Name  Description    Max torque value  Measures the highest torque value during the tightening.   Value at peak angle  Measures the torque value at the highest angle value.   Value at shutoff  Measures the last torque value before entering the break step.  "},{"id":"61179915","fileName":"61179915.html","title":"Target Angle Limits","level":5,"position":153,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Stage Parameter Descriptions"],"content":" With Target angle limits set, it is possible to monitor whether the nut is turned the desired angle during the tightening.      Parameter  Description  Default value    Angle limits  Choose the section of the tightening, in degrees, in which to monitor the angle.    Off:No limits are checked.   From Rundown complete:The monitoring window is set from when the Rundown complete torqueis reached.   From torque:The monitoring window is set from when the specified torque value is reached. Torque must be greater than Rundown complete torque.   From First target:The monitoring is set from when First targetis reached. This option is not available if TurboTight is chosen.   Auto:The angle monitoring limits are automatically calculated by the controller   Manual:The angle monitoring limits are manually entered.  Off   <From torque>  Torque value from where angle limits are set.     <From torque>  Torque value from where angle limits are set.  75% of Target Torque   Angle min  Angle value for lower angle limit  90°   Angle max  Angle value for upper angle limit  720°   Time min  Minimum time (in milliseconds) for the step. Measured from the start of the step.  10 ms For TurboTight: 0 ms   Time max  Maximum time (in milliseconds) for the step. Measured from the start of the step.  1000 ms For TurboTight: 40 ms  Position 1-4 are valid if the target is torque. Position 5-6 are valid if the target is angle. The parameter Measure angle atcan have different values. The parameter is only available when angle monitoring is turned on for the tightening program used. By default the angle is measured at Max angle value. The possible values of the parameter are listed in the table below.      Name  Description    Value at peak torque  Measures the angle at the highest torque value.   Max angle value  Measures the highest angle during tightening.   Value at shutoff  Measures the last angle value before entering the break step."},{"id":"61335179","fileName":"61335179.html","title":"Torque Compensation","level":5,"position":154,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Stage Parameter Descriptions"],"content":" By using torque compensation, the actual clamping force applied to the joint can be better determined and the scatter in the applied clamping force can be reduced. The torque compensation point is set by referring back to a specified angle from Rundown complete and calculating a value for the torque used during rundown. This is then compensated for when creating the preload in the screw by adding the torque value calculated in the torque compensation point to the Target torque.      Parameter  Description  Default value    Torque compensation  Enables adjustment if the Target torque for torque used in the rundown step.  Off:No compensation is made.  On:Manually sets the Torque compensation point.  Off"},{"id":"1232883979","fileName":"1232883979.html","title":"Residual Torque Correlation Factor","level":5,"position":155,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Stage Parameter Descriptions"],"content":" The term Residual torque correlation factor is similar to a calibration and adjusts between the dynamic torque, measured in the electrical tool, and the residual torque, measured by a control tool. The Residual torque correlation factoris available for all tools running the TurboTight strategy and the TensoPulse tightening strategy. It is also available for the battery pulse tools that are supported by the controller.  When using a Residual torque correlation factorthat differs from 100, the reported Final torqueis no longer the dynamic torque measured by the tool transducer. The dynamic torque measurement uses an internal torque transducer that constantly measures the torque. When the target torque is reached, the tool stops and the result is evaluated and reported. The measured final torque in the transducer is affected by the joint condition, the tool speed, gears and sockets. The residual torque is measured after the tightening is completed. It is the torque needed to continue or restart the tightening to a higher level. The residual torque is determining the clamping force in the joint.      A dynamic torque measurement is highly repetitive but may differ between tool type and tool speed.  A handheld calibrated torque wrench provides high accuracy measuring the residual torque but has higher variations due to joint relaxation, torque decay, friction or operator technique. The Residual torque correlation factoris a compensation between the dynamic torque and the residual torque. The factor should be determined by conducting tests. The selected tightening program is performed a few times and the dynamic torque is recorded. The tightenings are also manually measured to determine the residual torque.  The Residual torque correlation factorcan be calculated by dividing a residual torque by a dynamic torque. The Residual torque correlation factoris presented as percent and is by default 100%. This means the reported dynamic torque value has not been modified.      Parameters  Function     Target torque  The tool target torque set for the tightening using the TurboTight strategy.    Final dynamic torque  The final torque reported as the result of the performed tightening.    Dynamic torque  The dynamic torque measured by a reference transducer.    Residual torque  The desired residual torque that ensures the desired clamping force.    Residual torque correlation factor  The compensation factor between residual torque and dynamic torque An example of how torque tuning can be used: The TurboTight strategy is selected. The joint shall be tightened to 12 Nm to reach the desired clamping force. The following set up is made:      Example settings  Value  Function     Target torque  12 Nm  The programmed desired target torque in the controller    Residual torque correlation factor  100  The compensation factor between residual torque and dynamic torque A number of tightenings are made. After each tightening the joint is checked with a calibrated torque wrench. The average is calculated and the following result has been found:      Initial parameters and results  Value  Function     Target torque  12 Nm  The programmed target torque in the controller.    Final torque  12 Nm  The final torque reported as the result of the performed tightening.    Dynamic torque  12 Nm  The uncompensated measured torque from the tool transducer.    Residual torque  10 Nm  The residual torque measured with a calibrated torque wrench or other test tool.    Residual torque correlation factor  100 %  The compensation factor between residual torque and dynamic torque The testing shows that the residual torque is too low to produce the desired clamp force. The Residual torque correlation factor is calculated to 0.83, which is 83 %. An adjustment of the tuning factor is made and the following result is obtained.      Final parameters and results  Value  Function     Target torque  12 Nm  The programmed target torque in the controller.    Final torque  12 Nm  The final torque reported as the result of the performed tightening.    Dynamic torque  14.5 Nm  The uncompensated measured torque from the tool transducer.    Residual torque  12 Nm  The desired residual torque that ensures the desired clamping force.    Residual torque correlation factor  83 %  The compensation factor between residual torque and dynamic torque. What this shows is that we need to tighten a bit more than the specified target, to compensate for differences and to reach the desired torque in the joint.  It is important that the correlation is made with the same tool type and parameter configuration that will be used in production.  "},{"id":"2683154059","fileName":"2683154059.html","title":"Trigger Lost","level":5,"position":156,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Step Configuration Stages","Stage Parameter Descriptions"],"content":" In the Result Evaluationwindow of the program tightening stage, NOK on trigger lostswitch controls whether or not it is allowed to release the tool trigger before the target condition has been reached. The setting can be set to On or Off. Below is a description of the two states.      Switch setting  Description    On  Releasing the trigger before reaching the target condition will result in a NOK tightening.   Off  Releasing the trigger before reaching the target condition will result in an OK tightening as long as all other conditions have been met.  The default behavior is that premature trigger release shall not be allowed.  Availability The NOK on trigger lost is available in the following tightening strategies: Rotate, Quick Step, Two Step, Three Step, and Impulse - Single Step.  For the tightening strategies Rotate, Quick Step, Two Step and Three Step, Trigger Lostsetting is only available when the Target of the program is set to Angle (not Torque)."},{"id":"60434059","fileName":"6043405923858771851.html","title":"Tightening Program Configuration - General Parameters","level":3,"position":157,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab"],"content":"  Changes made to tightening programs in any section need to be actively applied by clicking the Apply button in the bottom right corner of the GUI. Alternatively, changes can be undone by clicking the Undo button in the same location. When navigating away from the section where changes have been made (by using the Back, Home or Result button), the user will be presented with a warning pop-up where the changes can also be applied or undone. The user cannot proceed without applying or undoing changes. The general tightening program settings is used to set up and manage the tightening programs by naming tightening programs, to make general tightening settings such as selecting tightening strategy, Manual or Quick prog mode, and to set the tightening program target value.  For more information about tightening parameters, see Start Stage, Rundown Stage, Tightening Strategies, and Stop Stage. For more information about Loosening parameters, see Loosening a screw. "},{"id":"60436875","fileName":"60436875.html","title":"Name","level":4,"position":158,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Program Configuration - General Parameters"],"content":" Use the Namefield to give the tightening program a name. This name will be stored with the tightening results and sent to ToolsNet (if applicable). The name can be maximum of 32 characters long."},{"id":"60443019","fileName":"60443019.html","title":"Strategy","level":4,"position":159,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Program Configuration - General Parameters"],"content":"  Strategysets the tightening strategy to be used with the tightening program. For more information about the available strategies and the relevant parameters, see \"Tightening Strategies\". "},{"id":"60452235","fileName":"60452235.html","title":"Target","level":4,"position":160,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Program Configuration - General Parameters"],"content":" The Quick step, Two step, and Three step strategies enable the choice of tightening towards either a Target torque or a Target angle value. When TurboTight is activated, only the Target torque option is available."},{"id":"60455307","fileName":"60455307.html","title":"Time Monitoring (elapsed time)","level":4,"position":161,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Program Configuration - General Parameters"],"content":" Time monitoring is available for all tightening strategies except Rotate. Time monitoring can be activated when angle limits are activated. Time monitoring is available for the rundown step and the final step of the tightening step.  To minimize the risk of unexpected jerk at the end of the tightening when using the TurboTight tightening strategy, make sure to activate Time monitoring.  Since handling the trace takes time, there is always a short difference between the Program elapsed time compared to Step elapsed time . This is especially noticeable in programs containing only one step.  When using an STB tool it is not possible to use time monitoring if all monitoring options are switched on. "},{"id":"2683165451","fileName":"2683165451.html","title":"Attachment Tuning","level":4,"position":162,"hasContent":true,"hierarchy":["Configuration","Working with the Tightening Tab","Tightening Program Configuration - General Parameters"],"content":" Attachment tuning gives the possibility to compensate for front attachments on the tool. The compensation can be made for each tightening program. An operator can hot swap an attachment and then select a tightening program tuned for that specific attachment. Attachment tuning is available for all conventional strategies except for the STwrench.    In Tightening program settings, set Attachment tuning enabledto Yes  Click on Tightening parameters > Edit  Click on the start step.  Under Attachment tuning, set Use attachment tuningto Yes  Set the necessary parameters for Gear ratioand Efficiency tuning(see table below).   Parameters for Attachment tuning     Attachment tuning  Description  Default     Attachment gear ratio  The Attachment gear ratiois needed to compensate the angle. Minimum: 0.5 Maximum: 3.6 Socket rotation speed = Tool speed \/ gear ratio  1.0    Efficiency tuning  Attachment gear ratio combined with the Efficiency tuningis needed to compensate the torque. Minimum: 0.5 Maximum: 1.0 For example 0.9 means 10% efficiency loss.  1.0 "},{"id":"59217035","fileName":"5921703523858478219.html","title":"Working with the Batch Sequence Tab","level":2,"position":163,"hasContent":true,"hierarchy":["Configuration"],"content":"   Controller features, such as the Low Reaction Tightening Strategies and controller-wide functions among others, require licenses distributed through the Functionality Management System (FMS). Whereas configuration of features is possible without specific licenses, the assignment and use of those features will require the correct license to be installed on the controller. Please refer to Licenses (FMS) for more detailed information on licenses.  Batch sequences are used to perform a specified number of tightenings in a specific order. Each batch sequence is given a name. "},{"id":"59223435","fileName":"59223435.html","title":"Batch Sequence Settings","level":3,"position":164,"hasContent":true,"hierarchy":["Configuration","Working with the Batch Sequence Tab"],"content":" A batch sequence can consist of up to 99 batches, with a batch size of up to 250 tightenings. The batches in a batch sequence are carried out in the order listed, or by using a Socket selector to choose which batch to run.  Batch settings parameters     Parameter name  Description  Default value    Lock tool on Batch sequence compl.  A batch sequence is completed when the batch sequence counter is equal to the batch sequence size.  On:The tool is locked and a tightening program or batch sequence must be selected to continue performing tightenings.  Off:After completion, the batch sequence is ready to be repeated.  On   Free order   No:The configured batches will be executed in the order listed, provided they have been configured to perform tightenings. If socket has been specified, the system will prompt for the socket when the batch is to be performed.  Yes:The configured batches can be executed in any order. The operator must indicate to the system which batch is to be executed by using a Socket selector. A batch is regarded as complete when all joints have been completed.  No   Increment on NOK  Makes it possible to increment the batch counter value even though the tightening is reported as NOK. For Max consecutive NOK to work (the maximum number of times a single bolt can be tightenened), Increment on NOK must be set to No. Setting this parameter to Yes, will allow the sequence to move on to the next tightening.  No   Max consecutive NOK  Maximum consecutive not OK tightenings (NOK) are a defined maximum allowed number of NOK consecutive tightenings in a batch. If the Max consecutive NOKnumber is reached, the event Too many NOK tightenings (4020)is displayed.  0   Decrement on loosening  Decrements the counter within the currently active batch. Completed batched cannot be decremented.  Never:The setting is off. Counter is not decremented when loosening is performed in the active batch.  Always:The batch counter is decremented when a loosening is performed.  When last tightening was OK:If the preceding tightening was OK, the batch counter is decremented when a loosening is performed.  Never   Sequence abort timer   On:The selected batch sequence can be aborted within a specified time limit  Off:The selected batch sequence cannot be aborted.  Off   Abort time (10-600)  The number of seconds during which the selected batch sequence can be aborted.  10"},{"id":"59220363","fileName":"59220363.html","title":"Batch Configuration","level":3,"position":165,"hasContent":true,"hierarchy":["Configuration","Working with the Batch Sequence Tab"],"content":" A batch is set up to perform a specified number of consecutive tightenings using the same tightening program. Batches must have tightening program and batch size specified in order to run.  Batch configuration parameters     Parameter  Description    Tightening program  The tightening program to use with the batch.   Batch size  Number of tightenings the batch will perform. Max. number of tightenings in one batch is 250. Batch size 0 will give the batch an infinite number of tightenings.   Identifier number  When using a Socket selector, this is the socket position used to activate the batch."},{"id":"1814036875","fileName":"181403687523858644875.html","title":"Working with the Sources Tab","level":2,"position":166,"hasContent":true,"hierarchy":["Configuration"],"content":"  Controller features, such as the Low Reaction Tightening Strategies and controller-wide functions among others, require licenses distributed through the Functionality Management System (FMS). Whereas configuration of features is possible without specific licenses, the assignment and use of those features will require the correct license to be installed on the controller. Please refer to Licenses (FMS) for more detailed information on licenses.  External signals used as tasks for tightenings are configured in the Sourcesmenu. Sources are accessories or similar connected to a virtual station. Two types of source tasks are available:  Source Tighteningtask  Source Batchtask  Source Tighteningis used to select a single tightening program.  Source Batchis used to select a batch sequence, a series of tightening programs. For more information about selection of tasks, see Assigning a Task to a Virtual Station. "},{"id":"1814051083","fileName":"181405108323858651275.html","title":"Source Tightening","level":3,"position":167,"hasContent":true,"hierarchy":["Configuration","Working with the Sources Tab"],"content":" The tightening menu shows a list of source tightening configurations. Separate lists can be linked to a Virtual Station by going to the Virtual Station in question, and choosing Task, Change task. There, a Source can be chosen as a task. Source tightenings link a specific tightening program to an identifier number. When the identifier number is sent to the controller (either by external digital signal, or, in cases where a socket selector is used, by lifting the corresponding socket in the selector) the linked program will run over and over until a different signal is sent (or socket is picked up). There is no batch counting. Source Tightening lists can be set either in Control or Confirm mode. When set to Control, an external source selects a tightening program by requesting an identifier number. In case of a socket selector, the identifier number is linked to a corresponding socket in the socket selector, and by lifting the socket the tightening program is selected. In Confirm mode, the socket selector cannot be used as a controlling source. In this mode identifier numbers are linked to both a tightening program and a specific socket (indicated in an additional column in the list). When an identifier number is requested (by an external signal), the corresponding socket is prompted in the socket selector and the tightening program is activated when the operator lifts the socket (other sockets are disabled). If no socket is specified (that is, set to 0 in the Socket column), the tightening program is activated directly and the socket status is ignored. Product Essentials Tutorials  https:\/\/www.youtube.com\/watch?v=vVAaKtp3O5k "},{"id":"4490313483","fileName":"4490313483.html","title":"Creating a Source Tightening","level":4,"position":168,"hasContent":true,"hierarchy":["Configuration","Working with the Sources Tab","Source Tightening"],"content":"  Changes made to tightening programs in any section need to be actively applied by clicking the Apply button in the bottom right corner of the GUI. Alternatively, changes can be undone by clicking the Undo button in the same location. When navigating away from the section where changes have been made (by using the Back, Home or Result button), the user will be presented with a warning pop-up where the changes can also be applied or undone. The user cannot proceed without applying or undoing changes.    Go to the Sourcesmenu, then select Tighteningon the left navigation.  Click the plusicon in the top right of the workspace.  Give the Source Tightening a name and select the correct Selector mode(Control or Confirm, depending on what is required).  By default, only one editable Identifier number will be available when creating a new Source Tightening. At the bottom of the screen, click the plusicon to add more.  Give every item an identifier number  If a socket selector is used, the identifier numbers will correspond to the positions in the socket selector, i.e. Identifier number 1 corresponds to socket number 1 in the socket selector.  Choose a tightening program to link to each identifier number by clicking on Programand choosing from the list of tightening programs. Sources - max consecutive NOK Max consecutive NOK can be set per Source Tightening or per individual program included in the Source Tightening.    Set Max consecutive NOK per programto No  Set the value in the Max consecutive NOKfield.    Set Max consecutive NOK per programto Yes  For every program in the Identifier selector configurationsection, set the value in the Max NOKcolumn. "},{"id":"1814065803","fileName":"181406580324645702923.html","title":"Source Batch Sequence","level":3,"position":169,"hasContent":true,"hierarchy":["Configuration","Working with the Sources Tab"],"content":" The Source Batch configuration is found under the Batchoption in the Sources menu. The controller can be configured to select a batch sequence based on either an identifier number or an identifier string.       Input  Description     Identifier number  The number must be a positive integer number that can originate from an accessory or from an external control entity.    Identifier string  The string must consist of ASCII characters and can originate from a scanner or from an external control entity.    Socket selector  The use of one or several socket selectors. Product Essentials Tutorials  https:\/\/www.youtube.com\/watch?v=-dTjDz6ravw  "},{"id":"4492689291","fileName":"4492689291.html","title":"Creating a Source Batch","level":4,"position":170,"hasContent":true,"hierarchy":["Configuration","Working with the Sources Tab","Source Batch Sequence"],"content":"    Go to the Sourcesmenu, then select Batch sequenceon the left navigation.  Click the plusicon in the top right of the workspace.  Give the Source Batch a name  Set the Abort on new identifierto Yesif scanning a new identifier string should abort the previous scan.  Select the Identifier method(String for text, or Number for numerical strings)  Set Free orderto Onif the strings should be able to be scanned in any order.  Identifier strings can be made up of up to 4 different strings. When free order is set to No, the strings need to be scanned in a specific order for the system to recognize the string.  If required, add an identifier string by clicking on the Plusicon in the Identifier string configurationsection.  Click on the Namelabel for the identifier string you want to change the properties of (pop-up window). The following properties can be indicated per string:   Name - the name of the string  Length - the length of the string. See Combining Identifier Strings for more information on concatenating strings.  Significant positions - used to specify which characters in the barcode string to read when putting together the string to match with your pre-defined string. The number of significant positions must match the number of characters in the pre-defined strings.  Saved positions - indicate which parts of each string used in the Source Batch is saved, and how they are represented in the log. In this field, indicate the positions in the string that need to be saved. Positions can constitute only parts of the entire string. If the field is left empty, the entire (concatenated) string will be saved. The table below shows some examples of saved position combinations. Saved position values are comma-separated (without spaces), and ranges are indicated using a hyphen.      Identifier string  Positions    String 1: 1234567  1-7   String 2: abcdef  8-13   String 3: GHIJKL  14-19   String 4: 890  20-22  Saved position examples     Saved positions  Saved results    (empty)  1234567abcdefGHIJKL890   1-3,9,11,15,20-22  123bdH890   8-12,1-7,19,20-21 will be changed automatically to: 1-12,19-21  1234567abcdeL89  The ID field in the string properties window cannot be altered, but can only be used to navigate between the different strings.  An error may occur when Free orderis set to On, and the lengths of the different strings are duplicated. The scanned sequence will then not activate a tightening program. To remedy this error, set Free orderto Off, or adjust the string lengths.  Click Edit.  In the Editwindow, indicate which strings (in the String containscolumn) should be linked to which Batch sequence (in the Activatescolumn). Click the plusicon at the bottom to add more strings.  Wildcards can be used when typing the \"string contains\". The wildcard(s) can be used at any position in the string. No Batch sequence is activated in case of an ambiguous matching result. The wildcard is a . (period) "},{"id":"59277835","fileName":"59277835.html","title":"Configuring Significant Positions to Read in Barcode String","level":4,"position":171,"hasContent":true,"hierarchy":["Configuration","Working with the Sources Tab","Source Batch Sequence"],"content":" The positions in the barcode string are associated with a number between 1 and 1024. The first position of the string is 1 and the last is 1024.  The significant positions must be specified following the rules described in the table below. Barcode strings:      Description   Significant positions   Valid configuration   Barcode string to match with pre-defined string    Significant positions in order  1,2,3,7,8  Ok  ABCGH   Significant positions in optional order  7,1,2,3,8  Ok  GABCH   Range of numbers  1–3,7-8  Ok  ABCGH"},{"id":"1238871947","fileName":"1238871947.html","title":"Combining Identifier Strings","level":4,"position":172,"hasContent":true,"hierarchy":["Configuration","Working with the Sources Tab","Source Batch Sequence"],"content":" The identifier stringthat is used for matching is a combination of up to four strings from a factory management system or up to four scanner inputs that need to be combined into one string. The Addand Deletecommand buttons manage how many strings are combined. The following parameters are available:  Parameters for combining identifier strings     Parameter  Description     Check box  Select an entry if it is to be deleted.    Name  The string must be given a name.    Length  The length of the string must be known and must be entered. This is important to be able to combine the correct string identifier.    Significant positions  The comma-separated positions or ranges (separated by hyphen) in the combined string that are used for matching.    Saved positions  The comma-separated positions or ranges in the strings that will be saved in the result. If more than one identifier stringis to be used, perform the following steps:    Press the Addcommand button to create a new entry in the table.  Issue the string a name.  Enter the length of the string.  Repeat steps 1-3 for every string to be added. Up to four strings can be combined. The Start-End parameters in each row define the individual string positions in the combined string identifierthat is used in the next step of the matching process.  The first part in the task selection process using an identifier stringas an input, is to define which positions in the string that are to be activated:  Enter the significant positions, to define which positions in the identifier stringwill be used for matching. The positions must be either comma-separated, or by range."},{"id":"91189387","fileName":"9118938723858458507.html","title":"Working with the Tool Tab","level":2,"position":173,"hasContent":true,"hierarchy":["Configuration"],"content":"  A tool must be connected to the controller for the Toolmenu to show information. "},{"id":"60342539","fileName":"60342539.html","title":"Tool Information","level":3,"position":174,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":" The Tool information view contains information used for giving service personnel accurate information about the tool connected to the controller, so that they can give adequate help and support, or for operators to see what tool is connected to the controller.  Tool information     Information  Description     Model  Tool model denomination.    Max torque  The maximum torque the tool can use for a tightening.    Min speed  The minimum rotation speed of the tool.    Max speed  The maximum rotation speed of the tool.    Min final speed  The minimum final rotation speed of the tool (only for BCP\/BCV-RE tools).    Max final speed  The maximum final rotation speed of the tool (only for BCP\/BCV-RE tools).    Gear ratio  The ratio of the angular velocity of the input gear to the angular velocity of the output gear.    Serial number  The tool’s serial number may be needed when the correct version of the Product instruction is required, in order to get the correct spare parts or service instructions.    Software version  Tool software version.    Product number  The tool’s Product or Ordering number. Tool TAG information  Tool TAG information is only available if the tool type is a STwrench.  STwrench tool information     Information  Description     TAG id  The programmable RFID TAG identification number that is programmed into the End-fitting tool(Socket).    Torque correction coefficient  In certain cases extensions may be needed to fit the application. In this case the wrench measurement must be compensated to show a correct value. To calculate the correction coefficient, refer to the latest version of the STwrench User Guide (printed matter number 9836 4134 01). The parameter is stored in the RFID TAG in the End-fitting tool.    Angle correction coefficient  In certain cases extensions may be needed to fit the application. In this case the wrench measurement must be compensated to show a correct value. To calculate the correction coefficient, refer to the latest version of the STwrench User Guide (printed matter number 9836 4134 01). The parameter is stored in the RFID TAG in the End-fitting tool.    Nominal torque  The smartHEAD of the STwrench contains the torque transducer and defines the wrench’s nominal torque. For more information, refer to the latest version of the STwrench User Guide (printed matter number 9836 4134 01).  The correction coefficients alter the STwrench measurement. It may cause an improper reading. Before making any corrections, refer to the latest version of the STwrench User Guide (printed matter number 9836 4134 01). "},{"id":"67529611","fileName":"67529611.html","title":"Tool Connection","level":3,"position":175,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":" The tool connection area shows which virtual station the tool is connected to. "},{"id":"3244190859","fileName":"3244190859.html","title":"Tool Health","level":3,"position":176,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":" The Health view contains information about tool temperature. Tool temperature Tool temperatures (both for cabled and battery tools) are monitored continuously by the POWER FOCUS 6000. Supported temperature units are degrees Celsius (°C) and degrees Fahrenheit (°F), with Celsius being the default unit. It is possible to switch between the two units without requiring a controller restart. When the tool motor temperature or tool electronics temperature exceeds max temperature, the tool is locked and an alert (2014) is shown. The tool is once again unlocked when the tool temperature drops below the temperature limit.  Tool temperature is not available for the STwrench. Monitoring Tool Temperature From the display or through the web GUI, users can access the latest tool electronics and tool motor temperatures measured together with the timestamp when the measurement was taken.    On the Home view, tap on the Tool Tab.  Both tool electronics temperature and tool motor temperature are listed under Health. For pulse tools, the Tool pulse unit temperature is also listed.  Click on either entry to access a list of peak temperatures and their timestamps."},{"id":"60324235","fileName":"60324235.html","title":"Tool Maintenance","level":3,"position":177,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":" The tool stores a service interval number and counts how many tightenings can be performed before a tool maintenance, or service is needed. Setting the Maintenance Alarm    On the Home view, tap on the Settings Tab, then select Tool.  Set the Service indicator alarmto On.  Return to the Home view, tap on the Tool Tab, and then select the tool you wish to set the alarm for.  Enter a value in the Service interval box.  Service intervals can only be set in multiples of 10 000. Any number other than multiples of 10 000 is rounded off to the nearest multiple of 10 000.  When working with pulse tools, both service intervals for number of tightenings and number of pulses is set. Whichever interval is reached first will trigger the alarm.  Maintenance parameters     Field  Description     Last service  Date and time when last service was performed. The Last service date is set at the repair workshop. The Last service dateis set to current date and time when the Reset service countbutton is pressed.    Total tightenings at service  Total number of tightenings performed by the tool since it was used for the first time. This value is made available at service, and will remain the same until next service.    Remaining tightenings  Total number of tightenings left until the service interval is reached.    Service interval  Number of tightenings to be performed between two service events. Can be set in multiples of 10 000.    Total pulses at service  [pulse tools only] Total number of pulses performed by the tool since it was used for the first time. This value is made available at service, and will remain the same until next service.    Remaining pulses  [pulse tools only] Total number of pulses left until the service interval is reached.    Service interval  [pulse tools only] Number of pulses to be performed between two service events. Can be set in multiples of 10 000.    Reset service counter  Reset of the Remaining tighteningscounter and sets Last service dateto current date.    Reset service data  [pulse tools only] Reset of the Remaining tighteningscounter as well as oil status and sets Last service dateto current date. "},{"id":"59654923","fileName":"5965492323858464907.html","title":"Tool Calibration","level":3,"position":178,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":"  Tool calibrationis used to control how well a tool corresponds to a reference transducer. The calibration value stored in the tool memory is used to adjust the torque value given by the tool’s torque transducer so that the correct torque value is displayed on the controller. The controller displays the date when the tool was last calibrated.  Calibration parameters     Field  Description     Last calibrated  Date and time when last calibration was performed.    Calibration value  Torque value to calibrate against.    Next calibration date  Date when the next calibration of this tool is needed. "},{"id":"59658251","fileName":"59658251.html","title":"Preparing the Calibration","level":4,"position":179,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab","Tool Calibration"],"content":"    Make sure the tool and controller are set up to perform tightening.  Set up the tool with a torque reference transducer (such as the STa6000, STpad or JSB Bench).  Refer to the torque reference transducer User Guide for set-up instructions.  Select a Tightening program with a target torque corresponding to a tightening normally used with your tool.  See Basic Tightening setup for a tutorial on setting up and activating a suitable tightening program."},{"id":"59661323","fileName":"59661323.html","title":"Calibrating the Tool","level":4,"position":180,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab","Tool Calibration"],"content":" The calibration value used for the tool is calculated from the torque readings read from the controller, and the torque reference transducer through the equation below:  New calibration value = Old calibration value × Mean (Reference values \/ Power Focus values)    On the Home view, tap on Tool Tab and select the tool to be calibrated. Then, go to Calibration.  Take note the old calibration value found in the Calibration valuetext box.  Make at least three tightenings and use the torque values read from the controller and the reference transducer (ACTA or similar) for calculating the mean torque values.  Calculate the new calibration value using the New calibration valueequation.  Store the new calibration value in the tool memory by entering the calculated value in the Calibration valuetext box and tapping Apply.  After calibration is completed, perform a tightening to verify that the new values are correct."},{"id":"8296748811","fileName":"8296748811.html","title":"Calibrating a Tool Through the STa6000 or STpad","level":4,"position":181,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab","Tool Calibration"],"content":" Connecting the STa6000\/STpad The STa6000\/STpad can be connected to the controller in two ways:    Connecting the STa6000      Connection  Remarks    COM port  Connect the Atlas Copco USB to Serial adapter to the controller's USB port using the ACTA Serial cable. Connect the STa6000 to the Serial Adapter using a USB cable.   Ethernet port  Connect the ethernet cable between the STa6000 and the controller's Factory Ethernet port, or the factory network.    Connecting the STpad      Connection  Remarks    COM port  Connect the STpad to the Controller's COM port using the ACTA Serial cable.   Ethernet port  Connect the ethernet cable between the STa6000 and the controller's Factory Ethernet port, or the factory network. Performing the QA Calibration through the STa6000 or STpad    Make sure the tool is connected and assigned to a virtual station on the controller.  Single tightening programs cannot be used for calibration purposes. Make sure a batch program is selected.  On the Home view, tap on Tool Tab. Then click on QA Calibration, and set the QA Calibration to On.  Select the virtual station the tool to be calibrated is connected to, and select the connection type to be used (TCP of COM port).  Note that the default port for communication is 4561  Connect the STa6000\/STpad to the controller, and select the correct virtual station.  Start the calibration from the STa6000\/STpad.  The STa6000\/STpad requests controller information, including tool information and tightening program.  Execute the tightening. When the calibration device detects a tightening, it requests the tightening result from the controller.  Repeat the above step until all tightenings in the batch have been executed.  Once completed, the STa6000\/STpad creates a report, as well as calculate a new calibration value for the tool.  Select Store in the STa6000\/STpad to send the new calibration value to the controller, which in turn writes it to the tool.  During calibration, if the tightening program is changed, or the sequence\/batch is updated, the calibration is terminated.  There is no limit in the batch size used for calibration purposes. However, the STa6000 can only display two digits as batch size. Thus, the counter on the Sta6000 reads 00 for 100.  After calibration is completed, perform a tightening to verify that the new values are correct."},{"id":"23017200267","fileName":"23017200267.html","title":"Tool Diagnostics","level":3,"position":182,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":" In Diagnostics it is possible to run:   Sensor tracking  Diagnostic tests Sensor tracking To diagnose a tool, the angle or torque sensor, it is possible to start a Sensor tracking session in the Tool menu. A Sensor tracking session has a time out of 20 minutes. A warning is shown 5 minutes before timeout and it is then possible to extend the session or to stop it.  Sensor tracking is only possible for cable tools.  It is only possible to start one Sensor tracking session for each tool and controller at a time.    In the HOMEwindow select Tool.  Select Cable Tooland Sensor Trackingin Diagnostics.  Turn On Start sensor tracking.  Tool angle, torque and speed are shown.  Sensor tracking information     Tool angle  How much the tool has turned since the sensor tracking session started or since the last reset.   Torque  Readout: the instantaneous value for the torque. Peak value: the highest measured torque value since the sensor tracking session started or since the last reset.   Speed  Readout: the instantaneous value for the speed. Peak value: the highest measured speed value since the sensor tracking session started or since the last reset. Diagnostic tests To find out if a tool works correctly it is possible to do a diagnostic tests of the tool. The type of test that can be run depends on which tool is connected. Three different types of tests can be run:   Automatic production test: No action is required from the user.  Manual tests with no acknowledgment: The user has to do some tasks during the test.  Manual tests with acknowledgment: The user has to monitor and give feedback on the tool´s behavior.  It is only possible to start one diagnostic test for each tool and controller at a time. When the diagnostic test is started the session is locked for other clients. A diagnostic test session has a time out of 20 minutes. A warning is shown 5 minutes before timeout and it is then possible to extend the session or to stop it.  Diagnostic test information     Automatic production test  Manual test with no acknowledgment  Manual test with acknowledgment      Transducer shunt check  Secondary transducer shunt check    Start button\/Trigger  Safety trigger  Reverse ring\/switch or button  Push start  Function button    Speaker\/Buzzer  LEDs    In the HOMEwindow select Tool.  Select Cable Tooland Diagnostic Testsin Diagnostics.  Turn on Diagnostic Tests.  Select the test you want to run.  Follow the instructions on the screen.  All tests show result with green or red indication.  The diagnostic test times out if no action is done within 20 seconds.  A diagnostic test result is shown when the a test session is completed.  If you leave the diagnostic test page the result will disappear!  To export a test result; select the Exportbutton."},{"id":"23123128331","fileName":"23123128331.html","title":"Zero Position","level":3,"position":183,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":" This configuration makes a system always return to the original start position for each tightening or sequence. Zero Position is set for each tool separately for both handheld and fixtured. Zero position sets the current position of the tool. It is not possible to set Zero Position during an ongoing tightening or sequence. Set a zero position:    In the home view select Tool.  Select Cable Tooland then Zero Positionin the right menu.  Select SET. The current position of the tool will be set as Zero Position."},{"id":"59618571","fileName":"59618571.html","title":"Tool Motor Tuning","level":3,"position":184,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":" A motor tuning adjusts the tool’s motor control unit to optimize the performance and minimize loss. For cable tools a motor tuning should be performed on each specific combination of controller and tool together. STB tools can be moved to another controller without the need to perform a new motor tuning. Before performing the motor tuning, make sure the tool is connected to a virtual station and that the controller is set up to perform tightening. The motor tuning takes approximately 1 minute to perform and rotates the spindle in both clockwise (CW) and counterclockwise (CCW) directions before it is finished.  For tools configured with open end Gear Front Attachment (GFA), remove the open end extension from the tool before performing the motor tuning. Performing tool motor tuning    On the Home view, select the ToolTab. Then, select the tool to be motor tuned and go to Motor tuning.  Select Perform, and then press the trigger on the tool.  Select OKto start the Motor tuning. Follow the instructions on the screen and keep pressing the tool trigger until the motor tuning is done.   If the motor tuning is successful, an OK event is displayed.  If the motor tuning is not successful, or the tool trigger was released before the motor tuning is done, an NOK event is displayed."},{"id":"23515569291","fileName":"23515569291.html","title":"Front End Configuration","level":3,"position":185,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":" Configure the tool to use the correct front end attachment.    Go to Toolin the home menu and select Cable Tool > Front End Configuration.  Select the Front End Type. If Open End is selected, the following parameters can be set.  Before using an Open End tool, make sure that the tool head and tool body have been assembled and configured correctly. If not, the tool can run in the wrong direction and the mechanical stop in the Open End head may be damaged.      Settings  Description    Invert motor direction  Available for Open End and Closed End.  Off: Default  On   Tightening direction   CW: Default Tightening direction set to clockwise.  CCW Tightening direction set to counterclockwise.   Positioning limit   Manual Set the Torque positioning limit.  Auto: Default Torque positioning limit automatically set to 2% of maximum torque but at least 2 Nm.  Select Applyto set up the configuration. The tool will restart. Perform Open End tuning The Open End tuning function is available for tools configured with Open End Gear Front Attachment (GFA). The function calculates the true gear ratio of both the tool and the extension combined, and saves it to the tool. The tuning will take approximately two minutes to perform.  When the Open End tuning is completed the tool must be calibrated with the Open End extension attached.    Select Performand then press the trigger on the tool.  Follow the instructions on the screen and keep pressing the tool trigger until the Open End tuning is completed.   If the Open End tuning was successful an OK event will be displayed.  If the Open End tuning was not successful, or the tool trigger was released before the tuning was finished, an NOK event will be displayed."},{"id":"5146918411","fileName":"514691841123858471819.html","title":"WLAN and Bluetooth for Wireless Tools","level":3,"position":186,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab"],"content":" The POWER FOCUS 6000controller has built-in wireless LAN and Bluetooth radio modules that enable the connection of wireless tools to a controller using a pairing process. When the pairing is established, the tool will connect to the controller automatically as soon as the tool is in range of the controller. A tool paired with a controller is only able to connect to that specific controller even if another controller is set up to use the same radio channel. The WLAN radio module in the controller can connect to three tools at a time, while the Bluetooth module allows for six simultaneous connections. "},{"id":"13503952651","fileName":"13503952651.html","title":"Pairing mode for STB tool and STwrench","level":4,"position":187,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab","WLAN and Bluetooth for Wireless Tools"],"content":" Placing the STB Tool in Pairing Mode    Disconnect the (charged) battery from the tool.  Press the tool trigger while re-attaching the battery.  When the tool LEDs are off, release the tool trigger.  When the tool LEDs are on again, press the tool trigger.  When the tool LEDs are off again, release the tool trigger. Both LEDs start to flash (after approximately 10 seconds).  The tool is now in pairing mode. The LEDs keep flashing when the tool is in pairing mode.  Do not start the Power Focus pairing procedure before both LEDs on the tool are flashing. Initiate pairing within 30 seconds or the tool might time out.  When the tool is placed in pairing mode, tap the connection type to start the pairing process. Placing the STwrench in pairing mode    Turn on the STwrench.  During the cell and gyroscope adjustment, press the UP, RIGHT and BARCODE buttons on the STwrench keyboard in that order.  At the end of the zero adjustment, the wrench is in pairing mode.  When the tool is placed in pairing mode, tap the connection type to start the pairing process."},{"id":"5147572619","fileName":"5147572619.html","title":"Bluetooth Requirements","level":4,"position":188,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab","WLAN and Bluetooth for Wireless Tools"],"content":"  In order to use Bluetooth with the POWER FOCUS 6000, the following requirements need to be met:   POWER FOCUS 6000software 2.6 or higher  A wireless tool equipped with a Bluetooth module  Tool software boot version 9.1.6 or higher  Tool software app version 3.6.1 or higher"},{"id":"5147554699","fileName":"5147554699.html","title":"Wireless Tools Restrictions","level":4,"position":189,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab","WLAN and Bluetooth for Wireless Tools"],"content":" When all WLAN (3) or Bluetooth slots (6) are filled, additional wireless tools paired with the controller will replace existing paired tools. There are a few rules governing this replacement. In the case of WLAN, one of the previously paired tools will be replaced at random. In the case of Bluetooth, offline tools will be replaced first, followed by online tools. Tools linked to a Virtual Station will never be replaced. When pairing an additional Bluetooth-equipped tool to a controller that already has six wireless Bluetiooth tools linked to Virtual Stations, make sure to remove one of the paired tools from one of the Virtual Stations before pairing the additional tool. The tool disconnected from the Virtual Station will then be replaced by the new tool."},{"id":"5147792523","fileName":"5147792523.html","title":"Pairing a Wireless Tool to a Controller","level":4,"position":190,"hasContent":true,"hierarchy":["Configuration","Working with the Tool Tab","WLAN and Bluetooth for Wireless Tools"],"content":"  The pairing of a Mechatronic Wrench to a controller is done differently than other wireless tools, and requires an MWRKit to be connected to the controller. Please refer to the tool's Product Instructions for more detailed information.  Before you start the pairing process:  Make sure WLAN or Bluetooth is enabled in the Controller (Depending on the wireless tool you want to pair)  Make sure there are pairing slots available (3 for WLAN and 6 for Bluetooth)  Check which radio channel to use  Check how to put the tool into pairing mode. See the STB user guide (9836 3043 01) for instructions on how to do this, or follow the instructions below  If possible, have a clear line of sight between tool and controller  Make sure no other tools are being paired with the controller at the same time    Enable the internal WLAN by going to the Settings> WLAN. Drag the Enabledswitch to On  If the WLAN Enabled switch is set to Off it is not possible to pair a tool to the controller. Tools already connected to the internal WLAN are disconnected when the Enabled switch is set to Off.  Set the radio channel to be used with the wireless tool. On the Home view, tap on Settings Tab, and click WLAN.  In the Radio channel area, tap the channel list and choose the appropriate channel.  Changing the channel will permanently disconnect all wireless tools paired with the controller.  Return to the Home view, and tap on Tool Tab. Then, tap the pairing icon in the upper right corner.   Put the tool in pairing mode. See Putting the wireless tool into pairing mode.  In the Pairingdialog box, click Performto start the pairing process.  The pairing process will end with one of the following results:    Pairing successful- The tool has been paired to the controller using the selected channel.   Pairing unsuccessful- This can be due to any of the following reasons:   No tool detected during the pairing process. Make sure the tool is in range and in pairing mode, and then click Closeand try again.  More than one tool was found during the pairing process. Make sure no other tool is in pairing mode, and then click Closeand try again.  Pairing already in progress. Make sure no one else is performing the pairing process on the controller, and then click Closeand try again.  Pairing failed. Click Closeand try again.  An IRC-W Infrastructure tool is a tool that is using the factory's wireless infrastructure to connect to the controller. The tool configurations, ADHOC or Infrastructure Mode, are set in ToolsTalk Service 2. A tool configured as an IRC-W Infrastructure tool can also connect as an ADHOC connected tool, using the controllers own built-in network. But when the tool restarts, it will revert to an IRC-W Infrastructure configured tool.  "},{"id":"91207435","fileName":"9120743523858619275.html","title":"Working with the Virtual Station Tab","level":2,"position":191,"hasContent":true,"hierarchy":["Configuration"],"content":" Virtual stations are configured in the Virtual Stationmenu. A virtual station is a software abstraction of a physical station and can be set up to use a specific tool and remotely execute different tasks using the tool. In POWER FOCUS 6000, it is possible to set up a number of virtual stations per controller. Each virtual station can be connected to one tool and one or more accessories. By using virtual stations, the operator can operate multiple tools and run different tasks using the same controller. It is possible to connect one cable tool and multiple STB tools simultaneously to the controller. When configuring different tools, make sure the selected start signal in Start source matches the selected tool and that the selected task can be run on the specific tool.  Before any tightening can begin a task must be selected in the virtual stations menu. A task is of one of three types:  Tightening program  Batch sequence  Sources The selection can be made manually by the operator or by external signals. Product Essentials Tutorials  https:\/\/www.youtube.com\/watch?v=Ay0zO5fGSD8 "},{"id":"84065675","fileName":"84065675.html","title":"Creating a Virtual Station","level":3,"position":192,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab"],"content":"   Controller features, such as the Low Reaction Tightening Strategies and controller-wide functions among others, require licenses distributed through the Functionality Management System (FMS). Whereas configuration of features is possible without specific licenses, the assignment and use of those features will require the correct license to be installed on the controller. Please refer to Licenses (FMS) for more detailed information on licenses.   Create a virtual station To create a new virtual station:    Tap on the plus sign.  Edit the name and other parameters. To remove a virtual station: Tap on delete at the bottom of the list of parameters. The list of virtual stations created is presented in the order of creation.  If no tool configuration is available when assigning a tool, a new tool configuration is automatically created and assigned to the virtual station. This auto-created tools configuration will have Start source set to Trigger onlyand trace set to Off.For STB tools Start request will be set to On.  "},{"id":"9844859531","fileName":"9844859531.html","title":"Assigning Licenses to a Virtual Station","level":3,"position":193,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab"],"content":"  To make virtual stations working, it is needed to assign them a Virtual Station Type license.    Select the Virtual Stationmenu and select the virtual station you want to assign licenses to.  In the Licenses section, select the arrow in the Virtual station typefield  The Change License Typewindow appears.  Select the Virtual Station Type you want to assign to the virtual station.  [If additional Virtual Station Featuresneed to be assigned] Select Editin the Featuresfield.  The Select Featureswindow appears.  Check all features you want to assign to the virtual station, then select OK."},{"id":"9844863243","fileName":"9844863243.html","title":"Unassigning licenses from a Virtual Station","level":3,"position":194,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab"],"content":"    Select the Virtual Stationmenu, then select the virtual station you want to unassign licenses from.  In the Licensessection, select the name of the license in the Virtual Station Typefield.  The Change License Typewindow appears.  Select the name of the assigned Virtual Station Type you want to unassign.  The Change License Typecloses and the Virtual Station Typefield will say None. All features will be removed from the controller as well.  When a Virtual Station is deleted, the licenses associated with that Virtual Station will automatically be returned to the Pool."},{"id":"67551243","fileName":"67551243.html","title":"Connecting a Tool to a Virtual Station","level":3,"position":195,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab"],"content":" A virtual station can only have one tool connected. Just one of the tools connected to a controller can be a cable tool. Added virtual stations can connect wireless tools paired to the controller. Each virtual station needs to have one tool configuration, in addition to the tool. The tool configurations are created in the Configurationsmenu.     Go to the Virtual stationmenu and tap the virtual station you want to connect the tool to.  In the Tool area, tap Choose toolto open the list of available tools. Or, if a tool is already chosen, tap Change toolto open the list of tools available to change to.   In the list of available tools, tap the desired tool to connect it to the virtual station.  Tools not available will be greyed out. To connect such a tool, it must first be disconnected from its virtual station.  When connecting a new tool a tool configuration is attached. If there are more than one configuration available a list of tool configurations is shown.    To replace the tool configuration for the virtual station:  Click on the arrow beside the name of the current configuration.  Choose another of the configurations in the list. It is not possible to deselect a configuration, only to select another available configuration.    "},{"id":"91212555","fileName":"9121255523858632075.html","title":"Configuring Task Window in a Virtual Station","level":3,"position":196,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab"],"content":" The selected task can either be running a tightening program, running a batch sequence or enabling the task using a source configured in the Sourcesmenu. The task can be monitored from the controller and the result of the task can be presented together with any events that may have occurred during the operation. "},{"id":"4502200843","fileName":"450220084323858638475.html","title":"Configuring Manual Mode in a Virtual Station","level":4,"position":197,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab","Configuring Task Window in a Virtual Station"],"content":" Manual mode for Virtual stations is used for performing tasks while the tool is in locked mode. In cases where the tool is locked for a certain reason (e.g. because the tool is outside its TLS footprint) there still may be a need to perform certain tasks with the tool, such as performing emergency work. By configuring manual mode for the virtual station, users can determine what signals are sent when entering manual mode (Entering signals), what task can be performed while in manual mode (Secondary task), and what signals are sent when leaving manual mode (Leaving signals). Since desired scenarios can vary between different users (i.e. which signals to send upon entry and exit and what task to perform), manual mode is fully configurable for each virtual station. Configuration consists of three elements: entering signals, leaving signals and secondary task (note that by primary task is meant the (automatic) task that is assigned to the virtual station under Task).    Go to the Virtual stationmenu and click on the virtual station to configure, then under Task, click on Set manual mode  In the Manual mode configuration screen, set the secondary task. This determines which task shall be run when in manual mode.  If no secondary task is set, the primary task will be used during manual mode.  All task types (tightening, batch sequence, source) can be set for the secondary task as for the primary task.  Set the entering signals to be sent by clicking the plusicon at the bottom of the Enteringsection. See the parameters for entering signals below.  Set the leaving signals to be sent by clicking the plusicon at the bottom of the Leavingsection. See the parameters for leaving signals below.  There is a limit of 99 signals that can be set for entering and leaving. "},{"id":"4504901899","fileName":"4504901899.html","title":"Entering and Leaving Signals","level":5,"position":198,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab","Configuring Task Window in a Virtual Station","Configuring Manual Mode in a Virtual Station"],"content":" The parameters for entering and leaving signals are the same. There are two types of signals: Boolean and integer\/string type. For Boolean type signals, an on\/off (true\/false) switch is used. For integer\/string type signals, a text field is used where the (I\/O) signal or string can be indicated.      Signal  Type  Default value    Abort sequence  Boolean  Off   Acknowledge events  Boolean  Off   Activate tool scanner  Boolean  Off   Clear results  Boolean  Off   Disable Fieldbus  Boolean  Off   Disable Open Protocol Commands  Boolean  Off   Disable Tool scanner  Boolean  Off   Dynamic batch size  Integer  0   External identifier  Integer  0   External monitored [1-8]  Boolean  Off   Flash Tool Green Led (external protocol)  Boolean  Off   Generic IO [1-10]  Integer  0   Id for dynamic batch size  Integer  0   Reset batch  Boolean  Off   Reset batch sequence  Boolean  Off   Reset bistable relay  Boolean  Off   Reset Too Many NOK  Boolean  Off   Select input  Integer  0   Set bistable relay  Boolean  Off   Unlock tool on complete  Boolean  Off   Unlock tool on disable  Boolean  Off"},{"id":"91215627","fileName":"91215627.html","title":"Configuring Protocols Window in a Virtual Station","level":3,"position":199,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab"],"content":" Under the tab Protocols, in the Virtual Station menu, you will find a list of available communication protocols depending on the current license in use. The Open Protocolis available for all licenses.  To gain access to ILM Protocolfunctionality, refer to the  ILM AdapterUser Guide. To gain access to functionality through Open Protocol, a unique port for each Virtual Station needs to be defined.    Set the  Open Protocolswitch to On.  Enter the Server portnumber.  Enter the Communication timeoutvalue in seconds, between 15 and 60.  Enter the PLC Indexvalue between 1 to 6.   PLC Indexis used to map where in the shared memory the Open Protocolcommands are to be written. The default value is 1 but it is possible to enter values 1 to 6.  Choose the action to be applied when the connection to the client is lost.  The Disconnect setting controls the action applied when a connection error occurs:   None- The tightening program continues normally.   Lock tool- The tool is locked after finishing the current tightening normally.   Unassign task- The tightening is ended after finishing the ongoing task. Except for plain tightening programs or Batch sequences where the task will be removed after finishing.   Always lock tool- The tool is locked after finishing the current tightening, regardless of result.   Use legacy counter The legacy counter setting counts all tightenings in a sequence and outputs that number to secondary systems. To enable this setting, set Use legacy counterto Yes.   MID0015 Echo selected identifier number This setting allows for responding the selected identifier number value in MID0015 PSET_SELECTED if MID0015 Echoselected identifier number set to Yes. Otherwise, the actual tightening program id is sent.   MID2500 loosening program This setting allows for the selection of a MID2500 loosening program from the list.  Tap or select Applywhen ready.  As the default value for SoftPLC Indexis always 1 and no checks are made to see if it is in use, there is a possibility that you may have configured the system so that the same index is configured several times when adding Virtual Stations. In this case, the Soft PLCwill not be able to determine from which Virtual Station the incoming MID is originating from."},{"id":"91218187","fileName":"9121818723858625675.html","title":"Configuring Accessories Window in a Virtual Station","level":3,"position":200,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab"],"content":" For connecting and disconnecting QIF accessories to and from a virtual station, see Connecting QIF accessories to a virtual station and Connecting QIF accessories to a virtual station. For troubleshooting with the help of I\/O diagnostics of an accessory, see Digital Signal Diagnostics. "},{"id":"79780747","fileName":"79780747.html","title":"Digital Signal Diagnostics","level":4,"position":201,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab","Configuring Accessories Window in a Virtual Station"],"content":" During deployment and during troubleshooting of a controller, a diagnostic tool is very helpful. It is available for the analysis under the Info tag for a device configuration or a fieldbus mapping in the Virtual stationmenu. The controller can operate in normal mode or in diagnostics mode. In normal mode the digital input and output signals operate normally and are routed between the internal controller logic and to an external accessory or a connector. The diagnostics mode is divided into monitor mode and forced mode. In the monitor mode signals operate normally, but provide live monitoring of the signal behavior. In forced mode the connection between the controller internal logic and the external accessory is opened and the input and output signals can be forced to a desired state. It is possible to diagnose digital signals for one device or one fieldbus at a time."},{"id":"81385227","fileName":"81385227.html","title":"Diagnostics Configuration","level":4,"position":202,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab","Configuring Accessories Window in a Virtual Station"],"content":" Diagnostics for a specific accessory or fieldbus is accessible through the Info option in the Virtual Station view for the accessory or fieldbus.    Tap Infoand on the next screen tap Diagnostics.  Activate Monitor modeor Forced modewith the switch.  The statuses of input signals and output signals are available under the respective tabs.  It is only possible to access the diagnostics from one single user or function at a time. If the diagnostics is already in use an information message is shown on the screen.   "},{"id":"79762059","fileName":"79762059.html","title":"Normal Operations","level":4,"position":203,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab","Configuring Accessories Window in a Virtual Station"],"content":" In normal operations mode external input signals are passed to the internal controller logic and controller output signals are passed to an external target, without any intervention from the diagnostics module.        A  Controller internal state machine and logic functions   B  Digital output signal path   C  Digital input signal path   D  Diagnostics module  "},{"id":"81614859","fileName":"81614859.html","title":"Monitor Digital Signals","level":4,"position":204,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab","Configuring Accessories Window in a Virtual Station"],"content":" In the diagnostics mode all signals passed to and from the controller internal logic can be monitored. A signal tap is connected in the diagnostics module and the signal states are displayed on the web GUI or the controller GUI.        A  Controller internal state machine and logic functions   B  Digital output signal path   C  Digital input signal path   D  Diagnostics module   E  User interface   F  Output signal tap   G  Input signal tap  "},{"id":"81636875","fileName":"81636875.html","title":"Force Digital Signals","level":4,"position":205,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab","Configuring Accessories Window in a Virtual Station"],"content":" In the diagnostics mode all signals passed to and from the controller internal logic can be forced to a desired state. The signal lines are opened in the diagnostics module. From the user interface both input and output signals can be forced to steady states. The user interface is either the web GUI or the controller GUI.  While signals are forced, the controller operates normally. When leaving the diagnostics mode and the forced mode all signals are set to the current operating state of the controller. This may lead to a change-of-state for digital outputs, which can create unwanted actions.        A  Controller internal state machine and logic functions   B  Digital output signal path   C  Digital input signal path   D  Diagnostics module   E  User interface   F  Forced output signal insertion point   G  Forced input signal insertion point  "},{"id":"81860747","fileName":"81860747.html","title":"Configuring Fieldbus Window in a Virtual Station","level":3,"position":206,"hasContent":true,"hierarchy":["Configuration","Working with the Virtual Station Tab"],"content":" The Fieldbusentry in the GUI shows the fieldbus mapping assigned to the controller. To analyze the fieldbus configuration click on perform in the diagnostics field for the fieldbus mapping. Read more about the diagnostics tool in the Virtual station - Accessories section of this chapter.  To configure Fieldbus mappings, ToolsTalk 2 is required.  Virtual station - Fieldbus  "},{"id":"13445548299","fileName":"1344554829923858485131.html","title":"Working with the Configurations Tab","level":2,"position":207,"hasContent":true,"hierarchy":["Configuration"],"content":" Product Essentials Tutorials  https:\/\/www.youtube.com\/watch?v=PY1WGo3YYIw "},{"id":"91118347","fileName":"9111834723858531467.html","title":"Tool Configuration","level":3,"position":208,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab"],"content":" In Configurations >Tool configurationmenu it is possible to configure the available accessory functions on the tool. Different functions are available depending on the tool type. Configuring Accessory Functions on the Tool    Select Filter by tool type. Then, select the necessary tool.  Select Editto configure the necessary functions.  A configuration assigned to a virtual station cannot be deleted.  If available, configure Tool LEDs, Function button, Buzzer and Direction switch by selecting the related box. Each box shows a number which corresponds to the number of the specific function (for example, 1 corresponds to Tool LEDs, 2 to Function button, 3 to Buzzer, and 4 to Direction switch).  If available, configure the General settings, Start condition, and Accessory bus according to the customer needs. General settings The general settings for the tool can be set in the General settings section.      Parameter  Description  Default value    Inactivity timeout  Determines if the tool turns the power off after a set period of inactivity, or not.  On   <Inactivity timeout>  If Inactivity timeout is set to On, it sets the number of minutes before the shutdown.  120 min   Front LED  Sets the behavior of the front LED (above tool trigger). Available only for wireless tools. When it is set to Off, the front LED does not lit when the trigger is pressed.  On   Duration after trigger released  Sets how long the front LED stays lit after the tool trigger is released (in seconds).  For cable tools, the front LED stays lit for 10 seconds after the tools trigger is pressed.  0 sec   Trace  Enables the graphical representation of the tightening.  For multistep programs, trace is always on from Trigger pressed.  For wireless tools, select Trigger pressedor Rundown completefor making the trace.  Off   TAG check  Enables TAG checking on the tool. The tool locks if the TAG supplied with the program is not equal to the one inserted into the STwrench smartHEAD.  TAG check is available only for STwrench or when no tool is selected when validating the tool configuration.  Off   TAG selection  It is used for selecting a Tightening Program\/Batch or Batch Sequence by using Batch Sequence\/Source Tightening\/Source Batch. The Tightening Program\/Batch or Batch Sequence has a TAG number configured that corresponds to the TAG number of the TAG inserted into the STwrench smartHEAD. On the STwrench display, the operator is informed about which Tightening Program\/Batch or Batch Sequence is selected for the TAG inserted into the STwrench smartHEAD.  TAG selection is available only for STwrench or when no tool is selected when validating the tool configuration.  Off "},{"id":"83892363","fileName":"83892363.html","title":"Configuration of the Tool LEDs","level":4,"position":209,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration"],"content":" The different LED indicators on the tool are configured to be controlled by one of the available output signals.  Blue LED The blue LED will be lit for a configurable duration of time, or configured to be lit until the following tightening. It is lit on the signal chosen by the configuration. Result indicator The result indicator decides how and for how long the LEDs are lit on tightening results. A pre-configured pattern is selected from a shortcut menu. This pattern can be a combination of tightening results.  Result indicator signals     Signal  Description    Off  No LEDs are activated after the tightening, regardless of the result   Green  If a result indicator is selected, a green light is the default signal if the tightening is terminated correctly (OK).   Red:high:yellow:low  If the tightening is terminated incorrectly (NOK); a red LED indicates that the final value is too high, or a yellow LED indicates that the value is too low. Red and yellow can be lit simultaneously (e.g. in case of too high torque, and too low angle).   Red:high(prio):yellow:low  If the tightening is terminated incorrectly (NOK); a red LED indicates that the final value is too high, or a yellow LED indicates that the value is too low. Red and yellow cannot be lit simultaneously. Only red is lit in case of simultaneous high and low values.   Red:NOK:yellow:low  A red LED indicates that the tightening is terminated incorrectly (NOK). An additional yellow LED can indicate if the value is too low.   Red:NOK  A red LED indicates that the tightening is terminated incorrectly (NOK). No additional LEDs are shown. LED ring The LED ring decides how the LEDs behave between the tightenings. The LED ring consists of three circles of LED lamps. One circle of red LEDs, one circle of yellow LEDs and one circle of green LEDs. Each circle can have a steady signal or a flashing signal. This provides a total of six different signals that can be connected to the LED ring.   A LED is turned on only when no tightening is ongoing and when the controlling output signal is activated.  A LED is turned off when the maximum time is exceeded. Only applicable if the signal type is an Event.  A LED is turned off when the next tightening is started.  A LED is turned off when the controlling output signal is deactivated. Only applicable if the signal type is an State.  "},{"id":"83837067","fileName":"83837067.html","title":"Configuration of the Function Button","level":4,"position":210,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration"],"content":" Use the function button on the tool to control up to six of the available input signals. The button’s three possible condition states are combined with the two possible states of the direction switch.      Function button states  Direction switch states    Single push  CW   Single push  CCW   Double push  CW   Double push  CCW   Pressed  CW   Pressed  CCW Two configurable parameters controls the push time.      Parameter  Description  Default value    Push detection interval  For single push: the maximum push time (in milliseconds) between the button being pressed and the button being released.  300 ms   Next push interval  For double push: the maximum time (in milliseconds) between the button being released after the first push, and the buttong being pressed again.  300 ms"},{"id":"83855371","fileName":"83855371.html","title":"Configuration of the Buzzer","level":4,"position":211,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration"],"content":" The buzzer is configured by assigning a sound to a signal selected from a list of available signals. The sound consists of a set of parameters described in the table. A signal with a sound can be prioritized between 1 and 10 where 1 is highest priority and 10 the lowest. By default a signal and sound has the priority 5. Up to 20 sounds can be assigned to signals.       Parameter  Description    Frequency  Exact frequency in Hz.   Time on  Time (in ms) that the buzzer makes a sound.   Time off  Time (in ms) that the buzzer is quiet.   Repetition  Number of times the buzzer repeats the on\/off sequence.   Volume  The buzzer volume, in percentage of max volume.  "},{"id":"83874059","fileName":"83874059.html","title":"Configuration of the Direction Switch","level":4,"position":212,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration"],"content":" The direction switch on the tool can be configured to trigger certain input signals when switched quickly (with a duration of 500 ms) from clockwise (CW) to counter clockwise (CCW) and back, or vice versa. Systems in Remote start When the system uses remote start and the user wants to trigger a signal assigned to a direction switch in Tool configuration, one needs to assign the respective signal and use the signal10029 - Select Looseningwith a required duration of 500 ms to trigger it. For this to work, an extra configuration step in ToolsTalk is needed. Under Hardware configurationin ToolsTalk, a configuration must be set for the tool by clicking on the tool icon. "},{"id":"1806338059","fileName":"180633805923858544267.html","title":"Configuration of the Start Condition","level":4,"position":213,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration"],"content":" The start conditions for a tool, such as start request, start source, trace, and TAG conditions for STwrench are configured here. The functions are described in the respective sections.   "},{"id":"67845771","fileName":"67845771.html","title":"Start Request","level":5,"position":214,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration","Configuration of the Start Condition"],"content":" Start request enables the requirement of having a persistent connection between the tool and controller for an STB tool. This to make sure that the tool is always up to date with tightening program or batch settings, and with other settings on the controller, when performing tightening. When Start request is set to On the tool gets locked if the tool loose connection with the controller. This means that if the tool loses connection in the middle of a tightening or a batch sequence, the tool will finish the ongoing tightening and then stop. The tool will be locked until it has reestablished the connection.  Parameters available for the start request     Parameter  Description  Default value    Start request  Lock the tool when the tool loose connection with the controller.  On: The tool is locked from performing tightening if it loose connection with the controller..  Off: The tool can continue to perform tightening although it has lost connection with the controller.  On"},{"id":"59712779","fileName":"59712779.html","title":"Start Source","level":5,"position":215,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration","Configuration of the Start Condition"],"content":" Use the tool start source to set how to start the tool. The default value is Trigger only.   Start Sourceis available only for certain tool types.  Options for start source     Start source  Description    Trigger only  Press the tool trigger to start the tightening.   Trigger OR Push  Press the tool trigger or push the tool against the joint to start the tightening.   Trigger AND Push  Press the tool trigger and push the tool against the joint to start the tightening.   Push only  Push the tool against the joint to start the tightening.   Digital input  Have a signal using digital input to trigger the start of the tightening.   Safety trigger  Two triggers (as with trigger and push) activated within 500 ms from each other to start the tightening."},{"id":"72154251","fileName":"72154251.html","title":"Trace Configuration","level":5,"position":216,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration","Configuration of the Start Condition"],"content":" Traces provide users with a graphical representation of the tightening. Traces can begin either from when the trigger is pressed or from after rundown complete.      Parameter  Description  Default value    Trace  Enables the result to be viewed in graphic form.  Off: No trace is made.  Trigger pressed: The trace is drawn from when the tool trigger is pressed.  Rundown complete: The trace is drawn from when Rundown completeis reached.  Off The maximum number of trace points is 2000 (200 for STB tools). If the maximum number of trace points is exceeded, every other result will be erased (effectively halving the sampling rate). Tracing will continue as long as the tightening is active, and every time the maximum number of trace points is reached, half of the trace points will be erased to allow the tracing to continue. Tracing will stop when the final stage of the tightening has finished."},{"id":"1820888075","fileName":"1820888075.html","title":"TAG Check","level":5,"position":217,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration","Configuration of the Start Condition"],"content":"  TAG checkfeature enables TAG checking on the tool. When the TAG check is enabled both on the Power Focus 6000 and the STwrench, the tool locks if the TAG supplied with the program is not equal to the one inserted into the STwrench smartHEAD. The TAG number is specified differently, depending on the work task. In case of Generic Tightening Strategies, the TAG number is specified in the Tightening Program. In case of Multistep Tightening Strategy, the TAG number depends on what has been selected in Sources\/Batch Sequencemenu.   If running Source Tightening( Sources > Tightening > Source Tightening > Selector mode - Confirm), the TAG number is specified in the Socketbox.  If running Batch Sequence( Batch sequence > Sequence library > Sequence > Batch configuration - Edit), the TAG number is the Identifier Number.  If running Source Batch( Sources > Batch sequence > Source Batch), the TAG number is specified in the Batch Sequenceas per above section.  In case of Batch Sequenceand Source Batch, set Free order- in the Batch Sequence- to No.  TAG check is available only for STwrench.      TAG check options  Description    Off  The tool does not lock, regardless of the inserted TAG.   On  The tool is locked as long as the TAG number is not equal to the TAG number specified in the tightening strategy configuration."},{"id":"1820889995","fileName":"1820889995.html","title":"TAG Selection","level":5,"position":218,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration","Configuration of the Start Condition"],"content":"  TAG selectionfeature is used for selecting a Tightening Program\/Batch or Batch Sequence that has a TAG number configured that corresponds to the TAG number of the TAG inserted into the STwrench smartHEAD.  TAG selection is available only for STwrench.      TAG selection options  Description    Off  The STwrench does not signal the controller to select Tightening Program\/Batch or Batch Sequence.   On  Select the Tightening Program\/Batch or Batch Sequence according to the TAG number configured in the Batch Sequence\/Source Tightening\/Source Batch."},{"id":"2687060107","fileName":"268706010723858537867.html","title":"Configuration of the Accessory Bus","level":4,"position":219,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration"],"content":" Tool accessories are connected to the tool through the accessory bus. The tool accessories are configured separately for each tool configuration on the controller.  Accessory bus configurations     Type  Description     ST selector  A small display and buttons used to select tasks or programs according to the configuration.    TLS tag  Tool Location System tag used to provide output signaling to the operator.    EHMI  A small display and buttons used to select tasks or programs according to the configuration. "},{"id":"2689781643","fileName":"2689781643.html","title":"ST Selector","level":5,"position":220,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration","Configuration of the Accessory Bus"],"content":" The ST selectoris a tool accessory. It is installed on the tool and connected to the tool accessory bus. It has a small display, two input buttons and output LEDs. Display The display shows one information at a time and has four different pages that can be configured to display different preset items on every page.      Parameter  Description     Page 1  Select the message to be displayed from the list:   Batch count  Current running batch  Final angle  Final torque  Generic IO 1  Generic IO 2  Generic IO 3  Generic IO 4  Generic IO 5  Generic IO 6  Generic IO 7  Generic IO 8  Generic IO 9  Generic IO 10  Remaining batch  Selected sequence id  Selected tightening program  Size of sequence  Target\/Final torque  Target torque  Total remaining sequence counter  Total sequence counter  Total sequence size    Page 2    Page 3    page 4 Switch time      Parameter  Description     Switch time  Select the time to display one message before the next message is displayed. Buttons The two buttons can be configured to act upon the displayed information and used to step through listed items.      Parameter  Description     Left button  Select one action from the shortcut menu.    Right button  Select one action from the shortcut menu. Status LEDs The status LEDs can be activated or deactivated.      Parameter  Description     Show result LED  Select the desired On or Off radio button.    Show extra LED  Select the desired On or Off radio button. The result LED are red, green and yellow, and show the same information as the main tool LED. The two extra LED can show Batch OKand Batch sequence OK. Both these LED are turned off at the next tightening."},{"id":"2689783563","fileName":"2689783563.html","title":"TLS Tag","level":5,"position":221,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration","Configuration of the Accessory Bus"],"content":" The Tool Location System (TLS)tag, is a tool accessory. The TLS tag is installed on the tool and connected to the tool accessory bus. The TLS tag is part of the Ubisense positioning system and is handled independently from the controller. In addition to the positioning, the TLS tag can be used to provide information to the operator. Selected output signals can generate different LED light combinations. Up to 10 different output signals can be mapped to a light priority.  TLS tag configuration parameters     Parameter  Description     Signal  Select a signal to trigger the LED light from a shortcut menu. For a signal of the type Event, select the duration of the signal.    Color  Select a color for the LED.    Priority  10 priority levels are available for the sounds where one (1) is the highest priority level. Default priority level is five (5). For two simultaneous signals, the signal with the highest priority wins. When two signals with the same priority triggers the LED, the first arriving signal wins.  An output signal can be of type Eventor of type State. A state signal is active as long as the state is active. An event signal is active during a configurable time."},{"id":"2694111883","fileName":"2694111883.html","title":"EHMI","level":5,"position":222,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration","Configuration of the Accessory Bus"],"content":" The EHMIis a tool accessory. It is installed on the tool and connected to the tool accessory bus. It has a graphical display, three function buttons, and optionally a scanner. The display is a subset of the controller GUI with the possibility to select tightening programs, batch sequences, and to view results from tightenings. The interaction with the controller is through function buttons. In the EHMI configuration it is possible to decide if the function buttons are On or Off.  EHMI buttons     Parameter  Description     Enable function buttons  On = The buttons have full functionality to configure settings within the visible menus. Off = The function buttons can only be used to acknowledge a necessary dialog on the EHMI."},{"id":"22800255627","fileName":"22800255627.html","title":"Configuration of the Dual Transducers","level":4,"position":223,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration"],"content":"  Available for FlexSystem and StepSync.      Dual transducer  Description     Required dual torque  If the connected tool must have dual torque transducers (that are not disabled) to be able to run a tightening.    Required dual angle  If the connected tool must have dual angle transducers (that are not disabled) to be able to run a tightening.    Secondary torque in trace  If the values from the secondary torque transducer is included in the trace.    Secondary angle in trace  If the values from the secondary angle transducer is included in the trace.    Enable double torque restriction  If the double torque transducer restriction is active.    Maximum torque difference  The limit for the double torque difference restriction.    Enable double angle restriction  If the double angle transducer restriction is active.    Maximum angle difference  The limit for the double angle difference restriction."},{"id":"20828780555","fileName":"20828780555.html","title":"Configuration of the Open End","level":4,"position":224,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Tool Configuration"],"content":"  Before using an open end tool, make sure that the tool head and tool body have been assembled and configured correctly. If not, the tool can run in the wrong direction and the mechanical stop in the open-end head may be damaged. After performing a tightening with an open end tool, it is possible to let the open end tool getting to the opening position again through the open end configuration. Configure the open end strategies and settings through the HMI (Human Machine Interface).  The open end configuration is applicable only to cable tools, IXB tools, and STB tools. The open end configuration is not applicable to Flexand to StepSync. Open End Configuration  Open End Settings     Settings  Description     Automatic Positioning  After performing a tightening with an open end tool, it is possible to let the open end tool getting to the opening position again automatically. A toggle key turns the Automatic Positioning Onor Off:    On: if enabled, after the tightening, when the open end tool is lifted up, the open end tool gets to the opening position again automatically. The operator must hold down the tool trigger during the full process (tightening + Automatic Positioning). If the operator releases the tool trigger before that the Automatic Positioningis completed, the open end tool will get back to the opening position through the selected Positioning Strategy.   Off: default value. If disabled, after the tightening, when the open end tool is lifted up, the open end tool does not get to the opening position again automatically. When the open end tool is lifted up, the operator must release the tool trigger. To let the open end tool getting to the opening position again, the operator must hold down the tool trigger again during the full Automatic Positioning.   Automatic Positioningis applicable only to Multistep tightening programs.   Automatic Positioningis applicable only to cable toolsand IXB tools.    Positioning Strategy  Select the Positioning Strategyto let the open end tool getting back to the opening position after the tightening.    Forward: default value. The open end tool turns forward - in the same direction of the tightening direction - to the opening position.   Reverse: the open end tool turns reverse - in the opposite direction of the tightening direction - to the opening position.   Reverse Torque Based: the open end tool gets to the opening position through a slow reverse rotation that is done by reversing slowly and monitoring the torque.   Forward Fast Start: the open end tool gets to the opening position as quick as possible.  We recommend to use Reverse Torque Basedand Forward Fast Startstrategies for open end tools with swiveling front part.   Reverse Torque Basedand Forward Fast Startstrategies are applicable only to cable toolsand IXB tools. If the Positioning Strategyof the STB toolsis Reverse Torque Basedor Forward Fast Start, the default Positioning Strategywould run automatically. For Reverse Torque Based, the default Positioning Strategyis Reverse. For Forward Fast Start, the default Positioning Strategyis Forward.    Positioning Speed   Positioning Speeddefines how quickly the tool should get to the opening position.  Positioning Speedis expressed as the percentage (%) of the open end tool maximum speed. The operator can enter a Positioning Speedvalue which ranges from 5% through 100%. By default, the Positioning Speedis set to 38%."},{"id":"91116299","fileName":"9111629923858491531.html","title":"Digital Signals","level":3,"position":225,"hasContent":false,"hierarchy":["Configuration","Working with the Configurations Tab"],"content":""},{"id":"83800459","fileName":"83800459.html","title":"Input Signals","level":4,"position":226,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Digital Signals"],"content":" Input signals are system commands that are carried out by using for example buttons or switches on an accessory, either a tool accessory or a QIF accessory, or by connecting the signal to an I\/O input plug.  The input signal Lock tool must not be configured for more than one accessory for each virtual station. "},{"id":"83818763","fileName":"83818763.html","title":"Output Signals","level":4,"position":227,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Digital Signals"],"content":" Output signals are states or events of the system. They can be linked to either a tool accessory or a QIF accessory. "},{"id":"4502205067","fileName":"4502205067.html","title":"Triggering Manual Mode","level":3,"position":228,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab"],"content":" Manual mode can be activated by a switch or an external system. For example (indicated below), a button on an operator panel can be configured to activate manual mode.    Go to the Configurationsmenu and choose Operator panelin the left navigation.  If no configuration for an operator panel exists, click the plusicon at the top right of the work space, otherwise continue to the next step.  In the configuration you want to alter, click Edit.  In the Operator panel configuration window, click on the position [A,B,C,D,E,F,G,I] to configure.  In the Position configuration window, click on the Component list. In the list, click One way key switch.  Click on the Turn signal list. In the list, choose Manual mode (use the arrow buttons to navigate within the list if necessary).  Close the Position configuration window.  If the user needs to be notified that Manual mode has been entered or left, then events 4070 and 4071 have to be configured, respectively. "},{"id":"59361931","fileName":"5936193123858497931.html","title":"Selector Configuration","level":3,"position":229,"hasContent":false,"hierarchy":["Configuration","Working with the Configurations Tab"],"content":""},{"id":"59364235","fileName":"59364235.html","title":"Digital Input Information","level":4,"position":230,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Selector Configuration"],"content":" Information about the connected digital inputs can be found by tapping Tighteningand then Digital inputson the Sourcesmenu."},{"id":"59367307","fileName":"5936730723858504843.html","title":"Socket Selector Configuration","level":4,"position":231,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Selector Configuration"],"content":" Socket selector is a socket tray with LEDs that can be used to guide the user through, for example, a Batch sequence. When using more than one tightening program, it is convenient to use a selector. When a socket is lifted, the corresponding tightening program is selected. Several socket selectors can be connected to each virtual station. Information about the connected socket selectors can be found by tapping Tighteningand then Socket selectoron the Sourcesmenu. "},{"id":"59370379","fileName":"59370379.html","title":"Configuring the Socket Selector","level":5,"position":232,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Selector Configuration","Socket Selector Configuration"],"content":"    Go to Configurations, then Socket selectorand click on the plus at the top right to create a new configuration  Give the configuration a name  Click on Edit  Click Addor Removefor the correct number of socket slots, then select all the slots that need to be active (indicated in blue)"},{"id":"59373451","fileName":"59373451.html","title":"Connecting a Socket Selector to a Virtual Station","level":5,"position":233,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Selector Configuration","Socket Selector Configuration"],"content":"    On the Virtual stationmenu, go to the virtual station to use and then go to Accessories and tap Choose accessories.  Under Accessories, click Choose accessories, then navigate to the Socket selector tab.  In the Configurationcolumn (left), select a configuration you want to use with the socket selector (seeConfiguring the Socket Selector)  In the Connected accessoriescolumn (right), select the socket selector you want to use. "},{"id":"4458638859","fileName":"4458638859.html","title":"Setting up a Socket Selector via I\/o Bus","level":4,"position":234,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Selector Configuration"],"content":"    Connect the socket selector to the controller's I\/O bus.  Under Virtual station > Accessories > Choose accessories > Socket selector, check that the selector shows up in the Connected accessoriescolumn (right)"},{"id":"4458748555","fileName":"4458748555.html","title":"Setting up a Selector 6 via Ethernet Cable\/Wireless","level":4,"position":235,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Selector Configuration"],"content":"  Selector 6 main overview  Selector front view      A  Holder for socket or bit   B  Indicator LEDs for the position   C  Sticker area   D  Mounting holes in each corner   E  Service port   F  Battery status LED (only available on wireless versions)   G  WLAN status LED (available on some selectors)   H  Battery (only available on wireless versions)   I  Mobility module (only available on wireless versions)  Selector 6 connection overview  Selector bottom view      A  Connector cover   B  External DC power in; Kycon (DC DIN) connector   C  Ethernet in, upstream connection; M12 D-coded female connector   D  Selector back side   E  Digital input and output connector   F  Ethernet out, downstream connection; M12 D-coded female connector   G  Battery  Selector 6 service port overview  Service interface      A  RJ45 Service port   B  RBU slot   C  Function button    On the controller, go to Settings > Networkand under Factory Ethernetport, check the IP address (only required when setting up via wireless connection).  Open the service port cover on the selector. The cover is secured by a 2 mm allen screw.  Connect an ethernet cable between a PC and the RJ-45 connector in the service interface.  Make sure the selector powered, either by PoE, by external power supply or by battery.  Open a web browser window in the PC.  Type the web address 169.251.1.1 and press the Enterkey. The web server in the selector will respond and show the selector web interface.  Select Settingsin the left navigation (this is selected by default). The Settingsworkspace shows the configuration menus and is divided into five different settings: Basic settings, Service port, Ethernet in, WLAN, and the POWER FOCUS 6000.  In the Ethernet insection, select External modeOn or Off for the desired LED control source.  The next steps in the set-up depend on how the socket selector will be connected to the controller (Ethernet cable directly to the controller (default), Ethernet cable to factory network, or wireless to factory network). See the instructions below for your set-up.     Ethernet ports (RJ45) for connecting devices and daisy-chaining controllers are only available in newer PF6 models. In order to connect Selector 6 via Ethernet cable to older controller models, an adapter cable should be used to connect the Ethernet cable to the controllers COM PORT.  In the Ethernet Insection, select PF6000(default) in the Connected to drop-down.  Click the Savebutton in top right of the workspace.  Remove the ethernet cable from the service port.  Close the service port with the lid and secure it with the allen screw.  The socket selector shows up in the Connected accessories list ( Virtual station > Accessories > Choose accessories > Socket selector)    In the Ethernet Insection, select Factory netfrom the Connected to drop-down  Select DHCP On or Off for dynamic or static IP address configuration. If a static IP address is required, in the IP address field, enter the IP address for the socket selector.  In the PF6000section, enter the controller IP address (see above) for the controller the selector will be connected to.  Click the Savebutton in top right of the workspace.  Remove the ethernet cable from the service port.  Close the service port with the lid and secure it with the allen screw.  The socket selector shows up in the Connected accessories list ( Virtual station > Accessories > Choose accessories > Socket selector)    In the Ethernet Insection, select Factory netfrom the Connected to drop-down   In the WLAN section, fill out the following parameters:  Enable: set radio button to YES  SSID: fill out the SSID name for the socket selector  Password: fill out the password for the wireless network to be connected to  Encryption type: choose the correct encryption type for the wireless network (WPA-PSK, or WPA2-PSK, EAP-TLS)  In the PF6000section, enter the controller IP address (see above) for the controller the selector will be connected to.  Click the Savebutton in top right of the workspace.  Remove the ethernet cable from the service port.  Close the service port with the lid and secure it with the allen screw.  The socket selector shows up in the Connected accessories list ( Virtual station > Accessories > Choose accessories > Socket selector)     "},{"id":"4417661707","fileName":"441766170723858550667.html","title":"General Virtual Station","level":3,"position":236,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab"],"content":" In General Virtual Station, different specific result reporting and tightening settings can be saved. Different filters can be created, filtering out specific results. In the tightening settings, characteristics like the tool unlocking behavior can be set. These configurations can then be assigned to virtual stations. Adding and editing a configuration    In the Configurations menu, click on the General Virtual Station tab, and click on the plus signin the top right corner.  Give the new configuration a name and click on Edit.  In the Result filter for reporting window, set the switch to Onfor those parameters you want to include in the results. By default, all parameters are set to On.  Turning on a result filter prevents the respective result from being sent, but the result is still shown on the controller.  The following parameters can be set in the Result filter for reportingsection:  Loosening  Batch increment  Batch decrement  Reset batch  Bypass Tightening Program  Abort sequence  Abort not started sequence  Reset batch sequence  In the Tightening Settings window, set a value for any of the parameters listed. By default, all parameters are set to Off.  The following parameters can be set in the Tightening Settingssection:  Unlock tool on loosening - makes sure that the tool is locked after a NOK tightening.  Disable loosening - makes sure that an operator is not loosening a bolt that their processes do not allow to be loosened.  Disable tightening - makes sure that an operator is not tightening a bolt that their processes do not allow to be tightened.  Unlock tool on loosening options     Unlock tool on loosening  Description    Off  A disabled tool will remain disabled regardless of the loosening status.   On OK  A disabled tool will be unlocked after an OK loosening has been performed.   Always  A disabled tool will be unlocked as soon as a loosening has been performed, regardless of the loosening status.  Disable loosening options     Disable loosening  Description    Off  Disable loosening is Off. It is always possible to loosen a bolt.   On OK tightening  Disable loosening for an OK tightening. An operator cannot loosen a bolt that was terminated with tightening OK.   On NOK tightening  Disable loosening for an NOK tightening. An operator cannot loosen a bolt that was terminated with tightening NOK.   Always  Disable loosening is always ON. An operator can never loosen a bolt.  Disable tightening options     Disable tightening  Description    Off  Disable tightening is Off. An operator can always tighten a bolt.   On OK tightening  Disable tightening after an OK tightening, An operator cannot tighten another bolt if the current tightening was terminated with OK.   On NOK tightening  Disable tightening after a NOK tightening. An operator cannot tighten another bolt if the current tightening was terminated with NOK.   After every tightening  Disable tightening is activated after every tightening. An operator cannot tighten another bolt until the current tightening is terminated. Allowing a disabled tool to unlock after loosening   In the general virtual station configuration assigned to the virtual station to which the tool is connected, set the Unlock tool on looseningto On OKor Always.  In order to enable the setting above, the following conditions need to be met:   The Disable looseningparameter cannot be set to Offor Always.  The Disable looseningparameter cannot be set to the same value as the Disable tightening.  The tightening program used must have loosening enabled. When the tool is locked for either tightening or loosening due to a disable state, it can be unlocked by any of the following input signals:   Master Unlock - 10005  Unlock Tool on Disable - 10059  Unlocking a disabled tool through the input signals specified is not possible if Lock tool on looseningis set to Always. Assigning a configuration to a virtual station Each virtual station can have its own configuration associated with it, or multiple virtual stations can share the same configuration. For a configuration to come into effect it needs to be assigned to a virtual station.    Go to the Virtual Station menu and select the Virtual Station you want to assign the configuration to.  Under General, the first General Virtual Station configuration will be chosen by default. Click on the configuration name.  In the pop-up window, select the desired configuration from the list. The pop-up window will be closed upon selection. "},{"id":"18236986251","fileName":"1823698625123858557067.html","title":"Configuring Result Presentation Settings","level":4,"position":237,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","General Virtual Station"],"content":" The Result Presentation Settingswindow allows a user to show the final torque without the PrT compensation value included, and PrT compensation value on the Live results. Configure the Result Presentation Settings Window    On the Homeview, select the Configurationstab. Then, on the left, select General Virtual Station.  In the wanted Configurationwindow, select Edit. The Edit Configurationscreen appears.  In the Result Presentation Settingswindow, set the relevant switches to ONor OFFdepending on the wanted results. If the Show PrT Compensation Value on Live Resultswitch is set to ON, the Live Resultswindow displays the PrT compensationvalue. If the Show Final Torque with PrT Compensationswitch is set to ON, the Live Resultswindow displays the final torque with the PrT compensationincluded.  Setting the switches in the Results Presentations Settingswindow to either ONor OFFhas no impact unless:   The multistep program has a tightening step including a Prevailing Torquestep monitor with the Compensationswitch set to ON. Result Presentation Settings Here are the different configuration options in the Results Presentations Settingswindow.      Show PrT Compensation Value on Live Result: ON Show Final Torque with PrT Compensation: ON  Show PrT Compensation Value on Live Result: ON Show Final Torque with PrT Compensation: OFF  Show PrT Compensation Value on Live Result: OFF Show Final Torque with PrT Compensation: ON  Show PrT Compensation Value on Live Result: OFF Show Final Torque with PrT Compensation: OFF                   "},{"id":"18287356043","fileName":"18287356043.html","title":"Show Final Torque with PrT Compensation: ON \/ Show PrT Compensation Value on Live Result: ON","level":5,"position":238,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","General Virtual Station","Configuring Result Presentation Settings"],"content":" Show Final Torque with PrT Compensation: ON The Live Result window shows the Final Torque with the PrT compensation value included. If the eHMI and ST Selector are on and configured, they show the Final Torque with the PrT compensation value included. Show PrT Compensation Value on Live Result: ON The Live Result window shows the PrT compensation value with the related compensation icon (). If there are several compensation values, the compensation value applied to the latest available step appears.   Configuring the Show Final Torque with PrT Compensationand Show PrT Compensation Value on Live Resultswitches does not impact:   The final torque values sent to ToolsNet and ToolsTalk: the final torque values with PrT compensation are always sent to ToolsNet and ToolsTalk.  The final torque value displayed with the historical results.  The traces based on live and historical results.  The values in Open Protocol messages.  The signals.  The protocol adapters.  "},{"id":"18287365003","fileName":"18287365003.html","title":"Show Final Torque with PrT Compensation: OFF \/ Show PrT Compensation Value on Live Result: ON","level":5,"position":239,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","General Virtual Station","Configuring Result Presentation Settings"],"content":" Show Final Torque with PrT Compensation: OFF The Live Result window shows the Final Torque without the PrT compensation value included. Since the Final Torque does not include the PrT compensation value, it shows in italic. Show PrT Compensation Value on Live Result: ON The Live Result window shows the PrT compensation value with the related compensation icon (). If there are several compensation values, the compensation value applied to the latest available step appears.   Configuring the Show Final Torque with PrT Compensationand Show PrT Compensation Value on Live Resultswitches does not impact:   The final torque values sent to ToolsNet and ToolsTalk: the final torque values with PrT compensation are always sent to ToolsNet and ToolsTalk.  The final torque value displayed with the historical results.  The traces based on live and historical results.  The values in Open Protocol messages.  The signals.  The protocol adapters.  "},{"id":"18287957899","fileName":"18287957899.html","title":"Show Final Torque with PrT Compensation: OFF \/ Show PrT Compensation Value on Live Result: OFF","level":5,"position":240,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","General Virtual Station","Configuring Result Presentation Settings"],"content":" Show Final Torque with PrT Compensation: OFF The Live Result window shows the Final Torque without the PrT compensation value included. Since the Final Torque does not include the PrT compensation value, it shows in italic. Show PrT Compensation Value on Live Result: OFF The Live Result window does not display the PrT compensation value and the related compensation icon ().   Configuring the Show Final Torque with PrT Compensationand Show PrT Compensation Value on Live Resultswitches does not impact:   The final torque values sent to ToolsNet and ToolsTalk: the final torque values with PrT compensation are always sent to ToolsNet and ToolsTalk.  The final torque value displayed with the historical results.  The traces based on live and historical results.  The values in Open Protocol messages.  The signals.  The protocol adapters.  "},{"id":"18287961995","fileName":"18287961995.html","title":"Show Final Torque with PrT Compensation: ON \/ Show PrT Compensation Value on Live Result: OFF","level":5,"position":241,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","General Virtual Station","Configuring Result Presentation Settings"],"content":" Show Final Torque with PrT Compensation: ON The Live Result window shows the Final Torque with the PrT compensation value included. If the eHMI and ST Selector are on and configured, they show the Final Torque with the PrT compensation value included. Show PrT Compensation Value on Live Result: OFF The Live Result window does not display the PrT compensation value and the related compensation icon ().   Configuring the Show Final Torque with PrT Compensationand Show PrT Compensation Value on Live Resultswitches does not impact:   The final torque values sent to ToolsNet and ToolsTalk: the final torque values with PrT compensation are always sent to ToolsNet and ToolsTalk.  The final torque value displayed with the historical results.  The traces based on live and historical results.  The values in Open Protocol messages.  The signals.  The protocol adapters.  "},{"id":"91120907","fileName":"9112090723858511243.html","title":"Configuring QIF Accessories","level":3,"position":242,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab"],"content":" A total of 15 QIF accessories can be connected to one controller. It is possible to add several scanners to each controller. All QIF accessories connected to the controller can be connected to the same virtual station. One of each type of accessory and multiple socket selectors. The functions of the QIF accessory can be connected to various input and output signals. "},{"id":"71637771","fileName":"71637771.html","title":"Connecting QIF Accessories to a Virtual Station","level":4,"position":243,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Configuring QIF Accessories"],"content":" To connect a QIF accessory to a virtual station:    Configure the accessory in the Configurationsmenu.  Connect the accessory to the controller I\/O bus.  In the Virtual stationmenu, choose the virtual station and then tap Choose accessoriesunder Accessories.  On the appropriate accessory tab, tap both the accessory and the configuration to connect them.   Connected accessories show up in All connections.   "},{"id":"67209867","fileName":"67209867.html","title":"Disconnecting QIF Accessories From a Virtual Station","level":4,"position":244,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Configuring QIF Accessories"],"content":"    On the Virtual stationmenu, choose the virtual station and then tap Choose accessoriesunder Accessories.  Under All connections, tap the disconnect icon on the right to disconnect.   "},{"id":"8402547851","fileName":"840254785123858518155.html","title":"Configuration of the Scanner","level":3,"position":245,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab"],"content":" In this menu, scanner configurations can be added. Scanners can be configured to either have scanned strings handled by the controller, or passed through to a an external system. When the scanned string is passed through, the controller does not select a task based on the string, but instead passes the string to an external device via an output signal. Adding a scanner and enabling pass through    Go to Configurations > Scanner, and select the Plus sign at the top right.  Give the scanner configuration a name.  To enable pass through, select Edit, and set Pass Through Modeto On. "},{"id":"59271435","fileName":"5927143523858524555.html","title":"Scanner Configuration","level":4,"position":246,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Configuration of the Scanner"],"content":" A scanner is used to read a barcode string or a QR code containing information to choose the appropriate batch sequence.  The scanner is configured in the Sourcestab. The scanner reads the characters you specify and puts them together to form a string of text. This text string is matched to the pre-defined strings you have specified in the controller, and if they match, the batch sequence linked to your pre-defined string is selected. Barcode strings of a length of up to 1024 characters can be read and they can contain characters in the positions 32-126 in the ASCII table. If the barcode contains a string longer than 1024 characters, the remaining part of the string, from position 1025 and forward, is discarded. "},{"id":"59280907","fileName":"59280907.html","title":"Configuring the Scanner","level":5,"position":247,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Configuration of the Scanner","Scanner Configuration"],"content":" The scanner itself must be set up using a US keyboard, and the scanner will emit a carriage return character to terminate the barcode string."},{"id":"59283979","fileName":"59283979.html","title":"Valid Scanners","level":5,"position":248,"hasContent":true,"hierarchy":["Configuration","Working with the Configurations Tab","Configuration of the Scanner","Scanner Configuration"],"content":" For a list of scanners verified for use with the POWER FOCUS 6000controller, contact your local Atlas Copco sales representative."},{"id":"91178763","fileName":"9117876323858665099.html","title":"Working with the Controller Tab","level":2,"position":249,"hasContent":true,"hierarchy":["Configuration"],"content":" The system administration tasks for the POWER FOCUS 6000controller are handled in the Controllermenu. The menu is accessed through the controller GUI, the web GUI, or the Tools Talk 2 GUI. "},{"id":"2957570059","fileName":"2957570059.html","title":"Intelligent Application Module","level":3,"position":250,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab"],"content":" The Intelligent Application module (IAM)is a non volatile storage that is located in the controller. The storage module contains all the controller programs, configurations and results. Certain modules may also include additional loaded feature items. For a complete list of available IAMs and their capabilities, please consult an Atlas Copco sales representative.  IAM information  "},{"id":"59564171","fileName":"5956417123858672011.html","title":"Software","level":3,"position":251,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab"],"content":" The version number of two versions of software available in the POWER FOCUS 6000controller are under the Software tab. Installing a second version of the controller software is useful when performing upgrades on multiple controllers. When production is ready for switching to the upgraded software, activation of the new software version is done locally on the controller GUI, from a remote computer with the web GUI, or with Tools Talk. A new software distribution can be installed either by connecting a USB flash drive containing the software to the controller’s USB port, or by using the web GUI.  The software update option is visible only when accessing the controller GUI from a PC. When a mass storage device with a valid software version is inserted in the USB port a prompt to update the software will appear. The software update file must not be unzipped and must be stored in a folder named PFImagesin the root directory on the USB flash drive.  An unexpected failure during software upgrade might lead to loss of data. Before upgrading software versions, it is recommended to take a backup of the controller configuration by exporting “All controller information”. "},{"id":"59567499","fileName":"59567499.html","title":"Updating Controller Software through USB","level":4,"position":252,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Software"],"content":"    Connect the USB flash drive to the controller: the installation wizard starts automatically.  If several software versions are available on the USB flash drive, a list with the different software upgrade files is displayed.  Select the software upgrade file to install and follow the instructions to finish the installation.  The USB flash drive needs to have a partition available and be formatted to work for Linux. Possible formats are for example FAT or NTFS.  Manually restart all Sync Member controllers after upgrading to a new software version or downgrading from a new software version.  "},{"id":"59570571","fileName":"59570571.html","title":"Updating Controller Software through Web GUI","level":4,"position":253,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Software"],"content":"    On the Controllermenu, go to Software, and select Software update. Then, click Browse.  Browse and choose the .zip file with the software and follow the instructions to complete the installation.  Manually restart all Sync Member controllers after upgrading to a new software version or downgrading from a new software version.  "},{"id":"62798987","fileName":"62798987.html","title":"Activating the Software on the Controller","level":4,"position":254,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Software"],"content":" The controller can store two installed software versions. By using the Software activation, it is possible to choose which software version to use. Software activation can be performed either locally from the controller GUI or remotely from the web GUI.  The activation process requires a restart of the controller.    On the Controllermenu, go to Software.  Swipe the Software activationswitch to stored and follow the instructions."},{"id":"3245009547","fileName":"324500954723858678411.html","title":"Hardware","level":3,"position":255,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab"],"content":" The Hardware tab contains Controller information, such as model designation and serial number, Health, Touch screen calibration, and information about the various electronics boards in the controller. "},{"id":"3245000971","fileName":"3245000971.html","title":"Health","level":4,"position":256,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Hardware"],"content":" The Health view contains information about battery status and controller temperature. Battery status  Controller > Hardware > Health The POWER FOCUS 6000battery, located inside the controller's front panel serves as backup power for some system elements, such as the internal clock. The status of the battery is updated once a day, as well as at controller restart. When the battery is close to being completely depleted, a warning (3011) will be displayed. The battery shall be replaced as soon as possible when the warning pops up. Controller temperature  Controller > Hardware > Health Controller temperature is monitored continuously by the POWER FOCUS 6000. Supported temperature units are degrees Celsius (°C) and degrees Fahrenheit (°F), with Celsius being the default unit. It is possible to switch between the two units without requiring a restart of the controller. When the controller temperature exceeds max temperature, the drive stage is disabled and an alert (3010) is shown. The drive stage is once again enabled when the controller temperature drops below the temperature limit. From the display or through the web GUI, users can access the latest controller temperature measured together with the timestamp when the measurement was taken."},{"id":"59445003","fileName":"5944500323858685323.html","title":"Export\/Import","level":3,"position":257,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab"],"content":" The Export\/ImportTab supports the user to make one of the following operations: Export, Import, and Automated backup. The Exportwindow supports the user to export controller configurations, settings, results, and events. In addition, it is possible to export tool logs, which can be shared with Atlas Copco Service personnel to troubleshoot problems with the tool(s). The Importwindow supports the user to import controller configurations and settings.  It is only possible to have one active Export or Import at the time. Any attempt to start a new Export\/Import while there is an ongoing Export\/Import is rejected. The Automated backupwindow supports the user to generate automatically a backup file. It is possible to export\/import data through one of the following devices:   USB flash drive (formatted and with a partition to work for Linux: possible formats are, for example, FAT or NTFS)  Web GUI  ToolsTalk 2 During the Export\/Import process a progress bar informs the user that an export\/import is ongoing. The time to perform an export\/import is depending on the numbers of results, events, and log files. Export\/Import Between Controllers Controllers may have different IAM types that could have different capabilities. A controller can export all the configurations that are applicable for the current type of IAM module.  A controller cannot import a file exported from a different type of IAM module. This is applicable also when using ToolsTalk 2. "},{"id":"16474632587","fileName":"16474632587.html","title":"Exporting \"All Controller Information\"","level":4,"position":258,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Export\/Import"],"content":" It is possible to export controller configuration, settings, results, and events for further processing. Part of the export is done both from the cable tool, as well as connected wireless tools. All data included in the export is stored in a file \"PFExport_<IAM name>_<datetime (lowest value displayed for time is seconds)>.tar.gz\", which includes the following files and directories:    \"PFExport_<datetime>_Results.csv\"– All available results The results are exported in a CSV formatted text file. The latest performed result is the first in the CSV file. It is possible to export the following result information for tightenings and loosenings:      Result Information  Power Focus 6000 - Tightening Programs  Power Focus 6000 - Multistep Programs  StepSync    Identity number  -  -  X   Type of tightening  X  X  X   Virtual Station name  X  X  X   VIN (Identifier String)  X  X  X   Selected identifier number  X  X  X   Date and Time  X  X  X   Unique tool identifier  X  X  -   Batch Sequence Name  X  X  -   Batch Sequence Counter  X  X  -   Batch Count  X  X  -   Bolt name  -  -  X   Total status  -  -  X   Total status info  -  -  X   Status  X  X  X   Status info  X  X  X   Mode Name  -  -  X   Tightening program\/Multistep Name  X  X  X   Stopping error  -  X  X   Errors  -  X  X   Failing Step  -  X  X   Channel  -  -  X   Target Torque (Nm)  X  X  -   Final Torque (Nm)  X  X  X   Target Angle (deg)  X  X  -   Start Final Angle (Nm)  X  X  X   Final Angle (deg)  X  X  X   Rundown Angle (deg)  X  -  -   Residual torque correlation factor  X  X  -   Elapsed time (s)  -  X  X   Angle low limit (deg)  X  X  X   Angle high limit (deg)  X  X  X   Torque low limit (Nm)  X  X  X   Torque high limit (Nm)  X  X  X   Number of pulses  X  -  -   Current at shutoff (A)  X  X  X   TrueAngle compensation (deg)  X  X  -   Time to rundown complete (ms)  X  -  -   Time to final torque (ms)  X  -  -   Target Text  X  X  -   Step Data  -  X  X   Selftap Torque  X  X  X   Prevailing Torque  X  X  X   Rundown Angle Trigger  X  X  X The field delimiter and number format depends on the language settings:      Language  Date\/time  Field delimiter  Number format    English (en_US)   MM\/dd\/yyyy hh:mm:ss   ,   123.456   Czech (cs)   dd.MM.yyyy hh:mm:ss   ;   123,456   German (de_DE)   dd.MM.yyyy hh:mm:ss   ;   123,456   Spanish (es_ES)   dd\/MM\/yyyy hh:mm:ss   ;   123,456   French (fr_FR)   dd\/MM\/yyyy hh:mm:ss   ;   123,456   Korean (ko_KR)   yyyy-MM-dd hh:mm:ss   ,   123.456   Italian (it_IT)   dd\/MM\/yyyy hh:mm:ss   ;   123,456   Japanese (ja_JP)   yyyy\/MM\/dd hh:mm:ss   ,   123.456   Portugese (pt_BR)   Dd\/MM\/yyyy hh:mm:ss   ;   123,456   Russian (ru_RU)   dd.MM.yyyy hh:mm:ss   ;   123,456   Swedish (sv_SE)   yyyy-MM-dd hh:mm:ss   ;   123,456   Chinese (zh_CN)   yyyy\/MM\/dd hh:mm:ss   ,   123.456  For PF6000-StepSync, all available results are in the file named “PFExport_<datetime>_Results.csv.zip”.    \"PFExport_<datetime>_Events.csv\"- All available events The following event information are exported in a CSV formatted text file:   Severity  Date  Time  Code  Description  Virtual Station that triggered the event (only exported for PF6000-Handheld)  Carrier (only exported for PF6000-StepSync)  Channel (only exported for PF6000-StepSync)   \"\/settings\"- Settings and configurations (used by Import)  For fieldbus exported settings and configurations:   General Fieldbus configuration (including IP address)  Fieldbus configuration  Fieldbus mapping (Virtual station mapping to ProcessDataFrame)    \"jsonConfigurations.zip\"- Multistep Tightening and Loosening programs are exported as .json files (to be used with MID2500)   \"atlas_sys_d.zip\"- Logfiles from Drive application   \"atlas_sys_i.zip\"- Logfiles from IT application   \"atlas_protocol_log.zip\"– Logfiles from external protocol adapters   “ExportInfo.txt”- Text document containing information about the IAM and Controller   \"atlas_plc.zip\"- PLC configuration   “licenseInformation.zip”– License Information and System Capabilities How to Export \"All Controller Information\"    On the Home view, select the ControllerTab. Then, on the left side, select the Export\/ImportTab .  In the Exportwindow, open the drop-down menu and select All controller information.  In the Exportwindow, select Export. At the end of the exporting process, an exporting pop-up window confirms that the export is done. A PF\/IXBExport_<IAM name>_<datetime>.tar.gzfile is automatically downloaded."},{"id":"16474634891","fileName":"16474634891.html","title":"Exporting \"Settings and Configurations\"","level":4,"position":259,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Export\/Import"],"content":" It is possible to export only controller configurations and settings. The exported data are stored in a compressed file identified with the IAM name and exported date and time. The data in the file include all configurations and settings of the controller, so that the export file can be imported and setup another controller with the same or newer release version. The exported data include information about the IAM and Controller, and also pre-formatted Multistep Tightening and Loosening programs to be used with the MID2500 solution. How to Export \"Settings and Configurations\"    On the Home view, select the ControllerTab. Then, on the left side, select the Export\/ImportTab .  In the Exportwindow, open the drop-down menu and select Settings and configurations.  In the Exportwindow, select Export. At the end of the exporting process, an exporting pop-up window confirms that the export is done. A PFExport_<IAM name>_<datetime>.tar.gzfile is automatically downloaded."},{"id":"16474637195","fileName":"16474637195.html","title":"Exporting \"Logs from Connected Tools\"","level":4,"position":260,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Export\/Import"],"content":" The export of tool logs enables a service technician to share the tool log data with Atlas Copco Service personnel to troubleshoot problems with the tool(s). It is possible to export tool logs from the following tools: STB, SRB, TBP\/TBP-S and QST-M. To export the tool logs, the tool has to be connected to the controller. It is not necessary for the tool to be assigned to a Virtual Station. All data included in the tool log export is stored in a file \"PFExport_<IAM name>_<datetime>.tar.gz\", which includes the following files and directories:    \"atlas_tool_i.zip\"– All available results For each connected tool an individual files is created. The file format for tool log files is \"tool-<tool type>-<tool serial number>.log\"   \"ExportInfo.txt\"- Text document containing information about the IAM, Controller and connected tools How to Export \"Logs from Connected Tools\"    On the Home view, select the ControllerTab. Then, on the left side, select the Export\/ImportTab .  In the Exportwindow, open the drop-down menu and select Logs from connected tools.  In the Exportwindow, select Export. At the end of the exporting process, an exporting pop-up window confirms that the export is done. A PFExport_<IAM name>_<datetime>.tar.gzfile is automatically downloaded."},{"id":"16474639499","fileName":"16474639499.html","title":"Exporting \"Results\"","level":4,"position":261,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Export\/Import"],"content":" It is possible to export only tightening results from the controller. How to Export \"Results\"    On the Home view, select the ControllerTab. Then, on the left side, select the Export\/ImportTab .  In the Exportwindow, open the drop-down menu and select Results.  In the Exportwindow, select Export. At the end of the exporting process, an exporting pop-up window confirms that the export is done. In case of a multi-spindle systems (fixtured), the exported file automatically downloaded is in a .zip format, otherwise it is in a .csv format."},{"id":"22007855499","fileName":"22007855499.html","title":"Exporting \"System Logs and Information\"","level":4,"position":262,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Export\/Import"],"content":" The export of system logs and information enables a service technician to share the logs of the system and its information with Atlas Copco Service technician. Troubleshooting problems with the system - such as controllers - is easier through the export of system logs and information.  The export of system logs and information does not include logs from the connected tool(s). If you need the export logs from the connected tool(s), select the necessary export method. All data included in the export of system logs and information are stored in a file PF\/IXBExport_<IAM name>_<datetime>.tar.gz, which includes the following files and directories:    atlas_sys_d.zip- Log files from Drive application   atlas_sys_i.zip- Log files from IT application   atlas_protocol_log.zip– Log files from external protocol adapters   ExportInfo.txt- Text document containing information about the IAM and controller   licenseInformation.zip– License information and system capabilities   atlas_systeminformation.zip– Information to Atlas Copco R&D for current system health and setup   atlas_workflow_log.zip– Log files for the workflow from external protocol adapters How to Export \"System Logs and Information\"    On the Home view, select the ControllerTab. Then, on the left side, select the Export\/ImportTab.  In the Exportwindow, open the drop-down menu and select System logs and information.  In the Exportwindow, select Export. At the end of the exporting process, an exporting pop-up window confirms that the export is done. A PF\/IXBExport_<IAM name>_<datetime>.tar.gzfile is automatically downloaded. "},{"id":"16491228811","fileName":"16491228811.html","title":"Importing Controller Configurations and Settings","level":4,"position":263,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Export\/Import"],"content":" When users import controller configuration and settings, existing configurations and settings are replaced by the imported controller configuration and settings. The following configurations are not imported or deselected:   Controller Network settings are not imported  Results and Events are not imported  License Assignment is not imported  Assigned task in Virtual Station\/s is deselected   \"jsonConfigurations.zip\"(Multistep Tightening and Loosening programs) is not imported   \"licenseInformation.zip\"(License Information and System Capabilities) is not imported How to Import Controller Configurations and Settings    On the Home view, select the ControllerTab. Then, on the left side, select the Export\/ImportTab .  In the Importwindow, select Import. An Informationpop-up window confirms that all setting for tightening program, batch, accessories, and controller will be replaced with the settings of the imported file. However, settings for network, PIN, results, and events will not be imported. Select Continue.  In the Importpop-up window, select Choose File. Then, select the file to be imported on the controller. At the end of the importing process, the controller will restart automatically.  If the importing process is interrupted before it has started, or the file disappears, the user is informed and the controller has to be restarted (to assure it is in a valid state). If the importing process is interrupted, but the file is not corrupt and exist, the import can be completed."},{"id":"16695644811","fileName":"16695644811.html","title":"Automated Backup","level":4,"position":264,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","Export\/Import"],"content":" The Automated Backupwindow enables or disables sFTP export. By default, Enable sFTP exportswitch is set to OFF. When turning ON Enable sFTP exportswitch, an export file is created 10 minutes after the last configuration change. If Enable sFTP exportswitch is set to ON on system startup, an export file is automatically created within 2-3 minutes. The export file is created within 2-3 minutes to reflect changes that might have been done before the system was shutdown.  The old Backup file is deleted before the new Backup file is available. The data in the exported file include all configurations and settings of the controller. The sFTP users can retrieve the exported file stored in the following directory of the system: \/Export\/<export file name>.  A system supporting sFTP is needed. To retrieve the file sFTP users do not need to use any password. The username for sFTP users is as follows:      Username   autoexport"},{"id":"9808349963","fileName":"980834996323858691723.html","title":"StepSync","level":3,"position":265,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab"],"content":"   Controller features, such as the Low Reaction Tightening Strategies and controller-wide functions among others, require licenses distributed through the Functionality Management System (FMS). Whereas configuration of features is possible without specific licenses, the assignment and use of those features will require the correct license to be installed on the controller. Please refer to Licenses (FMS) for more detailed information on licenses.   StepSync requires ToolsTalk 2 to configure. With the StepSync function it is possible to connect several Power Focus 6000 controllers together and run synchronized tightenings. The first controller in the configuration is called the Sync Reference and handles all the tightening and data reporting. Up to 5 additional Power Focus 6000 controllers are then connected to the Sync Reference via a Power Focus 6000 daisy-chain cable (see Setting up StepSync (hardware) and are called Sync Members, their only function is to handle the tools. Sync Reference The Sync Reference controller is the brain in the system. It handles the tightening settings and all data reporting. It also handles the configuration for the complete system and the connection to ToolsTalk and ToolsNet. All accessories or fieldbuses are connected directly to the Sync Reference. Sync Member The Sync Member controller works as a drive without extra functionality. The IT part is not running and it is not possible to connect any external accessories or protocols to a Sync Member. Each Sync Member has a channel number assigned to it (2-64). The channel number is used to identify the tool and drive within the Hardware Layout Configuration in ToolsTalk 2, as well as to select the ones that should be included in the tightening in Sync Mode, and also used for result reporting. It is also used for error events to make it possible to identify the faulty part. Tightenings It is only possible to run Multistep tightening programs. To be able to synchronize tightenings between each tool, synchronization points are used. At these points, the tools will wait for each other before continuing with the next step in the tightening program. A tightening program can contain up to 25 steps (not counting the synchronization points). No repair or termination paths are allowed. Note that the assignment of tightening programs can only take place through ToolsTalk 2. The controller does not provide possibilities to assign tightening programs. Licensing The StepSync function is an FMS feature. It is only the Sync Reference that requires a license, making it possible to change any Power Focus 6000 controller into a Sync Member without any additional licenses. The Sync Reference license is an add-on FMS controller feature.  If the Sync Reference license is removed, no tightenings can be performed in StepSync mode. If connection to the license server is lost, the license will continue to operate for 48 hours. The controller will check for a valid Sync Reference license every hour. "},{"id":"9808353803","fileName":"9808353803.html","title":"StepSync User Interface","level":4,"position":266,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync"],"content":" The StepSync user interface is a simplified version of the regular POWER FOCUS 6000interface. For detailed descriptions on the various interface elements, please refer to the dedicated chapters and sections in this manual describing those. Note that the user interface is only accessible on the Sync Reference. Not all functions in the various menu items are available in the StepSync interface. The following functions are accessible and editable in the interface:    Tool: all information available.   Virtual Station: all functions accessible, except creation of new Virtual Stations, assignment of Tasks (tightening program), and assignment of tool among others.   Configurations: all functions available.   StepSync (Controller): all functions available. Note that there is an extra section here called Channels where information on the tools connected to the Sync Reference and Sync Members is given.   Reports: Events (view all events).   Settings: the following functions are not available:   Tightening  Wireless  Events   Diagnostics: menu specific to StepSync\/Flex.   License assignment: all functions available."},{"id":"9850596747","fileName":"9850596747.html","title":"Configuring StepSync","level":4,"position":267,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync"],"content":"  The configuration of the Sync Reference and all Sync Members needs to be completed before performing the hardware set-up. Configuring the Sync Reference    Select the Controllermenu, then select the StepSynctab.  In the StepSync section, select No Sync  The Step Sync Modewindow appears.  Select Sync Reference  The Step Sync Modewindow closes.  Select Apply.  The controller will reboot and boot into the StepSync configuration, which is a simplified version of the regular Power Focus 6000 GUI. Enabling StepSync In order for StepSync to work, it has to be enabled on the Sync Reference. There are two ways to enable StepSync:   Set the I\/O signal Enable Operation (10055) to High, or  In the Sync reference, go to Configurations, then to the General Virtual Stationtab, and click on Editfor the configuration in question. Then, in the Fixtured Stationsfield, set Auto Enableto Always.  If StepSync has not been enabled, at runtime the user will be presented with an error message saying \"Unable to start, enable signal is low.\" Configuring the Sync Member    Select the Controllermenu, then select the StepSynctab.  In the StepSync section, select No Sync  The Step Sync Modewindow appears.  Select Sync Member  The Step Sync Modewindow closes.  In the Channelfield, set the channel number for the Sync Member by selecting the channel number. Then select the appropriate channel for the Sync Member.  The channel numbers of the Sync Members in the same set-up must be unique.  Select Apply.  The controller will reboot and boot into the Sync Member configuration, which will only display the Sync Member's channel number. Switching back to regular Power Focus 6000 mode (exiting StepSync)    Select the PF6 FlexSystemmenu, then select the StepSynctab.  In the StepSync section, select Sync Reference  The Step Sync Modewindow appears.  Select No Sync  The Step Sync Modewindow closes.  Select Apply.  The controller will reboot and boot into the regular configuration."},{"id":"9808351883","fileName":"9808351883.html","title":"Setting up StepSync (hardware)","level":4,"position":268,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync"],"content":"  Note that software configuration needs to be done before hardware set-up is completed in order to avoid possible set-up conflicts. The StepSync function allows several POWER FOCUS 6000to be connected in order to run synchronized tightenings.    Make sure each controller has been configured correctly (see StepSync Configuration for more information).  Using a Power Focus 6000 daisy-chain cable, connect the Sync Reference Com Port B to the first Sync Member's Com Port A.  Using another PF6000 daisy-chain cable, connect the first Sync Member's Com Port B to the second Sync Member's Com Port A. Do the same for all subsequent controllers.  A StepSync system can be configured with a maximum of 5 Sync Members.       A  Sync Reference  D  Connected to Com Port A   B  Sync Member  E  Power Focus 6000 daisy-chain cable   C  Connected to Com Port B    "},{"id":"9855031051","fileName":"9855031051.html","title":"StepSync Tightenings","level":4,"position":269,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync"],"content":" The only possible tightening programs to use in conjunction with StepSync are Multistep tightening programs. To synchronization between the tools in the set-up, Synchronization points are used. At these points, the tools will wait for each other before continuing with the next step in the Multistep tightening program. Note that assigning tightening programs to the different tools can only take place in ToolsTalk 2.  Example of a Multistep tighteningprogram for StepSync      A  Synchronization point A tightening program can consist of a maximum of 25 steps (not counting the Synchronization points). Available steps   Tighten to Angle  Tighten to Torque  Tighten to Torque plus Angle  Tighten to DynaTork  Wait  Socket Release  Tighten to Torque or Angle  Loosen to Angle  Loosen to Torque  Rundown  Tighten to Yield M2  Tighten to Yield  Tighten to Torque and Angle  Thread cutting to torque  Engage Available Monitors   Angle  Peak Torque  Shut Off Torque  Torque rate and deviation  Torque in angle window  Post view torque high  Post view torque los  Angle from Yield  Prevailing Torque  Shut Off Current  Post Thread cut angle  Post Thread cut peak torque  Stick Slip Detection  Time Available Step Restrictions   Maximum Torque  Maximum Angle  Cross Thread  Rescinding Torque  Torque Gradient  Torque in Angle View  Torque vs Current Deviation   Reject Management When switch to Off:       Action if failure   Description   End all    All channels will end the tightening and report status NOK.  The tightening that did not have an error itself will report additional info Terminated by other bolt.   Continue OK    The failing channels will end the tightening with status NOK.  The remaining channels will continue with the rest of the tightening program. When switch to On:      Parameter  Description     Max number of failing steps  Specifies the maximum number of different steps that can fail during the whole tightening. It does not matter if the same step fail more than once, it still only counts as one failing step. If not set an unlimited number of steps can fail.    Action if exceeded  Specifies the action if Maximum number of failing stepsis exceeded.    Action if NOK during repair  Specifies the action if a new error ( NOK) is detected while a repair is ongoing.  "},{"id":"9808355723","fileName":"9808355723.html","title":"StepSync Results","level":4,"position":270,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync"],"content":" The results for all the tools in the StepSync tightening will be shown on the controller GUI of the Sync Reference and in its corresponding Web GUI. The GIU on the Sync Members will not show any results. There are three different Result views. The first shows an overview of the total status for the entire tightening (OK or NOK) and the total number of OK and NOK bolts. The second shows the status for each bolt separately, and the third also shows the torque and angle values for each bolt.  Example of Overall Status View  Example of Overall Status view with Bolt Status  Example of Detailed Status view    "},{"id":"9808357643","fileName":"980835764323858698123.html","title":"StepSync Signals","level":4,"position":271,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync"],"content":" The StepSync system supports the same I\/O signals listed in the tables below. These can be mapped in fieldbus configuration and accessory configuration. Some are also available through Open Protocol. "},{"id":"18265939851","fileName":"1826593985123858705547.html","title":"Input Signals","level":5,"position":272,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals"],"content":"      Signal  Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]  Devices     title   item   item   item   none   none   subnodes "},{"id":"15415511691","fileName":"15415511691.html","title":"Channel Command - 10054","level":6,"position":273,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals"],"content":" Channel Command is an input signal that inhibits individual tools and prevents that those tools are included in the next tightening. It is also possible to replace the tightening program or bolt number configured in the sync mode configuration. Up to 64 channels are supported.  Name in SoftPLC: CHANNEL_COMMAND      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  uint32 array  1  64 The signal Channel Command -10054contains sub-signals (for more information, see \"Input Signals: Sub-signals\").   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":274,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Channel Command - 10054"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":275,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Channel Command - 10054"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":276,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Channel Command - 10054"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":277,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Channel Command - 10054"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":278,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Channel Command - 10054"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":279,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Channel Command - 10054"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":280,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Channel Command - 10054"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":281,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Channel Command - 10054"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":282,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Channel Command - 10054"],"content":"  I\/O Expander: TRUE"},{"id":"19292536075","fileName":"19292536075.html","title":"Continue Step - 10128","level":6,"position":283,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals"],"content":"  Continue Stepis an input signal that stops the Waittightening step. When the tightening has reached a Waittightening step with the condition Signalconfigured as Wait Type, a rising edge of the signal Continue Stepcauses the system (one or more spindles) to release. For more information, see the sub-signalChannel Command - 10054: Continue Step.  Name in SoftPLC: CONTINUE_STEP      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":284,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Continue Step - 10128"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":285,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Continue Step - 10128"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":286,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Continue Step - 10128"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":287,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Continue Step - 10128"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":288,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Continue Step - 10128"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":289,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Continue Step - 10128"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":290,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Continue Step - 10128"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":291,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Continue Step - 10128"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":292,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Continue Step - 10128"],"content":"  I\/O Expander: TRUE"},{"id":"18199003147","fileName":"18199003147.html","title":"Data Drop - 10125","level":6,"position":293,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals"],"content":" When set DATADROP to true at the end of a tightening DATADROP signal will drop result from the tightening. The result will not be stored persistently or sent to any device or clients like ToolsNet or protocol adapters.  Name in SoftPLC: DATADROP      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":294,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Data Drop - 10125"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":295,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Data Drop - 10125"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":296,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Data Drop - 10125"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":297,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Data Drop - 10125"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":298,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Data Drop - 10125"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":299,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Data Drop - 10125"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":300,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Data Drop - 10125"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":301,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Data Drop - 10125"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":302,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Data Drop - 10125"],"content":"  I\/O Expander: TRUE"},{"id":"18181823371","fileName":"18181823371.html","title":"Data Hold - 10124","level":6,"position":303,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals"],"content":" When signal DATAHOLD is set to true at the end of a tightening, transmission of the result data will be stopped.  Name in SoftPLC: DATAHOLD      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":304,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Data Hold - 10124"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":305,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Data Hold - 10124"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":306,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Data Hold - 10124"],"content":" Internal I\/O: TRUE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":307,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Data Hold - 10124"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":308,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Data Hold - 10124"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":309,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Data Hold - 10124"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":310,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Data Hold - 10124"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":311,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Data Hold - 10124"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":312,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Data Hold - 10124"],"content":"  I\/O Expander: TRUE"},{"id":"15415522699","fileName":"15415522699.html","title":"Disable Test Bolt - 10057","level":6,"position":313,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals"],"content":"  Name in SoftPLC: DISABLE_TESTBOLT      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":314,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Disable Test Bolt - 10057"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":315,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Disable Test Bolt - 10057"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":316,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Disable Test Bolt - 10057"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":317,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Disable Test Bolt - 10057"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":318,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Disable Test Bolt - 10057"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":319,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Disable Test Bolt - 10057"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":320,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Disable Test Bolt - 10057"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":321,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Disable Test Bolt - 10057"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":322,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Disable Test Bolt - 10057"],"content":"  I\/O Expander: TRUE"},{"id":"15415742347","fileName":"15415742347.html","title":"Enable Operation - 10055","level":6,"position":323,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals"],"content":"  Name in SoftPLC: ENABLE_OPERATION      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":324,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Enable Operation - 10055"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":325,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Enable Operation - 10055"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":326,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Enable Operation - 10055"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":327,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Enable Operation - 10055"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":328,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Enable Operation - 10055"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":329,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Enable Operation - 10055"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":330,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Enable Operation - 10055"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":331,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Enable Operation - 10055"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":332,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Enable Operation - 10055"],"content":"  I\/O Expander: TRUE"},{"id":"15415810315","fileName":"15415810315.html","title":"Fieldbus AsyncData To PF - 10077","level":6,"position":333,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals"],"content":"  Name in SoftPLC:      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  uint8 array  16  2048   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":334,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Fieldbus AsyncData To PF - 10077"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":335,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Fieldbus AsyncData To PF - 10077"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":336,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Fieldbus AsyncData To PF - 10077"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":337,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Fieldbus AsyncData To PF - 10077"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":338,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Fieldbus AsyncData To PF - 10077"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":339,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Fieldbus AsyncData To PF - 10077"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":340,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Fieldbus AsyncData To PF - 10077"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":341,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Fieldbus AsyncData To PF - 10077"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":342,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Fieldbus AsyncData To PF - 10077"],"content":" I\/O Expander: FALSE"},{"id":"15415916939","fileName":"15415916939.html","title":"Reset Cycle Status - 10056","level":6,"position":343,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals"],"content":"  Name in SoftPLC: RESET_CYCLE_STATUS      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":344,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Reset Cycle Status - 10056"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":345,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Reset Cycle Status - 10056"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":346,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Reset Cycle Status - 10056"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":347,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Reset Cycle Status - 10056"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":348,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Reset Cycle Status - 10056"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":349,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Reset Cycle Status - 10056"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":350,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Reset Cycle Status - 10056"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":351,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Reset Cycle Status - 10056"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":352,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Reset Cycle Status - 10056"],"content":"  I\/O Expander: TRUE"},{"id":"15415986315","fileName":"15415986315.html","title":"Reset System Error - 10062","level":6,"position":353,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals"],"content":"  Name in SoftPLC: RESET_SYSTEM_ERROR      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":354,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Reset System Error - 10062"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":355,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Reset System Error - 10062"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":356,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Reset System Error - 10062"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":357,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Reset System Error - 10062"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":358,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Reset System Error - 10062"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":359,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Reset System Error - 10062"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":360,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Reset System Error - 10062"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":361,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Reset System Error - 10062"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":362,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Reset System Error - 10062"],"content":"  I\/O Expander: TRUE"},{"id":"22163331339","fileName":"22163331339.html","title":"Set Zero Position - 10135","level":6,"position":363,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals"],"content":" For hand-held tools, the input signal Set Zero Positionkeeps the current position of the tools as home position. The signal is silently ignored if sent during an ongoing tightening. For fixtured tools, the input signal Set Zero Positionkeeps the current position of the tools as home position. The signal affects all the tools in the system, regardless of the virtual station. The signal is silently ignored by fixtured tools that are part of an ongoing tightening.  Name in SoftPLC: IN_EXTERNAL_SET_ZERO_POSITION      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":364,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Set Zero Position - 10135"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":365,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Set Zero Position - 10135"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":366,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Set Zero Position - 10135"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":367,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Set Zero Position - 10135"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":368,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Set Zero Position - 10135"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":369,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Set Zero Position - 10135"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":370,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Set Zero Position - 10135"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":371,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Set Zero Position - 10135"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":372,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Set Zero Position - 10135"],"content":"  I\/O Expander: TRUE"},{"id":"15416018443","fileName":"15416018443.html","title":"Start Loosening, Pulse - 10072","level":6,"position":373,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals"],"content":"  Name in SoftPLC: SELECT_PREVIOUS_ID_NUMBER      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: TRUE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":374,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Start Loosening, Pulse - 10072"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":375,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Start Loosening, Pulse - 10072"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":376,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Start Loosening, Pulse - 10072"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":377,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Start Loosening, Pulse - 10072"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":378,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Start Loosening, Pulse - 10072"],"content":" Tool Functions: TRUE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":379,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Start Loosening, Pulse - 10072"],"content":" ST Selector: TRUE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":380,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Start Loosening, Pulse - 10072"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":381,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Start Loosening, Pulse - 10072"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":382,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Start Loosening, Pulse - 10072"],"content":"  I\/O Expander: TRUE"},{"id":"15416029451","fileName":"15416029451.html","title":"Start Tools, Pulse - 10113","level":6,"position":383,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals"],"content":"      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: TRUE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":384,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Start Tools, Pulse - 10113"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":385,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Start Tools, Pulse - 10113"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":386,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Start Tools, Pulse - 10113"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":387,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Start Tools, Pulse - 10113"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":388,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Start Tools, Pulse - 10113"],"content":" Tool Functions: TRUE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":389,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Start Tools, Pulse - 10113"],"content":" ST Selector: TRUE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":390,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Start Tools, Pulse - 10113"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":391,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Start Tools, Pulse - 10113"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":392,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Start Tools, Pulse - 10113"],"content":"  I\/O Expander: TRUE"},{"id":"21014041227","fileName":"21014041227.html","title":"Stop (pulse) - 10129","level":6,"position":393,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals"],"content":" If this signal is generated any ongoing tightening or loosening will be stopped. Used in combination with 10024 or 10072.  Name in SoftPLC: EXTERNAL_STOP_PULSE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":394,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Stop (pulse) - 10129"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":395,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Stop (pulse) - 10129"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":396,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Stop (pulse) - 10129"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":397,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Stop (pulse) - 10129"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":398,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Stop (pulse) - 10129"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":399,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Stop (pulse) - 10129"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":400,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Stop (pulse) - 10129"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":401,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Stop (pulse) - 10129"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":402,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Stop (pulse) - 10129"],"content":"  I\/O Expander: TRUE"},{"id":"21014095499","fileName":"21014095499.html","title":"Stop (state) - 10133","level":6,"position":403,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals"],"content":" If this signal is set, any ongoing tightening or loosening will be stopped. Will also block any start attempts while set high. Used in combination with 10024 or 10072.  Name in SoftPLC: IN_EXTERNAL_STOP_STATE      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":404,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Stop (state) - 10133"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":405,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Stop (state) - 10133"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":406,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Stop (state) - 10133"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":407,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Stop (state) - 10133"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":408,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Stop (state) - 10133"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":409,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Stop (state) - 10133"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":410,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Stop (state) - 10133"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":411,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Stop (state) - 10133"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":412,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals","Stop (state) - 10133"],"content":"  I\/O Expander: TRUE"},{"id":"18265945099","fileName":"1826594509923858712971.html","title":"Output Signals","level":5,"position":413,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals"],"content":"      Signal  Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]  Devices     title   item   item   item   none   none   subnodes "},{"id":"15413918731","fileName":"15413918731.html","title":"Bolt Tightening Status - 79","level":6,"position":414,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":" Bolt Tightening Status is an output signal that identifies the status for individual bolts in a synchronized tightening. 100 bolts are supported. Bolt Tightening Status signal shows information related to the running tightening and the result of the last tightening.  Name in SoftPLC: BOLT_TIGHTENING_STATUS      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  uint32 array  32  32   FordResultStatus  State   4  4   CompactErrorStatus  State   4  4   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character). The signal Bolt Tightening Status - 79contains sub-signals (for more information, see \"Output Signals: Sub-signals\").   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":415,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Bolt Tightening Status - 79"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":416,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Bolt Tightening Status - 79"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":417,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Bolt Tightening Status - 79"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":418,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Bolt Tightening Status - 79"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":419,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Bolt Tightening Status - 79"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":420,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Bolt Tightening Status - 79"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":421,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Bolt Tightening Status - 79"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":422,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Bolt Tightening Status - 79"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":423,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Bolt Tightening Status - 79"],"content":"  I\/O Expander: TRUE"},{"id":"15413934859","fileName":"15413934859.html","title":"Channel Hardware Status - 81","level":6,"position":424,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":" Channel Hardware Status is an output signal that identifies the hardware status for individual channels. 64 channels are supported. Channel Hardware Status signal shows information about the hardware status and possible errors.  Name in SoftPLC: CHANNEL_HARDWARE_STATUS      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  uint32 array  1  64 The signal Channel Hardware Status - 81contains sub-signals (for more information, see \"Output Signals: Sub-signals\").   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":425,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Channel Hardware Status - 81"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":426,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Channel Hardware Status - 81"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":427,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Channel Hardware Status - 81"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":428,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Channel Hardware Status - 81"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":429,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Channel Hardware Status - 81"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":430,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Channel Hardware Status - 81"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":431,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Channel Hardware Status - 81"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":432,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Channel Hardware Status - 81"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":433,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Channel Hardware Status - 81"],"content":"  I\/O Expander: TRUE"},{"id":"15414576139","fileName":"15414576139.html","title":"Channel Tightening Status - 80","level":6,"position":434,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":" Channel Tightening Status is an output signal that identifies the status for individual channels in a synchronized tightening. 64 channels are supported. Channel Tightening Status signal shows information related to the running tightening and the result of the last tightening.  Name in SoftPLC: CHANNEL_TIGHTENING_STATUS      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  uint32 array  1  64   FordResultStatus  State   4  4   CompactErrorStatus  State   4  4   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character). The signal Channel Tightening Status - 80contains sub-signals (for more information, see \"Output Signals: Sub-signals\").   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":435,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Channel Tightening Status - 80"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":436,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Channel Tightening Status - 80"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":437,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Channel Tightening Status - 80"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":438,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Channel Tightening Status - 80"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":439,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Channel Tightening Status - 80"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":440,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Channel Tightening Status - 80"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":441,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Channel Tightening Status - 80"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":442,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Channel Tightening Status - 80"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":443,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Channel Tightening Status - 80"],"content":"  I\/O Expander: TRUE"},{"id":"21002018187","fileName":"21002018187.html","title":"Confirm loosening - 206","level":6,"position":444,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":" Indicate if loosening is selected and possible to start. That is, a loosening sync mode or loosening program exists and are selected.  Name in SoftPLC: CONFIRM_LOOSENING      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":445,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Confirm loosening - 206"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":446,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Confirm loosening - 206"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":447,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Confirm loosening - 206"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":448,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Confirm loosening - 206"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":449,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Confirm loosening - 206"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":450,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Confirm loosening - 206"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":451,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Confirm loosening - 206"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":452,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Confirm loosening - 206"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":453,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Confirm loosening - 206"],"content":"  I\/O Expander: TRUE"},{"id":"15414591371","fileName":"15414591371.html","title":"Cycle Complete - 77","level":6,"position":454,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":"  Name in SoftPLC: CYCLE_COMPLETE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":455,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Complete - 77"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":456,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Complete - 77"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":457,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Complete - 77"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":458,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Complete - 77"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":459,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Complete - 77"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":460,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Complete - 77"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":461,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Complete - 77"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":462,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Complete - 77"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":463,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Complete - 77"],"content":"  I\/O Expander: TRUE"},{"id":"21002085643","fileName":"21002085643.html","title":"Cycle Emergency stopped - 202","level":6,"position":464,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":" Indicate last tightening or loosening was interrupted by emergency stop.  Name in SoftPLC: CYCLE_EMERGENCY_STOPPED      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":465,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Emergency stopped - 202"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":466,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Emergency stopped - 202"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":467,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Emergency stopped - 202"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":468,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Emergency stopped - 202"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":469,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Emergency stopped - 202"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":470,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Emergency stopped - 202"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":471,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Emergency stopped - 202"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":472,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Emergency stopped - 202"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":473,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Emergency stopped - 202"],"content":"  I\/O Expander: TRUE"},{"id":"15414620555","fileName":"15414620555.html","title":"Cycle NOK - 76","level":6,"position":474,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":"  Name in SoftPLC: CYCLE_NOK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":475,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle NOK - 76"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":476,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle NOK - 76"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":477,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle NOK - 76"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":478,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle NOK - 76"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":479,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle NOK - 76"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":480,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle NOK - 76"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":481,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle NOK - 76"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":482,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle NOK - 76"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":483,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle NOK - 76"],"content":"  I\/O Expander: TRUE"},{"id":"15414663691","fileName":"15414663691.html","title":"Cycle OK - 75","level":6,"position":484,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":"  Name in SoftPLC: CYCLE_OK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":485,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle OK - 75"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":486,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle OK - 75"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":487,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle OK - 75"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":488,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle OK - 75"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":489,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle OK - 75"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":490,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle OK - 75"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":491,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle OK - 75"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":492,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle OK - 75"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":493,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle OK - 75"],"content":"  I\/O Expander: TRUE"},{"id":"15414791819","fileName":"15414791819.html","title":"Cycle Ready To Start - 82","level":6,"position":494,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":"  Name in SoftPLC: CYCLE_READY_TO_START      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":495,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Ready To Start - 82"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":496,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Ready To Start - 82"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":497,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Ready To Start - 82"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":498,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Ready To Start - 82"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":499,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Ready To Start - 82"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":500,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Ready To Start - 82"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":501,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Ready To Start - 82"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":502,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Ready To Start - 82"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":503,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Ready To Start - 82"],"content":"  I\/O Expander: TRUE"},{"id":"15414759179","fileName":"15414759179.html","title":"Cycle Running - 78","level":6,"position":504,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":"  Name in SoftPLC: CYCLE_RUNNING      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":505,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Running - 78"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":506,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Running - 78"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":507,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Running - 78"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":508,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Running - 78"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":509,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Running - 78"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":510,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Running - 78"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":511,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Running - 78"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":512,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Running - 78"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":513,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Cycle Running - 78"],"content":"  I\/O Expander: TRUE"},{"id":"18199369227","fileName":"18199369227.html","title":"Data Drop Active - 199","level":6,"position":514,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":" This signal will be set high whenever DATADROP function is active. When DATADROP input signal is set and worktask supporting DATADROP is selected.      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":515,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Data Drop Active - 199"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":516,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Data Drop Active - 199"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":517,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Data Drop Active - 199"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":518,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Data Drop Active - 199"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":519,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Data Drop Active - 199"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":520,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Data Drop Active - 199"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":521,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Data Drop Active - 199"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":522,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Data Drop Active - 199"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":523,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Data Drop Active - 199"],"content":"  I\/O Expander: TRUE"},{"id":"18199281419","fileName":"18199281419.html","title":"Data Hold Active - 198","level":6,"position":524,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":" This signal will be set high whenever the DATAHOLD function is active. When DATAHOLD signal is set and a worktask supporting DATAHOLD is selected.      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":525,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Data Hold Active - 198"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":526,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Data Hold Active - 198"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":527,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Data Hold Active - 198"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":528,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Data Hold Active - 198"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":529,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Data Hold Active - 198"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":530,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Data Hold Active - 198"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":531,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Data Hold Active - 198"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":532,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Data Hold Active - 198"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":533,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Data Hold Active - 198"],"content":"  I\/O Expander: TRUE"},{"id":"15415015819","fileName":"15415015819.html","title":"Fieldbus AsyncData From PF - 107","level":6,"position":534,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":"  Name in SoftPLC:      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  uint8 array  48  2048   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":535,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Fieldbus AsyncData From PF - 107"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":536,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Fieldbus AsyncData From PF - 107"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":537,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Fieldbus AsyncData From PF - 107"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":538,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Fieldbus AsyncData From PF - 107"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":539,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Fieldbus AsyncData From PF - 107"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":540,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Fieldbus AsyncData From PF - 107"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":541,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Fieldbus AsyncData From PF - 107"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":542,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Fieldbus AsyncData From PF - 107"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":543,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Fieldbus AsyncData From PF - 107"],"content":" I\/O Expander: FALSE"},{"id":"21049062283","fileName":"21049062283.html","title":"Last Cycle No Result - 200","level":6,"position":544,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":" This signal shall be set after a tightening is done if the tightening is considered as a free running.  Name in SoftPLC: LAST_CYCLE_NO_RESULT      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":545,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Last Cycle No Result - 200"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":546,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Last Cycle No Result - 200"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":547,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Last Cycle No Result - 200"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":548,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Last Cycle No Result - 200"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":549,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Last Cycle No Result - 200"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":550,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Last Cycle No Result - 200"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":551,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Last Cycle No Result - 200"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":552,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Last Cycle No Result - 200"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":553,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Last Cycle No Result - 200"],"content":"  I\/O Expander: TRUE"},{"id":"15415254411","fileName":"15415254411.html","title":"No System Error - 83","level":6,"position":554,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":"  Name in SoftPLC: NO_SYSTEM_ERROR      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":555,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","No System Error - 83"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":556,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","No System Error - 83"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":557,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","No System Error - 83"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":558,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","No System Error - 83"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":559,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","No System Error - 83"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":560,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","No System Error - 83"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":561,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","No System Error - 83"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":562,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","No System Error - 83"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":563,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","No System Error - 83"],"content":"  I\/O Expander: TRUE"},{"id":"15415403403","fileName":"15415403403.html","title":"No System Warning - 102","level":6,"position":564,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":"  Name in SoftPLC: NO_SYSTEM_WARNING      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":565,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","No System Warning - 102"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":566,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","No System Warning - 102"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":567,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","No System Warning - 102"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":568,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","No System Warning - 102"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":569,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","No System Warning - 102"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":570,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","No System Warning - 102"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":571,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","No System Warning - 102"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":572,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","No System Warning - 102"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":573,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","No System Warning - 102"],"content":"  I\/O Expander: TRUE"},{"id":"15415425547","fileName":"15415425547.html","title":"Selected Mode Id - 72","level":6,"position":574,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":"  Name in SoftPLC: SELECTED_MODE_ID      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Integer  1  32   TreatZeroAsOne  State  Integer  1  32   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":575,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Selected Mode Id - 72"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":576,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Selected Mode Id - 72"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":577,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Selected Mode Id - 72"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":578,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Selected Mode Id - 72"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":579,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Selected Mode Id - 72"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":580,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Selected Mode Id - 72"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":581,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Selected Mode Id - 72"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":582,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Selected Mode Id - 72"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":583,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Selected Mode Id - 72"],"content":" I\/O Expander: FALSE"},{"id":"21001130635","fileName":"21001130635.html","title":"Sync Mode Valid - 207","level":6,"position":584,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":" Indicate if selected sync mode is valid or not. That is, if it exists and is configured properly.  Name in SoftPLC: SYNC_MODE_VALID      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":585,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Sync Mode Valid - 207"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":586,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Sync Mode Valid - 207"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":587,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Sync Mode Valid - 207"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":588,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Sync Mode Valid - 207"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":589,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Sync Mode Valid - 207"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":590,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Sync Mode Valid - 207"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":591,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Sync Mode Valid - 207"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":592,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Sync Mode Valid - 207"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":593,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Sync Mode Valid - 207"],"content":"  I\/O Expander: TRUE"},{"id":"15415461643","fileName":"15415461643.html","title":"Test Bolt Activated - 91","level":6,"position":594,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":"  Name in SoftPLC: SELECTED_MODE_ID      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":595,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Test Bolt Activated - 91"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":596,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Test Bolt Activated - 91"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":597,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Test Bolt Activated - 91"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":598,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Test Bolt Activated - 91"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":599,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Test Bolt Activated - 91"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":600,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Test Bolt Activated - 91"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":601,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Test Bolt Activated - 91"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":602,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Test Bolt Activated - 91"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":603,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Test Bolt Activated - 91"],"content":"  I\/O Expander: TRUE"},{"id":"22259137675","fileName":"22259137675.html","title":"Tools in Zero Position - 210","level":6,"position":604,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":"  The output signal Tools in Zero Positionis available only for hand-held tool. The output signal Tools in Zero Positiondefines if the tool is in home position - for example, at the end of a forward or backward position step. The signal is not updated in real time, so if the tool for any reason is moved out of position, the signal will not work.  Name in SoftPLC: TOOLS_IN_ZERO_POSITION      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":605,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Tools in Zero Position - 210"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":606,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Tools in Zero Position - 210"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":607,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Tools in Zero Position - 210"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":608,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Tools in Zero Position - 210"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":609,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Tools in Zero Position - 210"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":610,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Tools in Zero Position - 210"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":611,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Tools in Zero Position - 210"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":612,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Tools in Zero Position - 210"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":613,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Tools in Zero Position - 210"],"content":"  I\/O Expander: TRUE"},{"id":"18269114891","fileName":"18269114891.html","title":"ToolsNet Connection Lost - 133","level":6,"position":614,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":" Indicates if enabled connection between ToolsNet and controller got interrupted or is working as expected.  Name in SoftPLC: TOOLSNET_CONNECTION_LOST      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":615,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","ToolsNet Connection Lost - 133"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":616,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","ToolsNet Connection Lost - 133"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":617,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","ToolsNet Connection Lost - 133"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":618,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","ToolsNet Connection Lost - 133"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":619,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","ToolsNet Connection Lost - 133"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":620,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","ToolsNet Connection Lost - 133"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":621,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","ToolsNet Connection Lost - 133"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":622,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","ToolsNet Connection Lost - 133"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":623,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","ToolsNet Connection Lost - 133"],"content":"  I\/O Expander: TRUE"},{"id":"21000319627","fileName":"21000319627.html","title":"ToolsTalk Connection Lost - 208","level":6,"position":624,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":" Indicates if enabled connection between ToolsTalk and controller got interrupted or is working as expected.  Name in SoftPLC: TOOLSTALK_CONNECTION_LOST      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: TRUE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":625,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","ToolsTalk Connection Lost - 208"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":626,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","ToolsTalk Connection Lost - 208"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":627,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","ToolsTalk Connection Lost - 208"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":628,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","ToolsTalk Connection Lost - 208"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":7,"position":629,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","ToolsTalk Connection Lost - 208"],"content":" Tool Functions: TRUE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":630,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","ToolsTalk Connection Lost - 208"],"content":" ST Selector: TRUE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":631,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","ToolsTalk Connection Lost - 208"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":7,"position":632,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","ToolsTalk Connection Lost - 208"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":633,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","ToolsTalk Connection Lost - 208"],"content":"  I\/O Expander: TRUE"},{"id":"20973171979","fileName":"20973171979.html","title":"Total Remaining Sequence Counter - 205","level":6,"position":634,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":" The amount of remaining tightenings to be completed in a batch sequence.  Name in SoftPLC: TOTAL_REMAINING_SEQ_COUNT      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  16   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: TRUE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":635,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Remaining Sequence Counter - 205"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":636,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Remaining Sequence Counter - 205"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":637,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Remaining Sequence Counter - 205"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":638,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Remaining Sequence Counter - 205"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":639,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Remaining Sequence Counter - 205"],"content":" Tool Functions: FALSE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":640,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Remaining Sequence Counter - 205"],"content":" ST Selector: TRUE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":641,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Remaining Sequence Counter - 205"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":642,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Remaining Sequence Counter - 205"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":643,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Remaining Sequence Counter - 205"],"content":" I\/O Expander: FALSE"},{"id":"20973170059","fileName":"20973170059.html","title":"Total Sequence Counter - 204","level":6,"position":644,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":" The amount of completed tightenings in a batch sequence.  Name in SoftPLC: TOTAL_SEQ_COUNTER      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  16   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: TRUE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":645,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Sequence Counter - 204"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":646,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Sequence Counter - 204"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":647,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Sequence Counter - 204"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":648,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Sequence Counter - 204"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":649,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Sequence Counter - 204"],"content":" Tool Functions: FALSE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":650,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Sequence Counter - 204"],"content":" ST Selector: TRUE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":651,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Sequence Counter - 204"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":652,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Sequence Counter - 204"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":653,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Sequence Counter - 204"],"content":" I\/O Expander: FALSE"},{"id":"20973167115","fileName":"20973167115.html","title":"Total Sequence Size - 203","level":6,"position":654,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":" The total amount of tightenings to be completed in a batch sequence.  Name in SoftPLC: TOTAL_SEQ_SIZE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  16   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  I\/O Expander: FALSE  Operator Panel: FALSE  ST Selector: TRUE  Stacklight: FALSE  Tool Functions: FALSE  TLS Tag: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":655,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Sequence Size - 203"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":7,"position":656,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Sequence Size - 203"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":7,"position":657,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Sequence Size - 203"],"content":" Internal I\/O: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":7,"position":658,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Sequence Size - 203"],"content":" I\/O Expander: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":7,"position":659,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Sequence Size - 203"],"content":" Operator Panel: FALSE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":7,"position":660,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Sequence Size - 203"],"content":" ST Selector: TRUE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":7,"position":661,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Sequence Size - 203"],"content":" Stacklight: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":662,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Sequence Size - 203"],"content":" Tool Functions: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":663,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Total Sequence Size - 203"],"content":" TLS Tag: FALSE"},{"id":"19292537611","fileName":"19292537611.html","title":"Waiting To Continue - 201","level":6,"position":664,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals"],"content":" Waiting To Continue is an output signal, which means that the tightening has reached a Waittightening step with the condition Signalconfigured as Wait Type. The system (one or more spindles) pauses the tightening waiting for the signalContinue Step - 10128(for system release) or the sub-signalChannel Command - 10054: Continue Step(for individual spindle release). For more information, see the sub-signalsBolt Tightening Status - 79: Waiting To ContinueandChannel Tightening Status - 80: Waiting To Continue.  Name in SoftPLC: WAITING_FOR_CONTINUE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":7,"position":665,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Waiting To Continue - 201"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":7,"position":666,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Waiting To Continue - 201"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":7,"position":667,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Waiting To Continue - 201"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":7,"position":668,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Waiting To Continue - 201"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":7,"position":669,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Waiting To Continue - 201"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":7,"position":670,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Waiting To Continue - 201"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":7,"position":671,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Waiting To Continue - 201"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":7,"position":672,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Waiting To Continue - 201"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":7,"position":673,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals","Waiting To Continue - 201"],"content":"  I\/O Expander: TRUE"},{"id":"19161586955","fileName":"1916158695523858720395.html","title":"Input Signals: Sub-signals","level":5,"position":674,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals"],"content":" Select the needed input signal to examine the related sub-signals:   Channel Command -10054 "},{"id":"19227460235","fileName":"1922746023523858727819.html","title":"Channel Command - 10054: Sub-signals","level":6,"position":675,"hasContent":false,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals: Sub-signals"],"content":""},{"id":"19392646411","fileName":"19392646411.html","title":"Continue Step","level":7,"position":676,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals: Sub-signals","Channel Command - 10054: Sub-signals"],"content":" If in a Waittightening step with the condition Signalconfigured as Wait Type, through the sub-signal Continue Step, it is possible to control tools individually and let the tightening continue. For more information, see the input signalContinue Step - 10128.  Name in SoftPLC: CHANNEL_COMMAND_CONTINUE_STEP      Value Type  Start bit  Length  Size Min [bit]  Size Max [bit]    Boolean  3  1  1  1 "},{"id":"15771115531","fileName":"15771115531.html","title":"Force Bolt ID","level":7,"position":677,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals: Sub-signals","Channel Command - 10054: Sub-signals"],"content":"  Name in SoftPLC: CHANNEL_COMMAND_FORCE_BOLT_ID      Value Type  Size Min [bit]  Size Max [bit]    Integer  1  8"},{"id":"15771111819","fileName":"15771111819.html","title":"Force Pset","level":7,"position":678,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals: Sub-signals","Channel Command - 10054: Sub-signals"],"content":"  Name in SoftPLC: CHANNEL_COMMAND_FORCE_PSET      Value Type  Size Min [bit]  Size Max [bit]    Integer  1  8"},{"id":"15770093579","fileName":"15770093579.html","title":"Inhibit No Result","level":7,"position":679,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals: Sub-signals","Channel Command - 10054: Sub-signals"],"content":"  Name in SoftPLC: CHANNEL_COMMAND_NO_RESULT      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15771103755","fileName":"15771103755.html","title":"Inhibit NOK Result","level":7,"position":680,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals: Sub-signals","Channel Command - 10054: Sub-signals"],"content":"  Name in SoftPLC: CHANNEL_COMMAND_NOK_RESULT      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15771108107","fileName":"15771108107.html","title":"Inhibit OK Result","level":7,"position":681,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals: Sub-signals","Channel Command - 10054: Sub-signals"],"content":"  Name in SoftPLC: CHANNEL_COMMAND_OK_RESULT      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"22163341451","fileName":"22163341451.html","title":"Set Zero Position","level":7,"position":682,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Input Signals: Sub-signals","Channel Command - 10054: Sub-signals"],"content":"  Name in SoftPLC: CHANNEL_COMMAND_SET_ZERO_POSITION      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"19227372555","fileName":"1922737255523858735243.html","title":"Output Signals: Sub-signals","level":5,"position":683,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals"],"content":" Select the needed output signal to examine the related sub-signals:   Bolt Tightening Status - 79  Channel Tightening Status - 80  Channel Hardware Status - 81 "},{"id":"19229917707","fileName":"1922991770723858742667.html","title":"Bolt Tightening Status - 79: Sub-signals","level":6,"position":684,"hasContent":false,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals"],"content":""},{"id":"15771234443","fileName":"15771234443.html","title":"All Signals","level":7,"position":685,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_ALL      Value Type  Size Min [bit]  Size Max [bit]    Integer  1  32"},{"id":"15771238155","fileName":"15771238155.html","title":"Cycle Running","level":7,"position":686,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_RUNNING      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772090379","fileName":"15772090379.html","title":"In Selected Mode","level":7,"position":687,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_IN_SELECTED_MODE      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15771241867","fileName":"15771241867.html","title":"Inhibited","level":7,"position":688,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_INHIBITED      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15773347851","fileName":"15773347851.html","title":"Last Cycle Angle High","level":7,"position":689,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_ANGLE_HIGH      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15773351563","fileName":"15773351563.html","title":"Last Cycle Angle Low","level":7,"position":690,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_ANGLE_LOW      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772717067","fileName":"15772717067.html","title":"Last Cycle Hardware Error","level":7,"position":691,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_HW_ERROR      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772539531","fileName":"15772539531.html","title":"Last Cycle Inhibited","level":7,"position":692,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_INHIBITED      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772382219","fileName":"15772382219.html","title":"Last Cycle NOK","level":7,"position":693,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_NOK      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772543243","fileName":"15772543243.html","title":"Last Cycle Not Included","level":7,"position":694,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_NOT_INCLUDED      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772377867","fileName":"15772377867.html","title":"Last Cycle OK","level":7,"position":695,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_OK      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772546955","fileName":"15772546955.html","title":"Last Cycle Terminated By Other","level":7,"position":696,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_TERMINATED_BY_OTHER      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15773246347","fileName":"15773246347.html","title":"Last Cycle Timeout","level":7,"position":697,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_TIMEOUT      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15773250059","fileName":"15773250059.html","title":"Last Cycle Torque High","level":7,"position":698,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_TORQUE_HIGH      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15773343371","fileName":"15773343371.html","title":"Last Cycle Torque Low","level":7,"position":699,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_TORQUE_LOW      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15773242507","fileName":"15773242507.html","title":"Last Loosening NOK","level":7,"position":700,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_LOOSENING_NOK      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772739595","fileName":"15772739595.html","title":"Last Loosening OK","level":7,"position":701,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_LOOSENING_OK      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772735755","fileName":"15772735755.html","title":"Last Tightening NOK","level":7,"position":702,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_TIGHTENING_NOK      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772731915","fileName":"15772731915.html","title":"Last Tightening OK","level":7,"position":703,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_TIGHTENING_OK      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772374155","fileName":"15772374155.html","title":"Loosening Running","level":7,"position":704,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_RUNNING_LOOSENING      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772094091","fileName":"15772094091.html","title":"Running Repair","level":7,"position":705,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_REPAIR      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772097931","fileName":"15772097931.html","title":"Running Termination","level":7,"position":706,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_TERMINATE      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772370443","fileName":"15772370443.html","title":"Tightening Running","level":7,"position":707,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_RUNNING_TIGHTENING      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772720779","fileName":"15772720779.html","title":"Tool Led Mirror Green","level":7,"position":708,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_TOOL_LED_MIRROR_GREEN      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772728203","fileName":"15772728203.html","title":"Tool Led Mirror Red","level":7,"position":709,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_TOOL_LED_MIRROR_RED      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772724491","fileName":"15772724491.html","title":"Tool Led Mirror Yellow","level":7,"position":710,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_TOOL_LED_MIRROR_YELLOW      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"19392644875","fileName":"19392644875.html","title":"Waiting To Continue","level":7,"position":711,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Bolt Tightening Status - 79: Sub-signals"],"content":" If in a Waittightening step with the condition Signalconfigured as Wait Type, through the sub-signal Waiting To Continue, each individual bolt shows if the related status is waiting for an input to continue. For more information, see the output signalWaiting To Continue - 201.  Name in SoftPLC: CYCLE_STATUS_WAITING_FOR_CONTINUE      Value Type  Start bit  Length  Size Min [bit]  Size Max [bit]    Boolean  7  1  1  1 "},{"id":"19229921675","fileName":"1922992167523858757515.html","title":"Channel Tightening Status - 80: Sub-signals","level":6,"position":712,"hasContent":false,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals"],"content":""},{"id":"15771234443","fileName":"15771234443.html","title":"All Signals","level":7,"position":713,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_ALL      Value Type  Size Min [bit]  Size Max [bit]    Integer  1  32"},{"id":"15771238155","fileName":"15771238155.html","title":"Cycle Running","level":7,"position":714,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_RUNNING      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772090379","fileName":"15772090379.html","title":"In Selected Mode","level":7,"position":715,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_IN_SELECTED_MODE      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15771241867","fileName":"15771241867.html","title":"Inhibited","level":7,"position":716,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_INHIBITED      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15773347851","fileName":"15773347851.html","title":"Last Cycle Angle High","level":7,"position":717,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_ANGLE_HIGH      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15773351563","fileName":"15773351563.html","title":"Last Cycle Angle Low","level":7,"position":718,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_ANGLE_LOW      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772717067","fileName":"15772717067.html","title":"Last Cycle Hardware Error","level":7,"position":719,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_HW_ERROR      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772539531","fileName":"15772539531.html","title":"Last Cycle Inhibited","level":7,"position":720,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_INHIBITED      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772382219","fileName":"15772382219.html","title":"Last Cycle NOK","level":7,"position":721,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_NOK      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772543243","fileName":"15772543243.html","title":"Last Cycle Not Included","level":7,"position":722,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_NOT_INCLUDED      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772377867","fileName":"15772377867.html","title":"Last Cycle OK","level":7,"position":723,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_OK      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772546955","fileName":"15772546955.html","title":"Last Cycle Terminated By Other","level":7,"position":724,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_TERMINATED_BY_OTHER      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15773246347","fileName":"15773246347.html","title":"Last Cycle Timeout","level":7,"position":725,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_TIMEOUT      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15773250059","fileName":"15773250059.html","title":"Last Cycle Torque High","level":7,"position":726,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_TORQUE_HIGH      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15773343371","fileName":"15773343371.html","title":"Last Cycle Torque Low","level":7,"position":727,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_CYCLE_TORQUE_LOW      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15773242507","fileName":"15773242507.html","title":"Last Loosening NOK","level":7,"position":728,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_LOOSENING_NOK      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772739595","fileName":"15772739595.html","title":"Last Loosening OK","level":7,"position":729,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_LOOSENING_OK      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772735755","fileName":"15772735755.html","title":"Last Tightening NOK","level":7,"position":730,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_TIGHTENING_NOK      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772731915","fileName":"15772731915.html","title":"Last Tightening OK","level":7,"position":731,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_LAST_TIGHTENING_OK      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772374155","fileName":"15772374155.html","title":"Loosening Running","level":7,"position":732,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_RUNNING_LOOSENING      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772094091","fileName":"15772094091.html","title":"Running Repair","level":7,"position":733,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_REPAIR      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772097931","fileName":"15772097931.html","title":"Running Termination","level":7,"position":734,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_TERMINATE      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772370443","fileName":"15772370443.html","title":"Tightening Running","level":7,"position":735,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_RUNNING_TIGHTENING      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772720779","fileName":"15772720779.html","title":"Tool Led Mirror Green","level":7,"position":736,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_TOOL_LED_MIRROR_GREEN      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772728203","fileName":"15772728203.html","title":"Tool Led Mirror Red","level":7,"position":737,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_TOOL_LED_MIRROR_RED      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"15772724491","fileName":"15772724491.html","title":"Tool Led Mirror Yellow","level":7,"position":738,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_TOOL_LED_MIRROR_YELLOW      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"19417055115","fileName":"19417055115.html","title":"Waiting To Continue","level":7,"position":739,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Tightening Status - 80: Sub-signals"],"content":" If in a Waittightening step with the condition Signalconfigured as Wait Type, through the sub-signal Waiting To Continue, each individual channel shows if the related status is waiting for an input to continue. For more information, see the output signalWaiting To Continue - 201.  Name in SoftPLC: CYCLE_STATUS_WAITING_FOR_CONTINUE      Value Type  Start bit  Length  Size Min [bit]  Size Max [bit]    Boolean  7  1  1  1 "},{"id":"19229920139","fileName":"1922992013923858750091.html","title":"Channel Hardware Status - 81: Sub-signals","level":6,"position":740,"hasContent":false,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals"],"content":""},{"id":"15771234443","fileName":"15771234443.html","title":"All Signals","level":7,"position":741,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Hardware Status - 81: Sub-signals"],"content":"  Name in SoftPLC: CYCLE_STATUS_ALL      Value Type  Size Min [bit]  Size Max [bit]    Integer  1  32"},{"id":"20866813195","fileName":"20866813195.html","title":"Drive Any Hardware Error","level":7,"position":742,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Hardware Status - 81: Sub-signals"],"content":" This sub-signal is set whenever a drive hardware error is detected. This can be any of Drive Temp High, Drive Voltage Error, or Drive Disconnected.  Name in SoftPLC: CHANNEL_HW_STATUS_DRIVE_ANY_HARDWARE_ERROR      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"16423602187","fileName":"16423602187.html","title":"Drive Disconnected","level":7,"position":743,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Hardware Status - 81: Sub-signals"],"content":"  Name in SoftPLC: CHANNEL_HW_STATUS_DRIVE_DISCONNECTED      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"16423191307","fileName":"16423191307.html","title":"Drive Temp High","level":7,"position":744,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Hardware Status - 81: Sub-signals"],"content":"  Name in SoftPLC: CHANNEL_HW_STATUS_DRIVE_TEMP_HIGH      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"16423276683","fileName":"16423276683.html","title":"Drive Voltage Error","level":7,"position":745,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Hardware Status - 81: Sub-signals"],"content":"  Name in SoftPLC: CHANNEL_HW_STATUS_DRIVE_VOLTAGE_ERROR      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"16423289099","fileName":"16423289099.html","title":"Emergency Stop Active","level":7,"position":746,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Hardware Status - 81: Sub-signals"],"content":"  Name in SoftPLC: CHANNEL_HW_STATUS_EMERGENCY_STOP_ACTIVE      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"16422115083","fileName":"16422115083.html","title":"General Hardware Error","level":7,"position":747,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Hardware Status - 81: Sub-signals"],"content":"  Name in SoftPLC: CHANNEL_HW_STATUS_GENERAL_ERROR      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"16423201419","fileName":"16423201419.html","title":"Motortune Needed","level":7,"position":748,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Hardware Status - 81: Sub-signals"],"content":"  Name in SoftPLC: CHANNEL_HW_STATUS_MOTORTUNE_NEEDED      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"20866765707","fileName":"20866765707.html","title":"Tool Any Hardware Error","level":7,"position":749,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Hardware Status - 81: Sub-signals"],"content":" This sub-signal is set whenever a tool hardware error is detected. This can be any of Tool Temp High, Motortune Needed, Tool Cable Invalid, Tool Disconnected, Torque Transducer Erroror Tool Hardware Error.  Name in SoftPLC: CHANNEL_HW_STATUS_TOOL_ANY_HARDWARE_ERROR      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"16423302667","fileName":"16423302667.html","title":"Tool Cable Invalid","level":7,"position":750,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Hardware Status - 81: Sub-signals"],"content":"  Name in SoftPLC: CHANNEL_HW_STATUS_TOOL_CABLE_INVALID      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"16423509387","fileName":"16423509387.html","title":"Tool Disconnected","level":7,"position":751,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Hardware Status - 81: Sub-signals"],"content":"  Name in SoftPLC: CHANNEL_HW_STATUS_TOOL_DISCONNECTED      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"20866718219","fileName":"20866718219.html","title":"Tool Hardware Error","level":7,"position":752,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Hardware Status - 81: Sub-signals"],"content":" This sub-signal is set for a collection of health parameters and can indicate any of the following: ToolGround, ToolIndicatorBoard, ToolFanVoltage, ToolAccessoryBusVoltage, ToolParameterFileor ToolTriggerS.  Name in SoftPLC: CHANNEL_HW_STATUS_TOOL_HARDWARE_ERROR      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"16423181579","fileName":"16423181579.html","title":"Tool Temp High","level":7,"position":753,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Hardware Status - 81: Sub-signals"],"content":"  Name in SoftPLC: CHANNEL_HW_STATUS_TOOL_TEMP_HIGH      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"16423798411","fileName":"16423798411.html","title":"Torque Transducer Error","level":7,"position":754,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync","StepSync Signals","Output Signals: Sub-signals","Channel Hardware Status - 81: Sub-signals"],"content":"  Name in SoftPLC: CHANNEL_HW_STATUS_TORQUE_TRANSDUCER_ERROR      Value Type  Size Min [bit]  Size Max [bit]    Boolean  1  1"},{"id":"21933928203","fileName":"21933928203.html","title":"Tool Box for StepSync","level":4,"position":755,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync"],"content":" Controllers   There are two types of controllers:  PF6000\/PF8 Sync Reference  PF6000\/PF8 Sync Member A maximum of 63 Sync Member controllers can be added to a hardware layout configuration. The Sync Reference controller is always the first, the Sync Member controllers and tools need to be added after this. Tool Box The Tool Box contains the two controller types and all the tools which are supported. There is a drop-down list to be able to filter on specific tool types. Only the supported tools, seen in the table below, can be added to the Hardware Layout Configuration from the Tool Box. Unsupported tools connected to a StepSync controller will be displayed with a Tool not supportedicon in the Hardware Layout Configuration. These tools will be shown in ToolsTalk 2 in their current position within the StepSync configuration and this position cannot be changed in the Hardware Layout Configuration workspace. If the unsupported tool is deleted from this workspace, the user can Pushthe configuration to the controller to add the tool before continuing with the Hardware Layout Configuration setup. The tools can only be added to a controller that doesn't already have a tool connected.        Tool Family   Supported Models   Tensor STR  ETV, ETD, ETP   Tensor ST  ETV, ETD, ETP   Tensor SL  ETV, ETD, ETP, ETF   Tensor SR  ETV, ETD, ETP   QST  All (Excluding Dual Transducer - CTT, CTA, CTTA) "},{"id":"10096767371","fileName":"10096767371.html","title":"StepSync CAN Accessories","level":4,"position":756,"hasContent":true,"hierarchy":["Configuration","Working with the Controller Tab","StepSync"],"content":" The following CAN accessories are supported by a Power Focus 6000 StepSync system:   Internal I\/O  I\/O Expander  Operator Panel  Stack light  Indicator box These accessories can only be connected to the Sync Reference. No accessories can be connected to Sync Members."},{"id":"13446476427","fileName":"1344647642723858563467.html","title":"Working with the Settings Tab","level":2,"position":757,"hasContent":true,"hierarchy":["Configuration"],"content":" Product Essentials Tutorials  https:\/\/www.youtube.com\/watch?v=-nkc9mmzoBo "},{"id":"59016587","fileName":"5901658723858569867.html","title":"Configuration of the Network","level":3,"position":758,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab"],"content":" The POWER FOCUS 6000can be set up to be accessed from the Atlas Copco software ToolsTalk or from a web browser on a Local Area Network (LAN). It can also be accessed directly from a connected PC. It uses the IPv4 protocol.  To access and alter the Ethernet settings, select Edit.  Only the Factory Ethernet port can be configured. The Service Ethernet port has a designated IP address, 169.254.1.1, that must not be connected to the local network.  "},{"id":"59019403","fileName":"59019403.html","title":"Accessing the Controller On Lan","level":4,"position":759,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab","Configuration of the Network"],"content":" Select the Settingsmenu, and click on Editto access the Factory Ethernet port window. There you can alter the Ethernet settings. Connect the network cable to the Factory Ethernet port and then either manually specify the required information or, if available, use the information provided by the DHCP server. Required information is:    IP address  Subnet mask  Gateway This information is provided by the local system administrator. When using the manual option there are optional settings available for the use of DNS servers.  "},{"id":"59022475","fileName":"59022475.html","title":"Accessing the Controller Through a Web GUI","level":4,"position":760,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab","Configuration of the Network"],"content":" Connect the PC with a straight-through Ethernet cable (RJ45) to the Service Ethernet port. Access the controller with the IP address from a web browser."},{"id":"18725177995","fileName":"18725177995.html","title":"Configuring the Firewall","level":4,"position":761,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab","Configuration of the Network"],"content":" The controller can be set up to use a firewall. The firewall is based on the trusted host principle, and only allows incoming connections via enabled ports or white-listed addresses.  By default, the firewall is disabled.  The firewall applies only to incoming connections on the Factory Ethernet Port. Activating and configuring the firewall    In the Home view, select Settings.  Select Networkin the left panel.  In the right panel, scroll down to Firewall.  Select Editand set the Firewallto On. The Port Filtering (layer 4 firewall) and all its predefined filters are enabled by default.  Configure the settings for the different firewall layers by setting services to On\/Off or manually enter addresses.    Port filtering (layer 4 firewall): To open and specify reachable services through the firewall.   IP Filtering (layer 3 firewall): To specify a trusted host by IP on the network that can access all the services.   MAC Filtering (layer 2 firewall): To specify a trusted host by MAC.  When no firewall layer is enabled, all incoming connections are let through. Port Filtering (Layer 4 Firewall) When the Port Filtering (Layer 4 Firewall)is set to ON, the firewall filter packets based on destination port. Packets sent to an open port are accepted immediately. Non-matching packets are also processed by the other firewall types, IP Filtering and MAC Filtering, before being accepted or rejected. When the Port Filtering (Layer 4 Firewall)is OFF, the port filtering is disabled and all other options hidden. Predefined service have their own enable switches:   Open ports for web (TCP 80, TCP 8080)  Open ports for SSH and SFTP (TCP 22)  Open ports for wireless tools (UDP 6677, TCP 6678)  Open ports for accessories (TCP 25000)  Additional TCP ports  Additional UDP ports      Predefined service  Description    Open ports for IxB Connect (default 62000, configurable)  Port required for connection IxB Connect tools over factory network to the controller. IxB Connect requires a configured \"base port\" + 1 port\/connected tool. 3 tools => 62000 - 62003.   Open ports for web (TCP 80, TCP 8080)  Ports required for web services so the controller is accessible over the factory network.  Setting Open ports for web (TCP 80, TCP 8080)to Off, triggers a warning that the connection with the Web HMI can be lost.   Open ports for SSH and SFTP (TCP 22)  Port required for SSH and SFTP functionality on the Factory Ethernet Port.   Open ports for wireless tools (UDP 6677, TCP 6678)  Ports required for wireless tools to connect to the controller over the factory network.   Open ports for accessories (TCP 25000)  Ports required for accessories to communicate with the controller over the factory network. This applies to Socket Selector 6.   Open additional TCP ports  Accepted are both comma-separated ports and port ranges using a dash (-). Example: when entering 1,2,3,4-10, all ports between 1 and 10 are opened.  Invalid port entries trigger an immediate pop-up warning.  Ports are automatically sorted after selecting the Applybutton.   Open additional UDP ports To use Open Protocol, add the port numbers manually in the Open additional TCP portsentry box. For example: 4545,4546,4547(depends on the ports configured in Virtual Station > Virtual Station 1 > Protocols > Open Protocol > Server Port). To use NTP server, add port 123manually in the Open additional UDP portsentry box.  Multiple ports are added by using comma separation. Port ranges are added by using a dash. IP Filtering (layer 3 firewall) To specify trusted host or networks in the IP Filtering (layer 3 firewall), enter their IP addresses in the IP White Listentry box. To access the entry box, set the switch to On. Accepted entries are lists of IP addresses or network addresses as IP tables, that is, host IP addresses or network IP addresses. The network mask can be entered as mask length (for example, \/24) or as a network IP address (for example, \/255.255.255.0). Packets coming from a white-listed IP address are immediately allowed. Other packets are screened by the other firewall layers (Port Filtering and MAC Filtering).  IP address white-list example  Due to security issues, entering host names or network names is not accepted.  Note that processes like NATing (Network Address Translation) may change source IP addresses. Consult your local network administrator when white-listing a host based on source IP address is required. MAC Filtering (layer 2 firewall)  MAC Filtering (layer 2 firewall)allows specifying trusted hosts or networks by entering their MAC addresses in the MAC White Listentry box. To access the entry box, set the switch to On. Accepted entries are comma-separated lists of MAC addresses. Packets coming from a white-listed MAC address are immediately allowed. Other packets are screened by the other firewall layers (Port Filtering and IP Filtering).  MAC address white-list example  Invalid entries trigger an immediate pop-up warning.  Note that routing may change source MAC addresses. Consult your local network administrator when white-listing a host based on source MAC address is required. Packet counters To display the Firewall statistics for each firewall layer, select Settings > Network > Firewall > Packet Counters. The Updatesection includes the following buttons:    Refresh: used to refresh the displayed packet counters.   Reset: used to reset the packet counters to zero.  Both buttons has a switch that automatically resets itself to the original position after the action is done.  The Accepted Packet Counterssection displays the counters for each of the firewall types and for rejected packets.   Port Filtering: displays the packet counter for packets accepted by the Port Filtering firewall type.   IP Filtering: displays the packet counter for packets accepted by the IP Filtering firewall type.   MAC Filtering: displays the packet counter for packets accepted by the MAC Filtering firewall type.   Rejected: displays the packet counter for packet that were rejected.  The packets accepted, and thus counted, by the Port, IP and MAC Filtering rules only include the initial packets that establish a connection. The Rejected packets are all counted and displayed. Firewall status The status of the general firewall feature and its firewall layers is shown in the Firewallmain view directly under Settings > Network.      Status  Description    OK  The firewall is enabled and the firewall configuration is applied.   Disabled  The firewall is disabled and the firewall configuration is not applied.   Configuration Error  The firewall is enabled, but the firewall configuration is not applied due to an internal error.  For safety reasons, the fail-open policy is applied, meaning all connections are allowed through. When the general firewall status is OK, the status ( Enabled\/ Disabled) for the respective firewall layers is also shown.   "},{"id":"59089419","fileName":"5908941923858576267.html","title":"Configuration of the Protocol","level":3,"position":762,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab"],"content":" The POWER FOCUS 6000can be set up to communicate with servers running an Atlas Copco license manager as well as the two Atlas Copco softwares ToolsTalk and ToolsNet. ToolsTalk is used to configure one or several controllers. ToolsNet is used to handle result reporting.   "},{"id":"59092747","fileName":"59092747.html","title":"Configuring the ToolsTalk Connection","level":4,"position":763,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab","Configuration of the Protocol"],"content":" To connect a controller to ToolsTalk, configure and activate the ToolsTalk protocol settings on the controller.    On the Homeview, select the SettingsTab. Then, on the left, select Server Connections.  In the ToolsTalkwindow, set the following parameters:      Field  Description     On\/Off  Enables\/Disables communication with the ToolsTalk server    Server port  ToolsTalk server port    Server host  ToolsTalk server IP address  Select Apply.  To view the ToolsTalk connection status, select the Resultsicon and go to the Live Resultsview. Then, select thebutton. In the appearing dialog box, select the Server connectionstab. For information on how to configure ToolsTalk, refer to the ToolsTalk 2 User Guide.  "},{"id":"59095819","fileName":"59095819.html","title":"Configuring the ToolsNet Connection","level":4,"position":764,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab","Configuration of the Protocol"],"content":" To connect a controller to ToolsNet and collect tightening results, configure and activate the ToolsNet protocol settings on the controller.    On the Homeview, select the SettingsTab. Then, on the left, select Server Connections.  In the ToolsNetwindow, set the following parameters:      Field  Description     On\/Off  Enables\/Disables communication with the ToolsNet server    Server port  ToolsNet server port    Server host  ToolsNet server IP address  Select Apply.  To view the ToolsNet connection status, select the Resultsicon and go to the Live Resultsview. Then, select thebutton. In the appearing dialog box, select the Server connectionstab. For information on how to configure ToolsNet, refer to the ToolsNet 8 User Guide.  "},{"id":"3243807499","fileName":"3243807499.html","title":"Configuring a License Manager","level":4,"position":765,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab","Configuration of the Protocol"],"content":" The Atlas Copco license manager is connected to a controller and the protocol settings are activated on the controller from the Server connectionstab in the Settingsmenu.      Field  Description    On\/Off  Enables\/Disables communication with the Atlas Copco license manager.   Server host  Atlas Copco license manager server IP address   Server port  Atlas Copco license manager server port"},{"id":"20852486283","fileName":"20852486283.html","title":"Configuring the Remote Logging Connection","level":4,"position":766,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab","Configuration of the Protocol"],"content":" To connect a controller to a remote logging server, configure and activate the remote logging settings on the controller.    On the home view, go to the Settingstab and select Server connectionson the left pane.  On the Remote Loggingwindow, configure the following parameters:      Field  Description     On\/Off  Enables\/Disables communication with the remote logging server    TCP\/UDP  Selects TCP or UDP protocol    Server host  Remote logging server IP address    Server port  Remote logging server port Configure Log Levels To configure the logs that are stored on the remote logging server:    On the home view, go to the Settingstab and select Server connectionson the left pane.  On the Remote Loggingwindow, select Configure.  On the Configure Facilitieswindow, select the applicable checkboxes.      Category  SysLog classification    Error  Alert, Critical, Emergency, Error   Warning  Warning   Info  Informational, Notice  To restore the selection to the previous configuration, select UNDO.  Select Apply."},{"id":"23115572491","fileName":"23115572491.html","title":"Configuration of IxB Connect","level":3,"position":767,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab"],"content":"    On the home view, go to the Settingstab and select IxB Connect.  Set up a communication port for the IxB tool or use the default port value 62000."},{"id":"59143819","fileName":"5914381923858582667.html","title":"Configuration of the Preferences","level":3,"position":768,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab"],"content":" Preferences contains general settings such as date and time, language, torque unit, and startup screen.   "},{"id":"59146635","fileName":"59146635.html","title":"Configuring the Date and Time","level":4,"position":769,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab","Configuration of the Preferences"],"content":" Date and time must be set in order for events and results to get the correct time stamp for when they occurred.  9007201068760971  The time is retrieved from one of three available sources:   Manual   NTP   ToolsNet When the source is set to Manualthe date, time, and time zone are set manually. When the source is set to NTP, the date and time is retrieved from an NTP server defined in the GUI. When the source is set to ToolsNet, the date and time is retrieved fron the ToolsNet server.  Parameters to set date and time     Field  Description    Source  Source to retrieve the time from.   Date  Date entered manually if the source is set to manual.   Time  Time entered manually if the source is set to manual.   Time zone  The time zone; either the location or a standard time zone such as UTC (coordinated universal time)   NTP Server  IP-address of an NTP server providing date and time for the controller.  "},{"id":"59149707","fileName":"59149707.html","title":"Configuring the Displayed Controller Language","level":4,"position":770,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab","Configuration of the Preferences"],"content":" The controller GUI is translated into twelve languages. To change the language of the GUI:    Tap or click on the arrow beside the name of the language currently in use.  Choose a language from the list. The language change will take effect immediately.  Available GUI languages     Language  As displayed in controller    English  English   Czech  Čeština   German  Deutsch   Spanish  Español   French  Français   Korean  한국어   Italian  Italiano   Japanese  日本語   Portuguese  Português   Russian  Русский   Swedish  Svenska   Chinese  中文"},{"id":"59152779","fileName":"59152779.html","title":"Configuring the Displayed Torque Unit","level":4,"position":771,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab","Configuration of the Preferences"],"content":" Choose the unit to use for torque values and results. Torque results are displayed in the chosen unit both after a tightening is performed and when stored in the results list. To change the torque unit used in the controller GUI:    Tap or click on the arrow beside the name of the unit currently in use.  Choose a unit from the list. The torque unit change will take effect immediately.  Available torque units     Unit  Description    cNm  centinewton metre   dNm  decinewton metre   Nm  newton metre   kNm  kilonewton metre   in·lbf  inch-pound force   ft·lbf  foot-pound force   in·ozf  inch ounce-force   ft·ozf  foot ounce-force   gf·cm  gram-force centimetre   kgf·cm  kilogram-force centimetre   kgf·m  kilogram-force metre"},{"id":"2315908235","fileName":"2315908235.html","title":"Configuring the Startup Screen","level":4,"position":772,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab","Configuration of the Preferences"],"content":" The default screen at startup of the controller is the Home screen. It is possible to change startup screen to the Result screen. A change of startup screen in the settings requires a restart of the controller or a refresh of the web GUI."},{"id":"60266507","fileName":"6026650723858595467.html","title":"Configuration of the PIN Settings","level":3,"position":773,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab"],"content":" The PIN code prevents unauthorized usage of the controller or accidental changes. If enabled, a PIN code is required when accessing the controller either from the controller-GUI or Web-GUI. "},{"id":"60269835","fileName":"60269835.html","title":"Configuring the PIN","level":4,"position":774,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab","Configuration of the PIN Settings"],"content":" It is possible to have one or many different PIN configurations on the controller. Users can decide whether or not to activate one or several PIN configurations at the same time. Each PIN configuration has a PIN code, a user name, a switch for enabling or disabling the user\/PIN, and a list of available configurations that the user can access. When PIN is enabled and the screen is locked, a locked padlock icon is shown at the upper-right corner of the GUI. The user can access and make changes only to the selected configuration(s) without entering any PIN code, and browse the unselected configurations with read-only access only. The unselected configurations are greyed out or disabled. The screen lock goes automatically on after a certain time of inactivity, configurable by the user. The minimum value of the inactivity time is 20 sec and the maximum value is 600 sec. The inactivity time is configurable and applies to all PIN configurations. After a system startup, the controller is locked if the PIN is turned on, regardless of the current inactivity time.  The users and PIN configured apply also to the Service Port (169.254.1.1). To enable PIN protection on the Service Port, in the PINwindows, set Use PIN for Service Portto On. Each controller can configure up to 10 users. The PIN of each configuration has to be unique. It is required to have at least one configuration to enable the PIN functionality on the controller. The PIN can be configured from the Embedded controller-GUI, Web-based controller-GUI or Tools Talk 2. Adding New Users    On the Homeview, select the SettingsTab. Then, on the left, select PIN.  In the PINwindow, select Configure.  Select the Plusicon at the upper-right corner of the GUI. The PIN-Userswindow shows the new user. If there are not users stored in the controller, the new user is the first and only one in the list; if there are existing users stored in the controller, the new user is the last of the list.  Select the new user. The Userwindow appears. Enter the Name and the PIN of the new user, and then confirm the PIN.  The User Name must be unique. The Nametext box can be 1 to 32 characters long.  The PIN code must have 4 digits in length (numbers 1 through 9).  Enter PINbox and Confirm PINbox need to match for the changes to be applied. By default, dots are indicated in both the text box, but these are just placeholders and need to be replaced with actual PIN codes.  Select Permissions. The list of the available configurations appears. Select the check box at the left of the necessary configuration(s) the user can access and make changes. After selecting the necessary configuration(s), select OK. The Userwindow appears.   Select allselects all the available configurations at the same time. Select Deselect allto clear the check boxes and undo the selection.  The user can access and make changes only to the configuration(s) selected in the Permissionswindow, and browse the unselected configurations with read-only access. For the unselected configurations, no changes are allowed.  In the Userwindow, select Apply. Enabling Users    On the Homeview, select the SettingsTab. Then, on the left, select PIN.  In the PINwindow, select Configure.  In the PIN-Userswindow, select the check box at the left of the user name to be enabled.  PIN can also be enabled by clicking on the user name and setting - in the Userwindow - the Enabledswitch to On. Activating the PIN configuration    On the Homeview, select the SettingsTab. Then, on the left, select PIN.  In the PINwindow, select Configure.  In the PIN-activatingwindow, set the PIN Codeswitch to On.  The PIN can only be activated when at least one user\/PIN is enabled. If no user\/PIN is enabled, a Warningpop-up window appears.  Enter the Inactivity Timeout(in seconds), that defines the slot of time after which the screen is automatically locked up.  Default value for Inactivity Timeout is 120 seconds: this is a global setting, and cannot be set on a per user basis. Unlocking the controller-GUI or Web-GUI    On the Homeview, select the Padlock icon at the upper-right corner of the GUI. A pop-up window with a numeric keypad appears.  Enter the configured PIN code and select OK.  When the PIN is enabled and the screen has been unlocked, an Open Padlockicon appears at the upper-right corner of the GUI. The controller-GUI or Web-GUI can be locked again manually, by selecting the Open Padlockicon. Disabling Users    On the Homeview, select the SettingsTab. Then, on the left, select PIN.  In the PIN window, select Configure.  In the PIN-Userswindow, deselect the check box at the left of the user name to be disabled.  PIN can also be disabled by clicking on the user name and setting - in the Userwindow - the Enabledswitch to Off. Deleting Users    On the Homeview, select the SettingsTab. Then, on the left, select PIN.  In the PIN window, select Configure.  In the PIN-Userswindow, select the Deleteicon at the right of the user name to be deleted.  If the Useris removed, also the PINis deleted. It is not possible to access any configuration through the deleted PIN."},{"id":"67493259","fileName":"67493259.html","title":"Configuration of the Tool Alarms","level":3,"position":775,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab"],"content":" Alarms are set to control when to perform maintenance or calibration on the tools connected to the controller. The tool service interval and other information are found in the tool view on the Toolmenu.  Different tool alarms     Field  Description     Service indicator alarm  Enables an alarm for when the service interval for the tool is reached.    Tool lock after alarm  Lock the tool when the service interval is reached.    Calibration alarm  Enables the tool calibration alarm for all tools connected to the controller."},{"id":"24515912075","fileName":"24515912075.html","title":"Configuration of the Wireless Settings","level":3,"position":776,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab"],"content":" The Wireless settings in the controller activates the use of a WLAN and Bluetooth.    In the Settingsmenu, select the Wirelesstab.  Depending on the tool (WLAN-equipped tools are marked IRC-W, while Bluetooth-equipped tools are marked IRC-B), set Enabledto On. Note that \"Short range\/distance\" means better transmission speed but can be more sensitive to distance from controller and \"Long range\/distance\" means less transmission speed but increased tolerance to distance and disturbance.   IxB Connect mode: When switching from ONto OFFall previously paired tools will be un-paired and the tools need to be paired again before use.  OFF: Users can have both old Bluetooth tools like STB and IxB Connect tools connected at the same time via Bluetooth. On: Users can only have IxB Connect tool connected via Bluetooth."},{"id":"11270087947","fileName":"11270087947.html","title":"Configuration of BCP\/BCV-RE Tools","level":3,"position":777,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab"],"content":" The process for connecting BCV and BCP tools to the controller is slightly different than for other types of tools.    On the Home view, tap on the Settings Tab. Then, select BCP\/BCV-RE Connections.  Add a new BCP\/BCV-RE Connection configuration by clicking on the Plus (+)icon top right.  Turn on the configuration and provide a name in the name field.  Fill in the Server port and the Server host of the tool you want to connect in the respective fields. You can find both of these in the tool's Loader Software.  The tool should now be connected to the controller. Assign it to a Virtual Station in order to use it with a tightening program."},{"id":"82456971","fileName":"82456971.html","title":"Configurations of the Events Settings","level":3,"position":778,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab"],"content":" It is possible to configure the events available in the controller as either or several of:   Acknowledged  Logged  Displayed "},{"id":"81936907","fileName":"8193690723858589067.html","title":"Configuration of the Fieldbus","level":3,"position":779,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab"],"content":" The fieldbus section consists of information about the fieldbus type in use. This part is hardware dependent and read-only. The configuration section with general settings for the fieldbus in use is possible to edit. The fieldbus mapping and the assigning of fieldbus maps to virtual stations are done with ToolsTalk. For more information refer to the ToolsTalk configurations manual. "},{"id":"12235470219","fileName":"12235470219.html","title":"Creating a General Fieldbus Configuration","level":4,"position":780,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab","Configuration of the Fieldbus"],"content":" When a new fieldbus module is installed in the controller, General Fieldbus Configuration settings can be setup directly via the GUI, without the need of using ToolsTalk 2.  For configurations related to the fieldbus frame and connecting a fieldbus configuration to a Virtual Station, ToolsTalk 2 will still be needed.    Go to the Settingsmenu, and then select Fieldbus.  Select the Create Configbutton.  If no Fieldbus module is installed this button will not be visible.   Configure the following parameters:   Set by network: OFF\/ON   Read result handshake: OFF\/ON   Lock tool when fieldbus offline: OFF\/ON   Sync on task selected: OFF\/ON    OFF- Task changes made in the Virtual Station are ignored.   YES- Task changes made in the Virtual Station are synced with the Fieldbus module.   Depending on the installed module type, enter the Fieldbus communication specific settings:   IP Address   Subnet mask   Gateway  A new Configuration is created.  If a Fieldbus configuration already exists on the controller, this will have to be removed before creating a new configuration. When the configuration has been removed, instead of a Removebutton there will be a Create Configbutton."},{"id":"4426786187","fileName":"4426786187.html","title":"Configuration of the Results","level":3,"position":781,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab"],"content":" The Resultsmenu allows the user to configure the label names for results displayed in the Results list. Changing Result Status names    Go to Settings, then Results, and click on Customized detailed status.  Find the Status name you want to alter.  Write the new name in the corresponding field in the New status nameon the right."},{"id":"20729503115","fileName":"2072950311523858610827.html","title":"Configuration of the Extended Logging","level":3,"position":782,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab"],"content":" The POWER FOCUS 6000automatically creates logs and stores them. These logs can be configured to include extended logging using log groups. "},{"id":"20852493067","fileName":"20852493067.html","title":"Configuring the Log Groups","level":4,"position":783,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab","Configuration of the Extended Logging"],"content":" The default setting for a log group is off. To change the setting of a log group to on:    On the home view, go to the Settingstab and select Extended Loggingon the left pane.  On the Log Groupswindow, set the group to ON. Reset Log Groups It is possible to reset all log groups to their default settings.    On the home view, go to the Settingstab and select Extended Loggingon the left pane.  On the Reset Log Groupswindow, select Reset. A pop-up window appears asking if you want to reset all log groups. Select YES. Persistent Log Groups The log groups resets to their default setting at every reboot. To prevent resetting use persistent log groups.    On the home view, go to the Settingstab and select Extended Loggingon the left pane.  On the Keep Selection after Restartwindow, set Persistentto ON."},{"id":"18187766027","fileName":"1818776602723858602379.html","title":"Reset","level":3,"position":784,"hasContent":false,"hierarchy":["Configuration","Working with the Settings Tab"],"content":""},{"id":"4427638283","fileName":"4427638283.html","title":"Factory Reset Controller","level":4,"position":785,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab","Reset"],"content":" It is possible to undo the controller to the original factory settings.  All settings, events, configurations and historical data are deleted when the controller is reset. Do a factory reset only when you are completely sure that this is required. Performing a Controller Factory Reset    On the Homeview, select the SettingsTab. Then, on the left, select Reset.  In the Factory Reset Controllerwindow, select Reset. A pop-up window appears warning that all data will be deleted. Then, select Yes. The controller restarts to activate the new settings."},{"id":"18187772811","fileName":"18187772811.html","title":"Clear Results","level":4,"position":786,"hasContent":true,"hierarchy":["Configuration","Working with the Settings Tab","Reset"],"content":" It is possible to delete results and events stored on the controller. Deleting Results and Events    On the Homeview, select the SettingsTab. Then, on the left, select Reset.  In the Clear Resultswindow, select Clear. A pop-up window appears warning that all results and events will be deleted. Then, select Yes.  Turn off the controller and wait for 30 seconds before turning it on again."},{"id":"8850728587","fileName":"885072858723858198411.html","title":"Operation","level":1,"position":787,"hasContent":false,"hierarchy":[],"content":"  In this section, you can find step-by-step information about how to operate the product. "},{"id":"91553931","fileName":"9155393123858228107.html","title":"Remote Start and Emergency Stop","level":2,"position":788,"hasContent":false,"hierarchy":["Operation"],"content":""},{"id":"61941771","fileName":"6194177124670241291.html","title":"Remote Start Configuration","level":3,"position":789,"hasContent":true,"hierarchy":["Operation","Remote Start and Emergency Stop"],"content":" A tightening can be started remotely from an accessory in both single and multiple controller configurations. The switch to activate remote start is found on the connector panel located behind the front access door of the controller. Whenever using remote start you must enable an emergency stop solution for safety reasons. For more information about emergency stop, see Emergency stop (EM Stop) in the product instructions for POWER FOCUS 6000. When using a tool with some type of safety handle (such as a trigger start button or a safety lever), remote start must be disabled by setting the switch to Off. This is done to ensure that it is not possible to override the safety function within the tool. "},{"id":"61490955","fileName":"6149095523858235019.html","title":"Emergency Stop","level":3,"position":790,"hasContent":true,"hierarchy":["Operation","Remote Start and Emergency Stop"],"content":" The supply disconnecting device may serve as an emergency stop when it is readily accessible to the operator and it is of the type described in EN 60204-1:2006, 5.3.2 a), b), c) or d). When intended for such use, the supply disconnecting device shall be colored red and have a yellow background. (Ref. EN 60204-1:2006, 10.7.5). The POWER FOCUS 6000provides an infrastructure to build an Emergency Stop function with redundant breaking according to EN ISO 13849-1 category 3 PL d. The Emergency Stop function must be used when using remote start functionality. The Emergency Stop functionality can be used with a supply-disconnecting device (such as an Emergency Stop button). When the Emergency Stop button is activated, it breaks the supply voltage to the controller. A diagnose of the system is run automatically at the start of the controller. This is done both after an emergency stop and at a normal start. The Emergency Stop function is used with either a single controller or up to 10 controllers in a single emergency stop chain. In a multiple controller configuration, the Emergency Stop signal is distributed from the first controller to all interconnected controllers using the I\/O bus interface. The last controller in the chain returns a feedback signal to indicate that all controllers have received the Emergency Stop signal. The event Emergency Stopis displayed. For the Emergency Stop there is a 24V DC output through the Emergency Stop interface on the connector panel. "},{"id":"61507083","fileName":"6150708323858243467.html","title":"Cabling","level":4,"position":791,"hasContent":false,"hierarchy":["Operation","Remote Start and Emergency Stop","Emergency Stop"],"content":""},{"id":"61509131","fileName":"61509131.html","title":"Emergency Stop Button Cables","level":5,"position":792,"hasContent":true,"hierarchy":["Operation","Remote Start and Emergency Stop","Emergency Stop","Cabling"],"content":"  Cable dimensions for the emergency stop button     Single\/Multiple controllers  Dimension  Maximum length    Single  0.7 mm2cable  400 meters   Multiple  1.5 mm2cable  50 meters"},{"id":"61512203","fileName":"61512203.html","title":"I\/O Cables","level":5,"position":793,"hasContent":true,"hierarchy":["Operation","Remote Start and Emergency Stop","Emergency Stop","Cabling"],"content":" For connecting multiple controllers with I\/O cables distributing the emergency stop signal, observe the maximum length according to the following table:  Cable dimensions for I\/O cables     AWG 22 cable  Maximum total length    4 controllers  200 meters   5 controllers  140 meters   6 controllers  100 meters   8 controllers  70 meters   10 controller  50 meters"},{"id":"61515275","fileName":"6151527523858250379.html","title":"Pin Configurations for Emergency Stop","level":4,"position":794,"hasContent":true,"hierarchy":["Operation","Remote Start and Emergency Stop","Emergency Stop"],"content":" The Power Focus has an external EM Stop interface and I\/O bus on the connector panel located behind the front access door. The PIN configuration differs depending on whether it is a single or multiple controller solution. Furthermore, for the single controller, the PIN configuration differs depending on whether the controller is equipped with an EM Stop button or not. The following sections describe the available PINs on the connecting panel, and the use of the different PINs to connect an EM Stop button. "},{"id":"61518347","fileName":"61518347.html","title":"Single Controller with Emergency Stop Button","level":5,"position":795,"hasContent":true,"hierarchy":["Operation","Remote Start and Emergency Stop","Emergency Stop","Pin Configurations for Emergency Stop"],"content":" Connector: Phoenix, 6-pin Headers 3.5mm pitch      Use the following pins to attach an EM Stop button:    Pin   Use      1  Do not use   Connections for a single controller   2  Do not use   3  Attach an emergency button between pin 3 and pin 4   4  See pin 3   5  Attach an emergency button between pin 5 and pin 6   6  See pin 5   7  Connect a jumper between pin 7 and pin 8   8  See pin 7   9  Connect a jumper between pin 9 and pin 10   10  See pin 9  "},{"id":"61524235","fileName":"61524235.html","title":"Single Controller without Emergency Stop Button","level":5,"position":796,"hasContent":true,"hierarchy":["Operation","Remote Start and Emergency Stop","Emergency Stop","Pin Configurations for Emergency Stop"],"content":" Connector: Phoenix, 6-pin Headers 3.5mm pitch  Remote start switch must be set to OFF for this configuration      Use the following PIN configuration:    Pin  Use      1  Do not use   Connections with no EM stop   2  Do not use   3  Connect a jumper between pin 3 and pin 4   4  See pin 3   5  Connect a jumper between pin 5 and pin 6   6  See pin 5   7  Connect a jumper between pin 7 and pin 8   8  See pin 7   9  Connect a jumper between pin 9 and pin 10   10  See pin 9  "},{"id":"61526795","fileName":"6152679523858256779.html","title":"Multiple Controllers with Emergency Stop Buttons","level":5,"position":797,"hasContent":true,"hierarchy":["Operation","Remote Start and Emergency Stop","Emergency Stop","Pin Configurations for Emergency Stop"],"content":" The PIN configuration differs depending on the location of the controller in the EM Stop chain. "},{"id":"61529867","fileName":"61529867.html","title":"First Controller with an Emergency Stop Button Connected","level":6,"position":798,"hasContent":true,"hierarchy":["Operation","Remote Start and Emergency Stop","Emergency Stop","Pin Configurations for Emergency Stop","Multiple Controllers with Emergency Stop Buttons"],"content":" EM Stop button connector: Phoenix, 6-pin Headers 3.5mm pitch EM Stop I\/O cable connector: Molex Micro-Fit, 5-pin      Use the following pin configuration:    Pin   Use      1  Do not use   Connections for the first controller   2  Do not use   3  Attach an emergency button between pin 3 and pin 4   4  See pin 3   5  Attach an emergency button between pin 5 and pin 6   6  See pin 5   7  Connect a jumper between pin 7 and pin 8   8  See pin 7   9  Do not use   10  Do not use    "},{"id":"61532427","fileName":"61532427.html","title":"Controllers Between First and Last","level":6,"position":799,"hasContent":true,"hierarchy":["Operation","Remote Start and Emergency Stop","Emergency Stop","Pin Configurations for Emergency Stop","Multiple Controllers with Emergency Stop Buttons"],"content":" EM Stop I\/O cable connector: Molex Micro-Fit, 5-pin Remove plug or use the following pin configuration:       Pin  Use      1  Do not use   Connections for middle controllers   2  Do not use   3  Do not use   4  Do not use   5  Do not use   6  Do not use   7  Do not use   8  Do not use   9  Do not use   10  Do not use    "},{"id":"61534987","fileName":"61534987.html","title":"Last Controller","level":6,"position":800,"hasContent":true,"hierarchy":["Operation","Remote Start and Emergency Stop","Emergency Stop","Pin Configurations for Emergency Stop","Multiple Controllers with Emergency Stop Buttons"],"content":" EM Stop I\/O cable connector: Molex Micro-Fit, 5-pin      Use the following pin configuration:    Pin   Use      1  Do not use   Connections for last controller   2  Do not use   3  Do not use   4  Do not use   5  Do not use   6  Do not use   7  Do not use   8  Do not use   9  Connect a jumper between pin 9 and pin 10   10  See pin 9  "},{"id":"92146315","fileName":"9214631523858207883.html","title":"DIG IN\/OUT Connectors","level":2,"position":801,"hasContent":true,"hierarchy":["Operation"],"content":" The POWER FOCUS 6000uses the same hardware accessories (Stacklight, Operator panel etc.) as the Power Focus 4000 system. However, the digital input and output connectors are configured differently and use a different plug. In order to rewire the plug from Power Focus 4000 to POWER FOCUS 6000correctly, use the connector descriptions in the following sections. "},{"id":"67640587","fileName":"6764058723858214283.html","title":"Digital Output Connectors","level":3,"position":802,"hasContent":true,"hierarchy":["Operation","DIG IN\/OUT Connectors"],"content":" The POWER FOCUS 6000has a connector with four configurable internal digital outputs (DIG OUT) that are located behind the front access door. "},{"id":"67643915","fileName":"67643915.html","title":"Digital Output Connector for Power Focus 6000 \/ Power Focus 8","level":4,"position":803,"hasContent":true,"hierarchy":["Operation","DIG IN\/OUT Connectors","Digital Output Connectors"],"content":"       Pin   Relay   Function      1    Normally closed   Connectors for output   2  Relay 1  Common   3   Normally open   4    Normally closed   5  Relay 2  Common   6   Normally open   7    Normally closed   8  Relay 3  Common   9   Normally open   10    Normally closed   11  Relay 4  Common   12   Normally open         "},{"id":"67646475","fileName":"67646475.html","title":"Digital Output Connector for Power Focus 4000","level":4,"position":804,"hasContent":true,"hierarchy":["Operation","DIG IN\/OUT Connectors","Digital Output Connectors"],"content":"       Pin   Relay   Function      12    Normally closed   Connectors for output   11  Relay 4  Common   10   Normally open   9    Normally closed   8  Relay 3  Common   7   Normally open   6    Normally closed   5  Relay 2  Common   4   Normally open   3    Normally closed   2  Relay 1  Common   1   Normally open         "},{"id":"67585419","fileName":"6758541923858221195.html","title":"Digital Input Connectors","level":3,"position":805,"hasContent":true,"hierarchy":["Operation","DIG IN\/OUT Connectors"],"content":" The POWER FOCUS 6000has a connector with four configurable internal digital inputs (DIG IN) that are located behind the front access door. "},{"id":"67588747","fileName":"67588747.html","title":"Digital Input Connector for Power Focus 6000 \/ Power Focus 8","level":4,"position":806,"hasContent":true,"hierarchy":["Operation","DIG IN\/OUT Connectors","Digital Input Connectors"],"content":"       Pin   Function      13  24V     14  24V   15  0V   16  0V   17  0V   18  Digital input -   19  Digital input 1 +   20  Digital input 2 +   21  Digital input 3 +   22  Digital input 4 +  "},{"id":"67591307","fileName":"67591307.html","title":"Digital Input Connector for Power Focus 4000","level":4,"position":807,"hasContent":true,"hierarchy":["Operation","DIG IN\/OUT Connectors","Digital Input Connectors"],"content":"       Pin   Function      22  GND (+24VDC isolated)     21  +24VDC isolated   20  Digital input 4 -   19  Digital input 4 +   18  Digital input 3 -   17  Digital input 3 +   16  Digital input 2 -   15  Digital input 2 +   14  Digital input 1 -   13  Digital input 1 +  "},{"id":"8850730123","fileName":"885073012323858263179.html","title":"Reports and Statistics","level":1,"position":808,"hasContent":false,"hierarchy":[],"content":"  In this section, you can learn about available reports and statistics. "},{"id":"17846137227","fileName":"1784613722723858272651.html","title":"Working with the Reports Tab","level":2,"position":809,"hasContent":false,"hierarchy":["Reports and Statistics"],"content":""},{"id":"92128267","fileName":"9212826723858292363.html","title":"Results","level":3,"position":810,"hasContent":true,"hierarchy":["Reports and Statistics","Working with the Reports Tab"],"content":" This section describes how to access tightening results on the POWER FOCUS 6000controller and how to read the information given in the different result views. It describes both the live results view available after each tightening and the historical results view available in Resultson the Reportsmenu. When a tightening is performed, the results are stored on the controller. Results can also be sent to an external system such as ToolsNet or exported for analysis using the export function. "},{"id":"67351435","fileName":"6735143523858299275.html","title":"Live Results","level":4,"position":811,"hasContent":true,"hierarchy":["Reports and Statistics","Working with the Reports Tab","Results"],"content":" The Live Resultspop up window shows results from the different virtual stations on the controller in the upper four as well as the lower four panes. The reason for this is that you can choose two different result views for the same virtual station to be shown at the same time. Select a result pane to open a window where you can step through the different result views by clicking the arrows at the side of the result window. Result View - Numbers The first window will display the result in numbers.       A  Virtual station name   B  Batch sequence name   C  Batches in sequence   An OK batch is colored green.  An ongoing batch is colored yellow.  An NOK batch is colored red.   D  Tightenings in batch   An OK tightening is colored green.  An ongoing tightening is colored yellow.  An NOK tightening is colored red.   E  Result status An NOK tightening will give a detailed status of the unsuccessful tightening.   F  Target torque\/angle   G  Tightening program name   H  Number of completed batches in sequence   J  Number of completed tightenings in a batch   K  Tightening result Result View - High-Low Result The graphic display shows whether the result is high, low or within the set limits.       A  Graphic display showing if the tightening result is too high or too low with respect to the given limits for the tightening program. Torque value.   B  Result status   C  Angle value  If the tightening is NOK, a detailed reason will be given. Result View - Extensive Results The extensive results views will display some additional tightening results.  The second view always shows the identifiers (VIN). If the first screen is already full with parameters, the rest of the parameters are shown on the second screen.  Result View - Identifier Strings This result view shows the identifier strings included in a multiple barcode scan.  Result View - Trace With the trace result view, one can learn better how the tightening behaves, in order to make adjustments to the tightening program. Depending on the tightening strategy, the trace will display different tightening parameters. The trace result is available as two different graphs: torque\/time and torque\/angle. Result View - Result Reporter The list shows the values from the result reporters. If there is a result reporter defined for a program monitor\/restriction, the value from that monitor\/restriction is reported. If there is no result reporter defined for a program monitor\/restriction, the value from the latest executed result reporter in main path is reported.   Evaluation order if several reporters of the same type are defined in a program:   result reporter on program monitor\/program restriction.  result reporter on monitor\/restriction of the last executed step in main path.  Values on the highest level of the multistep result set by the corresponding result reporter:  final angle set by result reporter final angle  final torque set by result reporter final torque  current set by result reporter current      "},{"id":"18305368843","fileName":"18305368843.html","title":"Viewing Protocol Status","level":5,"position":812,"hasContent":true,"hierarchy":["Reports and Statistics","Working with the Reports Tab","Results","Live Results"],"content":"    On the Homeview, select the Resultsicon and go to the Live Resultsview.  At the upper-right corner, select thebutton. The Protocol Statusdialog box appears.  The tabs in the dialog box show the following information:      Tab  Description     Open Protocol  Shows the status of the open protocol connection: OK \/ NOK    Server Connections  Shows the status of the connections to ToolsTalkand ToolsNetservers: OK \/ NOK  To change the configuration setting Enabled \/ Disabled, go to Settings > Server Connectionsand select the server to configure.    Launcher Status  Shows the launcher status of the different system adapters: OK \/ NOK  Select Close.  "},{"id":"67474571","fileName":"6747457123858305675.html","title":"Stored Results","level":4,"position":813,"hasContent":true,"hierarchy":["Reports and Statistics","Working with the Reports Tab","Results"],"content":" The controller stores the result for every tightening or loosening performed. Showing Stored Results    On the Homeview, select the ReportsTab. On the left side, Resultsis automatically selected.  In the Resultswindow, select View all results. The results list shows with the following information:    Date: date and time of the tightening performed.   Virtual Station: Virtual Station which the tightening was performed with.   Tightening Program: Tightening Program column shows Multistep Tightening Program name, or Batch Sequence name followed by the Tightening Program name within the Batch Sequence.   Result: Torque \/ Angle result.   Limits: Limits column shows values only when the user sets Step Monitor or Step Restriction, or Program Monitor or Program Restrictions. Step Monitors, Step Restrictions, Program Monitors and Program Restrictions are applicable for Final Torque and Final Angle.   Details: Tightening \/ loosening result details.   Trace checkbox: By selecting a trace checkbox the corresponding result will be shown in the Sync traceresult view.  In the Limitscolumn, the minimum \/ maximum value can be red colored. In this case, the red colored value means that any of the following has occurred:   The measured value is lower than the minimum value set in the Multistep Program.  The measured value is higher than the maximum value set in the Tightening Program. Showing and Reading Result Traces    On the Home view, select the ReportsTab. On the left side, Resultsis automatically selected.  In the Resultswindow, select View all results. The results list shows in the Resultswindow.  Select the necessary result. The tightening trace shows in the Trace Result Viewwindow.  Trace Result Viewwindow shows, step by step, the tightening life-cycle. When the tightening is NOK, Trace Result Viewwindow shows which Step Monitor or Step Restriction caused it. On the trace graph, the Step Monitor or Step Restriction that caused the NOK tightening in the Step level, is red colored.  On the upper-right corner of the trace graph, select the left-arrow \/ right-arrow to show the necessary trace graph. The following trace graphs are available:   Torque \/ Time  Torque \/ Angle  Angle \/ Time  Speed \/ Time  Speed \/ Angle  Gradient \/ Time (when the tightening program is configured to make a gradient trace)  Gradient \/ Angle (when the tightening program is configured to make a gradient trace)  Current \/ Time  Current \/ Angle  Step lines are upon the trace graph. On the trace graph, it is possible to zoom in\/out, move the trace, and read x-axis and y-axis values on a specific point. On the lower-left corner of the trace graph, select \"+\" to zoom in , \"-\" to zoom out, or the \"square icon\" to reset the zoom level back to the default view. On the lower part of the Trace Result Viewwindow, select the necessary step to open a pop up window with the detailed step information.  "},{"id":"18314076555","fileName":"18314076555.html","title":"Viewing Synchronized Traces","level":5,"position":814,"hasContent":true,"hierarchy":["Reports and Statistics","Working with the Reports Tab","Results","Stored Results"],"content":"  Synchronizing traces older than software version 3.5 is not supported.    On the Homeview, select the ReportsTab. On the left side, Resultsis automatically selected.  In the Resultswindow, select View all results.  Select the traces to compare by marking theicon of the corresponding results. A selected trace icon turns blue.  Up to 10 traces can be selected.  Results without theicon do not support synchronization.  Select theicon in the upper right hand corner, to open the sync trace view. When selecting theicon all selected result traces will be unchecked.  In the Sync Trace Result View, select the preferred Sync methodfrom the drop-down list. Select the trace types with the arrows in the upper right hand corner. The Sync Trace Result Viewis shown below:       Position  Description     1  Select method to synchronize traces and display of current sync method.    2  Switch between available trace types. The following trace graphs are available:   Torque \/ Time  Torque \/ Angle  Angle \/ Time  Speed \/ Time  Speed \/ Angle  Gradient \/ Time (when the tightening program is configured to make a gradient trace)  Gradient \/ Angle (when the tightening program is configured to make a gradient trace)  Current \/ Time  Current \/ Angle    3  Zoom methods to examine sections of the traces in more detail. Select \"+\" to zoom in , \"-\" to zoom out, or the \"square icon\" to reset the zoom level back to the default view. It is also possible to zoom to a specific section by holding down the right mouse button, moving the mouse over a section, and release the right mouse button. The area inside the drawn rectangle defines the area to show.    4  Each result is represented by one tab, showing the time when the tightening was performed. An icon on the left of each tab reflects the outcome of the tightening:    Blue:Tightening successful   Red:Tightening failed   Exclamation mark:The trace cannot be shown in the diagram Clicking on the icon toggles between the following display settings for its trace:   Show trace only  Show trace and step dividers with available limits or restrictions  Hide trace    5  Change primary result trace. The primary result trace is used as reference and will define the values for the x-axis. Only one trace can be set as primary result. The first selected trace (the left-most tab) is by default used as reference.    6  Tightening details of currently selected result. Sync methods Sync methods are different strategies to synchronize traces by a specific value. Traces can be synchronized by, for example, peak torque (highest torque reached for each trace). This shifts all traces along the x-axis, until each curve has its peak torque value at the exact same position on the x-axis. All subsequent results are given an offset on the x-axis according to one of the following methods:      Sync method  Description     None  Default value. Selected traces are not synced.    Peak \/ Torque  Peak \/ Angle  Peak \/ Speed  Peak \/ Current  Peak \/ Gradient  All traces are synchronized towards the peak value, that is, shifted along the x-axis so that the peak values are at the same position on the x-axis as the peak value of the primary result.    Custom \/ Torque  Custom \/ Angle  Custom \/ Speed  Custom \/ Current  Custom \/ Gradient    All traces are synchronized towards a set value, shifted along the x-axis so that the set value are the same at the same position The set value of the primary result is used as reference point on the x-axis.  If sync method Customis selected and none of the traces contains the configured value, an exclamation mark is shown in the custom value field.  If a result has no trace value that matches to the sync method it cannot be synchronized and its trace will not be shown. It will instead be shown with an exclamation mark.   If none of the traces are possible to synchronize, the error message “Unable to synchronize”is shown.     "},{"id":"92164363","fileName":"9216436323858279051.html","title":"Events","level":3,"position":815,"hasContent":false,"hierarchy":["Reports and Statistics","Working with the Reports Tab"],"content":""},{"id":"67876875","fileName":"67876875.html","title":"Reading the Information Given in an Event","level":4,"position":816,"hasContent":true,"hierarchy":["Reports and Statistics","Working with the Reports Tab","Events"],"content":" An event contains information that describes the occurred event as well as some system information to help describe what has happened, where and when.  51399307      1   Heading- Describes what part of the system the event concerns.   2   Event name- A short descriptive text of the event.   3   Virtual station- If the event is related to a virtual station on the controller the virtual station name will be displayed.   4   Code- A unique four-digit number that identifies the event.   5   Module- Describes in what part of the system the event concerns.   6   Type- Information, Warning or Error.   7   Time- Date and time when the event occurred.  "},{"id":"67895563","fileName":"6789556323858285963.html","title":"Event Types","level":4,"position":817,"hasContent":true,"hierarchy":["Reports and Statistics","Working with the Reports Tab","Events"],"content":" Events are divided into three types; Information, Warningsor Errors. "},{"id":"67898891","fileName":"67898891.html","title":"Event Information","level":5,"position":818,"hasContent":true,"hierarchy":["Reports and Statistics","Working with the Reports Tab","Events","Event Types"],"content":" Information events signal a noteworthy event that has occurred from actions performed by the user or the system. Information events do not require any specific user actions.   "},{"id":"67901451","fileName":"67901451.html","title":"Event Warnings","level":5,"position":819,"hasContent":true,"hierarchy":["Reports and Statistics","Working with the Reports Tab","Events","Event Types"],"content":" Warning events signal a potentially serious condition that could affect the system performance or result in injury.   "},{"id":"67904011","fileName":"67904011.html","title":"Event Errors","level":5,"position":820,"hasContent":true,"hierarchy":["Reports and Statistics","Working with the Reports Tab","Events","Event Types"],"content":" Event Errors signal a serious condition, such as a failed service, that almost exclusively requires the user to make changes to the setup or the configuration in order to continue.   "},{"id":"67969163","fileName":"67969163.html","title":"Configuration of Events","level":4,"position":821,"hasContent":true,"hierarchy":["Reports and Statistics","Working with the Reports Tab","Events"],"content":" Each event has a default setting for whether they should be acknowledged (Ack), logged (Log) or displayed (Disp). These settings can be configured in Eventson the Settingsmenu.   Some options cannot be changed and they are greyed out.  "},{"id":"64568843","fileName":"64568843.html","title":"Event Codes","level":4,"position":822,"hasContent":true,"hierarchy":["Reports and Statistics","Working with the Reports Tab","Events"],"content":" Different types of events are used to notify the user of certain state changes or occurrences in the system. Each event requires a different action.  Some of the procedures described can only be performed by Atlas Copco Service personnel. For more information about a specific event code, use the below filters or enter the event code search criteria in the search box.       Event Code   Event Type   Event Name   Description   Procedure  Log \/ Display \/ Ack \/ Conf   Available for   Group     none   item   none   none   none   column   list   list   1000  Info  Controller Started  The controller is started.    Log  Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC PFHC  Controller and Tool   1001  Warning  Controller Serial Number Updated  Generated at start-up if IT-board box serial number (controller serial number) differs from AUX-board box serial number. AUX-board is considered to be non-replaceable in field. The controller will reboot when the serial number is updated.  Replace IT-board or box.  Log  Display  Ack Conf  Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller and Tool   1010  Info  Tool Connected  A tool is connected.   Log Display Conf  Flex Power Focus 6000 Power Focus 8 StepSync Power Focus XC PFHC  Controller and Tool   1011  Info  Tool Disconnected  A tool is disconnected.   Log Display Conf  Flex Power Focus 6000 Power Focus 8 StepSync Power Focus XC PFHC  Controller and Tool   1012  Info  Tool Rejected Controller Connection  This event can occur if the tool is into a skip-zone.  Verify if another controller is connected to the tool. Make sure that the tool settings are correctly set up.  Log Display Conf  Power Focus 6000 Power Focus 8 Power Focus XC  Controller and Tool   2000  Warning  Battery Low   Replace battery.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2001  Warning  Battery Empty   Replace battery.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2002  Warning  Tool Battery Health Low  Tool battery health problem is detected. Valid for SRB, TBP and IxB tools only.  Replace battery.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2004  Warning  Tool is not of the preferred type  Tool has been replaced by a tool with a different Tool Max Torque.  Change tool.  Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2006  Warning  Tool Backup Battery Health low  The backup battery in the tool has too poor performance.  The backup battery should be replaced.  Log Display Ack Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2007  Warning  Tool Backup Battery Missing  Tool backup battery is missing. Valid for SRB, TBP and IxB tools only.  Insert battery  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2008  Warning  Tool Backup Battery Error  Tool backup battery error detected. Valid for SRB, TBP and IxB tools only.  Replace battery.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2009  Warning  Backup Battery Voltage Low  The controller's backup battery is almost empty  Replace battery.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2010  Error  Tool Software Version Mismatch  Tool and controller software versions not compatible.  Service tool - update tool software.  Log Display Ack Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2012  Warning  Tool Communication Disturbance  Communication between tool and controller interrupted.  Relocate antenna placement.  Conf  Flex Power Focus 6000 Power Focus 8 StepSync Power Focus XC PFHC  Tool   2013  Warning  Illegal Ring Position  Tool direction switch in faulty position.  If occurring frequently - service the tool.  Log Display Conf  Flex Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2014  Warning  Tool Overheated  Tool overheated. Valid for SRB, TBP and IxB tools only.  Allow tool to cool down.  Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2015  Error  Tool Temperature Sensor Error  SRB, TBP and IxB tools only.  Service the tool.  Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2016  Warning  Tool Pulse Unit Overheated  Pulse unit overheated. Tool is not locked, but the warning is displayed whenever the tool is started as long as the pulse unit temperature is over threshold. Valid for SRB, TBP and IxB tools only.  Allow tool to cool down.  Log Display Conf  Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2019  Warning  Tool Could not Start Motor  Tool motor failure. Valid for SRB, TBP and IxB tools only.   Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2020  Warning  Tool Requires Motor Tuning  Tool requires motor tuning.  Perform a motor tuning.  Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2021  Warning  Motor Tuning Failed  Motor tuning failed.  Complete motor tuning or service the tool.  Log  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2022  Info  Motor Tuning Completed  Motor tuning completed.   Log Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2023  Warning  The Tool Requires Open End Tuning  The tool requires open end tuning.  Perform open end tuning.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2024  Warning  Open End Tuning Failed  Open end tuning failed.  Try to perform open end tuning one more time. If it fails again, service the tool.  Log Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2025  Info  Open End Tuning Successful  Open end tuning successful.   Log Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2026  Warning  Open End Position Failed  Open end position failed.  Press the tool trigger again and wait for the positioning to be completed. If it fails again, service the tool.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2027  Warning  Usage Limited Due To High Tool Temperature  Temperature limit value has been reached. Tightening has been inhibited to reduce risk for tool shutting down due to overheating.  Wait until tool temperature has been reduced.  Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2030  Error  Tool Memory Failure: Change Tool  Tool memory corrupt.  Service the tool.  Log Display Ack Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2031  Error  Tool Accessory Memory Corrupt  Tool accessory memory corrupt.  Service the tool accessory.  Log Display Ack Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2040  Error  System Check Failure    Log Display Ack Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2041  Error  Torque Transducer Error  Will be generated either on calibration error or if tool reports transducer error.  Service the tool.  Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2042  Error  Angle Transducer Error   Service the tool.  Log Display Ack Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2043  Error  Tool Ground Fault Error   Service the tool.  Log Display Ack Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2044  Info  Tool Service Interval Expired  Indicates that servicing of the tool is needed. Triggered when the number of set tightenings has been exceeded.  Perform service of tool.  Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2045  Warning  Tool Calibration Data Invalid  If validation of calibration data fails.  Service the tool.  Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2046  Info  Tool: Next Calibration Date Has Passed  Indicates that calibration of tool is needed. Triggered when calibration alarm is enabled in settings and the current time is greater than next calibration date.  Service the tool.  Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2048  Info  Tool Calibration Value Updated By QA Device  Tool calibration was updated when a calibration with a QA device was performed.   Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2050  Error  Tool Parameter File Not Supported  Required tool parameters are missing.  Update tool parameters.  Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2060  Info  Unexpected Trigger Behavior  Used to prevent start of tool if accessory is connected.   Log Display Conf  IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2071  Error  Tool Memory Corrupt  Tool descriptor is corrupt.  Service the tool.  Log Display Conf  Flex Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2072  Info  Unknown Device Connected    Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2073  Warning  Tool Trigger Supervision Failure  HW channel failure. Mismatch between hardware and software of tool trigger.   Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2074  Warning  Tool Indicator Board Failure  Tool indicator board failure.  Service the tool.  Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2075  Warning  Tool Fan Voltage Failure  Tool fan voltage failure.  Service the tool.  Log Display Conf  Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2076  Warning  Tool Accessory Bus Voltage Failure  Tool accessory bus voltage failure.  Service the tool.  Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2077  Warning  Tool Trigger Sensor Error  Tool trigger sensor error.  Service the tool.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2078  Info  Tool Tightening Program Updated  Tool locked due to tightening program update.   Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2079  Error  Tool Cable Not Supported  Tool cable is corrupt. The chip in the cable is not responding or is damaged.  Switch cable.  Log Display Conf  Flex Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tool   2080  Error  Tool Battery Failure  DC voltage too high or too low. Battery failure.  Contact the Atlas Copco service representative and send back battery to Atlas Copco (do not reuse it!).  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2081  Error  Tool Current Limit Reached  The current limit value has been reached and the drive is disabled.  Service the tool.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2082  Error  Tool Current Measurement Error  Current measurement error. Current cannot be measured with a reliable result.  Service the tool.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2083  Error  Tool Internal Error  Various internal hardware errors. Valid for STB and IxB tools only.  Service the tool.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2084  Error  Tool Internal Software Error  Various internal software errors. Valid for STB and IxB tools only.  Service the tool.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2085  Error  Tool RBU Error  An RBU error was detected by the tool software.  Check that the RBU is correctly installed. If error is still present then service the tool.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2086  Error  Tool Stall  Tool motor is stalling.  Service the tool.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2087  Warning  Tool Motor Current High  Tool motor current limit value is exceeded, and the tool is locked. Tool will enter failsafe mode. Valid for SRB, TBP and IxB tools only.   Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2088  Warning  Tool Battery Current High  Tool battery current is too high. Valid for SRB, TBP and IxB tools only.   Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2089  Warning  Tool Drive Voltage Low  Tool drive voltage is below the monitored lower voltage limit value. Valid for SRB, TBP and IxB tools only.   Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2090  Warning  Tool Drive Voltage High  Tool drive voltage is above monitored higher voltage limit value. Valid for SRB, TBP and IxB tools only.   Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2091  Warning  Tool Main Board Error  Tool main board internal error. Valid for SRB, TBP and IxB tools only.   Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2092  Warning  Tool Power Module Error  Tool power module internal error. Valid for SRB, TBP and IxB tools only.   Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2093  Warning  Pulse Unit Oil Level Low  The oil level of the connected pulse tool is low.  Service the tool.  Log Display Conf  Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2094  Warning  Pulse Unit Oil Level Empty  The oil level of the connected pulse tool is below required operational level.  Service the tool.  Log Display Ack Conf  Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2095  Warning  Tool Battery Communication Lost  Tool lost communication with battery. Valid for SRB, TBP and IxB tools only.  Make sure battery is snugged correctly. Otherwise change battery.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2096  Error  Tool Battery Software Version Mismatch  Tool battery software incompatible with tool software. Valid for SRB, TBP and IxB tools only.  Update software.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2100  Info  STwrench smartHEAD Removed  STwrench smartHEAD has been removed.  Reconnect smartHEAD and restart the wrench.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tool   2101  Warning  Wrench Tightening When Locked  A wrench tightening was performed when the tool status was locked in the controller.  Wait until the tool status in controller is unlocked.  Log Display Conf  Power Focus 6000 Power Focus 8  Tool   2120  Warning  Unable To Start: Tool Has No Active Torque Transducer    Log Display  Flex  Tool   2121  Warning  Transducers Are Disabled For Connected Tool    Log Display  Flex  Tool   2122  Warning  Unable To Start: Tool Is Missing Required Torque Transducer    Log Display  Flex IxB  Tool   2123  Warning  Unable To Start: Tool Is Missing Required Angle Transducer    Log Display  Flex  Tool   2124  Error  Torque Transducer Error On Main Transducer  Shows that there is an error on the Main torque transducer of a Tool with dual transducers.   Log Display  Flex  Tool   2125  Error  Torque Transducer Error On Secondary Transducer  Shows that there is an error on the Secondary torque transducer of a Tool with dual transducers.   Log Display  Flex  Tool   2126  Error  Tool Torque Transducer Calibration Error On Main Transducer    Log Display  Flex  Tool   2127  Error  Tool Torque Transducer Calibration Error    Log Display  Flex StepSync  Tool   2128  Error  Tool Torque Transducer: Shunt Test Failed On Main Transducer    Log Display  Flex  Tool   2129  Error  Tool Torque Transducer: Shunt Test Failed    Log Display  Flex StepSync  Tool   2130  Error  Tool Torque Transducer: Zero Offset Compensation Failed On Main Transducer    Log Display  Flex  Tool   2131  Error  Tool Torque Transducer: Zero Offset Compensation Failed    Log Display  Flex StepSync  Tool   2132  Error  Tool Torque Transducer Hardware Error On Main Transducer    Log Display  Flex  Tool   2133  Error  Tool Torque Transducer Hardware Error    Log Display  Flex StepSync  Tool   2134  Error  Tool Torque Transducer Error: Overflow In A\/D Converter On Main Transducer    Log Display  Flex  Tool   2135  Error  Tool Torque Transducer Error: Overflow In A\/D Converter    Log Display  Flex StepSync  Tool   2136  Error  Tool Torque Transducer Calibration Error On Secondary Transducer    Log Display  Flex  Tool   2137  Error  Tool Torque Transducer Error: Shunt Test Failed On Secondary Transducer    Log Display  Flex  Tool   2138  Error  Tool Torque Transducer Error: Zero Offset Compensation Failed On Secondary Transducer    Log Display  Flex  Tool   2139  Error  Tool Torque Transducer Hardware Error On Secondary Transducer    Log Display  Flex  Tool   2140  Error  Tool Torque Transducer Error: Overflow In A\/D Converter On Secondary Transducer    Log Display  Flex  Tool   2202  Error  Tool HMI overcurrent occurred  Tool HMI overcurrent was detected.  Service the tool. Replace tool HMI.  Log Display Ack Conf  IxB  Tool   2203  Error  Tool front light overcurrent occurred  Tool front light overcurrent was detected  Service the tool. Replace tool front light.  Log Display Ack Conf  IxB  Tool   2204  Error  Accessory bus overcurrent occurred  Accessory bus overcurrent was detected.  Service the tool. Replace accessory bus.  Log Display Ack Conf  IxB  Tool   2207  Error  Vibrator overcurrent occurred  Vibrator overcurrent was detected.  Service the tool. Replace the vibrator.  Log Display Ack Conf  IxB  Tool   2208  Warning  System CPU temperature high  System CPU temperature high.  Wait until tool temperature has been reduced.  Log Display Conf  IxB  Tool   2209  Error  System CPU temperature critical  System CPU temperature critical.  Wait until tool temperature has been reduced.  Log Display Conf  IxB  Tool   2210  Error  Unsupported power source: tightening not permitted  Battery with too low voltage attached to the tool.  Attach battery with higher voltage to the tool.  Log Display Ack Conf  IxB  Tool   2217  Info  Running on backup battery  Running on backup battery.   Log  IxB  Tool   2218  Info  Battery connected  Battery connected or controller\/tool started.   Log  IxB  Tool   2219  Info  Power source: unknown  Unknown power source connected or controller\/tool started with unknown power source.   Log  IxB  Tool   2500  Error  Tensioner puller bar max number  Tensioner puller bar must be replaced. System is locked for usage. Pressure can only be released.  Send the tensioner to service organization for replacement of the puller bar.  Log Display Ack  PFHC  Tool   2501  Error  Pump motor protection alarm  The pump motor protection has stopped the motor. The system must stop. If the system is under pressure, it needs manual actions to release pressure.  Turn off the system. If under pressure, mechanically release the pressure and send the pump to service.  Log Display Ack  PFHC  Tool   2502  Error  Pump motor oil level low alarm  The pump motor oil level is low which has stopped the motor. If the system is under pressure, it needs manual actions to release pressure.  Turn off the system. If under pressure, mechanically release the pressure and top up oil.  Log Display Ack  PFHC  Tool   2503  Error  Pump motor oil temperature high alarm  The pump motor oil temperature is high.  Turn off the system and wait for the oil to cool down.  Log Display Ack  PFHC  Tool   2504  Error  Tensioner pressure sensor alarm  Failure in the pressure sensor electronics of the tensioner. No pressure can be read nor reported to the system.  Turn off the system. If under pressure, mechanically release the pressure and send the tensioner to service.  Log Display Ack  PFHC  Tool   2505  Error  Pump pressure sensor alarm  Failure in the pressure sensor electronics of the pump. No pressure can be read nor reported to the system.  Turn off the system. If under pressure, mechanically release the pressure and send the pump to service.  Log Display Ack  PFHC  Tool   2506  Error  Unexpected clockwise rotation detected  A clockwise nut rotation while waiting for pressure release after completed tensioning. The result is invalidated.  Release pressure and tension the nut again.  Log Display Conf  PFHC  Tool   2507  Error  Unexpected counter clockwise rotation detected  A counter clockwise nut rotation while waiting for pressure release after completed tensioning. The result is invalidated.  Release pressure and tension the nut again.  Log Display Conf  PFHC  Tool   2508  Error  Pump or tensioner pressure sensor failure  Too large difference between the pressure sensor readings in the pump and the tensioner. Pressurization is halted.  Problem in the hydraulics or the calibration of the pressure sensors. Restart the system and try again. If the problem repeats, contact your local Atlas Copco sales representative.  Log Display Ack  PFHC  Tool   2509  Error  Tensioner pressure sensor failure or hydraulic hose failure  The tensioner's pressure sensor indicates no pressure but the pump's sensor reads a pressure increase. Pressurization is halted.  Problem in the hydraulics or the calibration of the pressure sensors. Restart the system and try again. If the problem repeats, contact your local Atlas Copco sales representative.  Log Display Ack  PFHC  Tool   2510  Error  Set custom ID failed  Setting custom ID failed.  Restart the system and check the connected devices. If Custom ID for the unit is wrong, redo the setting.  Log Display Ack  PFHC  Tool   2511  Info  Custom ID is set  Setting custom ID succeeded.   Log Display Ack  PFHC  Tool   2512  Warning  Malformed Barcode string, ignored  The scanned string could not be parsed as a tower data bar code.  Scan a proper tower data qr code or scan tower section id.  Log Display Ack  PFHC  Tool   2513  Error  No pump pressure detected  The system is trying to pressurize but no pressure increase is registered in the pump. Possible cause is incorrect phase order in the three phase connector.  Power off the system and reverse the phases of the power connector.  Log Display Ack  PFHC  Tool   2514  Warning  Tensioner overtorque alarm  Too high torque is applied to the click wrench. This causes damage to the torque sensor.  Relax the torque.  Log  PFHC  Tool   2515  Warning  Tensioner overpressure alarm  The pressure in the tensioner is too high.  Let the pressure drop, or release the pressure. Check the hydraulic pressure parameters.  Log  PFHC  Tool   2516  Warning  Unexpected Pump or Tensioner firmware  Unexpected Pump or Tensioner firmware version detected, restart system. If the problem persists, the system may be possible to run, but carefully observe any unexpected behaviour.  Power cycle system  Log Display Ack  PFHC  Tool   2517  Error  Incompatible Pump or Tensioner firmware version, restart system. The system cannot run.  Incompatible Pump or Tensioner firmware version, restart system. The system cannot run.  Restart system, if this doesn’t help replace the failing unit. Check connected devices to see which one has not connected.  Log Display Ack  PFHC  Tool   3000  Error  Controller Internal Software Error  Software error in the controller.  Contact service.  Log Display Ack Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Controller, Drive and StepSync   3001  Error  Controller Clock Battery Empty  Internal battery is getting close to end of life.  Replace battery.  Log Display Ack Conf  Flex Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3010  Warning  System Overheated  The controller is overheated.  Cool down.  Log Display Conf  Power Focus 6000 Power Focus 8 Power Focus XC  Controller, Drive and StepSync   3011  Warning  Drive Overheated Controller Hardware   Cool down.  Log Display Conf  Flex  Controller, Drive and StepSync   3013  Warning  Usage Limited Due To High Controller Temperature  Temperature limit value has been reached. Tightening has been inhibited to reduce risk for controller shutting down due to overheating.  Wait until controller temperature has been reduced.  Log Display Conf  Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3020  Warning  Controller Hardware Failure    Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3021  Warning  System Voltage Problem  DC voltage too high or too low.   Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3022  Warning  Controller Voltage Problem: AC Input Voltage Too High  DC voltage too high or too low.  Fix the input voltage.  Log Display  Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3023  Warning  Controller Voltage Problem: AC Input Voltage Too Low  DC voltage too high or too low.  Fix the input voltage.  Log Display  Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3024  Warning  Drive Voltage Problem: AC Input Voltage Too High  DC voltage too high or too low.  Fix the input voltage.  Log Display  Flex  Controller, Drive and StepSync   3025  Warning  Drive Voltage Problem: AC Input Voltage Too Low  DC voltage too high or too low.  Fix the input voltage.  Log Display  Flex  Controller, Drive and StepSync   3030  Error  IP Address Conflicting With Another Node On The Network  The set IP address is in use by another device on the same network.  Change IP address on one of the devices.  Log Display Conf  Flex Power Focus 6000 Power Focus 8 StepSync Power Focus XC PFHC  Controller, Drive and StepSync   3031  Info  Network Cable Unplugged  The carrier of the factory port is lost (cable disconnected).  Check the cable connection.  Log Display Conf  Flex Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3032  Info  Pairing Started  Tool pairing started.   Log Display Conf  Power Focus 6000 Power Focus 8 Power Focus XC  Controller, Drive and StepSync   3033  Info  Pairing Successful  Tool pairing successful.   Log Display Conf  Power Focus 6000 Power Focus 8 Power Focus XC  Controller, Drive and StepSync   3034  Info  Pairing Unsuccessful: No Tool Found  The controller found no tool to pair with when scanning for radio peers.  Set the tool in pairing mode and try again.  Log Display Conf  Power Focus 6000 Power Focus 8 Power Focus XC  Controller, Drive and StepSync   3035  Error  Pairing Unsuccessful: More Than One Tool Found  The controller found more than one tool when scanning for radio peers.  Ensure that only one tool is in pairing mode when starting the pairing mode on the controller.  Log Display Conf  Power Focus 6000 Power Focus 8 Power Focus XC  Controller, Drive and StepSync   3036  Error  Pairing Unsuccessful: Communication Error  The controller experienced a loss of connection, an unexpected answer or timeout during the pairing process.  Try to perform pairing one more time. If it fails again, service the tool.  Log Display Conf  Power Focus 6000 Power Focus 8 Power Focus XC  Controller, Drive and StepSync   3037  Info  Pairing Unsuccessful: Tool Slot Is Full   Clear one tool slot.  Log Display Conf  Power Focus 6000 Power Focus 8 Power Focus XC  Controller, Drive and StepSync   3040  Warning  Emergency Stop  Drive disabled due to emergency stop.  Reset emergency stop.  Log Display Conf  Flex Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3050  Info  System Clock Updated  System clock has been updated.   Log Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC PFHC  Controller, Drive and StepSync   3051  Error  System Clock Error  Wrong time read from hardware Real Time Clock (RTC).  Change RTC battery.  Log Display Ack Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC PFHC  Controller, Drive and StepSync   3052  Warning  Remote Start Configuration Error  Mismatch between HW and SW remote start configuration.  Verify that HW dip switch matches the selected start source.  Log Display Conf  Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3053  Info  Drive Connected  StepSync drive has been connected.   Log Display  Flex Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3054  Info  Drive Disconnected  StepSync drive disconnected.   Log Display  Flex Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3055  Warning  Mode Configuration Error  Generated when selected mode is configured wrongly. E.g. configuring two bolts with the same bolt number or the same channel, incomplete mode configuration.  Check ToolsTalk 2 for mode configuration error.  Log Display  Flex StepSync  Controller, Drive and StepSync   3056  Warning  Unable to Start: Tool Or Drive Is Missing  Generated when a used channel is missing a drive or tool.  Verify Channel Menu on the HMI. Connect missing drive or tool.  Log Display  Flex StepSync  Controller, Drive and StepSync   3057  Info  Unable to Start: Channel Is Already In Use  Generated when a needed channel has been allocated to another virtual station.   Log Display  Flex  Controller, Drive and StepSync   3058  Info  No Mode Selected   Select mode.  Log Display  Flex StepSync  Controller, Drive and StepSync   3059  Warning  Failed To Connect To Atlas Copco License Manager  Indicates that the controller failed to connect to the local license manager to get licenses.  Verify the local network. If it fails again, service the controller.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3061  Warning  Unable To Start: Enable Signal Is Low    Log Display  Flex StepSync  Controller, Drive and StepSync   3062  Warning  Unable To Start: Stop Signal Is High    Log Display  Flex StepSync  Controller, Drive and StepSync   3063  Warning  Unable To Start: All Channels Inhibited  All channels have been set inhibited, so no tightening can be started.  Set at least one channel to not be inhibited.  Log Display  Flex StepSync  Controller, Drive and StepSync   3064  Warning  Carrier Number Faulty  A FlexCarrier hex switch is set to zero.  Turn the switch to a non-zero value.  Log Display  Flex  Controller, Drive and StepSync   3065  Warning  Carrier E-Stop Configuration Plug Wrong Type Or Missing  A Carrier is missing its E-stop configuration plug, or the plug type is wrong.  Insert correct plug type.  Log Display  Flex  Controller, Drive and StepSync   3066  Warning  Carrier Voltage Inlet: No 3-Phase AC    Log Display  Flex  Controller, Drive and StepSync   3067  Warning  Carrier Voltage Inlet: One AC Phase Missing    Log Display  Flex  Controller, Drive and StepSync   3068  Warning  Carrier: Internal 24 VDC Power Supply Unit Broken    Log Display  Flex  Controller, Drive and StepSync   3069  Warning  Carrier 24 Voltage OUT-Port Disabled Due To Over-Current   Reset the system.  Log Display  Flex  Controller, Drive and StepSync   3070  Warning  Carrier, Hardware Error In PF6 FlexControl Cable OUT   Reset the system.  Log Display  Flex  Controller, Drive and StepSync   3071  Warning  Carrier, Hardware Error In PF6 FlexControl Cable IN   Reset the system.  Log Display  Flex  Controller, Drive and StepSync   3072  Warning  Emergency Stop 24 VDC Power Failure Due To Short-Circuit    Log Display  Flex  Controller, Drive and StepSync   3073  Warning  Unable To Start: System Is Emergency Stopped  When allocating multiple spindles, this event is invoked by \"preStartCheckFailed\" due to emergency stop.  Reset the emergency stop.  Log Display  Flex StepSync  Controller, Drive and StepSync   3074  Warning  Carrier Overheated    Log Display  Flex  Controller, Drive and StepSync   3075  Warning  Carrier Temperature OK    Log Display  Flex  Controller, Drive and StepSync   3076  Warning  Carrier: Internal 24 VDC Power Supply Overload  Current output from internal PSU is too high.  Disconnect other carriers that are powered from the PSU. Disconnect any external equipment using 24 VDC.  Log Display  Flex  Controller, Drive and StepSync   3077  Warning  Carrier: Internal 24 VDC Power Supply Over Voltage  Voltage output from internal PSU is too high.  Replace the carrier.  Log Display  Flex  Controller, Drive and StepSync   3078  Warning  Carrier: Internal 24 VDC Power Supply Under Voltage  Voltage output from internal PSU is too low.  Replace the carrier.  Log Display  Flex  Controller, Drive and StepSync   3079  Warning  External Supply To Carrier: 24 VDC Over Voltage  Backup input voltage is more than 27 VDC.  Adjust the backup input voltage.  Log Display  Flex  Controller, Drive and StepSync   3080  Warning  External Supply To Carrier: 24 VDC Under Voltage  Backup input voltage is less than 19 VDC.  Adjust the backup input voltage.  Log Display  Flex  Controller, Drive and StepSync   3081  Warning  Carrier Voltage Inlet: 3-Phase AC Over Voltage  Input voltage is too high.  Lower input voltage: must be 400 VAC or 480 VAC.  Log Display  Flex  Controller, Drive and StepSync   3082  Warning  Carrier Voltage Inlet: 3-Phase AC Under Voltage  Input voltage is too low.  Higher input voltage: must be 400 VAC or 480 VAC.  Log Display  Flex  Controller, Drive and StepSync   3083  Error  Wrong Anybus\/Profisafe Module Firmware    Log Display  Flex Power Focus 6000 Power Focus 8 StepSync  Controller, Drive and StepSync   3084  Error  Soft PLC Runtime Error  eCLR has terminated in an uncontrolled way.   Log Display Conf  Flex Power Focus 6000 Power Focus 8 StepSync  Controller, Drive and StepSync   3085  Warning  Carrier: Fan Module Out Of Order    Log Display  Flex  Controller, Drive and StepSync   3086  Warning  Carrier: Fan Module Partly Out Of Order    Log Display  Flex  Controller, Drive and StepSync   3087  Warning  Carrier: Left Fan Module Out Of Order    Log Display  Flex  Controller, Drive and StepSync   3088  Warning  Carrier: Left Fan Module Partly Out Of Order    Log Display  Flex  Controller, Drive and StepSync   3089  Warning  Carrier: Right Fan Module Out Of Order    Log Display  Flex  Controller, Drive and StepSync   3090  Warning  Carrier: Right Fan Module Partly Out Of Order    Log Display  Flex  Controller, Drive and StepSync   3096  Warning  Cellular signal strength low  The RSSI value for the cellular connection is under the defined threshold value of -98 dBm.  Move the tool closer to the cellular antennas for a stronger connection and avoid data loss.  Conf  IxB  Controller, Drive and StepSync   3097  Warning  Cellular connection lost  The system lost connection to the cellular network.    Move the tool closer to the cellular antennas.  Check the cellular connection setup so correct APN is still configured.  Check the cellular network for any problems.  Log Display Conf  IxB  Controller, Drive and StepSync   3100  Warning  Mode Configuration Does Not Exist    Log Display  Flex StepSync  Controller, Drive and StepSync   3150  Error  Software IAM Incompatibility  IAM is incompatible with the software that is installed on the controller.  Replace IAM.  Log Display Ack  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3160  Error  Failed To Activate Newly Installed Software  Something went wrong during the activation. When the newly installed software starts, a fallback to the previous working software happens. This error happens when the new software fails to start for three times and only during software installation.  Take an export and contact Atlas Copco for further assistance. Note down the software version you are trying to install as well as the software version that is working.  Log Display Ack  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3161  Error  Started On Unexpected Software Partition  The controller has started on the inactive software side and not on the expected software side.  Note down the software information (on the Home screen of the controller, select Controller > Software). Try to restart the controller and make sure its running on correct software when started again. If error persists, do an export and contact Atlas Copco.  Log Display Ack  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3500  Error  Generic License Manager Error  Inconsistency detected in the feature management system used.  Contact Atlas Copco representative.  Log Display Ack  IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3501  Error  License Manager Synchronization Error    Log Display Ack  IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3502  Info  License Manager Synchronization Done     IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3503  Warning  License Manager: Another Source in Use  License is used by another source.  Verify license assignment.  Log Display  IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3504  Warning  License Manager Restart Needed   Restart license manager.  Log Display  IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3505  Info  USB License Synchronization Started    Log  Power Focus 6000 Power Focus 8 Power Focus XC  Controller, Drive and StepSync   3506  Error  USB License Synchronization Error    Log  Power Focus 6000 Power Focus 8 Power Focus XC  Controller, Drive and StepSync   3507  Info  USB License Synchronization Done    Log  Power Focus 6000 Power Focus 8  Controller, Drive and StepSync   3508  Info  One or more of your licenses are about to expire. Please make sure you have a license server configured   Update licenses.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3511  Warning  One of your licenses has a different license definition  Inconsistency detected in a license to be used.  Contact Atlas Copco representative.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3550  Warning  License Is Missing   Install the correct license.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   3551  Warning  Wireless Communication Disabled By Licensing   Unassign Standalone license from the Virtual Station.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Controller, Drive and StepSync   4010  Info  Tool Locked By Digital Input  The tool is locked by a digital input signal.   Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tightening Process   4011  Info  Tool Locked By Open Protocol  The tool is locked by Open Protocol.   Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tightening Process   4012  Info  Tool Locked By Fieldbus  The tool is locked by the Fieldbus.   Log Display Conf  Flex Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tightening Process   4013  Info  Tool Locked By Socket Selector  Tool is locked when the socket selector is disconnected from the Virtual Station.  Unlock by Master Unlock.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4014  Info  Tool Locked By Soft PLC  Soft PLC signal locked the tool.  Unlock by Master Unlock.  Log Display Conf  Flex Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tightening Process   4015  Info  Loosening Disabled  Loosening is disabled in the tightening program.   Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tightening Process   4016  Info  Tightening Disabled    Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tightening Process   4017  Info  Loosening Not Configured  Loosening is not configured in the selected tightening program  Select different tightening program.  Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tightening Process   4020  Info  Too Many NOK Tightenings  Maximum consecutive NOK tightenings in batch is exceeded   Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tightening Process   4025  Info  No Tightening Program Selected  No tightening program selected.  Select tightening program or batch sequence.  Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4030  Info  Batch Sequence Aborted  The batch sequence has been aborted.   Log Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC PFHC  Tightening Process   4031  Info  Max Time To Complete Batch Sequence Reached    Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tightening Process   4032  Info  Max Time To Complete First Tightening Reached    Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tightening Process   4035  Info  Locked By Line Control    Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4040  Info  Locked By Alternative Identifier  Tool locked by alternative identifier.   Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4050   Invalid Socket Configuration  Tightening program assigned to multiple sockets.  Tightening program assigned to multiple sockets.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4060  Info  Tool Locked On Batch Complete  When running a batch with flag Tool lock on batch sequence complete this event is generated when the user press the trigger.  Unlock with signal Unlock Tool on complete.  Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tightening Process   4070  Info  Process Enter Manual Mode  Indicates that manual mode has been activated for a virtual station.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4071  Info  Process Enter Automatic Mode  Indicates that automatic mode has been entered for a virtual station.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4072  Info  Test Bolt    Conf  Flex StepSync  Tightening Process   4073  Info  Tool zero position updated  Indicates that the tool zero position is set using signals.   Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tightening Process   4100  Warning  Identifier Not Accepted: Invalid String Length    Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tightening Process   4101  Warning  String Selection Unsuccessful: Multiple Matches    Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tightening Process   4102  Warning  String Selection Unsuccessful: No Match Found    Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tightening Process   4103  Warning  Identifier Not Accepted: Identical String Already Received    Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tightening Process   4104  Warning  Identifier Not Accepted: No Match Found    Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Tightening Process   4500  Info  Result DriveError  Internal driver error or driver loss detected.   Conf  Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4501  Info  Result Rehit  Attempt to tighten an already tightened bolt when Rehit detection is on.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4502  Info  Result Soft Start Torque Low  Soft start torque below minimum level.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4503  Info  Result Soft Start Torque High  Soft start torque exceeded maximum level.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4504  Info  Result Self Tap Torque High  Self-tap torque exceeded maximum level.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4505  Info  Result Self Tap Torque Low  Self-tap torque below minimum limit.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4506  Info  Result Safety Torque Low  Automatically calculated torque value to ensure torque sensor is mounted correctly.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4507  Info  Result Rundown Torque High  Rundown torque exceeded maximum level.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4508  Info  Result Rundown Angle High  Rundown angle exceeded maximum level.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4509  Info  Result Rundown Time High  Rundown time exceeded maximum limit.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4510  Info  Result Rundown Time Low  Rundown time below minimum limit.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4511  Info  Result Rundown Torque Low  Rundown torque below minimum level.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4512  Info  Result Rundown Angle Low  Rundown angle below minimum level.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4513  Info  Result Final Torque High  Final step torque exceeded maximum level.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4514  Info  Result Final Angle High  Final step angle exceeded maximum level.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4515  Info  Result Final Torque Low  Final step torque below minimum level.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4516  Info  Result Final Angle Low  Final step angle below minimum level.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4517  Info  Result Tightening Timeout  Tightening time limit exceeded. For General Tightening Strategies max tightening time is 30 seconds. For Multistep max tightening time depends on step restriction Maximum Time Limit. Error code is dependent on tightening stage.  Redo tightening.  Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4518  Info  Result Trigger Lost  Tool trigger was released before target was reached. For General Tightening Strategies it is not allowed to release the trigger before the tightening stage has finished. For Multistep, the error is displayed when trigger is lost before the target in a specific step is reached.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4519  Info  Premature Torque Loss  Socket has slipped off the nut.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4520  Info  Result Target Reached Before Final Step  Target torque reached before final step in tightening program.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4521  Info  Result Post View Torque Low  Post view torque below minimum level.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4522  Info  Result Post View Torque High  Post view torque exceeded maximum level.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4523  Info  Result Post View Torque Interval Not Reached  Post view torque interval not reached.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4524  Info  Result Torque Compensation Interval Not Reached  Torque compensation interval angle before rundown end not reached.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4525  Info  Result Tool Movement Exceeded  From a NOK tightening detailed status.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4526  Info  Result SafetyCurrMon Sensor Mismatch  Current monitoring error.    IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4527  Info  Result Tool Movement Exceeded     IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4538  Info  Result Final Supervision Torque Low  Final Supervision Torque was not reached.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4543  Info  Result Snug Monitor High  Wrench only. Monitor detected snug value exceeded.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4545  Info  Result No Residual Torque  Wrench only. Residual torque was under threshold.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4546  Info  Result Overspeed  Wrench only. Wrench gyro failed to measure angle due to high speed.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4547  Info  Result Effective Loosening  Wrench only. Wrench detected unexpected loosening.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4548  Info  Result Final Less Than Target  Final torque is below target torque set in tightening program.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4549  Info  TurboTight Time Limit Exceeded    Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4550  Info  Result Rundown Pulses High  Maximum number of rundown pulses is exceeded.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4551  Info  Result Rundown Pulses Low  Rundown is completed before the minimum number of rundown pulses is reached.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4552  Info  Result Final Pulses High  Maximum number of pulses is exceeded.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4553  Info  Result Final Pulses Low  Tightening is completed before the minimum number of pulses is reached.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4554  Info  Current At Shutoff High  Current at shut off exceeded Current Limit High.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4555  Info  Current At Shutoff Low  Shut off current measured was below Current Limit Low.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4556  Info  Uncategorized Multistep Error  An error in the multistep configuration, often with tool validation.   Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4557  Info  Result Overload    Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Tightening Process   4600  Warning  Data Drop or Data Hold used in combination with Batch Tightening. The signals have no effect   Data Drop and Data Hold are only supported for worktasks, without batch control. Select another worktask if the signals must be used.   Flex StepSync  Tightening Process   4601  Info  Data Hold Active: tightening result is sent once signal is low     Flex StepSync  Tightening Process   4602  Info  Data Drop active: tightening result discarded     Flex StepSync  Tightening Process   5010  Warning  Invalid Tightening Program Parameter Value  The parameter in the selected tightening program are invalid.  Check the configuration of the selected tightening program to find and to change the value of the parameter.  Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC PFHC  Program Configuration   5011  Warning  Couldn't prepare program storage in tool  It is not possible to read the current program storage size in the STB tool, or to prepare the program storage for downloading the updated - or newly selected - tightening program to the STB tool.    Check the STB tool for supported software version.  Reboot the STB tool.  Select again the tightening program.  Check network connection for data consistency and quality.  Log Display Conf  Power Focus 6000 Power Focus 8 Power Focus XC  Program Configuration   5020  Info  Main Trigger Is Not The Active Start Source  Generated when configured for push start only and user presses main trigger. Will be generated until user presses the push start.  Press push start to start the tool.  Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Program Configuration   5030  Info  Tightening Program Complexity Exceeds Tool Capacity  The selected tightening program is too complex for the STB tool that is used. Tool will be locked.  Reduce complexity of the tightening program, or choose different program.  Log Display Conf  Power Focus 6000 Power Focus 8 Power Focus XC  Program Configuration   6010  Info  Accessory Connected  Accessory is connected to the controller.   Log Display Ack Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Accessory   6020  Info  Accessory Disconnected  Accessory is disconnected from the controller.   Log Display Ack Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Accessory   6021  Warning  Fieldbus Offline  No communication with Fieldbus.   Log Display Ack Conf  Flex Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Accessory   6030  Warning  Accessory Address Collision  Two or more accessories with the same address are connected.  Change address on accessory.  Log Display Ack Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Accessory   6040  Warning  Accessory Communication Error  Intermittent communication error with accessory.  Check cables and connectors.  Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Accessory   6041  Warning  Fieldbus Error  Communication error with Fieldbus.    Log Display Ack Conf  Flex Power Focus 6000 Power Focus 8 StepSync  Accessory   6042  Warning  Fieldbus Module Mismatch  The installed Fieldbus module does not match with the configured module.  Change the configuration to match with the installed module, or replace the installed module with the correct one.  Log Display Ack Conf  Flex Power Focus 6000 Power Focus 8 StepSync  Accessory   6043  Warning  Fieldbus Output Buffer Overflow  The output buffer used for the Fieldbus communication is exhausted and an overflow of the buffer has occurred. One or more signal updates have been discarded.  Stop Fieldbus communication and Fieldbus diagnostics (if used) to recover the buffer. If this event occurs frequently, check your Fieldbus communication setup, including the PLC program: too frequent updates compared to your update interval can lead to this scenario.  Log Display Ack Conf  Flex Power Focus 6000 Power Focus 8 StepSync  Accessory   6044  Warning  Fieldbus Provider ID mismatch  The installed fieldbus module is not supported.  Connect a supported Atlas Copcofieldbus module.  Log Display Ack  Power Focus 8  Accessory   6050  Info  Wrong Socket Selected  Generated when no or incorrect socket is selected.   Log Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Accessory   6090  Warning  Barcode Scanner Could Not Be Identified  When no unique serial number is found.  Configure the barcode reader device.  Log Display Ack Conf  Flex Power Focus 6000 Power Focus 8 StepSync Power Focus XC PFHC  Accessory   7010  Info  Message Text To Display  General event for displaying of messages.   Display Ack Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC PFHC  Message   8200  Info  Failed To Open Serial Port  Serial port to be used could not be opened.  Check serial port connections.  Display Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Miscellaneous   8300  Warning  Open Protocol client communication timed out  Communication to an Open Protocol client has timed out. No keep alive message or command sent within expected time.    Check controller network connection.  Check network setup: firewall and switches.  Check client side application software.  Log Display Conf  Flex IxB Power Focus 6000 Power Focus 8 StepSync Power Focus XC  Miscellaneous   8214  Error  EHMI Software Version Mismatch  EHMI software version does not match in compatibility with the controller.  Update the software version of the EHMI.  Log Display Ack Conf  IxB Power Focus 6000 Power Focus 8 Power Focus XC  Miscellaneous "},{"id":"2531843467","fileName":"2531843467.html","title":"NOK Results List","level":4,"position":823,"hasContent":true,"hierarchy":["Reports and Statistics","Working with the Reports Tab","Events"],"content":"      Error message  Description  GUI location    Drive error  Internal driver error or driver loss detected.   N\/A   Rehit  Attempt to tighten an already tightened bolt.   Tightening parameters (Edit) > Rehit detection   Soft start torque above max  Soft start torque exceeded maximum level.   Tightening parameters (Edit) > (Step 1) Soft Start > Torque max   Selftap torque above max  Selftap torque exceeded maximum level.   Tightening parameters (Edit) > (Step 2) Selftap > Torque max   Selftap torque below min  Selftap torque below minimum limit.   Tightening parameters (Edit) > (Step 2) Selftap > Torque min   Safety torque limit low  Automatically calculated torque value to ensure torque sensor is mounted correctly.   N\/A   Rundown torque above max  Rundown torque exceeded maximum level.   Tightening parameters (Edit) > (Step 2) Rundown torque limits > Torque max   Rundown angle above max  Rundown angle exceeded maximum level.   Tightening parameters (Edit) > (Step 2) Rundown angle limits > Angle max   Rundown exceeded max time limit  Rundown time exceeded maximum limit.   Tightening parameters (Edit) > (Step 2) Rundown angle limits > Time max   Rundown below min time limit  Rundown time below minimum limit.   Tightening parameters (Edit) > (Step 2) Rundown angle limits > Time min   Rundown torque below min  Rundown torque below minimum level.   Tightening parameters (Edit) > (Step 2) Rundown torque limits > Torque min   Rundown angle below min  Rundown angle below minimum level.   Tightening parameters (Edit) > (Step 2) Rundown angle limits > Angle min   Final step torque above max  Final step torque exceeded maximum level.   Tightening parameters (Edit) > (Step 3) Final step > Torque limits Manual > Torque max   Final step angle above max  Final step angle exceeded maximum level.   Tightening parameters (Edit) > (Step 3) Final step > Angle max   Final step torque below min  Final step torque below minimum level.   Tightening parameters (Edit) > (Step 3) Final step > Torque limits Manual > Torque min   Final step angle below min  Final step angle below minimum level.   Tightening parameters (Edit) > (Step 3) Final step > Angle max   Tightening timeout  Tightening time limit exceeded.   [Multistep] Tightening parameters (Edit) > Step dependent  [Other tightening programs]: fixed parameter set to 30 seconds   Trigger lost  Tool trigger was released before target was reached.   [Multistep]: trigger release before tightening step target has been reached  [Other tightening programs]: trigger release before tightening stage has finished   Slip off  Socket has slipped off the nut.   Tightening parameters (Edit) > (Step 3) Tightening parameters > Slipoff detection time   Target reached before final step  Target torque reached before final step in tightening program.   Target torque   Post view torque below min  Post view torque below minimum level.   Tightening parameters (Edit) > (Step 2) Post view torque > Torque min   Post view torque above max  Post view torque exceeded maximum level.   Tightening parameters (Edit) > (Step 2) Post view torque > Torque max   Post view torque interval not reached  Post view torque interval not reached.   Tightening parameters (Edit) > (Step 2) Post view torque > Torque min length   Torque compensation interval not reached  Torque compensation interval angle before rundown end not reached.   Tightening parameters (Edit) > (Step 3) Torque compensation > Torque compensation point   Tool movement exceeded  Tool was moved beyond set angle limits.   Tightening parameters (Edit) > (Step 1) TrueAngle compensation (On); Tool movement limits > Positive\/Negative   Current monitoring error  Current monitoring error.   Tightening parameters (Edit) > (Step 1) Current monitoring (On)   Final step exceeded max time limit    [TurboTight] Tightening parameters (Edit) > (Step 3) Final step > Time max   Final step below min time limit    [TurboTight] Tightening parameters (Edit) > (Step 3) Final step > Time min   TurboTight time limit exceeded  TurboTight time limit exceeded.   [TurboTight] Tightening parameters (Edit) > (Step 3) Final step > Time max   Snug monitor high  Wrench only. Monitor detected snug value exceeded.   Tightening parameters (Edit) > Rundown stage (Step 2) Rundown complete > Rundown complete torque   No residual torque  Wrench only. Residual torque was under threshold.   [TurboTight] + [TensorPulse] Tightening parameters (Edit) > (Step 3) > Tightening parameters > Residual torque correlation factor   Overspeed  Wrench only. Wrench gyro failed to measure angle due to high speed.   N\/A"},{"id":"18139904907","fileName":"1813990490723858312075.html","title":"SPC - Statistical Process Control","level":3,"position":824,"hasContent":true,"hierarchy":["Reports and Statistics","Working with the Reports Tab"],"content":" The purpose of the built-in SPC function is to give the operator or quality control staff data that let them judge the stability and capability of the assembly process according to standard SPC rules. By configuring the SPC function within the controller, it is possible to simplify and do the work directly on the controller without the need of external software. The charts are generated on the controller. Since it is possible to use program monitors within the controller as a SPC variable, it is necessary to specify that only variables controlled by the controller show the performance of the controller system. Other variables show mainly results from other processes. For example, if a torque value is applied to a joint, then SPC of the final torque value and the related results - such as Cp and Cpk - show the performance of the tool and the controller on that joint. Statistical calculations are based on old data stored in the controller. Statistical calculations are done on a Virtual Station level, depending on the tightening program selected and used for that specific Virtual Station. "},{"id":"18155021963","fileName":"18155021963.html","title":"Configuring SPC Parameters","level":4,"position":825,"hasContent":true,"hierarchy":["Reports and Statistics","Working with the Reports Tab","SPC - Statistical Process Control"],"content":"    On the Homeview, select the ReportsTab. Then, on the left, select Statistics.  In the SPC Configurationwindow, enter the following parameters to collect results stored in the controller:    Number of Subgroups: enter the number of subgroups the statistics calculation is based upon. The number of results ( Number of Subgroups× Frequency) can range from 2 through 500.   Subgroup Size: enter the number of tests (samples) necessary to define each point (the average value of the tests in the subgroup) on the SPC charts. The subgroup size can range from 2 through 25.   Frequency: enter how often to start collecting a new subgroup. Frequency must be equal or higher than Subgroup size. For instance, if Frequency is 8 and Subgroup Size is 5, the first 5 data (results) is used for the subgroup. Because of the Frequency =8, the next subgroup starts considering data (results) from the 8th one on, and so on in a loop."},{"id":"18172827403","fileName":"18172827403.html","title":"Configuring SPC Variables","level":4,"position":826,"hasContent":true,"hierarchy":["Reports and Statistics","Working with the Reports Tab","SPC - Statistical Process Control"],"content":"    On the Homeview, select the ReportsTab. Then, on the left, select Statistics.  Select the Plusicon at the upper-right corner of the GUI. The SPC Variablewindow shows the new variable.  In the Namebox, enter the name of the variable. The name of the variable is the heading of the SPC Variablewindow.  Select Tightening Program. The Tightening Programwindow appears and lists all the multistep tightening programs stored in the controller and available for statistical calculations. Select the multistep tightening program of the new variable.  The Tightening Program must be a Multistep Program.  Select Virtual Station. The Virtual Stationwindow appears. Select the Virtual Station which the results are made from.  Statistics are based on results made by a Virtual Station that has the following license type assigned:    Process Control  Select Monitor. The Monitorwindow appears. Select one of the following program monitors which the SPC calculation is based on:    Step monitor peak torque   Step monitor angle   Final torque   Final angle   Program monitor torque   Program monitor angle  If the user selects Step monitor peak torqueor Step monitor angle, in the Step numberbox enter the number of the necessary step of the tightening program which read the value from.  If the user uses the result reporters, it is possible to have an effect on the following monitor values: Final torqueand Final angle.  Select Edit limits. The Variable configurationwindow appears. For calculations and analysis of the results, set the following limits for each value of interest.  In the Tolerance limitswindow, set the following limits (used for calculation of the process capabilities Cp and Cpk):   Upper Tolerance Limit (UTL): a user-defined quantity that identifies the highest acceptable value of a product attribute.   Lower Tolerance Limit (LTL): a user-defined quantity that identifies the lowest acceptable value of a product attribute.  In the Control limitswindow, enable or disable the Auto calculateswitch. If the Auto calculateswitch is set to Yes, the control limits are automatically calculated. If the Auto calculateswitch is set to No, set the following limits:   Mean - Upper control limit: a statistically determined measurement that appears as a horizontal dashed line above the process average.   Mean - Lower control limit: a statistically determined value that appears as a horizontal dashed line below the process average.   Range - Upper control limit: a statistically determined measurement that appears as a horizontal dashed line above the process average.   Range - Lower control limit: a statistically determined value that appears as a horizontal dashed line below the process average.   Sigma - Upper control limit: a statistically determined measurement that appears as a horizontal dashed line above the process average.   Sigma - Lower control limit: a statistically determined value that appears as a horizontal dashed line below the process average.  In the Capabilitieswindow, set the following limits:   Cp: the Cp index gives the process capability: it is the number of times the spread of the process is into the tolerance width ( Upper tolerance limit- Lower tolerance limit). The higher the value of Cp, the better the process.   Cpk: the Cpk index gives the process capability corrected for the position. It is not useful having a high Cp index if the process setting is way off center in relation to the middle of the tolerance range. A high Cpk index means, then, that you have a good process with a small spread in relation to the tolerance width, and also that it is well centered within that width ( Upper tolerance limit- Lower tolerance limit). If Cpk is equal to Cp, the process is set to produce exactly in the middle of the tolerance range. "},{"id":"18175092363","fileName":"18175092363.html","title":"Calculating Statistics","level":4,"position":827,"hasContent":true,"hierarchy":["Reports and Statistics","Working with the Reports Tab","SPC - Statistical Process Control"],"content":"    On the Homeview, select the ReportsTab. Then, on the left, select Statistics.  In the SPC Configurationwindow, enter the parameters to collect results stored in the controller ( Number of Subgroups, Subgroup Size, and Frequency).  Select the Plusicon at the upper-right corner of the GUI. The SPC Variablewindow shows the new variable. Configure the new SPC Variable.  In the SPC Variablewindow, select Calculate. Data is collected from the historical results stored in the controller that are aligned with the criteria set in the SPC Configurationwindow and SPC Variablewindow. The values of interest are collected into subgroups of the size set in the SPC Configurationwindow. The collected tightening results on the controller are used for statistics calculations.  It is not possible to calculate statistics for results from deleted tightening programs or Virtual Stations, unless the results are still stored on the controller.  Only 1 user at a time can calculate statistics. Statistics Formulas Data in a subgroup is calculated as:   Average:   Range = R = max (Xi) - min (Xi), where i=1...n  Standard deviation for a subgroup:   Total overall of the standard deviation:  Where N = total number of observations. When specified number of subgroups to use for calculations has been collected, the SPC function starts calculations to determine the statistical stability. Calculations are performed through the following steps: (m = number of subgroups)   Calculation of Average of Average values:   Calculation of Average of Range:   Calculation of Average of Standard deviation:   Calculation of the process capabilities Cp and Cpk with respect to Sigma:    Where:  is the overall arithmetic average of the observed characteristic values.  UTL is the Upper Tolerance Limit.  LTL is the Lower Tolerance Limit.  The sigma estimation is the mean square standard deviation within the subgroups:   Calculation of the process capabilities Cp and Cpk with respect to Range:    Where for a normal distribution su = sl = 3. Calculations for control limits if, in the SPC Configurationwindow, the Auto calculateswitch is set to Yes:    X-bar R (Mean)     X-bar R (Range)      X-bar S (Mean)     X-bar S (Sigma)    A2, A3, D3, D4, B3, and B4are constants (for more information, see the \" SPC Calculation Constants\" paragraph). SPC Calculations Constants      Subgroup Size  Divisors for estimate of standard dev.  Factors for Control Limits       Xbar R   Xbar S    A2   D3   D4   A3   B3   B4    n   d2   2  1.128  1.880  -  3.267  2.659  -  3.267   3  1.693  1.023  -  2.574  1.954  -  2.568   4  2.059  0.729  -  2.282  1.628  -  2.266   5  2.326  0.577  -  2.114  1.427  -  2.089   6  2.534  0.483  -  2.004  1.287  0.030  1.970   7  2.704  0.419  0.076  1.924  1.182  0.118  1.882   8  2.847  0.373  0.136  1.864  1.099  0.185  1.815   9  2.970  0.337  0.184  1.816  1.032  0.239  1.761   10  3.078  0.308  0.223  1.777  0.975  0.284  1.716   11  3.173  0.285  0.256  1.744  0.927  0.321  1.679   12  3.258  0.266  0.283  1.717  0.886  0.354  1.646   13  3.336  0.249  0.307  1.693  0.850  0.382  1.618   14  3.407  0.235  0.328  1.672  0.817  0.406  1.594   15  3.472  0.223  0.347  1.653  0.789  0.428  1.572   16  3.532  0.212  0.363  1.637  0.763  0.448  1.552   17  3.588  0.203  0.378  1.622  0.739  0.466  1.534   18  3.640  0.194  0.391  1.608  0.718  0.482  1.518   19  3.689  0.187  0.403  1.597  0.698  0.497  1.503   20  3.735  0.180  0.415  1.585  0.680  0.510  1.490   21  3.778  0.173  0.425  1.575  0.663  0.523  1.477   22  3.819  0.167  0.434  1.566  0.647  0.534  1.466   23  3.858  0.162  0.443  1.557  0.633  0.545  1.455   24  3.895  0.157  0.451  1.548  0.619  0.555  1.445   25  3.931  0.153  0.459  1.541  0.606  0.565  1.435                      "},{"id":"18178664715","fileName":"18178664715.html","title":"Viewing Statistical Results","level":4,"position":828,"hasContent":true,"hierarchy":["Reports and Statistics","Working with the Reports Tab","SPC - Statistical Process Control"],"content":"    On the Homeview, select the ReportsTab. Then, on the left, select Statistics.  In the SPC Configurationwindow, enter the following parameters: Number of Subgroups, Subgroup Size, and Frequency.  Select the Plusicon at the upper-right corner of the GUI. The SPC Variablewindow shows the new variable. Configure the new SPC Variable.  In the SPC Variablewindow, select Calculate.  To show the statistical results, in the SPC Variablewindow, select Viewbox.  Viewbox shows the date and time which the statistics results have been done. The statistical results are displayed through a histogram, the XBar-Rchart, and the XBar-Schart.  When all calculations on the filtered results are done, they are sent to the Web HMI and ToolsTalk 2. The statistics results are locally saved on a Temporary Internet Files folder (not saved on the controller).  Statistical results can be displayed only on the Web HMI. Histogram A histogram is a series of rectangles, each proportional in width to the range of values within a class and proportional in height to the number of samples falling in the class. A Gaussian curve follows the trend of the rectangles. A histogram reveals the amount of variation that any process has within it. The histogram is useful because it emphasizes and clarifies trends that are not readily discernible in tables. XBar-R Chart The XBar-R control chart shows both the mean value (XBar) and the range (R) of a subgroup. This is the most common type of control chart using indiscrete or continuous values. The XBar part of the chart shows any changes in the mean value of the process while the R part shows any changes in the dispersion of the process. This chart is particularly useful because it shows changes in mean value and dispersion of the process at the same time, making it a very effective method for checking abnormalities in the process. XBar-S Chart The XBar-S control chart shows both the mean value (XBar) Chart and the standard deviation (S) for each subgroup. The XBar-S chart is identical to the XBar-R chart except that the R (range) is replaced by an S (standard deviation). Calculated Statistical Values In the Web HMI the calculated statistical values are displayed in information boxes below the histogram, the XBar-Rchart, and the XBar-Schart.  The calculated values depend on the chart which they are read on. The calculated statistical values are:   Min = minimum value for all collected sample values  Max = maximum value for all collected sample values  Mean =  Mean+3Sigma =+ 3*stdDev  Mean-3Sigma =- 3*stdDev  Cp (in XBar-Rchart the value is based on range, and in XBar-Schart the value is based on sigma)  Cpk (in XBar-Rchart the value is based on range, and in XBar-Schart the value is based on sigma)  Center line = in Range part, and in Sigma part  Target (if available the target value for the monitor)  Standard deviation = Total overall standard deviation = stdDev    "},{"id":"8850733579","fileName":"885073357923858318987.html","title":"Troubleshooting and Service","level":1,"position":829,"hasContent":false,"hierarchy":[],"content":"  This section provides assistance in troubleshooting problems, should they arise, and contains information to help you maintain and service the product. "},{"id":"5147835915","fileName":"5147835915.html","title":"Troubleshooting: WLAN and Bluetooth","level":2,"position":830,"hasContent":true,"hierarchy":["Troubleshooting and Service"],"content":"      Problem  Possible cause  Solution    Failed pairing (WLAN)  Tool has been restarted and lost connection to the controller  Pair tool with the controller   Failed pairing (WLAN)  Other tools are being paired at the same time  Make sure all other tools have exited pairing mode   Failed pairing (WLAN)  Tool is out of range  Move the tool closer to the controller and make sure you have a clear line of sight to the controller   Failed pairing (Bluetooth)  Other tools are being paired at the same time  Make sure all other tools have exited pairing mode   Failed pairing (Bluetooth)  Tool is out of range  Move the tool closer to the controller and make sure you have a clear line of sight to the controller   Failed pairing (Bluetooth)  Interference from other tools  The Bluetooth module can be sensitive; make sure to move other Bluetooth devices further away from the controller, or switch them off if possible   Failed pairing (Bluetooth)  All six slots have been filled and all six tools have been assigned to a Virtual Station  Remove one of the existing paired tools from the Virtual Station (in the Virtual Stationmenu, in the Toolfield)   Tool disappeared from the Tool list (Bluetooth)  When pairing additional tools, existing tools will disappear from the connected tools list (in the Toolsmenu)  Press the tool trigger to make it appear in the list again   Tool disappeared from the Tool list (Bluetooth)  Tools may disappear from the list when the tool has been outside radio coverage  Make sure to be inside the radio coverage area and press the tool trigger to make it appear in the list again"},{"id":"11688473995","fileName":"1168847399523858408843.html","title":"Reference","level":1,"position":832,"hasContent":false,"hierarchy":[],"content":"  In this section, you can find miscellaneous useful information. "},{"id":"67265675","fileName":"67265675.html","title":"Terms and Definitions","level":2,"position":833,"hasContent":true,"hierarchy":["Reference"],"content":"       Term   Synonym   Definition   Note    batch   multiple tightening using the same tightening program and socket    batch sequence  sequence  multiple tightening using a combination of different tightening programs and sockets    controller GUI   user interface at controller buttons or touch screen    event   controller and tool status signals    final angle   actual measured angle value at the end of the tightening cycle    final torque   actual measured torque value at the end of the tightening cycle    GUI    user interface made up of interactive graphical elements such as windows, icons and symbols on a display     HMI  Human Machine Interface  user interface to tool or controller  The HMI can be a computer web-based interface or controller touch screen.   IAM  Intelligent Application Module  removable module in controller containing program, configuration parameters and tightening results    line structure   sorting and grouping controllers in structures, folders or sub-folders in ToolsTalk  The line structure is a method for improving the visibility of a large group of controllers in a structured manner.   post view torque   function for monitoring and detecting torque maximum and minimum values before rundown is complete  One purpose of post view torque is the use of a self-locking nut.   Tightening program  Parameter set  configuration of parameters and values to control and monitor a single tightening action, and to store the tightening result    push   transfer of data saved in ToolsTalk to the controller memory    QIF  Quality Integrated Fastening  fully integrated line of nutrunners, controllers, accessories and process monitoring tools to guarantee high quality and traceability of tightening in industrial assembly systems  QIF was developed at Atlas Copco and is preferably used in motor vehicle industry and other assembly situations where many joints are critical. The QIF concept also includes process monitoring and documentation.   QIF accessory   accessory for operator communication and guidance used in QIF  Accessory products used for communication between system and operator. For example: scanner, operator panel, stacklight and socket selector. The communication provides improved quality and traceability in the assembly process.   quick step   tightening strategy  A tightening strategy to reduce the joint’s preload scatter by combining an initial step with a given speed and torque and then reducing the speed in the final step.   Re-hit detection   detection of re-tightening of an already tightened joint    rotate   tightening strategy which rotates the tool head.  Rotate is mainly used for test or demonstration purposes.   rundown complete   end of the rundown step, when the screw head is in contact with the surface and the tightening step begins    rundown step   step when a bolt enters the thread until the bolt head touches the surface    snug   screw or bolt is approximately finger-tight to the surface    socket selector   QIF accessory, consisting of a socket tray with lamps, that can be used to guide an operator to the correct socket    soft start   start tightening at slow speed during a specified rotation angle  The function helps the bolt to enter the thread in a well controlled way and may prevent unwanted ergonomic tool movement when the trigger is pressed.   stacklight   QIF accessory, which handles the communication between operator and controller through digital signals like lamps, buttons, switches and buzzer    target   desired result of a tightening  The target is expressed in torque or angle.   target angle   desired angle value at the end of the tightening cycle, measured from a reference point    target torque   desired torque value at the end of the tightening cycle    three step   tightening strategy  A tightening strategy to reduce the joint’s preload scatter and relaxation effects with an initial step with a given speed and torque followed by a short loosening step before the final tightening at reduced speed.   tightening step   step from when a bolt head has reached the surface until the tightening has reached the desired target torque or target angle    tightening strategy   algorithm which continuously controls and monitors the tightening process  The user can select a strategy optimized for the joint and program certain parameters.   TurboTight   tightening strategy  A tightening strategy based on the tool’s maximum speed to perform fast and ergonomic tightening. The strategy requires only a target torque value to be set.   two step   tightening strategy  A tightening strategy to reduce the joint’s preload scatter and relaxation effects with an initial step with a given speed and torque, followed by a short-term stop, before the final tightening at reduced speed.   web GUI   user interface to controller through web browser window from a remote computer    virtual station  virtual controller  software abstraction of a physical controller to behave like multiple controllers  A controller can have only one cable tool connected to it, but several wireless tools. Each tool is connected to its own virtual station.   Virtual station type   License containing a bundle of controller features.  This license is required for running a virtual station.   Virtual station feature   License for individual features.  Can be used to complement Virtual station type licenses.   Controller feature   License for controller-wide features, such as Soft PLC and StepSync.  Are assigned to an entire controller and can be used by all virtual stations."},{"id":"18265939851","fileName":"1826593985123858426763.html","title":"Input Signals","level":2,"position":834,"hasContent":true,"hierarchy":["Reference"],"content":"      Signal  Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]  Devices     title   item   item   item   none   none   subnodes "},{"id":"15043972875","fileName":"15043972875.html","title":"Abort Sequence - 10012","level":3,"position":835,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" When a Batch sequence abort request is received, the Batch sequence functionality aborts the batch sequence only after getting the ongoing tightening result.  Name in SoftPLC: ABORT_BATCH_SEQUENCE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":836,"hasContent":true,"hierarchy":["Reference","Input Signals","Abort Sequence - 10012"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":837,"hasContent":true,"hierarchy":["Reference","Input Signals","Abort Sequence - 10012"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":838,"hasContent":true,"hierarchy":["Reference","Input Signals","Abort Sequence - 10012"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":839,"hasContent":true,"hierarchy":["Reference","Input Signals","Abort Sequence - 10012"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":840,"hasContent":true,"hierarchy":["Reference","Input Signals","Abort Sequence - 10012"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":841,"hasContent":true,"hierarchy":["Reference","Input Signals","Abort Sequence - 10012"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":842,"hasContent":true,"hierarchy":["Reference","Input Signals","Abort Sequence - 10012"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":843,"hasContent":true,"hierarchy":["Reference","Input Signals","Abort Sequence - 10012"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":844,"hasContent":true,"hierarchy":["Reference","Input Signals","Abort Sequence - 10012"],"content":"  I\/O Expander: TRUE"},{"id":"19436912523","fileName":"19436912523.html","title":"Abort Sequence and Clear Results - 10127","level":3,"position":845,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" When signal \"Abort sequence and clear results\" is set, the ongoing sequence is aborted and signals related to \"Clear results\" are cleared.  Name in SoftPLC:ABORT_SEQ_AND_CLEAR_RES      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":846,"hasContent":true,"hierarchy":["Reference","Input Signals","Abort Sequence and Clear Results - 10127"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":847,"hasContent":true,"hierarchy":["Reference","Input Signals","Abort Sequence and Clear Results - 10127"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":848,"hasContent":true,"hierarchy":["Reference","Input Signals","Abort Sequence and Clear Results - 10127"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":849,"hasContent":true,"hierarchy":["Reference","Input Signals","Abort Sequence and Clear Results - 10127"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":850,"hasContent":true,"hierarchy":["Reference","Input Signals","Abort Sequence and Clear Results - 10127"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":851,"hasContent":true,"hierarchy":["Reference","Input Signals","Abort Sequence and Clear Results - 10127"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":852,"hasContent":true,"hierarchy":["Reference","Input Signals","Abort Sequence and Clear Results - 10127"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":853,"hasContent":true,"hierarchy":["Reference","Input Signals","Abort Sequence and Clear Results - 10127"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":854,"hasContent":true,"hierarchy":["Reference","Input Signals","Abort Sequence and Clear Results - 10127"],"content":"  I\/O Expander: TRUE"},{"id":"15058654091","fileName":"15058654091.html","title":"Acknowledge Events - 10004","level":3,"position":855,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Acknowledge of an event.  Name in SoftPLC: ACKNOWLEDGE_EVENT      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":856,"hasContent":true,"hierarchy":["Reference","Input Signals","Acknowledge Events - 10004"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":857,"hasContent":true,"hierarchy":["Reference","Input Signals","Acknowledge Events - 10004"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":858,"hasContent":true,"hierarchy":["Reference","Input Signals","Acknowledge Events - 10004"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":859,"hasContent":true,"hierarchy":["Reference","Input Signals","Acknowledge Events - 10004"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":860,"hasContent":true,"hierarchy":["Reference","Input Signals","Acknowledge Events - 10004"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":861,"hasContent":true,"hierarchy":["Reference","Input Signals","Acknowledge Events - 10004"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":862,"hasContent":true,"hierarchy":["Reference","Input Signals","Acknowledge Events - 10004"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":863,"hasContent":true,"hierarchy":["Reference","Input Signals","Acknowledge Events - 10004"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":864,"hasContent":true,"hierarchy":["Reference","Input Signals","Acknowledge Events - 10004"],"content":"  I\/O Expander: TRUE"},{"id":"15058661387","fileName":"15058661387.html","title":"Activate Tool Scanner - 10075","level":3,"position":865,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Activates the tool scanner through an external source.  Name in SoftPLC: ACTIVATE_TOOL_SCANNER      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":866,"hasContent":true,"hierarchy":["Reference","Input Signals","Activate Tool Scanner - 10075"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":867,"hasContent":true,"hierarchy":["Reference","Input Signals","Activate Tool Scanner - 10075"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":868,"hasContent":true,"hierarchy":["Reference","Input Signals","Activate Tool Scanner - 10075"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":869,"hasContent":true,"hierarchy":["Reference","Input Signals","Activate Tool Scanner - 10075"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":870,"hasContent":true,"hierarchy":["Reference","Input Signals","Activate Tool Scanner - 10075"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":871,"hasContent":true,"hierarchy":["Reference","Input Signals","Activate Tool Scanner - 10075"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":872,"hasContent":true,"hierarchy":["Reference","Input Signals","Activate Tool Scanner - 10075"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":873,"hasContent":true,"hierarchy":["Reference","Input Signals","Activate Tool Scanner - 10075"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":874,"hasContent":true,"hierarchy":["Reference","Input Signals","Activate Tool Scanner - 10075"],"content":"  I\/O Expander: TRUE"},{"id":"15110504331","fileName":"15110504331.html","title":"Batch Decrement - 10002","level":3,"position":875,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Incrementally decreases the batch counter by one.  Name in SoftPLC: BATCH_DECREMENT      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":876,"hasContent":true,"hierarchy":["Reference","Input Signals","Batch Decrement - 10002"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":877,"hasContent":true,"hierarchy":["Reference","Input Signals","Batch Decrement - 10002"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":878,"hasContent":true,"hierarchy":["Reference","Input Signals","Batch Decrement - 10002"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":879,"hasContent":true,"hierarchy":["Reference","Input Signals","Batch Decrement - 10002"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":880,"hasContent":true,"hierarchy":["Reference","Input Signals","Batch Decrement - 10002"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":881,"hasContent":true,"hierarchy":["Reference","Input Signals","Batch Decrement - 10002"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":882,"hasContent":true,"hierarchy":["Reference","Input Signals","Batch Decrement - 10002"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":883,"hasContent":true,"hierarchy":["Reference","Input Signals","Batch Decrement - 10002"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":884,"hasContent":true,"hierarchy":["Reference","Input Signals","Batch Decrement - 10002"],"content":"  I\/O Expander: TRUE"},{"id":"15110848523","fileName":"15110848523.html","title":"Batch Increment - 10001","level":3,"position":885,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Incrementally increases the batch counter by one.  Name in SoftPLC: BATCH_INCREMENT      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":886,"hasContent":true,"hierarchy":["Reference","Input Signals","Batch Increment - 10001"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":887,"hasContent":true,"hierarchy":["Reference","Input Signals","Batch Increment - 10001"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":888,"hasContent":true,"hierarchy":["Reference","Input Signals","Batch Increment - 10001"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":889,"hasContent":true,"hierarchy":["Reference","Input Signals","Batch Increment - 10001"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":890,"hasContent":true,"hierarchy":["Reference","Input Signals","Batch Increment - 10001"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":891,"hasContent":true,"hierarchy":["Reference","Input Signals","Batch Increment - 10001"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":892,"hasContent":true,"hierarchy":["Reference","Input Signals","Batch Increment - 10001"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":893,"hasContent":true,"hierarchy":["Reference","Input Signals","Batch Increment - 10001"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":894,"hasContent":true,"hierarchy":["Reference","Input Signals","Batch Increment - 10001"],"content":"  I\/O Expander: TRUE"},{"id":"15632943499","fileName":"15632943499.html","title":"Bypass Identifier - 10123","level":3,"position":895,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" In source batch string used to bypass an identifier string in string receiving sequence.      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":896,"hasContent":true,"hierarchy":["Reference","Input Signals","Bypass Identifier - 10123"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":897,"hasContent":true,"hierarchy":["Reference","Input Signals","Bypass Identifier - 10123"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":898,"hasContent":true,"hierarchy":["Reference","Input Signals","Bypass Identifier - 10123"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":899,"hasContent":true,"hierarchy":["Reference","Input Signals","Bypass Identifier - 10123"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":900,"hasContent":true,"hierarchy":["Reference","Input Signals","Bypass Identifier - 10123"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":901,"hasContent":true,"hierarchy":["Reference","Input Signals","Bypass Identifier - 10123"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":902,"hasContent":true,"hierarchy":["Reference","Input Signals","Bypass Identifier - 10123"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":903,"hasContent":true,"hierarchy":["Reference","Input Signals","Bypass Identifier - 10123"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":904,"hasContent":true,"hierarchy":["Reference","Input Signals","Bypass Identifier - 10123"],"content":"  I\/O Expander: TRUE"},{"id":"15137503371","fileName":"15137503371.html","title":"Bypass Tightening Program - 10008","level":3,"position":905,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Skips the next tightening program in the running batch sequence.  Name in SoftPLC: BYPASS_PSET      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":906,"hasContent":true,"hierarchy":["Reference","Input Signals","Bypass Tightening Program - 10008"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":907,"hasContent":true,"hierarchy":["Reference","Input Signals","Bypass Tightening Program - 10008"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":908,"hasContent":true,"hierarchy":["Reference","Input Signals","Bypass Tightening Program - 10008"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":909,"hasContent":true,"hierarchy":["Reference","Input Signals","Bypass Tightening Program - 10008"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":910,"hasContent":true,"hierarchy":["Reference","Input Signals","Bypass Tightening Program - 10008"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":911,"hasContent":true,"hierarchy":["Reference","Input Signals","Bypass Tightening Program - 10008"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":912,"hasContent":true,"hierarchy":["Reference","Input Signals","Bypass Tightening Program - 10008"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":913,"hasContent":true,"hierarchy":["Reference","Input Signals","Bypass Tightening Program - 10008"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":914,"hasContent":true,"hierarchy":["Reference","Input Signals","Bypass Tightening Program - 10008"],"content":"  I\/O Expander: TRUE"},{"id":"15138424331","fileName":"15138424331.html","title":"Disable Fieldbus - 10049","level":3,"position":915,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Disables the fieldbus.  Name in SoftPLC: DISABLE_FIELDBUS      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Filedbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":916,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable Fieldbus - 10049"],"content":" Filedbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":917,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable Fieldbus - 10049"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":918,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable Fieldbus - 10049"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":919,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable Fieldbus - 10049"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":920,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable Fieldbus - 10049"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":921,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable Fieldbus - 10049"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":922,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable Fieldbus - 10049"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":923,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable Fieldbus - 10049"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":924,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable Fieldbus - 10049"],"content":"  I\/O Expander: TRUE"},{"id":"15138445451","fileName":"15138445451.html","title":"Disable tool - 30000","level":3,"position":925,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" If the signal is set to True, a tool is immediately stopped and locked.      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":926,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable tool - 30000"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":927,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable tool - 30000"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":928,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable tool - 30000"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":929,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable tool - 30000"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":930,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable tool - 30000"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":931,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable tool - 30000"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":932,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable tool - 30000"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":933,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable tool - 30000"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":934,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable tool - 30000"],"content":" I\/O Expander: FALSE"},{"id":"15138466571","fileName":"15138466571.html","title":"Disable Tool Scanner - 10119","level":3,"position":935,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Disables tool scanner when scanning by tool trigger when signal is set. It is still possible to scan by using the scan button but the scan string is ignored.  Name in SoftPLC: DISABLE_TOOL_SCANNER      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":936,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable Tool Scanner - 10119"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":937,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable Tool Scanner - 10119"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":938,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable Tool Scanner - 10119"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":939,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable Tool Scanner - 10119"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":940,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable Tool Scanner - 10119"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":941,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable Tool Scanner - 10119"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":942,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable Tool Scanner - 10119"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":943,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable Tool Scanner - 10119"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":944,"hasContent":true,"hierarchy":["Reference","Input Signals","Disable Tool Scanner - 10119"],"content":"  I\/O Expander: TRUE"},{"id":"15138487691","fileName":"15138487691.html","title":"Dynamic Batch Size - 10074","level":3,"position":945,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  Name in SoftPLC: DYNAMIC_BATCH_SIZE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  16   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":946,"hasContent":true,"hierarchy":["Reference","Input Signals","Dynamic Batch Size - 10074"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":947,"hasContent":true,"hierarchy":["Reference","Input Signals","Dynamic Batch Size - 10074"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":948,"hasContent":true,"hierarchy":["Reference","Input Signals","Dynamic Batch Size - 10074"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":949,"hasContent":true,"hierarchy":["Reference","Input Signals","Dynamic Batch Size - 10074"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":950,"hasContent":true,"hierarchy":["Reference","Input Signals","Dynamic Batch Size - 10074"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":951,"hasContent":true,"hierarchy":["Reference","Input Signals","Dynamic Batch Size - 10074"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":952,"hasContent":true,"hierarchy":["Reference","Input Signals","Dynamic Batch Size - 10074"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":953,"hasContent":true,"hierarchy":["Reference","Input Signals","Dynamic Batch Size - 10074"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":954,"hasContent":true,"hierarchy":["Reference","Input Signals","Dynamic Batch Size - 10074"],"content":" I\/O Expander: FALSE"},{"id":"15138508811","fileName":"15138508811.html","title":"External OK - 10063","level":3,"position":955,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  Name in SoftPLC: EXTERNAL_OK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":956,"hasContent":true,"hierarchy":["Reference","Input Signals","External OK - 10063"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":957,"hasContent":true,"hierarchy":["Reference","Input Signals","External OK - 10063"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":958,"hasContent":true,"hierarchy":["Reference","Input Signals","External OK - 10063"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":959,"hasContent":true,"hierarchy":["Reference","Input Signals","External OK - 10063"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":960,"hasContent":true,"hierarchy":["Reference","Input Signals","External OK - 10063"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":961,"hasContent":true,"hierarchy":["Reference","Input Signals","External OK - 10063"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":962,"hasContent":true,"hierarchy":["Reference","Input Signals","External OK - 10063"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":963,"hasContent":true,"hierarchy":["Reference","Input Signals","External OK - 10063"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":964,"hasContent":true,"hierarchy":["Reference","Input Signals","External OK - 10063"],"content":"  I\/O Expander: TRUE"},{"id":"15293574027","fileName":"15293574027.html","title":"Fieldbus Lock Loosening - 20021","level":3,"position":965,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" A Virtual Station is locked when starting a loosening if the signal is set from a connected and supported accessory. An ongoing loosening is aborted immediately when Fieldbus Lock Loosening is set to True, due to the Stop Drive setting.      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":966,"hasContent":true,"hierarchy":["Reference","Input Signals","Fieldbus Lock Loosening - 20021"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":967,"hasContent":true,"hierarchy":["Reference","Input Signals","Fieldbus Lock Loosening - 20021"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":968,"hasContent":true,"hierarchy":["Reference","Input Signals","Fieldbus Lock Loosening - 20021"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":969,"hasContent":true,"hierarchy":["Reference","Input Signals","Fieldbus Lock Loosening - 20021"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":970,"hasContent":true,"hierarchy":["Reference","Input Signals","Fieldbus Lock Loosening - 20021"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":971,"hasContent":true,"hierarchy":["Reference","Input Signals","Fieldbus Lock Loosening - 20021"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":972,"hasContent":true,"hierarchy":["Reference","Input Signals","Fieldbus Lock Loosening - 20021"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":973,"hasContent":true,"hierarchy":["Reference","Input Signals","Fieldbus Lock Loosening - 20021"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":974,"hasContent":true,"hierarchy":["Reference","Input Signals","Fieldbus Lock Loosening - 20021"],"content":" I\/O Expander: FALSE"},{"id":"15293577739","fileName":"15293577739.html","title":"Fieldbus Lock Tightening - 20020","level":3,"position":975,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" A Virtual Station is locked when starting a tightening if the signal is set from a connected and supported accessory. An ongoing tightening is aborted immediately when Fieldbus Lock Tightening is set to True, due to the Stop Drive setting.      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":976,"hasContent":true,"hierarchy":["Reference","Input Signals","Fieldbus Lock Tightening - 20020"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":977,"hasContent":true,"hierarchy":["Reference","Input Signals","Fieldbus Lock Tightening - 20020"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":978,"hasContent":true,"hierarchy":["Reference","Input Signals","Fieldbus Lock Tightening - 20020"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":979,"hasContent":true,"hierarchy":["Reference","Input Signals","Fieldbus Lock Tightening - 20020"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":980,"hasContent":true,"hierarchy":["Reference","Input Signals","Fieldbus Lock Tightening - 20020"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":981,"hasContent":true,"hierarchy":["Reference","Input Signals","Fieldbus Lock Tightening - 20020"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":982,"hasContent":true,"hierarchy":["Reference","Input Signals","Fieldbus Lock Tightening - 20020"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":983,"hasContent":true,"hierarchy":["Reference","Input Signals","Fieldbus Lock Tightening - 20020"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":984,"hasContent":true,"hierarchy":["Reference","Input Signals","Fieldbus Lock Tightening - 20020"],"content":" I\/O Expander: FALSE"},{"id":"15293581451","fileName":"15293581451.html","title":"Flush Read Result Queue - 30005","level":3,"position":985,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":986,"hasContent":true,"hierarchy":["Reference","Input Signals","Flush Read Result Queue - 30005"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":987,"hasContent":true,"hierarchy":["Reference","Input Signals","Flush Read Result Queue - 30005"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":988,"hasContent":true,"hierarchy":["Reference","Input Signals","Flush Read Result Queue - 30005"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":989,"hasContent":true,"hierarchy":["Reference","Input Signals","Flush Read Result Queue - 30005"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":990,"hasContent":true,"hierarchy":["Reference","Input Signals","Flush Read Result Queue - 30005"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":991,"hasContent":true,"hierarchy":["Reference","Input Signals","Flush Read Result Queue - 30005"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":992,"hasContent":true,"hierarchy":["Reference","Input Signals","Flush Read Result Queue - 30005"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":993,"hasContent":true,"hierarchy":["Reference","Input Signals","Flush Read Result Queue - 30005"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":994,"hasContent":true,"hierarchy":["Reference","Input Signals","Flush Read Result Queue - 30005"],"content":" I\/O Expander: FALSE"},{"id":"15293585163","fileName":"15293585163.html","title":"ID for Dynamic Batch Size - 10073","level":3,"position":995,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  Name in SoftPLC: DYNAMIC_BATCH_SIZE_TPID      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Integer  1  16   TreatZeroAsOne  State  Integer  1  16   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":996,"hasContent":true,"hierarchy":["Reference","Input Signals","ID for Dynamic Batch Size - 10073"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":997,"hasContent":true,"hierarchy":["Reference","Input Signals","ID for Dynamic Batch Size - 10073"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":998,"hasContent":true,"hierarchy":["Reference","Input Signals","ID for Dynamic Batch Size - 10073"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":999,"hasContent":true,"hierarchy":["Reference","Input Signals","ID for Dynamic Batch Size - 10073"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1000,"hasContent":true,"hierarchy":["Reference","Input Signals","ID for Dynamic Batch Size - 10073"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1001,"hasContent":true,"hierarchy":["Reference","Input Signals","ID for Dynamic Batch Size - 10073"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1002,"hasContent":true,"hierarchy":["Reference","Input Signals","ID for Dynamic Batch Size - 10073"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1003,"hasContent":true,"hierarchy":["Reference","Input Signals","ID for Dynamic Batch Size - 10073"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1004,"hasContent":true,"hierarchy":["Reference","Input Signals","ID for Dynamic Batch Size - 10073"],"content":" I\/O Expander: FALSE"},{"id":"15294283787","fileName":"15294283787.html","title":"Lock Loosening - 20003","level":3,"position":1005,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Filedbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1006,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Loosening - 20003"],"content":" Filedbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1007,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Loosening - 20003"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1008,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Loosening - 20003"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1009,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Loosening - 20003"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1010,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Loosening - 20003"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1011,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Loosening - 20003"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1012,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Loosening - 20003"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1013,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Loosening - 20003"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1014,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Loosening - 20003"],"content":"  I\/O Expander: TRUE"},{"id":"15294287499","fileName":"15294287499.html","title":"Lock Tightening - 20002","level":3,"position":1015,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Tool locked for tightening by digital input.      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Filedbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1016,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tightening - 20002"],"content":" Filedbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1017,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tightening - 20002"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1018,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tightening - 20002"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1019,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tightening - 20002"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1020,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tightening - 20002"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1021,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tightening - 20002"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1022,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tightening - 20002"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1023,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tightening - 20002"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1024,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tightening - 20002"],"content":"  I\/O Expander: TRUE"},{"id":"15294995211","fileName":"15294995211.html","title":"Lock Tool Active High - 20004","level":3,"position":1025,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Filedbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1026,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tool Active High - 20004"],"content":" Filedbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1027,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tool Active High - 20004"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1028,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tool Active High - 20004"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1029,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tool Active High - 20004"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1030,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tool Active High - 20004"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1031,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tool Active High - 20004"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1032,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tool Active High - 20004"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1033,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tool Active High - 20004"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1034,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tool Active High - 20004"],"content":"  I\/O Expander: TRUE"},{"id":"15294998923","fileName":"15294998923.html","title":"Lock Tool Active Low - 20061","level":3,"position":1035,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Locks the tool when this signal is low.      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Filedbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1036,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tool Active Low - 20061"],"content":" Filedbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1037,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tool Active Low - 20061"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1038,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tool Active Low - 20061"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1039,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tool Active Low - 20061"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1040,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tool Active Low - 20061"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1041,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tool Active Low - 20061"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1042,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tool Active Low - 20061"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1043,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tool Active Low - 20061"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1044,"hasContent":true,"hierarchy":["Reference","Input Signals","Lock Tool Active Low - 20061"],"content":"  I\/O Expander: TRUE"},{"id":"15295002891","fileName":"15295002891.html","title":"Manual Mode - 10061","level":3,"position":1045,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Used to set the Virtual Station in manual mode. If the signal is True (high) the signal 101 - Manual mode is high. If the signal is False (low) the signal 101 - Manual mode is low.  Name in SoftPLC: SET_MANUAL_MODE      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1046,"hasContent":true,"hierarchy":["Reference","Input Signals","Manual Mode - 10061"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1047,"hasContent":true,"hierarchy":["Reference","Input Signals","Manual Mode - 10061"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1048,"hasContent":true,"hierarchy":["Reference","Input Signals","Manual Mode - 10061"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1049,"hasContent":true,"hierarchy":["Reference","Input Signals","Manual Mode - 10061"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1050,"hasContent":true,"hierarchy":["Reference","Input Signals","Manual Mode - 10061"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1051,"hasContent":true,"hierarchy":["Reference","Input Signals","Manual Mode - 10061"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1052,"hasContent":true,"hierarchy":["Reference","Input Signals","Manual Mode - 10061"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1053,"hasContent":true,"hierarchy":["Reference","Input Signals","Manual Mode - 10061"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1054,"hasContent":true,"hierarchy":["Reference","Input Signals","Manual Mode - 10061"],"content":"  I\/O Expander: TRUE"},{"id":"15295006603","fileName":"15295006603.html","title":"Master Unlock - 10005","level":3,"position":1055,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Master Unlock is an input signal which unlocks the following functions and signals.  FUNCTIONS:   Disable loosening at OK tightening  Disable loosening at NOK tightening  Disable tightening  Max consecutive NOK  Tool Lock on Sequence complete  SIGNALS:   20001 - Pending Event Acknowledge Lock  20002 - Lock Tightening  20003 - Lock Loosening  20004 - Lock Tool Active High  20013 - WorkTask Lock Tightening  20014 - WorkTask Lock Loosening  20015 - Batch Done lLock  20018 - Open Protocol Lock  20020 - Fieldbus Lock Tightening  20021 - Fieldbus Lock Loosening  20022 - Disable Loosening At OK Tight  20023 - Too Many NOK Tightenings Lock  20033 - Line Control Lock  20034 - Locked By Alternative Identifier  Name in SoftPLC: MASTER_UNLOCK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1056,"hasContent":true,"hierarchy":["Reference","Input Signals","Master Unlock - 10005"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1057,"hasContent":true,"hierarchy":["Reference","Input Signals","Master Unlock - 10005"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1058,"hasContent":true,"hierarchy":["Reference","Input Signals","Master Unlock - 10005"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1059,"hasContent":true,"hierarchy":["Reference","Input Signals","Master Unlock - 10005"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1060,"hasContent":true,"hierarchy":["Reference","Input Signals","Master Unlock - 10005"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1061,"hasContent":true,"hierarchy":["Reference","Input Signals","Master Unlock - 10005"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1062,"hasContent":true,"hierarchy":["Reference","Input Signals","Master Unlock - 10005"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1063,"hasContent":true,"hierarchy":["Reference","Input Signals","Master Unlock - 10005"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1064,"hasContent":true,"hierarchy":["Reference","Input Signals","Master Unlock - 10005"],"content":"  I\/O Expander: TRUE"},{"id":"15295151115","fileName":"15295151115.html","title":"Pulse Stop - 10030","level":3,"position":1065,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" If this signal is generated any ongoing tightening or loosening will be stopped. Used in combination with 10024 or 10072.  Name in SoftPLC: TIGHTENING_STOP_PULSE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1066,"hasContent":true,"hierarchy":["Reference","Input Signals","Pulse Stop - 10030"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1067,"hasContent":true,"hierarchy":["Reference","Input Signals","Pulse Stop - 10030"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1068,"hasContent":true,"hierarchy":["Reference","Input Signals","Pulse Stop - 10030"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1069,"hasContent":true,"hierarchy":["Reference","Input Signals","Pulse Stop - 10030"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1070,"hasContent":true,"hierarchy":["Reference","Input Signals","Pulse Stop - 10030"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1071,"hasContent":true,"hierarchy":["Reference","Input Signals","Pulse Stop - 10030"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1072,"hasContent":true,"hierarchy":["Reference","Input Signals","Pulse Stop - 10030"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1073,"hasContent":true,"hierarchy":["Reference","Input Signals","Pulse Stop - 10030"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1074,"hasContent":true,"hierarchy":["Reference","Input Signals","Pulse Stop - 10030"],"content":"  I\/O Expander: TRUE"},{"id":"15307366411","fileName":"15307366411.html","title":"Read Result Handshake Ack - 30004","level":3,"position":1075,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Enable the Read Result Handshake feature in the Fieldbus device for making the controller available for the signal Rear Result Handshake Ack.      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1076,"hasContent":true,"hierarchy":["Reference","Input Signals","Read Result Handshake Ack - 30004"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1077,"hasContent":true,"hierarchy":["Reference","Input Signals","Read Result Handshake Ack - 30004"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1078,"hasContent":true,"hierarchy":["Reference","Input Signals","Read Result Handshake Ack - 30004"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1079,"hasContent":true,"hierarchy":["Reference","Input Signals","Read Result Handshake Ack - 30004"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1080,"hasContent":true,"hierarchy":["Reference","Input Signals","Read Result Handshake Ack - 30004"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1081,"hasContent":true,"hierarchy":["Reference","Input Signals","Read Result Handshake Ack - 30004"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1082,"hasContent":true,"hierarchy":["Reference","Input Signals","Read Result Handshake Ack - 30004"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1083,"hasContent":true,"hierarchy":["Reference","Input Signals","Read Result Handshake Ack - 30004"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1084,"hasContent":true,"hierarchy":["Reference","Input Signals","Read Result Handshake Ack - 30004"],"content":" I\/O Expander: FALSE"},{"id":"15307370379","fileName":"15307370379.html","title":"Reset All Identifiers - 10115","level":3,"position":1085,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" In Source batch string used to reset all received string identifiers from string receiving sequence at once. In other worktasks clears VIN number.  Name in SoftPLC: RESET_ALL_IDENTIFIERS      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1086,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset All Identifiers - 10115"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1087,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset All Identifiers - 10115"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1088,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset All Identifiers - 10115"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1089,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset All Identifiers - 10115"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1090,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset All Identifiers - 10115"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1091,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset All Identifiers - 10115"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1092,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset All Identifiers - 10115"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1093,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset All Identifiers - 10115"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1094,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset All Identifiers - 10115"],"content":"  I\/O Expander: TRUE"},{"id":"15307374091","fileName":"15307374091.html","title":"Reset Batch - 10003","level":3,"position":1095,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Resets the batch counter to 0. No batch OK (nxOK). If batch OK is activated, it will be deactivated.  Name in SoftPLC: RESET_BATCH      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1096,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Batch - 10003"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1097,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Batch - 10003"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1098,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Batch - 10003"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1099,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Batch - 10003"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1100,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Batch - 10003"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1101,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Batch - 10003"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1102,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Batch - 10003"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1103,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Batch - 10003"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1104,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Batch - 10003"],"content":"  I\/O Expander: TRUE"},{"id":"15308184203","fileName":"15308184203.html","title":"Reset Batch Sequence - 10053","level":3,"position":1105,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Resets the Batch Sequence. Unlocks a tool that is locked by Tool Lock on Complete.  Name in SoftPLC: RESET_BATCH_SEQUENCE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1106,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Batch Sequence - 10053"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1107,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Batch Sequence - 10053"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1108,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Batch Sequence - 10053"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1109,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Batch Sequence - 10053"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1110,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Batch Sequence - 10053"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1111,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Batch Sequence - 10053"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1112,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Batch Sequence - 10053"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1113,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Batch Sequence - 10053"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1114,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Batch Sequence - 10053"],"content":"  I\/O Expander: TRUE"},{"id":"15308187915","fileName":"15308187915.html","title":"Reset Bistable Relay - 10022","level":3,"position":1115,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Reset the bistable relay output.  Name in SoftPLC: RESET_BISTABLE_RELAY      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1116,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Bistable Relay - 10022"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1117,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Bistable Relay - 10022"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1118,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Bistable Relay - 10022"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1119,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Bistable Relay - 10022"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1120,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Bistable Relay - 10022"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1121,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Bistable Relay - 10022"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1122,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Bistable Relay - 10022"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1123,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Bistable Relay - 10022"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1124,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Bistable Relay - 10022"],"content":"  I\/O Expander: TRUE"},{"id":"15308191627","fileName":"15308191627.html","title":"Reset Latest Identifier - 10114","level":3,"position":1125,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" In Source batch string used to reset latest received string from string receiving sequence. In other worktasks clears VIN number.  Name in SoftPLC: RESET_LATEST_IDENTIFIER      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1126,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Latest Identifier - 10114"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1127,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Latest Identifier - 10114"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1128,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Latest Identifier - 10114"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1129,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Latest Identifier - 10114"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1130,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Latest Identifier - 10114"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1131,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Latest Identifier - 10114"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1132,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Latest Identifier - 10114"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1133,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Latest Identifier - 10114"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1134,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Latest Identifier - 10114"],"content":"  I\/O Expander: TRUE"},{"id":"15309462539","fileName":"15309462539.html","title":"Reset Relays - 10120","level":3,"position":1135,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Resets all signals.  Name in SoftPLC: RESET_RELAYS      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1136,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Relays - 10120"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1137,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Relays - 10120"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1138,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Relays - 10120"],"content":" Internal I\/O: TRUE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1139,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Relays - 10120"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1140,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Relays - 10120"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1141,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Relays - 10120"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1142,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Relays - 10120"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1143,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Relays - 10120"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1144,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Relays - 10120"],"content":"  I\/O Expander: TRUE"},{"id":"15309466251","fileName":"15309466251.html","title":"Reset Sequence Status - 10118","level":3,"position":1145,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Resets signals Batch Sequence Done\/OK\/NOK and Sequence Aborted.  Name in SoftPLC: RESET_SEQUENCE_STATUS      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1146,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Sequence Status - 10118"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1147,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Sequence Status - 10118"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1148,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Sequence Status - 10118"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1149,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Sequence Status - 10118"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1150,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Sequence Status - 10118"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1151,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Sequence Status - 10118"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1152,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Sequence Status - 10118"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1153,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Sequence Status - 10118"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1154,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Sequence Status - 10118"],"content":"  I\/O Expander: TRUE"},{"id":"15309469963","fileName":"15309469963.html","title":"Reset Too Many NOK - 10013","level":3,"position":1155,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Reset the batch after receiving lock Too Many NOK  Name in SoftPLC: RESET_TOO_MANY_NOK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1156,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Too Many NOK - 10013"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1157,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Too Many NOK - 10013"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1158,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Too Many NOK - 10013"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1159,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Too Many NOK - 10013"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1160,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Too Many NOK - 10013"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1161,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Too Many NOK - 10013"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1162,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Too Many NOK - 10013"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1163,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Too Many NOK - 10013"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1164,"hasContent":true,"hierarchy":["Reference","Input Signals","Reset Too Many NOK - 10013"],"content":"  I\/O Expander: TRUE"},{"id":"15309473675","fileName":"15309473675.html","title":"Select Input - 10020","level":3,"position":1165,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Selects Tightening Program withing Source Tightening\/Batch within sequence.  Name in SoftPLC: SELECT_INPUT_VALUE      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Integer  1  16   TreatZeroAsOne  State  Integer  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: TRUE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1166,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input - 10020"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1167,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input - 10020"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1168,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input - 10020"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1169,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input - 10020"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1170,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input - 10020"],"content":" Tool Functions: FALSE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":4,"position":1171,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input - 10020"],"content":" ST Selector: TRUE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1172,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input - 10020"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1173,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input - 10020"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1174,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input - 10020"],"content":" I\/O Expander: FALSE"},{"id":"15311768587","fileName":"15311768587.html","title":"Select Input and Dynamic Batch Size - 30007","level":3,"position":1175,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" It is used to set the Batch Size for a specific \"Identifier Number\" in a Source Tightening Task, running \"External batch control\". Batch size can be set to 1-250.  If Batch size is set to 0, it is treated as infinite batch. The user is not able to un-set a Batch back to a state where it has no size, once it has been set.      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Integer  16  16   TreatZeroAsOne  State  Integer  16  16   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1176,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input and Dynamic Batch Size - 30007"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1177,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input and Dynamic Batch Size - 30007"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1178,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input and Dynamic Batch Size - 30007"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1179,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input and Dynamic Batch Size - 30007"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1180,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input and Dynamic Batch Size - 30007"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1181,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input and Dynamic Batch Size - 30007"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1182,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input and Dynamic Batch Size - 30007"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1183,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input and Dynamic Batch Size - 30007"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1184,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input and Dynamic Batch Size - 30007"],"content":" I\/O Expander: FALSE"},{"id":"15138529931","fileName":"15138529931.html","title":"Select Input Bit 0 - 10016","level":3,"position":1185,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_0      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Filedbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1186,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 0 - 10016"],"content":" Filedbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1187,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 0 - 10016"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1188,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 0 - 10016"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1189,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 0 - 10016"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1190,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 0 - 10016"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1191,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 0 - 10016"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1192,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 0 - 10016"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1193,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 0 - 10016"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1194,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 0 - 10016"],"content":"  I\/O Expander: TRUE"},{"id":"15210523147","fileName":"15210523147.html","title":"Select Input Bit 1 - 10017","level":3,"position":1195,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_1      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Filedbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1196,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 1 - 10017"],"content":" Filedbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1197,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 1 - 10017"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1198,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 1 - 10017"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1199,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 1 - 10017"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1200,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 1 - 10017"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1201,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 1 - 10017"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1202,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 1 - 10017"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1203,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 1 - 10017"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1204,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 1 - 10017"],"content":"  I\/O Expander: TRUE"},{"id":"15217407371","fileName":"15217407371.html","title":"Select Input Bit 2 - 10018","level":3,"position":1205,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_2      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Filedbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1206,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 2 - 10018"],"content":" Filedbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1207,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 2 - 10018"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1208,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 2 - 10018"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1209,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 2 - 10018"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1210,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 2 - 10018"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1211,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 2 - 10018"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1212,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 2 - 10018"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1213,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 2 - 10018"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1214,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 2 - 10018"],"content":"  I\/O Expander: TRUE"},{"id":"15217430795","fileName":"15217430795.html","title":"Select Input Bit 3 - 10019","level":3,"position":1215,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_3      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Filedbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1216,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 3 - 10019"],"content":" Filedbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1217,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 3 - 10019"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1218,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 3 - 10019"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1219,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 3 - 10019"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1220,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 3 - 10019"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1221,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 3 - 10019"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1222,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 3 - 10019"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1223,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 3 - 10019"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1224,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 3 - 10019"],"content":"  I\/O Expander: TRUE"},{"id":"15294280075","fileName":"15294280075.html","title":"Select Input Bit 4 - 10066","level":3,"position":1225,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_4      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Filedbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1226,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 4 - 10066"],"content":" Filedbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1227,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 4 - 10066"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1228,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 4 - 10066"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1229,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 4 - 10066"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1230,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 4 - 10066"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1231,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 4 - 10066"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1232,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 4 - 10066"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1233,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 4 - 10066"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1234,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 4 - 10066"],"content":"  I\/O Expander: TRUE"},{"id":"15189453323","fileName":"15189453323.html","title":"Select Input Bit 5 - 10067","level":3,"position":1235,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_5      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Filedbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1236,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 5 - 10067"],"content":" Filedbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1237,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 5 - 10067"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1238,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 5 - 10067"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1239,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 5 - 10067"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1240,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 5 - 10067"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1241,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 5 - 10067"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1242,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 5 - 10067"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1243,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 5 - 10067"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1244,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 5 - 10067"],"content":"  I\/O Expander: TRUE"},{"id":"15217501067","fileName":"15217501067.html","title":"Select Input Bit 6 - 10068","level":3,"position":1245,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_6      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Filedbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1246,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 6 - 10068"],"content":" Filedbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1247,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 6 - 10068"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1248,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 6 - 10068"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1249,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 6 - 10068"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1250,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 6 - 10068"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1251,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 6 - 10068"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1252,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 6 - 10068"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1253,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 6 - 10068"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1254,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 6 - 10068"],"content":"  I\/O Expander: TRUE"},{"id":"15217524491","fileName":"15217524491.html","title":"Select Input Bit 7 - 10069","level":3,"position":1255,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_7      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Filedbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1256,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 7 - 10069"],"content":" Filedbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1257,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 7 - 10069"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1258,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 7 - 10069"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1259,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 7 - 10069"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1260,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 7 - 10069"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1261,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 7 - 10069"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1262,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 7 - 10069"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1263,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 7 - 10069"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1264,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 7 - 10069"],"content":"  I\/O Expander: TRUE"},{"id":"15217550603","fileName":"15217550603.html","title":"Select Input Bit 8 - 10070","level":3,"position":1265,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_8      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Filedbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1266,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 8 - 10070"],"content":" Filedbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1267,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 8 - 10070"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1268,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 8 - 10070"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1269,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 8 - 10070"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1270,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 8 - 10070"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1271,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 8 - 10070"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1272,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 8 - 10070"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1273,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 8 - 10070"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1274,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 8 - 10070"],"content":"  I\/O Expander: TRUE"},{"id":"15217919627","fileName":"15217919627.html","title":"Select Input Bit 9 - 10071","level":3,"position":1275,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  Name in SoftPLC: SEL_INPUT_BIT_9      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Filedbus: FALSE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1276,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 9 - 10071"],"content":" Filedbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1277,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 9 - 10071"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1278,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 9 - 10071"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1279,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 9 - 10071"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1280,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 9 - 10071"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1281,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 9 - 10071"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1282,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 9 - 10071"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1283,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 9 - 10071"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1284,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Input Bit 9 - 10071"],"content":"  I\/O Expander: TRUE"},{"id":"15311772299","fileName":"15311772299.html","title":"Select Loosening - 10029","level":3,"position":1285,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Selects loosening as default operation mode and used in combination with Start Tools -10028 signal.  Name in SoftPLC: SELECT_LOOSENING      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1286,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Loosening - 10029"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1287,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Loosening - 10029"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1288,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Loosening - 10029"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1289,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Loosening - 10029"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1290,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Loosening - 10029"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1291,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Loosening - 10029"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1292,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Loosening - 10029"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1293,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Loosening - 10029"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1294,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Loosening - 10029"],"content":"  I\/O Expander: TRUE"},{"id":"15311776267","fileName":"15311776267.html","title":"Select Next Identifier Number - 10116","level":3,"position":1295,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  It is possible to use the signal Select Next Identifier Number when a task in the virtual station is configured as:   Batch Sequence   Source Tightening   Source Batch    Number Identifiermethod   String Identifiermethod  ST Selector configurable functions Take Nextand Take Previousenable the input signals Select Next Identifier Numberand Select Previous Identifier Number. Batch Sequence selected as Virtual Station Task If Free Orderswitch has been enabled, the signal Select Next Identifier Number can select different batches within the selected sequence.  Before selecting batches, it is mandatory that they have the identifier number assigned. If a batch does not have the identifier number assigned, the signal Select Next Identifier Number cannot select it, even if Free Orderswitch is enabled. It enables looping through the batches that have a configured identifier number. If identifier number is \"None\", it is possible to select it only after all Batches with configured identifier number are completed.  It is possible to do looping, but 0 is skipped. When a batch is finished, it is no longer selectable. For example, in case of batches with assigned identifier numbers 1,2,4,5, the signal runs in loop: 1,2,4,5,1,2,4... as long as the batches are not finished. Source Tightening selected as Virtual Station Task The signal selects the next identifier number from the list of tightening programs specified in the Source Tightening task. The selection runs from the currently selected identifier number to the next larger one. When the biggest identifier number is selected, this signal selects 0; after 0, the signal selects the next bigger identifier number.  If 0 is selected as identifier number, the tool is locked. If the identifier number has been added to the Source Tightening list, but no tightening program has ever been assigned to it, it is skipped while looping through the Source Tightening list. If the tightening program is assigned to an identifier number and then it is removed from the list of tightening programs, it is still possible to select this identifier number. In this case, the tool is locked because there is not a specific tightening program. When Selector Modeswitch is set to Confirm, the socket selector needs to be assigned and configured. All tightening programs can be selected, but before running them, appropriate socket must be lifted from the socket selector. Source Batch selected as Virtual Station Task In Sources > Batch Sequence > Source Batch, when the identifier method is set to Number, the signal Select Next Identifier Number selects sequences from a list of sequences shown in Source Batchtask.  It is possible to do looping through 0. The signal Select Next Identifier Number selects only the identifier numbers assigned to sequences. For example, if there are 4 sequences available with identifier numbers 1,2,4, and 8, the signal Select Next Identifier Number iterates and selects 1,2,4,8,0,1,2...  The identifier numbers not defined are not selected. In Sources > Batch Sequence > Source Batch, when the identifier method is set to String, it is necessary to select the sequence through external sources (like scanner or Open Protocol). The signal Select Next Identifier Number is able to select the batches within the selected sequence.  Name in SoftPLC: SELECT_NEXT_ID_NUMBER      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: TRUE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1296,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Next Identifier Number - 10116"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1297,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Next Identifier Number - 10116"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1298,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Next Identifier Number - 10116"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1299,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Next Identifier Number - 10116"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1300,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Next Identifier Number - 10116"],"content":" Tool Functions: TRUE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":4,"position":1301,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Next Identifier Number - 10116"],"content":" ST Selector: TRUE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1302,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Next Identifier Number - 10116"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1303,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Next Identifier Number - 10116"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1304,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Next Identifier Number - 10116"],"content":"  I\/O Expander: TRUE"},{"id":"15314250379","fileName":"15314250379.html","title":"Select Previous Identifier Number - 10117","level":3,"position":1305,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  It is possible to use the signal Select Previous Identifier Number when a task in the virtual station is configured as:   Batch Sequence   Source Tightening   Source Batch    Number Identifiermethod   String Identifiermethod  ST Selector configurable functions Take Nextand Take Previousenable the input signals Select Next Identifier Numberand Select Previous Identifier Number. Batch Sequence selected as Virtual Station Task If Free Orderswitch has been enabled, the signal Select Previous Identifier Number can select different batches within the selected sequence.  Before selecting batches, it is mandatory that they have the identifier number assigned. If a batch does not have the identifier number assigned, the signal Select Previous Identifier Number cannot select it, even if Free Orderswitch is enabled. It enables looping through the batches that have a configured identifier number. If identifier number is \"None\", it is possible to select it only after all Batches with configured identifier number are completed.  It is possible to do looping, but 0 is skipped. When a batch is finished, it is no longer selectable. For example, in case of batches with assigned identifier numbers 1,2,4,5, the signal runs in loop: 5,4,2,1,5,4,2... as long as the batches are not finished. Source Tightening selected as Virtual Station Task The signal selects the previous identifier number from the list of tightening programs specified in the Source Tightening task. The selection runs from the currently selected identifier number to the previous lower one. When the smallest identifier number is selected, this signal selects 0; after 0, the signal selects the next smaller identifier number.  If 0 is selected as identifier number, the tool is locked. If the tightening program is assigned to an identifier number and then it is removed from the list of tightening programs, it is still possible to select this identifier number. In this case, the tool is locked because there is not a specific tightening program. When Selector Modeswitch is set to Confirm, the socket selector needs to be assigned and configured. All tightening programs can be selected, but before running them, appropriate socket must be lifted from the socket selector. Source Batch selected as Virtual Station Task In Sources > Batch Sequence > Source Batch, when the identifier method is set to Number, the signal Select Previous Identifier Number selects sequences from a list of sequences shown in Source Batchtask.  It is possible to do looping through 0. The signal Select Previous Identifier Number selects only the identifier numbers assigned to sequences. For example, if there are 4 sequences available with identifier numbers 1,2,4, and 8, the signal Select Previous Identifier Number iterates and selects 8,4,2,1,0,8,4...  The identifier numbers not defined are not selected. In Sources > Batch Sequence > Source Batch, when the identifier method is set to String, it is necessary to select the sequence through external sources (like scanner or Open Protocol). The signal Select Previous Identifier Number is able to select the batches within the selected sequence.  Name in SoftPLC: SELECT_PREVIOUS_ID_NUMBER      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: TRUE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1306,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Previous Identifier Number - 10117"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1307,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Previous Identifier Number - 10117"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1308,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Previous Identifier Number - 10117"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1309,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Previous Identifier Number - 10117"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1310,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Previous Identifier Number - 10117"],"content":" Tool Functions: TRUE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":4,"position":1311,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Previous Identifier Number - 10117"],"content":" ST Selector: TRUE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1312,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Previous Identifier Number - 10117"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1313,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Previous Identifier Number - 10117"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1314,"hasContent":true,"hierarchy":["Reference","Input Signals","Select Previous Identifier Number - 10117"],"content":"  I\/O Expander: TRUE"},{"id":"15314254091","fileName":"15314254091.html","title":"Set Bistable Relay - 10021","level":3,"position":1315,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Set the bistable relay output.  Name in SoftPLC: SET_BISTABLE_RELAY      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1316,"hasContent":true,"hierarchy":["Reference","Input Signals","Set Bistable Relay - 10021"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1317,"hasContent":true,"hierarchy":["Reference","Input Signals","Set Bistable Relay - 10021"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1318,"hasContent":true,"hierarchy":["Reference","Input Signals","Set Bistable Relay - 10021"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1319,"hasContent":true,"hierarchy":["Reference","Input Signals","Set Bistable Relay - 10021"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1320,"hasContent":true,"hierarchy":["Reference","Input Signals","Set Bistable Relay - 10021"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1321,"hasContent":true,"hierarchy":["Reference","Input Signals","Set Bistable Relay - 10021"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1322,"hasContent":true,"hierarchy":["Reference","Input Signals","Set Bistable Relay - 10021"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1323,"hasContent":true,"hierarchy":["Reference","Input Signals","Set Bistable Relay - 10021"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1324,"hasContent":true,"hierarchy":["Reference","Input Signals","Set Bistable Relay - 10021"],"content":"  I\/O Expander: TRUE"},{"id":"20700443275","fileName":"20700443275.html","title":"Set CCW Direction - 10132","level":3,"position":1325,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  Set CCW Directionis an input signal which forces the SR21\/SL tool to counterclockwise direction.  The SR21\/SL tool is forced to counterclockwise direction only if, after being connected with the controller, the signal is set \"high\". This operation is essential, even if the signal was set \"high\" before that the SR21\/SL tool was connected with the controller. If the tool is running clockwise, the signal will switch the direction to counterclockwise. If the tool is running counterclockwise, the direction will not change.  Set CCW Directionoverrides the input signal Toggle CW\/CCW For Next Run. If the signal is set \"low\", the tool will switch the direction to clockwise. When the tool is set to counterclockwise, the orange direction LED on the tool lights up.      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1326,"hasContent":true,"hierarchy":["Reference","Input Signals","Set CCW Direction - 10132"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1327,"hasContent":true,"hierarchy":["Reference","Input Signals","Set CCW Direction - 10132"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1328,"hasContent":true,"hierarchy":["Reference","Input Signals","Set CCW Direction - 10132"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1329,"hasContent":true,"hierarchy":["Reference","Input Signals","Set CCW Direction - 10132"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1330,"hasContent":true,"hierarchy":["Reference","Input Signals","Set CCW Direction - 10132"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1331,"hasContent":true,"hierarchy":["Reference","Input Signals","Set CCW Direction - 10132"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1332,"hasContent":true,"hierarchy":["Reference","Input Signals","Set CCW Direction - 10132"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1333,"hasContent":true,"hierarchy":["Reference","Input Signals","Set CCW Direction - 10132"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1334,"hasContent":true,"hierarchy":["Reference","Input Signals","Set CCW Direction - 10132"],"content":"  I\/O Expander: TRUE"},{"id":"22163331339","fileName":"22163331339.html","title":"Set Zero Position - 10135","level":3,"position":1335,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" For hand-held tools, the input signal Set Zero Positionkeeps the current position of the tools as home position. The signal is silently ignored if sent during an ongoing tightening. For fixtured tools, the input signal Set Zero Positionkeeps the current position of the tools as home position. The signal affects all the tools in the system, regardless of the virtual station. The signal is silently ignored by fixtured tools that are part of an ongoing tightening.  Name in SoftPLC: IN_EXTERNAL_SET_ZERO_POSITION      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1336,"hasContent":true,"hierarchy":["Reference","Input Signals","Set Zero Position - 10135"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1337,"hasContent":true,"hierarchy":["Reference","Input Signals","Set Zero Position - 10135"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1338,"hasContent":true,"hierarchy":["Reference","Input Signals","Set Zero Position - 10135"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1339,"hasContent":true,"hierarchy":["Reference","Input Signals","Set Zero Position - 10135"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1340,"hasContent":true,"hierarchy":["Reference","Input Signals","Set Zero Position - 10135"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1341,"hasContent":true,"hierarchy":["Reference","Input Signals","Set Zero Position - 10135"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1342,"hasContent":true,"hierarchy":["Reference","Input Signals","Set Zero Position - 10135"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1343,"hasContent":true,"hierarchy":["Reference","Input Signals","Set Zero Position - 10135"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1344,"hasContent":true,"hierarchy":["Reference","Input Signals","Set Zero Position - 10135"],"content":"  I\/O Expander: TRUE"},{"id":"15314257803","fileName":"15314257803.html","title":"Socket Selector External Green Light - 10046","level":3,"position":1345,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Controls green lights when socket selector is in external mode (how multiple physical devices are mapped to logical sockets are defined by the socket selector resource configuration).   Byte0 - logical sockets 1-4  Byte1 - logical sockets 5-8  Byte2 - logical sockets 9-12  Byte3 - logical sockets 13-16  Byte4 - logical sockets 17-20  Byte5 - logical sockets 21-24  Byte6 - logical sockets 25-28  Byte7 - logical sockets 29-32  2 bits per socket, 00=off, 01=flash, 10=solid  Name in SoftPLC: SOCKET_SEL_EXT_GREEN_LIGHT      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  uint64  1  64   SocketLedControlTwoDevices  State  uint64  1  64   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1346,"hasContent":true,"hierarchy":["Reference","Input Signals","Socket Selector External Green Light - 10046"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1347,"hasContent":true,"hierarchy":["Reference","Input Signals","Socket Selector External Green Light - 10046"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1348,"hasContent":true,"hierarchy":["Reference","Input Signals","Socket Selector External Green Light - 10046"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1349,"hasContent":true,"hierarchy":["Reference","Input Signals","Socket Selector External Green Light - 10046"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1350,"hasContent":true,"hierarchy":["Reference","Input Signals","Socket Selector External Green Light - 10046"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1351,"hasContent":true,"hierarchy":["Reference","Input Signals","Socket Selector External Green Light - 10046"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1352,"hasContent":true,"hierarchy":["Reference","Input Signals","Socket Selector External Green Light - 10046"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1353,"hasContent":true,"hierarchy":["Reference","Input Signals","Socket Selector External Green Light - 10046"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1354,"hasContent":true,"hierarchy":["Reference","Input Signals","Socket Selector External Green Light - 10046"],"content":" I\/O Expander: FALSE"},{"id":"15314261515","fileName":"15314261515.html","title":"Socket Selector External Red Light - 10047","level":3,"position":1355,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Controls red lights when socket selector is in external mode (how multiple physical devices are mapped to logical sockets are defined by the socket selector resource configuration).   Byte0 - logical sockets 1-4  Byte1 - logical sockets 5-8  Byte2 - logical sockets 9-12  Byte3 - logical sockets 13-16  Byte4 - logical sockets 17-20  Byte5 - logical sockets 21-24  Byte6 - logical sockets 25-28  Byte7 - logical sockets 29-32  2 bits per socket, 00=off, 01=flash, 10=solid  Name in SoftPLC: SOCKET_SEL_EXT_RED_LIGHT      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  uint64  1  64   SocketLedControlTwoDevices  State  uint64  1  64   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1356,"hasContent":true,"hierarchy":["Reference","Input Signals","Socket Selector External Red Light - 10047"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1357,"hasContent":true,"hierarchy":["Reference","Input Signals","Socket Selector External Red Light - 10047"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1358,"hasContent":true,"hierarchy":["Reference","Input Signals","Socket Selector External Red Light - 10047"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1359,"hasContent":true,"hierarchy":["Reference","Input Signals","Socket Selector External Red Light - 10047"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1360,"hasContent":true,"hierarchy":["Reference","Input Signals","Socket Selector External Red Light - 10047"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1361,"hasContent":true,"hierarchy":["Reference","Input Signals","Socket Selector External Red Light - 10047"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1362,"hasContent":true,"hierarchy":["Reference","Input Signals","Socket Selector External Red Light - 10047"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1363,"hasContent":true,"hierarchy":["Reference","Input Signals","Socket Selector External Red Light - 10047"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1364,"hasContent":true,"hierarchy":["Reference","Input Signals","Socket Selector External Red Light - 10047"],"content":" I\/O Expander: FALSE"},{"id":"15314726027","fileName":"15314726027.html","title":"Start Loosening - 10011","level":3,"position":1365,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Active signal starts loosening. Once digital input goes inactive the loosening must be stopped.  Name in SoftPLC: START_LOOSENING      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1366,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Loosening - 10011"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1367,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Loosening - 10011"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1368,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Loosening - 10011"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1369,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Loosening - 10011"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1370,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Loosening - 10011"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1371,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Loosening - 10011"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1372,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Loosening - 10011"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1373,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Loosening - 10011"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1374,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Loosening - 10011"],"content":"  I\/O Expander: TRUE"},{"id":"15319511435","fileName":"15319511435.html","title":"Start Tightening - 10010","level":3,"position":1375,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Active signal starts tightening. Once input goes inactive the tightening must be stopped.  Name in SoftPLC: START_TIGHTENING      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1376,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tightening - 10010"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1377,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tightening - 10010"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1378,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tightening - 10010"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1379,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tightening - 10010"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1380,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tightening - 10010"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1381,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tightening - 10010"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1382,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tightening - 10010"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1383,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tightening - 10010"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1384,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tightening - 10010"],"content":"  I\/O Expander: TRUE"},{"id":"15319515147","fileName":"15319515147.html","title":"Start Tightening Pulse - 10024","level":3,"position":1385,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" The tightening starts at signal. Runs until the tightening is finished, or until the 30 sec timeout in tightening program occurs.  Name in SoftPLC: TIGHTENING_START_PULSE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1386,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tightening Pulse - 10024"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1387,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tightening Pulse - 10024"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1388,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tightening Pulse - 10024"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1389,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tightening Pulse - 10024"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1390,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tightening Pulse - 10024"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1391,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tightening Pulse - 10024"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1392,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tightening Pulse - 10024"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1393,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tightening Pulse - 10024"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1394,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tightening Pulse - 10024"],"content":"  I\/O Expander: TRUE"},{"id":"15319518859","fileName":"15319518859.html","title":"Start Tools - 10028","level":3,"position":1395,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Active signal which starts the tool (default operation mode is tightening). As soon as signal goes inactive the tool must be stopped. Used in combination with Select Loosening - 10029 signal.  Name in SoftPLC: START_DRIVE_CONTINIOUS      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1396,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tools - 10028"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1397,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tools - 10028"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1398,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tools - 10028"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1399,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tools - 10028"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1400,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tools - 10028"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1401,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tools - 10028"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1402,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tools - 10028"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1403,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tools - 10028"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1404,"hasContent":true,"hierarchy":["Reference","Input Signals","Start Tools - 10028"],"content":"  I\/O Expander: TRUE"},{"id":"21014041227","fileName":"21014041227.html","title":"Stop (pulse) - 10129","level":3,"position":1405,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" If this signal is generated any ongoing tightening or loosening will be stopped. Used in combination with 10024 or 10072.  Name in SoftPLC: EXTERNAL_STOP_PULSE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1406,"hasContent":true,"hierarchy":["Reference","Input Signals","Stop (pulse) - 10129"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1407,"hasContent":true,"hierarchy":["Reference","Input Signals","Stop (pulse) - 10129"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1408,"hasContent":true,"hierarchy":["Reference","Input Signals","Stop (pulse) - 10129"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1409,"hasContent":true,"hierarchy":["Reference","Input Signals","Stop (pulse) - 10129"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1410,"hasContent":true,"hierarchy":["Reference","Input Signals","Stop (pulse) - 10129"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1411,"hasContent":true,"hierarchy":["Reference","Input Signals","Stop (pulse) - 10129"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1412,"hasContent":true,"hierarchy":["Reference","Input Signals","Stop (pulse) - 10129"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1413,"hasContent":true,"hierarchy":["Reference","Input Signals","Stop (pulse) - 10129"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1414,"hasContent":true,"hierarchy":["Reference","Input Signals","Stop (pulse) - 10129"],"content":"  I\/O Expander: TRUE"},{"id":"15319522571","fileName":"15319522571.html","title":"To SoftPLC - 10065","level":3,"position":1415,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  Name in SoftPLC: TO_PLC      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  uint8 array  1  1   Filedbus: FALSE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1416,"hasContent":true,"hierarchy":["Reference","Input Signals","To SoftPLC - 10065"],"content":" Filedbus: FALSE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1417,"hasContent":true,"hierarchy":["Reference","Input Signals","To SoftPLC - 10065"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1418,"hasContent":true,"hierarchy":["Reference","Input Signals","To SoftPLC - 10065"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1419,"hasContent":true,"hierarchy":["Reference","Input Signals","To SoftPLC - 10065"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1420,"hasContent":true,"hierarchy":["Reference","Input Signals","To SoftPLC - 10065"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1421,"hasContent":true,"hierarchy":["Reference","Input Signals","To SoftPLC - 10065"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1422,"hasContent":true,"hierarchy":["Reference","Input Signals","To SoftPLC - 10065"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1423,"hasContent":true,"hierarchy":["Reference","Input Signals","To SoftPLC - 10065"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1424,"hasContent":true,"hierarchy":["Reference","Input Signals","To SoftPLC - 10065"],"content":"  I\/O Expander: TRUE"},{"id":"20700240139","fileName":"20700240139.html","title":"Toggle CW\/CCW - 10130","level":3,"position":1425,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  Toggle CW\/CCWis an input signal which toggles the direction of the SR21\/SL tool. If the tool is running clockwise, the signal will toggle the direction to counterclockwise. If the tool is running counterclockwise, the signal will toggle the direction to clockwise.  Toggle CW\/CCWoverrides the input signal Toggle CW\/CCW For Next Run. When the tool is toggled to counterclockwise, the orange direction LED on the tool lights up.      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1426,"hasContent":true,"hierarchy":["Reference","Input Signals","Toggle CW\/CCW - 10130"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1427,"hasContent":true,"hierarchy":["Reference","Input Signals","Toggle CW\/CCW - 10130"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1428,"hasContent":true,"hierarchy":["Reference","Input Signals","Toggle CW\/CCW - 10130"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1429,"hasContent":true,"hierarchy":["Reference","Input Signals","Toggle CW\/CCW - 10130"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1430,"hasContent":true,"hierarchy":["Reference","Input Signals","Toggle CW\/CCW - 10130"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1431,"hasContent":true,"hierarchy":["Reference","Input Signals","Toggle CW\/CCW - 10130"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1432,"hasContent":true,"hierarchy":["Reference","Input Signals","Toggle CW\/CCW - 10130"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1433,"hasContent":true,"hierarchy":["Reference","Input Signals","Toggle CW\/CCW - 10130"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1434,"hasContent":true,"hierarchy":["Reference","Input Signals","Toggle CW\/CCW - 10130"],"content":"  I\/O Expander: TRUE"},{"id":"20700310795","fileName":"20700310795.html","title":"Toggle CW\/CCW For Next Run - 10131","level":3,"position":1435,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  Toggle CW\/CCW For Next Runis an input signal which toggles the direction of the SR21\/SL tool for the next tightening\/loosening. If the tool is running clockwise, the signal will toggle the direction to counterclockwise. If the tool is running counterclockwise, the signal will toggle the direction to clockwise. When the next tightening\/loosening is complete, the tool toggles back to the direction it was before the signal was sent. When the tool is toggled to counterclockwise for the next tightening\/loosening, the orange direction LED on the tool blinks.  It is possible to trigger the signal Toggle CW\/CCW For Next Runonly once. When the signal toggles the tool direction, any other update of this signal will be neglected.      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1436,"hasContent":true,"hierarchy":["Reference","Input Signals","Toggle CW\/CCW For Next Run - 10131"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1437,"hasContent":true,"hierarchy":["Reference","Input Signals","Toggle CW\/CCW For Next Run - 10131"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1438,"hasContent":true,"hierarchy":["Reference","Input Signals","Toggle CW\/CCW For Next Run - 10131"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1439,"hasContent":true,"hierarchy":["Reference","Input Signals","Toggle CW\/CCW For Next Run - 10131"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1440,"hasContent":true,"hierarchy":["Reference","Input Signals","Toggle CW\/CCW For Next Run - 10131"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1441,"hasContent":true,"hierarchy":["Reference","Input Signals","Toggle CW\/CCW For Next Run - 10131"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1442,"hasContent":true,"hierarchy":["Reference","Input Signals","Toggle CW\/CCW For Next Run - 10131"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1443,"hasContent":true,"hierarchy":["Reference","Input Signals","Toggle CW\/CCW For Next Run - 10131"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1444,"hasContent":true,"hierarchy":["Reference","Input Signals","Toggle CW\/CCW For Next Run - 10131"],"content":"  I\/O Expander: TRUE"},{"id":"15292388875","fileName":"15292388875.html","title":"Unlock Tool on Complete - 10051","level":3,"position":1445,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":" Unlocks a tool that is locked by \"Tool Lock on Complete\".  Name in SoftPLC: UNLOCK_TOOL_ON_COMPLETE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1446,"hasContent":true,"hierarchy":["Reference","Input Signals","Unlock Tool on Complete - 10051"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1447,"hasContent":true,"hierarchy":["Reference","Input Signals","Unlock Tool on Complete - 10051"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1448,"hasContent":true,"hierarchy":["Reference","Input Signals","Unlock Tool on Complete - 10051"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1449,"hasContent":true,"hierarchy":["Reference","Input Signals","Unlock Tool on Complete - 10051"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1450,"hasContent":true,"hierarchy":["Reference","Input Signals","Unlock Tool on Complete - 10051"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1451,"hasContent":true,"hierarchy":["Reference","Input Signals","Unlock Tool on Complete - 10051"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1452,"hasContent":true,"hierarchy":["Reference","Input Signals","Unlock Tool on Complete - 10051"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1453,"hasContent":true,"hierarchy":["Reference","Input Signals","Unlock Tool on Complete - 10051"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1454,"hasContent":true,"hierarchy":["Reference","Input Signals","Unlock Tool on Complete - 10051"],"content":"  I\/O Expander: TRUE"},{"id":"15292209803","fileName":"15292209803.html","title":"Unlock Tool on Disable - 10059","level":3,"position":1455,"hasContent":true,"hierarchy":["Reference","Input Signals"],"content":"  Name in SoftPLC: UNLOCK_TOOL_ON_DISABLE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1456,"hasContent":true,"hierarchy":["Reference","Input Signals","Unlock Tool on Disable - 10059"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1457,"hasContent":true,"hierarchy":["Reference","Input Signals","Unlock Tool on Disable - 10059"],"content":" Indicator Box: FALSE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1458,"hasContent":true,"hierarchy":["Reference","Input Signals","Unlock Tool on Disable - 10059"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1459,"hasContent":true,"hierarchy":["Reference","Input Signals","Unlock Tool on Disable - 10059"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1460,"hasContent":true,"hierarchy":["Reference","Input Signals","Unlock Tool on Disable - 10059"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1461,"hasContent":true,"hierarchy":["Reference","Input Signals","Unlock Tool on Disable - 10059"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1462,"hasContent":true,"hierarchy":["Reference","Input Signals","Unlock Tool on Disable - 10059"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1463,"hasContent":true,"hierarchy":["Reference","Input Signals","Unlock Tool on Disable - 10059"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1464,"hasContent":true,"hierarchy":["Reference","Input Signals","Unlock Tool on Disable - 10059"],"content":"  I\/O Expander: TRUE"},{"id":"18265945099","fileName":"1826594509923858434187.html","title":"Output Signals","level":2,"position":1465,"hasContent":true,"hierarchy":["Reference"],"content":"      Signal  Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]  Devices     title   item   item   item   none   none   subnodes "},{"id":"15058671499","fileName":"15058671499.html","title":"Active Identifier String - 186","level":3,"position":1466,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Set when an identifier string has been received and accepted by the work-task; it is necessary that even sequence or tightening program are running. If running Source batch-string, it is set when all scans have been received and a sequence had been selected. In that case it includes concatenated string consisted of saved positions. For other work-tasks it includes the “VIN” number.  Name in SoftPLC: ACTIVE_IDENTIFIER_STRING      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  String  8  800   IdentifierU32Hnw  State  String  8  800   IdentifierU32  State  String  8  800   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1467,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String - 186"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1468,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String - 186"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1469,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String - 186"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1470,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String - 186"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1471,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String - 186"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1472,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String - 186"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1473,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String - 186"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1474,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String - 186"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1475,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String - 186"],"content":" I\/O Expander: FALSE"},{"id":"15059027211","fileName":"15059027211.html","title":"Active Identifier String 1 - 188","level":3,"position":1476,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Signal corresponding to the first configured string in Source batch-string. Active Identifier String 1 signal is sent once a scanning sequence is done and a sequence has been selected, thus the identifier parts are active. The strings is filtered with saved position. Only sent when running Source batch string.  Name in SoftPLC: ACTIVE_ID_STRING_1      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  String  8  800   IdentifierU32Hnw  State  String  8  800   IdentifierU32  State  String  8  800   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1477,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 1 - 188"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1478,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 1 - 188"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1479,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 1 - 188"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1480,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 1 - 188"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1481,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 1 - 188"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1482,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 1 - 188"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1483,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 1 - 188"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1484,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 1 - 188"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1485,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 1 - 188"],"content":" I\/O Expander: FALSE"},{"id":"15059037835","fileName":"15059037835.html","title":"Active Identifier String 2 - 189","level":3,"position":1486,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Signal corresponding to the second configured string in Source batch-string. Active Identifier String 2 signal is sent once a scanning sequence is done and a sequence has been selected, thus the identifier parts are active. The strings is filtered with saved position. Only sent when running Source batch string.  Name in SoftPLC: ACTIVE_ID_STRING_2      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  String  8  800   IdentifierU32Hnw  State  String  8  800   IdentifierU32  State  String  8  800   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1487,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 2 - 189"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1488,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 2 - 189"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1489,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 2 - 189"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1490,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 2 - 189"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1491,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 2 - 189"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1492,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 2 - 189"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1493,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 2 - 189"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1494,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 2 - 189"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1495,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 2 - 189"],"content":" I\/O Expander: FALSE"},{"id":"15059713419","fileName":"15059713419.html","title":"Active Identifier String 3 - 190","level":3,"position":1496,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Signal corresponding to the third configured string in Source batch-string. Active Identifier String 3 signal is sent once a scanning sequence is done and a sequence has been selected, thus the identifier parts are active. The strings is filtered with saved position. Only sent when running Source batch string.  Name in SoftPLC: ACTIVE_ID_STRING_3      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  String  8  800   IdentifierU32Hnw  State  String  8  800   IdentifierU32  State  String  8  800   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1497,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 3 - 190"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1498,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 3 - 190"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1499,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 3 - 190"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1500,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 3 - 190"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1501,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 3 - 190"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1502,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 3 - 190"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1503,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 3 - 190"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1504,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 3 - 190"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1505,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 3 - 190"],"content":" I\/O Expander: FALSE"},{"id":"15059742219","fileName":"15059742219.html","title":"Active Identifier String 4 - 191","level":3,"position":1506,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Signal corresponding to the fourth configured string in Source batch-string. Active Identifier String 4 signal is sent once a scanning sequence is done and a sequence has been selected, thus the identifier parts are active. The strings is filtered with saved position. Only sent when running Source batch string.  Name in SoftPLC: ACTIVE_ID_STRING_4      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  String  8  800   IdentifierU32Hnw  State  String  8  800   IdentifierU32  State  String  8  800   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1507,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 4 - 191"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1508,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 4 - 191"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1509,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 4 - 191"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1510,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 4 - 191"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1511,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 4 - 191"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1512,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 4 - 191"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1513,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 4 - 191"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1514,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 4 - 191"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1515,"hasContent":true,"hierarchy":["Reference","Output Signals","Active Identifier String 4 - 191"],"content":" I\/O Expander: FALSE"},{"id":"15059777035","fileName":"15059777035.html","title":"Batch Completed - 30","level":3,"position":1516,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Batch Completed is an output signal which is triggered when the batch is complete. The batch result status (OK or NOK) has no effect on the Batch Completed signal.  Name in SoftPLC: BATCH_COMPLETED      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1517,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed - 30"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1518,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed - 30"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1519,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed - 30"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1520,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed - 30"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1521,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed - 30"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1522,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed - 30"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1523,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed - 30"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1524,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed - 30"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1525,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed - 30"],"content":"  I\/O Expander: TRUE"},{"id":"15103018891","fileName":"15103018891.html","title":"Batch Completed NOK - 37","level":3,"position":1526,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Batch finished with status NOK.  Name in SoftPLC: BATCH_COMPLETED_NOK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1527,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed NOK - 37"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1528,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed NOK - 37"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1529,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed NOK - 37"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1530,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed NOK - 37"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1531,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed NOK - 37"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1532,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed NOK - 37"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1533,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed NOK - 37"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1534,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed NOK - 37"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1535,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed NOK - 37"],"content":"  I\/O Expander: TRUE"},{"id":"15103026955","fileName":"15103026955.html","title":"Batch Completed OK - 36","level":3,"position":1536,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Batch finished with status OK.  Name in SoftPLC: BATCH_COMPLETED_OK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1537,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed OK - 36"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1538,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed OK - 36"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1539,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed OK - 36"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1540,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed OK - 36"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1541,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed OK - 36"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1542,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed OK - 36"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1543,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed OK - 36"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1544,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed OK - 36"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1545,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Completed OK - 36"],"content":"  I\/O Expander: TRUE"},{"id":"15103048843","fileName":"15103048843.html","title":"Batch Count - 31","level":3,"position":1546,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Batch Count is an output signal which shows the current number of tightening in the batch.  Name in SoftPLC: BATCH_COUNT      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  8   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: TRUE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1547,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Count - 31"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1548,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Count - 31"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1549,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Count - 31"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1550,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Count - 31"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1551,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Count - 31"],"content":" Tool Functions: FALSE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":4,"position":1552,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Count - 31"],"content":" ST Selector: TRUE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1553,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Count - 31"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1554,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Count - 31"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1555,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Count - 31"],"content":" I\/O Expander: FALSE"},{"id":"15114137867","fileName":"15114137867.html","title":"Batch Running - 32","level":3,"position":1556,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Indicates that a batch in a batch sequence is running.  Name in SoftPLC: BATCH_RUNNING      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1557,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Running - 32"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1558,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Running - 32"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1559,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Running - 32"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1560,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Running - 32"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1561,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Running - 32"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1562,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Running - 32"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1563,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Running - 32"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1564,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Running - 32"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1565,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Running - 32"],"content":"  I\/O Expander: TRUE"},{"id":"15118036619","fileName":"15118036619.html","title":"Batch Sequence Completed NOK - 46","level":3,"position":1566,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Batch sequence finished with status NOK.  Name in SoftPLC: BATCH_SEQUENCE_NOK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1567,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Completed NOK - 46"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1568,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Completed NOK - 46"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1569,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Completed NOK - 46"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1570,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Completed NOK - 46"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1571,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Completed NOK - 46"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1572,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Completed NOK - 46"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1573,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Completed NOK - 46"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1574,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Completed NOK - 46"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1575,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Completed NOK - 46"],"content":"  I\/O Expander: TRUE"},{"id":"15118064907","fileName":"15118064907.html","title":"Batch Sequence Completed OK - 45","level":3,"position":1576,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Batch sequence finished with status OK.  Name in SoftPLC: BATCH_SEQUENCE_OK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1577,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Completed OK - 45"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1578,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Completed OK - 45"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1579,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Completed OK - 45"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1580,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Completed OK - 45"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1581,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Completed OK - 45"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1582,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Completed OK - 45"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1583,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Completed OK - 45"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1584,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Completed OK - 45"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1585,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Completed OK - 45"],"content":"  I\/O Expander: TRUE"},{"id":"15118080907","fileName":"15118080907.html","title":"Batch Sequence Done - 48","level":3,"position":1586,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Indicates when a sequence is completed, both in case Batch Sequence Completed OK and Batch Sequence Completed NOK.  Name in SoftPLC: BATCH_SEQUENCE_COMPLETED      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  Event  Boolean  1  1   Invert  Event  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1587,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Done - 48"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1588,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Done - 48"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1589,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Done - 48"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1590,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Done - 48"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1591,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Done - 48"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1592,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Done - 48"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1593,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Done - 48"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1594,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Done - 48"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1595,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Done - 48"],"content":"  I\/O Expander: TRUE"},{"id":"15127467659","fileName":"15127467659.html","title":"Batch Sequence Running - 47","level":3,"position":1596,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Indicates if the Batch Sequence is running or not.  Name in SoftPLC: BATCHSEQUENCE_RUNNING      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1597,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Running - 47"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1598,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Running - 47"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1599,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Running - 47"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1600,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Running - 47"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1601,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Running - 47"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1602,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Running - 47"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1603,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Running - 47"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1604,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Running - 47"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1605,"hasContent":true,"hierarchy":["Reference","Output Signals","Batch Sequence Running - 47"],"content":"  I\/O Expander: TRUE"},{"id":"15128100363","fileName":"15128100363.html","title":"Bistable Relay - 40","level":3,"position":1606,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Bistable Relay is a signal controlled by the inputs \"Set Bistable Relay\" and \"Reset Bistable Relay\". After receiving the input \"Set Bistable Relay\", Bistable Relay signal is set to True. After receiving the input \"Reset Bistable Relay\", Bistable Relay signal is set to False. If \"Set Bistable Relay\" or \"Reset Bistable Relay\" goes low, the Bistable relay keeps its state. The state for the Bistable relay changes when \"Set Bistable Relay\" or \"Reset Bistable Relay\" goes high. After restarting the controller, the Bistable relay is set to False as default.  Name in SoftPLC: BISTABLE_RELAY      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1607,"hasContent":true,"hierarchy":["Reference","Output Signals","Bistable Relay - 40"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1608,"hasContent":true,"hierarchy":["Reference","Output Signals","Bistable Relay - 40"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1609,"hasContent":true,"hierarchy":["Reference","Output Signals","Bistable Relay - 40"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1610,"hasContent":true,"hierarchy":["Reference","Output Signals","Bistable Relay - 40"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1611,"hasContent":true,"hierarchy":["Reference","Output Signals","Bistable Relay - 40"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1612,"hasContent":true,"hierarchy":["Reference","Output Signals","Bistable Relay - 40"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1613,"hasContent":true,"hierarchy":["Reference","Output Signals","Bistable Relay - 40"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1614,"hasContent":true,"hierarchy":["Reference","Output Signals","Bistable Relay - 40"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1615,"hasContent":true,"hierarchy":["Reference","Output Signals","Bistable Relay - 40"],"content":"  I\/O Expander: TRUE"},{"id":"15137517067","fileName":"15137517067.html","title":"Calibration Alarm - 138","level":3,"position":1616,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" The Calibration alarm from the Tool maintenance configuration. Provides a reminder for when it is time to calibrate the tool.  Name in SoftPLC: CALIBRATION_ALARM      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1617,"hasContent":true,"hierarchy":["Reference","Output Signals","Calibration Alarm - 138"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1618,"hasContent":true,"hierarchy":["Reference","Output Signals","Calibration Alarm - 138"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1619,"hasContent":true,"hierarchy":["Reference","Output Signals","Calibration Alarm - 138"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1620,"hasContent":true,"hierarchy":["Reference","Output Signals","Calibration Alarm - 138"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1621,"hasContent":true,"hierarchy":["Reference","Output Signals","Calibration Alarm - 138"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1622,"hasContent":true,"hierarchy":["Reference","Output Signals","Calibration Alarm - 138"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1623,"hasContent":true,"hierarchy":["Reference","Output Signals","Calibration Alarm - 138"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1624,"hasContent":true,"hierarchy":["Reference","Output Signals","Calibration Alarm - 138"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1625,"hasContent":true,"hierarchy":["Reference","Output Signals","Calibration Alarm - 138"],"content":"  I\/O Expander: TRUE"},{"id":"15137552267","fileName":"15137552267.html","title":"Configuration Version - 88","level":3,"position":1626,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":"  Name in SoftPLC: CONFIGURATION_VERSION      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  32   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1627,"hasContent":true,"hierarchy":["Reference","Output Signals","Configuration Version - 88"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1628,"hasContent":true,"hierarchy":["Reference","Output Signals","Configuration Version - 88"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1629,"hasContent":true,"hierarchy":["Reference","Output Signals","Configuration Version - 88"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1630,"hasContent":true,"hierarchy":["Reference","Output Signals","Configuration Version - 88"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1631,"hasContent":true,"hierarchy":["Reference","Output Signals","Configuration Version - 88"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1632,"hasContent":true,"hierarchy":["Reference","Output Signals","Configuration Version - 88"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1633,"hasContent":true,"hierarchy":["Reference","Output Signals","Configuration Version - 88"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1634,"hasContent":true,"hierarchy":["Reference","Output Signals","Configuration Version - 88"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1635,"hasContent":true,"hierarchy":["Reference","Output Signals","Configuration Version - 88"],"content":" I\/O Expander: FALSE"},{"id":"21002018187","fileName":"21002018187.html","title":"Confirm loosening - 206","level":3,"position":1636,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Indicate if loosening is selected and possible to start. That is, a loosening sync mode or loosening program exists and are selected.  Name in SoftPLC: CONFIRM_LOOSENING      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1637,"hasContent":true,"hierarchy":["Reference","Output Signals","Confirm loosening - 206"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1638,"hasContent":true,"hierarchy":["Reference","Output Signals","Confirm loosening - 206"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1639,"hasContent":true,"hierarchy":["Reference","Output Signals","Confirm loosening - 206"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1640,"hasContent":true,"hierarchy":["Reference","Output Signals","Confirm loosening - 206"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1641,"hasContent":true,"hierarchy":["Reference","Output Signals","Confirm loosening - 206"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1642,"hasContent":true,"hierarchy":["Reference","Output Signals","Confirm loosening - 206"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1643,"hasContent":true,"hierarchy":["Reference","Output Signals","Confirm loosening - 206"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1644,"hasContent":true,"hierarchy":["Reference","Output Signals","Confirm loosening - 206"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1645,"hasContent":true,"hierarchy":["Reference","Output Signals","Confirm loosening - 206"],"content":"  I\/O Expander: TRUE"},{"id":"15137804427","fileName":"15137804427.html","title":"Controller Switched On - 42","level":3,"position":1646,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Set to true at start up of IO Exchange  Name in SoftPLC: IO_ON      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1647,"hasContent":true,"hierarchy":["Reference","Output Signals","Controller Switched On - 42"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1648,"hasContent":true,"hierarchy":["Reference","Output Signals","Controller Switched On - 42"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1649,"hasContent":true,"hierarchy":["Reference","Output Signals","Controller Switched On - 42"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1650,"hasContent":true,"hierarchy":["Reference","Output Signals","Controller Switched On - 42"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1651,"hasContent":true,"hierarchy":["Reference","Output Signals","Controller Switched On - 42"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1652,"hasContent":true,"hierarchy":["Reference","Output Signals","Controller Switched On - 42"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1653,"hasContent":true,"hierarchy":["Reference","Output Signals","Controller Switched On - 42"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1654,"hasContent":true,"hierarchy":["Reference","Output Signals","Controller Switched On - 42"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1655,"hasContent":true,"hierarchy":["Reference","Output Signals","Controller Switched On - 42"],"content":"  I\/O Expander: TRUE"},{"id":"15137889035","fileName":"15137889035.html","title":"Current Running Batch - 180","level":3,"position":1656,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Current Running Batch is an output signal which shows the index of the current running batch in a sequence. If the user uses a socket selector, \" Zero\" appears if none, more than one, or wrong socket is selected. If the user uses batch mode and a batch is running, \" 1\" appears for Source Tightening configurations.  Name in SoftPLC: CURRENT_RUNNING_BATCH_IX      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  8   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: TRUE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1657,"hasContent":true,"hierarchy":["Reference","Output Signals","Current Running Batch - 180"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1658,"hasContent":true,"hierarchy":["Reference","Output Signals","Current Running Batch - 180"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1659,"hasContent":true,"hierarchy":["Reference","Output Signals","Current Running Batch - 180"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1660,"hasContent":true,"hierarchy":["Reference","Output Signals","Current Running Batch - 180"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1661,"hasContent":true,"hierarchy":["Reference","Output Signals","Current Running Batch - 180"],"content":" Tool Functions: FALSE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":4,"position":1662,"hasContent":true,"hierarchy":["Reference","Output Signals","Current Running Batch - 180"],"content":" ST Selector: TRUE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1663,"hasContent":true,"hierarchy":["Reference","Output Signals","Current Running Batch - 180"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1664,"hasContent":true,"hierarchy":["Reference","Output Signals","Current Running Batch - 180"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1665,"hasContent":true,"hierarchy":["Reference","Output Signals","Current Running Batch - 180"],"content":" I\/O Expander: FALSE"},{"id":"15138001931","fileName":"15138001931.html","title":"Direction Switch CCW - 13","level":3,"position":1666,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" The direction switch on the tool is turned in counter clockwise direction.  Name in SoftPLC: DIRECTION_SWITCH_CCW      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1667,"hasContent":true,"hierarchy":["Reference","Output Signals","Direction Switch CCW - 13"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1668,"hasContent":true,"hierarchy":["Reference","Output Signals","Direction Switch CCW - 13"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1669,"hasContent":true,"hierarchy":["Reference","Output Signals","Direction Switch CCW - 13"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1670,"hasContent":true,"hierarchy":["Reference","Output Signals","Direction Switch CCW - 13"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1671,"hasContent":true,"hierarchy":["Reference","Output Signals","Direction Switch CCW - 13"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1672,"hasContent":true,"hierarchy":["Reference","Output Signals","Direction Switch CCW - 13"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1673,"hasContent":true,"hierarchy":["Reference","Output Signals","Direction Switch CCW - 13"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1674,"hasContent":true,"hierarchy":["Reference","Output Signals","Direction Switch CCW - 13"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1675,"hasContent":true,"hierarchy":["Reference","Output Signals","Direction Switch CCW - 13"],"content":"  I\/O Expander: TRUE"},{"id":"15138023051","fileName":"15138023051.html","title":"Direction Switch CW - 12","level":3,"position":1676,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" The direction switch on the tool is turned in clockwise direction.  Name in SoftPLC: DIRECTION_SWITCH_CW      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1677,"hasContent":true,"hierarchy":["Reference","Output Signals","Direction Switch CW - 12"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1678,"hasContent":true,"hierarchy":["Reference","Output Signals","Direction Switch CW - 12"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1679,"hasContent":true,"hierarchy":["Reference","Output Signals","Direction Switch CW - 12"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1680,"hasContent":true,"hierarchy":["Reference","Output Signals","Direction Switch CW - 12"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1681,"hasContent":true,"hierarchy":["Reference","Output Signals","Direction Switch CW - 12"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1682,"hasContent":true,"hierarchy":["Reference","Output Signals","Direction Switch CW - 12"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1683,"hasContent":true,"hierarchy":["Reference","Output Signals","Direction Switch CW - 12"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1684,"hasContent":true,"hierarchy":["Reference","Output Signals","Direction Switch CW - 12"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1685,"hasContent":true,"hierarchy":["Reference","Output Signals","Direction Switch CW - 12"],"content":"  I\/O Expander: TRUE"},{"id":"15138044171","fileName":"15138044171.html","title":"Emergency Stop - 20036","level":3,"position":1686,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":"  Name in SoftPLC: EMERGENCY_STOP      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1687,"hasContent":true,"hierarchy":["Reference","Output Signals","Emergency Stop - 20036"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1688,"hasContent":true,"hierarchy":["Reference","Output Signals","Emergency Stop - 20036"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1689,"hasContent":true,"hierarchy":["Reference","Output Signals","Emergency Stop - 20036"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1690,"hasContent":true,"hierarchy":["Reference","Output Signals","Emergency Stop - 20036"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1691,"hasContent":true,"hierarchy":["Reference","Output Signals","Emergency Stop - 20036"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1692,"hasContent":true,"hierarchy":["Reference","Output Signals","Emergency Stop - 20036"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1693,"hasContent":true,"hierarchy":["Reference","Output Signals","Emergency Stop - 20036"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1694,"hasContent":true,"hierarchy":["Reference","Output Signals","Emergency Stop - 20036"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1695,"hasContent":true,"hierarchy":["Reference","Output Signals","Emergency Stop - 20036"],"content":"  I\/O Expander: TRUE"},{"id":"15138065291","fileName":"15138065291.html","title":"Event Code - 30001","level":3,"position":1696,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Relay an event when it is triggered. Momentary, on for two cycle times.  Name in SoftPLC: EVENT_CODE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  1  16   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1697,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Code - 30001"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1698,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Code - 30001"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1699,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Code - 30001"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1700,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Code - 30001"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1701,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Code - 30001"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1702,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Code - 30001"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1703,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Code - 30001"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1704,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Code - 30001"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1705,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Code - 30001"],"content":" I\/O Expander: FALSE"},{"id":"15138086411","fileName":"15138086411.html","title":"Event Code Severity - 30003","level":3,"position":1706,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Event Code Severity is an output signal which is activated when the triggered event has severity of error or warning.  Name in SoftPLC: EVENT_CODE_SEVERITY      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1707,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Code Severity - 30003"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1708,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Code Severity - 30003"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1709,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Code Severity - 30003"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1710,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Code Severity - 30003"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1711,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Code Severity - 30003"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1712,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Code Severity - 30003"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1713,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Code Severity - 30003"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1714,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Code Severity - 30003"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1715,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Code Severity - 30003"],"content":" I\/O Expander: FALSE"},{"id":"15138107531","fileName":"15138107531.html","title":"Event Present - 161","level":3,"position":1716,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Indicates if event is triggered. It is only triggered on accessories if event requires an ACK.  Name in SoftPLC: EVENT_PRESENT      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1717,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Present - 161"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1718,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Present - 161"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1719,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Present - 161"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1720,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Present - 161"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1721,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Present - 161"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1722,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Present - 161"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1723,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Present - 161"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1724,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Present - 161"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1725,"hasContent":true,"hierarchy":["Reference","Output Signals","Event Present - 161"],"content":"  I\/O Expander: TRUE"},{"id":"15138128651","fileName":"15138128651.html","title":"Fieldbus Disconnected - 96","level":3,"position":1726,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":"  Name in SoftPLC: FIELDBUS_DISCONNECTED      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Filedbus: FALSE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1727,"hasContent":true,"hierarchy":["Reference","Output Signals","Fieldbus Disconnected - 96"],"content":" Filedbus: FALSE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1728,"hasContent":true,"hierarchy":["Reference","Output Signals","Fieldbus Disconnected - 96"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1729,"hasContent":true,"hierarchy":["Reference","Output Signals","Fieldbus Disconnected - 96"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1730,"hasContent":true,"hierarchy":["Reference","Output Signals","Fieldbus Disconnected - 96"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1731,"hasContent":true,"hierarchy":["Reference","Output Signals","Fieldbus Disconnected - 96"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1732,"hasContent":true,"hierarchy":["Reference","Output Signals","Fieldbus Disconnected - 96"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1733,"hasContent":true,"hierarchy":["Reference","Output Signals","Fieldbus Disconnected - 96"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1734,"hasContent":true,"hierarchy":["Reference","Output Signals","Fieldbus Disconnected - 96"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1735,"hasContent":true,"hierarchy":["Reference","Output Signals","Fieldbus Disconnected - 96"],"content":"  I\/O Expander: TRUE"},{"id":"15138572171","fileName":"15138572171.html","title":"Final Angle - 8","level":3,"position":1736,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":"      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Float  0  0   Filedbus: FALSE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: TRUE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1737,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle - 8"],"content":" Filedbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1738,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle - 8"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1739,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle - 8"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1740,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle - 8"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1741,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle - 8"],"content":" Tool Functions: FALSE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":4,"position":1742,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle - 8"],"content":" ST Selector: TRUE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1743,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle - 8"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1744,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle - 8"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1745,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle - 8"],"content":" I\/O Expander: FALSE"},{"id":"15138551051","fileName":"15138551051.html","title":"Final Angle - 31003","level":3,"position":1746,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Actual measured Angle value at the end of the tightening cycle.  Name in SoftPLC: FINAL_ANGLE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Integer  16  16   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1747,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle - 31003"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1748,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle - 31003"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1749,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle - 31003"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1750,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle - 31003"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1751,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle - 31003"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1752,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle - 31003"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1753,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle - 31003"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1754,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle - 31003"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1755,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle - 31003"],"content":" I\/O Expander: FALSE"},{"id":"15138593291","fileName":"15138593291.html","title":"Final Angle Status - 31006","level":3,"position":1756,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" This signal shows the status of the final angle, which can be:    OK- if the measured angle is within the limits configured in the tightening program.   HIGH- if the measured angle is more than the high limit configured in the tightening program.   LOW- if the measured angle is less than the low limit configured in the tightening program.  The value of the Final Angle Statussignal shows differently, depending on the configuration of the fieldbus signal. If the user selects the signal converter, the signal shows one of the following values:    O- Final Angle Status OK.   H- Final Angle Status High.   L- Final Angle Status Low. If there is no filter applied, the signal shows one of the following values:    1- Final Angle Status OK.   2- Final Angle Status High.   3- Final Angle Status Low.  Name in SoftPLC: FINAL_ANGLE_STATUS      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Integer  2  8   StatusAsChar  State  Integer  2  8   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1757,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle Status - 31006"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1758,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle Status - 31006"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1759,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle Status - 31006"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1760,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle Status - 31006"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1761,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle Status - 31006"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1762,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle Status - 31006"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1763,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle Status - 31006"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1764,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle Status - 31006"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1765,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Angle Status - 31006"],"content":" I\/O Expander: FALSE"},{"id":"15228729227","fileName":"15228729227.html","title":"Final Measured Current - 31017","level":3,"position":1766,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Current at the measurement step of final angle and final torque. It is sent when a result is available.      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  Event  Integer  32  32   FixedPointToDecimal  Event  Integer  32  32   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1767,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Measured Current - 31017"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1768,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Measured Current - 31017"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1769,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Measured Current - 31017"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1770,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Measured Current - 31017"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1771,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Measured Current - 31017"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1772,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Measured Current - 31017"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1773,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Measured Current - 31017"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1774,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Measured Current - 31017"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1775,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Measured Current - 31017"],"content":" I\/O Expander: FALSE"},{"id":"15228750347","fileName":"15228750347.html","title":"Final Target Speed - 31020","level":3,"position":1776,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" The target speed of the last step of the tightening program.      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Integer  16  16   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1777,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Target Speed - 31020"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1778,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Target Speed - 31020"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1779,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Target Speed - 31020"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1780,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Target Speed - 31020"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1781,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Target Speed - 31020"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1782,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Target Speed - 31020"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1783,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Target Speed - 31020"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1784,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Target Speed - 31020"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1785,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Target Speed - 31020"],"content":" I\/O Expander: FALSE"},{"id":"15228771467","fileName":"15228771467.html","title":"Final Target Torque - 31015","level":3,"position":1786,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Gets the target torque of the tightening program for a performed tightening. The value is copied from the program of the tightening result and is published after the tightening.  The Multistep programs retrieve the Target Torque from the last tightening step in the tightening program defined as Step Category \"Final\".      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  Event  Integer  32  32   FixedPointToDecimal  Event  Integer  32  32   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1787,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Target Torque - 31015"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1788,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Target Torque - 31015"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1789,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Target Torque - 31015"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1790,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Target Torque - 31015"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1791,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Target Torque - 31015"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1792,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Target Torque - 31015"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1793,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Target Torque - 31015"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1794,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Target Torque - 31015"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1795,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Target Torque - 31015"],"content":" I\/O Expander: FALSE"},{"id":"15228877707","fileName":"15228877707.html","title":"Final Torque - 5","level":3,"position":1796,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":"      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Float  1  1   Filedbus: FALSE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: TRUE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1797,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque - 5"],"content":" Filedbus: FALSE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1798,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque - 5"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1799,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque - 5"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1800,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque - 5"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1801,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque - 5"],"content":" Tool Functions: FALSE"},{"id":"18182364043","fileName":"18182364043.html","title":"ST Selector","level":4,"position":1802,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque - 5"],"content":" ST Selector: TRUE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1803,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque - 5"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1804,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque - 5"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1805,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque - 5"],"content":" I\/O Expander: FALSE"},{"id":"15228792587","fileName":"15228792587.html","title":"Final Torque - 31002","level":3,"position":1806,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Actual measured torque value at the end of the tightening cycle.  Name in SoftPLC: FINAL_TORQUE      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Integer  32  32   FixedPointToDecimal  State  Integer  32  32   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1807,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque - 31002"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1808,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque - 31002"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1809,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque - 31002"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1810,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque - 31002"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1811,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque - 31002"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1812,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque - 31002"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1813,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque - 31002"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1814,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque - 31002"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1815,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque - 31002"],"content":" I\/O Expander: FALSE"},{"id":"15228898827","fileName":"15228898827.html","title":"Final Torque Status - 31009","level":3,"position":1816,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" This signal shows the status of the final torque, which can be:    OK- if the measured torque is within the limits configured in the tightening program.   HIGH- if the measured torque is more than the high limit configured in the tightening program.   LOW- if the measured torque is less than the low limit configured in the tightening program.  The value of the Final Torque Statussignal shows differently, depending on the configuration of the fieldbus signal. If the user selects the signal converter, the signal shows one of the following values:    O- Final Torque Status OK.   H- Final Torque Status High.   L- Final Torque Status Low. If there is no filter applied, the signal shows one of the following values:    1- Final Torque Status OK.   2- Final Torque Status High.   3- Final Torque Status Low.  Name in SoftPLC: FINAL_TORQUE_STATUS      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Integer  2  8   StatusAsChar  State  Integer  2  8   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1817,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque Status - 31009"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1818,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque Status - 31009"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1819,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque Status - 31009"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1820,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque Status - 31009"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1821,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque Status - 31009"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1822,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque Status - 31009"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1823,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque Status - 31009"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1824,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque Status - 31009"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1825,"hasContent":true,"hierarchy":["Reference","Output Signals","Final Torque Status - 31009"],"content":" I\/O Expander: FALSE"},{"id":"15228919947","fileName":"15228919947.html","title":"First Target Torque - 31019","level":3,"position":1826,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Retrieves the first target torque after a completed tightening.      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  Event  Integer  32  32   FixedPointToDecimal  Event  Integer  32  32   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1827,"hasContent":true,"hierarchy":["Reference","Output Signals","First Target Torque - 31019"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1828,"hasContent":true,"hierarchy":["Reference","Output Signals","First Target Torque - 31019"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1829,"hasContent":true,"hierarchy":["Reference","Output Signals","First Target Torque - 31019"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1830,"hasContent":true,"hierarchy":["Reference","Output Signals","First Target Torque - 31019"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1831,"hasContent":true,"hierarchy":["Reference","Output Signals","First Target Torque - 31019"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1832,"hasContent":true,"hierarchy":["Reference","Output Signals","First Target Torque - 31019"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1833,"hasContent":true,"hierarchy":["Reference","Output Signals","First Target Torque - 31019"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1834,"hasContent":true,"hierarchy":["Reference","Output Signals","First Target Torque - 31019"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1835,"hasContent":true,"hierarchy":["Reference","Output Signals","First Target Torque - 31019"],"content":" I\/O Expander: FALSE"},{"id":"15228941067","fileName":"15228941067.html","title":"From SoftPLC - 10064","level":3,"position":1836,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Allocated bytes for data transfer from PLC to accessories.  Name in SoftPLC: FROM_PLC      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  uint8 array  8  8   Filedbus: FALSE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: FALSE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: FALSE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1837,"hasContent":true,"hierarchy":["Reference","Output Signals","From SoftPLC - 10064"],"content":" Filedbus: FALSE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1838,"hasContent":true,"hierarchy":["Reference","Output Signals","From SoftPLC - 10064"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1839,"hasContent":true,"hierarchy":["Reference","Output Signals","From SoftPLC - 10064"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1840,"hasContent":true,"hierarchy":["Reference","Output Signals","From SoftPLC - 10064"],"content":"  Operator Panel: TRUE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1841,"hasContent":true,"hierarchy":["Reference","Output Signals","From SoftPLC - 10064"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1842,"hasContent":true,"hierarchy":["Reference","Output Signals","From SoftPLC - 10064"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1843,"hasContent":true,"hierarchy":["Reference","Output Signals","From SoftPLC - 10064"],"content":"  Stacklight: TRUE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1844,"hasContent":true,"hierarchy":["Reference","Output Signals","From SoftPLC - 10064"],"content":" TLS Tag: FALSE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1845,"hasContent":true,"hierarchy":["Reference","Output Signals","From SoftPLC - 10064"],"content":"  I\/O Expander: TRUE"},{"id":"15138192011","fileName":"15138192011.html","title":"High Angle - 10","level":3,"position":1846,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Angle result is too high.  Name in SoftPLC: HIGH_ANGLE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1847,"hasContent":true,"hierarchy":["Reference","Output Signals","High Angle - 10"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1848,"hasContent":true,"hierarchy":["Reference","Output Signals","High Angle - 10"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1849,"hasContent":true,"hierarchy":["Reference","Output Signals","High Angle - 10"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1850,"hasContent":true,"hierarchy":["Reference","Output Signals","High Angle - 10"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1851,"hasContent":true,"hierarchy":["Reference","Output Signals","High Angle - 10"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1852,"hasContent":true,"hierarchy":["Reference","Output Signals","High Angle - 10"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1853,"hasContent":true,"hierarchy":["Reference","Output Signals","High Angle - 10"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1854,"hasContent":true,"hierarchy":["Reference","Output Signals","High Angle - 10"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1855,"hasContent":true,"hierarchy":["Reference","Output Signals","High Angle - 10"],"content":"  I\/O Expander: TRUE"},{"id":"15138213131","fileName":"15138213131.html","title":"High Torque - 7","level":3,"position":1856,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Torque result is higher than maximum torque limit.  Name in SoftPLC: HIGH_TORQUE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1857,"hasContent":true,"hierarchy":["Reference","Output Signals","High Torque - 7"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1858,"hasContent":true,"hierarchy":["Reference","Output Signals","High Torque - 7"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1859,"hasContent":true,"hierarchy":["Reference","Output Signals","High Torque - 7"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1860,"hasContent":true,"hierarchy":["Reference","Output Signals","High Torque - 7"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1861,"hasContent":true,"hierarchy":["Reference","Output Signals","High Torque - 7"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1862,"hasContent":true,"hierarchy":["Reference","Output Signals","High Torque - 7"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1863,"hasContent":true,"hierarchy":["Reference","Output Signals","High Torque - 7"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1864,"hasContent":true,"hierarchy":["Reference","Output Signals","High Torque - 7"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1865,"hasContent":true,"hierarchy":["Reference","Output Signals","High Torque - 7"],"content":"  I\/O Expander: TRUE"},{"id":"15138234251","fileName":"15138234251.html","title":"Identifier Received - 100","level":3,"position":1866,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":"  Name in SoftPLC: IDENTIFIER_RECEIVED      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1867,"hasContent":true,"hierarchy":["Reference","Output Signals","Identifier Received - 100"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1868,"hasContent":true,"hierarchy":["Reference","Output Signals","Identifier Received - 100"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1869,"hasContent":true,"hierarchy":["Reference","Output Signals","Identifier Received - 100"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1870,"hasContent":true,"hierarchy":["Reference","Output Signals","Identifier Received - 100"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1871,"hasContent":true,"hierarchy":["Reference","Output Signals","Identifier Received - 100"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1872,"hasContent":true,"hierarchy":["Reference","Output Signals","Identifier Received - 100"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1873,"hasContent":true,"hierarchy":["Reference","Output Signals","Identifier Received - 100"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1874,"hasContent":true,"hierarchy":["Reference","Output Signals","Identifier Received - 100"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1875,"hasContent":true,"hierarchy":["Reference","Output Signals","Identifier Received - 100"],"content":"  I\/O Expander: TRUE"},{"id":"15228962187","fileName":"15228962187.html","title":"Last Received Identifier String - 187","level":3,"position":1876,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Set directly when an identifier has been received in the work-task. For Source batch-string, it is set at every scanning in scan process, thus it is changed for every scanning and sent even if it does not match in length. String set is in raw format and not only \"saved positions\" in the string. For other work-tasks this signal is equal to Active Identifier String signal.  Name in SoftPLC: LAST_RECEIVED_ID_STRING      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  String  8  800   IdentifierU32Hnw  State  String  8  800   IdentifierU32  State  String  8  800   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1877,"hasContent":true,"hierarchy":["Reference","Output Signals","Last Received Identifier String - 187"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":1878,"hasContent":true,"hierarchy":["Reference","Output Signals","Last Received Identifier String - 187"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":1879,"hasContent":true,"hierarchy":["Reference","Output Signals","Last Received Identifier String - 187"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":1880,"hasContent":true,"hierarchy":["Reference","Output Signals","Last Received Identifier String - 187"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":1881,"hasContent":true,"hierarchy":["Reference","Output Signals","Last Received Identifier String - 187"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1882,"hasContent":true,"hierarchy":["Reference","Output Signals","Last Received Identifier String - 187"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title":"Stacklight","level":4,"position":1883,"hasContent":true,"hierarchy":["Reference","Output Signals","Last Received Identifier String - 187"],"content":" Stacklight: FALSE"},{"id":"18182373643","fileName":"18182373643.html","title":"TLS Tag","level":4,"position":1884,"hasContent":true,"hierarchy":["Reference","Output Signals","Last Received Identifier String - 187"],"content":" TLS Tag: FALSE"},{"id":"18182390283","fileName":"18182390283.html","title":"I\/O Expander","level":4,"position":1885,"hasContent":true,"hierarchy":["Reference","Output Signals","Last Received Identifier String - 187"],"content":" I\/O Expander: FALSE"},{"id":"15228983307","fileName":"15228983307.html","title":"License Server Connection Lost - 134","level":3,"position":1886,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Indicates that the connection to the Atlas Copco license server has been lost or the synchronization has failed. The signal is cleared when the License manager synchronization has been done successfully  Name in SoftPLC: LICENSE_SERVER_CONN_LOST      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1887,"hasContent":true,"hierarchy":["Reference","Output Signals","License Server Connection Lost - 134"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1888,"hasContent":true,"hierarchy":["Reference","Output Signals","License Server Connection Lost - 134"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1889,"hasContent":true,"hierarchy":["Reference","Output Signals","License Server Connection Lost - 134"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1890,"hasContent":true,"hierarchy":["Reference","Output Signals","License Server Connection Lost - 134"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1891,"hasContent":true,"hierarchy":["Reference","Output Signals","License Server Connection Lost - 134"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1892,"hasContent":true,"hierarchy":["Reference","Output Signals","License Server Connection Lost - 134"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1893,"hasContent":true,"hierarchy":["Reference","Output Signals","License Server Connection Lost - 134"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1894,"hasContent":true,"hierarchy":["Reference","Output Signals","License Server Connection Lost - 134"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1895,"hasContent":true,"hierarchy":["Reference","Output Signals","License Server Connection Lost - 134"],"content":"  I\/O Expander: TRUE"},{"id":"15229004427","fileName":"15229004427.html","title":"Loosening Disabled - 184","level":3,"position":1896,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":"  Loosening Disabled is an output signal which is activated when the loosening is externally locked by any of the following signals:  20003 - Lock Loosening  20004 - Lock Tool Active High  20033 - Line Control Lock  20018 - Open Protocol Lock  20021 - Fieldbus Lock Loosening  20041 - Soft PLC Lock Loosening  20061 - Lock Tool Active Low  Name in SoftPLC: LOOSENING_DISABLED      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1897,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening Disabled - 184"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1898,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening Disabled - 184"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1899,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening Disabled - 184"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1900,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening Disabled - 184"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1901,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening Disabled - 184"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1902,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening Disabled - 184"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1903,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening Disabled - 184"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1904,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening Disabled - 184"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1905,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening Disabled - 184"],"content":"  I\/O Expander: TRUE"},{"id":"15229025547","fileName":"15229025547.html","title":"Loosening Enabled - 185","level":3,"position":1906,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":"  Loosening Disabled is an output signal which is activated when the loosening is not externally locked by any of the following signals:  20003 - Lock Loosening  20004 - Lock Tool Active High  20033 - Line Control Lock  20018 - Open Protocol Lock  20021 - Fieldbus Lock Loosening  20041 - Soft PLC Lock Loosening  20061 - Lock Tool Active Low  Name in SoftPLC: LOOSENING_ENABLED      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1907,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening Enabled - 185"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1908,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening Enabled - 185"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1909,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening Enabled - 185"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1910,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening Enabled - 185"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1911,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening Enabled - 185"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1912,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening Enabled - 185"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1913,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening Enabled - 185"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1914,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening Enabled - 185"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1915,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening Enabled - 185"],"content":"  I\/O Expander: TRUE"},{"id":"15229046667","fileName":"15229046667.html","title":"Loosening is Locked - 28","level":3,"position":1916,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" The loosening is disabled.  Name in SoftPLC: LOOSENING_IS_LOCKED      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1917,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening is Locked - 28"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1918,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening is Locked - 28"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1919,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening is Locked - 28"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1920,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening is Locked - 28"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1921,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening is Locked - 28"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1922,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening is Locked - 28"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1923,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening is Locked - 28"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1924,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening is Locked - 28"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1925,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening is Locked - 28"],"content":"  I\/O Expander: TRUE"},{"id":"15229067787","fileName":"15229067787.html","title":"Loosening NOK - 74","level":3,"position":1926,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" NOK loosening took place.  Name in SoftPLC: LOOSENING_NOK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1927,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening NOK - 74"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1928,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening NOK - 74"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1929,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening NOK - 74"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1930,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening NOK - 74"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1931,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening NOK - 74"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1932,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening NOK - 74"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1933,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening NOK - 74"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1934,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening NOK - 74"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1935,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening NOK - 74"],"content":"  I\/O Expander: TRUE"},{"id":"15225623563","fileName":"15225623563.html","title":"Loosening OK - 70","level":3,"position":1936,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" OK loosening took place.  Name in SoftPLC: LOOSENING_OK      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1937,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening OK - 70"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1938,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening OK - 70"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1939,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening OK - 70"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1940,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening OK - 70"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1941,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening OK - 70"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1942,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening OK - 70"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1943,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening OK - 70"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1944,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening OK - 70"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1945,"hasContent":true,"hierarchy":["Reference","Output Signals","Loosening OK - 70"],"content":"  I\/O Expander: TRUE"},{"id":"15226816395","fileName":"15226816395.html","title":"Low Angle - 9","level":3,"position":1946,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Angle result is lower than minimum angle limit.  Name in SoftPLC: LOW_ANGLE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1947,"hasContent":true,"hierarchy":["Reference","Output Signals","Low Angle - 9"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1948,"hasContent":true,"hierarchy":["Reference","Output Signals","Low Angle - 9"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1949,"hasContent":true,"hierarchy":["Reference","Output Signals","Low Angle - 9"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1950,"hasContent":true,"hierarchy":["Reference","Output Signals","Low Angle - 9"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1951,"hasContent":true,"hierarchy":["Reference","Output Signals","Low Angle - 9"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1952,"hasContent":true,"hierarchy":["Reference","Output Signals","Low Angle - 9"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1953,"hasContent":true,"hierarchy":["Reference","Output Signals","Low Angle - 9"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1954,"hasContent":true,"hierarchy":["Reference","Output Signals","Low Angle - 9"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1955,"hasContent":true,"hierarchy":["Reference","Output Signals","Low Angle - 9"],"content":"  I\/O Expander: TRUE"},{"id":"15226904203","fileName":"15226904203.html","title":"Low Torque - 6","level":3,"position":1956,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Torque result is lower than minimum torque limit.  Name in SoftPLC: LOW_TORQUE      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1957,"hasContent":true,"hierarchy":["Reference","Output Signals","Low Torque - 6"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1958,"hasContent":true,"hierarchy":["Reference","Output Signals","Low Torque - 6"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1959,"hasContent":true,"hierarchy":["Reference","Output Signals","Low Torque - 6"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1960,"hasContent":true,"hierarchy":["Reference","Output Signals","Low Torque - 6"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1961,"hasContent":true,"hierarchy":["Reference","Output Signals","Low Torque - 6"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1962,"hasContent":true,"hierarchy":["Reference","Output Signals","Low Torque - 6"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1963,"hasContent":true,"hierarchy":["Reference","Output Signals","Low Torque - 6"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1964,"hasContent":true,"hierarchy":["Reference","Output Signals","Low Torque - 6"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1965,"hasContent":true,"hierarchy":["Reference","Output Signals","Low Torque - 6"],"content":"  I\/O Expander: TRUE"},{"id":"15226928011","fileName":"15226928011.html","title":"Manual Mode - 101","level":3,"position":1966,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Indicates on any supported and configured accessory the Virtual Station status for manual mode  Name in SoftPLC: MANUAL_MODE      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1967,"hasContent":true,"hierarchy":["Reference","Output Signals","Manual Mode - 101"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1968,"hasContent":true,"hierarchy":["Reference","Output Signals","Manual Mode - 101"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1969,"hasContent":true,"hierarchy":["Reference","Output Signals","Manual Mode - 101"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1970,"hasContent":true,"hierarchy":["Reference","Output Signals","Manual Mode - 101"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1971,"hasContent":true,"hierarchy":["Reference","Output Signals","Manual Mode - 101"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1972,"hasContent":true,"hierarchy":["Reference","Output Signals","Manual Mode - 101"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1973,"hasContent":true,"hierarchy":["Reference","Output Signals","Manual Mode - 101"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1974,"hasContent":true,"hierarchy":["Reference","Output Signals","Manual Mode - 101"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1975,"hasContent":true,"hierarchy":["Reference","Output Signals","Manual Mode - 101"],"content":"  I\/O Expander: TRUE"},{"id":"15226951819","fileName":"15226951819.html","title":"Max Consecutive NOK Reached - 35","level":3,"position":1976,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Indicates Max coherent NOK tightening counter is reachead.  Name in SoftPLC: MAX_COHERENT_NOK_REACHED      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1977,"hasContent":true,"hierarchy":["Reference","Output Signals","Max Consecutive NOK Reached - 35"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1978,"hasContent":true,"hierarchy":["Reference","Output Signals","Max Consecutive NOK Reached - 35"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1979,"hasContent":true,"hierarchy":["Reference","Output Signals","Max Consecutive NOK Reached - 35"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1980,"hasContent":true,"hierarchy":["Reference","Output Signals","Max Consecutive NOK Reached - 35"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1981,"hasContent":true,"hierarchy":["Reference","Output Signals","Max Consecutive NOK Reached - 35"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1982,"hasContent":true,"hierarchy":["Reference","Output Signals","Max Consecutive NOK Reached - 35"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1983,"hasContent":true,"hierarchy":["Reference","Output Signals","Max Consecutive NOK Reached - 35"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1984,"hasContent":true,"hierarchy":["Reference","Output Signals","Max Consecutive NOK Reached - 35"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1985,"hasContent":true,"hierarchy":["Reference","Output Signals","Max Consecutive NOK Reached - 35"],"content":"  I\/O Expander: TRUE"},{"id":"15226975627","fileName":"15226975627.html","title":"Open End in Open Position - 89","level":3,"position":1986,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Open End tool in open position.  Name in SoftPLC: OPEN_END_IN_OPEN_POSITION      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    State  Boolean  1  1   Filedbus: FALSE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181937163","fileName":"18181937163.html","title":"Fieldbus","level":4,"position":1987,"hasContent":true,"hierarchy":["Reference","Output Signals","Open End in Open Position - 89"],"content":" Filedbus: FALSE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1988,"hasContent":true,"hierarchy":["Reference","Output Signals","Open End in Open Position - 89"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1989,"hasContent":true,"hierarchy":["Reference","Output Signals","Open End in Open Position - 89"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":1990,"hasContent":true,"hierarchy":["Reference","Output Signals","Open End in Open Position - 89"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":1991,"hasContent":true,"hierarchy":["Reference","Output Signals","Open End in Open Position - 89"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":1992,"hasContent":true,"hierarchy":["Reference","Output Signals","Open End in Open Position - 89"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":1993,"hasContent":true,"hierarchy":["Reference","Output Signals","Open End in Open Position - 89"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":1994,"hasContent":true,"hierarchy":["Reference","Output Signals","Open End in Open Position - 89"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":1995,"hasContent":true,"hierarchy":["Reference","Output Signals","Open End in Open Position - 89"],"content":"  I\/O Expander: TRUE"},{"id":"15226999435","fileName":"15226999435.html","title":"Open Protocol Disconnected - 95","level":3,"position":1996,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" If Open Protocol is set to off in the Virtual Station, \"Open Protocol Disconnected\" signal is set to False. If Open Protocol is turned on in the Virtual Station the \"Open Protocol Disconnected\" signal is set to True. When at least one client (several Open Protocol clients can connect to the same Virtual Station) is connected the \"Open Protocol Disconnected\" signal is set to False.  Name in SoftPLC: OPEN_PROTOCOL_DISCONNECTED      Converter  Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Standard  State  Boolean  1  1   Invert  State  Boolean  1  1   To avoid duplicating signals, it is possible to define Value Converters. Converters are used to support more than one representation of the same signal (for example Angle\/Torque Status can both be represented bitwise or as a status character).   Fieldbus: TRUE  Indicator Box: TRUE  Internal I\/O: TRUE   Operator Panel: TRUE  Tool Functions: TRUE  ST Selector: FALSE   Stacklight: TRUE  TLS Tag: TRUE   I\/O Expander: TRUE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":1997,"hasContent":true,"hierarchy":["Reference","Output Signals","Open Protocol Disconnected - 95"],"content":" Fieldbus: TRUE"},{"id":"18182348683","fileName":"18182348683.html","title":"Indicator Box","level":4,"position":1998,"hasContent":true,"hierarchy":["Reference","Output Signals","Open Protocol Disconnected - 95"],"content":" Indicator Box: TRUE"},{"id":"18182352523","fileName":"18182352523.html","title":"Internal I\/O","level":4,"position":1999,"hasContent":true,"hierarchy":["Reference","Output Signals","Open Protocol Disconnected - 95"],"content":" Internal I\/O: TRUE"},{"id":"18182356363","fileName":"18182356363.html","title":"Operator Panel","level":4,"position":2000,"hasContent":true,"hierarchy":["Reference","Output Signals","Open Protocol Disconnected - 95"],"content":"  Operator Panel: TRUE"},{"id":"18182360203","fileName":"18182360203.html","title":"Tool Functions","level":4,"position":2001,"hasContent":true,"hierarchy":["Reference","Output Signals","Open Protocol Disconnected - 95"],"content":" Tool Functions: TRUE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":2002,"hasContent":true,"hierarchy":["Reference","Output Signals","Open Protocol Disconnected - 95"],"content":" ST Selector: FALSE"},{"id":"18182367883","fileName":"18182367883.html","title":"Stacklight","level":4,"position":2003,"hasContent":true,"hierarchy":["Reference","Output Signals","Open Protocol Disconnected - 95"],"content":"  Stacklight: TRUE"},{"id":"18182371723","fileName":"18182371723.html","title":"TLS Tag","level":4,"position":2004,"hasContent":true,"hierarchy":["Reference","Output Signals","Open Protocol Disconnected - 95"],"content":" TLS Tag: TRUE"},{"id":"18182388363","fileName":"18182388363.html","title":"I\/O Expander","level":4,"position":2005,"hasContent":true,"hierarchy":["Reference","Output Signals","Open Protocol Disconnected - 95"],"content":"  I\/O Expander: TRUE"},{"id":"15227023243","fileName":"15227023243.html","title":"Pass-Through Identifier - 104","level":3,"position":2006,"hasContent":true,"hierarchy":["Reference","Output Signals"],"content":" Output signal for sending a scanned string from a scanner to an external device.  Name in SoftPLC: BARCODE_ID_PASSTHROUGH      Signal Type  Value Type  Size Min [bit]  Size Max [bit]    Event  String  8  800   Fieldbus: TRUE  Indicator Box: FALSE  Internal I\/O: FALSE  Operator Panel: FALSE  Tool Functions: FALSE  ST Selector: FALSE  Stacklight: FALSE  TLS Tag: FALSE  I\/O Expander: FALSE"},{"id":"18181934859","fileName":"18181934859.html","title":"Fieldbus","level":4,"position":2007,"hasContent":true,"hierarchy":["Reference","Output Signals","Pass-Through Identifier - 104"],"content":" Fieldbus: TRUE"},{"id":"18182350603","fileName":"18182350603.html","title":"Indicator Box","level":4,"position":2008,"hasContent":true,"hierarchy":["Reference","Output Signals","Pass-Through Identifier - 104"],"content":" Indicator Box: FALSE"},{"id":"18182354443","fileName":"18182354443.html","title":"Internal I\/O","level":4,"position":2009,"hasContent":true,"hierarchy":["Reference","Output Signals","Pass-Through Identifier - 104"],"content":" Internal I\/O: FALSE"},{"id":"18182358283","fileName":"18182358283.html","title":"Operator Panel","level":4,"position":2010,"hasContent":true,"hierarchy":["Reference","Output Signals","Pass-Through Identifier - 104"],"content":" Operator Panel: FALSE"},{"id":"18182362123","fileName":"18182362123.html","title":"Tool Functions","level":4,"position":2011,"hasContent":true,"hierarchy":["Reference","Output Signals","Pass-Through Identifier - 104"],"content":" Tool Functions: FALSE"},{"id":"18182365963","fileName":"18182365963.html","title":"ST Selector","level":4,"position":2012,"hasContent":true,"hierarchy":["Reference","Output Signals","Pass-Through Identifier - 104"],"content":" ST Selector: FALSE"},{"id":"18182369803","fileName":"18182369803.html","title"