﻿function getRedirectParameter(parameterName) {
	var items = location.search.substr(1).split("&");
	for (var i = 0; i < items.length; i++) {
		var current = items[i].split("=");
		if (current[0] == parameterName) return decodeURIComponent(current[1]);
	}
	return null;
}

function getRedirectTarget(language) {
	if (Object.keys(redirectTargets).length == 1) {
		language = Object.keys(redirectTargets)[0];
	}
	
	var targets = redirectTargets[language];
	if (targets) {
		var topic = getRedirectParameter("topic");
		return targets[topic] || targets["*"];
	}
	
	return null;
}

var language = getRedirectParameter("language");
var url = getRedirectTarget(language);
if (url) {
	window.location.replace(url);
}
else {
	document.addEventListener("DOMContentLoaded", function() {
		var languageLinks = document.getElementsByClassName("language-link");
		for (var i = 0; i < languageLinks.length; i++) {
			languageLinks[i].onclick = function(event) {
				var selectedLanguage = event.target.getAttribute("data-language");
				var url = getRedirectTarget(selectedLanguage);
				window.location.assign(url);
				event.preventDefault();
			}
		}
	})
}