﻿$(function () {
    if (tableData.type === 'master-detail') {
        createMasterDetailTable()
    }
    else {
        createStandardTable()
    }
})

function createMasterDetailTable() {
    var lookup = {}
    var allGeneratedColumns = []
    var columnProperty = tableData.columns.find(function (x) { return x.type === "column" })
    var rowProperties = tableData.columns.filter(function (x) { return x.type === "item" });

    $.each(tableData.items, function (index, item) {
        if (!lookup[item.id]) {
            lookup[item.id] = { id: item.id, title: item.title, generatedColumns: [], defaultContent: "" }
        }

        var columnName = item[columnProperty.data][0]

        if (allGeneratedColumns.indexOf(columnName) === -1) {
            allGeneratedColumns.push(columnName)
        }

        var generatedColumn = {
            rows: []
        }
        $.each(rowProperties, function (i, prop) {
            generatedColumn.rows.push(item[prop.data])

            generatedColumn[prop.data] = [];
            $.each(item[prop.data], function (i, x) {
                generatedColumn[prop.data].push(x)
            })
        })

        lookup[item.id][columnName] = generatedColumn

        lookup[item.id].generatedColumns.push(columnName)
    })

    var items = []
    for (var prop in lookup) {
        var item = lookup[prop]
        items.push(item)
    }

    var columns = []
    $.each(tableData.columns, function (i1, column) {
        if (column.type === "title") {
            columns.push(column)

            $.each(allGeneratedColumns, function (i2, generatedColumn) {
                columns.push({ name: generatedColumn, data: generatedColumn + '.rows', type: "generated", title: generatedColumn })
            })
        }
    })

    var table = createTable(columns, items)

    $('#datatable').addClass('master-detail')

    createMasterDetailFilters(table, tableData.columns, items)

    setTimeout(resizeRows, 500)

    table.on('draw', resizeRows)
    table.on('column-visibility', resizeRows)

    function resizeRows() {
        $('#datatable>tbody>tr').each(function () {
            $(this).find(".inner-table").each(function () {
                $(this).find("tr").each(function (i) {
                    this.style.height = ''
                })
            })

            var maxHeights = []
            $(this).find(".inner-table").each(function () {
                $(this).find("tr").each(function (i) {
                    if (!maxHeights[i] || maxHeights[1] < this.clientHeight) {
                        maxHeights[i] = this.clientHeight
                    }
                })
            })

            $(this).find(".inner-table").each(function () {
                $(this).find("tr").each(function (i) {
                    this.style.height = '' + maxHeights[i] + 'px'
                })
            })
        })
    }
}

function createStandardTable() {
    var table = createTable(tableData.columns, tableData.items)

    createStandardFilters(table, tableData.columns, tableData.items)
}

function createTable(columns, items) {
    var table = $('#datatable').DataTable({
        autoWidth: false,
        paging: false,
        data: items,
        columns: columns.map(function (c) {
            if (c.name === "title") {
                c.fnCreatedCell = function (nTd, sData, oData, iRow, iCol) {
                    $(nTd).html('<a href="' + oData.id + '.html">' + sData + '</a>')
                    $(nTd).addClass("title-column")
                }
            }
            else if (c.type === "generated") {
                c.fnCreatedCell = function (nTd, sData, oData, iRow, iCol) {
                    $(nTd).html("<table class='inner-table'>" + oData[c.name].rows.map(createRow).join("") + "</table>")
                    $(nTd).addClass("generated-cell")
                }
            }

            return c
        }),
    })

    table.on( 'draw', function () {
        var body = $( table.table().body() )
 
        body.unhighlight()

        if ( table.rows( { filter: 'applied' } ).data().length ) {
            body.highlight( table.search() )
        
            for (var key in filterTerms) {
                body.highlight(filterTerms[key])
            }
        }
    })

    return table

    function createRow(r) {
        return "<tr><td>" + r.join(", ") + "</td></tr>"
    }
}
