﻿var legendHighlightClass = "hotspot-highlight";
var svgHightlightClass = "highlight";
var linkMap = new Map();

$("[data-insert-svg]").each(function( index ) {
	var list = $(this).attr("data-link-list");
	var linkList = list.split(String.fromCharCode(0xE027));
	linkList.forEach(function(link)	{
		var s = link.split(String.fromCharCode(0xE028));
		linkMap.set(s[0], link);
	});
	
	var hotspotId = $(this).attr("data-hotspot-id");
	$(this).after(omd.svgImages[$(this).attr("data-insert-svg")]);
	var svg = $(this).next();
	svg.attr('data-hotspot-id', hotspotId);
    $(this).remove();
});

$("svg").each(function( index ) {
	var svg = Snap(this);
	
	var elements = svg.selectAll("a");
	if(!elements || !elements.length)
		return;
	
	$(this).parent().addClass('hotspot-container');
  	
	elements.forEach(function(element) {
	  	if(element.node.hasAttribute('data-target')) {
			var target = element.node.getAttribute('data-target');
			var link = linkMap.get(target);
			if(link) {
				var linkElements = link.split(String.fromCharCode(0xE028));
				element.node.setAttribute('title', linkElements[2]);
				element.node.setAttribute('data-content', linkElements[3]);
				element.node.setAttribute('data-toggle', 'popover');
				element.node.setAttribute('data-trigger', 'focus');
				element.node.setAttribute('tabindex', '-1');
				element.node.setAttribute('data-html', 'true');
				element.addClass('svg-link')
			}
		}
		else {
			var href = element.attr('xlink:href');
			if (href.indexOf('shortlink:') == 0) {
				var linkElements = href.split(':');
				var project = linkElements[1];
				var page = linkElements.length > 2 ?
					'redirect/' + linkElements[2] + ".html" :
					'index.html';
				var lang = $('body').attr('lang');
				var newHref = shortlinkBaseUrl + '/' + project + '/' + page + '?language=' + lang;

				element.attr({'xlink:href':newHref});
			}
			
			element.node.setAttribute('target', '_blank');
		}
  	});
});

$(function () {    
    
    // activate popupovers for hotspot links
    var popoverOptions = {
        container: "body",
        placement: "bottom",
        delay: {
            show: 200,
            hide: 100
        }
    };

    $('.svg-link').popover(popoverOptions);


});


$("svg").each(function( index ) {
    var svg = Snap(this);
	
	var tableLegend = $('table[data-legend-id=' + $(this).attr('data-hotspot-id')  + ']');
	if (tableLegend && tableLegend.length)
		tableLegend.addClass('print-only');

	var elements = svg.selectAll("[hotspotid]");
	if(!elements)
    return;
    
  $(this).parent().addClass('hotspot-container');
  	
	elements.forEach(function(element) {
		var text = findTableEntryForSvgElement(element).next().html();
		if (text && text.length) {
			element.node.setAttribute('data-content', "<div>" + text + "</div>");
			element.node.setAttribute('data-toggle', 'popover');
			element.node.setAttribute('data-html', 'true');
			element.addClass('svg-legend')
		}
	});
	
	var popoverOptions = {
        container: "body",
        placement: "bottom",
        trigger: "hover",
        delay: {
            show: 200,
            hide: 100
        }
    };
	
	$('.svg-legend').popover(popoverOptions);
	
    tableLegend.on("mouseenter", "td:nth-child(odd)", function() {
        setFocus(findSvgElementFromLegendTable($(this)));
        highlightTableEntries($(this));
    });

    tableLegend.on("mouseleave", "td:nth-child(odd)", function() {
        leaveFocus(findSvgElementFromLegendTable($(this)));
        unhighlightTableEntries($(this));
    });

    tableLegend.on("mouseenter", "td:nth-child(even)", function() {
        setFocus(findSvgElementFromLegendTable($(this).prev()));
        highlightTableEntries($(this).prev());
    });
    tableLegend.on("mouseleave", "td:nth-child(even)", function() {
        leaveFocus(findSvgElementFromLegendTable($(this).prev()));
        unhighlightTableEntries($(this).prev());
    });

    $(this).on("mouseenter", "[hotspotid]", function() {
        setFocus(findMatchingSvgElements($(this)));
        highlightTableEntries(findTableEntryForSvgElement($(this)));
    });

    $(this).on("mouseleave", "[hotspotid]", function() {
        leaveFocus(findMatchingSvgElements($(this)));
        unhighlightTableEntries(findTableEntryForSvgElement($(this)));
    });

    function findSvgElementFromLegendTable(leftTableEntry) {
        var ref = leftTableEntry.children()[0].innerHTML;
        return svg.selectAll("*[hotspotid=\"" + ref + "\"]");
    }

    function findMatchingSvgElements(domElement) {
        var ref = domElement.attr("hotspotid");
        return svg.selectAll("*[hotspotid=\"" + ref + "\"]");
    }

    function findTableEntryForSvgElement(domElement) {
        var ref = domElement.attr("hotspotid");
        var entry = tableLegend.find("td:nth-child(odd)").filter(function() {
            return $(this).find("p").text() == ref;
        });
        return entry.first();
    }
});


function setFocus(svgElements) {
  if(!svgElements)
    return;
  svgElements.forEach(function(element) {
    element.addClass(svgHightlightClass);
  });
}

function leaveFocus(svgElements) {
  if(!svgElements)
    return;
  svgElements.forEach(function(element) {
    element.removeClass(svgHightlightClass);
  });
}

function highlightTableEntries(leftTableEntry) {
  if(!leftTableEntry)
    return;
  leftTableEntry.addClass(legendHighlightClass);
  leftTableEntry.next().addClass(legendHighlightClass);
}

function unhighlightTableEntries(leftTableEntry) {
  if(!leftTableEntry)
    return;
  leftTableEntry.removeClass(legendHighlightClass);
  leftTableEntry.next().removeClass(legendHighlightClass);
}

$(window).load(function() {
    if(navigator.userAgent === 'ie' || navigator.userAgent.indexOf('MSIE ') > 0 || navigator.userAgent.match(/Trident.*rv:11\./)) {
        $('body').addClass('ie');
    }
});